//=============================================================================
// VisuStella MZ - Battle Core
// VisuMZ_1_BattleCore.js
//=============================================================================

var Imported = Imported || {};
Imported.VisuMZ_1_BattleCore = true;

var VisuMZ = VisuMZ || {};
VisuMZ.BattleCore = VisuMZ.BattleCore || {};
VisuMZ.BattleCore.version = 1.48;

//=============================================================================
 /*:
 * @target MZ
 * @plugindesc [RPG Maker MZ] [Tier 1] [Version 1.48] [BattleCore]
 * @author VisuStella
 * @url http://www.yanfly.moe/wiki/Battle_Core_VisuStella_MZ
 * @orderAfter VisuMZ_0_CoreEngine
 *
 * @help
 * ============================================================================
 * Introduction
 * ============================================================================
 *
 * The Battle Core plugin revamps the battle engine provided by RPG Maker MZ to
 * become more flexible, streamlined, and support a variety of features. The
 * updated battle engine allows for custom Action Sequences, battle layout
 * styles, and a lot of control over the battle mechanics, too.
 *
 * Features include all (but not limited to) the following:
 * 
 * * Action Sequence Plugin Commands to give you full control over what happens
 *   during the course of a skill or item.
 * * Animated Sideview Battler support for enemies!
 * * Auto Battle options for party-wide and actor-only instances.
 * * Base Troop Events to quickly streamline events for all Troop events.
 * * Battle Command control to let you change which commands appear for actors.
 * * Battle Layout styles to change the way the battle scene looks.
 * * Casting animation support for skills.
 * * Critical Hit control over the success rate formula and damage multipliers.
 * * Custom target scopes added for skills and items.
 * * Damage formula control, including Damage Styles.
 * * Damage caps, both hard caps and soft caps.
 * * Damage traits such Armor Penetration/Reduction to bypass defenses.
 * * Elements & Status Menu Core support for traits.
 * * Multitude of JavaScript notetags and global Plugin Parameters to let you
 *   make a variety of effects across various instances during battle.
 * * Party Command window can be skipped/disabled entirely.
 * * Weather effects now show in battle.
 * * Streamlined Battle Log to remove redundant information and improve the
 *   flow of battle.
 * * Visual HP Gauges can be displayed above the heads of actors and/or enemies
 *   with a possible requirement for enemies to be defeated at least once first
 *   in order for them to show.
 *
 * ============================================================================
 * Requirements
 * ============================================================================
 *
 * This plugin is made for RPG Maker MZ. This will not work in other iterations
 * of RPG Maker.
 *
 * ------ Tier 1 ------
 *
 * This plugin is a Tier 1 plugin. Place it under other plugins of lower tier
 * value on your Plugin Manager list (ie: 0, 1, 2, 3, 4, 5). This is to ensure
 * that your plugins will have the best compatibility with the rest of the
 * VisuStella MZ library.
 *
 * ============================================================================
 * Major Changes
 * ============================================================================
 *
 * This plugin will overwrite some core parts of the RPG Maker MZ base code in
 * order to ensure the Battle Core plugin will work at full capacity. The
 * following are explanations of what has been changed.
 *
 * ---
 *
 * Action Sequences
 *
 * - Action sequences are now done either entirely by the Battle Log Window or
 * through common events if the <Custom Action Sequence> notetag is used.
 * In RPG Maker MZ by default, Action Sequences would be a mixture of using the
 * Battle Log Window, the Battle Manager, and the Battle Scene, making it hard
 * to fully grab control of the situation.
 *
 * ---
 *
 * Action Speed
 *
 * - Action speeds determine the turn order in the default battle system. The
 * AGI of a battle unit is also taken into consideration. However, the random
 * variance applied to the action speed system makes the turn order extremely
 * chaotic and hard for the player to determine. Thus, the random variance
 * aspect of it has been turned off. This can be reenabled by default through
 * Plugin Parameters => Mechanics Settings => Allow Random Speed?
 *
 * ---
 *
 * Animated Sideview Battler Support For Enemies
 *
 * - Enemies can now use Sideview Actor sprites for themselves! They will
 * behave like actors and can even carry their own set of weapons for physical
 * attacks. These must be set up using notetags. More information can be found
 * in the notetag section.
 *
 * - As the sprites are normally used for actors, some changes have been made
 * to Sprite_Actor to be able to support both actors and enemies. These changes
 * should have minimal impact on other plugins.
 *
 * ---
 *
 * Battle Sprite Updates
 *
 * - A lot of functions in Sprite_Battler, Sprite_Actor, and Sprite_Enemy have
 * been overwritten to make the new Action Sequence system added by this plugin
 * possible. These changes make it possible for the sprites to move anywhere on
 * the screen, jump, float, change visibility, and more.
 *
 * ---
 *
 * Change Battle Back in Battle
 * 
 * - By default, the Change Battle Back event command does not work in battle.
 * Any settings made to it will only reflect in the following battle. Now, if
 * the battle back event command is used during battle, it will reflect upon
 * any new changes immediately.
 *
 * ---
 *
 * Critical Hit - LUK Influence
 *
 * - The LUK Buffs now affect the critical hit rate based off how the formula
 * is now calculated. Each stack of a LUK Buff will double the critical hit
 * rate and compound upon that. That means a x1 LUK Buff stack will raise it by
 * x2, a x2 LUK Buff stack will raise the critical hit rate by x4, a x3 LUK
 * Buff Stack will raise the critical hit rate stack by x8, and so on.
 *
 * - LUK also plays a role in how much damage is dealt with critical hits. The
 * default critical hit multiplier has been reduced from x3 to x2. However, a
 * percentage of LUK will added on (based off the user's CRI rate) onto the
 * finalized critical damage. If the user's CRI rate is 4%, then 4% of the user
 * LUK value will also be added onto the damage.
 *
 * - This change can be altered through Plugin Parameters => Damage Settings =>
 * Critical Hits => JS: Rate Formula and JS: Damage Formula.
 *
 * ---
 * 
 * Damage Popups
 * 
 * - Damage popups are now formatted with + and - to determine healing and
 * damage. MP Damage will also include "MP" at the back. This is to make it
 * clearer what each colored variant of the damage popup means as well as help
 * color blind players read the on-screen data properly.
 * 
 * - Damage popups have also been rewritten to show all changed aspects instead
 * of just one. Previously with RPG Maker MZ, if an action would deal both HP
 * and MP damage, only one of them would show. Now, everything is separated and
 * both HP and MP changes will at a time.
 * 
 * ---
 * 
 * Dual Wielding
 * 
 * - Previously, RPG Maker MZ had "Dual Wielding" attack using both weapon
 * animations at once, with the combined ATK of each weapon. It's confusing to
 * look at and does not portray the nature of "Dual Wielding".
 * 
 * - Dual Wielding, or in the case of users adding in third and fourth weapons,
 * Multi Wielding is now changed. Each weapon is displayed individually, each
 * producing its own attack animation, showing each weapon type, and applying
 * only that weapon's ATK, Traits, and related effects. It is no longer a
 * combined effect to display everything at once like RPG Maker MZ default.
 * 
 * - If an actor has multiple weapon slots but some of them are unequipped,
 * then the action will treat the attack as a single attack. There will be no
 * barehanded attack to add on top of it. This is to match RPG Maker MZ's
 * decision to omit a second animation if the same scenario is applied.
 * 
 * ---
 *
 * Force Action
 *
 * - Previously, Forced Actions would interrupt the middle of an event to
 * perform an action. However, with the addition of more flexible Action
 * Sequences, the pre-existing Force Action system would not be able to exist
 * and would require being remade.
 *
 * - Forced Actions now are instead, added to a separate queue from the action
 * battler list. Whenever an action and/or common event is completed, then if
 * there's a Forced Action battler queued, then the Forced Action battler will
 * have its turn. This is the cleanest method available and avoids the most
 * conflicts possible.
 *
 * - This means if you planned to make cinematic sequences with Forced Actions,
 * you will need to account for the queued Force Actions. However, in the case
 * of battle cinematics, we would highly recommend that you use the newly added
 * Action Sequence Plugin Commands instead as those give you more control than
 * any Force Action ever could.
 *
 * ---
 *
 * Random Scope
 *
 * - The skill and item targeting scopes for Random Enemy, 2 Random Enemies,
 * 3 Random Enemies, 4 Random Enemies will now ignore TGR and utilize true
 * randomness.
 *
 * ---
 *
 * Spriteset_Battle Update
 *
 * - The spriteset now has extra containers to separate battlers (actors and
 * enemies), animations, and damage. This is to make actors and enemy battler
 * sprites more efficient to sort (if enabled), so that animations won't
 * interfere with and cover damage sprites, and to make sure damage sprites are
 * unaffected by screen tints in order to ensure the player will always have a
 * clear read on the information relaying sprites.
 *
 * ---
 * 
 * TPB/ATB Active Battle Actor Shifting
 * 
 * - Pressing cancel on the Actor Command Window no longer switches between
 * actors with a full TPB/ATB gauge before reaching the Party Command Window.
 * This is to accomplish a couple of things: 1) reduce the number of button
 * presses to reach the Party Command Window and 2) to prevent motion resets
 * and disrupting action sequences. If this feature is vital to your battle
 * system, we recommend that you do not use this plugin or any of the Battle
 * Core-required plugins.
 * 
 * ---
 *
 * Weather Displayed in Battle
 *
 * - Previously, weather has not been displayed in battle. This means that any
 * weather effects placed on the map do not transfer over to battle and causes
 * a huge disconnect for players. The Battle Core plugin will add weather
 * effects to match the map's weather conditions. Any changes made to weather
 * through event commands midway through battle will also be reflected.
 *
 * ---
 *
 * ============================================================================
 * Base Troops
 * ============================================================================
 *
 * Base Troops can be found, declared, and modified in the Plugin Parameters =>
 * Mechanics Settings => Base Troop ID's. All of the listed Troop ID's here
 * will have their page events replicated and placed under all other troops
 * found in the database.
 *
 * ---
 *
 * This means that if you have an event that runs on Turn 1 of a Base Troop,
 * then for every troop out there, that same event will also run on Turn 1,
 * as well. This is useful for those who wish to customize their battle system
 * further and to reduce the amount of work needed to copy/paste said event
 * pages into every database troop object manually.
 *
 * ---
 *
 * ============================================================================
 * Damage Styles
 * ============================================================================
 *
 * Damage Styles are a new feature added through the Battle Core plugin. When
 * using certain Battle Styles, you can completely ignore typing in the whole
 * damage formula inside the damage formula input box, and instead, insert
 * either a power amount or a multiplier depending on the Damage Style. The
 * plugin will then automatically calculate damage using that value factoring
 * in ATK, DEF, MAT, MDF values.
 *
 * ---
 *
 * Here is a list of the Damage Styles that come with this plugin by default.
 * You can add in your own and even edit them to your liking.
 * Or just remove them if you want.
 *
 * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
 * Style          Use Formula As   PH/MA Disparity   Stat Scale   Damage Scale
 * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
 * Standard       Formula          No                Varies       Varies
 * ArmorScaling   Formula          No                Varies       Varies
 * CT             Multiplier       Yes               Low          Normal
 * D4             Multiplier       No                High         Normal
 * DQ             Multiplier       No                Low          Low
 * FF7            Power            Yes               Low          High
 * FF8            Power            Yes               Medium       Normal
 * FF9            Power            Yes               Low          Normal
 * FF10           Power            Yes               Medium       High
 * MK             Multiplier       No                Medium       Low
 * MOBA           Multiplier       No                Medium       Normal
 * PKMN           Power            No                Low          Normal
 *
 * Use the above chart to figure out which Damage Style best fits your game,
 * if you plan on using them.
 *
 * The 'Standard' style is the same as the 'Manual' formula input, except that
 * it allows for the support of <Armor Penetration> and <Armor Reduction>
 * notetags.
 *
 * The 'Armor Scaling' style allows you to type in the base damage calculation
 * without the need to type in any defending modifiers.
 *
 * NOTE: While these are based off the damage formulas found in other games,
 * not all of them are exact replicas. Many of them are adapted for use in
 * RPG Maker MZ since not all RPG's use the same set of parameters and not all
 * external multipliers function the same way as RPG Maker MZ.
 * 
 * ---
 *
 * Style:
 * - This is what the Damage Style is.
 *
 * Use Formula As:
 * - This is what you insert into the formula box.
 * - Formula: Type in the formula for the action just as you would normally.
 * - Multiplier: Type in the multiplier for the action.
 *     Use float values. This means 250% is typed out as 2.50
 * - Power: Type in the power constant for the action.
 *     Use whole numbers. Type in something like 16 for a power constant.
 * 
 * PH/MA Disparity:
 * - Is there a disparity between how Physical Attacks and Magical Attacks
 *   are calculated?
 * - If yes, then physical attacks and magical attacks will have different
 *   formulas used.
 * - If no, then physical attacks and magical attacks will share similar
 *   formulas for how they're calculated.
 *
 * Stat Scale:
 * - How much should stats scale throughout the game?
 * - Low: Keep them under 100 for the best results.
 * - Medium: Numbers work from low to mid 400's for best results.
 * - High: The numbers really shine once they're higher.
 *
 * Damage Scale:
 * - How much does damage vary depending on small parameter changes?
 * - Low: Very little increase from parameter changes.
 * - Normal: Damage scales close to proportionally with parameter changes.
 * - High: Damage can boost itself drastically with parameter changes.
 *
 * ---
 *
 * To determine what kind of parameters are used for the Damage Styles, they
 * will depend on two things: the action's 'Hit Type' (ie Physical Attack,
 * Magical Attack, and Certain Hit) and the action's 'Damage Type' (ie. Damage,
 * Recovery, or Drain).
 *
 * Certain Hit tends to use whichever value is higher: ATK or MAT, and then
 * ignores the target's defense values. Use Certain Hits for 'True Damage'.
 *
 * Use the chart below to figure out everything else:
 * 
 * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
 * Hit Type      Damage Type   Attacker Parameter   Defender Parameter
 * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
 * Physical      Damage        ATK                  DEF
 * Magical       Damage        MAT                  MDF
 * Certain Hit   Damage        Larger (ATK, MAT)    -Ignores-
 * Physical      Recover       DEF                  -Ignores-
 * Magical       Recover       MDF                  -Ignores-
 * Certain Hit   Recover       Larger (ATK, MAT)    -Ignores-
 * Physical      Drain         ATK                  DEF
 * Magical       Drain         MAT                  MDF
 * Certain Hit   Drain         Larger (ATK, MAT)    -Ignores-
 *
 * These can be modified within the Plugin Parameters in the individual
 * Damage Styles themselves.
 *
 * ---
 *
 * Skills and Items can use different Damage Styles from the setting you've
 * selected in the Plugin Parameters. They can be altered to have different
 * Damage Styles through the usage of a notetag:
 *
 * <Damage Style: name>
 *
 * This will use whichever style is found in the Plugin Parameters.
 *
 * If "Manual" is used, then no style will be used and all calculations will be
 * made strictly based off the formula found inside the formula box.
 *
 * ---
 *
 * ============================================================================
 * VisuStella MZ Compatibility
 * ============================================================================
 *
 * While this plugin is compatible with the majority of the VisuStella MZ
 * plugin library, it is not compatible with specific plugins or specific
 * features. This section will highlight the main plugins/features that will
 * not be compatible with this plugin or put focus on how the make certain
 * features compatible.
 *
 * ---
 * 
 * VisuMZ_1_BattleCore
 * 
 * When using Action Sequences, Boost effects for damage, turn extensions,
 * analyze, etc. will not occur for anything other than the Action Sequence:
 * "MECH: Action Effect" in order to maintain controlled effects. However, if
 * you do want to apply bonuses for Boosts, utilize "MECH: Boost Store Data" to
 * store inside a variable how many times Boosts were used. This can be used
 * however which way you want it to as long as it is manageable through events
 * and Common Events.
 * 
 * ---
 *
 * ============================================================================
 * Notetags
 * ============================================================================
 *
 * The following are notetags that have been added through this plugin. These
 * notetags will not work with your game if this plugin is OFF or not present.
 * 
 * === HP Gauge-Related Notetags ===
 * 
 * The following notetags allow you to set whether or not HP Gauges can be
 * displayed by enemies regardless of Plugin Parameter settings.
 * 
 * ---
 *
 * <Show HP Gauge>
 *
 * - Used for: Enemy Notetags
 * - Will always show the HP Gauge for the enemy regardless of the defeat
 *   requirement setting.
 * - This does not bypass the player's Options preferences.
 * - This does not bypass disabling enemy HP Gauges as a whole.
 * 
 * ---
 *
 * <Hide HP Gauge>
 *
 * - Used for: Enemy Notetags
 * - Will always hide the HP Gauge for the enemy regardless of the defeat
 *   requirement setting.
 * - This does not bypass the player's Options preferences.
 * 
 * ---
 * 
 * <Battle UI Offset: +x, +y>
 * <Battle UI Offset: -x, -y>
 * 
 * <Battle UI Offset X: +x>
 * <Battle UI Offset X: -x>
 * 
 * <Battle UI Offset Y: +y>
 * <Battle UI Offset Y: -y>
 * 
 * - Used for: Actor and Enemy Notetags
 * - Adjusts the offset of HP Gauges and State Icons above the heads of actors
 *   and enemies.
 * - Replace 'x' with a number value that offsets the x coordinate.
 * - Negative x values offset left. Positive x values offset right.
 * - Replace 'y' with a number value that offsets the y coordinate.
 * - Negative y values offset up. Positive x values offset down.
 * 
 * ---
 *
 * === Animation-Related Notetags ===
 *
 * The following notetags allow you to set animations to play at certain
 * instances and/or conditions.
 *
 * ---
 *
 * <Slip Animation: x>
 *
 * - Requires VisuMZ_0_CoreEngine!
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - During the phase at which the user regenerates HP, MP, or TP, this
 *   animation will play as long as the user is alive and visible.
 * - Replace 'x' with a number value representing the Animation ID to play.
 *
 * ---
 *
 * <Cast Animation: x>
 *
 * - Used for: Skill Notetags
 * - Plays a battle animation at the start of the skill.
 * - Replace 'x' with a number value representing the Animation ID to play.
 *
 * ---
 *
 * <Attack Animation: x>
 *
 * - Used for: Enemy Notetags
 * - Gives an enemy an attack animation to play for its basic attack.
 * - Replace 'x' with a number value representing the Animation ID to play.
 *
 * ---
 *
 * === Battleback-Related Notetags ===
 *
 * You can apply these notetags to have some control over the battlebacks that
 * appear in different regions of the map for random or touch encounters.
 *
 * ---
 *
 * <Region x Battleback1: filename>
 * <Region x Battleback2: filename>
 * 
 * - Used for: Map Notetags
 * - If the player starts a battle while standing on 'x' region, then the
 *   'filename' battleback will be used.
 * - Replace 'x' with a number representing the region ID you wish to use.
 * - Replace 'filename' with the filename of the graphic to use. Do not insert
 *   any extensions. This means the file 'Castle1.png' will be only inserted
 *   as 'Castle1' without the '.png' at the end.
 * - *NOTE: This will override any specified battleback settings.
 *
 * ---
 *
 * === Battle Command-Related Notetags ===
 *
 * You can use notetags to change how the battle commands of playable
 * characters appear in battle as well as whether or not they can be used.
 *
 * ---
 *
 * <Seal Attack>
 * <Seal Guard>
 * <Seal Item>
 *
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Prevents specific battle commands from being able to be used.
 *
 * ---
 *
 * <Battle Commands>
 *  Attack
 *  Skills
 *  SType: x
 *  SType: name
 *  All Skills
 *  Skill: x
 *  Skill: name
 *  Guard
 *  Item
 *  Party
 *  Escape
 *  Auto Battle
 *  Combat Log
 *  Talk
 *  Weapon Swap
 * </Battle Commands>
 *
 * - Used for: Class Notetags
 * - Changes which commands appear in the Actor Command Window in battle.
 *   If this notetag is not used, then the default commands determined in
 *   Plugin Parameters => Actor Command Window => Command List will be used.
 * - Add/remove/modify entries as needed.
 *
 * - Attack 
 *   - Adds the basic attack command.
 * 
 * - Skills
 *   - Displays all the skill types available to the actor.
 * 
 * - SType: x
 * - Stype: name
 *   - Adds in a specific skill type.
 *   - Replace 'x' with the ID of the skill type.
 *   - Replace 'name' with the name of the skill type (without text codes).
 *
 * - All Skills
 *   - Adds all usable battle skills as individual actions.
 * 
 * - Skill: x
 * - Skill: name
 *   - Adds in a specific skill as a usable action.
 *   - Replace 'x' with the ID of the skill.
 *   - Replace 'name' with the name of the skill.
 * 
 * - Guard
 *   - Adds the basic guard command.
 * 
 * - Item
 *   - Adds the basic item command.
 *
 * - Party
 *   - Requires VisuMZ_2_PartySystem.
 *   - Allows this actor to switch out with a different party member.
 * 
 * - Escape
 *   - Adds the escape command.
 * 
 * - Auto Battle
 *   - Adds the auto battle command.
 * 
 * - Combat Log
 *   - Requires VisuMZ_4_CombatLog.
 *   - Opens up the combat log.
 * 
 * - Talk
 *   - Requires VisuMZ_3_BattleCmdTalk!
 *   - Shows talk command if applicable.
 * 
 * - Weapon Swap
 *   - Requires VisuMZ_2_WeaponSwapSystem.
 *   - Swaps the current weapon.
 *
 * Example:
 *
 * <Battle Commands>
 *  Attack
 *  Skill: Heal
 *  Skills
 *  Guard
 *  Item
 *  Escape
 * </Battle Commands>
 *
 * ---
 *
 * <Command Text: x>
 *
 * - Used for: Skill Notetags
 * - When a skill is used in a <Battle Commands> notetag set, you can change
 *   the skill name text that appears to something else.
 * - Replace 'x' with the skill's name you want to shown in the Actor Battle
 *   Command window.
 * - Recommended Usage: Shorten skill names that are otherwise too big to fit
 *   inside of the Actor Battle Command window.
 *
 * ---
 *
 * <Command Icon: x>
 *
 * - Used for: Skill Notetags
 * - When a skill is used in a <Battle Commands> notetag set, you can change
 *   the skill icon that appears to something else.
 * - Replace 'x' with the ID of icon you want shown in the Actor Battle Command
 *   window to represent the skill.
 * 
 * ---
 * 
 * <Command Require Learn>
 * 
 * - Used for: Skill Notetags
 * - Determines if a battle command is visible or not by whether the actor has
 *   learned the skill.
 * - Learning the skill is a requirement. Acquiring the skill through traits
 *   does not count as learning the skill.
 * 
 * ---
 * 
 * <Command Require Access>
 * 
 * - Used for: Skill Notetags
 * - Determines if a battle command is visible or not by whether the actor has
 *   access to the skill.
 * - Having access to the skill can come through either learning the skill or
 *   temporarily acquiring it through trait objects.
 * 
 * ---
 * 
 * <Command Show Switch: x>
 * 
 * <Command Show All Switches: x,x,x>
 * <Command Show Any Switches: x,x,x>
 * 
 * - Used for: Skill Notetags
 * - Determines if a battle command is visible or not through switches.
 * - Replace 'x' with the switch ID to determine the skill's visibility.
 * - If 'All' notetag variant is used, item will be hidden until all
 *   switches are ON. Then, it would be shown.
 * - If 'Any' notetag variant is used, item will be shown if any of the
 *   switches are ON. Otherwise, it would be hidden.
 * - This can be applied to Attack and Guard commands, too.
 * 
 * ---
 * 
 * <Command Hide Switch: x>
 * 
 * <Command Hide All Switches: x,x,x>
 * <Command Hide Any Switches: x,x,x>
 * 
 * - Used for: Skill Notetags
 * - Determines if a battle command is visible or not through switches.
 * - Replace 'x' with the switch ID to determine the skill's visibility.
 * - If 'All' notetag variant is used, item will be shown until all
 *   switches are ON. Then, it would be hidden.
 * - If 'Any' notetag variant is used, item will be hidden if any of the
 *   switches are ON. Otherwise, it would be shown.
 * - This can be applied to Attack and Guard commands, too.
 * 
 * ---
 * 
 * <Battle Portrait: filename>
 *
 * - Used for: Actor
 * - This is used with the "Portrait" Battle Layout.
 * - Sets the battle portrait image for the actor to 'filename'.
 * - Replace 'filename' with a picture found within your game project's
 *   img/pictures/ folder. Filenames are case sensitive. Leave out the filename
 *   extension from the notetag.
 * - This will override any menu images used for battle only.
 * 
 * ---
 * 
 * <Battle Portrait Offset: +x, +y>
 * <Battle Portrait Offset: -x, -y>
 * 
 * <Battle Portrait Offset X: +x>
 * <Battle Portrait Offset X: -x>
 * 
 * <Battle Portrait Offset Y: +y>
 * <Battle Portrait Offset Y: -y>
 *
 * - Used for: Actor
 * - This is used with the "Portrait" and "Border" Battle Layouts.
 * - Offsets the X and Y coordinates for the battle portrait.
 * - Replace 'x' with a number value that offsets the x coordinate.
 * - Negative x values offset left. Positive x values offset right.
 * - Replace 'y' with a number value that offsets the y coordinate.
 * - Negative y values offset up. Positive x values offset down.
 * 
 * ---
 * 
 * === JavaScript Notetag: Battle Command-Related ===
 *
 * The following are notetags made for users with JavaScript knowledge to
 * determine if skill-based battle commands are visible or hidden.
 * 
 * ---
 * 
 * <JS Command Visible>
 *  code
 *  code
 *  visible = code;
 * </JS Command Visible>
 * 
 * - Used for: Skill Notetags
 * - The 'visible' variable is the final returned variable to determine the
 *   skill's visibility in the Battle Command Window.
 * - Replace 'code' with JavaScript code to determine the skill's visibility in
 *   the Battle Command Window.
 * - The 'user' variable represents the user who will perform the skill.
 * - The 'skill' variable represents the skill to be used.
 * 
 * ---
 *
 * === Targeting-Related Notetags ===
 *
 * The following notetags are related to the targeting aspect of skills and
 * items and may adjust the scope of how certain skills/items work.
 *
 * ---
 *
 * <Always Hit>
 *
 * <Always Hit Rate: x%>
 *
 * - Used for: Skill, Item Notetags
 * - Causes the action to always hit or to always have a hit rate of exactly
 *   the marked x%.
 * - Replace 'x' with a number value representing the hit success percentage.
 *
 * ---
 *
 * <Repeat Hits: x>
 *
 * - Used for: Skill, Item Notetags
 * - Changes the number of hits the action will produce.
 * - Replace 'x' with a number value representing the number of hits to incur.
 *
 * ---
 *
 * <Target: x Random Any>
 *
 * - Used for: Skill, Item Notetags
 * - Makes the skill pick 'x' random targets when used.
 * - Targets can be both actors and enemies.
 * - Replace 'x' with a number value representing the number of random targets.
 *
 * ---
 *
 * <Target: x Random Enemies>
 *
 * - Used for: Skill, Item Notetags
 * - Makes the skill pick 'x' random targets when used.
 * - Targets are only enemies.
 * - Replace 'x' with a number value representing the number of random targets.
 *
 * ---
 *
 * <Target: x Random Allies>
 *
 * - Used for: Skill, Item Notetags
 * - Makes the skill pick 'x' random targets when used.
 * - Targets are only actors.
 * - Replace 'x' with a number value representing the number of random targets.
 *
 * ---
 *
 * <Target: All Allies But User>
 *
 * - Used for: Skill, Item Notetags
 * - Targets all allies with the exception of the user.
 *
 * ---
 *
 * === JavaScript Notetag: Targeting-Related ===
 *
 * ---
 * 
 * <JS Targets>
 *  code
 *  code
 *  targets = [code];
 * </JS Targets>
 *
 * - Used for: Skill, Item Notetags
 * - The 'targets' variable is an array that is returned to be used as a
 *   container for all the valid action targets.
 * - The 'targets' variable will include the original set of targets determined
 *   by the skill/item's original scale.
 * - If you wish to clear it out, simply do 'targets = []' first.
 * - Replace 'code' with JavaScript code to determine valid targets.
 *
 * ---
 *
 * === Damage-Related Notetags ===
 *
 * ---
 *
 * <Damage Style: name>
 *
 * - Used for: Skill, Item Notetags
 * - Replace 'name' with a Damage Style name to change the way calculations are
 *   made using the damage formula input box.
 * - Names can be found in Plugin Parameters => Damage Settings => Style List
 *
 * ---
 *
 * <Armor Reduction: x>
 * <Armor Reduction: x%>
 * - Used for: Actor, Class, Skill, Item, Weapon, Armor, Enemy, State Notetags
 * - If used on skills and/or items, sets the current skill/item's armor
 *   reduction properties to 'x' and/or 'x%'.
 * - If used on trait objects, adds 'x' and/or 'x%' armor reduction properties
 *   when calculating one's own armor.
 * - This applies to physical attacks.
 * - Use the 'x' notetag variant to determine a flat reduction value.
 * - Use the 'x%' notetag variant to determine a percentile reduction value.
 *
 * ---
 *
 * <Armor Penetration: x>
 * <Armor Penetration: x%>
 * - Used for: Actor, Class, Skill, Item, Weapon, Armor, Enemy, State Notetags
 * - If used on skills and/or items, sets the current skill/item's armor
 *   penetration properties to 'x' and/or 'x%'.
 * - If used on trait objects, adds 'x' and/or 'x%' armor penetration
 *   properties when calculating a target's armor.
 * - This applies to physical attacks.
 * - Use the 'x' notetag variant to determine a flat penetration value.
 * - Use the 'x%' notetag variant to determine a percentile penetration value.
 *
 * ---
 *
 * <Magic Reduction: x>
 * <Magic Reduction: x%>
 * - Used for: Actor, Class, Skill, Item, Weapon, Armor, Enemy, State Notetags
 * - If used on skills and/or items, sets the current skill/item's armor
 *   reduction properties to 'x' and/or 'x%'.
 * - If used on trait objects, adds 'x' and/or 'x%' armor reduction properties
 *   when calculating one's own armor.
 * - This applies to magical attacks.
 * - Use the 'x' notetag variant to determine a flat reduction value.
 * - Use the 'x%' notetag variant to determine a percentile reduction value.
 *
 * ---
 *
 * <Magic Penetration: x>
 * <Magic Penetration: x%>
 * - Used for: Actor, Class, Skill, Item, Weapon, Armor, Enemy, State Notetags
 * - If used on skills and/or items, sets the current skill/item's armor
 *   penetration properties to 'x' and/or 'x%'.
 * - If used on trait objects, adds 'x' and/or 'x%' armor penetration
 *   properties when calculating a target's armor.
 * - This applies to magical attacks.
 * - Use the 'x' notetag variant to determine a flat penetration value.
 * - Use the 'x%' notetag variant to determine a percentile penetration value.
 *
 * ---
 *
 * <Bypass Damage Cap>
 * 
 * - Used for: Actor, Class, Skill, Item, Weapon, Armor, Enemy, State Notetags
 * - If used on skills and/or items, this will cause the action to never have
 *   its damage capped.
 * - If used on trait objects, this will cause the affected unit to never have
 *   its damage capped.
 *
 * ---
 *
 * <Damage Cap: x>
 *
 * - Used for: Actor, Class, Skill, Item, Weapon, Armor, Enemy, State Notetags
 * - If used on skills and/or items, this will declare the hard damage cap to
 *   be the 'x' value.
 * - If used on trait objects, this will raise the affect unit's hard damage
 *   cap to 'x' value. If another trait object has a higher value, use that
 *   value instead.
 *
 * ---
 *
 * <Bypass Soft Damage Cap>
 *
 * - Used for: Actor, Class, Skill, Item, Weapon, Armor, Enemy, State Notetags
 * - If used on skills and/or items, this will cause the action to never have
 *   its damage scaled downward to the soft cap.
 * - If used on trait objects, this will cause the affected unit to never have
 *   its damage scaled downward to the soft cap.
 *
 * ---
 *
 * <Soft Damage Cap: +x%>
 * <Soft Damage Cap: -x%>
 *
 * - Used for: Actor, Class, Skill, Item, Weapon, Armor, Enemy, State Notetags
 * - If used on skills and/or items, this will increase/decrease the action's
 *   soft cap by x% where 'x' is a percentage value representing the increment
 *   changed by the hard cap value.
 * - If used on trait objects, this will raise the affect unit's soft damage
 *   limit by x% where 'x' is a percentage value representing the increment
 *   changed by the hard cap value.
 *
 * ---
 *
 * <Unblockable>
 *
 * - Used for: Skill, Item Notetags
 * - Using "Guard" against this skill will not reduce any damage.
 *
 * ---
 *
 * === Critical-Related Notetags ===
 *
 * The following notetags affect skill and item critical hit rates and the
 * critical damage multiplier.
 *
 * ---
 *
 * <Always Critical>
 *
 * - Used for: Skill, Item Notetags
 * - This skill/item will always land a critical hit regardless of the
 *   user's CRI parameter value.
 *
 * ---
 *
 * <Set Critical Rate: x%>
 *
 * - Used for: Skill, Item Notetags
 * - This skill/item will always have a x% change to land a critical hit
 *   regardless of user's CRI parameter value.
 * - Replace 'x' with a percerntage value representing the success rate.
 *
 * ---
 *
 * <Modify Critical Rate: x%>
 * <Modify Critical Rate: +x%>
 * <Modify Critical Rate: -x%>
 *
 * - Used for: Skill, Item Notetags
 * - Modifies the user's CRI parameter calculation for this skill/item.
 * - The 'x%' notetag variant will multiply the user's CRI parameter value
 *   for this skill/item.
 * - The '+x%' and '-x%' notetag variants will incremenetally increase/decrease
 *   the user's CRI parameter value for this skill/item.
 *
 * ---
 *
 * <Modify Critical Multiplier: x%>
 * <Modify Critical Multiplier: +x%>
 * <Modify Critical Multiplier: -x%>
 *
 * - Used for: Skill, Item Notetags
 * - These notetags determine the damage multiplier when a critical hit lands.
 * - The 'x%' notetag variant multiply the multiplier to that exact percentage.
 * - The '+x%' and '-x%' notetag variants will change the multiplier with an
 *   incremenetal rate for this skill/item.
 *
 * ---
 *
 * <Modify Critical Bonus Damage: x%>
 * <Modify Critical Bonus Damage: +x%>
 * <Modify Critical Bonus Damage: -x%>
 *
 * - Used for: Skill, Item Notetags
 * - These notetags determine the bonus damage added when a critical hit lands.
 * - The 'x%' notetag variant multiply the damage to that exact percentage.
 * - The '+x%' and '-x%' notetag variants will change the bonus damage with an
 *   incremenetal rate for this skill/item.
 *
 * ---
 *
 * === JavaScript Notetags: Critical-Related ===
 *
 * The following are notetags made for users with JavaScript knowledge to
 * determine how critical hit-related aspects are calculated.
 *
 * ---
 *
 * <JS Critical Rate>
 *  code
 *  code
 *  rate = code;
 * </JS Critical Rate>
 *
 * - Used for: Skill, Item Notetags
 * - The 'rate' variable is the final returned amount to determine the
 *   critical hit success rate.
 * - Replace 'code' with JavaScript code to determine the final 'rate' to be
 *   returned as the critical hit success rate.
 * - The 'user' variable represents the one using the skill/item.
 * - The 'target' variable represents the one receiving the skill/item hit.
 *
 * ---
 *
 * <JS Critical Damage>
 *  code
 *  code
 *  multiplier = code;
 *  bonusDamage = code;
 * </JS Critical Damage>
 *
 * - Used for: Skill, Item Notetags
 * - The 'multiplier' variable is returned later and used as the damage
 *   multiplier used to amplify the critical damage amount.
 * - The 'bonusDamage' variable is returned later and used as extra added
 *   damage for the critical damage amount.
 * - Replace 'code' with JavaScript code to determine how the 'multiplier' and
 *   'bonusDamage' variables are calculated.
 * - The 'user' variable represents the one using the skill/item.
 * - The 'target' variable represents the one receiving the skill/item hit.
 *
 * ---
 *
 * === Action Sequence-Related Notetags ===
 *
 * Action Sequences allow you full control over how a skill and/or item plays
 * through its course. These notetags give you control over various aspects of
 * those Action Sequences. More information is found in the Action Sequences
 * help section.
 *
 * ---
 *
 * <Custom Action Sequence>
 *
 * - Used for: Skill, Item Notetags
 * - Removes all automated Action Sequence parts from the skill.
 * - Everything Action Sequence-related will be done by Common Events.
 * - Insert Common Event(s) into the skill/item's effects list to make use of
 *   the Custom Action Sequences.
 * - This will prevent common events from loading in the Item Scene and Skill
 *   Scene when used outside of battle.
 *
 * ---
 * 
 * <Auto Action Sequence>
 * 
 * - Used for: Skill, Item Notetags
 * - If the Action Sequence Plugin Parameter "Auto Notetag" is enabled, this
 *   plugin will prevent custom action sequences from happening for the skill
 *   or item, and instead, use an Automatic Action Sequence instead.
 * - Ignore this if you have "Auto Notetag" disabled or set to false.
 * 
 * ---
 * 
 * <Common Event: name>
 *
 * - Used for: Skill, Item Notetags
 * - Battle only: calls forth a Common Event of a matching name.
 * - Replace 'name' with the name of a Common Event to call from when this
 *   skill/item is used in battle.
 *   - Remove any \I[x] in the name.
 * - Insert multiple notetags to call multiple Common Events in succession.
 * - This will occur after any Common Event Trait Effects for the skill/item's
 *   database entry.
 * - This is primarily used for users who are reorganizing around their Common
 *   Events and would still like to have their skills/items perform the correct
 *   Action Sequences in case the ID's are different.
 * 
 * ---
 *
 * <Display Icon: x>
 * <Display Text: string>
 *
 * - Used for: Skill, Item Notetags
 * - When displaying the skill/item name in the Action Sequence, determine the
 *   icon and/or text displayed.
 * - Replace 'x' with a number value representing the icon ID to be displayed.
 * - Replace 'string' with a text value representing the displayed name.
 *
 * ---
 * 
 * <Common Event Key: name>
 * <Common Event Keys: name, name, name>
 * 
 * <Common Event Keys>
 *  key
 *  key
 *  key
 * </Common Event Keys>
 * 
 * - Used for: Skill, Item Notetags
 * - Will generate Common Events for the skill/item with a corresponding key.
 * - Replace 'name' with the name of the Common Event's key that you want to
 *   reference. That key will be converted into a Common Event effect for the
 *   skill/item and be treated as an action sequence.
 *   - The notetag variants that use multiple keys will have the keys added in
 *     the order they are listed.
 *   - If keys do not reference any Common Events, no Common Events will be
 *     added for that key.
 * - To mark a Common Event with a key, insert inside a Common Event's name the
 *   [ and ] brackets around the text that will be used as the Common Event's
 *   key text.
 *   - For example, if Common Event's name is "Penta Slash [PENTA]", then the
 *     key used is "PENTA" without the quotes.
 *   - This key could then be referenced by <Common Event Key: PENTA> notetag.
 *   - Do not use commas (,) inside the key text as it will be automatically
 *     removed for the sake of consistency.
 * - This feature is made for make the process of sharing Action Sequences to
 *   become easier without needing to line up Common Event ID's.
 * 
 * ---
 *
 * === Animated Sideview Battler-Related Notetags ===
 *
 * Enemies can use Animated Sideview Actor graphics thanks to this plugin.
 * These notetags give you control over that aspect. Some of these also affect
 * actors in addition to enemies.
 *
 * ---
 *
 * <Sideview Battler: filename>
 *
 * <Sideview Battlers>
 *  filename: weight
 *  filename: weight
 *  filename: weight
 * </Sideview Battlers>
 *
 * - Used for: Enemy Notetags
 * - Replaces the enemy's battler graphic with an animated Sideview Actor
 *   graphic found in the img/sv_actors/ folder.
 * - Replace 'filename' with the filename of the graphic to use. Do not insert
 *   any extensions. This means the file 'Actor1_1.png' will be only inserted
 *   as 'Actor1_1' without the '.png' at the end.
 * - If the multiple notetag vaiant is used, then a random filename is selected
 *   from the list upon the enemy's creation.
 * - Replace 'weight' with a number value representing how often the 'filename'
 *   would come up. The higher the weight, the more often. You may omit this
 *   and the colon(:) and just type in the 'filename' instead.
 * - Add/remove lines as you see fit.
 *
 * Example:
 *
 * <Sideview Battlers>
 *  Actor1_1: 25
 *  Actor1_3: 10
 *  Actor1_5
 *  Actor1_7
 * </Sideview Battlers>
 *
 * ---
 *
 * <Sideview Anchor: x, y>
 *
 * - Used for: Actor, Enemy Notetags
 * - Sets the sprite anchor positions for the sideview sprite.
 * - Replace 'x' and 'y' with numbers depicting where the anchors should be for
 *   the sideview sprite.
 * - By default, the x and y anchors are 0.5 and 1.0.
 *
 * ---
 * 
 * <Sideview Home Offset: +x, +y>
 * <Sideview Home Offset: -x, -y>
 * 
 * - Used for: Actor, Class, Weapon, Armor, State Notetags
 * - Offsets the sideview actor sprite's home position by +/-x, +/-y.
 * - Replace 'x' and 'y' with numbers depicting how much to offset each of the
 *   coordinates by. For '0' values, use +0 or -0.
 * - This notetag will not work if you remove it from the JavaScript code in
 *   Plugin Parameters > Actor > JS:  Home Position
 * 
 * ---
 * 
 * <Sideview Weapon Offset: +x, +y>
 * <Sideview Weapon Offset: -x, -y>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy State Notetags
 * - Offsets the sideview weapon sprite's position by +/-x, +/-y.
 * - Replace 'x' and 'y' with numbers depicting how much to offset each of the
 *   coordinates by. For '0' values, use +0 or -0.
 * 
 * ---
 *
 * <Sideview Show Shadow>
 * <Sideview Hide Shadow>
 *
 * - Used for: Actor, Enemy Notetags
 * - Sets it so the sideview battler's shadow will be visible or hidden.
 *
 * ---
 * 
 * <Sideview Shadow Scale: x%>
 * <Sideview Shadow Scale: x.y>
 * 
 * - Used for: Actor, Enemy Notetags
 * - Adjusts the scaling size of the sideview battler's shadow.
 * - This affects both the X and Y scale.
 * 
 * ---
 * 
 * <Sideview Shadow Scale X: x%>
 * <Sideview Shadow Scale X: x.y>
 * 
 * <Sideview Shadow Scale Y: x%>
 * <Sideview Shadow Scale Y: x.y>
 * 
 * - Used for: Actor, Enemy Notetags
 * - Adjusts the scaling size of the sideview battler's shadow.
 * - These affect their respective X and Y scales separately.
 * 
 * ---
 *
 * <Sideview Collapse>
 * <Sideview No Collapse>
 *
 * - Used for: Enemy Notetags
 * - Either shows the collapse graphic or does not show the collapse graphic.
 * - Collapse graphic means the enemy will 'fade away' once it's defeated.
 * - No collapse graphic means the enemy's corpse will remain on the screen.
 *
 * ---
 *
 * <Sideview Idle Motion: name>
 *
 * <Sideview Idle Motions>
 *  name: weight
 *  name: weight
 *  name: weight
 * </Sideview Idle Motions>
 *
 * - Used for: Enemy Notetags
 * - Changes the default idle motion for the enemy.
 * - Replace 'name' with any of the following motion names:
 *   - 'walk', 'wait', 'chant', 'guard', 'damage', 'evade', 'thrust', 'swing',
 *     'missile', 'skill', 'spell', 'item', 'escape', 'victory', 'dying',
 *     'abnormal', 'sleep', 'dead'
 * - If the multiple notetag vaiant is used, then a random motion name is
 *   selected from the list upon the enemy's creation.
 * - Replace 'weight' with a number value representing how often the 'name'
 *   would come up. The higher the weight, the more often. You may omit this
 *   and the colon(:) and just type in the 'name' instead.
 * - Add/remove lines as you see fit.
 *
 * Example:
 *
 * <Sideview Idle Motions>
 *  walk: 25
 *  wait: 50
 *  guard
 *  victory
 *  abnormal
 * </Sideview Idle Motions>
 *
 * ---
 *
 * <Sideview Size: width, height>
 *
 * - Used for: Enemy Notetags
 * - When using a sideview battler, its width and height will default to the
 *   setting made in Plugin Parameters => Enemy Settings => Size: Width/Height.
 * - This notetag lets you change that value to something else.
 * - Replace 'width' and 'height' with numbers representing how many pixels
 *   wide/tall the sprite will be treated as.
 *
 * ---
 *
 * <Sideview Weapon: weapontype>
 *
 * <Sideview Weapons>
 *  weapontype: weight
 *  weapontype: weight
 *  weapontype: weight
 * </Sideview Weapons>
 *
 * - Used for: Enemy Notetags
 * - Give your sideview enemies weapons to use.
 * - Replace 'weapontype' with the name of the weapon type found under the
 *   Database => Types => Weapon Types list (without text codes).
 * - If the multiple notetag vaiant is used, then a random weapon type is
 *   selected from the list upon the enemy's creation.
 * - Replace 'weight' with a number value representing how often the weapontype
 *   would come up. The higher the weight, the more often. You may omit this
 *   and the colon(:) and just type in the 'weapontype' instead.
 * - Add/remove lines as you see fit.
 *
 * Example:
 *
 * <Sideview Weapons>
 *  Dagger: 25
 *  Sword: 25
 *  Axe
 * </Sideview Weapons>
 *
 * ---
 *
 * <traitname Sideview Battler: filename>
 *
 * <traitname Sideview Battlers>
 *  filename: weight
 *  filename: weight
 *  filename: weight
 * </traitname Sideview Battlers>
 *
 * - Used for: Enemy Notetags
 * - Requires VisuMZ_1_ElementStatusCore
 * - Allows certain Trait Sets to cause battlers to have a unique appearance.
 * - Replace 'filename' with the filename of the graphic to use. Do not insert
 *   any extensions. This means the file 'Actor1_1.png' will be only inserted
 *   as 'Actor1_1' without the '.png' at the end.
 * - If the multiple notetag vaiant is used, then a random filename is selected
 *   from the list upon the enemy's creation.
 * - Replace 'weight' with a number value representing how often the 'filename'
 *   would come up. The higher the weight, the more often. You may omit this
 *   and the colon(:) and just type in the 'filename' instead.
 * - Add/remove lines as you see fit.
 *
 * Examples:
 *
 * <Male Sideview Battlers>
 *  Actor1_1: 25
 *  Actor1_3: 10
 *  Actor1_5
 *  Actor1_7
 * </Male Sideview Battlers>
 *
 * <Female Sideview Battlers>
 *  Actor1_2: 25
 *  Actor1_4: 10
 *  Actor1_6
 *  Actor1_8
 * </Female Sideview Battlers>
 *
 * ---
 *
 * <traitname Sideview Idle Motion: name>
 *
 * <traitname Sideview Idle Motions>
 *  name: weight
 *  name: weight
 *  name: weight
 * </traitname Sideview Idle Motions>
 *
 * - Used for: Enemy Notetags
 * - Requires VisuMZ_1_ElementStatusCore
 * - Allows certain Trait Sets to cause battlers to have unique idle motions.
 * - Replace 'name' with any of the following motion names:
 *   - 'walk', 'wait', 'chant', 'guard', 'damage', 'evade', 'thrust', 'swing',
 *     'missile', 'skill', 'spell', 'item', 'escape', 'victory', 'dying',
 *     'abnormal', 'sleep', 'dead'
 * - If the multiple notetag vaiant is used, then a random motion name is
 *   selected from the list upon the enemy's creation.
 * - Replace 'weight' with a number value representing how often the 'name'
 *   would come up. The higher the weight, the more often. You may omit this
 *   and the colon(:) and just type in the 'name' instead.
 * - Add/remove lines as you see fit.
 *
 * Examples:
 *
 * <Jolly Sideview Idle Motions>
 *  wait: 25
 *  victory: 10
 *  walk
 * </Jolly Sideview Idle Motions>
 *
 * <Serious Sideview Idle Motions>
 *  walk: 25
 *  guard: 10
 *  wait
 * </Jolly Sideview Idle Motions>
 *
 * ---
 *
 * <traitname Sideview Weapon: weapontype>
 *
 * <traitname Sideview Weapons>
 *  weapontype: weight
 *  weapontype: weight
 *  weapontype: weight
 * </traitname Sideview Weapons>
 *
 * - Used for: Enemy Notetags
 * - Requires VisuMZ_1_ElementStatusCore
 * - Allows certain Trait Sets to cause battlers to have unique weapons.
 * - Replace 'weapontype' with the name of the weapon type found under the
 *   Database => Types => Weapon Types list (without text codes).
 * - If the multiple notetag vaiant is used, then a random weapon type is
 *   selected from the list upon the enemy's creation.
 * - Replace 'weight' with a number value representing how often the weapontype
 *   would come up. The higher the weight, the more often. You may omit this
 *   and the colon(:) and just type in the 'weapontype' instead.
 * - Add/remove lines as you see fit.
 *
 * Examples:
 *
 * <Male Sideview Weapons>
 *  Dagger: 25
 *  Sword: 25
 *  Axe
 * </Male Sideview Weapons>
 *
 * <Female Sideview Weapons>
 *  Dagger: 25
 *  Spear: 25
 *  Cane
 * </Female Sideview Weapons>
 *
 * ---
 *
 * === Enemy-Related Notetags ===
 *
 * ---
 *
 * <Battler Sprite Cannot Move>
 *
 * - Used for: Enemy Notetags
 * - Prevents the enemy from being able to move, jump, and/or float due to
 *   Action Sequences. Useful for rooted enemies.
 *
 * ---
 * 
 * <Battler Sprite Grounded>
 *
 * - Used for: Enemy Notetags
 * - Prevents the enemy from being able to jumping and/or floating due to
 *   Action Sequences but still able to move. Useful for rooted enemies.
 * 
 * ---
 *
 * <Swap Enemies>
 *  name: weight
 *  name: weight
 *  name: weight
 * </Swap Enemies>
 *
 * - Used for: Enemy Notetags
 * - Causes this enemy database object to function as a randomizer for any of
 *   the listed enemies inside the notetag. When the enemy is loaded into the
 *   battle scene, the enemy is immediately replaced with one of the enemies
 *   listed. The randomization is based off the 'weight' given to each of the
 *   enemy 'names'.
 * - Replace 'name' with the database enemy of the enemy you wish to replace
 *   the enemy with.
 * - Replace 'weight' with a number value representing how often the 'name'
 *   would come up. The higher the weight, the more often. You may omit this
 *   and the colon(:) and just type in the 'name' instead.
 * - Add/remove lines as you see fit.
 *
 * Example:
 *
 * <Swap Enemies>
 *  Bat: 50
 *  Slime: 25
 *  Orc
 *  Minotaur
 * </Swap Enemies>
 *
 * ---
 *
 * === JavaScript Notetags: Mechanics-Related ===
 *
 * These JavaScript notetags allow you to run code at specific instances during
 * battle provided that the unit has that code associated with them in a trait
 * object (actor, class, weapon, armor, enemy, or state). How you use these is
 * entirely up to you and will depend on your ability to understand the code
 * used and driven for each case.
 *
 * ---
 *
 * <JS Pre-Start Battle>
 *  code
 *  code
 *  code
 * </JS Pre-Start Battle>
 *
 * <JS Post-Start Battle>
 *  code
 *  code
 *  code
 * </JS Post-Start Battle>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code at the start of battle aimed at the function:
 *   BattleManager.startBattle()
 *   - 'Pre' runs before the function runs.
 *   - 'Post' runs after the function runs.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one affected by the trait object.
 *
 * ---
 *
 * <JS Pre-Start Turn>
 *  code
 *  code
 *  code
 * </JS Pre-Start Turn>
 *
 * <JS Post-Start Turn>
 *  code
 *  code
 *  code
 * </JS Post-Start Turn>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code at the start of a turn aimed at the function:
 *   BattleManager.startTurn()
 *   - 'Pre' runs before the function runs.
 *   - 'Post' runs after the function runs.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one affected by the trait object.
 *
 * ---
 *
 * <JS Pre-Start Action>
 *  code
 *  code
 *  code
 * </JS Pre-Start Action>
 *
 * <JS Post-Start Action>
 *  code
 *  code
 *  code
 * </JS Post-Start Action>
 * 
 * - Used for: Actor, Class, Skill, Item, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code at the start of an action aimed at the function:
 *   BattleManager.startAction()
 *   - 'Pre' runs before the function runs.
 *   - 'Post' runs after the function runs.
 * - If used on skills and/or items, this will only apply to the skill/item
 *   being used and does not affect other skills and items.
 * - If used on trait objects, this will apply to any skills/items used as long
 *   as the unit affected by the trait object has access to the trait object.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one affected by the trait object.
 *
 * ---
 *
 * <JS Pre-Apply>
 *  code
 *  code
 *  code
 * </JS Pre-Apply>
 * 
 * - Used for: Skill, Item Notetags
 * - Runs JavaScript code at the start of an action hit aimed at the function:
 *   Game_Action.prototype.apply()
 *   - 'Pre' runs before the function runs.
 * - If used on skills and/or items, this will only apply to the skill/item
 *   being used and does not affect other skills and items.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one using the skill/item.
 * - The 'target' variable represents the one receiving the skill/item hit.
 *
 * ---
 *
 * <JS Pre-Apply as User>
 *  code
 *  code
 *  code
 * </JS Pre-Apply as User>
 *
 * <JS Pre-Apply as Target>
 *  code
 *  code
 *  code
 * </JS Pre-Apply as Target>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code at the start of an action hit aimed at the function:
 *   Game_Action.prototype.apply()
 *   - 'Pre' runs before the function runs.
 * - If used on trait objects, this will apply to any skills/items used as long
 *   as the unit affected by the trait object has access to the trait object.
 * - If the 'as User' notetag variant is used, this code will be run as a
 *   response to the action from the action user end.
 * - If the 'as Target' notetag variant is used, this code will be run as a
 *   response to the action from the action target end.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one using the skill/item.
 * - The 'target' variable represents the one receiving the skill/item hit.
 *
 * ---
 *
 * <JS Pre-Damage>
 *  code
 *  code
 *  code
 * </JS Pre-Damage>
 * 
 * - Used for: Skill, Item Notetags
 * - Runs JavaScript code before damage is dealt aimed at the function:
 *   Game_Action.prototype.executeDamage()
 *   - 'Pre' runs before the function runs.
 * - If used on skills and/or items, this will only apply to the skill/item
 *   being used and does not affect other skills and items.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one using the skill/item.
 * - The 'target' variable represents the one receiving the skill/item hit.
 *
 * ---
 *
 * <JS Pre-Damage as User>
 *  code
 *  code
 *  code
 * </JS Pre-Damage as User>
 *
 * <JS Pre-Damage as Target>
 *  code
 *  code
 *  code
 * </JS Pre-Damage as Target>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code before damage is dealt aimed at the function:
 *   Game_Action.prototype.executeDamage()
 *   - 'Pre' runs before the function runs.
 * - If used on trait objects, this will apply to any skills/items used as long
 *   as the unit affected by the trait object has access to the trait object.
 * - If the 'as User' notetag variant is used, this code will be run as a
 *   response to the action from the action user end.
 * - If the 'as Target' notetag variant is used, this code will be run as a
 *   response to the action from the action target end.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one using the skill/item.
 * - The 'target' variable represents the one receiving the skill/item hit.
 *
 * ---
 *
 * <JS Post-Damage>
 *  code
 *  code
 *  code
 * </JS Post-Damage>
 * 
 * - Used for: Skill, Item Notetags
 * - Runs JavaScript code after damage is dealt aimed at the function:
 *   Game_Action.prototype.executeDamage()
 *   - 'Post' runs after the function runs.
 * - If used on skills and/or items, this will only apply to the skill/item
 *   being used and does not affect other skills and items.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one using the skill/item.
 * - The 'target' variable represents the one receiving the skill/item hit.
 *
 * ---
 *
 * <JS Post-Damage as User>
 *  code
 *  code
 *  code
 * </JS Post-Damage as User>
 *
 * <JS Post-Damage as Target>
 *  code
 *  code
 *  code
 * </JS Post-Damage as Target>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code after damage is dealt aimed at the function:
 *   Game_Action.prototype.executeDamage()
 *   - 'Post' runs after the function runs.
 * - If used on trait objects, this will apply to any skills/items used as long
 *   as the unit affected by the trait object has access to the trait object.
 * - If the 'as User' notetag variant is used, this code will be run as a
 *   response to the action from the action user end.
 * - If the 'as Target' notetag variant is used, this code will be run as a
 *   response to the action from the action target end.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one using the skill/item.
 * - The 'target' variable represents the one receiving the skill/item hit.
 *
 * ---
 *
 * <JS Post-Apply>
 *  code
 *  code
 *  code
 * </JS Post-Apply>
 * 
 * - Used for: Skill, Item Notetags
 * - Runs JavaScript code at the end of an action hit aimed at the function:
 *   Game_Action.prototype.apply()
 *   - 'Post' runs after the function runs.
 * - If used on skills and/or items, this will only apply to the skill/item
 *   being used and does not affect other skills and items.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one using the skill/item.
 * - The 'target' variable represents the one receiving the skill/item hit.
 *
 * ---
 *
 * <JS Post-Apply as User>
 *  code
 *  code
 *  code
 * </JS Post-Apply as User>
 *
 * <JS Post-Apply as Target>
 *  code
 *  code
 *  code
 * </JS Post-Apply as Target>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code at the end of an action hit aimed at the function:
 *   Game_Action.prototype.apply()
 *   - 'Post' runs after the function runs.
 * - If used on trait objects, this will apply to any skills/items used as long
 *   as the unit affected by the trait object has access to the trait object.
 * - If the 'as User' notetag variant is used, this code will be run as a
 *   response to the action from the action user end.
 * - If the 'as Target' notetag variant is used, this code will be run as a
 *   response to the action from the action target end.
 * - Replace 'code' with JavaScript code to run desired effects.
 *
 * ---
 *
 * <JS Pre-End Action>
 *  code
 *  code
 *  code
 * </JS Pre-End Action>
 *
 * <JS Post-End Action>
 *  code
 *  code
 *  code
 * </JS Post-End Action>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code at the end of an action aimed at the function:
 *   BattleManager.endAction()
 *   - 'Pre' runs before the function runs.
 *   - 'Post' runs after the function runs.
 * - If used on trait objects, this will apply to any skills/items used as long
 *   as the unit affected by the trait object has access to the trait object.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one affected by the trait object.
 *
 * ---
 *
 * <JS Pre-End Turn>
 *  code
 *  code
 *  code
 * </JS Pre-End Turn>
 *
 * <JS Post-End Turn>
 *  code
 *  code
 *  code
 * </JS Post-End Turn>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code at the end of a turn aimed at the function:
 *   Game_Battler.prototype.onTurnEnd()
 *   - 'Pre' runs before the function runs.
 *   - 'Post' runs after the function runs.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one affected by the trait object.
 *
 * ---
 *
 * <JS Pre-Regenerate>
 *  code
 *  code
 *  code
 * </JS Pre-Regenerate>
 *
 * <JS Post-Regenerate>
 *  code
 *  code
 *  code
 * </JS Post-Regenerate>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code when a unit regenerates HP/MP aimed at the function:
 *   Game_Battler.prototype.regenerateAll()
 *   - 'Pre' runs before the function runs.
 *   - 'Post' runs after the function runs.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one affected by the trait object.
 *
 * ---
 *
 * <JS Battle Victory>
 *  code
 *  code
 *  code
 * </JS Battle Victory>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code when a battle is won aimed at the function:
 *   BattleManager.processVictory()
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one affected by the trait object.
 *
 * ---
 *
 * <JS Escape Success>
 *  code
 *  code
 *  code
 * </JS Escape Success>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code when escaping succeeds aimed at the function:
 *   BattleManager.onEscapeSuccess()
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one affected by the trait object.
 *
 * ---
 *
 * <JS Escape Failure>
 *  code
 *  code
 *  code
 * </JS Escape Failure>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code when escaping fails aimed at the function:
 *   BattleManager.onEscapeFailure()
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one affected by the trait object.
 *
 * ---
 *
 * <JS Battle Defeat>
 *  code
 *  code
 *  code
 * </JS Battle Defeat>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code when a battle is lost aimed at the function:
 *   BattleManager.processDefeat()
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one affected by the trait object.
 *
 * ---
 *
 * <JS Pre-End Battle>
 *  code
 *  code
 *  code
 * </JS Pre-End Battle>
 *
 * <JS Post-End Battle>
 *  code
 *  code
 *  code
 * </JS Post-End Battle>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code when the battle is over aimed at the function:
 *   BattleManager.endBattle()
 *   - 'Pre' runs before the function runs.
 *   - 'Post' runs after the function runs.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one affected by the trait object.
 *
 * ---
 * 
 * === Battle Layout-Related Notetags ===
 * 
 * These tags will change the battle layout for a troop regardless of how the
 * plugin parameters are set up normally. Insert these tags in either the
 * noteboxes of maps or the names of troops for them to take effect. If both
 * are present for a specific battle, then priority goes to the setting found
 * in the troop name.
 * 
 * ---
 * 
 * <Layout: type>
 * <Battle Layout: type>
 * 
 * - Used for: Map Notetags, Troop Name Tags, and Troop Comment Tags
 * - Changes the battle layout style used for this specific map or battle.
 * - Replace 'type' with 'default', 'list', 'xp', 'portrait', or 'border'.
 * - If using Troop Comment Tags, then as long as the tag appears in a comment
 *   found on any of the Troop's pages (even if they don't run), the tag will
 *   be considered in effect.
 * 
 * ---
 *
 * ============================================================================
 * Action Sequence - Plugin Commands
 * ============================================================================
 *
 * Skills and items, when used in battle, have a pre-determined series of
 * actions to display to the player as a means of representing what's going on
 * with the action. For some game devs, this may not be enough and they would
 * like to get more involved with the actions themselves.
 *
 * Action Sequences, added through this plugin, enable this. To give a skill or
 * item a Custom Action Sequence, a couple of steps must be followed:
 *
 * ---
 *
 * 1. Insert the <Custom Action Sequence> notetag into the skill or item's
 *    notebox (or else this would not work as intended).
 * 2. Give that skill/item a Common Event through the Effects box. The selected
 *    Common Event will contain all the Action Sequence data.
 * 3. Create the Common Event with Action Sequence Plugin Commands and/or event
 *    commands to make the skill/item do what you want it to do.
 *
 * ---
 *
 * The Plugin Commands added through the Battle Core plugin focus entirely on
 * Action Sequences. However, despite the fact that they're made for skills and
 * items, some of these Action Sequence Plugin Commands can still be used for
 * regular Troop events and Common Events.
 *
 * ---
 *
 * === Action Sequence - Action Sets ===
 *
 * Action Sequence Action Sets are groups of commonly used
 * Action Sequence Commands put together for more efficient usage.
 *
 * ---
 *
 * ACSET: Setup Action Set
 * - The generic start to most actions.
 *
 *   Display Action:
 *   Immortal: On:
 *   Battle Step:
 *   Wait For Movement:
 *   Cast Animation:
 *   Wait For Animation:
 *   - Use this part of the action sequence?
 *
 * ---
 *
 * ACSET: All Targets Action Set
 * - Affects all targets simultaneously performing the following.
 *
 *   Dual/Multi Wield?
 *   - Add times struck based on weapon quantity equipped?
 * 
 *   Perform Action:
 *   Wait Count:
 *   Action Animation:
 *   Wait For Animation:
 *   Action Effect:
 *   Immortal: Off:
 *   - Use this part of the action sequence?
 *   - Insert values for the Wait Count(s).
 *
 * ---
 *
 * ACSET: Each Target Action Set
 * - Goes through each target one by one to perform the following.
 *
 *   Dual/Multi Wield?
 *   - Add times struck based on weapon quantity equipped?
 *
 *   Perform Action:
 *   Wait Count:
 *   Action Animation:
 *   Wait Count:
 *   Action Effect:
 *   Immortal: Off:
 *   - Use this part of the action sequence?
 *   - Insert values for the Wait Count(s).
 *
 * ---
 *
 * ACSET: Finish Action
 * - The generic ending to most actions.
 *
 *   Wait For New Line:
 *   Wait For Effects:
 *   Clear Battle Log:
 *   Home Reset:
 *   Wait For Movement:
 *   - Use this part of the action sequence?
 *
 * ---
 * 
 * === Action Sequences - Angle ===
 * 
 * These action sequences allow you to have control over the camera angle.
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * ---
 *
 * ANGLE: Change Angle
 * - Changes the camera angle.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 *   Angle:
 *   - Change the camera angle to this many degrees.
 *
 *   Duration:
 *   - Duration in frames to change camera angle.
 *
 *   Angle Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Angle?:
 *   - Wait for angle changes to complete before performing next command?
 *
 * ---
 *
 * ANGLE: Reset Angle
 * - Reset any angle settings.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 *   Duration:
 *   - Duration in frames to reset camera angle.
 *
 *   Angle Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Angle?:
 *   - Wait for angle changes to complete before performing next command?
 *
 * ---
 *
 * ANGLE: Wait For Angle
 * - Waits for angle changes to complete before performing next command.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 * ---
 *
 * === Action Sequences - Animations ===
 *
 * These Action Sequences are related to the 'Animations' that can be found in
 * the Animations tab of the Database.
 *
 * ---
 *
 * ANIM: Action Animation
 * - Plays the animation associated with the action.
 *
 *   Targets:
 *   - Select unit(s) to play the animation on.
 *
 *   Mirror Animation:
 *   - Mirror the animation?
 *
 *   Wait For Animation?:
 *   - Wait for animation to complete before performing next command?
 *
 * ---
 *
 * ANIM: Attack Animation
 * - Plays the animation associated with the user's weapon.
 *
 *   Targets:
 *   - Select unit(s) to play the animation on.
 *
 *   Mirror Animation:
 *   - Mirror the animation?
 *
 *   Wait For Animation?:
 *   - Wait for animation to complete before performing next command?
 *
 * ---
 *
 * ANIM: Attack Animation 2+
 * - Plays the animation associated with the user's other weapons.
 * - Plays nothing if there is no other weapon equipped.
 *
 *   Targets:
 *   - Select unit(s) to play the animation on.
 * 
 *   Slot:
 *   - Which weapon slot to get this data from?
 *   - Main-hand weapon is weapon slot 1.
 *
 *   Mirror Animation:
 *   - Mirror the animation?
 *
 *   Wait For Animation?:
 *   - Wait for animation to complete before performing next command?
 *
 * ---
 *
 * ANIM: Cast Animation
 * - Plays the cast animation associated with the action.
 *
 *   Targets:
 *   - Select unit(s) to play the animation on.
 *
 *   Mirror Animation:
 *   - Mirror the animation?
 *
 *   Wait For Animation?:
 *   - Wait for animation to complete before performing next command?
 *
 * ---
 *
 * ANIM: Change Battle Portrait
 * - Changes the battle portrait of the actor (if it's an actor).
 * - Can be used outside of battle/action sequences.
 *
 *   Targets:
 *   - Select unit(s) to play the animation on.
 *   - Valid units can only be actors.
 *
 *   Filename:
 *   - Select the file to change the actor's portrait to.
 * 
 * ---
 *
 * ANIM: Play at Coordinate
 * - Plays an animation on the screen at a specific x, y coordinate.
 * - Requires VisuMZ_0_CoreEngine!
 * 
 *   Animation ID:
 *   - Plays this animation.
 * 
 *   Coordinates:
 * 
 *     X:
 *     Y:
 *     - X/Y coordinate used for the animation.
 *       You may use JavaScript code.
 * 
 *   Mirror Animation?:
 *   - Mirror the animation?
 * 
 *   Mute Animation?:
 *   - Mute the animation?
 * 
 *   Wait for Completion?:
 *   - Wait the animation to finish before continuing?
 *
 * ---
 *
 * ANIM: Show Animation
 * - Plays the a specific animation on unit(s).
 *
 *   Targets:
 *   - Select unit(s) to play the animation on.
 *
 *   Animation ID:
 *   - Select which animation to play on unit(s).
 *
 *   Mirror Animation:
 *   - Mirror the animation?
 *
 *   Wait For Animation?:
 *   - Wait for animation to complete before performing next command?
 *
 * ---
 *
 * ANIM: Wait For Animation
 * - Causes the interpreter to wait for any animation(s) to finish.
 *
 * ---
 *
 * === Action Sequences - Battle Log ===
 *
 * These Action Sequences are related to the Battle Log Window, the window
 * found at the top of the battle screen.
 *
 * ---
 *
 * BTLOG: Add Text
 * - Adds a new line of text into the Battle Log.
 *
 *   Text:
 *   - Add this text into the Battle Log.
 *   - Text codes allowed.
 * 
 *   Copy to Combat Log?:
 *   - Copies text to the Combat Log.
 *   - Requires VisuMZ_4_CombatLog
 * 
 *     Combat Log Icon:
 *     - What icon would you like to bind to this entry?
 *     - Requires VisuMZ_4_CombatLog
 *
 * ---
 *
 * BTLOG: Clear Battle Log
 * - Clears all the text in the Battle Log.
 *
 * ---
 *
 * BTLOG: Display Action
 * - plays the current action in the Battle Log.
 *
 * ---
 *
 * BTLOG: Pop Base Line
 * - Removes the Battle Log's last added base line and  all text up to its
 *   former location.
 *
 * ---
 *
 * BTLOG: Push Base Line
 * - Adds a new base line to where the Battle Log currently is at.
 *
 * ---
 *
 * BTLOG: Refresh Battle Log
 * - Refreshes the Battle Log.
 *
 * ---
 *
 * BTLOG: UI Show/Hide
 * - Shows or hides the Battle UI (including the Battle Log).
 *
 *   Show/Hide?:
 *   - Shows/hides the Battle UI.
 *
 * ---
 *
 * BTLOG: Wait For Battle Log
 * - Causes the interpreter to wait for the Battle Log to finish.
 *
 * ---
 *
 * BTLOG: Wait For New Line
 * - Causes the interpreter to wait for a new line in the Battle Log.
 *
 * ---
 *
 * === Action Sequences - Camera ===
 *
 * These Action Sequences are battle camera-related.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * ---
 *
 * CAMERA: Clamp ON/OFF
 * - Turns battle camera clamping on/off.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 *   Setting:
 *   - Turns camera clamping on/off.
 *
 * ---
 *
 * CAMERA: Focus Point
 * - Focus the battle camera on a certain point in the screen.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 *   X Coordinate:
 *   - Insert the point to focus the camera on.
 *   - You may use JavaScript code.
 *
 *   Y Coordinate:
 *   - Insert the point to focus the camera on.
 *   - You may use JavaScript code.
 *
 *   Duration:
 *   - Duration in frames for camera focus change.
 *
 *   Camera Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Camera?
 *   - Wait for camera changes to complete before performing next command?
 *
 * ---
 *
 * CAMERA: Focus Target(s)
 * - Focus the battle camera on certain battler target(s).
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 *   Targets:
 *   - Select unit(s) to focus the battle camera on.
 *
 *   Duration:
 *   - Duration in frames for camera focus change.
 *
 *   Camera Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Camera?
 *   - Wait for camera changes to complete before performing next command?
 *
 * ---
 *
 * CAMERA: Offset
 * - Offset the battle camera from the focus target.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 *   Offset X:
 *   - How much to offset the camera X by.
 *   - Negative: left. Positive: right.
 *
 *   Offset Y:
 *   - How much to offset the camera Y by.
 *   - Negative: up. Positive: down.
 *
 *   Duration:
 *   - Duration in frames for offset change.
 *
 *   Camera Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Camera?
 *   - Wait for camera changes to complete before performing next command?
 *
 * ---
 *
 * CAMERA: Reset
 * - Reset the battle camera settings.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 *   Reset Focus?:
 *   - Reset the focus point?
 *
 *   Reset Offset?:
 *   - Reset the camera offset?
 *
 *   Duration:
 *   - Duration in frames for reset change.
 *
 *   Camera Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Camera?
 *   - Wait for camera changes to complete before performing next command?
 *
 * ---
 *
 * CAMERA: Wait For Camera
 * - Waits for camera changes to complete before performing next command.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 * ---
 *
 * === Action Sequences - Dragonbones ===
 *
 * These Action Sequences are Dragonbones-related.
 * Requires VisuMZ_2_DragonbonesUnion!
 *
 * ---
 *
 * DB: Dragonbones Animation
 * - Causes the unit(s) to play a Dragonbones motion animation.
 * - Requires VisuMZ_2_DragonbonesUnion!
 *
 *   Targets:
 *   - Select which unit(s) to perform a motion animation.
 *
 *   Motion Animation:
 *   - What is the name of the Dragonbones motion animation you wish to play?
 *
 * ---
 *
 * DB: Dragonbones Time Scale
 * - Causes the unit(s) to change their Dragonbones time scale.
 * - Requires VisuMZ_2_DragonbonesUnion!
 *
 *   Targets:
 *   - Select which unit(s) to perform a motion animation.
 *
 *   Time Scale:
 *   - Change the value of the Dragonbones time scale to this.
 *
 * ---
 *
 * === Action Sequences - Elements ===
 *
 * These Action Sequences can change up the element(s) used for the action's
 * damage calculation midway through an action.
 *
 * They also require the VisuMZ_1_ElementStatusCore plugin to be present in
 * order for them to work.
 *
 * ---
 *
 * ELE: Add Elements
 * - Adds element(s) to be used when calculating damage.
 * - Requires VisuMZ_1_ElementStatusCore!
 *
 *   Elements:
 *   - Select which element ID to add onto the action.
 *   - Insert multiple element ID's to add multiple at once.
 *
 * ---
 *
 * ELE: Clear Element Changes
 * - Clears all element changes made through Action Sequences.
 * - Requires VisuMZ_1_ElementStatusCore!
 *
 * ---
 *
 * ELE: Force Elements
 * - Forces only specific element(s) when calculating damage.
 * - Requires VisuMZ_1_ElementStatusCore!
 *
 *   Elements:
 *   - Select which element ID to force in the action.
 *   - Insert multiple element ID's to force multiple at once.
 *
 * ---
 *
 * ELE: Null Element
 * - Forces no element to be used when calculating damage.
 * - Requires VisuMZ_1_ElementStatusCore!
 *
 * ---
 * 
 * === Action Sequences - Horror Effects ===
 * 
 * These Action Sequences are Horror Effects-related.
 * Requires VisuMZ_2_HorrorEffects!
 * 
 * ---
 *
 * HORROR: Clear All Filters
 * - Clear all Horror Effects filters on the target battler(s).
 *
 *   Targets:
 *   - Select unit(s) to remove Horror Effects for.
 *
 * ---
 *
 * HORROR: Glitch Create
 * - Creates the glitch effect on the target battler(s).
 *
 *   Targets:
 *   - Select unit(s) to create the Horror Effect for.
 *
 *   Glitch Slices:
 *   - Glitch slices to be used with the target.
 *
 *   Glitch Offset:
 *   - Default offset value.
 *
 *   Glitch Animated?:
 *   - Animate the glitch effect?
 *
 *   Glitch Frequency:
 *   - If animated, how frequent to make the glitch effect?
 *   - Lower = often     Higher = rarer
 *
 *   Glitch Strength:
 *   - If animated, how strong is the glitch effect?
 *   - Lower = weaker     Higher = stronger
 *
 * ---
 *
 * HORROR: Glitch Remove
 * - Removes the glitch effect on the target battler(s).
 *
 *   Targets:
 *   - Select unit(s) to remove the Horror Effect for.
 *
 * ---
 *
 * HORROR: Noise Create
 * - Creates the noise effect on the target battler(s).
 *
 *   Targets:
 *   - Select unit(s) to create the Horror Effect for.
 *
 *   Noise Rate:
 *   - Noise rate to be used with the target.
 *
 *   Noise Animated:
 *   - Animate the noise for the target?
 *
 * ---
 *
 * HORROR: Noise Remove
 * - Removes the noise effect on the target battler(s).
 *
 *   Targets:
 *   - Select unit(s) to remove the Horror Effect for.
 *
 * ---
 *
 * HORROR: TV Create
 * - Creates the TV effect on the target battler(s).
 *
 *   Targets:
 *   - Select unit(s) to create the Horror Effect for.
 *
 *   TV Line Thickness:
 *   - Default TV line thickness
 *   - Lower = thinner     Higher = thicker
 *
 *   TV Corner Size:
 *   - Default TV line corner size
 *   - Lower = smaller     Higher = bigger
 *
 *   TV Animated:
 *   - Animate the TV?
 *
 *   TV Speed:
 *   - Speed used to animate the TV if animated
 *   - Lower = slower     Higher = faster
 *
 * ---
 *
 * HORROR: TV Remove
 * - Removes the TV effect on the target battler(s).
 *
 *   Targets:
 *   - Select unit(s) to remove the Horror Effect for.
 *
 * ---
 * 
 * === Action Sequences - Impact ===
 * 
 * These Action Sequences are related to creating impact.
 * Requires VisuMZ_3_ActSeqImpact!
 * 
 * ---
 *
 * IMPACT: Color Break
 * - Breaks the colors on the screen before reassembling.
 * - Requires VisuMZ_3_ActSeqImpact!
 *
 *   Intensity:
 *   - What is the intensity of the color break effect?
 *
 *   Duration:
 *   - What is the duration of the color break effect?
 *
 *   Easing Type:
 *   - Select which easing type you wish to apply.
 *
 * ---
 *
 * IMPACT: Motion Blur Screen
 * - Creates a motion blur on the whole screen.
 * - Requires VisuMZ_3_ActSeqImpact!
 *
 *   Angle:
 *   - Determine what angle to make the motion blur at.
 *
 *   Intensity Rate:
 *   - This determines intensity rate of the motion blur.
 *   - Use a number between 0 and 1.
 *
 *   Duration:
 *   - How many frames should the motion blur last?
 *   - What do you want to be its duration?
 *
 *   Easing Type:
 *   - Select which easing type you wish to apply.
 *
 * ---
 *
 * IMPACT: Motion Blur Target(s)
 * - Creates a motion blur on selected target(s).
 * - Requires VisuMZ_3_ActSeqImpact!
 *
 *   Targets:
 *   - Select unit(s) to create motion blur effects for.
 *
 *   Angle:
 *   - Determine what angle to make the motion blur at.
 *
 *   Intensity Rate:
 *   - This determines intensity rate of the motion blur.
 *   - Use a number between 0 and 1.
 *
 *   Duration:
 *   - How many frames should the motion blur last?
 *   - What do you want to be its duration?
 *
 *   Easing Type:
 *   - Select which easing type you wish to apply.
 *
 * ---
 *
 * IMPACT: Motion Trail Create
 * - Creates a motion trail effect for the target(s).
 * - Requires VisuMZ_3_ActSeqImpact!
 *
 *   Targets:
 *   - Select unit(s) to create motion trail effects for.
 *
 *   Delay:
 *   - How many frames to delay by when creating a motion trail?
 *   - The higher the delay, the less motion trails there are.
 *
 *   Duration:
 *   - How many frames should the motion trail last?
 *   - What do you want to be its duration?
 *
 *   Hue:
 *   - What do you want to be the hue for the motion trail?
 *
 *   Starting Opacity:
 *   - What starting opacity value do you want for the motion trail?
 *   - Opacity values decrease over time.
 *
 *   Tone:
 *   - What tone do you want for the motion trail?
 *   - Format: [Red, Green, Blue, Gray]
 *
 * ---
 *
 * IMPACT: Motion Trail Remove
 * - Removes the motion trail effect from the target(s).
 * - Requires VisuMZ_3_ActSeqImpact!
 *
 *   Targets:
 *   - Select unit(s) to clear motion trail effects for.
 *
 * ---
 *
 * IMPACT: Shockwave at Point
 * - Creates a shockwave at the designated coordinates.
 * - Requires VisuMZ_3_ActSeqImpact!
 *
 *   Point: X:
 *   Point: Y:
 *   - What x/y coordinate do you want to create a shockwave at?
 *   - You can use JavaScript code.
 *
 *   Amplitude:
 *   - What is the aplitude of the shockwave effect?
 *
 *   Wavelength:
 *   - What is the wavelength of the shockwave effect?
 *
 *   Duration:
 *   - What is the duration of the shockwave?
 *
 * ---
 *
 * IMPACT: Shockwave from Each Target(s)
 * - Creates a shockwave at each of the target(s) location(s).
 * - Requires VisuMZ_3_ActSeqImpact!
 *
 *   Targets:
 *   - Select unit(s) to start a shockwave from.
 *
 *   Target Location:
 *   - Select which part target group to start a shockwave from.
 * 
 *     Offset X:
 *     Offset Y:
 *     - How much to offset the shockwave X/Y point by.
 *
 *   Amplitude:
 *   - What is the aplitude of the shockwave effect?
 *
 *   Wavelength:
 *   - What is the wavelength of the shockwave effect?
 *
 *   Duration:
 *   - What is the duration of the shockwave?
 *
 * ---
 *
 * IMPACT: Shockwave from Target(s) Center
 * - Creates a shockwave from the center of the target(s).
 * - Requires VisuMZ_3_ActSeqImpact!
 *
 *   Targets:
 *   - Select unit(s) to start a shockwave from.
 *
 *   Target Location:
 *   - Select which part target group to start a shockwave from.
 * 
 *     Offset X:
 *     Offset Y:
 *     - How much to offset the shockwave X/Y point by.
 *
 *   Amplitude:
 *   - What is the aplitude of the shockwave effect?
 *
 *   Wavelength:
 *   - What is the wavelength of the shockwave effect?
 *
 *   Duration:
 *   - What is the duration of the shockwave?
 *
 * ---
 *
 * IMPACT: Zoom Blur at Point
 * - Creates a zoom blur at the designated coordinates.
 * - Requires VisuMZ_3_ActSeqImpact!
 *
 *   Point: X:
 *   Point: Y:
 *   - What x/y coordinate do you want to focus the zoom at?
 *   - You can use JavaScript code.
 *
 *   Zoom Strength:
 *   - What is the strength of the zoom effect?
 *   - Use a number between 0 and 1.
 *
 *   Visible Radius:
 *   - How much of a radius should be visible from the center?
 *
 *   Duration:
 *   - What is the duration of the zoom blur?
 *
 *   Easing Type:
 *   - Select which easing type you wish to apply.
 *
 * ---
 *
 * IMPACT: Zoom Blur at Target(s) Center
 * - Creates a zoom blur at the center of targets.
 * - Requires VisuMZ_3_ActSeqImpact!
 *
 *   Targets:
 *   - Select unit(s) to start a zoom blur from.
 *
 *   Target Location:
 *   - Select which part target group to start a zoom blur from.
 * 
 *     Offset X:
 *     Offset Y:
 *     - How much to offset the zoom blur X/Y point by.
 *
 *   Zoom Strength:
 *   - What is the strength of the zoom effect?
 *   - Use a number between 0 and 1.
 *
 *   Visible Radius:
 *   - How much of a radius should be visible from the center?
 *
 *   Duration:
 *   - What is the duration of the zoom blur?
 *
 *   Easing Type:
 *   - Select which easing type you wish to apply.
 *
 * ---
 *
 * === Action Sequences - Mechanics ===
 *
 * These Action Sequences are related to various mechanics related to the
 * battle system.
 *
 * ---
 *
 * MECH: Action Effect
 * - Causes the unit(s) to take damage/healing from action and incurs any
 *   changes made such as buffs and states.
 *
 *   Targets:
 *   - Select unit(s) to receive the current action's effects.
 *
 * ---
 *
 * MECH: Add Buff/Debuff
 * - Adds buff(s)/debuff(s) to unit(s). 
 * - Determine which parameters are affected and their durations.
 *
 *   Targets:
 *   - Select unit(s) to receive the buff(s) and/or debuff(s).
 *
 *   Buff Parameters:
 *   - Select which parameter(s) to buff.
 *   - Insert a parameter multiple times to raise its stacks.
 *
 *   Debuff Parameters:
 *   - Select which parameter(s) to debuff.
 *   - Insert a parameter multiple times to raise its stacks.
 *
 *   Turns:
 *   - Number of turns to set the parameter(s) buffs to.
 *   - You may use JavaScript code.
 *
 * ---
 *
 * MECH: Add State
 * - Adds state(s) to unit(s).
 *
 *   Targets:
 *   - Select unit(s) to receive the buff(s).
 *
 *   States:
 *   - Select which state ID(s) to add to unit(s).
 *   - Insert multiple state ID's to add multiple at once.
 *
 * ---
 * 
 * MECH: Analyze Weakness
 * - Reveal elemental weakness(es) from target(s).
 * - Requires VisuMZ_3_WeaknessDisplay!
 * 
 *   Targets:
 *   - Select unit(s) to reveal elemental weaknesses for.
 * 
 *   Reveal:
 *   - How many elemental weaknesses do you wish to reveal?
 *   - You may use JavaScript code.
 * 
 * ---
 *
 * MECH: Armor Penetration
 * - Adds an extra layer of defensive penetration/reduction.
 * - You may use JavaScript code for any of these.
 *
 *   Armor/Magic Penetration:
 *
 *     Rate:
 *     - Penetrates an extra multiplier of armor by this value.
 *
 *     Flat:
 *     - Penetrates a flat amount of armor by this value.
 *
 *   Armor/Magic Reduction:
 *
 *     Rate:
 *     - Reduces an extra multiplier of armor by this value.
 *
 *     Flat:
 *     - Reduces a flat amount of armor by this value.
 *
 * ---
 * 
 * MECH: ATB Gauge
 * - Alters the ATB/TPB Gauges.
 * - Requires VisuMZ_2_BattleSystemATB!
 * 
 *   Targets:
 *   - Select unit(s) to alter the ATB/TPB Gauges for.
 * 
 *   Charging:
 *   
 *     Charge Rate:
 *     - Changes made to the ATB Gauge if it is currently charging.
 * 
 *   Casting:
 *   
 *     Cast Rate:
 *     - Changes made to the ATB Gauge if it is currently casting.
 *   
 *     Interrupt?:
 *     - Interrupt the ATB Gauge if it is currently casting?
 * 
 * ---
 * 
 * MECH: Boost Points Change
 * - Changes Boost Points for target(s).
 * - Requires VisuMZ_3_BoostAction!
 * 
 *   Targets:
 *   - Select unit(s) to alter the Boost Points for.
 * 
 *   Alter Boost Points By:
 *   - Alters the unit(s) Boost Points.
 *   - Positive for gaining points. Negative for losing points.
 * 
 * ---
 * 
 * MECH: Boost Store Data
 * - Stores the number of Boosts used this action inside a variable.
 * - Requires VisuMZ_3_BoostAction!
 * 
 *   Variable ID:
 *   - Which variable do you want to store the data inside?
 * 
 * ---
 * 
 * MECH: Break Shield Change
 * - Changes Break Shields for target(s) if not Break Stunned.
 * - Requires VisuMZ_4_BreakShields!
 * 
 *   Targets:
 *   - Select unit(s) to alter the Break Shields for.
 * 
 *   Alter Break Shields By:
 *   - Alters the unit(s) Break Shields.
 *   - Positive for gaining shields. Negative for losing shields.
 * 
 * ---
 * 
 * MECH: Break Shield Reset
 * - Resets Break Shields for target(s) if not Break Stunned.
 * - Requires VisuMZ_4_BreakShields!
 * 
 *   Targets:
 *   - Select unit(s) to reset the Break Shields for.
 * 
 * ---
 * 
 * MECH: BTB Brave Points
 * - Alters the target(s) Brave Points to an exact value.
 * - Requires VisuMZ_2_BattleSystemBTB!
 * 
 *   Targets:
 *   - Select unit(s) to alter the ATB/TPB Gauges for.
 * 
 *   Alter Brave Points By:
 *   - Alters the target(s) Brave Points.
 *   - Positive for gaining BP.
 *   - Negative for losing BP.
 * 
 * ---
 *
 * MECH: Collapse
 * - Causes the unit(s) to perform its collapse animation if the unit(s)
 *   has died.
 *
 *   Targets:
 *   - Select unit(s) to process a death collapse.
 *
 *   Force Death:
 *   - Force death even if the unit has not reached 0 HP?
 *   - This will remove immortality.
 *
 *   Wait For Effect?:
 *   - Wait for the collapse effect to complete before performing next command?
 *
 * ---
 * 
 * MECH: CTB Order
 * - Alters the CTB Turn Order.
 * - Requires VisuMZ_2_BattleSystemCTB!
 * 
 *   Targets:
 *   - Select unit(s) to alter the CTB Turn Order for.
 * 
 *   Change Order By:
 *   - Changes turn order for target(s) by this amount.
 *   - Positive increases wait. Negative decreases wait.
 * 
 * ---
 * 
 * MECH: CTB Speed
 * - Alters the CTB Speed.
 * - Requires VisuMZ_2_BattleSystemCTB!
 * 
 *   Targets:
 *   - Select unit(s) to alter the CTB Speed for.
 * 
 *   Charge Rate:
 *   - Changes made to the CTB Speed if it is currently charging.
 * 
 *   Cast Rate:
 *   - Changes made to the CTB Speed if it is currently casting.
 * 
 * ---
 * 
 * MECH: Custom Damage Formula
 * - Changes the current action's damage formula to custom.
 * - This will assume the MANUAL damage style.
 * 
 *   Formula:
 *   - Changes the current action's damage formula to custom.
 *   - Use 'default' to revert the damage formula.
 * 
 * ---
 *
 * MECH: Damage Popup
 * - Causes the unit(s) to display the current state of damage received
 *   or healed.
 *
 *   Targets:
 *   - Select unit(s) to prompt a damage popup.
 *
 * ---
 *
 * MECH: Dead Label Jump
 * - If the active battler is dead, jump to a specific label in the
 *   common event.
 *
 *   Jump To Label:
 *   - If the active battler is dead, jump to this specific label in the
 *     common event.
 *
 * ---
 *
 * MECH: Enemy Escape
 * - Causes the enemy unit(s) to escape.
 *
 *   Targets:
 *   - Select unit(s) to escape.
 *
 * ---
 *
 * MECH: ETB Energy Count
 * - Alters the subject team's available Energy Count.
 * - Requires VisuMZ_2_BattleSystemETB!
 *
 *   Energy Count:
 *   - Alters the subject team's available Energy Count.
 *   - Positive for gaining energy. Negative for losing energy.
 *
 * ---
 *
 * MECH: FTB Action Count
 * - Alters the subject team's available Action Count.
 * - Requires VisuMZ_2_BattleSystemFTB!
 *
 *   Action Count:
 *   - Alters the subject team's available Action Count.
 *   - Positive for gaining actions. Negative for losing actions.
 *
 * ---
 *
 * MECH: HP, MP, TP
 * - Alters the HP, MP, and TP values for unit(s).
 * - Positive values for healing. Negative values for damage.
 *
 *   Targets:
 *   - Select unit(s) to receive the current action's effects.
 *
 *   HP, MP, TP:
 *
 *     Rate:
 *     - Changes made to the parameter based on rate.
 *     - Positive values for healing. Negative values for damage.
 *
 *     Flat:
 *     - Flat changes made to the parameter.
 *     - Positive values for healing. Negative values for damage.
 *
 *   Damage Popup?:
 *   - Display a damage popup after?
 *
 * ---
 *
 * MECH: Immortal
 * - Changes the immortal flag of targets. If immortal flag is removed and a
 *   unit would die, collapse that unit.
 *
 *   Targets:
 *   - Alter the immortal flag of these groups. If immortal flag is removed and
 *     a unit would die, collapse that unit.
 *
 *   Immortal:
 *   - Turn immortal flag for unit(s) on/off?
 *
 * ---
 *
 * MECH: Multipliers
 * - Changes the multipliers for the current action.
 * - You may use JavaScript code for any of these.
 *
 *   Critical Hit%:
 *
 *     Rate:
 *     - Affects chance to land a critical hit by this multiplier.
 *
 *     Flat:
 *     - Affects chance to land a critical hit by this flat bonus.
 *
 *   Critical Damage
 *
 *     Rate:
 *     - Affects critical damage by this multiplier.
 *
 *     Flat:
 *     - Affects critical damage by this flat bonus.
 *
 *   Damage/Healing
 *
 *     Rate:
 *     - Sets the damage/healing multiplier for current action.
 *
 *     Flat:
 *     - Sets the damage/healing bonus for current action.
 *
 *   Hit Rate
 *
 *     Rate:
 *     - Affects chance to connect attack by this multiplier.
 *
 *     Flat:
 *     - Affects chance to connect attack by this flat bonus.
 *
 * ---
 * 
 * MECH: OTB Order
 * - Alters the OTB Turn Order. Best used with single targets.
 * - Requires VisuMZ_2_BattleSystemOTB!
 * 
 *   Targets:
 *   - Select unit(s) to alter the OTB Turn Order for.
 * 
 *   Current Turn By:
 *   - Changes turn order for target(s) by this amount.
 *   - Positive increases wait. Negative decreases wait.
 * 
 *   Next Turn By:
 *   - Changes turn order for target(s) by this amount.
 *   - Positive increases wait. Negative decreases wait.
 * 
 *   Follow Turn By:
 *   - Changes turn order for target(s) by this amount.
 *   - Positive increases wait. Negative decreases wait.
 * 
 * ---
 * 
 * MECH: PTB Alter Cost
 * - Alters the action's cost settings.
 * - Requires VisuMZ_2_BattleSystemPTB!
 * 
 *   Override?:
 *   - Overrides any 'permanent' settings for Changeability?
 * 
 *   Alter Changeability:
 *   - Allow the cost type and value to be changeable?
 * 
 *   Alter Cost Type:
 *   - Change the cost type to this scenario.
 *   - Use 'Unchanged' for no changes.
 * 
 *   Alter Cost Value:
 *   - What is the default action cost for this scenario?
 * 
 *   Priority:
 *   - What is this scenario's priority? Scenario outcomes with equal or lower
 *     priorities cannot override types and costs.
 * 
 * ---
 * 
 * MECH: PTB Conversion
 * - Converts full actions into half actions.
 * - Requires VisuMZ_2_BattleSystemPTB!
 * 
 *   Conversion Count:
 *   - Converts full actions into half actions.
 *   - If not enough, consume half actions.
 * 
 * ---
 * 
 * MECH: PTB Full/Half Action(s)
 * - Alters the subject team's available Full/Half Actions.
 * - Requires VisuMZ_2_BattleSystemPTB!
 * 
 *   Full Actions:
 *   - Alters the subject team's available Full Actions.
 *   - Positive for gaining. Negative for losing.
 * 
 *   Half Actions:
 *   - Alters the subject team's available Half Actions.
 *   - Positive for gaining. Negative for losing.
 * 
 * ---
 *
 * MECH: Remove Buff/Debuff
 * - Removes buff(s)/debuff(s) from unit(s). 
 * - Determine which parameters are removed.
 *
 *   Targets:
 *   - Select unit(s) to have the buff(s) and/or debuff(s) removed.
 *
 *   Buff Parameters:
 *   - Select which buffed parameter(s) to remove.
 *
 *   Debuff Parameters:
 *   - Select which debuffed parameter(s) to remove.
 *
 * ---
 *
 * MECH: Remove State
 * - Remove state(s) from unit(s).
 *
 *   Targets:
 *   - Select unit(s) to have states removed from.
 *
 *   States:
 *   - Select which state ID(s) to remove from unit(s).
 *   - Insert multiple state ID's to remove multiple at once.
 *
 * ---
 * 
 * MECH: STB Exploit Effect
 * - Utilize the STB Exploitation mechanics!
 * - Requires VisuMZ_2_BattleSystemSTB!
 * 
 *   Target(s) Exploited?:
 *   - Exploit the below targets?
 * 
 *     Targets:
 *     - Select unit(s) to become exploited.
 * 
 *     Force Exploitation:
 *     - Force the exploited status?
 * 
 *   User Exploiter?:
 *   - Allow the user to become the exploiter?
 * 
 *     Force Exploitation:
 *     - Force the exploiter status?
 * 
 * ---
 * 
 * MECH: STB Extra Action
 * - Adds an extra action for the currently active battler.
 * - Requires VisuMZ_2_BattleSystemSTB!
 * 
 *   Extra Actions:
 *   - How many extra actions should the active battler gain?
 *   - You may use JavaScript code.
 * 
 * ---
 * 
 * MECH: STB Remove Excess Actions
 * - Removes excess actions from the active battler.
 * - Requires VisuMZ_2_BattleSystemSTB!
 * 
 *   Remove Actions:
 *   - How many actions to remove from the active battler?
 *   - You may use JavaScript code.
 * 
 * ---
 * 
 * MECH: Swap Weapon
 * - Causes the unit(s) to swap their weapon for another.
 * - Requires VisuMZ_2_WeaponSwapSystem!
 * 
 *   Targets:
 *   - Select unit(s) to swap weapons for.
 * 
 *   Weapon Type ID:
 *   - Which weapon type to swap to?
 *   - This is NOT the weapon's ID.
 *   - It's the weapon TYPE.
 * 
 * ---
 * 
 * MECH: Text Popup
 * - Causes the unit(s) to display a text popup.
 * 
 *   Targets:
 *   - Select unit(s) to prompt a text popup.
 * 
 *   Text:
 *   - What text do you wish to display?
 * 
 *   Text Color:
 *   - Use #rrggbb for custom colors or regular numbers for text colors from
 *     the Window Skin.
 * 
 *   Flash Color:
 *   - Adjust the popup's flash color.
 *   - Format: [red, green, blue, alpha]
 * 
 *   Flash Duration:
 *   - What is the frame duration of the flash effect?
 * 
 * ---
 * 
 * MECH: Variable Popup
 * - Causes the unit(s) to display a popup using the data stored inside
 *   a variable.
 * 
 *   Targets:
 *   - Select unit(s) to prompt a text popup.
 * 
 *   Variable:
 *   - Get data from which variable to display as a popup?
 * 
 *   Digit Grouping:
 *   - Use digit grouping to separate numbers?
 *   - Requires VisuMZ_0_CoreEngine!
 * 
 *   Text Color:
 *   - Use #rrggbb for custom colors or regular numbers for text colors from
 *     the Window Skin.
 * 
 *   Flash Color:
 *   - Adjust the popup's flash color.
 *   - Format: [red, green, blue, alpha]
 * 
 *   Flash Duration:
 *   - What is the frame duration of the flash effect?
 * 
 * ---
 *
 * MECH: Wait For Effect
 * - Waits for the effects to complete before performing next command.
 *
 * ---
 *
 * === Action Sequences - Motion ===
 *
 * These Action Sequences allow you the ability to control the motions of
 * sideview sprites.
 *
 * ---
 * 
 * MOTION: Clear Freeze Frame
 * - Clears any freeze frames from the unit(s).
 * 
 *   Targets:
 *   - Select which unit(s) to clear freeze frames for.
 * 
 * ---
 * 
 * MOTION: Freeze Motion Frame
 * - Forces a freeze frame instantly at the selected motion.
 * - Automatically clears with a new motion.
 * 
 *   Targets:
 *   - Select which unit(s) to freeze motions for.
 * 
 *   Motion Type:
 *   - Freeze this motion for the unit(s).
 * 
 *   Frame Index:
 *   - Which frame do you want to freeze the motion on?
 *   - Frame index values start at 0.
 * 
 *   Show Weapon?:
 *   - If using 'attack', 'thrust', 'swing', or 'missile', display the
 *     weapon sprite?
 * 
 * ---
 *
 * MOTION: Motion Type
 * - Causes the unit(s) to play the selected motion.
 *
 *   Targets:
 *   - Select which unit(s) to perform a motion.
 *
 *   Motion Type:
 *   - Play this motion for the unit(s).
 *
 *   Show Weapon?:
 *   - If using 'attack', 'thrust', 'swing', or 'missile', display the
 *     weapon sprite?
 *
 * ---
 *
 * MOTION: Perform Action
 * - Causes the unit(s) to play the proper motion based on the current action.
 *
 *   Targets:
 *   - Select which unit(s) to perform a motion.
 *
 * ---
 *
 * MOTION: Refresh Motion
 * - Cancels any set motions unit(s) has to do and use their most natural
 *   motion at the moment.
 *
 *   Targets:
 *   - Select which unit(s) to refresh their motion state.
 *
 * ---
 *
 * MOTION: Wait By Motion Frame
 * - Creates a wait equal to the number of motion frames passing.
 * - Time is based on Plugin Parameters => Actors => Motion Speed.
 *
 *   Motion Frames to Wait?:
 *   - Each "frame" is equal to the value found in 
 *     Plugin Parameters => Actors => Motion Speed
 *
 * ---
 *
 * === Action Sequences - Movement ===
 *
 * These Action Sequences allow you the ability to control the sprites of
 * actors and enemies in battle.
 *
 * ---
 *
 * MOVE: Battle Step
 * - Causes the unit(s) to move forward past their home position to prepare
 *   for action.
 *
 *   Targets:
 *   - Select which unit(s) to move.
 *
 *   Wait For Movement?:
 *   - Wait for movement to complete before performing next command?
 *
 * ---
 *
 * MOVE: Face Direction
 * - Causes the unit(s) to face forward or backward.
 * - Sideview-only!
 *
 *   Targets:
 *   - Select which unit(s) to change direction.
 *
 *   Direction:
 *   - Select which direction to face.
 *
 * ---
 *
 * MOVE: Face Point
 * - Causes the unit(s) to face a point on the screen.
 * - Sideview-only!
 *
 *   Targets:
 *   - Select which unit(s) to change direction.
 *
 *   Point:
 *   - Select which point to face.
 *     - Home
 *     - Center
 *     - Point X, Y
 *       - Replace 'x' and 'y' with coordinates
 *
 *   Face Away From?:
 *   - Face away from the point instead?
 *
 * ---
 *
 * MOVE: Face Target(s)
 * - Causes the unit(s) to face other targets on the screen.
 * - Sideview-only!
 *
 *   Targets (facing):
 *   - Select which unit(s) to change direction.
 *
 *   Targets (destination):
 *   - Select which unit(s) for the turning unit(s) to face.
 *
 *   Face Away From?:
 *   - Face away from the unit(s) instead?
 *
 * ---
 *
 * MOVE: Float
 * - Causes the unit(s) to float above the ground.
 * - Sideview-only!
 *
 *   Targets:
 *   - Select which unit(s) to make float.
 *
 *   Desired Height:
 *   - Vertical distance to float upward.
 *   - You may use JavaScript code.
 *
 *   Duration:
 *   - Duration in frames for total float amount.
 *
 *   Float Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Float?:
 *   - Wait for floating to complete before performing next command?
 *
 * ---
 *
 * MOVE: Home Reset
 * - Causes the unit(s) to move back to their home position(s) and face back to
 *   their original direction(s).
 *
 *   Targets:
 *   - Select which unit(s) to move.
 *
 *   Wait For Movement?:
 *   - Wait for movement to complete before performing next command?
 *
 * ---
 *
 * MOVE: Jump
 * - Causes the unit(s) to jump into the air.
 * - Sideview-only!
 *
 *   Targets:
 *   - Select which unit(s) to make jump.
 *
 *   Desired Height:
 *   - Max jump height to go above the ground
 *   - You may use JavaScript code.
 *
 *   Duration:
 *   - Duration in frames for total jump amount.
 *
 *   Wait For Jump?:
 *   - Wait for jumping to complete before performing next command?
 *
 * ---
 *
 * MOVE: Move Distance
 * - Moves unit(s) by a distance from their current position(s).
 * - Sideview-only!
 *
 *   Targets:
 *   - Select which unit(s) to move.
 *
 *   Distance Adjustment:
 *   - Makes adjustments to distance values to determine which direction to
 *     move unit(s).
 *     - Normal - No adjustments made
 *     - Horizontal - Actors adjust left, Enemies adjust right
 *     - Vertical - Actors adjust Up, Enemies adjust down
 *     - Both - Applies both Horizontal and Vertical
 *
 *     Distance: X:
 *     - Horizontal distance to move.
 *     - You may use JavaScript code.
 *
 *     Distance: Y:
 *     - Vertical distance to move.
 *     - You may use JavaScript code.
 *
 *   Duration:
 *   - Duration in frames for total movement amount.
 *
 *   Face Destination?:
 *   - Turn and face the destination?
 *
 *   Movement Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Movement Motion:
 *   - Play this motion for the unit(s).
 *
 *   Wait For Movement?:
 *   - Wait for movement to complete before performing next command?
 *
 * ---
 *
 * MOVE: Move To Point
 * - Moves unit(s) to a designated point on the screen.
 * - Sideview-only! Points based off Graphics.boxWidth/Height.
 *
 *   Targets:
 *   - Select which unit(s) to move.
 *
 *   Destination Point:
 *   - Select which point to face.
 *     - Home
 *     - Center
 *     - Point X, Y
 *       - Replace 'x' and 'y' with coordinates
 *
 *   Offset Adjustment:
 *   - Makes adjustments to offset values to determine which direction to
 *     adjust the destination by.
 *
 *     Offset: X:
 *     - Horizontal offset to move.
 *     - You may use JavaScript code.
 *
 *     Offset: Y:
 *     - Vertical offset to move.
 *     - You may use JavaScript code.
 *
 *   Duration:
 *   - Duration in frames for total movement amount.
 *
 *   Face Destination?:
 *   - Turn and face the destination?
 *
 *   Movement Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Movement Motion:
 *   - Play this motion for the unit(s).
 *
 *   Wait For Movement?:
 *   - Wait for movement to complete before performing next command?
 *
 * ---
 *
 * MOVE: Move To Target(s)
 * - Moves unit(s) to another unit(s) on the battle field.
 * - Sideview-only!
 *
 *   Targets (Moving):
 *   - Select which unit(s) to move.
 *
 *   Targets (Destination):
 *   - Select which unit(s) to move to.
 *
 *     Target Location:
 *     - Select which part target group to move to.
 *       - front head
 *       - front center
 *       - front base
 *       - middle head
 *       - middle center
 *       - middle base
 *       - back head
 *       - back center
 *       - back base
 *
 *     Melee Distance:
 *     - The melee distance away from the target location in addition to the
 *       battler's width.
 *
 *   Offset Adjustment:
 *   - Makes adjustments to offset values to determine which direction to
 *     adjust the destination by.
 *
 *     Offset: X:
 *     - Horizontal offset to move.
 *     - You may use JavaScript code.
 *
 *     Offset: Y:
 *     - Vertical offset to move.
 *     - You may use JavaScript code.
 *
 *   Duration:
 *   - Duration in frames for total movement amount.
 *
 *   Face Destination?:
 *   - Turn and face the destination?
 *
 *   Movement Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Movement Motion:
 *   - Play this motion for the unit(s).
 *
 *   Wait For Movement?:
 *   - Wait for movement to complete before performing next command?
 *
 * ---
 *
 * MOVE: Opacity
 * - Causes the unit(s) to change opacity.
 * - Sideview-only!
 *
 *   Targets:
 *   - Select which unit(s) to change opacity.
 *
 *   Desired Opacity:
 *   - Change to this opacity value.
 *   - You may use JavaScript code.
 *
 *   Duration:
 *   - Duration in frames for opacity change.
 *
 *   Opacity Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Opacity?:
 *   - Wait for opacity changes to complete before performing next command?
 *
 * ---
 *
 * MOVE: Scale/Grow/Shrink
 * - Causes the unit(s) to scale, grow, or shrink?.
 * - Sideview-only!
 *
 *   Targets:
 *   - Select which unit(s) to change the scale of.
 *
 *   Scale X:
 *   Scale Y:
 *   - What target scale value do you want?
 *   - 1.0 is normal size.
 *
 *   Duration:
 *   - Duration in frames to scale for.
 *
 *   Scale Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Scale?:
 *   - Wait for scaling to complete before performing next command?
 *
 * ---
 *
 * MOVE: Skew/Distort
 * - Causes the unit(s) to skew.
 * - Sideview-only!
 *
 *   Targets:
 *   - Select which unit(s) to skew.
 *
 *   Skew X:
 *   Skew Y:
 *   - What variance to skew?
 *   - Use small values for the best results.
 *
 *   Duration:
 *   - Duration in frames to skew for.
 *
 *   Skew Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Skew?:
 *   - Wait for skew to complete before performing next command?
 *
 * ---
 *
 * MOVE: Spin/Rotate
 * - Causes the unit(s) to spin.
 * - Sideview-only!
 *
 *   Targets:
 *   - Select which unit(s) to spin.
 *
 *   Angle:
 *   - How many degrees to spin?
 *
 *   Duration:
 *   - Duration in frames to spin for.
 *
 *   Spin Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 * 
 *   Revert Angle on Finish:
 *   - Upon finishing the spin, revert the angle back to 0.
 *
 *   Wait For Spin?:
 *   - Wait for spin to complete before performing next command?
 *
 * ---
 *
 * MOVE: Wait For Float
 * - Waits for floating to complete before performing next command.
 *
 * ---
 *
 * MOVE: Wait For Jump
 * - Waits for jumping to complete before performing next command.
 *
 * ---
 *
 * MOVE: Wait For Movement
 * - Waits for movement to complete before performing next command.
 *
 * ---
 *
 * MOVE: Wait For Opacity
 * - Waits for opacity changes to complete before performing next command.
 *
 * ---
 *
 * MOVE: Wait For Scale
 * - Waits for scaling to complete before performing next command.
 *
 * ---
 *
 * MOVE: Wait For Skew
 * - Waits for skewing to complete before performing next command.
 *
 * ---
 *
 * MOVE: Wait For Spin
 * - Waits for spinning to complete before performing next command.
 *
 * ---
 * 
 * === Action Sequences - Projectiles ===
 * 
 * Create projectiles on the screen and fire them off at a target.
 * Requires VisuMZ_3_ActSeqProjectiles!
 * 
 * ---
 *
 * PROJECTILE: Animation
 * - Create an animation projectile and fire it at a target.
 * - Requires VisuMZ_3_ActSeqProjectiles!
 *
 *   Coordinates:
 *
 *     Start Location:
 *     - Settings to determine where the projectile(s) start from.
 *
 *       Type:
 *       - Select where the projectile should start from.
 *         - Target - Start from battler target(s)
 *         - Point - Start from a point on the screen
 *
 *         Target(s):
 *         - Select which unit(s) to start the projectile from.
 *
 *           Centralize:
 *           - Create one projectile at the center of the targets?
 *           - Or create a projectile for each target?
 * 
 *           Target Location:
 *           - Select which part of the target to send the projectile from.
 *           - front head
 *           - front center
 *           - front base
 *           - middle head
 *           - middle center
 *           - middle base
 *           - back head
 *           - back center
 *           - back base
 *
 *         Point X:
 *         Point Y:
 *         - Insert the X/Y coordinate to start the projectile at.
 *         - You may use JavaScript code.
 *
 *       Offset X:
 *       Offset Y:
 *       - Insert how many pixels to offset the X/Y coordinate by.
 *       - You may use JavaScript code.
 *
 *     Goal Location:
 *     - Settings to determine where the projectile(s) start from.
 *
 *       Type:
 *       - Select where the projectile should go to.
 *         - Target - Goal is battler target(s)
 *         - Point - Goal is a point on the screen
 *
 *         Target(s):
 *         - Select which unit(s) for projectile to go to.
 *
 *           Centralize:
 *           - Create one projectile at the center of the targets?
 *           - Or create a projectile for each target?
 * 
 *           Target Location:
 *           - Select which part of the target to send the projectile to.
 *           - front head
 *           - front center
 *           - front base
 *           - middle head
 *           - middle center
 *           - middle base
 *           - back head
 *           - back center
 *           - back base
 *
 *         Point X:
 *         Point Y:
 *         - Insert the X/Y coordinate to send the projectile to.
 *         - You may use JavaScript code.
 *
 *       Offset X:
 *       Offset Y:
 *       - Insert how many pixels to offset the X/Y coordinate by.
 *       - You may use JavaScript code.
 *
 *   Settings:
 *
 *     Animation ID:
 *     - Determine which animation to use as a projectile.
 *
 *     Duration:
 *     - Duration for the projectile(s) to travel.
 *
 *     Wait For Projectile?:
 *     - Wait for projectile(s) to reach their destination before going onto
 *       the next command?
 *
 *     Extra Settings:
 *     - Add extra settings to the projectile?
 *
 *       Auto Angle?:
 *       - Automatically angle the projectile to tilt the direction
 *         it's moving?
 *
 *       Angle Offset:
 *       - Alter the projectile's tilt by this many degrees.
 *
 *       Arc Peak:
 *       - This is the height of the project's trajectory arc in pixels.
 *
 *       Easing:
 *       - Select which easing type to apply to the projectile's trajectory.
 *
 *       Spin Speed:
 *       - Determine how much angle the projectile spins per frame.
 *       - Does not work well with "Auto Angle".
 *
 * ---
 *
 * PROJECTILE: Icon
 * - Create an icon projectile and fire it at a target.
 * - Requires VisuMZ_3_ActSeqProjectiles!
 *
 *   Coordinates:
 *
 *     Start Location:
 *     - Settings to determine where the projectile(s) start from.
 *
 *       Type:
 *       - Select where the projectile should start from.
 *         - Target - Start from battler target(s)
 *         - Point - Start from a point on the screen
 *
 *         Target(s):
 *         - Select which unit(s) to start the projectile from.
 *
 *           Centralize:
 *           - Create one projectile at the center of the targets?
 *           - Or create a projectile for each target?
 * 
 *           Target Location:
 *           - Select which part of the target to send the projectile from.
 *           - front head
 *           - front center
 *           - front base
 *           - middle head
 *           - middle center
 *           - middle base
 *           - back head
 *           - back center
 *           - back base
 *
 *         Point X:
 *         Point Y:
 *         - Insert the X/Y coordinate to start the projectile at.
 *         - You may use JavaScript code.
 *
 *       Offset X:
 *       Offset Y:
 *       - Insert how many pixels to offset the X/Y coordinate by.
 *       - You may use JavaScript code.
 *
 *     Goal Location:
 *     - Settings to determine where the projectile(s) start from.
 *
 *       Type:
 *       - Select where the projectile should go to.
 *         - Target - Goal is battler target(s)
 *         - Point - Goal is a point on the screen
 *
 *         Target(s):
 *         - Select which unit(s) for projectile to go to.
 *
 *           Centralize:
 *           - Create one projectile at the center of the targets?
 *           - Or create a projectile for each target?
 * 
 *           Target Location:
 *           - Select which part of the target to send the projectile to.
 *           - front head
 *           - front center
 *           - front base
 *           - middle head
 *           - middle center
 *           - middle base
 *           - back head
 *           - back center
 *           - back base
 *
 *         Point X:
 *         Point Y:
 *         - Insert the X/Y coordinate to send the projectile to.
 *         - You may use JavaScript code.
 *
 *       Offset X:
 *       Offset Y:
 *       - Insert how many pixels to offset the X/Y coordinate by.
 *       - You may use JavaScript code.
 *
 *   Settings:
 *
 *     Icon:
 *     - Determine which icon to use as a projectile.
 *       - You may use JavaScript code.
 *
 *     Duration:
 *     - Duration for the projectile(s) to travel.
 *
 *     Wait For Projectile?:
 *     - Wait for projectile(s) to reach their destination before going onto
 *       the next command?
 *
 *     Extra Settings:
 *     - Add extra settings to the projectile?
 *
 *       Auto Angle?:
 *       - Automatically angle the projectile to tilt the direction
 *         it's moving?
 *
 *       Angle Offset:
 *       - Alter the projectile's tilt by this many degrees.
 *
 *       Arc Peak:
 *       - This is the height of the project's trajectory arc in pixels.
 *
 *       Blend Mode:
 *       - What kind of blend mode do you wish to apply to the projectile?
 *         - Normal
 *         - Additive
 *         - Multiply
 *         - Screen
 *
 *       Easing:
 *       - Select which easing type to apply to the projectile's trajectory.
 *
 *       Hue:
 *       - Adjust the hue of the projectile.
 *       - Insert a number between 0 and 360.
 *
 *       Scale:
 *       - Adjust the size scaling of the projectile.
 *       - Use decimals for exact control.
 *
 *       Spin Speed:
 *       - Determine how much angle the projectile spins per frame.
 *       - Does not work well with "Auto Angle".
 *
 * ---
 *
 * PROJECTILE: Picture
 * - Create a picture projectile and fire it at a target.
 * - Requires VisuMZ_3_ActSeqProjectiles!
 *
 *   Coordinates:
 *
 *     Start Location:
 *     - Settings to determine where the projectile(s) start from.
 *
 *       Type:
 *       - Select where the projectile should start from.
 *         - Target - Start from battler target(s)
 *         - Point - Start from a point on the screen
 *
 *         Target(s):
 *         - Select which unit(s) to start the projectile from.
 *
 *           Centralize:
 *           - Create one projectile at the center of the targets?
 *           - Or create a projectile for each target?
 * 
 *           Target Location:
 *           - Select which part of the target to send the projectile from.
 *           - front head
 *           - front center
 *           - front base
 *           - middle head
 *           - middle center
 *           - middle base
 *           - back head
 *           - back center
 *           - back base
 *
 *         Point X:
 *         Point Y:
 *         - Insert the X/Y coordinate to start the projectile at.
 *         - You may use JavaScript code.
 *
 *       Offset X:
 *       Offset Y:
 *       - Insert how many pixels to offset the X/Y coordinate by.
 *       - You may use JavaScript code.
 *
 *     Goal Location:
 *     - Settings to determine where the projectile(s) start from.
 *
 *       Type:
 *       - Select where the projectile should go to.
 *         - Target - Goal is battler target(s)
 *         - Point - Goal is a point on the screen
 *
 *         Target(s):
 *         - Select which unit(s) for projectile to go to.
 *
 *           Centralize:
 *           - Create one projectile at the center of the targets?
 *           - Or create a projectile for each target?
 * 
 *           Target Location:
 *           - Select which part of the target to send the projectile to.
 *           - front head
 *           - front center
 *           - front base
 *           - middle head
 *           - middle center
 *           - middle base
 *           - back head
 *           - back center
 *           - back base
 *
 *         Point X:
 *         Point Y:
 *         - Insert the X/Y coordinate to send the projectile to.
 *         - You may use JavaScript code.
 *
 *       Offset X:
 *       Offset Y:
 *       - Insert how many pixels to offset the X/Y coordinate by.
 *       - You may use JavaScript code.
 *
 *   Settings:
 *
 *     Picture Filename:
 *     - Determine which picture to use as a projectile.
 *
 *     Duration:
 *     - Duration for the projectile(s) to travel.
 *
 *     Wait For Projectile?:
 *     - Wait for projectile(s) to reach their destination before going onto
 *       the next command?
 *
 *     Extra Settings:
 *     - Add extra settings to the projectile?
 *
 *       Auto Angle?:
 *       - Automatically angle the projectile to tilt the direction
 *         it's moving?
 *
 *       Angle Offset:
 *       - Alter the projectile's tilt by this many degrees.
 *
 *       Arc Peak:
 *       - This is the height of the project's trajectory arc in pixels.
 *
 *       Blend Mode:
 *       - What kind of blend mode do you wish to apply to the projectile?
 *         - Normal
 *         - Additive
 *         - Multiply
 *         - Screen
 *
 *       Easing:
 *       - Select which easing type to apply to the projectile's trajectory.
 *
 *       Hue:
 *       - Adjust the hue of the projectile.
 *       - Insert a number between 0 and 360.
 *
 *       Scale:
 *       - Adjust the size scaling of the projectile.
 *       - Use decimals for exact control.
 *
 *       Spin Speed:
 *       - Determine how much angle the projectile spins per frame.
 *       - Does not work well with "Auto Angle".
 *
 * ---
 * 
 * === Action Sequences - Skew ===
 * 
 * These action sequences allow you to have control over the camera skew.
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * ---
 *
 * SKEW: Change Skew
 * - Changes the camera skew.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 *   Skew X:
 *   - Change the camera skew X to this value.
 *
 *   Skew Y:
 *   - Change the camera skew Y to this value.
 *
 *   Duration:
 *   - Duration in frames to change camera skew.
 *
 *   Skew Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Skew?:
 *   - Wait for skew changes to complete before performing next command?
 *
 * ---
 *
 * SKEW: Reset Skew
 * - Reset any skew settings.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 *   Duration:
 *   - Duration in frames to reset camera skew.
 *
 *   Skew Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Skew?:
 *   - Wait for skew changes to complete before performing next command?
 *
 * ---
 *
 * SKEW: Wait For Skew
 * - Waits for skew changes to complete before performing next command.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 * ---
 *
 * === Action Sequences - Target ===
 *
 * If using a manual target by target Action Sequence, these commands will give
 * you full control over its usage.
 *
 * ---
 *
 * TARGET: Current Index
 * - Sets the current index to this value.
 * - Then decide to jump to a label (optional).
 *
 *   Set Index To:
 *   - Sets current targeting index to this value.
 *   - 0 is the starting index of a target group.
 *
 *   Jump To Label:
 *   - If a target is found after the index change, jump to this label in the
 *     Common Event.
 *
 * ---
 *
 * TARGET: Next Target
 * - Moves index forward by 1 to select a new current target.
 * - Then decide to jump to a label (optional).
 *
 *   Jump To Label:
 *   - If a target is found after the index change, jump to this label in the
 *     Common Event.
 *
 * ---
 *
 * TARGET: Previous Target
 * - Moves index backward by 1 to select a new current target.
 * - Then decide to jump to a label (optional).
 *
 *   Jump To Label:
 *   - If a target is found after the index change, jump to this label in the
 *     Common Event.
 *
 * ---
 *
 * TARGET: Random Target
 * - Sets index randomly to determine new currernt target.
 * - Then decide to jump to a label (optional).
 *
 *   Force Random?:
 *   - Index cannot be its previous index amount after random.
 *
 *   Jump To Label:
 *   - If a target is found after the index change, jump to this label in the
 *     Common Event.
 *
 * ---
 *
 * === Action Sequences - Weapon ===
 *
 * Allows for finer control over Dual/Multi Wielding actors.
 * Only works for Actors.
 *
 * ---
 *
 * WEAPON: Clear Weapon Slot
 * - Clears the active weapon slot (making others valid again).
 * - Only works for Actors.
 *
 *   Targets:
 *   - Select unit(s) to clear the active weapon slot for.
 *
 * ---
 *
 * WEAPON: Next Weapon Slot
 * - Goes to next active weapon slot (making others invalid).
 * - If next slot is weaponless, don't label jump.
 *
 *   Targets:
 *   - Select unit(s) to change the next active weapon slot for.
 *
 * ---
 *
 * WEAPON: Set Weapon Slot
 * - Sets the active weapon slot (making others invalid).
 * - Only works for Actors.
 *
 *   Targets:
 *   - Select unit(s) to change the active weapon slot for.
 *
 *   Weapon Slot ID:
 *   - Select weapon slot to make active (making others invalid).
 *   - Use 0 to clear and normalize. You may use JavaScript code.
 *
 * ---
 *
 * === Action Sequences - Zoom ===
 *
 * These Action Sequences are zoom-related.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * ---
 *
 * ZOOM: Change Scale
 * - Changes the zoom scale.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 *   Scale:
 *   - The zoom scale to change to.
 *
 *   Duration:
 *   - Duration in frames to reset battle zoom.
 *
 *   Zoom Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Zoom?
 *   - Wait for zoom changes to complete before performing next command?
 *
 * ---
 *
 * ZOOM: Reset Zoom
 * - Reset any zoom settings.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 *   Duration:
 *   - Duration in frames to reset battle zoom.
 *
 *   Zoom Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Zoom?
 *   - Wait for zoom changes to complete before performing next command?
 *
 * ---
 *
 * ZOOM: Wait For Zoom
 * - Waits for zoom changes to complete before performing next command.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Auto Battle Settings
 * ============================================================================
 *
 * These Plugin Parameter settings allow you to change the aspects added by
 * this plugin that support Auto Battle and the Auto Battle commands.
 *
 * Auto Battle commands can be added to the Party Command Window and/or Actor
 * Command Window. The one used by the Party Command Window will cause the
 * whole party to enter an Auto Battle state until stopped by a button input.
 * The command used by the Actor Command Window, however, will cause the actor
 * to select an action based off the Auto Battle A.I. once for the current turn
 * instead.
 *
 * ---
 *
 * Battle Display
 * 
 *   Message:
 *   - Message that's displayed when Auto Battle is on.
 *     Text codes allowed. %1 - OK button, %2 - Cancel button
 * 
 *   OK Button:
 *   - Text used to represent the OK button.
 *   - If VisuMZ_0_CoreEngine is present, ignore this.
 * 
 *   Cancel Button:
 *   - Text used to represent the Cancel button.
 *   - If VisuMZ_0_CoreEngine is present, ignore this.
 * 
 *   Background Type:
 *   - Select background type for Auto Battle window.
 *     - 0 - Window
 *     - 1 - Dim
 *     - 2 - Transparent
 * 
 *   JS: X, Y, W, H:
 *   - Code used to determine the dimensions for this window.
 *
 * ---
 *
 * Options
 * 
 *   Add Option?:
 *   - Add the Auto Battle options to the Options menu?
 * 
 *   Adjust Window Height:
 *   - Automatically adjust the options window height?
 * 
 *   Startup Name:
 *   - Command name of the option.
 * 
 *   Style Name:
 *   - Command name of the option.
 * 
 *   OFF:
 *   - Text displayed when Auto Battle Style is OFF.
 * 
 *   ON:
 *   - Text displayed when Auto Battle Style is ON.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Damage Settings
 * ============================================================================
 *
 * These Plugin Parameters add a variety of things to how damage is handled in
 * battle. These range from hard damage caps to soft damage caps to how damage
 * popups appear, how the formulas for various aspects are handled and more.
 *
 * Damage Styles are also a feature added through this plugin. More information
 * can be found in the help section above labeled 'Damage Styles'.
 *
 * ---
 *
 * Damage Styles
 * 
 *   Default Style:
 *   - Which Damage Style do you want to set as default?
 *   - Use 'Manual' to not use any styles at all.
 *     - The 'Manual' style will not support <Armor Penetration> notetags.
 *     - The 'Manual' style will not support <Armor Reduction> notetags.
 * 
 *   Style List:
 *   - A list of the damage styles available.
 *   - These are used to calculate base damage.
 * 
 *     Name:
 *     - Name of this Damage Style.
 *     -Used for notetags and such.
 * 
 *     JS: Formula:
 *     - The base formula for this Damage Style.
 * 
 *     Items & Equips Core:
 * 
 *       HP Damage:
 *       MP Damage:
 *       HP Recovery:
 *       MP Recovery:
 *       HP Drain:
 *       MP Drain:
 *       - Vocabulary used for this data entry.
 * 
 *       JS: Damage Display:
 *       - Code used the data displayed for this category.
 *
 * ---
 *
 * Damage Cap
 * 
 *   Enable Damage Cap?:
 *   - Put a maximum hard damage cap on how far damage can go?
 *   - This can be broken through the usage of notetags.
 * 
 *   Default Hard Cap:
 *   - The default hard damage cap used before applying damage.
 * 
 *   Enable Soft Cap?:
 *   - Soft caps ease in the damage values leading up to the  hard damage cap.
 *   - Requires hard Damage Cap enabled.
 * 
 *     Base Soft Cap Rate:
 *     - The default soft damage cap used before applying damage.
 * 
 *     Soft Scale Constant:
 *     - The default soft damage cap used before applying damage.
 *
 * ---
 *
 * Popups
 * 
 *   Popup Duration:
 *   - Adjusts how many frames a popup stays visible.
 * 
 *   Newest Popups Bottom:
 *   - Puts the newest popups at the bottom.
 * 
 *   Offset X:
 *   Offset Y:
 *   - Sets how much to offset the sprites by horizontally/vertically.
 * 
 *   Shift X:
 *   Shift Y:
 *   - Sets how much to shift the sprites by horizontally/vertically.
 * 
 *   Shift Y:
 * 
 *   Critical Flash Color:
 *   - Adjust the popup's flash color.
 *   - Format: [red, green, blue, alpha]
 * 
 *   Critical Duration:
 *   - Adjusts how many frames a the flash lasts.
 *
 * ---
 *
 * Formulas
 * 
 *   JS: Overall Formula:
 *   - The overall formula used when calculating damage.
 * 
 *   JS: Variance Formula:
 *   - The formula used when damage variance.
 * 
 *   JS: Guard Formula:
 *   - The formula used when damage is guarded.
 *
 * ---
 *
 * Critical Hits
 * 
 *   JS: Rate Formula:
 *   - The formula used to calculate Critical Hit Rates.
 * 
 *   JS: Damage Formula:
 *   - The formula used to calculate Critical Hit Damage modification.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Mechanics Settings
 * ============================================================================
 *
 * Some of the base settings for the various mechanics found in the battle
 * system can be altered here in these Plugin Parameters. Most of these will
 * involve JavaScript code and require you to have to good understanding of
 * how the RPG Maker MZ code works before tampering with it.
 *
 * ---
 *
 * Action Speed
 * 
 *   Allow Random Speed?:
 *   - Allow speed to be randomized base off the user's AGI?
 * 
 *   JS: Calculate:
 *   - Code used to calculate action speed.
 *
 * ---
 *
 * Base Troop
 * 
 *   Base Troop ID's:
 *   - Select the Troop ID(s) to duplicate page events from for all
 *     other troops.
 *   - More information can be found in the dedicated Help section above.
 *
 * ---
 * 
 * Common Events (on Map)
 * 
 *   Pre-Battle Event:
 *   Post-Battle Event:
 *   Victory Event:
 *   Defeat Event:
 *   Escape Success Event:
 *   Escape Fail Event:
 *   - Queued Common Event to run upon meeting the condition.
 *   - Use to 0 to not run any Common Event at all.
 *   - "Post-Battle Event" will always run regardless.
 *   - If any events are running before the battle, they will continue running
 *     to the end first before the queued Common Events will run.
 *   - These common events only run on the map scene. They're not meant to run
 *     in the battle scene.
 *   - If the "Defeat Event" has a common event attached to it, then random
 *     encounters will be changed to allow defeat without being sent to the
 *     Game Over scene. Instead, the game will send the player to the map scene
 *     where the Defeat Event will run.
 *
 * ---
 *
 * Escape
 * 
 *   JS: Calc Escape Ratio:
 *   - Code used to calculate the escape success ratio.
 * 
 *   JS: Calc Escape Raise:
 *   - Code used to calculate how much the escape success ratio raises upon
 *     each failure.
 * 
 * ---
 * 
 * Switches
 * 
 *   Switch: Critical:
 *   - Turns switch ON if the action performs a critical hit.
 *   - Switch reverts to OFF whenever an action starts.
 *   - If multiple targets/hits are struck, as long as one hit lands a critical
 *     hit, then the switch will remain ON for the rest of the action.
 * 
 *   Switch: Miss/Evade:
 *   - Turns switch ON if the action misses/is evaded.
 *   - Switch reverts to OFF whenever an action starts.
 *   - If multiple targets/hits are struck, as long as one hit fails to land,
 *     then the switch will remain ON for the rest of the action.
 * 
 * ---
 * 
 * Variables
 * 
 *   Variable: Damage:
 *   - Variable records target damage during action.
 *   - Variable reverts to 0 whenever an action starts.
 *   - If multiple targets/hits are struck, the variable will record the total
 *     amount of damage done for the remainder of the action (unless manually
 *     reseting to 0 during an Action Sequence).
 * 
 *   Variable: Healing:
 *   - Variable records target healing during action.
 *   - Variable reverts to 0 whenever an action starts.
 *   - If multiple targets/hits are struck, the variable will record the total
 *     amount of healing done for the remainder of the action (unless manually
 *     reseting to 0 during an Action Sequence).
 * 
 * ---
 *
 * JS: Battle-Related
 * 
 *   JS: Pre-Start Battle:
 *   - Target function: BattleManager.startBattle()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Post-Start Battle:
 *   - Target function: BattleManager.startBattle()
 *   - JavaScript code occurs after function is run.
 * 
 *   JS: Battle Victory:
 *   - Target function: BattleManager.processVictory()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Escape Success:
 *   - Target function: BattleManager.onEscapeSuccess()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Escape Failure:
 *   - Target function: BattleManager.onEscapeFailure()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Battle Defeat:
 *   - Target function: BattleManager.processDefeat()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Pre-End Battle:
 *   - Target function: BattleManager.endBattle()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Post-End Battle:
 *   - Target function: BattleManager.endBattle()
 *   - JavaScript code occurs after function is run.
 *
 * ---
 *
 * JS: Turn-Related
 * 
 *   JS: Pre-Start Turn:
 *   - Target function: BattleManager.startTurn()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Post-Start Turn:
 *   - Target function: BattleManager.startTurn()
 *   - JavaScript code occurs after function is run.
 * 
 *   JS: Pre-End Turn:
 *   - Target function: Game_Battler.prototype.onTurnEnd()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Post-End Turn:
 *   - Target function: Game_Battler.prototype.onTurnEnd()
 *   - JavaScript code occurs after function is run.
 * 
 *   JS: Pre-Regenerate:
 *   - Target function: Game_Battler.prototype.regenerateAll()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Post-Regenerate:
 *   - Target function: Game_Battler.prototype.regenerateAll()
 *   - JavaScript code occurs after function is run.
 *
 * ---
 *
 * JS: Action-Related
 * 
 *   JS: Pre-Start Action:
 *   - Target function: BattleManager.startAction()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Post-Start Action:
 *   - Target function: BattleManager.startAction()
 *   - JavaScript code occurs after function is run.
 * 
 *   JS: Pre-Apply:
 *   - Target function: Game_Action.prototype.apply()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Pre-Damage:
 *   - Target function: Game_Action.prototype.executeDamage()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Post-Damage:
 *   - Target function: Game_Action.prototype.executeDamage()
 *   - JavaScript code occurs after function is run.
 * 
 *   JS: Post-Apply:
 *   - Target function: Game_Action.prototype.apply()
 *   - JavaScript code occurs after function is run.
 * 
 *   JS: Pre-End Action:
 *   - Target function: BattleManager.endAction()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Post-End Action:
 *   - DescriTarget function: BattleManager.endAction()
 *   - JavaScript code occurs after function is run.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Battle Layout Settings
 * ============================================================================
 *
 * The Battle Layout Settings Plugin Parameter gives you control over the look,
 * style, and appearance of certain UI elements. These range from the way the
 * Battle Status Window presents its information to the way certain windows
 * like the Party Command Window and Actor Command Window appear.
 *
 * ---
 *
 * Battle Layout Style
 * - The style used for the battle layout.
 * 
 *   Default:
 *   - Shows actor faces in Battle Status.
 * 
 *   List:
 *   - Lists actors in Battle Status.
 * 
 *   XP:
 *   - Shows actor battlers in a stretched Battle Status.
 * 
 *   Portrait:
 *   - Shows portraits in a stretched Battle Status.
 * 
 *   Border:
 *   - Displays windows around the screen border.
 *
 * ---
 *
 * List Style
 * 
 *   Show Faces:
 *   - Shows faces in List Style?
 * 
 *   Command Window Width:
 *   - Determine the window width for the Party and Actor Command Windows.
 *   - Affects Default and List Battle Layout styles.
 *
 * ---
 *
 * XP Style
 * 
 *   Command Lines:
 *   - Number of action lines in the Actor Command Window for the XP Style.
 * 
 *   Sprite Height:
 *   - Default sprite height used when if the sprite's height has not been
 *     determined yet.
 * 
 *   Sprite Base Location:
 *   - Determine where the sprite is located on the Battle Status Window.
 *     - Above Name - Sprite is located above the name.
 *     - Bottom - Sprite is located at the bottom of the window.
 *     - Centered - Sprite is centered in the window.
 *     - Top - Sprite is located at the top of the window.
 *
 * ---
 *
 * Portrait Style
 * 
 *   Show Portraits?:
 *   - Requires VisuMZ_1_MainMenuCore.
 *   - Shows the actor's portrait instead of a face.
 * 
 *   Portrait Scaling:
 *   - If portraits are used, scale them by this much.
 *
 * ---
 *
 * Border Style
 * 
 *   Columns:
 *   - The total number of columns for Skill & Item Windows in the battle scene
 * 
 *   Show Portraits?:
 *   - Requires VisuMZ_1_MainMenuCore.
 *   - Shows the actor's portrait at the edge of the screen.
 * 
 *   Portrait Scaling:
 *   - If portraits are used, scale them by this much.
 *
 * ---
 *
 * Skill & Item Windows
 * 
 *   Middle Layout:
 *   - Shows the Skill & Item Windows in mid-screen?
 * 
 *   Columns:
 *   - The total number of columns for Skill & Item Windows in the battle scene
 *
 * ---
 * 
 * Status Window Elements
 * 
 *   Battler Name:
 *   Gauge 1 (HP):
 *   Gauge 2 (MP):
 *   Gauge 3 (TP):
 *   State Icon:
 *   TPB/ATB Gauge:
 * 
 *     Offset: X/Y:
 *     - Offset this Battle Status Window element's X/Y.
 *     - For X: Negative goes left. Positive goes right.
 *     - For Y: Negative goes up. Positive goes down.
 * 
 *   Window Skin:
 * 
 *     Filename:
 *     - Filename used for the Battle Status Window skin.
 *     - Leave this empty to use the default window skin.
 * 
 *     Hide Window Skin?:
 *     - Hide the window skin for the Battle Status Window?
 * 
 *   Selectable Background:
 * 
 *     Hide Selectable BG?:
 *     - Show/Hide the selectable background box for the Battle Status Window?
 * 
 *   Attachments:
 * 
 *     Back Attachment:
 * 
 *       Filename:
 *       - Filename used for an image to attach to the back of the Battle
 *         Status Window. Leave empty for none.
 * 
 *       Offset: X/Y:
 *       - Offset this Battle Status Window element's X/Y.
 *       - For X: Negative goes left. Positive goes right.
 *       - For Y: Negative goes up. Positive goes down.
 * 
 *     Front Attachment:
 * 
 *       Filename:
 *       - Filename used for an image to attach to the front of the Battle
 *         Status Window. Leave empty for none.
 * 
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Battle Log Settings
 * ============================================================================
 *
 * These Plugin Parameters give you control over how the Battle Log Window, the
 * window shown at the top of the screen in the battle layout, appears, its
 * various properties, and which text will be displayed.
 *
 * The majority of the text has been disabled by default with this plugin to
 * make the flow of battle progress faster.
 *
 * ---
 *
 * General
 * 
 *   Back Color:
 *   - Use #rrggbb for a hex color.
 * 
 *   Max Lines:
 *   - Maximum number of lines to be displayed.
 * 
 *   Message Wait:
 *   - Number of frames for a usual message wait.
 * 
 *   Text Align:
 *   - Text alignment for the Window_BattleLog.
 * 
 *   JS: X, Y, W, H:
 *   - Code used to determine the dimensions for the battle log.
 *
 * ---
 *
 * Start Turn
 * 
 *   Show Start Turn?:
 *   - Display turn changes at the start of the turn?
 * 
 *   Start Turn Message:
 *   - Message displayed at turn start.
 *   - %1 - Turn Count
 * 
 *   Start Turn Wait:
 *   - Number of frames to wait after a turn started.
 *
 * ---
 *
 * Display Action
 * 
 *   Show Centered Action?:
 *   - Display a centered text of the action name?
 * 
 *   Show Skill Message 1?:
 *   - Display the 1st skill message?
 * 
 *   Show Skill Message 2?:
 *   - Display the 2nd skill message?
 * 
 *   Show Item Message?:
 *   - Display the item use message?
 *
 * ---
 *
 * Action Changes
 * 
 *   Show Counter?:
 *   - Display counter text?
 * 
 *   Show Reflect?:
 *   - Display magic reflection text?
 * 
 *   Show Substitute?:
 *   - Display substitute text?
 *
 * ---
 *
 * Action Results
 * 
 *   Show No Effect?:
 *   - Display no effect text?
 * 
 *   Show Critical?:
 *   - Display critical text?
 * 
 *   Show Miss/Evasion?:
 *   - Display miss/evasion text?
 * 
 *   Show HP Damage?:
 *   - Display HP Damage text?
 * 
 *   Show MP Damage?:
 *   - Display MP Damage text?
 * 
 *   Show TP Damage?:
 *   - Display TP Damage text?
 *
 * ---
 *
 * Display States
 * 
 *   Show Added States?:
 *   - Display added states text?
 * 
 *   Show Removed States?:
 *   - Display removed states text?
 * 
 *   Show Current States?:
 *   - Display the currently affected state text?
 * 
 *   Show Added Buffs?:
 *   - Display added buffs text?
 * 
 *   Show Added Debuffs?:
 *   - Display added debuffs text?
 * 
 *   Show Removed Buffs?:
 *   - Display removed de/buffs text?
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Battleback Scaling Settings
 * ============================================================================
 *
 * By default, the battlebacks in RPG Maker MZ scale as if the screen size is
 * a static 816x624 resolution, which isn't always the case. These settings
 * here allow you to dictate how you want the battlebacks to scale for the
 * whole game. These settings CANNOT be changed midgame or per battle.
 *
 * ---
 *
 * Settings
 * 
 *   Default Style:
 *   - The default scaling style used for battlebacks.
 *   - MZ (MZ's default style)
 *   - 1:1 (No Scaling)
 *   - Scale To Fit (Scale to screen size)
 *   - Scale Down (Scale Downward if Larger than Screen)
 *   - Scale Up (Scale Upward if Smaller than Screen)
 * 
 *   JS: 1:1:
 *   JS: Scale To Fit:
 *   JS: Scale Down:
 *   JS: Scale Up:
 *   JS: 1:1:
 *   JS: 1:1:
 *   - This code gives you control over the scaling for this style.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Party Command Window
 * ============================================================================
 *
 * These Plugin Parameters allow you control over how the Party Command Window
 * operates in the battle scene. You can turn disable it from appearing or make
 * it so that it doesn't 
 *
 * ---
 *
 * Command Window
 * 
 *   Style:
 *   - How do you wish to draw commands in the Party Command Window?
 *   - Text Only: Display only the text.
 *   - Icon Only: Display only the icon.
 *   - Icon + Text: Display the icon first, then the text.
 *   - Auto: Determine which is better to use based on the size of the cell.
 * 
 *   Text Align:
 *   - Text alignment for the Party Command Window.
 * 
 *   Fight Icon:
 *   - The icon used for the Fight command.
 * 
 *   Add Auto Battle?:
 *   - Add the "Auto Battle" command to the Command Window?
 * 
 *     Auto Battle Icon:
 *     - The icon used for the Auto Battle command.
 * 
 *     Auto Battle Text:
 *     - The text used for the Auto Battle command.
 * 
 *   Add Options?:
 *   - Add the "Options" command to the Command Window?
 * 
 *     Options Icon:
 *     - The icon used for the Options command.
 * 
 *     Active TPB Message:
 *     - Message that will be displayed when selecting options during the
 *       middle of an action.
 * 
 *   Escape Icon:
 *   - The icon used for the Escape command.
 *
 * ---
 *
 * Access
 * 
 *   Skip Party Command:
 *   - DTB: Skip Party Command selection on turn start.
 *   - TPB: Skip Party Command selection at battle start.
 * 
 *   Disable Party Command:
 *   - Disable the Party Command Window entirely?
 *
 * ---
 *
 * Help Window
 * 
 *   Fight:
 *   - Text displayed when selecting a skill type.
 *   - %1 - Skill Type Name
 * 
 *   Auto Battle:
 *   - Text displayed when selecting the Auto Battle command.
 * 
 *   Options:
 *   - Text displayed when selecting the Options command.
 * 
 *   Escape:
 *   - Text displayed when selecting the escape command.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Actor Command Window
 * ============================================================================
 *
 * These Plugin Parameters allow you to change various aspects regarding the
 * Actor Command Window and how it operates in the battle scene. This ranges
 * from how it appears to the default battle commands given to all players
 * without a custom <Battle Commands> notetag.
 *
 * ---
 *
 * Command Window
 * 
 *   Style:
 *   - How do you wish to draw commands in the Actor Command Window?
 *   - Text Only: Display only the text.
 *   - Icon Only: Display only the icon.
 *   - Icon + Text: Display the icon first, then the text.
 *   - Auto: Determine which is better to use based on the size of the cell.
 * 
 *   Text Align:
 *   - Text alignment for the Actor Command Window.
 * 
 *   Item Icon:
 *   - The icon used for the Item command.
 * 
 *   Normal SType Icon:
 *   - Icon used for normal skill types that aren't assigned any icons.
 *   - Ignore if VisuMZ_1_SkillsStatesCore is installed.
 * 
 *   Magic SType Icon:
 *   - Icon used for magic skill types that aren't assigned any icons.
 *   - Ignore if VisuMZ_1_SkillsStatesCore is installed.
 *
 * ---
 *
 * Battle Commands
 * 
 *   Command List:
 *   - List of battle commands that appear by default if the <Battle Commands>
 *     notetag isn't present.
 *
 *     - Attack 
 *       - Adds the basic attack command.
 * 
 *     - Skills
 *       - Displays all the skill types available to the actor.
 * 
 *     - SType: x
 *     - Stype: name
 *       - Adds in a specific skill type.
 *       - Replace 'x' with the ID of the skill type.
 *       - Replace 'name' with the name of the skill type (without text codes).
 *
 *     - All Skills
 *       - Adds all usable battle skills as individual actions.
 * 
 *     - Skill: x
 *     - Skill: name
 *       - Adds in a specific skill as a usable action.
 *       - Replace 'x' with the ID of the skill.
 *       - Replace 'name' with the name of the skill.
 * 
 *     - Guard
 *       - Adds the basic guard command.
 * 
 *     - Item
 *       - Adds the basic item command.
 * 
 *     - Escape
 *       - Adds the escape command.
 * 
 *     - Auto Battle
 *       - Adds the auto battle command.
 * 
 *     - Party
 *       - Requires VisuMZ_2_PartySystem!
 *       - Switches out the current actor for another.
 * 
 *     - Combat Log
 *       - Requires VisuMZ_4_CombatLog!
 *       - Shows combat log.
 * 
 *     - Talk
 *       - Requires VisuMZ_3_BattleCmdTalk!
 *       - Shows talk command if applicable.
 * 
 *     - Weapon Swap
 *       - Requires VisuMZ_2_WeaponSwapSystem!
 *       - Swaps current weapon for next one.
 * 
 *   Show Command Costs:
 *   - If a battle command has a resource cost, show it?
 *
 * ---
 *
 * Help Window
 * 
 *   Skill Types:
 *   - Text displayed when selecting a skill type.
 *   - %1 - Skill Type Name
 * 
 *   Items:
 *   - Text displayed when selecting the item command.
 * 
 *   Escape:
 *   - Text displayed when selecting the escape command.
 * 
 *   Auto Battle:
 *   - Text displayed when selecting the Auto Battle command.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Actor Battler Settings
 * ============================================================================
 *
 * These Plugin Parameter settings adjust how the sideview battlers behave for
 * the actor sprites. Some of these settings are shared with enemies if they
 * use sideview battler graphics.
 *
 * ---
 *
 * Flinch
 * 
 *   Flinch Distance X:
 *   - The normal X distance when flinching.
 * 
 *   Flinch Distance Y:
 *   - The normal Y distance when flinching.
 * 
 *   Flinch Duration:
 *   - The number of frames for a flinch to complete.
 *
 * ---
 *
 * Sideview Battlers
 * 
 *   Anchor: X:
 *   - Default X anchor for Sideview Battlers.
 * 
 *   Anchor: Y:
 *   - Default Y anchor for Sideview Battlers.
 * 
 *   Chant Style:
 *   - What determines the chant motion?
 *   - Hit type or skill type?
 * 
 *   Offset X:
 *   - Offsets X position where actor is positioned.
 *   - Negative values go left. Positive values go right.
 * 
 *   Offset Y:
 *   - Offsets Y position where actor is positioned.
 *   - Negative values go up. Positive values go down.
 * 
 *   Motion Speed:
 *   - The number of frames in between each motion.
 * 
 *   Priority: Active:
 *   - Place the active actor on top of actor and enemy sprites.
 * 
 *   Priority: Actors:
 *   - Prioritize actors over enemies when placing sprites on top of each other
 * 
 *   Shadow Visible:
 *   - Show or hide the shadow for Sideview Battlers.
 * 
 *   Smooth Image:
 *   - Smooth out the battler images or pixelate them?
 * 
 *   JS: Home Position:
 *   - Code used to calculate the home position of actors.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Enemy Battler Settings
 * ============================================================================
 *
 * These Plugin Parameter settings adjust how enemies appear visually in the
 * battle scene. Some of these settings will override the settings used for
 * actors if used as sideview battlers. Other settings include changing up the
 * default attack animation for enemies, how the enemy select window functions,
 * and more.
 *
 * ---
 *
 * Visual
 * 
 *   Attack Animation:
 *   - Default attack animation used for enemies.
 *   - Use <Attack Animation: x> for custom animations.
 * 
 *   Emerge Text:
 *   - Show or hide the 'Enemy emerges!' text at the start of battle.
 * 
 *   Offset X:
 *   - Offsets X position where enemy is positioned.
 *   - Negative values go left. Positive values go right.
 * 
 *   Offset Y:
 *   - Offsets Y position where enemy is positioned.
 *   - Negative values go up. Positive values go down.
 * 
 *   Smooth Image:
 *   - Smooth out the battler images or pixelate them?
 *
 * ---
 *
 * Select Window
 * 
 *   Any: Last Selected:
 *   - Prioritize last selected enemy over front view or sideview settings?
 * 
 *   FV: Right Priority:
 *   - If using frontview, auto select the enemy furthest right.
 * 
 *   SV: Right Priority:
 *   - If using sideview, auto select the enemy furthest right.
 * 
 * ---
 * 
 * Name:
 * 
 *   Legacy Option:
 *   - Use the legacy version (window) or new version (sprite).
 *   - WARNING: Legacy version is no longer supported for bugs.
 *   - Not all settings available here in the Plugin Parameters will be
 *     available to the legacy version (ie Always Visible and Attach States).
 * 
 *   Font Size:
 *   - Font size used for enemy names.
 * 
 *   Name Position:
 * 
 *     Offset X:
 *     Offset Y:
 *     - Offset the enemy name's position by this much.
 *     - For X: Negative goes left. Positive goes right.
 *     - For Y: Negative goes up. Positive goes down.
 * 
 *   Name: Attach States:
 *   - Attach the enemy's state icon to the enemy name?
 * 
 *     Attach: Offset X:
 *     Attach: Offset Y:
 *     - How much to offset the attached icon's X/Y position by?
 *     - For X: Negative goes left. Positive goes right.
 *     - For Y: Negative goes up. Positive goes down.
 * 
 *   Name Visibility:
 * 
 *     Always Hidden:
 *     - Determines if the enemy name will always be visible.
 *     - Highest priority.
 * 
 *     Always Visible:
 *     - Determines if the enemy name will always be visible.
 *     - Medium priority.
 * 
 *     By Selection?:
 *     - Determines the conditions for enemy name visibility.
 *     - Lowest priority.
 *
 * ---
 *
 * Sideview Battlers
 * 
 *   Allow Collapse:
 *   - Causes defeated enemies with SV Battler graphics to "fade away"
 *     when defeated?
 * 
 *   Anchor: X:
 *   - Default X anchor for Sideview Battlers.
 *   - Use values between 0 and 1 to be safe.
 * 
 *   Anchor: Y:
 *   - Default Y anchor for Sideview Battlers.
 *   - Use values between 0 and 1 to be safe.
 * 
 *   Motion: Idle:
 *   - Sets default idle animation used by Sideview Battlers.
 * 
 *   Shadow Visible:
 *   - Show or hide the shadow for Sideview Battlers.
 * 
 *   Size: Width:
 *   - Default width for enemies that use Sideview Battlers.
 * 
 *   Size: Height:
 *   - Default height for enemies that use Sideview Battlers.
 * 
 *   Weapon Type:
 *   - Sets default weapon type used by Sideview Battlers.
 *   - Use 0 for Bare Hands.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: HP Gauge Settings
 * ============================================================================
 *
 * Settings that adjust the visual HP Gauge displayed in battle.
 *
 * ---
 *
 * Show Gauges For
 * 
 *   Actors:
 *   - Show HP Gauges over the actor sprites' heads?
 *   - Requires SV Actors to be visible.
 * 
 *   Enemies:
 *   - Show HP Gauges over the enemy sprites' heads?
 *   - Can be bypassed with <Hide HP Gauge> notetag.
 * 
 *     Requires Defeat?:
 *     - Requires defeating the enemy once to show HP Gauge?
 *     - Can be bypassed with <Show HP Gauge> notetag.
 * 
 *       Battle Test Bypass?:
 *       - Bypass the defeat requirement in battle test?
 *
 * ---
 *
 * Settings
 * 
 *   Anchor X:
 *   Anchor Y:
 *   - Where do you want the HP Gauge sprite's anchor X/Y to be?
 *     Use values between 0 and 1 to be safe.
 * 
 *   Scale:
 *   - How large/small do you want the HP Gauge to be scaled?
 * 
 *   Offset X:
 *   Offset Y:
 *   - How many pixels to offset the HP Gauge's X/Y by?
 *
 * ---
 *
 * Options
 * 
 *   Add Option?:
 *   - Add the 'Show HP Gauge' option to the Options menu?
 * 
 *   Adjust Window Height:
 *   - Automatically adjust the options window height?
 * 
 *   Option Name:
 *   - Command name of the option.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Action Sequence Settings
 * ============================================================================
 *
 * Action Sequence Plugin Parameters allow you to decide if you want automatic
 * Action Sequences to be used for physical attacks, the default casting
 * animations used, how counters and reflects appear visually, and what the
 * default stepping distances are.
 *
 * ---
 *
 * Automatic Sequences
 * 
 *   Melee Single Target:
 *   - Allow this auto sequence for physical, single target actions?
 * 
 *   Melee Multi Target:
 *   - Allow this auto sequence for physical, multi-target actions?
 *
 * ---
 * 
 * Quality of Life
 * 
 *   Auto Notetag:
 *   - Automatically apply the <Custom Action Sequence> notetag effect to any
 *     item or skill that has a Common Event?
 *   - Any item or skill without a Common Event attached to it will use the
 *     Automatic Action Sequences instead.
 *   - The <Auto Action Sequence> notetag will disable this effect for that
 *     particular skill or item.
 * 
 * ---
 *
 * Cast Animations
 * 
 *   Certain Hit:
 *   - Cast animation for Certain Hit skills.
 * 
 *   Physical:
 *   - Cast animation for Physical skills.
 * 
 *   Magical:
 *   - Cast animation for Magical skills.
 *
 * ---
 *
 * Counter/Reflect
 * 
 *   Counter Back:
 *   - Play back the attack animation used?
 * 
 *   Reflect Animation:
 *   - Animation played when an action is reflected.
 * 
 *   Reflect Back:
 *   - Play back the attack animation used?
 *
 * ---
 *
 * Stepping
 * 
 *   Melee Distance:
 *   - Minimum distance in pixels for Movement Action Sequences.
 * 
 *   Step Distance X:
 *   - The normal X distance when stepping forward.
 * 
 *   Step Distance Y:
 *   - The normal Y distance when stepping forward.
 * 
 *   Step Duration:
 *   - The number of frames for a stepping action to complete.
 *
 * ---
 *
 * ============================================================================
 * Terms of Use
 * ============================================================================
 *
 * 1. These plugins may be used in free or commercial games provided that they
 * have been acquired through legitimate means at VisuStella.com and/or any
 * other official approved VisuStella sources. Exceptions and special
 * circumstances that may prohibit usage will be listed on VisuStella.com.
 * 
 * 2. All of the listed coders found in the Credits section of this plugin must
 * be given credit in your games or credited as a collective under the name:
 * "VisuStella".
 * 
 * 3. You may edit the source code to suit your needs, so long as you do not
 * claim the source code belongs to you. VisuStella also does not take
 * responsibility for the plugin if any changes have been made to the plugin's
 * code, nor does VisuStella take responsibility for user-provided custom code
 * used for custom control effects including advanced JavaScript notetags
 * and/or plugin parameters that allow custom JavaScript code.
 * 
 * 4. You may NOT redistribute these plugins nor take code from this plugin to
 * use as your own. These plugins and their code are only to be downloaded from
 * VisuStella.com and other official/approved VisuStella sources. A list of
 * official/approved sources can also be found on VisuStella.com.
 *
 * 5. VisuStella is not responsible for problems found in your game due to
 * unintended usage, incompatibility problems with plugins outside of the
 * VisuStella MZ library, plugin versions that aren't up to date, nor
 * responsible for the proper working of compatibility patches made by any
 * third parties. VisuStella is not responsible for errors caused by any
 * user-provided custom code used for custom control effects including advanced
 * JavaScript notetags and/or plugin parameters that allow JavaScript code.
 *
 * 6. If a compatibility patch needs to be made through a third party that is
 * unaffiliated with VisuStella that involves using code from the VisuStella MZ
 * library, contact must be made with a member from VisuStella and have it
 * approved. The patch would be placed on VisuStella.com as a free download
 * to the public. Such patches cannot be sold for monetary gain, including
 * commissions, crowdfunding, and/or donations.
 *
 * ============================================================================
 * Credits
 * ============================================================================
 * 
 * If you are using this plugin, credit the following people in your game:
 * 
 * Team VisuStella
 * * Yanfly
 * * Arisu
 * * Olivia
 * * Irina
 *
 * ============================================================================
 * Changelog
 * ============================================================================
 * 
 * Version 1.48: October 21, 2021
 * * Feature Update!
 * ** Animations are now played on top of battlers in the Front View XP Battle
 *    Layout appearance. Update made by Irina.
 * ** Battle Log, if decided to be shown, now updates faster. Update by Irina.
 * ** Default Critical Damage Bonus increase is now updated to account for
 *    HP Healing and MP Recovery. To update this, create a new project, with
 *    the newest version of Battle Core installed. Copy over the Plugin
 *    Parameters for the Damage Settings > Critical Hits > JS: Damage Formula
 *    to your own project's version. Update made by Irina.
 * 
 * Version 1.47: October 14, 2021
 * * Compatibility Update!
 * ** Added compatibility functionality for future plugins.
 * * Feature Update!
 * ** Back attachment sprites are now automatically updated with sprite
 *    battlers to be shifted towards the very back.
 * 
 * Version 1.46: September 23, 2021
 * * Bug Fixes!
 * ** Fixed problem with skills and items without action sequences preventing
 *    actions from occurring. Fix made by Yanfly.
 * 
 * Version 1.45: September 17, 2021
 * * Bug Fixes!
 * ** <JS Pre-End Action> and <JS Post-End Action> effects now have multiple
 *    checks to make sure that they don't launch multiple times when a battler
 *    without actions has a turn after one that does. Fix made by Olivia.
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Action Sequence notetags added by Yanfly and Arisu:
 * *** <Common Event Key: name>
 * *** <Common Event Keys: name, name, name>
 * *** <Common Event Keys>
 *      key
 *      key
 *      key
 *     </Common Event Keys>
 * **** Will generate Common Events for the skill/item with a corresponding
 *      key.
 * **** More information will be explained inside of the help file.
 * **** This feature is made for make the process of sharing Action Sequences
 *      to become easier without needing to line up Common Event ID's.
 * 
 * Version 1.44: August 20, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Action Sequence added by Irina and sponsored by Anon.
 * *** "ANIM: Play at Coordinate"
 * **** Plays an animation on the screen at a specific x, y coordinate even if
 *      there is no sprite attached.
 * **** Requires VisuMZ_0_CoreEngine!
 * 
 * Version 1.43: July 23, 2021
 * * Feature Update!
 * ** Immortality now works different with instant death mechanics. Skill
 *    effects that apply instant death or attack states that apply instant
 *    death will now trigger a flag instead of cancelling immortality. The
 *    flag will remain until immortality is manually cancelled via Action
 *    Sequence and then proc the death effect. This way, animations can remain
 *    to the end with instant death mechanics in mind. This does not affect
 *    script calls.
 * 
 * Version 1.42: July 16, 2021
 * * Bug Fixes!
 * ** Added another fail safe for empty common events used for pre-battle
 *    common events. Fix made by Olivia.
 * 
 * Version 1.41: July 2, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * ** Added entries to <Battle Command> notetags and Plugin Parameters for
 *    "Party", "Combat Log", and "Weapon Swap" which weren't updated before.
 * * Optimization Update!
 * ** Plugin should run more optimized.
 * * New Features!
 * ** New Action Sequence added by Arisu:
 * *** MECH: Enemy Escape
 * **** Causes the enemy unit(s) to escape.
 * 
 * Version 1.40: June 25, 2021
 * * Bug Fixes!
 * ** Transformations from static enemies to and from animated SV enemies
 *    should no longer show both sprites. Fix made by Irina.
 * * Compatibility Update
 * ** Compatibility update with RPG Maker MZ 1.3.0+.
 * 
 * Version 1.39: June 18, 2021
 * * Bug Fixes!
 * ** MOVE: Home Reset should no longer trigger an end action function and
 *    cause plugins such as "Boost Action" to malfunction. Fix made by Olivia.
 * * Compatibility Update
 * ** Added compatibility functionality for future plugins.
 * * Documentation Update!
 * ** Help file updated for updated features.
 * * Feature Update!
 * ** <Battle Layout: x> Troop Name tags can now work with comment tags. Update
 *    made by Irina.
 * ** Random encounter lists are now better shuffled for more variety with how
 *    the RNG seed works. Update made by Arisu.
 * 
 * Version 1.38: June 11, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * * Feature Updates!
 * ** Location calculations will now be based off the a battler's base position
 *    in order for animations, popups, and other aspects to line up properly
 *    when scaled. Update made by Irina.
 * ** Plugin Parameters for Enemy Battler Settings > Name have been rearranged
 *    for better organization. Update by Olivia.
 * * New Features!
 * ** New Notetags added by Olivia and sponsored by NSG:
 * *** <Sideview Shadow Scale X: x%>
 * *** <Sideview Shadow Scale X: x.y>
 * *** <Sideview Shadow Scale Y: x%>
 * *** <Sideview Shadow Scale Y: x.y>
 * **** These new notetags allow you to adjust the X and Y scale of the SV
 *      shadow sprite separately.
 * ** New Plugin Parameters added by Olivia and sponsored by NSG:
 * *** Enemy Battler Settings > Name > Name Visibility > Always Hidden
 * *** Enemy Battler Settings > Name > Name Visibility > By Selection?
 * **** Choose to have the names always hidden or by selection.
 * **** These are adjusted on a priority list.
 * 
 * Version 1.37: May 21, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New notetags added by Olivia.
 * *** <Command Require Learn>
 * *** <Command Require Access>
 * **** These two commands determine the visibility of a battle command by
 *      whether or not the skill has been learned or accessible.
 * * Feature Update!
 * ** For those using TPB, each battler's regeneration phase will no longer
 *    tick multiple times in a single frame to prevent irregularities. Update
 *    made by Olivia.
 * 
 * Version 1.36: May 14, 2021
 * * Bug Fixes!
 * ** Reversed an HP/MP regeneration bug that was incorrectly reported for TPB.
 *    Fix made by Olivia.
 * * Documentation Update
 * ** Added "TPB/ATB Active Battle Actor Shifting" to Major Changes section:
 * *** This change has been active since the start of this plugin. It was not
 *     documented until now.
 * *** Pressing cancel on the Actor Command Window no longer switches between
 *     actors with a full TPB/ATB gauge before reaching the Party Command
 *     Window. This is to accomplish a couple of things: 1) reduce the number
 *     of button presses to reach the Party Command Window and 2) to prevent
 *     motion resets and disrupting action sequences. If this feature is vital
 *     to your battle system, we recommend that you do not use this plugin or
 *     any of the Battle Core-required plugins.
 * ** Feature Updates
 * *** Distortion sprite Y calculations will now be rounded upward for better
 *     visuals and prevent odd pixelation effects. Update made by Irina.
 * 
 * Version 1.35: May 7, 2021
 * * Bug Fixes!
 * ** Pre-Battle Common Events without a wait command at the end should no
 *    longer lock up by coincidentally pressing the menu key at the same time.
 *    Fix made by Olivia.
 * * Feature Update!
 * ** Added an extra check for TPB-based battle systems to not run turn end
 *    functions when it's not actually the actual turn end timing. Update made
 *    by Olivia.
 * ** "Damage Styles" plugin parameters are now moved to the top of the
 *    Damage Settings category. This should make it easier to acknowledge the
 *    existence of and not have it be an unknown entity. Update made by Irina.
 * 
 * Version 1.34: April 23, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * * Feature Update!
 * ** Uses a better algorithm for determining shadow positioning. Update made
 *    by Olivia.
 * * New Features!
 * ** New additions made for Projectile action sequences.
 * ** "Start Location" and "Goal Location" now have "Target Location" parameter
 *    to determine which part of the target's body to send the projectile from
 *    or towards. Added by Olivia.
 * ** Requires VisuMZ_1_BattleCore version 1.34 to have affect.
 * 
 * Version 1.33: April 9, 2021
 * * Bug Fixes!
 * ** Skill costs should now be displayed on battle commands again. Bug fix
 *    made by Olivia.
 * ** Pre-Battle Common Events should no longer cause stalling when used with
 *    specific event commands. Bug fix made by Olivia.
 * * Compatibility Update!
 * ** Added "Weapon Swap" to the list of battle commands that can be added.
 * * Documentation Update!
 * ** Added "Weapon Swap" and "Combat Log" to the list of <Battle Commands> in
 *    the notetags section.
 * ** Help file updated for new features.
 * * New Features!
 * ** New notetags added by Olivia:
 * *** <Sideview Shadow Scale: x%> and <Sideview Shadow Scale: x.y>
 * **** Used for: Actor, Enemy Notetags
 * **** Adjusts the scaling size of the sideview battler's shadow.
 * 
 * Version 1.32: April 2, 2021
 * * Feature Update!
 * ** Sideview battler sprites when using front view will now factor in the
 *    window padding and appear properly centered to their focus point. Update
 *    made by Olivia.
 * 
 * Version 1.31: March 26, 2021
 * * Compatibility Update!
 * ** Added compatibility functionality for future plugins.
 * * Documentation Update!
 * ** Added "VisuStella MZ Compatibility" section for detailed compatibility
 *    explanations with the VisuMZ_3_BoostAction plugin.
 * 
 * Version 1.30: March 19, 2021
 * * Documentation Update!
 * ** Help file updated for updated features.
 * * Feature Update!
 * ** <JS Targets> is now updated to include the default set of targets
 *    selected by the skill/item's original scope. Update made by Yanfly.
 * *** If you wish to clear it out, simply do 'targets = []' first.
 * 
 * Version 1.29: March 12, 2021
 * * Compatibility Update!
 * ** Added compatibility functionality for future plugins.
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Plugin Parameter added by Olivia:
 * *** Plugin Parameters > Enemy Battler Settings > Name > Legacy Option
 * **** Use the legacy version (window) or new version (sprite).
 * **** WARNING: Legacy version is no longer supported for bugs.
 * **** Not all settings available here in the Plugin Parameters will be
 *      available to the legacy version (ie Always Visible and Attach States).
 * 
 * Version 1.28: March 5, 2021
 * * Compatibility Update!
 * ** Added compatibility functionality for future plugins.
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Plugin Parameters added by Arisu:
 * *** Plugin Parameters > Actor Command > Show Command Costs
 * **** If you don't want to show skill costs for your commands in the Actor
 *      Command Window, you can now hide them.
 * ** New Plugin Parameters added by Irina:
 * *** Plugin Parameters > Battle Layout Settings > Status Window Elements
 * *** Battle Layout Settings > Status Window Elements > Battler Name
 * *** Battle Layout Settings > Status Window Elements > Gauge 1 (HP)
 * *** Battle Layout Settings > Status Window Elements > Gauge 2 (MP)
 * *** Battle Layout Settings > Status Window Elements > Gauge 3 (TP)
 * *** Battle Layout Settings > Status Window Elements > State Icon
 * *** Battle Layout Settings > Status Window Elements > TPB/ATB Gauge
 * **** These new Plugin Parameters allow you to offset the positions of the
 *      various Battle Status Window elements. Their base positions will be
 *      calculated by the Battle Layout used and then offset from there.
 * *** Battle Layout Settings > Status Window Elements > Window Skin
 * **** These settings allow you to set a specific window skin for the
 *      Battle Status Window or hide it from view completely.
 * *** Battle Layout Settings > Status Window Elements > Selectable Background
 * **** This option allows you to hide the black box that comes with the
 *      majority of selectable elements found in RPG Maker MZ in case it does
 *      not fit with how you want the Battle Status Window to look.
 * *** Battle Layout Settings > Status Window Elements > Back Attachment
 * *** Battle Layout Settings > Status Window Elements > Front Attachment
 * **** These settings allow you to attach images to the back/front of the
 *      Battle Status Window from the img/system/ folder.
 * **** You may offset X and Y positions for them as well.
 * ** New Plugin Parameters added by Olivia:
 * *** Plugin Parameters > Enemy Settings > Name: Always Visible
 * **** Determines if the enemy name will always be visible.
 * *** Plugin Parameters > Enemy Settings > Name: Attach States
 * **** Attach the enemy's state icon to the enemy name?
 * *** Plugin Parameters > Enemy Settings > Attach: Offset X/Y
 * **** Offset the attached state icon's position.
 * * Feature Update!
 * ** Switched drawing enemy names on the screen from window to sprite to
 *    reduce lag and for better screen positioning accuracy especially during
 *    screen zooming. Update by Olivia.
 * 
 * Version 1.27: February 26, 2021
 * * Compatibility Update!
 * ** Added compatibility functionality for future plugins.
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Plugin Parameters added by Irina and sponsored by AndyL:
 * *** Plugin Parameters > Mechanics Settings > Switches > Switch: Critical
 * *** Plugin Parameters > Mechanics Settings > Switches > Switch: Miss/Evade
 * **** Turns Switches ON if the action performs a critical hit, misses, or is
 *      evaded at any point.
 * **** Switch reverts to OFF whenever an action starts.
 * **** If multiple targets/hits are struck, as long as one hit respectively
 *      lands a critical hit, fails to land, then the switch will remain ON for
 *      the rest of the action.
 * *** Plugin Parameters > Mechanics Settings > Variables > Variable: Damage
 * *** Plugin Parameters > Mechanics Settings > Variables > Variable: Healing
 * **** Variable records target damage/healing during action.
 * **** Variable reverts to 0 whenever an action starts.
 * **** If multiple targets/hits are struck, the variable will record the total
 *      amount of damage/healing done for the remainder of the action (unless
 *      manually reseting to 0 during an Action Sequence).
 * 
 * Version 1.26: February 19, 2021
 * * Bug Fixes!
 * ** Battles with branching event paths found within a conditional branch or
 *    choice tree will no longer be skipped over. Fix made by Arisu.
 * * Compatibility Update
 * ** Returning to the battle scene from the options scene in a Tpb-base battle
 *    system now links the current actor. Update by Irina.
 * 
 * Version 1.25: February 5, 2021
 * * Compatibility Update
 * ** Added compatibility update with VisuStella MZ Skills and States Core's
 *    Plugin Parameter > State Settings > Action End Update
 * * Feature Update!
 * ** <Common Event: name> notetag no longer requires <Custom Action Sequence>
 *    notetag if the Plugin Parameter: Auto Notetag is enabled.
 * 
 * Version 1.24: January 29, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * * Feature Update!
 * ** MOVE: Move To Point and MOVE: Move To Target(s) Action Sequences'
 *    "Offset Adjustment" normal setting will now factor in Offset X and
 *    Offset Y positions unlike before where it cancels them. Update by Irina.
 * * New Features!
 * ** New notetag added by Arisu:
 * *** <Common Event: name>
 * **** Battle only: calls forth a Common Event of a matching name.
 * **** This is primarily used for users who are reorganizing around their
 *      Common Events and would still like to have their skills/items perform
 *      the correct Action Sequences in case the ID's are different.
 * 
 * Version 1.23: January 22, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * * Feature Update!
 * ** ACSET: All Targets Action Set and ACSET: Each Target Action Set updated
 * *** New parameter added: Dual/Multi Wield?
 * **** Add times struck based on weapon quantity equipped?
 * * New Features!
 * ** Dual Wielding now functions differently. Made by Olivia.
 * *** Previously, RPG Maker MZ had "Dual Wielding" attack using both weapon
 *     animations at once, with the combined ATK of each weapon. It's confusing
 *     to look at and does not portray the nature of "Dual Wielding".
 * *** Dual Wielding, or in the case of users adding in third and fourth
 *     weapons, Multi Wielding is now changed. Each weapon is displayed
 *     individually, each producing its own attack animation, showing each
 *     weapon type, and applying only that weapon's ATK, Traits, and related
 *     effects. It is no longer a combined effect to display everything at once
 *     like RPG Maker MZ default.
 * *** If an actor has multiple weapon slots but some of them are unequipped,
 *     then the action will treat the attack as a single attack. There will be
 *     no barehanded attack to add on top of it. This is to match RPG Maker
 *     MZ's decision to omit a second animation if the same scenario is
 *     applied.
 * ** New Action Sequence Plugin Commands added by Yanfly
 * *** ANIM: Attack Animation 2+
 * **** Plays the animation associated with the user's 2nd weapon.
 *      Plays nothing if there is no 2nd weapon equipped.
 * ** New Action Sequence Plugin Commands added by Olivia
 * *** WEAPON: Clear Weapon Slot
 * *** WEAPON: Next Weapon Slot
 * *** WEAPON: Set Weapon Slot
 * **** These are Action Sequence Plugin Commands for devs who want finer
 *      control over Dual/Multi Wielding weapons.
 * 
 * Version 1.22: January 15, 2021
 * * Compatibility Update
 * ** Compatibility with "All Skills" Actor Command should now work with the
 *    Skills & States Core hide skill notetags.
 * 
 * Version 1.21: January 8, 2021
 * * Bug Fixes!
 * ** "MOVE: Home Reset" Plugin Command Action Sequence should work properly.
 *    Fix made by Yanfly.
 * * Documentation Update!
 * ** Added documentation for new feature(s)!
 * * New Features!
 * ** New Notetag snuck in by Arisu
 * *** <Auto Action Sequence>
 * **** Used for those who have the "Auto Notetag" Plugin Parameter enabled and
 *      just want to use an automatic Action Sequence instead.
 * ** New Plugin Parameter snuck in by Arisu!
 * *** Plugin Parameters > Action Sequences > Quality of Life > Auto Notetag
 * **** Automatically apply the <Custom Action Sequence> notetag effect to any
 *      item or skill that has a Common Event?
 * **** Any item or skill without a Common Event attached to it will use the
 *      Automatic Action Sequences instead.
 * **** The <Auto Action Sequence> notetag will disable this effect for that
 *      particular skill or item.
 * ** Arisu, you're going to be responsible for any bugs these may cause.
 * *** Bring it!!!!
 * **** And handling any bug report emails that are sent because this was
 *      turned on by accident.
 * ***** Please read the documentation, guys!
 * 
 * Version 1.20: January 1, 2021
 * * Bug Fixes!
 * ** For TPB Active or ATB Active, inputting actors that have received damage
 *    will return back to place after flinching. Fix made by Yanfly.
 * * Documentation Update!
 * ** Added documentation for new feature(s)!
 * * New Features!
 * ** New notetags added by Yanfly:
 * *** <Battle Portrait Offset: +x, +y>
 * *** <Battle Portrait Offset X: +x>
 * *** <Battle Portrait Offset Y: +y>
 * **** This is used with the "Portrait" and "Border" Battle Layouts.
 * **** Offsets the X and Y coordinates for the battle portrait.
 * 
 * Version 1.19: December 25, 2020
 * * Bug Fixes!
 * ** Removing a state from a Sideview Enemy during the middle of their a non-
 *    looping motion will no longer reset their motion to neutral.
 *    Fix made by Yanfly.
 * * Compatibility Update!
 * ** Plugins should be more compatible with one another.
 * * Documentation Update!
 * ** Added documentation for updated feature(s)!
 * * Feature Update!
 * ** Action Sequence "PROJECTILE: Icon" now supports code for the "Icon"
 *    parameter. Update made by Yanfly.
 * 
 * Version 1.18: December 18, 2020
 * * Bug Fixes!
 * ** For TPB Active or ATB Active, inputting actors will no longer step back
 *    after an enemy's action is finished. Fix made by Yanfly and Shiro.
 * * Documentation Update!
 * ** Added documentation for new feature(s)!
 * * New Features!
 * ** Action Sequence "BTLOG: Add Text" is updated for the convenience of a new
 *    option to quickly copy the displayed text to the VisuStella MZ Combat Log
 *    if that plugin is installed. Added by Yanfly.
 * 
 * Version 1.17: December 11, 2020
 * * Bug Fixes!
 * ** Common Events in TPB Active that cause forced actions will no longer
 *    cause currently inputting actors that match the forced action battler to
 *    crash the game. Fix made by Yanfly and Shiro.
 * * Compatibility Update!
 * ** Added compatibility functionality for future plugins.
 * ** Plugins should be more compatible with one another.
 * * Documentation Update!
 * ** Added documentation for new feature(s)!
 * * Feature Update!
 * ** Action Sequence Impact Action Sequences "Shockwave from Each Target(s)",
 *    "Shockwave from Target(s) Center", and "Zoom Blur at Target(s) Center"
 *    now have "Offset X" and "Offset Y" plugin parameters. Added by Yanfly.
 * ** Action Sequence "MOVE: Move To Target(s)" is now changed so that if the
 *    "Melee Distance" value is set to 0, battlers will no longer stand a half
 *    body distance away. Added by Yanfly.
 * 
 * Version 1.16: December 4, 2020
 * * Bug Fixes!
 * ** Bug fixes made for the RPG Maker MZ base code. If a battler has no
 *    actions, then their action speed will not be Infinity. Fix by Olivia.
 * * Compatibility Update!
 * ** Plugins should be more compatible with one another.
 * * Optimization Update!
 * ** Plugin should run more optimized.
 * 
 * Version 1.15: November 29, 2020
 * * Bug Fixes!
 * ** Completely replacing the whole party at once will no longer cause the
 *    battle system to crash. Fix made by Olivia.
 * ** Pre-Battle Common Events will no longer cancel out any win/lose branches.
 *    Fix made by Arisu.
 * * Feature Update!
 * ** Custom Action Sequences will no longer close the Actor Command Input
 *    window unless absolutely necessary (like for Show Message events) during
 *    Active TPB/ATB. Change made by Arisu.
 * 
 * Version 1.14: November 22, 2020
 * * Feature Update!
 * ** Natural Miss and Evasion motions now have flinch distance.
 *    Added by Yanfly.
 * 
 * Version 1.13: November 15, 2020
 * * Optimization Update!
 * ** Plugin should run more optimized.
 * 
 * Version 1.12: November 8, 2020
 * * Bug Fixes!
 * ** Failsafes added to prevent common events from running if they're empty.
 *    Fix made by Irina.
 * ** Skip Party Command will now work properly with TPB-based battle systems.
 *    Fix made by Yanfly.
 * * Compatibility Update!
 * ** Plugins should be more compatible with one another.
 * * Documentation Update!
 * ** In preparation for upcoming VisuStella MZ plugins.
 * 
 * Version 1.11: November 1, 2020
 * * Compatibility Update!
 * ** Plugins should be more compatible with one another.
 * * Documentation Update!
 * ** Added clarity for the Plugin Parameters for the Common Events settings
 *    found in the mechanics section. The common events are only meant to run
 *    in the map scene and not for the battle scene. Update made by Irina.
 * * Feature Update!
 * ** The Plugin Parameter for Mechanics, Common Events (on Map), Defeat Event
 *    now has updated functionality. If this has a common event attached to it,
 *    then losing to random encounters will no longer send the player to the
 *    Game Over scene, but instead, send the player back to the map scene,
 *    where the Defeat Common Event will run. Update made by Irina.
 * 
 * Version 1.10: October 25, 2020
 * * Documentation Update!
 * ** Added documentation for new feature(s)!
 * * New Features!
 * ** New Action Sequence Plugin Command added by Olivia:
 * *** MECH: Custom Damage Formula
 * **** Changes the current action's damage formula to custom.
 *      This will assume the MANUAL damage style.
 * ** New Notetag added by Irina:
 * ** New Plugin Parameters added by Irina:
 * *** Plugin Parameters > Battleback Scaling Settings
 * **** These settings allow you to adjust how battlebacks scale to the screen
 *      in the game.
 * *** <Battler Sprite Grounded>
 * **** Prevents the enemy from being able to jumping and/or floating due to
 *      Action Sequences but still able to move. Useful for rooted enemies.
 * 
 * Version 1.09: October 18, 2020
 * * Bug Fixes!
 * ** Exiting out of the Options menu scene or Party menu scene will no longer
 *    cause party members to reset their starting position. Fix made by Arisu
 * * Documentation Update!
 * ** Added documentation for new feature(s)!
 * ** There was a documentation error with <JS Pre-Regenerate> and
 *    <JS Post-Regenerate>. Fix made by Yanfly.
 * *** Before, these were written as <JS Pre-Regenerate Turn> and
 *     <JS Post-Regenerate Turn>. The "Turn" part of the notetag has been
 *     removed in the documentation.
 * * Feature Update!
 * ** Damage sprites on actors are now centered relative to the actor's anchor.
 *    Change made by Yanfly.
 * * New Features!
 * ** New Action Sequence Plugin Command added by Yanfly:
 * *** MECH: Variable Popup
 * **** Causes the unit(s) to display a popup using the data stored inside
 *      a variable.
 * 
 * Version 1.08: October 11, 2020
 * * Bug Fixes!
 * ** Dead party members at the start of battle no longer start offscreen.
 *    Fix made by Arisu.
 * ** Removed party members from battle no longer count as moving battlers.
 *    Fix made by Yanfly.
 * ** Using specific motions should now have the weapons showing and not
 *    showing properly. Fix made by Yanfly.
 * 
 * Version 1.07: October 4, 2020
 * * Bug Fixes!
 * ** Adding and removing actors will now refresh the battle status display.
 *    Fix made by Irina.
 * ** Adding new states that would change the affected battler's state motion
 *    will automatically refresh the battler's motion. Fix made by Irina.
 * ** Boss Collapse animation fixed and will sink into the ground.
 *    Fix made by Irina.
 * ** Failsafes added for certain animation types. Fix made by Yanfly.
 * ** Freeze Motion for thrust, swing, and missile animations will now show the
 *    weapons properly. Fix made by Yanfly.
 * ** The Guard command will no longer display the costs of the Attack command.
 *    Fix made by Irina.
 * * Documentation Update!
 * ** Updated help file for newly added plugin parameters.
 * * Feature Updates!
 * ** When using the Change Battleback event command in battle, the game client
 *    will wait until both battlebacks are loaded before changing the both of
 *    them so that the appearance is synched together. Change made by Yanfly.
 * * New Features!
 * ** New plugin parameters added by Irina!
 * *** Plugin Parameters > Actor Battler Settings > Chant Style
 * **** What determines the chant motion? Hit type or skill type?
 * 
 * Version 1.06: September 27, 2020
 * * Bug Fixes!
 * ** Enemy Battler Plugin Parameter "Shadow Visible" should now work again.
 *    Fix made by Irina.
 * * Compatibility Update!
 * ** Added compatibility functionality for future plugins. Added by Yanfly.
 * * Documentation Update!
 * ** Updated the help file for all the new plugin parameters.
 * * Feature Update!
 * ** Action Sequence "MECH: HP, MP, TP" will now automatically collapse an
 *    enemy if it has been killed by the effect.
 * ** All battle systems for front view will now have damage popups appear
 *    in front of the status window instead of just the Portrait battle layout.
 *    Update made by Yanfly.
 * * New Features!
 * ** New Action Sequence Plugin Commands from Irina!
 * *** MOTION: Clear Freeze Frame
 * *** MOTION: Freeze Motion Frame
 * **** You can freeze a battler's sprite's motion with a specific frame.
 * ** New notetags for Maps and name tags for Troops added by Yanfly!
 * *** <Battle Layout: type> to change the battle layout style used for
 *     specific maps and/or troops.
 * ** New plugin parameters added by Yanfly!
 * *** Plugin Parameters > Battle Layout Settings > Command Window Width
 * **** This plugin parameter lets you adjust the window width for Party and
 *      Actor Command windows in the Default and List Battle Layout styles.
 * *** Plugin Parameters > Enemy Battler Settings > Name: Offset X
 * *** Plugin Parameters > Enemy Battler Settings > Name: Offset Y
 * **** These plugin parameters allow you to offset the position of the enemy
 *      name positions on the screen by a specific amount.
 * 
 * Version 1.05: September 20, 2020
 * * Bug Fixes!
 * ** Actors now use their casting or charging animations again during TPB/ATB.
 *    Fix made by Yanfly.
 * ** Defeat requirement for enemies will no longer crash the game if turned on
 *    after creating
 * ** Escaping animation no longer has actors stay in place. Fixed by Yanfly.
 * ** Failsafes added for newly added weapon types that have not been adjusted
 *    in the Database > System 2 tab. Fixed by Irina.
 * ** Shadows now appear under the actor sprites. Fix made by Yanfly.
 * ** Victory during TPB will no longer cancel the victory animations of
 *    actors that will have their turn after. Fixed by Yanfly.
 * * Documentation Update!
 * ** All Anchor Plugin Parameter descriptions now state to use values between
 *    0 and 1 to be safe. Update made by Yanfly.
 * * Feature Update!
 * ** During Active TPB / ATB, canceling out of the actor command window will
 *    go directly into the party window without having to sort through all of
 *    the available active actors.
 * ** Going from the Party Command Window's Fight command will immediately
 *    return back to the actor command window that was canceled from.
 * * New Features!
 * ** Action Sequence Plugin Command "MOVE: Spin/Rotate" has been updated.
 * *** A new parameter has been added: "Revert Angle on Finish"
 * *** Added by Yanfly.
 * ** New plugin parameters have been added to Damage Settings.
 * *** Appear Position: Selects where you want popups to appear relative to the
 *     battler. Head, Center, Base. Added by Yanfly.
 * *** Offset X: Sets how much to offset the sprites by vertically.
 *     Added by Yanfly.
 * *** Offset Y: Sets how much to offset the sprites by horizontally.
 *     Added by Yanfly.
 * ** New plugin parameters have been added to Actor Battler Settings.
 * *** Priority: Active - Place the active actor on top of actor and
 *     enemy sprites. Added by Yanfly.
 * *** Priority: Actors - Prioritize actors over enemies when placing 
 *     sprites on top of each other. Added by Yanfly.
 * 
 * Version 1.04: September 13, 2020
 * * Bug Fixes!
 * ** Active Battler Sprites now remain on top and won't be hidden behind
 *    other sprites for better visual clarity. Fix made by Arisu.
 * ** Collapsing battlers will now show the dead motion properly. Fix made by
 *    Olivia.
 * ** Dead battlers can no longer be given immortality. Fix made by Olivia.
 * ** Going into the Options menu with no battleback set will no longer set a
 *    battle snapshot.
 * ** HP Gauges for Sideview Enemies are no longer flipped! Fix made by Yanfly.
 * ** Moving a dead battler would no longer reset their animation. Fix made by
 *    Olivia.
 * ** Pre-Battle Common Events now work with events instead of just random
 *    encounters. Fix made by Yanfly.
 * ** Sideview Enemy shadows no longer twitch. Fix made by Irina.
 * * Documentation Updates!
 * ** Added further explanations for Anchor X and Anchor Y plugin parameters.
 *    This is because there's a lot of confusion for users who aren't familiar
 *    with how sprites work. Added by Irina.
 * ** <Magic Reduction: x> notetag updated to say magical damage instead of
 *    physical damage. Fix made by Yanfly.
 * * New Features!
 * ** Additional Action Sequence Plugin Commands have been added in preparation
 *    of upcoming plugins! Additions made by Irina.
 * *** Action Sequences - Angle (for VisuMZ_3_ActSeqCamera)
 * *** Action Sequences - Camera (for VisuMZ_3_ActSeqCamera)
 * *** Action Sequences - Skew (for VisuMZ_3_ActSeqCamera)
 * *** Action Sequences - Zoom (for VisuMZ_3_ActSeqCamera)
 * ** Additional Action Sequence Plugin Commands have been made available now
 *    and added to Battle Core! Additions made by Irina.
 * *** MOVE: Scale/Grow/Shrink
 * *** MOVE: Skew/Distort
 * *** MOVE: Spin/Rotate
 * *** MOVE: Wait For Scale
 * *** MOVE: Wait For Skew
 * *** MOVE: Wait For Spin
 * ** Plugin Parameters Additions. Additions made by Irina.
 * *** Plugin Params > Actor Battler Settings > Offset X
 * *** Plugin Params > Actor Battler Settings > Offset Y
 * *** Plugin Params > Actor Battler Settings > Smooth Image
 * *** Plugin Params > Enemy Battler Settings > Offset X
 * *** Plugin Params > Enemy Battler Settings > Offset Y
 * *** Plugin Params > Enemy Battler Settings > Smooth Image
 * 
 * Version 1.03: September 6, 2020
 * * Bug Fixes!
 * ** Animated Battlers will refresh their motions from the death motion once
 *    they're revived instead of waiting for their next input phase. Fix made
 *    by Yanfly.
 * ** Battle Log speed sometimes went by too fast for certain enabled messages.
 *    Wait timers are now added to them, like state results, buff results, and
 *    debuff results. Fix made by Yanfly.
 * ** Boss Collapse animation now works properly. Fix made by Yanfly.
 * ** Freeze fix for TPB (Wait) if multiple actors get a turn at the same time.
 *    Fix made by Olivia.
 * ** Pressing cancel on a target window after selecting a single skill no
 *    longer causes the status window to twitch.
 * ** Sideview Enemies had a split frame of being visible if they were to start
 *    off hidden in battle. Fix made by Shaz.
 * * Compatibility Update:
 * ** Battle Core's Sprite_Damage.setup() function is now separated fro the
 *    default to allow for better compatibility. Made by Yanfly.
 * * Documentation Update:
 * ** Inserted more information for "Damage Popups" under "Major Changes"
 * * New Features!
 * ** <Magic Penetration: x>, <Magic Penetration: x%> notetags added.
 * ** <Magic Reduction: x>, <Magic Reduction: x%> notetags added.
 * ** <Battle UI Offset: +x, +y>, <Battle UI Offset X: +x>, and
 *    <Battle UI Offset Y: +y> notetags added for adjusting the positions of
 *    HP Gauges and State Icons.
 * *** Notetags added by Yanfly.
 * 
 * Version 1.02: August 30, 2020
 * * Bug Fixes!
 * ** Failsafes added for parsing battle targets. Fix made by Yanfly.
 * ** Immortality is no longer ignored by skills/items with the Normal Attack
 *    state effect. Fix made by Yanfly.
 * ** Miss and Evasion sound effects work again! Fix made by Yanfly.
 * ** Selecting "Escape" from the Actor Command Window will now have the
 *    Inputting Battler show its escape motion. Fix made by Yanfly.
 * ** Wait for Movement now applies to SV Enemies. Fix made by Yanfly.
 * * New Features!
 * ** Plugin Command "ACSET: Finish Action" now has an option to turn off the
 *    Immortality of targets. Feature added by Yanfly.
 * * Optimization Update
 * ** Uses less resources when making checks for Pre-Battle Battle Start events
 * 
 * Version 1.01: August 23, 2020
 * * Bug Fixes!
 * ** Plugin Parameters > Damage Settings > Damage Formats are now fixed.
 *    Fix made by Olivia.
 * ** TPB Battle System with Disable Party Command fixed. Fix made by Olivia.
 * ** States now show in list format if faces are disabled. Fix made by Yanfly.
 * ** The default damage styles were missing the 'v' variable to allow for
 *    variable data input. These are back now. Fix made by Yanfly.
 * *** Users updating from version 1.00 will need to fix this problem by either
 *     removing the plugin from the Plugin Manager list and reinstalling it, or
 *     going to Plugin Parameters > Damage Settings > Style List > the style
 *     you want, and adding "const v = $gameVariables._data;" to JS: Formula
 * * New Notetags Added:
 * ** <Command Show Switch: x> added by Olivia
 * ** <Command Show All Switches: x,x,x> added by Olivia
 * ** <Command Show Any Switches: x,x,x> added by Olivia
 * ** <Command Hide Switch: x> added by Olivia
 * ** <Command Hide All Switches: x,x,x> added by Olivia
 * ** <Command Hide Any Switches: x,x,x> added by Olivia
 * ** <JS Command Visible> added by Olivia
 *
 * Version 1.00: August 20, 2020
 * * Finished Plugin!
 *
 * ============================================================================
 * End of Helpfile
 * ============================================================================
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceStart
 * @text -
 * @desc The following are Action Sequences commands/sets.
 * These Plugin Commands only work in battle.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakSet
 * @text Action Sequence - Action Sets
 * @desc Action Sequence Action Sets are groups of commonly used
 * Action Sequence Commands put together for more efficient usage.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Set_SetupAction
 * @text ACSET: Setup Action Set
 * @desc The generic start to most actions.
 * 
 * @arg DisplayAction:eval
 * @text Display Action
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg ApplyImmortal:eval
 * @text Immortal: On
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg ActionStart:eval
 * @text Battle Step
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg WaitForMovement:eval
 * @text Wait For Movement
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg CastAnimation:eval
 * @text Cast Animation
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg WaitForAnimation:eval
 * @text Wait For Animation
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Set_WholeActionSet
 * @text ACSET: All Targets Action Set
 * @desc Affects all targets simultaneously performing the following.
 * 
 * @arg DualWield:eval
 * @text Dual/Multi Wield?
 * @type boolean
 * @on Apply
 * @off Don't
 * @desc Add times struck based on weapon quantity equipped?
 * @default false
 * 
 * @arg PerformAction:eval
 * @text Perform Action
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg WaitCount:eval
 * @text Wait Count
 * @desc How many frames should the action sequence wait?
 * You may use JavaScript code.
 * @default Sprite_Battler._motionSpeed
 * 
 * @arg ActionAnimation:eval
 * @text Action Animation
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg WaitForAnimation:eval
 * @text Wait For Animation
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg ActionEffect:eval
 * @text Action Effect
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg ApplyImmortal:eval
 * @text Immortal: Off
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Set_TargetActionSet
 * @text ACSET: Each Target Action Set
 * @desc Goes through each target one by one to perform the following.
 * 
 * @arg DualWield:eval
 * @text Dual/Multi Wield?
 * @type boolean
 * @on Apply
 * @off Don't
 * @desc Add times struck based on weapon quantity equipped?
 * @default false
 * 
 * @arg PerformAction:eval
 * @text Perform Action
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg WaitCount1:eval
 * @text Wait Count
 * @desc How many frames should the action sequence wait?
 * You may use JavaScript code.
 * @default Sprite_Battler._motionSpeed
 * 
 * @arg ActionAnimation:eval
 * @text Action Animation
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg WaitCount2:eval
 * @text Wait Count
 * @desc How many frames should the action sequence wait?
 * You may use JavaScript code.
 * @default Sprite_Battler._motionSpeed * 2
 * 
 * @arg ActionEffect:eval
 * @text Action Effect
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg ApplyImmortal:eval
 * @text Immortal: Off
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Set_FinishAction
 * @text ACSET: Finish Action
 * @desc The generic ending to most actions.
 * 
 * @arg ApplyImmortal:eval
 * @text Immortal: Off
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg WaitForNewLine:eval
 * @text Wait For New Line
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg WaitForEffect:eval
 * @text Wait For Effects
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg ClearBattleLog:eval
 * @text Clear Battle Log
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg ActionEnd:eval
 * @text Home Reset
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg WaitForMovement:eval
 * @text Wait For Movement
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceAngle
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakAngle
 * @text Action Sequences - Angle
 * @desc Allows you to have control over the camera angle.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_ChangeAngle
 * @text ANGLE: Change Angle
 * @desc Changes the camera angle.
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * @arg Angle:eval
 * @text Angle
 * @desc Change the camera angle to this many degrees.
 * @default 0
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames to change camera angle.
 * @default 60
 *
 * @arg EasingType:str
 * @text Angle Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default InOutSine
 * 
 * @arg WaitForAngle:eval
 * @text Wait For Angle?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for angle changes to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Angle_Reset
 * @text ANGLE: Reset Angle
 * @desc Reset any angle settings.
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames to reset camera angle.
 * @default 60
 *
 * @arg EasingType:str
 * @text Angle Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default InOutSine
 * 
 * @arg WaitForAngle:eval
 * @text Wait For Angle?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for angle changes to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Angle_WaitForAngle
 * @text ANGLE: Wait For Angle
 * @desc Waits for angle changes to complete before performing next command.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceAnimation
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakAnimation
 * @text Action Sequences - Animations
 * @desc These Action Sequences are related to the 'Animations' that
 * can be found in the Animations tab of the Database.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_ActionAnimation
 * @text ANIM: Action Animation
 * @desc Plays the animation associated with the action.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to play the animation on.
 * @default ["all targets"]
 * 
 * @arg Mirror:eval
 * @text Mirror Animation
 * @type boolean
 * @on Mirror
 * @off Normal
 * @desc Mirror the animation?
 * @default false
 * 
 * @arg WaitForAnimation:eval
 * @text Wait For Animation?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for animation to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_AttackAnimation
 * @text ANIM: Attack Animation
 * @desc Plays the animation associated with the user's 1st weapon.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to play the animation on.
 * @default ["all targets"]
 * 
 * @arg Mirror:eval
 * @text Mirror Animation
 * @type boolean
 * @on Mirror
 * @off Normal
 * @desc Mirror the animation?
 * @default false
 * 
 * @arg WaitForAnimation:eval
 * @text Wait For Animation?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for animation to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_AttackAnimation2
 * @text ANIM: Attack Animation 2+
 * @desc Plays the animation associated with the user's other weapons.
 * Plays nothing if there is no other weapon equipped.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to play the animation on.
 * @default ["all targets"]
 * 
 * @arg Slot:eval
 * @text Slot
 * @desc Which weapon slot to get this data from?
 * Main-hand weapon is weapon slot 1.
 * @default 2
 * 
 * @arg Mirror:eval
 * @text Mirror Animation
 * @type boolean
 * @on Mirror
 * @off Normal
 * @desc Mirror the animation?
 * @default true
 * 
 * @arg WaitForAnimation:eval
 * @text Wait For Animation?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for animation to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_CastAnimation
 * @text ANIM: Cast Animation
 * @desc Plays the cast animation associated with the action.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to play the animation on.
 * @default ["user"]
 * 
 * @arg Mirror:eval
 * @text Mirror Animation
 * @type boolean
 * @on Mirror
 * @off Normal
 * @desc Mirror the animation?
 * @default false
 * 
 * @arg WaitForAnimation:eval
 * @text Wait For Animation?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for animation to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_ChangeBattlePortrait
 * @text ANIM: Change Battle Portrait
 * @desc Changes the battle portrait of the actor (if it's an actor).
 * Can be used outside of battle/action sequences.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to change the portraits for.
 * Valid units can only be actors.
 * @default ["user"]
 * 
 * @arg Filename:str
 * @text Filename
 * @type file
 * @dir img/pictures/
 * @desc Select the file to change the actor's portrait to.
 * @default Untitled
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_PlayAtCoordinate
 * @text ANIM: Play at Coordinate
 * @desc Plays an animation on the screen at a specific x, y coordinate.
 * Requires VisuMZ_0_CoreEngine!
 *
 * @arg AnimationID:num
 * @text Animation ID
 * @parent Animation
 * @type animation
 * @desc Plays this animation.
 * @default 1
 * 
 * @arg Coordinates
 *
 * @arg pointX:eval
 * @text X
 * @parent Coordinates
 * @desc X coordinate used for the animation.
 * You may use JavaScript code.
 * @default Graphics.width / 2
 *
 * @arg pointY:eval
 * @text Y
 * @parent Coordinates
 * @desc Y coordinate used for the animation.
 * You may use JavaScript code.
 * @default Graphics.height / 2
 *
 * @arg Mirror:eval
 * @text Mirror Animation?
 * @parent Animation
 * @type boolean
 * @on Mirror
 * @off Normal
 * @desc Mirror the animation?
 * @default false
 *
 * @arg Mute:eval
 * @text Mute Animation?
 * @parent Animation
 * @type boolean
 * @on Mute
 * @off Normal
 * @desc Mute the animation?
 * @default false
 *
 * @arg WaitComplete:eval
 * @text Wait for Completion?
 * @parent Animation
 * @type boolean
 * @on Wait
 * @off Normal
 * @desc Wait the animation to finish before continuing?
 * @default false
 * 
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_ShowAnimation
 * @text ANIM: Show Animation
 * @desc Plays the a specific animation on unit(s).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to play the animation on.
 * @default ["all targets"]
 * 
 * @arg AnimationID:num
 * @text Animation ID
 * @type animation
 * @desc Select which animation to play on unit(s).
 * @default 1
 * 
 * @arg Mirror:eval
 * @text Mirror Animation
 * @type boolean
 * @on Mirror
 * @off Normal
 * @desc Mirror the animation?
 * @default false
 * 
 * @arg WaitForAnimation:eval
 * @text Wait For Animation?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for animation to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_WaitForAnimation
 * @text ANIM: Wait For Animation
 * @desc Causes the interpreter to wait for any animation(s) to finish.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceBattleLog
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakBattleLog
 * @text Action Sequences - Battle Log
 * @desc These Action Sequences are related to the Battle Log Window,
 * the window found at the top of the battle screen.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_BattleLog_AddText
 * @text BTLOG: Add Text
 * @desc Adds a new line of text into the Battle Log.
 * 
 * @arg Text:str
 * @text Text
 * @desc Add this text into the Battle Log.
 * Text codes allowed.
 * @default Insert text here.
 * 
 * @arg CopyCombatLog:eval
 * @text Copy to Combat Log?
 * @type boolean
 * @on Copy Text
 * @off Don't Copy
 * @desc Copies text to the Combat Log.
 * Requires VisuMZ_4_CombatLog
 * @default true
 *
 * @arg CombatLogIcon:num
 * @text Combat Log Icon
 * @parent CopyCombatLog:eval
 * @desc What icon would you like to bind to this entry?
 * Requires VisuMZ_4_CombatLog
 * @default 87
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_BattleLog_Clear
 * @text BTLOG: Clear Battle Log
 * @desc Clears all the text in the Battle Log.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_BattleLog_DisplayAction
 * @text BTLOG: Display Action
 * @desc Displays the current action in the Battle Log.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_BattleLog_PopBaseLine
 * @text BTLOG: Pop Base Line
 * @desc Removes the Battle Log's last added base line and 
 * all text up to its former location.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_BattleLog_PushBaseLine
 * @text BTLOG: Push Base Line
 * @desc Adds a new base line to where the Battle Log currently is at.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_BattleLog_Refresh
 * @text BTLOG: Refresh Battle Log
 * @desc Refreshes the Battle Log.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_BattleLog_UI
 * @text BTLOG: UI Show/Hide
 * @desc Shows or hides the Battle UI (including the Battle Log).
 * 
 * @arg ShowHide:eval
 * @text Show/Hide?
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Shows/hides the Battle UI.
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_BattleLog_WaitForBattleLog
 * @text BTLOG: Wait For Battle Log
 * @desc Causes the interpreter to wait for the Battle Log to finish.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_BattleLog_WaitForNewLine
 * @text BTLOG: Wait For New Line
 * @desc Causes the interpreter to wait for a new line in the Battle Log.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceCamera
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakCamera
 * @text Action Sequences - Camera
 * @desc Allows you to have control over the camera.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Camera_Clamp
 * @text CAMERA: Clamp ON/OFF
 * @desc Turns battle camera clamping on/off.
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * @arg Setting:eval
 * @text ON/OFF
 * @type boolean
 * @on ON
 * @off OFF
 * @desc Turns camera clamping on/off.
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Camera_FocusPoint
 * @text CAMERA: Focus Point
 * @desc Focus the battle camera on a certain point in the screen.
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * @arg FocusX:eval
 * @text X Coordinate
 * @desc Insert the point to focus the camera on.
 * You may use JavaScript code.
 * @default Graphics.width / 2
 * 
 * @arg FocusY:eval
 * @text Y Coordinate
 * @desc Insert the point to focus the camera on.
 * You may use JavaScript code.
 * @default Graphics.height / 2
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for camera focus change.
 * @default 60
 *
 * @arg EasingType:str
 * @text Camera Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default InOutSine
 * 
 * @arg WaitForCamera:eval
 * @text Wait For Camera?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for camera changes to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Camera_FocusTarget
 * @text CAMERA: Focus Target(s)
 * @desc Focus the battle camera on certain battler target(s).
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to focus the battle camera on.
 * @default ["user"]
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for camera focus change.
 * @default 60
 *
 * @arg EasingType:str
 * @text Camera Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default InOutSine
 * 
 * @arg WaitForCamera:eval
 * @text Wait For Camera?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for camera changes to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Camera_Offset
 * @text CAMERA: Offset
 * @desc Offset the battle camera from the focus target.
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * @arg OffsetX:eval
 * @text Offset X
 * @desc How much to offset the camera X by.
 * Negative: left. Positive: right.
 * @default +0
 * 
 * @arg OffsetY:eval
 * @text Offset Y
 * @desc How much to offset the camera Y by.
 * Negative: up. Positive: down.
 * @default +0
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for offset change.
 * @default 60
 *
 * @arg EasingType:str
 * @text Camera Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default InOutSine
 * 
 * @arg WaitForCamera:eval
 * @text Wait For Camera?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for camera changes to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Camera_Reset
 * @text CAMERA: Reset
 * @desc Reset the battle camera settings.
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * @arg ResetFocus:eval
 * @text Reset Focus?
 * @type boolean
 * @on On
 * @off Off
 * @desc Reset the focus point?
 * @default true
 * 
 * @arg ResetOffset:eval
 * @text Reset Offset?
 * @type boolean
 * @on On
 * @off Off
 * @desc Reset the camera offset?
 * @default true
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for reset change.
 * @default 60
 *
 * @arg EasingType:str
 * @text Camera Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default InOutSine
 * 
 * @arg WaitForCamera:eval
 * @text Wait For Camera?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for camera changes to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Camera_WaitForCamera
 * @text CAMERA: Wait For Camera
 * @desc Waits for camera to complete before performing next command.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * @ --------------------------------------------------------------------------
 *
 *
 * @command ActionSequenceSpaceDragonbones
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreaDragonbones
 * @text Action Sequences - Dragonbones
 * @desc These Action Sequences are Dragonbones-related.
 * Requires VisuMZ_2_DragonbonesUnion!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_DB_DragonbonesMotionAni
 * @text DB: Dragonbones Animation
 * @desc Causes the unit(s) to play a Dragonbones motion animation.
 * Requires VisuMZ_2_DragonbonesUnion!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to perform a motion animation.
 * @default ["user"]
 *
 * @arg MotionAni:str
 * @text Motion Animation
 * @desc What is the name of the Dragonbones motion animation you wish to play?
 * @default attack
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_DB_DragonbonesTimeScale
 * @text DB: Dragonbones Time Scale
 * @desc Causes the unit(s) to change their Dragonbones time scale.
 * Requires VisuMZ_2_DragonbonesUnion!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to perform a motion animation.
 * @default ["user"]
 *
 * @arg TimeScale:num
 * @text Time Scale
 * @desc Change the value of the Dragonbones time scale to this.
 * @default 1.0
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceElements
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakElements
 * @text Action Sequences - Elements
 * @desc These Action Sequences are related to elements.
 * Requires VisuMZ_1_ElementStatusCore!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Element_AddElements
 * @text ELE: Add Elements
 * @desc Adds element(s) to be used when calculating damage.
 * Requires VisuMZ_1_ElementStatusCore!
 *
 * @arg Elements:arraynum
 * @text Elements
 * @type number[]
 * @min 1
 * @max 99
 * @desc Select which element ID to add onto the action.
 * Insert multiple element ID's to add multiple at once.
 * @default ["1"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Element_Clear
 * @text ELE: Clear Element Changes
 * @desc Clears all element changes made through Action Sequences.
 * Requires VisuMZ_1_ElementStatusCore!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Element_ForceElements
 * @text ELE: Force Elements
 * @desc Forces only specific element(s) when calculating damage.
 * Requires VisuMZ_1_ElementStatusCore!
 *
 * @arg Elements:arraynum
 * @text Elements
 * @type number[]
 * @min 1
 * @max 99
 * @desc Select which element ID to force in the action.
 * Insert multiple element ID's to force multiple at once.
 * @default ["1"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Element_NullElements
 * @text ELE: Null Element
 * @desc Forces no element to be used when calculating damage.
 * Requires VisuMZ_1_ElementStatusCore!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceHorror
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakHorror
 * @text Action Sequences - Horror Effects
 * @desc These Action Sequences are Horror Effects-related.
 * Requires VisuMZ_2_HorrorEffects!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Horror_Clear
 * @text HORROR: Clear All Filters
 * @desc Clear all Horror Effects filters on the target battler(s).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to remove Horror Effects for.
 * @default ["user"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Horror_GlitchCreate
 * @text HORROR: Glitch Create
 * @desc Creates the glitch effect on the target battler(s).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to create the Horror Effect for.
 * @default ["user"]
 *
 * @arg slices:num
 * @text Glitch Slices
 * @parent FilterGlitch
 * @type number
 * @min 1
 * @desc Glitch slices to be used with the target.
 * @default 10
 *
 * @arg offset:num
 * @text Glitch Offset
 * @parent FilterGlitch
 * @type number
 * @min 1
 * @desc Default offset value.
 * @default 100
 *
 * @arg animated:eval
 * @text Glitch Animated?
 * @parent FilterGlitch
 * @type boolean
 * @on Animate
 * @off Static
 * @desc Animate the glitch effect?
 * @default true
 *
 * @arg aniFrequency:num
 * @text Glitch Frequency
 * @parent FilterGlitch
 * @type number
 * @min 1
 * @desc If animated, how frequent to make the glitch effect?
 * Lower = often     Higher = rarer
 * @default 300
 *
 * @arg aniStrength:num
 * @text Glitch Strength
 * @parent FilterGlitch
 * @type number
 * @min 1
 * @desc If animated, how strong is the glitch effect?
 * Lower = weaker     Higher = stronger
 * @default 30
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Horror_GlitchRemove
 * @text HORROR: Glitch Remove
 * @desc Removes the glitch effect on the target battler(s).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to remove the Horror Effect for.
 * @default ["user"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Horror_NoiseCreate
 * @text HORROR: Noise Create
 * @desc Creates the noise effect on the target battler(s).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to create the Horror Effect for.
 * @default ["user"]
 *
 * @arg noise:num
 * @text Noise Rate
 * @parent FilterNoise
 * @desc Noise rate to be used with the target.
 * @default 0.3
 *
 * @arg animated:eval
 * @text Noise Animated
 * @parent FilterNoise
 * @type boolean
 * @on Animate
 * @off Static
 * @desc Animate the noise for the target?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Horror_NoiseRemove
 * @text HORROR: Noise Remove
 * @desc Removes the noise effect on the target battler(s).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to remove the Horror Effect for.
 * @default ["user"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Horror_TVCreate
 * @text HORROR: TV Create
 * @desc Creates the TV effect on the target battler(s).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to create the Horror Effect for.
 * @default ["user"]
 *
 * @arg lineWidth:num
 * @text TV Line Thickness
 * @parent FilterTV
 * @type number
 * @min 1
 * @desc Default TV line thickness
 * Lower = thinner     Higher = thicker
 * @default 5
 *
 * @arg vignetting:num
 * @text TV Corner Size
 * @parent FilterTV
 * @desc Default TV line corner size
 * Lower = smaller     Higher = bigger
 * @default 0.3
 *
 * @arg animated:eval
 * @text TV Animated
 * @parent FilterTV
 * @type boolean
 * @on Animate
 * @off Static
 * @desc Animate the TV?
 * @default true
 *
 * @arg aniSpeed:num
 * @text TV Speed
 * @parent FilterTV
 * @desc Speed used to animate the TV if animated
 * Lower = slower     Higher = faster
 * @default 0.25
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Horror_TVRemove
 * @text HORROR: TV Remove
 * @desc Removes the TV effect on the target battler(s).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to remove the Horror Effect for.
 * @default ["user"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceImpact
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakImpact
 * @text Action Sequences - Impact
 * @desc These Action Sequences are related to creating impact.
 * Requires VisuMZ_3_ActSeqImpact!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_ColorBreak
 * @text IMPACT: Color Break
 * @desc Breaks the colors on the screen before reassembling.
 * Requires VisuMZ_3_ActSeqImpact!
 * 
 * @arg Intensity:eval
 * @text Intensity
 * @desc What is the intensity of the color break effect?
 * @default 60
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc What is the duration of the color break effect?
 * @default 60
 *
 * @arg EasingType:str
 * @text Easing Type
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * @default OutBack
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_MotionBlurScreen
 * @text IMPACT: Motion Blur Screen
 * @desc Creates a motion blur on the whole screen.
 * Requires VisuMZ_3_ActSeqImpact!
 *
 * @arg Angle:eval
 * @text Angle
 * @desc Determine what angle to make the motion blur at.
 * @default Math.randomInt(360)
 *
 * @arg Rate:eval
 * @text Intensity Rate
 * @desc This determines intensity rate of the motion blur.
 * Use a number between 0 and 1.
 * @default 0.1
 *
 * @arg Duration:num
 * @text Duration
 * @type Number
 * @min 1
 * @desc How many frames should the motion blur last?
 * What do you want to be its duration?
 * @default 30
 *
 * @arg EasingType:str
 * @text Easing Type
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * @default InOutSine
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_MotionBlurTarget
 * @text IMPACT: Motion Blur Target(s)
 * @desc Creates a motion blur on selected target(s).
 * Requires VisuMZ_3_ActSeqImpact!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to create motion blur effects for.
 * @default ["user"]
 *
 * @arg Angle:eval
 * @text Angle
 * @desc Determine what angle to make the motion blur at.
 * @default Math.randomInt(360)
 *
 * @arg Rate:eval
 * @text Intensity Rate
 * @desc This determines intensity rate of the motion blur.
 * Use a number between 0 and 1.
 * @default 0.5
 *
 * @arg Duration:num
 * @text Duration
 * @type Number
 * @min 1
 * @desc How many frames should the motion blur last?
 * What do you want to be its duration?
 * @default 30
 *
 * @arg EasingType:str
 * @text Easing Type
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * @default InOutSine
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_MotionTrailCreate
 * @text IMPACT: Motion Trail Create
 * @desc Creates a motion trail effect for the target(s).
 * Requires VisuMZ_3_ActSeqImpact!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to create motion trail effects for.
 * @default ["user"]
 *
 * @arg delay:num
 * @text Delay
 * @type Number
 * @min 1
 * @desc How many frames to delay by when creating a motion trail?
 * The higher the delay, the less after images there are.
 * @default 1
 *
 * @arg duration:num
 * @text Duration
 * @type Number
 * @min 1
 * @desc How many frames should the motion trail last?
 * What do you want to be its duration?
 * @default 30
 *
 * @arg hue:num
 * @text Hue
 * @type Number
 * @min 0
 * @max 255
 * @desc What do you want to be the hue for the motion trail?
 * @default 0
 *
 * @arg opacityStart:num
 * @text Starting Opacity
 * @type Number
 * @min 0
 * @max 255
 * @desc What starting opacity value do you want for the motion
 * trail? Opacity values decrease over time.
 * @default 200
 *
 * @arg tone:eval
 * @text Tone
 * @desc What tone do you want for the motion trail?
 * Format: [Red, Green, Blue, Gray]
 * @default [0, 0, 0, 0]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_MotionTrailRemove
 * @text IMPACT: Motion Trail Remove
 * @desc Removes the motion trail effect from the target(s).
 * Requires VisuMZ_3_ActSeqImpact!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to clear motion trail effects for.
 * @default ["user"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_ShockwavePoint
 * @text IMPACT: Shockwave at Point
 * @desc Creates a shockwave at the designated coordinates.
 * Requires VisuMZ_3_ActSeqImpact!
 * 
 * @arg Coordinates
 * 
 * @arg X:eval
 * @text Point: X
 * @parent Coordinates
 * @desc What x coordinate do you want to create a shockwave at?
 * You can use JavaScript code.
 * @default Graphics.width / 2
 * 
 * @arg Y:eval
 * @text Point: Y
 * @parent Coordinates
 * @desc What y coordinate do you want to create a shockwave at?
 * You can use JavaScript code.
 * @default (Graphics.height - 200) / 2
 * 
 * @arg Amp:eval
 * @text Amplitude
 * @desc What is the aplitude of the shockwave effect?
 * @default 30
 * 
 * @arg Wave:eval
 * @text Wavelength
 * @desc What is the wavelength of the shockwave effect?
 * @default 160
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc What is the duration of the shockwave?
 * @default 60
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_ShockwaveEachTargets
 * @text IMPACT: Shockwave from Each Target(s)
 * @desc Creates a shockwave at each of the target(s) location(s).
 * Requires VisuMZ_3_ActSeqImpact!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to start a shockwave from.
 * @default ["all targets"]
 * 
 * @arg TargetLocation:str
 * @text Target Location
 * @parent Targets2:arraystr
 * @type combo
 * @option front head
 * @option front center
 * @option front base
 * @option middle head
 * @option middle center
 * @option middle base
 * @option back head
 * @option back center
 * @option back base
 * @desc Select which part target group to start a shockwave from.
 * @default middle center
 * 
 * @arg OffsetX:eval
 * @text Offset X
 * @parent TargetLocation:str
 * @desc How much to offset the shockwave X point by.
 * Negative: left. Positive: right.
 * @default +0
 * 
 * @arg OffsetY:eval
 * @text Offset Y
 * @parent TargetLocation:str
 * @desc How much to offset the shockwave Y point by.
 * Negative: up. Positive: down.
 * @default +0
 * 
 * @arg Amp:eval
 * @text Amplitude
 * @desc What is the aplitude of the shockwave effect?
 * @default 30
 * 
 * @arg Wave:eval
 * @text Wavelength
 * @desc What is the wavelength of the shockwave effect?
 * @default 160
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc What is the duration of the shockwave?
 * @default 60
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_ShockwaveCenterTargets
 * @text IMPACT: Shockwave from Target(s) Center
 * @desc Creates a shockwave from the center of the target(s).
 * Requires VisuMZ_3_ActSeqImpact!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to start a shockwave from.
 * @default ["all targets"]
 * 
 * @arg TargetLocation:str
 * @text Target Location
 * @parent Targets2:arraystr
 * @type combo
 * @option front head
 * @option front center
 * @option front base
 * @option middle head
 * @option middle center
 * @option middle base
 * @option back head
 * @option back center
 * @option back base
 * @desc Select which part target group to start a shockwave from.
 * @default middle center
 * 
 * @arg OffsetX:eval
 * @text Offset X
 * @parent TargetLocation:str
 * @desc How much to offset the shockwave X point by.
 * Negative: left. Positive: right.
 * @default +0
 * 
 * @arg OffsetY:eval
 * @text Offset Y
 * @parent TargetLocation:str
 * @desc How much to offset the shockwave Y point by.
 * Negative: up. Positive: down.
 * @default +0
 * 
 * @arg Amp:eval
 * @text Amplitude
 * @desc What is the aplitude of the shockwave effect?
 * @default 30
 * 
 * @arg Wave:eval
 * @text Wavelength
 * @desc What is the wavelength of the shockwave effect?
 * @default 160
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc What is the duration of the shockwave?
 * @default 60
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_ZoomBlurPoint
 * @text IMPACT: Zoom Blur at Point
 * @desc Creates a zoom blur at the designated coordinates.
 * Requires VisuMZ_3_ActSeqImpact!
 * 
 * @arg Coordinates
 * 
 * @arg X:eval
 * @text Point: X
 * @parent Coordinates
 * @desc What x coordinate do you want to focus the zoom at?
 * You can use JavaScript code.
 * @default Graphics.width / 2
 * 
 * @arg Y:eval
 * @text Point: Y
 * @parent Coordinates
 * @desc What y coordinate do you want to focus the zoom at?
 * You can use JavaScript code.
 * @default (Graphics.height - 200) / 2
 * 
 * @arg Strength:eval
 * @text Zoom Strength
 * @desc What is the strength of the zoom effect?
 * Use a number between 0 and 1.
 * @default 0.5
 * 
 * @arg Radius:eval
 * @text Visible Radius
 * @desc How much of a radius should be visible from the center?
 * @default 0
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc What is the duration of the zoom blur?
 * @default 60
 *
 * @arg EasingType:str
 * @text Easing Type
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * @default OutSine
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_ZoomBlurTargetCenter
 * @text IMPACT: Zoom Blur at Target(s) Center
 * @desc Creates a zoom blur at the center of targets.
 * Requires VisuMZ_3_ActSeqImpact!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to start a zoom blur from.
 * @default ["user"]
 * 
 * @arg TargetLocation:str
 * @text Target Location
 * @parent Targets2:arraystr
 * @type combo
 * @option front head
 * @option front center
 * @option front base
 * @option middle head
 * @option middle center
 * @option middle base
 * @option back head
 * @option back center
 * @option back base
 * @desc Select which part target group to start a zoom blur from.
 * @default middle center
 * 
 * @arg OffsetX:eval
 * @text Offset X
 * @parent TargetLocation:str
 * @desc How much to offset the zoom blur X point by.
 * Negative: left. Positive: right.
 * @default +0
 * 
 * @arg OffsetY:eval
 * @text Offset Y
 * @parent TargetLocation:str
 * @desc How much to offset the zoom blur Y point by.
 * Negative: up. Positive: down.
 * @default +0
 * 
 * @arg Strength:eval
 * @text Zoom Strength
 * @desc What is the strength of the zoom effect?
 * Use a number between 0 and 1.
 * @default 0.5
 * 
 * @arg Radius:eval
 * @text Visible Radius
 * @desc How much of a radius should be visible from the center?
 * @default 0
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc What is the duration of the zoom blur?
 * @default 60
 *
 * @arg EasingType:str
 * @text Easing Type
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * @default OutSine
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceMechanics
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakMechanics
 * @text Action Sequences - Mechanics
 * @desc These Action Sequences are related to various mechanics
 * related to the battle system.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_ActionEffect
 * @text MECH: Action Effect
 * @desc Causes the unit(s) to take damage/healing from action and
 * incurs any changes made such as buffs and states.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to receive the current action's effects.
 * @default ["all targets"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_AddBuffDebuff
 * @text MECH: Add Buff/Debuff
 * @desc Adds buff(s)/debuff(s) to unit(s). 
 * Determine which parameters are affected and their durations.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to receive the buff(s) and/or debuff(s).
 * @default ["user"]
 * 
 * @arg Buffs:arraystr
 * @text Buff Parameters
 * @type combo[]
 * @option MaxHP
 * @option MaxMP
 * @option ATK
 * @option DEF
 * @option MAT
 * @option MDF
 * @option AGI
 * @option LUK
 * @desc Select which parameter(s) to buff.
 * Insert a parameter multiple times to raise its stacks.
 * @default ["ATK"]
 *
 * @arg Debuffs:arraystr
 * @text Debuff Parameters
 * @type combo[]
 * @option MaxHP
 * @option MaxMP
 * @option ATK
 * @option DEF
 * @option MAT
 * @option MDF
 * @option AGI
 * @option LUK
 * @desc Select which parameter(s) to debuff.
 * Insert a parameter multiple times to raise its stacks.
 * @default ["DEF"]
 * 
 * @arg Turns:eval
 * @text Turns
 * @desc Number of turns to set the parameter(s) buffs to.
 * You may use JavaScript code.
 * @default 5
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_AddState
 * @text MECH: Add State
 * @desc Adds state(s) to unit(s).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to receive the buff(s).
 * @default ["user"]
 * 
 * @arg States:arraynum
 * @text States
 * @type state[]
 * @desc Select which state ID(s) to add to unit(s).
 * Insert multiple state ID's to add multiple at once.
 * @default ["4"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_AnalyzeWeakness
 * @text MECH: Analyze Weakness
 * @desc Reveal elemental weakness(es) from target(s).
 * Requires VisuMZ_3_WeaknessDisplay!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to reveal elemental weaknesses for.
 * @default ["all targets"]
 * 
 * @arg Reveal:eval
 * @text Reveal
 * @desc How many elemental weaknesses do you wish to reveal?
 * You may use JavaScript code.
 * @default 1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_ArmorPenetration
 * @text MECH: Armor Penetration
 * @desc Adds an extra layer of defensive penetration/reduction.
 * You may use JavaScript code for any of these.
 *
 * @arg ArmorPenetration
 * @text Armor/Magic Penetration
 * 
 * @arg ArPenRate:eval
 * @text Rate
 * @parent ArmorPenetration
 * @desc Penetrates an extra multiplier of armor by this value.
 * @default 0.00
 * 
 * @arg ArPenFlat:eval
 * @text Flat
 * @parent ArmorPenetration
 * @desc Penetrates a flat amount of armor by this value.
 * @default 0
 *
 * @arg ArmorReduction
 * @text Armor/Magic Reduction
 * 
 * @arg ArRedRate:eval
 * @text Rate
 * @parent ArmorReduction
 * @desc Reduces an extra multiplier of armor by this value.
 * @default 0.00
 * 
 * @arg ArRedFlat:eval
 * @text Flat
 * @parent ArmorReduction
 * @desc Reduces a flat amount of armor by this value.
 * @default 0
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_AtbGauge
 * @text MECH: ATB Gauge
 * @desc Alters the ATB/TPB Gauges.
 * Requires VisuMZ_2_BattleSystemATB!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to alter the ATB/TPB Gauges for.
 * @default ["all targets"]
 *
 * @arg Charging
 * 
 * @arg ChargeRate:eval
 * @text Charge Rate
 * @parent Charging
 * @desc Changes made to the ATB Gauge if it is currently charging.
 * @default -0.00
 * 
 * @arg Casting
 * 
 * @arg CastRate:eval
 * @text Cast Rate
 * @parent Casting
 * @desc Changes made to the ATB Gauge if it is currently casting.
 * @default -0.00
 * 
 * @arg Interrupt:eval
 * @text Interrupt?
 * @parent Casting
 * @type boolean
 * @on Interrupt
 * @off Don't Interrupt
 * @desc Interrupt the ATB Gauge if it is currently casting?
 * @default false
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_BoostPointsChange
 * @text MECH: Boost Points Change
 * @desc Changes Boost Points for target(s).
 * Requires VisuMZ_3_BoostAction!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to alter the Boost Points for.
 * @default ["user"]
 * 
 * @arg BoostPoints:eval
 * @text Alter Boost Points By
 * @desc Alters the unit(s) Boost Points.
 * Positive for gaining points. Negative for losing points.
 * @default +1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_BoostPointsStoreData
 * @text MECH: Boost Store Data
 * @desc Stores the number of Boosts used this action inside a variable.
 * Requires VisuMZ_3_BoostAction!
 * 
 * @arg VariableID:num
 * @text Variable ID
 * @type variable
 * @desc Which variable do you want to store the data inside?
 * @default 1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_BreakShieldChange
 * @text MECH: Break Shield Change
 * @desc Changes Break Shields for target(s) if not Break Stunned.
 * Requires VisuMZ_4_BreakShields!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to alter the Break Shields for.
 * @default ["all targets"]
 * 
 * @arg BreakShields:eval
 * @text Alter Break Shields By
 * @desc Alters the unit(s) Break Shields.
 * Positive for gaining shields. Negative for losing shields.
 * @default -1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_BreakShieldReset
 * @text MECH: Break Shield Reset
 * @desc Resets Break Shields for target(s) if not Break Stunned.
 * Requires VisuMZ_4_BreakShields!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to reset the Break Shields for.
 * @default ["all targets"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_BtbGain
 * @text MECH: BTB Brave Points
 * @desc Alters the target(s) Brave Points to an exact value.
 * Requires VisuMZ_2_BattleSystemBTB!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to alter the ATB/TPB Gauges for.
 * @default ["all targets"]
 * 
 * @arg BravePoints:eval
 * @text Alter Brave Points By
 * @desc Alters the target(s) Brave Points.
 * Positive for gaining BP. Negative for losing BP.
 * @default +1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_Collapse
 * @text MECH: Collapse
 * @desc Causes the unit(s) to perform its collapse animation
 * if the unit(s) has died.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to process a death collapse.
 * @default ["all targets"]
 * 
 * @arg ForceDeath:eval
 * @text Force Death
 * @type boolean
 * @on On
 * @off Off
 * @desc Force death even if the unit has not reached 0 HP?
 * This will remove immortality.
 * @default false
 * 
 * @arg WaitForEffect:eval
 * @text Wait For Effect?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for the collapse effect to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_CtbOrder
 * @text MECH: CTB Order
 * @desc Alters the CTB Turn Order.
 * Requires VisuMZ_2_BattleSystemCTB!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to alter the CTB Turn Order for.
 * @default ["all targets"]
 *
 * @arg ChangeOrderBy:eval
 * @text Change Order By
 * @parent Charging
 * @desc Changes turn order for target(s) by this amount.
 * Positive increases wait. Negative decreases wait.
 * @default +1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_CtbSpeed
 * @text MECH: CTB Speed
 * @desc Alters the CTB Speed.
 * Requires VisuMZ_2_BattleSystemCTB!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to alter the CTB Speed for.
 * @default ["all targets"]
 *
 * @arg ChargeRate:eval
 * @text Charge Rate
 * @parent Charging
 * @desc Changes made to the CTB Speed if it is currently charging.
 * @default -0.00
 * 
 * @arg CastRate:eval
 * @text Cast Rate
 * @parent Casting
 * @desc Changes made to the CTB Speed if it is currently casting.
 * @default -0.00
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_CustomDmgFormula
 * @text MECH: Custom Damage Formula
 * @desc Changes the current action's damage formula to custom.
 * This will assume the MANUAL damage style.
 * 
 * @arg Formula:str
 * @text Formula
 * @desc Changes the current action's damage formula to custom.
 * Use 'default' to revert the damage formula.
 * @default default
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_DamagePopup
 * @text MECH: Damage Popup
 * @desc Causes the unit(s) to display the current state of
 * damage received or healed.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to prompt a damage popup.
 * @default ["all targets"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_DeathBreak
 * @text MECH: Dead Label Jump
 * @desc If the active battler is dead, jump to a specific label in the common event.
 * 
 * @arg JumpToLabel:str
 * @text Jump To Label
 * @desc If the active battler is dead, jump to this specific label in the common event.
 * @default Untitled
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_EnemyEscape
 * @text MECH: Enemy Escape
 * @desc Causes the enemy unit(s) to escape.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to escape.
 * @default ["user"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_EtbAction
 * @text MECH: ETB Energy Count
 * @desc Alters the subject team's available Energy Count.
 * Requires VisuMZ_2_BattleSystemETB!
 * 
 * @arg ActionCount:eval
 * @text Energy Count
 * @desc Alters the subject team's available Energy Count.
 * Positive for gaining energy. Negative for losing energy.
 * @default +1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_FtbAction
 * @text MECH: FTB Action Count
 * @desc Alters the subject team's available Action Count.
 * Requires VisuMZ_2_BattleSystemFTB!
 * 
 * @arg ActionCount:eval
 * @text Action Count
 * @desc Alters the subject team's available Action Count.
 * Positive for gaining actions. Negative for losing actions.
 * @default +1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_HpMpTp
 * @text MECH: HP, MP, TP
 * @desc Alters the HP, MP, and TP values for unit(s).
 * Positive values for healing. Negative values for damage.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to receive the current action's effects.
 * @default ["user"]
 *
 * @arg HP
 * 
 * @arg HP_Rate:eval
 * @text HP Rate
 * @parent HP
 * @desc Changes made to HP based on rate.
 * Positive values for healing. Negative values for damage.
 * @default +0.00
 * 
 * @arg HP_Flat:eval
 * @text HP Flat
 * @parent HP
 * @desc Flat changes made to HP.
 * Positive values for healing. Negative values for damage.
 * @default +0
 * 
 * @arg MP
 * 
 * @arg MP_Rate:eval
 * @text MP Rate
 * @parent MP
 * @desc Changes made to MP based on rate.
 * Positive values for healing. Negative values for damage.
 * @default +0.00
 * 
 * @arg MP_Flat:eval
 * @text MP Flat
 * @parent MP
 * @desc Flat changes made to MP.
 * Positive values for healing. Negative values for damage.
 * @default +0
 *
 * @arg TP
 * 
 * @arg TP_Rate:eval
 * @text TP Rate
 * @parent TP
 * @desc Changes made to TP based on rate.
 * Positive values for healing. Negative values for damage.
 * @default +0.00
 * 
 * @arg TP_Flat:eval
 * @text TP Flat
 * @parent TP
 * @desc Flat changes made to TP.
 * Positive values for healing. Negative values for damage.
 * @default +0
 * 
 * @arg ShowPopup:eval
 * @text Damage Popup?
 * @type boolean
 * @on On
 * @off Off
 * @desc Display a damage popup after?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_Immortal
 * @text MECH: Immortal
 * @desc Changes the immortal flag of targets. If immortal flag is
 * removed and a unit would die, collapse that unit.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Alter the immortal flag of these groups. If immortal flag
 * is removed and a unit would die, collapse that unit.
 * @default ["user","all targets"]
 * 
 * @arg Immortal:eval
 * @text Immortal
 * @type boolean
 * @on On
 * @off Off
 * @desc Turn immortal flag for unit(s) on/off?
 * @default false
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_Multipliers
 * @text MECH: Multipliers
 * @desc Changes the multipliers for the current action.
 * You may use JavaScript code for any of these.
 *
 * @arg CriticalHit
 * @text Critical Hit%
 * 
 * @arg CriticalHitRate:eval
 * @text Rate
 * @parent CriticalHit
 * @desc Affects chance to land a critical hit by this multiplier.
 * @default 1.00
 * 
 * @arg CriticalHitFlat:eval
 * @text Flat
 * @parent CriticalHit
 * @desc Affects chance to land a critical hit by this flat bonus.
 * @default +0.00
 *
 * @arg CriticalDmg
 * @text Critical Damage
 * 
 * @arg CriticalDmgRate:eval
 * @text Rate
 * @parent CriticalDmg
 * @desc Affects critical damage by this multiplier.
 * @default 1.00
 * 
 * @arg CriticalDmgFlat:eval
 * @text Flat
 * @parent CriticalDmg
 * @desc Affects critical damage by this flat bonus.
 * @default +0.00
 *
 * @arg Damage
 * @text Damage/Healing
 * 
 * @arg DamageRate:eval
 * @text Rate
 * @parent Damage
 * @desc Sets the damage/healing multiplier for current action.
 * @default 1.00
 * 
 * @arg DamageFlat:eval
 * @text Flat
 * @parent Damage
 * @desc Sets the damage/healing bonus for current action.
 * @default +0.00
 *
 * @arg HitRate
 * @text Hit Rate
 * 
 * @arg HitRate:eval
 * @text Rate
 * @parent HitRate
 * @desc Affects chance to connect attack by this multiplier.
 * @default 1.00
 * 
 * @arg HitFlat:eval
 * @text Flat
 * @parent HitRate
 * @desc Affects chance to connect attack by this flat bonus.
 * @default +0.00
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_OtbOrder
 * @text MECH: OTB Order
 * @desc Alters the OTB Turn Order. Best used with single targets.
 * Requires VisuMZ_2_BattleSystemOTB!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to alter the OTB Turn Order for.
 * @default ["all targets"]
 *
 * @arg CurrentTurn:eval
 * @text Current Turn By
 * @parent Charging
 * @desc Changes turn order for target(s) by this amount.
 * Positive increases wait. Negative decreases wait.
 * @default +0
 *
 * @arg NextTurn:eval
 * @text Next Turn By
 * @parent Charging
 * @desc Changes turn order for target(s) by this amount.
 * Positive increases wait. Negative decreases wait.
 * @default +1
 *
 * @arg FollowTurn:eval
 * @text Follow Turn By
 * @parent Charging
 * @desc Changes turn order for target(s) by this amount.
 * Positive increases wait. Negative decreases wait.
 * @default +0
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_PtbAlterCost
 * @text MECH: PTB Alter Cost
 * @desc Alters the action's cost settings.
 * Requires VisuMZ_2_BattleSystemPTB!
 *
 * @arg Override:eval
 * @text Override?
 * @type boolean
 * @on Override Permanent
 * @off Require Temporary
 * @desc Overrides any 'permanent' settings for Changeability?
 * @default false
 *
 * @arg alterChange:str
 * @text Alter Changeability
 * @type select
 * @option Unchanged - Cost type is unchanged after this effect
 * @value unchanged
 * @option Permanent - Cost type can no longer be changed after
 * @value permanent
 * @option Temporary - Cost type can still be changed after
 * @value temporary
 * @desc Allow the cost type and value to be changeable?
 * @default unchanged
 *
 * @arg alterType:str
 * @text Alter Cost Type
 * @type select
 * @option Unchanged - No changes are made
 * @value unchanged
 * @option Consume - Removes half, otherwise consumes full
 * @value consume
 * @option Convert - Converts full => half, otherwise consumes half
 * @value convert
 * @option Compress - Consumes half, otherwise converts full => half
 * @value compress
 * @desc Change the cost type to this scenario.
 * Use 'Unchanged' for no changes.
 * @default convert
 *
 * @arg alterCost:eval
 * @text Alter Cost Value
 * @desc What is the default action cost for this scenario?
 * @default +0
 *
 * @arg alterPriority:eval
 * @text Priority
 * @desc What is this scenario's priority? Scenario outcomes with
 * equal or lower priorities cannot override types and costs.
 * @default 50
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_PtbConvert
 * @text MECH: PTB Conversion
 * @desc Converts full actions into half actions.
 * Requires VisuMZ_2_BattleSystemPTB!
 * 
 * @arg ConvertCount:eval
 * @text Conversion Count
 * @desc Converts full actions into half actions.
 * If not enough, consume half actions.
 * @default 1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_PtbFullHalfAction
 * @text MECH: PTB Full/Half Action(s)
 * @desc Alters the subject team's available Full/Half Actions.
 * Requires VisuMZ_2_BattleSystemPTB!
 * 
 * @arg FullActions:eval
 * @text Full Actions
 * @desc Alters the subject team's available Full Actions.
 * Positive for gaining. Negative for losing.
 * @default +0
 * 
 * @arg HalfActions:eval
 * @text Half Actions
 * @desc Alters the subject team's available Half Actions.
 * Positive for gaining. Negative for losing.
 * @default +0
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_RemoveBuffDebuff
 * @text MECH: Remove Buff/Debuff
 * @desc Removes buff(s)/debuff(s) from unit(s). 
 * Determine which parameters are removed.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to have the buff(s) and/or debuff(s) removed.
 * @default ["user"]
 * 
 * @arg Buffs:arraystr
 * @text Buff Parameters
 * @type combo[]
 * @option MaxHP
 * @option MaxMP
 * @option ATK
 * @option DEF
 * @option MAT
 * @option MDF
 * @option AGI
 * @option LUK
 * @desc Select which buffed parameter(s) to remove.
 * @default ["MaxHP","MaxMP","ATK","DEF","MAT","MDF","AGI","LUK"]
 *
 * @arg Debuffs:arraystr
 * @text Debuff Parameters
 * @type combo[]
 * @option MaxHP
 * @option MaxMP
 * @option ATK
 * @option DEF
 * @option MAT
 * @option MDF
 * @option AGI
 * @option LUK
 * @desc Select which debuffed parameter(s) to remove.
 * @default ["MaxHP","MaxMP","ATK","DEF","MAT","MDF","AGI","LUK"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_RemoveState
 * @text MECH: Remove State
 * @desc Remove state(s) from unit(s).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to have states removed from.
 * @default ["user"]
 * 
 * @arg States:arraynum
 * @text States
 * @type state[]
 * @desc Select which state ID(s) to remove from unit(s).
 * Insert multiple state ID's to remove multiple at once.
 * @default ["4"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_StbExploit
 * @text MECH: STB Exploit Effect
 * @desc Utilize the STB Exploitation mechanics!
 * Requires VisuMZ_2_BattleSystemSTB!
 * 
 * @arg Exploited:eval
 * @text Target(s) Exploited?
 * @type boolean
 * @on Exploit
 * @off Don't
 * @desc Exploit the below targets?
 * @default true
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to become exploited.
 * @default ["all targets"]
 * 
 * @arg ForceExploited:eval
 * @text Force Exploitation
 * @type boolean
 * @on Force
 * @off Don't
 * @desc Force the exploited status?
 * @default false
 * 
 * @arg Exploiter:eval
 * @text User Exploiter?
 * @type boolean
 * @on Exploit
 * @off Don't
 * @desc Allow the user to become the exploiter?
 * @default true
 * 
 * @arg ForceExploited:eval
 * @text Force Exploitation
 * @type boolean
 * @on Force
 * @off Don't
 * @desc Force the exploiter status?
 * @default false
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_StbExtraAction
 * @text MECH: STB Extra Action
 * @desc Adds an extra action for the currently active battler.
 * Requires VisuMZ_2_BattleSystemSTB!
 * 
 * @arg Actions:eval
 * @text Extra Actions
 * @parent Charging
 * @desc How many extra actions should the active battler gain?
 * You may use JavaScript code.
 * @default 1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_StbRemoveExcessActions
 * @text MECH: STB Remove Excess Actions
 * @desc Removes excess actions from the active battler.
 * Requires VisuMZ_2_BattleSystemSTB!
 * 
 * @arg Actions:eval
 * @text Remove Actions
 * @parent Charging
 * @desc How many actions to remove from the active battler?
 * You may use JavaScript code.
 * @default 99
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_SwapWeapon
 * @text MECH: Swap Weapon
 * @desc Causes the unit(s) to swap their weapon for another.
 * Requires VisuMZ_2_WeaponSwapSystem!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to swap weapons for.
 * @default ["user"]
 * 
 * @arg WeaponTypeID:eval
 * @text Weapon Type ID
 * @desc Which weapon type to swap to?
 * This is NOT the weapon's ID. It's the weapon TYPE.
 * @default 1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_TextPopup
 * @text MECH: Text Popup
 * @desc Causes the unit(s) to display a text popup.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to prompt a text popup.
 * @default ["target"]
 * 
 * @arg Text:str
 * @text Text
 * @desc What text do you wish to display?
 * @default Text
 * 
 * @arg TextColor:str
 * @text Text Color
 * @parent Text:str
 * @desc Use #rrggbb for custom colors or regular numbers
 * for text colors from the Window Skin.
 * @default #ffffff
 *
 * @arg FlashColor:eval
 * @text Flash Color
 * @parent Popups
 * @desc Adjust the popup's flash color.
 * Format: [red, green, blue, alpha]
 * @default [255, 0, 0, 160]
 * 
 * @arg FlashDuration:num
 * @text Flash Duration
 * @parent FlashColor:eval
 * @type Number
 * @desc What is the frame duration of the flash effect?
 * @default 60
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_VariablePopup
 * @text MECH: Variable Popup
 * @desc Causes the unit(s) to display a popup using the data
 * stored inside a variable.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to prompt a text popup.
 * @default ["target"]
 * 
 * @arg Variable:num
 * @text Variable ID
 * @type variable
 * @desc Get data from which variable to display as a popup?
 * @default 1
 * 
 * @arg DigitGrouping:eval
 * @text Digit Grouping
 * @parent Variable:num
 * @type boolean
 * @on Group Digits
 * @off Don't Group
 * @desc Use digit grouping to separate numbers?
 * Requires VisuMZ_0_CoreEngine!
 * @default true
 * 
 * @arg TextColor:str
 * @text Text Color
 * @parent Variable:num
 * @desc Use #rrggbb for custom colors or regular numbers
 * for text colors from the Window Skin.
 * @default #ffffff
 *
 * @arg FlashColor:eval
 * @text Flash Color
 * @parent Popups
 * @desc Adjust the popup's flash color.
 * Format: [red, green, blue, alpha]
 * @default [0, 0, 0, 0]
 * 
 * @arg FlashDuration:num
 * @text Flash Duration
 * @parent FlashColor:eval
 * @type Number
 * @desc What is the frame duration of the flash effect?
 * @default 60
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_WaitForEffect
 * @text MECH: Wait For Effect
 * @desc Waits for the effects to complete before performing next command.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceMotion
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakMotion
 * @text Action Sequences - Motion
 * @desc These Action Sequences allow you the ability to control
 * the motions of sideview sprites.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Motion_ClearFreezeFrame
 * @text MOTION: Clear Freeze Frame
 * @desc Clears any freeze frames from the unit(s).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to clear freeze frames for.
 * @default ["user"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Motion_FreezeMotionFrame
 * @text MOTION: Freeze Motion Frame
 * @desc Forces a freeze frame instantly at the selected motion.
 * Automatically clears with a new motion.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to freeze motions for.
 * @default ["user"]
 *
 * @arg MotionType:str
 * @text Motion Type
 * @type combo
 * @option walk
 * @option wait
 * @option chant
 * @option guard
 * @option damage
 * @option evade
 * @option attack
 * @option thrust
 * @option swing
 * @option missile
 * @option skill
 * @option spell
 * @option item
 * @option escape
 * @option victory
 * @option dying
 * @option abnormal
 * @option sleep
 * @option dead
 * @desc Freeze this motion for the unit(s).
 * @default attack
 * 
 * @arg Frame:num
 * @text Frame Index
 * @desc Which frame do you want to freeze the motion on?
 * Frame index values start at 0.
 * @default 2
 *
 * @arg ShowWeapon:eval
 * @text Show Weapon?
 * @type combo
 * @type boolean
 * @on Show
 * @off Hide
 * @desc If using 'attack', 'thrust', 'swing', or 'missile',
 * display the weapon sprite?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Motion_MotionType
 * @text MOTION: Motion Type
 * @desc Causes the unit(s) to play the selected motion.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to perform a motion.
 * @default ["user"]
 *
 * @arg MotionType:str
 * @text Motion Type
 * @type combo
 * @option walk
 * @option wait
 * @option chant
 * @option guard
 * @option damage
 * @option evade
 * @option attack
 * @option thrust
 * @option swing
 * @option missile
 * @option skill
 * @option spell
 * @option item
 * @option escape
 * @option victory
 * @option dying
 * @option abnormal
 * @option sleep
 * @option dead
 * @desc Play this motion for the unit(s).
 * @default attack
 *
 * @arg ShowWeapon:eval
 * @text Show Weapon?
 * @type combo
 * @type boolean
 * @on Show
 * @off Hide
 * @desc If using 'attack', 'thrust', 'swing', or 'missile',
 * display the weapon sprite?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Motion_PerformAction
 * @text MOTION: Perform Action
 * @desc Causes the unit(s) to play the proper motion based
 * on the current action.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to perform a motion.
 * @default ["user"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Motion_RefreshMotion
 * @text MOTION: Refresh Motion
 * @desc Cancels any set motions unit(s) has to do and use
 * their most natural motion at the moment.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to refresh their motion state.
 * @default ["user"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Motion_WaitMotionFrame
 * @text MOTION: Wait By Motion Frame
 * @desc Creates a wait equal to the number of motion frames passing.
 * Time is based on Plugin Parameters => Actors => Motion Speed.
 *
 * @arg MotionFrameWait:num
 * @text Motion Frames to Wait?
 * @type number
 * @min 1
 * @desc Each "frame" is equal to the value found in
 * Plugin Parameters => Actors => Motion Speed
 * @default 1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceMovement
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakMovement
 * @text Action Sequences - Movement
 * @desc These Action Sequences allow you the ability to control
 * the sprites of actors and enemies in battle.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_BattleStep
 * @text MOVE: Battle Step
 * @desc Causes the unit(s) to move forward past their home position
 * to prepare for action.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to move.
 * @default ["user"]
 * 
 * @arg WaitForMovement:eval
 * @text Wait For Movement?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for movement to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_FaceDirection
 * @text MOVE: Face Direction
 * @desc Causes the unit(s) to face forward or backward.
 * Sideview-only!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to change direction.
 * @default ["user"]
 * 
 * @arg Direction:str
 * @text Direction
 * @type combo
 * @option forward
 * @option backward
 * @option random
 * @desc Select which direction to face.
 * @default forward
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_FacePoint
 * @text MOVE: Face Point
 * @desc Causes the unit(s) to face a point on the screen.
 * Sideview-only!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to change direction.
 * @default ["user"]
 * 
 * @arg Point:str
 * @text Point
 * @type combo
 * @option home
 * @option center
 * @option point x, y
 * @desc Select which point to face.
 * Replace 'x' and 'y' with coordinates
 * @default home
 * 
 * @arg FaceAway:eval
 * @text Face Away From?
 * @type boolean
 * @on Turn Away
 * @off Face Directly
 * @desc Face away from the point instead?
 * @default false
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_FaceTarget
 * @text MOVE: Face Target(s)
 * @desc Causes the unit(s) to face other targets on the screen.
 * Sideview-only!
 * 
 * @arg Targets1:arraystr
 * @text Targets (facing)
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to change direction.
 * @default ["user"]
 * 
 * @arg Targets2:arraystr
 * @text Targets (destination)
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) for the turning unit(s) to face.
 * @default ["current target"]
 * 
 * @arg FaceAway:eval
 * @text Face Away From?
 * @type boolean
 * @on Turn Away
 * @off Face Directly
 * @desc Face away from the unit(s) instead?
 * @default false
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_Float
 * @text MOVE: Float
 * @desc Causes the unit(s) to float above the ground.
 * Sideview-only!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to make float.
 * @default ["user"]
 * 
 * @arg Height:eval
 * @text Desired Height
 * @desc Vertical distance to float upward.
 * You may use JavaScript code.
 * @default 100
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for total float amount.
 * @default 12
 *
 * @arg EasingType:str
 * @text Float Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 * 
 * @arg WaitForFloat:eval
 * @text Wait For Float?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for floating to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_HomeReset
 * @text MOVE: Home Reset
 * @desc Causes the unit(s) to move back to their home position(s)
 * and face back to their original direction(s).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to move.
 * @default ["alive battlers"]
 * 
 * @arg WaitForMovement:eval
 * @text Wait For Movement?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for movement to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_Jump
 * @text MOVE: Jump
 * @desc Causes the unit(s) to jump into the air.
 * Sideview-only!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to make jump.
 * @default ["user"]
 * 
 * @arg Height:eval
 * @text Desired Height
 * @desc Max jump height to go above the ground
 * You may use JavaScript code.
 * @default 100
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for total jump amount.
 * @default 12
 * 
 * @arg WaitForJump:eval
 * @text Wait For Jump?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for jumping to complete before performing next command?
 * @default false
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_MoveBy
 * @text MOVE: Move Distance
 * @desc Moves unit(s) by a distance from their current position(s).
 * Sideview-only!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to move.
 * @default ["user"]
 *
 * @arg DistanceAdjust:str
 * @text Distance Adjustment
 * @type select
 * @option Normal - No adjustments made
 * @value none
 * @option Horizontal - Actors adjust left, Enemies adjust right
 * @value horz
 * @option Vertical - Actors adjust Up, Enemies adjust down
 * @value vert
 * @option Both - Applies both Horizontal and Vertical
 * @value horz + vert
 * @desc Makes adjustments to distance values to determine
 * which direction to move unit(s).
 * @default horz
 * 
 * @arg DistanceX:eval
 * @text Distance: X
 * @parent DistanceAdjust:str
 * @desc Horizontal distance to move.
 * You may use JavaScript code.
 * @default 48
 * 
 * @arg DistanceY:eval
 * @text Distance: Y
 * @parent DistanceAdjust:str
 * @desc Vertical distance to move.
 * You may use JavaScript code.
 * @default 0
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for total movement amount.
 * @default 12
 * 
 * @arg FaceDirection:eval
 * @text Face Destination?
 * @type boolean
 * @on Turn
 * @off Don't
 * @desc Turn and face the destination?
 * @default true
 *
 * @arg EasingType:str
 * @text Movement Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 *
 * @arg MotionType:str
 * @text Movement Motion
 * @type combo
 * @option walk
 * @option wait
 * @option chant
 * @option guard
 * @option damage
 * @option evade
 * @option thrust
 * @option swing
 * @option missile
 * @option skill
 * @option spell
 * @option item
 * @option escape
 * @option victory
 * @option dying
 * @option abnormal
 * @option sleep
 * @option dead
 * @desc Play this motion for the unit(s).
 * @default walk
 * 
 * @arg WaitForMovement:eval
 * @text Wait For Movement?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for movement to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_MoveToPoint
 * @text MOVE: Move To Point
 * @desc Moves unit(s) to a designated point on the screen.
 * Sideview-only! Points based off Graphics.boxWidth/Height.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to move.
 * @default ["user"]
 * 
 * @arg Destination:str
 * @text Destination Point
 * @type combo
 * @option home
 * @option center
 * @option point x, y
 * @desc Select which point to face.
 * Replace 'x' and 'y' with coordinates
 * @default home
 *
 * @arg OffsetAdjust:str
 * @text Offset Adjustment
 * @parent Destination:str
 * @type select
 * @option Normal - No adjustments made
 * @value none
 * @option Horizontal - Actors adjust left, Enemies adjust right
 * @value horz
 * @option Vertical - Actors adjust Up, Enemies adjust down
 * @value vert
 * @option Both - Applies both Horizontal and Vertical
 * @value horz + vert
 * @desc Makes adjustments to offset values to determine
 * which direction to adjust the destination by.
 * @default horz
 * 
 * @arg OffsetX:eval
 * @text Offset: X
 * @parent OffsetAdjust:str
 * @desc Horizontal offset to move.
 * You may use JavaScript code.
 * @default 0
 * 
 * @arg OffsetY:eval
 * @text Offset: Y
 * @parent OffsetAdjust:str
 * @desc Vertical offset to move.
 * You may use JavaScript code.
 * @default 0
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for total movement amount.
 * @default 12
 * 
 * @arg FaceDirection:eval
 * @text Face Destination?
 * @type boolean
 * @on Turn
 * @off Don't
 * @desc Turn and face the destination?
 * @default true
 *
 * @arg EasingType:str
 * @text Movement Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 *
 * @arg MotionType:str
 * @text Movement Motion
 * @type combo
 * @option walk
 * @option wait
 * @option chant
 * @option guard
 * @option damage
 * @option evade
 * @option thrust
 * @option swing
 * @option missile
 * @option skill
 * @option spell
 * @option item
 * @option escape
 * @option victory
 * @option dying
 * @option abnormal
 * @option sleep
 * @option dead
 * @desc Play this motion for the unit(s).
 * @default walk
 * 
 * @arg WaitForMovement:eval
 * @text Wait For Movement?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for movement to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_MoveToTarget
 * @text MOVE: Move To Target(s)
 * @desc Moves unit(s) to another unit(s) on the battle field.
 * Sideview-only!
 * 
 * @arg Targets1:arraystr
 * @text Targets (Moving)
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to move.
 * @default ["user"]
 * 
 * @arg Targets2:arraystr
 * @text Targets (Destination)
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to move to.
 * @default ["all targets"]
 * 
 * @arg TargetLocation:str
 * @text Target Location
 * @parent Targets2:arraystr
 * @type combo
 * @option front head
 * @option front center
 * @option front base
 * @option middle head
 * @option middle center
 * @option middle base
 * @option back head
 * @option back center
 * @option back base
 * @desc Select which part target group to move to.
 * @default front base
 * 
 * @arg MeleeDistance:eval
 * @text Melee Distance
 * @parent TargetLocation:str
 * @desc The melee distance away from the target location
 * in addition to the battler's width.
 * @default 24
 *
 * @arg OffsetAdjust:str
 * @text Offset Adjustment
 * @parent Targets2:arraystr
 * @type select
 * @option Normal - No adjustments made
 * @value none
 * @option Horizontal - Actors adjust left, Enemies adjust right
 * @value horz
 * @option Vertical - Actors adjust Up, Enemies adjust down
 * @value vert
 * @option Both - Applies both Horizontal and Vertical
 * @value horz + vert
 * @desc Makes adjustments to offset values to determine
 * which direction to adjust the destination by.
 * @default horz
 * 
 * @arg OffsetX:eval
 * @text Offset: X
 * @parent OffsetAdjust:str
 * @desc Horizontal offset to move.
 * You may use JavaScript code.
 * @default 0
 * 
 * @arg OffsetY:eval
 * @text Offset: Y
 * @parent OffsetAdjust:str
 * @desc Vertical offset to move.
 * You may use JavaScript code.
 * @default 0
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for total movement amount.
 * @default 12
 * 
 * @arg FaceDirection:eval
 * @text Face Destination?
 * @type boolean
 * @on Turn
 * @off Don't
 * @desc Turn and face the destination?
 * @default true
 *
 * @arg EasingType:str
 * @text Movement Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 *
 * @arg MotionType:str
 * @text Movement Motion
 * @type combo
 * @option walk
 * @option wait
 * @option chant
 * @option guard
 * @option damage
 * @option evade
 * @option thrust
 * @option swing
 * @option missile
 * @option skill
 * @option spell
 * @option item
 * @option escape
 * @option victory
 * @option dying
 * @option abnormal
 * @option sleep
 * @option dead
 * @desc Play this motion for the unit(s).
 * @default walk
 * 
 * @arg WaitForMovement:eval
 * @text Wait For Movement?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for movement to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_Opacity
 * @text MOVE: Opacity
 * @desc Causes the unit(s) to change opacity.
 * Sideview-only!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to change opacity.
 * @default ["user"]
 * 
 * @arg Opacity:eval
 * @text Desired Opacity
 * @desc Change to this opacity value.
 * You may use JavaScript code.
 * @default 255
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for opacity change.
 * @default 12
 *
 * @arg EasingType:str
 * @text Opacity Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 * 
 * @arg WaitForOpacity:eval
 * @text Wait For Opacity?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for opacity changes to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_Scale
 * @text MOVE: Scale/Grow/Shrink
 * @desc Causes the unit(s) to scale, grow, or shrink?.
 * Sideview-only!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to change the scale of.
 * @default ["user"]
 * 
 * @arg ScaleX:eval
 * @text Scale X
 * @desc What target scale value do you want?
 * 1.0 is normal size.
 * @default 1.00
 * 
 * @arg ScaleY:eval
 * @text Scale Y
 * @desc What target scale value do you want?
 * 1.0 is normal size.
 * @default 1.00
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames to scale for.
 * @default 12
 *
 * @arg EasingType:str
 * @text Scale Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 * 
 * @arg WaitForScale:eval
 * @text Wait For Scale?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for scaling to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_Skew
 * @text MOVE: Skew/Distort
 * @desc Causes the unit(s) to skew.
 * Sideview-only!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to skew.
 * @default ["user"]
 * 
 * @arg SkewX:eval
 * @text Skew X
 * @desc X variance to skew?
 * Use small values for the best results.
 * @default 0.00
 * 
 * @arg SkewY:eval
 * @text Skew Y
 * @desc Y variance to skew?
 * Use small values for the best results.
 * @default 0.00
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames to skew for.
 * @default 12
 *
 * @arg EasingType:str
 * @text Skew Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 * 
 * @arg WaitForSkew:eval
 * @text Wait For Skew?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for skew to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_Spin
 * @text MOVE: Spin/Rotate
 * @desc Causes the unit(s) to spin.
 * Sideview-only!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to spin.
 * @default ["user"]
 * 
 * @arg Angle:eval
 * @text Angle
 * @desc How many degrees to spin?
 * @default 360
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames to spin for.
 * @default 12
 *
 * @arg EasingType:str
 * @text Spin Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 * 
 * @arg RevertAngle:eval
 * @text Revert Angle on Finish
 * @type boolean
 * @on Revert
 * @off Don't
 * @desc Revert angle after spinning?
 * @default true
 * 
 * @arg WaitForSpin:eval
 * @text Wait For Spin?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for spin to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_WaitForFloat
 * @text MOVE: Wait For Float
 * @desc Waits for floating to complete before performing next command.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_WaitForJump
 * @text MOVE: Wait For Jump
 * @desc Waits for jumping to complete before performing next command.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_WaitForMovement
 * @text MOVE: Wait For Movement
 * @desc Waits for movement to complete before performing next command.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_WaitForOpacity
 * @text MOVE: Wait For Opacity
 * @desc Waits for opacity changes to complete before performing next command.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_WaitForScale
 * @text MOVE: Wait For Scale
 * @desc Waits for scaling to complete before performing next command.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_WaitForSkew
 * @text MOVE: Wait For Skew
 * @desc Waits for skewing to complete before performing next command.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_WaitForSpin
 * @text MOVE: Wait For Spin
 * @desc Waits for spinning to complete before performing next command.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceProjectile
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakProjectile
 * @text Action Sequences - Projectiles
 * @desc Create projectiles on the screen and fire them off at a target.
 * Requires VisuMZ_3_ActSeqProjectiles!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Projectile_Animation
 * @text PROJECTILE: Animation
 * @desc Create an animation projectile and fire it at a target.
 * Requires VisuMZ_3_ActSeqProjectiles!
 * 
 * @arg Coordinates
 *
 * @arg Start:struct
 * @text Start Location
 * @parent Coordinates
 * @type struct<ProjectileStart>
 * @desc Settings to determine where the projectile(s) start from.
 * @default {"Type:str":"target","Targets:arraystr":"[\"user\"]","TargetCenter:eval":"false","PointX:eval":"Graphics.width / 2","PointY:eval":"Graphics.height / 2","OffsetX:eval":"+0","OffsetY:eval":"+0"}
 *
 * @arg Goal:struct
 * @text Goal Location
 * @parent Coordinates
 * @type struct<ProjectileGoal>
 * @desc Settings to determine where the projectile(s) start from.
 * @default {"Type:str":"target","Targets:arraystr":"[\"all targets\"]","TargetCenter:eval":"false","PointX:eval":"Graphics.width / 2","PointY:eval":"Graphics.height / 2","OffsetX:eval":"+0","OffsetY:eval":"+0"}
 * 
 * @arg Settings
 *
 * @arg AnimationID:num
 * @text Animation ID
 * @parent Settings
 * @type animation
 * @desc Determine which animation to use as a projectile.
 * @default 77
 * 
 * @arg Duration:eval
 * @text Duration
 * @parent Settings
 * @desc Duration for the projectile(s) to travel.
 * @default 20
 * 
 * @arg WaitForProjectile:eval
 * @text Wait For Projectile?
 * @parent Settings
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for projectile(s) to reach their destination before
 * going onto the next command?
 * @default true
 * 
 * @arg Extra:struct
 * @text Extra Settings
 * @type struct<ProjectileExAni>
 * @desc Add extra settings to the projectile?
 * @default {"AutoAngle:eval":"true","AngleOffset:eval":"+0","Arc:eval":"0","EasingType:str":"Linear","Spin:eval":"+0.0"}
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Projectile_Icon
 * @text PROJECTILE: Icon
 * @desc Create an icon projectile and fire it at a target.
 * Requires VisuMZ_3_ActSeqProjectiles!
 * 
 * @arg Coordinates
 *
 * @arg Start:struct
 * @text Start Location
 * @parent Coordinates
 * @type struct<ProjectileStart>
 * @desc Settings to determine where the projectile(s) start from.
 * @default {"Type:str":"target","Targets:arraystr":"[\"user\"]","TargetCenter:eval":"false","PointX:eval":"Graphics.width / 2","PointY:eval":"Graphics.height / 2","OffsetX:eval":"+0","OffsetY:eval":"+0"}
 *
 * @arg Goal:struct
 * @text Goal Location
 * @parent Coordinates
 * @type struct<ProjectileGoal>
 * @desc Settings to determine where the projectile(s) start from.
 * @default {"Type:str":"target","Targets:arraystr":"[\"all targets\"]","TargetCenter:eval":"false","PointX:eval":"Graphics.width / 2","PointY:eval":"Graphics.height / 2","OffsetX:eval":"+0","OffsetY:eval":"+0"}
 * 
 * @arg Settings
 *
 * @arg Icon:eval
 * @text Icon Index
 * @parent Settings
 * @desc Determine which icon to use as a projectile.
 * You may use JavaScript code.
 * @default 118
 * 
 * @arg Duration:eval
 * @text Duration
 * @parent Settings
 * @desc Duration for the projectile(s) to travel.
 * @default 20
 * 
 * @arg WaitForProjectile:eval
 * @text Wait For Projectile?
 * @parent Settings
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for projectile(s) to reach their destination before
 * going onto the next command?
 * @default true
 * 
 * @arg Extra:struct
 * @text Extra Settings
 * @type struct<ProjectileExtra>
 * @desc Add extra settings to the projectile?
 * @default {"AutoAngle:eval":"true","AngleOffset:eval":"+0","Arc:eval":"0","BlendMode:num":"0","EasingType:str":"Linear","Hue:eval":"0","Scale:eval":"1.0","Spin:eval":"+0.0"}
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Projectile_Picture
 * @text PROJECTILE: Picture
 * @desc Create a picture projectile and fire it at a target.
 * Requires VisuMZ_3_ActSeqProjectiles!
 * 
 * @arg Coordinates
 *
 * @arg Start:struct
 * @text Start Location
 * @parent Coordinates
 * @type struct<ProjectileStart>
 * @desc Settings to determine where the projectile(s) start from.
 * @default {"Type:str":"target","Targets:arraystr":"[\"user\"]","TargetCenter:eval":"false","PointX:eval":"Graphics.width / 2","PointY:eval":"Graphics.height / 2","OffsetX:eval":"+0","OffsetY:eval":"+0"}
 *
 * @arg Goal:struct
 * @text Goal Location
 * @parent Coordinates
 * @type struct<ProjectileGoal>
 * @desc Settings to determine where the projectile(s) start from.
 * @default {"Type:str":"target","Targets:arraystr":"[\"all targets\"]","TargetCenter:eval":"false","PointX:eval":"Graphics.width / 2","PointY:eval":"Graphics.height / 2","OffsetX:eval":"+0","OffsetY:eval":"+0"}
 * 
 * @arg Settings
 *
 * @arg Picture:str
 * @text Picture Filename
 * @parent Settings
 * @type file
 * @dir img/pictures/
 * @desc Determine which picture to use as a projectile.
 * @default Untitled
 * 
 * @arg Duration:eval
 * @text Duration
 * @parent Settings
 * @desc Duration for the projectile(s) to travel.
 * @default 20
 * 
 * @arg WaitForProjectile:eval
 * @text Wait For Projectile?
 * @parent Settings
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for projectile(s) to reach their destination before
 * going onto the next command?
 * @default true
 * 
 * @arg Extra:struct
 * @text Extra Settings
 * @type struct<ProjectileExtra>
 * @desc Add extra settings to the projectile?
 * @default {"AutoAngle:eval":"true","AngleOffset:eval":"+0","Arc:eval":"0","BlendMode:num":"0","EasingType:str":"Linear","Hue:eval":"0","Scale:eval":"1.0","Spin:eval":"+0.0"}
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceSkew
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakSkew
 * @text Action Sequences - Skew
 * @desc Allows you to have control over the camera skew.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_ChangeSkew
 * @text SKEW: Change Skew
 * @desc Changes the camera skew.
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * @arg SkewX:eval
 * @text Skew X
 * @desc Change the camera skew X to this value.
 * @default 0
 * 
 * @arg SkewY:eval
 * @text Skew Y
 * @desc Change the camera skew Y to this value.
 * @default 0
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames to change camera skew.
 * @default 60
 *
 * @arg EasingType:str
 * @text Skew Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default InOutSine
 * 
 * @arg WaitForSkew:eval
 * @text Wait For Skew?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for skew changes to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Skew_Reset
 * @text SKEW: Reset Skew
 * @desc Reset any skew settings.
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames to reset camera skew.
 * @default 60
 *
 * @arg EasingType:str
 * @text Skew Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default InOutSine
 * 
 * @arg WaitForSkew:eval
 * @text Wait For Skew?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for skew changes to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Skew_WaitForSkew
 * @text SKEW: Wait For Skew
 * @desc Waits for skew changes to complete before performing next command.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceTarget
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakTarget
 * @text Action Sequences - Target
 * @desc If using a manual target by target Action Sequence,
 * these commands will give you full control over its usage.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Target_CurrentIndex
 * @text TARGET: Current Index
 * @desc Sets the current index to this value.
 * Then decide to jump to a label (optional).
 * 
 * @arg Index:eval
 * @text Set Index To
 * @desc Sets current targeting index to this value.
 * 0 is the starting index of a target group.
 * @default 0
 * 
 * @arg JumpToLabel:str
 * @text Jump To Label
 * @desc If a target is found after the index change,
 * jump to this label in the Common Event.
 * @default Untitled
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Target_NextTarget
 * @text TARGET: Next Target
 * @desc Moves index forward by 1 to select a new current target.
 * Then decide to jump to a label (optional).
 * 
 * @arg JumpToLabel:str
 * @text Jump To Label
 * @desc If a target is found after the index change,
 * jump to this label in the Common Event.
 * @default Untitled
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Target_PrevTarget
 * @text TARGET: Previous Target
 * @desc Moves index backward by 1 to select a new current target.
 * Then decide to jump to a label (optional).
 * 
 * @arg JumpToLabel:str
 * @text Jump To Label
 * @desc If a target is found after the index change,
 * jump to this label in the Common Event.
 * @default Untitled
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Target_RandTarget
 * @text TARGET: Random Target
 * @desc Sets index randomly to determine new currernt target.
 * Then decide to jump to a label (optional).
 * 
 * @arg ForceRandom:eval
 * @text Force Random?
 * @type boolean
 * @on On
 * @off Off
 * @desc Index cannot be its previous index amount after random.
 * @default false
 * 
 * @arg JumpToLabel:str
 * @text Jump To Label
 * @desc If a target is found after the index change,
 * jump to this label in the Common Event.
 * @default Untitled
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceWeapon
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakWeapon
 * @text Action Sequences - Weapon
 * @desc Allows for finer control over Dual/Multi Wielding actors.
 * Only works for Actors.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Weapon_ClearActiveWeapon
 * @text WEAPON: Clear Weapon Slot
 * @desc Clears the active weapon slot (making others valid again).
 * Only works for Actors.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @desc Select unit(s) to clear the active weapon slot for.
 * @default ["user"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Weapon_NextActiveWeapon
 * @text WEAPON: Next Weapon Slot
 * @desc Goes to next active weapon slot (making others invalid).
 * If next slot is weaponless, don't label jump.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @desc Select unit(s) to change the next active weapon slot for.
 * @default ["user"]
 * 
 * @arg JumpToLabel:str
 * @text Jump To Label
 * @desc If a weapon is found after the index change,
 * jump to this label in the Common Event.
 * @default Untitled
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Weapon_SetActiveWeapon
 * @text WEAPON: Set Weapon Slot
 * @desc Sets the active weapon slot (making others invalid).
 * Only works for Actors.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @desc Select unit(s) to change the active weapon slot for.
 * @default ["user"]
 * 
 * @arg SlotID:eval
 * @text Weapon Slot ID
 * @desc Select weapon slot to make active (making others invalid).
 * Use 0 to clear and normalize. You may use JavaScript code.
 * @default 1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceZoom
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakZoom
 * @text Action Sequences - Zoom
 * @desc Allows you to have control over the screen zoom.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Zoom_Scale
 * @text ZOOM: Change Scale
 * @desc Changes the zoom scale.
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * @arg Scale:eval
 * @text Scale
 * @desc The zoom scale to change to.
 * @default 1.0
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames to change battle zoom.
 * @default 60
 *
 * @arg EasingType:str
 * @text Zoom Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default InOutSine
 * 
 * @arg WaitForZoom:eval
 * @text Wait For Zoom?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for zoom changes to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Zoom_Reset
 * @text ZOOM: Reset Zoom
 * @desc Reset any zoom settings.
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames to reset battle zoom.
 * @default 60
 *
 * @arg EasingType:str
 * @text Zoom Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default InOutSine
 * 
 * @arg WaitForZoom:eval
 * @text Wait For Zoom?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for zoom changes to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Zoom_WaitForZoom
 * @text ZOOM: Wait For Zoom
 * @desc Waits for zoom to complete before performing next command.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceEnd
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @ ==========================================================================
 * @ Plugin Parameters
 * @ ==========================================================================
 *
 * @param BreakHead
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param BattleCore
 * @default Plugin Parameters
 *
 * @param ATTENTION
 * @default READ THE HELP FILE
 *
 * @param BreakSettings
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param AutoBattle:struct
 * @text Auto Battle Settings
 * @type struct<AutoBattle>
 * @desc Settings pertaining to Auto Battle.
 * @default {"BattleDisplay":"","AutoBattleMsg:str":"Press %1 or %2 to stop Auto Battle","AutoBattleOK:str":"OK","AutoBattleCancel:str":"Cancel","AutoBattleBgType:num":"1","AutoBattleRect:func":"\"const width = Graphics.width;\\nconst height = this.calcWindowHeight(1, false);\\nconst x = 0;\\nconst y = (Graphics.height - height) / 2;\\nreturn new Rectangle(x, y, width, height);\"","Options":"","AddOption:eval":"true","AdjustRect:eval":"true","StartName:str":"Auto Battle Start","StyleName:str":"Auto Battle Style","StyleOFF:str":"Attack","StyleON:str":"Skills"}
 *
 * @param Damage:struct
 * @text Damage Settings
 * @type struct<Damage>
 * @desc Settings pertaining to damage calculations.
 * @default {"DamageStyles":"","DefaultDamageStyle:str":"Standard","DamageStyleList:arraystruct":"[\"{\\\"Name:str\\\":\\\"Standard\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Declare Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Replace Formula\\\\\\\\nlet formula = item.damage.formula;\\\\\\\\nif (SceneManager.isSceneBattle() && !this.isCertainHit()) {\\\\\\\\n    const fmt = 'Math.max(this.applyArmorModifiers(b, %1), 0)';\\\\\\\\n    formula = formula.replace(/b.def/g, fmt.format('b.def'));\\\\\\\\n    formula = formula.replace(/b.mdf/g, fmt.format('b.mdf'));\\\\\\\\n    formula = formula.replace(/b.agi/g, fmt.format('b.agi'));\\\\\\\\n    formula = formula.replace(/b.luk/g, fmt.format('b.luk'));\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Calculate Damage\\\\\\\\nlet value = Math.max(eval(formula), 0);\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"return this.getItemDamageAmountTextOriginal();\\\\\\\"\\\"}\",\"{\\\"Name:str\\\":\\\"Armor Scaling\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Declare Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Replace Formula\\\\\\\\nlet formula = item.damage.formula;\\\\\\\\nif (SceneManager.isSceneBattle() && !this.isCertainHit()) {\\\\\\\\n    const fmt = 'Math.max(this.applyArmorModifiers(b, %1), 1)';\\\\\\\\n    formula = formula.replace(/b.def/g, fmt.format('b.def'));\\\\\\\\n    formula = formula.replace(/b.mdf/g, fmt.format('b.mdf'));\\\\\\\\n    formula = formula.replace(/b.agi/g, fmt.format('b.agi'));\\\\\\\\n    formula = formula.replace(/b.luk/g, fmt.format('b.luk'));\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Calculate Damage\\\\\\\\nlet value = Math.max(eval(formula), 0);\\\\\\\\n\\\\\\\\n// Apply Defender's Defense Parameter\\\\\\\\nif (this.isDamage() && !this.isCertainHit()) {\\\\\\\\n\\\\\\\\n    // Calculate Base Armor\\\\\\\\n    let armor = this.isPhysical() ? b.def : b.mdf;\\\\\\\\n    armor = this.applyArmorModifiers(target, armor);\\\\\\\\n\\\\\\\\n    // Apply Armor to Damage\\\\\\\\n    if (armor >= 0) {\\\\\\\\n        value *= 100 / (100 + armor);\\\\\\\\n    } else {\\\\\\\\n        value *= 2 - (100 / (100 - armor));\\\\\\\\n    }\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"return this.getItemDamageAmountTextOriginal();\\\\\\\"\\\"}\",\"{\\\"Name:str\\\":\\\"CT\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Create Multiplier\\\\\\\\nconst multiplier = Math.max(eval(item.damage.formula), 0);\\\\\\\\n\\\\\\\\n// Declare Values\\\\\\\\nlet value = 0;\\\\\\\\nlet level = Math.max(a.level || a.luk, 1);\\\\\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\\\\\narmor = Math.max(this.applyArmorModifiers(target, armor), 0);\\\\\\\\nlet attackStat = 0;\\\\\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    attackStat = a.atk;\\\\\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    attackStat =  a.mat;\\\\\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\\\\\n    attackStat =  a.def;\\\\\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\\\\\n    attackStat =  a.mdf;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Calculate Damage\\\\\\\\nattackStat = (attackStat * 1.75) + (level ** 2 / 45.5);\\\\\\\\nvalue = attackStat * 4;\\\\\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    value *= Math.max(256 - armor, 0) / 256;\\\\\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    value *= Math.max(102.4 - armor, 0) / 128;\\\\\\\\n}\\\\\\\\nvalue *= multiplier;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst item = this._item;\\\\\\\\nconst formula = item.damage.formula;\\\\\\\\nconst a = this._tempActorA;\\\\\\\\nconst b = this._tempActorB;\\\\\\\\nconst user = a;\\\\\\\\nconst target = b;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\ntry {\\\\\\\\n    const value = Math.max(eval(formula), 0);\\\\\\\\n    return '%1%'.format(Math.round(value * 100));\\\\\\\\n} catch (e) {\\\\\\\\n    if ($gameTemp.isPlaytest()) {\\\\\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\\\\\n    }\\\\\\\\n    return '?????';\\\\\\\\n}\\\\\\\"\\\"}\",\"{\\\"Name:str\\\":\\\"D4\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Create Multiplier\\\\\\\\nconst multiplier = Math.max(eval(item.damage.formula), 0);\\\\\\\\n\\\\\\\\n// Declare Values\\\\\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\\\\\narmor = this.applyArmorModifiers(target, armor);\\\\\\\\nlet stat = 0;\\\\\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    stat = a.atk;\\\\\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    stat = a.mat;\\\\\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\\\\\n    stat = a.def;\\\\\\\\n    armor = 0;\\\\\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\\\\\n    stat = a.mdf;\\\\\\\\n    armor = 0;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Calculate Damage \\\\\\\\nlet value = 1.5 * Math.max(2 * stat * multiplier - armor, 1) * multiplier / 5;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst item = this._item;\\\\\\\\nconst formula = item.damage.formula;\\\\\\\\nconst a = this._tempActorA;\\\\\\\\nconst b = this._tempActorB;\\\\\\\\nconst user = a;\\\\\\\\nconst target = b;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\ntry {\\\\\\\\n    const value = Math.max(eval(formula), 0);\\\\\\\\n    return '%1%'.format(Math.round(value * 100));\\\\\\\\n} catch (e) {\\\\\\\\n    if ($gameTemp.isPlaytest()) {\\\\\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\\\\\n    }\\\\\\\\n    return '?????';\\\\\\\\n}\\\\\\\"\\\"}\",\"{\\\"Name:str\\\":\\\"DQ\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Create Multiplier\\\\\\\\nlet multiplier = Math.max(eval(item.damage.formula), 0);\\\\\\\\nif (this.isCertainHit()) {\\\\\\\\n    let value = multiplier * Math.max(a.atk, a.mat);\\\\\\\\n    return (isNaN(value) ? 0 : value) * sign;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Get Primary Stats\\\\\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\\\\\narmor = this.applyArmorModifiers(b, armor);\\\\\\\\nlet stat = 1;\\\\\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    stat = a.atk;\\\\\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    stat = a.mat;\\\\\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\\\\\n    stat = a.def;\\\\\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\\\\\n    stat = a.mdf;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Check for Recovery\\\\\\\\nif (this.isRecover()) {\\\\\\\\n    let value = stat * multiplier * sign;\\\\\\\\n    return isNaN(value) ? 0 : value;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Calculate Damage\\\\\\\\nlet value = 0;\\\\\\\\nif (stat < ((2 + armor) / 2)) {\\\\\\\\n    // Plink Damage\\\\\\\\n    let baseline = Math.max(stat - ((12 * (armor - stat + 1)) / stat), 5);\\\\\\\\n    value = baseline / 3;\\\\\\\\n} else {\\\\\\\\n    // Normal Damage\\\\\\\\n    let baseline = Math.max(stat - (armor / 2), 1);\\\\\\\\n    value = baseline / 2;\\\\\\\\n}\\\\\\\\nvalue *= multiplier;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn isNaN(value) ? 0 : value;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst item = this._item;\\\\\\\\nconst formula = item.damage.formula;\\\\\\\\nconst a = this._tempActorA;\\\\\\\\nconst b = this._tempActorB;\\\\\\\\nconst user = a;\\\\\\\\nconst target = b;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\ntry {\\\\\\\\n    const value = Math.max(eval(formula), 0);\\\\\\\\n    return '%1%'.format(Math.round(value * 100));\\\\\\\\n} catch (e) {\\\\\\\\n    if ($gameTemp.isPlaytest()) {\\\\\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\\\\\n    }\\\\\\\\n    return '?????';\\\\\\\\n}\\\\\\\"\\\"}\",\"{\\\"Name:str\\\":\\\"FF7\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Create Power\\\\\\\\nconst power = Math.max(eval(item.damage.formula), 0);\\\\\\\\n\\\\\\\\n// Declare base Damage\\\\\\\\nlet baseDamage = 0;\\\\\\\\nlet level = Math.max(a.level || a.luk, 1);\\\\\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    baseDamage = a.atk + ((a.atk + level) / 32) * ((a.atk * level) / 32);\\\\\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    baseDamage = 6 * (a.mat + level);\\\\\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\\\\\n    baseDamage = 6 * (a.def + level);\\\\\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\\\\\n    baseDamage = 6 * (a.mdf + level);\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Calculate Final Damage\\\\\\\\nlet value = baseDamage;\\\\\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\\\\\narmor = this.applyArmorModifiers(target, armor);\\\\\\\\nif (this.isRecover()) {\\\\\\\\n    value += 22 * power;\\\\\\\\n} else {\\\\\\\\n    value = (power * Math.max(512 - armor, 1) * baseDamage) / (16 * 512);\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Power\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Power\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Power\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Power\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Power\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Power\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst item = this._item;\\\\\\\\nconst formula = item.damage.formula;\\\\\\\\nconst a = this._tempActorA;\\\\\\\\nconst b = this._tempActorB;\\\\\\\\nconst user = a;\\\\\\\\nconst target = b;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\ntry {\\\\\\\\n    return formula;\\\\\\\\n} catch (e) {\\\\\\\\n    if ($gameTemp.isPlaytest()) {\\\\\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\\\\\n    }\\\\\\\\n    return '?????';\\\\\\\\n}\\\\\\\"\\\"}\",\"{\\\"Name:str\\\":\\\"FF8\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Create Power\\\\\\\\nconst power = Math.max(eval(item.damage.formula), 0);\\\\\\\\n\\\\\\\\n// Declare Damage\\\\\\\\nlet Value = 0;\\\\\\\\nlet level = Math.max(a.level || a.luk, 1);\\\\\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\\\\\narmor = this.applyArmorModifiers(target, armor);\\\\\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    value = a.atk ** 2 / 16 + a.atk;\\\\\\\\n    value *= Math.max(265 - armor, 1) / 256;\\\\\\\\n    value *= power / 16;\\\\\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    value = a.mat + power;\\\\\\\\n    value *= Math.max(265 - armor, 1) / 4;\\\\\\\\n    value *= power / 256;\\\\\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\\\\\n    value = (power + a.def) * power / 2;\\\\\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\\\\\n    value = (power + a.mdf) * power / 2;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Power\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Power\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Power\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Power\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Power\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Power\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst item = this._item;\\\\\\\\nconst formula = item.damage.formula;\\\\\\\\nconst a = this._tempActorA;\\\\\\\\nconst b = this._tempActorB;\\\\\\\\nconst user = a;\\\\\\\\nconst target = b;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\ntry {\\\\\\\\n    return formula;\\\\\\\\n} catch (e) {\\\\\\\\n    if ($gameTemp.isPlaytest()) {\\\\\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\\\\\n    }\\\\\\\\n    return '?????';\\\\\\\\n}\\\\\\\"\\\"}\",\"{\\\"Name:str\\\":\\\"FF9\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Create Damage Constant\\\\\\\\nconst power = Math.max(eval(item.damage.formula), 0);\\\\\\\\nif (this.isCertainHit()) {\\\\\\\\n    return (isNaN(power) ? 0 : power) * sign;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Declare Main Stats\\\\\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\\\\\narmor = this.applyArmorModifiers(b, armor);\\\\\\\\nlet stat = 1;\\\\\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    stat = a.atk;\\\\\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    stat = a.mat;\\\\\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\\\\\n    stat = a.def;\\\\\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\\\\\n    stat = a.mdf;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Declare Base Damage\\\\\\\\nlet baseDamage = power;\\\\\\\\nif (this.isPhysical()) {\\\\\\\\n    baseDamage += stat;\\\\\\\\n}\\\\\\\\nif (this.isDamage() || this.isDrain()) {\\\\\\\\n    baseDamage -= armor;\\\\\\\\n    baseDamage = Math.max(1, baseDamage);\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Declare Bonus Damage\\\\\\\\nlet bonusDamage = stat + (((a.level || a.luk) + stat) / 8);\\\\\\\\n\\\\\\\\n// Declare Final Damage\\\\\\\\nlet value = baseDamage * bonusDamage * sign;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn isNaN(value) ? 0 : value;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Power\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Power\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Power\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Power\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Power\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Power\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst item = this._item;\\\\\\\\nconst formula = item.damage.formula;\\\\\\\\nconst a = this._tempActorA;\\\\\\\\nconst b = this._tempActorB;\\\\\\\\nconst user = a;\\\\\\\\nconst target = b;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\ntry {\\\\\\\\n    return formula;\\\\\\\\n} catch (e) {\\\\\\\\n    if ($gameTemp.isPlaytest()) {\\\\\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\\\\\n    }\\\\\\\\n    return '?????';\\\\\\\\n}\\\\\\\"\\\"}\",\"{\\\"Name:str\\\":\\\"FF10\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Create Damage Constant\\\\\\\\nconst power = Math.max(eval(item.damage.formula), 0);\\\\\\\\nif (this.isCertainHit()) {\\\\\\\\n    return (isNaN(power) ? 0 : power) * sign;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Create Damage Offense Value\\\\\\\\nlet value = power;\\\\\\\\n\\\\\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    value = (((a.atk ** 3) / 32) + 32) * power / 16;\\\\\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    value = power * ((a.mat ** 2 / 6) + power) / 4;\\\\\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\\\\\n    value = power * ((a.def + power) / 2);\\\\\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\\\\\n    value = power * ((a.mdf + power) / 2);\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Apply Damage Defense Value\\\\\\\\nif (this.isDamage() || this.isDrain()) {\\\\\\\\n    let armor = this.isPhysical() ? b.def : b.mdf;\\\\\\\\n    armor = this.applyArmorModifiers(b, armor);\\\\\\\\n    armor = Math.max(armor, 1);\\\\\\\\n    value *= ((((armor - 280.4) ** 2) / 110) / 16) / 730;\\\\\\\\n    value *= (730 - (armor * 51 - (armor ** 2) / 11) / 10) / 730;\\\\\\\\n} else if (this.isRecover()) {\\\\\\\\n    value *= -1;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn isNaN(value) ? 0 : value;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Power\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Power\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Power\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Power\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Power\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Power\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst item = this._item;\\\\\\\\nconst formula = item.damage.formula;\\\\\\\\nconst a = this._tempActorA;\\\\\\\\nconst b = this._tempActorB;\\\\\\\\nconst user = a;\\\\\\\\nconst target = b;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\ntry {\\\\\\\\n    return formula;\\\\\\\\n} catch (e) {\\\\\\\\n    if ($gameTemp.isPlaytest()) {\\\\\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\\\\\n    }\\\\\\\\n    return '?????';\\\\\\\\n}\\\\\\\"\\\"}\",\"{\\\"Name:str\\\":\\\"MK\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Create Multiplier\\\\\\\\nconst multiplier = Math.max(eval(item.damage.formula), 0);\\\\\\\\n\\\\\\\\n// Declare Values\\\\\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\\\\\narmor = this.applyArmorModifiers(target, armor);\\\\\\\\nconst denominator = Math.max(200 + armor, 1);\\\\\\\\n\\\\\\\\n// Calculate Damage \\\\\\\\nlet value = 0;\\\\\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    value = 200 * a.atk / denominator;\\\\\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    value = 200 * a.mat / denominator;\\\\\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\\\\\n    value = 200 * a.def / 200;\\\\\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\\\\\n    value = 200 * a.mdf / 200;\\\\\\\\n}\\\\\\\\nvalue *= multiplier;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst item = this._item;\\\\\\\\nconst formula = item.damage.formula;\\\\\\\\nconst a = this._tempActorA;\\\\\\\\nconst b = this._tempActorB;\\\\\\\\nconst user = a;\\\\\\\\nconst target = b;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\ntry {\\\\\\\\n    const value = Math.max(eval(formula), 0);\\\\\\\\n    return '%1%'.format(Math.round(value * 100));\\\\\\\\n} catch (e) {\\\\\\\\n    if ($gameTemp.isPlaytest()) {\\\\\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\\\\\n    }\\\\\\\\n    return '?????';\\\\\\\\n}\\\\\\\"\\\"}\",\"{\\\"Name:str\\\":\\\"MOBA\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Create Damage Value\\\\\\\\nlet value = Math.max(eval(item.damage.formula), 0) * sign;\\\\\\\\n\\\\\\\\n// Apply Attacker's Offense Parameter\\\\\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    value *= a.atk;\\\\\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    value *= a.mat;\\\\\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\\\\\n    value *= a.def;\\\\\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\\\\\n    value *= a.mdf;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Apply Defender's Defense Parameter\\\\\\\\nif (this.isDamage() && !this.isCertainHit()) {\\\\\\\\n\\\\\\\\n    // Calculate Base Armor\\\\\\\\n    let armor = this.isPhysical() ? b.def : b.mdf;\\\\\\\\n    armor = this.applyArmorModifiers(target, armor);\\\\\\\\n\\\\\\\\n    // Apply Armor to Damage\\\\\\\\n    if (armor >= 0) {\\\\\\\\n        value *= 100 / (100 + armor);\\\\\\\\n    } else {\\\\\\\\n        value *= 2 - (100 / (100 - armor));\\\\\\\\n    }\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn isNaN(value) ? 0 : value;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst item = this._item;\\\\\\\\nconst formula = item.damage.formula;\\\\\\\\nconst a = this._tempActorA;\\\\\\\\nconst b = this._tempActorB;\\\\\\\\nconst user = a;\\\\\\\\nconst target = b;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\ntry {\\\\\\\\n    const value = Math.max(eval(formula), 0);\\\\\\\\n    return '%1%'.format(Math.round(value * 100));\\\\\\\\n} catch (e) {\\\\\\\\n    if ($gameTemp.isPlaytest()) {\\\\\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\\\\\n    }\\\\\\\\n    return '?????';\\\\\\\\n}\\\\\\\"\\\"}\",\"{\\\"Name:str\\\":\\\"PKMN\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Create Power\\\\\\\\nconst power = Math.max(eval(item.damage.formula), 0);\\\\\\\\n\\\\\\\\n// Declare Values\\\\\\\\nlet value = 0;\\\\\\\\nlet level = Math.max(a.level || a.luk, 1);\\\\\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\\\\\narmor = Math.max(this.applyArmorModifiers(target, armor), 0);\\\\\\\\nlet attackStat = 0;\\\\\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    attackStat = a.atk;\\\\\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    attackStat =  a.mat;\\\\\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\\\\\n    attackStat =  a.def;\\\\\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\\\\\n    attackStat =  a.mdf;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Calculate Damage\\\\\\\\nvalue = (((((2 * level) / 5) + 2) * power * (attackStat / armor)) / 50) + 2;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Power\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Power\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Power\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Power\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Power\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Power\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst item = this._item;\\\\\\\\nconst formula = item.damage.formula;\\\\\\\\nconst a = this._tempActorA;\\\\\\\\nconst b = this._tempActorB;\\\\\\\\nconst user = a;\\\\\\\\nconst target = b;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\ntry {\\\\\\\\n    return formula;\\\\\\\\n} catch (e) {\\\\\\\\n    if ($gameTemp.isPlaytest()) {\\\\\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\\\\\n    }\\\\\\\\n    return '?????';\\\\\\\\n}\\\\\\\"\\\"}\"]","Cap":"","EnableDamageCap:eval":"false","DefaultHardCap:num":"9999","EnableSoftCap:eval":"false","DefaultSoftCap:num":"0.80","DefaultSoftScaler:num":"0.1275","Popups":"","PopupDuration:num":"128","NewPopupBottom:eval":"true","PopupPosition:str":"base","PopupOffsetX:num":"0","PopupOffsetY:num":"0","PopupShiftX:num":"8","PopupShiftY:num":"-28","hpDamageFmt:str":"-%1","hpHealingFmt:str":"+%1","mpDamageFmt:str":"-%1 %2","mpHealingFmt:str":"+%1 %2","CriticalColor:eval":"[255, 0, 0, 160]","CriticalDuration:num":"128","Formulas":"","OverallFormulaJS:func":"\"// Declare Constants\\nconst target = arguments[0];\\nconst critical = arguments[1];\\nconst item = this.item();\\n\\n// Get Base Damage\\nconst baseValue = this.evalDamageFormula(target);\\n\\n// Calculate Element Modifiers\\nlet value = baseValue * this.calcElementRate(target);\\n\\n// Calculate Physical and Magical Modifiers\\nif (this.isPhysical()) {\\n    value *= target.pdr;\\n}\\nif (this.isMagical()) {\\n    value *= target.mdr;\\n}\\n\\n// Apply Healing Modifiers\\nif (baseValue < 0) {\\n    value *= target.rec;\\n}\\n\\n// Apply Critical Modifiers\\nif (critical) {\\n    value = this.applyCritical(value);\\n}\\n\\n// Apply Variance and Guard Modifiers\\nvalue = this.applyVariance(value, item.damage.variance);\\nvalue = this.applyGuard(value, target);\\n\\n// Finalize Damage\\nvalue = Math.round(value);\\nreturn value;\"","VarianceFormulaJS:func":"\"// Declare Constants\\nconst damage = arguments[0];\\nconst variance = arguments[1];\\n\\n// Calculate Variance\\nconst amp = Math.floor(Math.max((Math.abs(damage) * variance) / 100, 0));\\nconst v = Math.randomInt(amp + 1) + Math.randomInt(amp + 1) - amp;\\n\\n// Return Damage\\nreturn damage >= 0 ? damage + v : damage - v;\"","GuardFormulaJS:func":"\"// Declare Constants\\nconst damage = arguments[0];\\nconst target = arguments[1];\\n\\n// Return Damage Early\\nconst note = this.item().note;\\nif (note.match(/<UNBLOCKABLE>/i)) return damage;\\nif (!target.isGuard()) return damage;\\nif (damage < 0) return damage;\\n\\n// Declare Guard Rate\\nlet guardRate = 0.5;\\nguardRate /= target.grd;\\n\\n// Return Damage\\nreturn damage * guardRate;\"","Critical":"","CriticalHitRateJS:func":"\"// Declare Constants\\nconst user = this.subject();\\nconst target = arguments[0];\\n\\n// Create Base Critical Rate\\nlet rate = this.subject().cri * (1 - target.cev);\\n\\n// Apply Notetags\\nconst note = this.item().note;\\nif (note.match(/<ALWAYS CRITICAL>/i)) {\\n    return 1;\\n}\\nif (note.match(/<SET CRITICAL RATE:[ ](\\\\d+)([%％])>/i)) {\\n    return Number(RegExp.$1) / 100;\\n}\\nif (note.match(/<MODIFY CRITICAL RATE:[ ](\\\\d+)([%％])>/i)) {\\n    rate *= Number(RegExp.$1) / 100;\\n}\\nif (note.match(/<MODIFY CRITICAL RATE:[ ]([\\\\+\\\\-]\\\\d+)([%％])>/i)) {\\n    rate += Number(RegExp.$1) / 100;\\n}\\nif (note.match(/<JS CRITICAL RATE>\\\\s*([\\\\s\\\\S]*)\\\\s*<\\\\/JS CRITICAL RATE>/i)) {\\n    const code = String(RegExp.$1);\\n    try {\\n        eval(code);\\n    } catch (e) {\\n        if ($gameTemp.isPlaytest()) console.log(e);\\n    }\\n}\\n\\n// Apply LUK Buffs/Debuffs\\nconst lukStack = this.subject().buff(7);\\nrate *= 2 ** lukStack;\\n\\n// Return Rate\\nreturn rate;\"","CriticalHitMultiplier:func":"\"// Declare Constants\\nconst user = this.subject();\\nlet damage = arguments[0];\\nlet multiplier = 2.0;\\nlet bonusDamage = this.subject().luk * this.subject().cri;\\nif (this.isHpRecover() || this.isMpRecover()) {\\n    bonusDamage *= -1;\\n}\\n\\n// Apply Notetags\\nconst note = this.item().note;\\nif (note.match(/<MODIFY CRITICAL MULTIPLIER:[ ](\\\\d+)([%％])>/i)) {\\n    multiplier = Number(RegExp.$1) / 100;\\n}\\nif (note.match(/<MODIFY CRITICAL MULTIPLIER:[ ]([\\\\+\\\\-]\\\\d+)([%％])>/i)) {\\n    multiplier += Number(RegExp.$1) / 100;\\n}\\nif (note.match(/<MODIFY CRITICAL BONUS DAMAGE:[ ](\\\\d+)([%％])>/i)) {\\n    bonusDamage *= Number(RegExp.$1) / 100;\\n}\\nif (note.match(/<MODIFY CRITICAL BONUS DAMAGE:[ ]([\\\\+\\\\-]\\\\d+)([%％])>/i)) {\\n    bonusDamage += bonusDamage * (RegExp.$1) / 100;\\n}\\nif (note.match(/<JS CRITICAL DAMAGE>\\\\s*([\\\\s\\\\S]*)\\\\s*<\\\\/JS CRITICAL DAMAGE>/i)) {\\n    const code = String(RegExp.$1);\\n    try {\\n        eval(code);\\n    } catch (e) {\\n        if ($gameTemp.isPlaytest()) console.log(e);\\n    }\\n}\\n\\n// Return Damage\\nreturn damage * multiplier + bonusDamage;\""}
 *
 * @param Mechanics:struct
 * @text Mechanics Settings
 * @type struct<Mechanics>
 * @desc Settings pertaining to various game mechanics.
 * @default {"ActionSpeed":"","AllowRandomSpeed:eval":"false","CalcActionSpeedJS:func":"\"// Declare Constants\\nconst agi = this.subject().agi;\\n\\n// Create Speed\\nlet speed = agi;\\nif (this.allowRandomSpeed()) {\\n    speed += Math.randomInt(Math.floor(5 + agi / 4));\\n}\\nif (this.item()) {\\n    speed += this.item().speed;\\n}\\nif (this.isAttack()) {\\n    speed += this.subject().attackSpeed();\\n}\\n\\n// Return Speed\\nreturn speed;\"","BaseTroop":"","BaseTroopIDs:arraynum":"[\"1\"]","CommonEvents":"","BattleStartEvent:num":"0","BattleEndEvent:num":"0","VictoryEvent:num":"0","DefeatEvent:num":"0","EscapeSuccessEvent:num":"0","EscapeFailEvent:num":"0","Escape":"","CalcEscapeRatioJS:func":"\"// Calculate Escape Ratio\\nlet ratio = 0.5;\\nratio *= $gameParty.agility();\\nratio /= $gameTroop.agility();\\n\\n// Return Ratio\\nreturn ratio;\"","CalcEscapeRaiseJS:func":"\"// Calculate Escape Ratio\\nlet value = 0.1;\\nvalue += $gameParty.aliveMembers().length;\\n\\n// Return Value\\nreturn value;\"","BattleJS":"","PreStartBattleJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","PostStartBattleJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","BattleVictoryJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","EscapeSuccessJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","EscapeFailureJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","BattleDefeatJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","PreEndBattleJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","PostEndBattleJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","TurnJS":"","PreStartTurnJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","PostStartTurnJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","PreEndTurnJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","PostEndTurnJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","PreRegenerateJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","PostRegenerateJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","ActionJS":"","PreStartActionJS:func":"\"// Declare Constants\\nconst value = arguments[0];\\nconst user = this.subject();\\nconst target = user;\\nconst a = user;\\nconst b = user;\\nconst action = this;\\nconst item = this.item();\\nconst skill = this.item();\\n\\n// Perform Actions\\n\"","PostStartActionJS:func":"\"// Declare Constants\\nconst value = arguments[0];\\nconst user = this.subject();\\nconst target = user;\\nconst a = user;\\nconst b = user;\\nconst action = this;\\nconst item = this.item();\\nconst skill = this.item();\\n\\n// Perform Actions\\n\"","PreApplyJS:func":"\"// Declare Constants\\nconst value = arguments[0];\\nconst target = arguments[1];\\nconst user = this.subject();\\nconst a = user;\\nconst b = target;\\nconst action = this;\\nconst item = this.item();\\nconst skill = this.item();\\n\\n// Perform Actions\\n\\n// Return Value\\nreturn value;\"","PreDamageJS:func":"\"// Declare Constants\\nconst value = arguments[0];\\nconst target = arguments[1];\\nconst user = this.subject();\\nconst a = user;\\nconst b = target;\\nconst action = this;\\nconst item = this.item();\\nconst skill = this.item();\\n\\n// Perform Actions\\n\\n// Return Value\\nreturn value;\"","PostDamageJS:func":"\"// Declare Constants\\nconst value = arguments[0];\\nconst target = arguments[1];\\nconst user = this.subject();\\nconst a = user;\\nconst b = target;\\nconst action = this;\\nconst item = this.item();\\nconst skill = this.item();\\n\\n// Perform Actions\\n\\n// Return Value\\nreturn value;\"","PostApplyJS:func":"\"// Declare Constants\\nconst value = arguments[0];\\nconst target = arguments[1];\\nconst user = this.subject();\\nconst a = user;\\nconst b = target;\\nconst action = this;\\nconst item = this.item();\\nconst skill = this.item();\\n\\n// Perform Actions\\n\\n// Return Value\\nreturn value;\"","PreEndActionJS:func":"\"// Declare Constants\\nconst value = arguments[0];\\nconst user = this.subject();\\nconst target = user;\\nconst a = user;\\nconst b = user;\\nconst action = this;\\nconst item = this.item();\\nconst skill = this.item();\\n\\n// Perform Actions\\n\"","PostEndActionJS:func":"\"// Declare Constants\\nconst value = arguments[0];\\nconst user = this.subject();\\nconst target = user;\\nconst a = user;\\nconst b = user;\\nconst action = this;\\nconst item = this.item();\\nconst skill = this.item();\\n\\n// Perform Actions\\n\""}
 *
 * @param CmdWindows
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param BattleLayout:struct
 * @text Battle Layout Settings
 * @type struct<BattleLayout>
 * @desc Settings that adjust how the battle layout appears.
 * @default {"Style:str":"default","ListStyle":"","ShowFacesListStyle:eval":"true","CommandWidth:num":"192","XPStyle":"","XPActorCommandLines:num":"4","XPActorDefaultHeight:num":"64","XPSpriteYLocation:str":"name","PotraitStyle":"","ShowPortraits:eval":"true","PortraitScale:num":"0.5","BorderStyle":"","SkillItemBorderCols:num":"1","ShowPortraitsBorderStyle:eval":"true","PortraitScaleBorderStyle:num":"1.25","SkillItemWindows":"","SkillItemMiddleLayout:eval":"false","SkillItemStandardCols:num":"2"}
 *
 * @param BattleLog:struct
 * @text Battle Log Settings
 * @type struct<BattleLog>
 * @desc Settings that adjust how Window_BattleLog behaves.
 * @default {"General":"","BackColor:str":"#000000","MaxLines:num":"10","MessageWait:num":"16","TextAlign:str":"center","BattleLogRectJS:func":"\"const wx = 0;\\nconst wy = 0;\\nconst ww = Graphics.boxWidth;\\nconst wh = this.calcWindowHeight(10, false);\\nreturn new Rectangle(wx, wy, ww, wh);\"","StartTurn":"","StartTurnShow:eval":"true","StartTurnMsg:str":"Turn %1","StartTurnWait:num":"40","DisplayAction":"","ActionCenteredName:eval":"true","ActionSkillMsg1:eval":"false","ActionSkillMsg2:eval":"true","ActionItemMsg:eval":"false","ActionChanges":"","ShowCounter:eval":"true","ShowReflect:eval":"true","ShowSubstitute:eval":"true","ActionResults":"","ShowFailure:eval":"false","ShowCritical:eval":"false","ShowMissEvasion:eval":"false","ShowHpDmg:eval":"false","ShowMpDmg:eval":"false","ShowTpDmg:eval":"false","DisplayStates":"","ShowAddedState:eval":"false","ShowRemovedState:eval":"false","ShowCurrentState:eval":"false","ShowAddedBuff:eval":"false","ShowAddedDebuff:eval":"false","ShowRemovedBuff:eval":"false"}
 *
 * @param Battleback:struct
 * @text Battleback Scaling
 * @type struct<Battleback>
 * @desc Settings that adjust how battlebacks scale.
 * @default {"DefaultStyle:str":"MZ","jsOneForOne:func":"\"// Adjust Size\\nthis.width = Graphics.width;\\nthis.height = Graphics.height;\\n\\n// Adjust Scale\\nconst scale = 1.0;\\nthis.scale.x = scale;\\nthis.scale.y = scale;\\n\\n// Adjust Coordinates\\nthis.x = 0;\\nthis.y = 0;\"","jsScaleToFit:func":"\"// Adjust Size\\nthis.width = Graphics.width;\\nthis.height = Graphics.height;\\n\\n// Adjust Scale\\nconst ratioX = this.width / this.bitmap.width;\\nconst ratioY = this.height / this.bitmap.height;\\nconst scale = Math.max(ratioX, ratioY);\\nthis.scale.x = scale;\\nthis.scale.y = scale;\\n\\n// Adjust Coordinates\\nthis.x = (Graphics.width - this.width) / 2;\\nthis.y = Graphics.height - this.height;\"","jsScaleDown:func":"\"// Adjust Size\\nthis.width = Graphics.width;\\nthis.height = Graphics.height;\\n\\n// Adjust Scale\\nconst ratioX = Math.min(1, this.width / this.bitmap.width);\\nconst ratioY = Math.min(1, this.height / this.bitmap.height);\\nconst scale = Math.max(ratioX, ratioY);\\nthis.scale.x = scale;\\nthis.scale.y = scale;\\n\\n// Adjust Coordinates\\nthis.x = (Graphics.width - this.width) / 2;\\nthis.y = Graphics.height - this.height;\"","jsScale Up:func":"\"// Adjust Size\\nthis.width = Graphics.width;\\nthis.height = Graphics.height;\\n\\n// Adjust Scale\\nconst ratioX = Math.max(1, this.width / this.bitmap.width);\\nconst ratioY = Math.max(1, this.height / this.bitmap.height);\\nconst scale = Math.max(ratioX, ratioY);\\nthis.scale.x = scale;\\nthis.scale.y = scale;\\n\\n// Adjust Coordinates\\nthis.x = (Graphics.width - this.width) / 2;\\nthis.y = Graphics.height - this.height;\""}
 *
 * @param PartyCmd:struct
 * @text Party Command Window
 * @type struct<PartyCmd>
 * @desc Settings that alter the Party Command Window in battle.
 * @default {"Cmd":"","CmdStyle:str":"auto","CmdTextAlign:str":"left","CmdIconFight:num":"76","CommandAddAutoBattle:eval":"true","CmdIconAutoBattle:num":"78","CmdTextAutoBattle:str":"Auto","CommandAddOptions:eval":"true","CmdIconOptions:num":"83","ActiveTpbOptionsMessage:str":"Options Menu queued after action is complete.","CmdIconEscape:num":"82","Access":"","SkipPartyCmd:eval":"true","DisablePartyCmd:eval":"false","HelpWindow":"","HelpFight:str":"Select actions to fight.","HelpAutoBattle:str":"Sets party to Auto Battle mode.","HelpOptions:str":"Opens up the Options Menu.","HelpEscape:str":"Attempt to escape the battle."}
 *
 * @param ActorCmd:struct
 * @text Actor Command Window
 * @type struct<ActorCmd>
 * @desc Settings that alter the Actor Command Window in battle.
 * @default {"Cmd":"","CmdStyle:str":"auto","CmdTextAlign:str":"left","CmdIconItem:num":"176","IconStypeNorm:num":"78","IconStypeMagic:num":"79","BattleCmd":"","BattleCmdList:arraystr":"[\"attack\",\"skills\",\"guard\",\"item\",\"escape\"]","HelpWindow":"","HelpSkillType:str":"Opens up a list of skills under the \\C[16]%1\\C[0] category.","HelpItem:str":"Opens up a list of items that you can use.","HelpEscape:str":"Attempt to escape the battle.","HelpAutoBattle:str":"Automatically choose an action suitable for combat."}
 *
 * @param VisualBreak
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param Actor:struct
 * @text Actor Battler Settings
 * @type struct<Actor>
 * @desc Settings that alter various properties for actors.
 * @default {"Flinch":"","FlinchDistanceX:num":"12","FlinchDistanceY:num":"0","FlinchDuration:num":"6","SvBattlers":"","AnchorX:num":"0.5","AnchorY:num":"1.0","ChantStyle:eval":"true","OffsetX:num":"0","OffsetY:num":"0","MotionSpeed:num":"12","PrioritySortActive:eval":"true","PrioritySortActors:eval":"false","Shadow:eval":"true","SmoothImage:eval":"true","HomePosJS:func":"\"// Declare Constants\\nconst sprite = this;\\nconst actor = this._actor;\\nconst index = arguments[0];\\n\\n// Make Calculations\\nlet x = Math.round((Graphics.width / 2) + 192)\\nx -= Math.floor((Graphics.width - Graphics.boxWidth) / 2);\\nx += index * 32;\\nlet y = (Graphics.height - 200) - ($gameParty.maxBattleMembers() * 48);\\ny -= Math.floor((Graphics.height - Graphics.boxHeight) / 2);\\ny += index * 48;\\n\\n// Home Position Offsets\\nconst offsetNote = /<SIDEVIEW HOME OFFSET:[ ]([\\\\+\\\\-]\\\\d+),[ ]([\\\\+\\\\-]\\\\d+)>/i;\\nconst xOffsets = actor.traitObjects().map((obj) => (obj && obj.note.match(offsetNote) ? Number(RegExp.$1) : 0));\\nconst yOffsets = actor.traitObjects().map((obj) => (obj && obj.note.match(offsetNote) ? Number(RegExp.$2) : 0));\\nx = xOffsets.reduce((r, offset) => r + offset, x);\\ny = yOffsets.reduce((r, offset) => r + offset, y);\\n\\n// Set Home Position\\nthis.setHome(x, y);\""}
 *
 * @param Enemy:struct
 * @text Enemy Battler Settings
 * @type struct<Enemy>
 * @desc Settings that alter various properties for enemies.
 * @default {"Visual":"","AttackAnimation:num":"1","EmergeText:eval":"false","OffsetX:num":"0","OffsetY:num":"0","SmoothImage:eval":"true","SelectWindow":"","FrontViewSelect:eval":"false","SideviewSelect:eval":"true","NameFontSize:num":"22","SvBattlers":"","AllowCollapse:eval":"false","AnchorX:num":"0.5","AnchorY:num":"1.0","MotionIdle:str":"walk","Shadow:eval":"true","Width:num":"64","Height:num":"64","WtypeId:num":"0"}
 *
 * @param HpGauge:struct
 * @text HP Gauge Settings
 * @type struct<HpGauge>
 * @desc Settings that adjust the visual HP Gauge displayed in battle.
 * @default {"Display":"","ShowActorGauge:eval":"false","ShowEnemyGauge:eval":"true","RequiresDefeat:eval":"false","BTestBypass:eval":"true","Settings":"","AnchorX:num":"0.5","AnchorY:num":"1.0","Scale:num":"0.5","OffsetX:num":"0","OffsetY:num":"-3","Options":"","AddHpGaugeOption:eval":"true","AdjustRect:eval":"true","Name:str":"Show HP Gauge"}
 *
 * @param ActionSequence:struct
 * @text Action Sequence Settings
 * @type struct<ActionSequence>
 * @desc Settings that adjust how certain Action Sequences work.
 * @default {"AutoSequences":"","AutoMeleeSolo:eval":"true","AutoMeleeAoE:eval":"true","CastAnimations":"","CastCertain:num":"120","CastPhysical:num":"52","CastMagical:num":"51","CounterReflection":"","CounterPlayback:eval":"true","ReflectAnimation:num":"53","ReflectPlayback:eval":"true","Stepping":"","MeleeDistance:num":"24","StepDistanceX:num":"48","StepDistanceY:num":"0","StepDuration:num":"12"}
 *
 * @param BreakEnd1
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param End Of
 * @default Plugin Parameters
 *
 * @param BreakEnd2
 * @text --------------------------
 * @default ----------------------------------
 *
 */
/* ----------------------------------------------------------------------------
 * Auto Battle Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~AutoBattle:
 *
 * @param BattleDisplay
 * @text Battle Display
 *
 * @param AutoBattleMsg:str
 * @text Message
 * @parent BattleDisplay
 * @desc Message that's displayed when Auto Battle is on.
 * Text codes allowed. %1 - OK button, %2 - Cancel button
 * @default Press %1 or %2 to stop Auto Battle
 *
 * @param AutoBattleOK:str
 * @text OK Button
 * @parent BattleDisplay
 * @desc Text used to represent the OK button.
 * If VisuMZ_0_CoreEngine is present, ignore this.
 * @default OK
 *
 * @param AutoBattleCancel:str
 * @text Cancel Button
 * @parent BattleDisplay
 * @desc Text used to represent the Cancel button.
 * If VisuMZ_0_CoreEngine is present, ignore this.
 * @default Cancel
 *
 * @param AutoBattleBgType:num
 * @text Background Type
 * @parent BattleDisplay
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for Auto Battle window.
 * @default 1
 *
 * @param AutoBattleRect:func
 * @text JS: X, Y, W, H
 * @parent BattleDisplay
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "const width = Graphics.width;\nconst height = this.calcWindowHeight(1, false);\nconst x = 0;\nconst y = (Graphics.height - height) / 2;\nreturn new Rectangle(x, y, width, height);"
 *
 * @param Options
 *
 * @param AddOption:eval
 * @text Add Option?
 * @parent Options
 * @type boolean
 * @on Add
 * @off Don't Add
 * @desc Add the Auto Battle options to the Options menu?
 * @default true
 *
 * @param AdjustRect:eval
 * @text Adjust Window Height
 * @parent Options
 * @type boolean
 * @on Adjust
 * @off Don't
 * @desc Automatically adjust the options window height?
 * @default true
 *
 * @param StartName:str
 * @text Startup Name
 * @parent Options
 * @desc Command name of the option.
 * @default Auto Battle Start
 *
 * @param StyleName:str
 * @text Style Name
 * @parent Options
 * @desc Command name of the option.
 * @default Auto Battle Style
 *
 * @param StyleOFF:str
 * @text OFF
 * @parent StyleName:str
 * @desc Text displayed when Auto Battle Style is OFF.
 * @default Attack
 *
 * @param StyleON:str
 * @text ON
 * @parent StyleName:str
 * @desc Text displayed when Auto Battle Style is ON.
 * @default Skills
 *
 */
/* ----------------------------------------------------------------------------
 * Damage Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Damage:
 *
 * @param DamageStyles
 * @text Damage Styles
 *
 * @param DefaultDamageStyle:str
 * @text Default Style
 * @parent DamageStyles
 * @desc Which Damage Style do you want to set as default?
 * Use 'Manual' to not use any styles at all.
 * @default Standard
 *
 * @param DamageStyleList:arraystruct
 * @text Style List
 * @parent DamageStyles
 * @type struct<DamageStyle>[]
 * @desc A list of the damage styles available.
 * These are used to calculate base damage.
 * @default ["{\"Name:str\":\"Standard\",\"Formula:func\":\"\\\"// Declare Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Replace Formula\\\\nlet formula = item.damage.formula;\\\\nif (SceneManager.isSceneBattle() && !this.isCertainHit()) {\\\\n    const fmt = 'Math.max(this.applyArmorModifiers(b, %1), 0)';\\\\n    formula = formula.replace(/b.def/g, fmt.format('b.def'));\\\\n    formula = formula.replace(/b.mdf/g, fmt.format('b.mdf'));\\\\n    formula = formula.replace(/b.agi/g, fmt.format('b.agi'));\\\\n    formula = formula.replace(/b.luk/g, fmt.format('b.luk'));\\\\n}\\\\n\\\\n// Calculate Damage\\\\nlet value = Math.max(eval(formula), 0);\\\\n\\\\n// Return Value\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Multiplier\",\"DamageType2:str\":\"%1 Damage Multiplier\",\"DamageType3:str\":\"%1 Recovery Multiplier\",\"DamageType4:str\":\"%1 Recovery Multiplier\",\"DamageType5:str\":\"%1 Drain Multiplier\",\"DamageType6:str\":\"%1 Drain Multiplier\",\"DamageDisplay:func\":\"\\\"return this.getItemDamageAmountTextOriginal();\\\"\"}","{\"Name:str\":\"Armor Scaling\",\"Formula:func\":\"\\\"// Declare Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Replace Formula\\\\nlet formula = item.damage.formula;\\\\nif (SceneManager.isSceneBattle() && !this.isCertainHit()) {\\\\n    const fmt = 'Math.max(this.applyArmorModifiers(b, %1), 1)';\\\\n    formula = formula.replace(/b.def/g, fmt.format('b.def'));\\\\n    formula = formula.replace(/b.mdf/g, fmt.format('b.mdf'));\\\\n    formula = formula.replace(/b.agi/g, fmt.format('b.agi'));\\\\n    formula = formula.replace(/b.luk/g, fmt.format('b.luk'));\\\\n}\\\\n\\\\n// Calculate Damage\\\\nlet value = Math.max(eval(formula), 0);\\\\n\\\\n// Apply Defender's Defense Parameter\\\\nif (this.isDamage() && !this.isCertainHit()) {\\\\n\\\\n    // Calculate Base Armor\\\\n    let armor = this.isPhysical() ? b.def : b.mdf;\\\\n    armor = this.applyArmorModifiers(target, armor);\\\\n\\\\n    // Apply Armor to Damage\\\\n    if (armor >= 0) {\\\\n        value *= 100 / (100 + armor);\\\\n    } else {\\\\n        value *= 2 - (100 / (100 - armor));\\\\n    }\\\\n}\\\\n\\\\n// Return Value\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Multiplier\",\"DamageType2:str\":\"%1 Damage Multiplier\",\"DamageType3:str\":\"%1 Recovery Multiplier\",\"DamageType4:str\":\"%1 Recovery Multiplier\",\"DamageType5:str\":\"%1 Drain Multiplier\",\"DamageType6:str\":\"%1 Drain Multiplier\",\"DamageDisplay:func\":\"\\\"return this.getItemDamageAmountTextOriginal();\\\"\"}","{\"Name:str\":\"CT\",\"Formula:func\":\"\\\"// Define Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Create Multiplier\\\\nconst multiplier = Math.max(eval(item.damage.formula), 0);\\\\n\\\\n// Declare Values\\\\nlet value = 0;\\\\nlet level = Math.max(a.level || a.luk, 1);\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\narmor = Math.max(this.applyArmorModifiers(target, armor), 0);\\\\nlet attackStat = 0;\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    attackStat = a.atk;\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    attackStat =  a.mat;\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\n    attackStat =  a.def;\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\n    attackStat =  a.mdf;\\\\n}\\\\n\\\\n// Calculate Damage\\\\nattackStat = (attackStat * 1.75) + (level ** 2 / 45.5);\\\\nvalue = attackStat * 4;\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    value *= Math.max(256 - armor, 0) / 256;\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    value *= Math.max(102.4 - armor, 0) / 128;\\\\n}\\\\nvalue *= multiplier;\\\\n\\\\n// Return Value\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Multiplier\",\"DamageType2:str\":\"%1 Damage Multiplier\",\"DamageType3:str\":\"%1 Recovery Multiplier\",\"DamageType4:str\":\"%1 Recovery Multiplier\",\"DamageType5:str\":\"%1 Drain Multiplier\",\"DamageType6:str\":\"%1 Drain Multiplier\",\"DamageDisplay:func\":\"\\\"// Define Constants\\\\nconst item = this._item;\\\\nconst formula = item.damage.formula;\\\\nconst a = this._tempActorA;\\\\nconst b = this._tempActorB;\\\\nconst user = a;\\\\nconst target = b;\\\\n\\\\n// Return Value\\\\ntry {\\\\n    const value = Math.max(eval(formula), 0);\\\\n    return '%1%'.format(Math.round(value * 100));\\\\n} catch (e) {\\\\n    if ($gameTemp.isPlaytest()) {\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\n    }\\\\n    return '?????';\\\\n}\\\"\"}","{\"Name:str\":\"D4\",\"Formula:func\":\"\\\"// Define Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Create Multiplier\\\\nconst multiplier = Math.max(eval(item.damage.formula), 0);\\\\n\\\\n// Declare Values\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\narmor = this.applyArmorModifiers(target, armor);\\\\nlet stat = 0;\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    stat = a.atk;\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    stat = a.mat;\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\n    stat = a.def;\\\\n    armor = 0;\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\n    stat = a.mdf;\\\\n    armor = 0;\\\\n}\\\\n\\\\n// Calculate Damage \\\\nlet value = 1.5 * Math.max(2 * stat * multiplier - armor, 1) * multiplier / 5;\\\\n\\\\n// Return Value\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Multiplier\",\"DamageType2:str\":\"%1 Damage Multiplier\",\"DamageType3:str\":\"%1 Recovery Multiplier\",\"DamageType4:str\":\"%1 Recovery Multiplier\",\"DamageType5:str\":\"%1 Drain Multiplier\",\"DamageType6:str\":\"%1 Drain Multiplier\",\"DamageDisplay:func\":\"\\\"// Define Constants\\\\nconst item = this._item;\\\\nconst formula = item.damage.formula;\\\\nconst a = this._tempActorA;\\\\nconst b = this._tempActorB;\\\\nconst user = a;\\\\nconst target = b;\\\\n\\\\n// Return Value\\\\ntry {\\\\n    const value = Math.max(eval(formula), 0);\\\\n    return '%1%'.format(Math.round(value * 100));\\\\n} catch (e) {\\\\n    if ($gameTemp.isPlaytest()) {\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\n    }\\\\n    return '?????';\\\\n}\\\"\"}","{\"Name:str\":\"DQ\",\"Formula:func\":\"\\\"// Define Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Create Multiplier\\\\nlet multiplier = Math.max(eval(item.damage.formula), 0);\\\\nif (this.isCertainHit()) {\\\\n    let value = multiplier * Math.max(a.atk, a.mat);\\\\n    return (isNaN(value) ? 0 : value) * sign;\\\\n}\\\\n\\\\n// Get Primary Stats\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\narmor = this.applyArmorModifiers(b, armor);\\\\nlet stat = 1;\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    stat = a.atk;\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    stat = a.mat;\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\n    stat = a.def;\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\n    stat = a.mdf;\\\\n}\\\\n\\\\n// Check for Recovery\\\\nif (this.isRecover()) {\\\\n    let value = stat * multiplier * sign;\\\\n    return isNaN(value) ? 0 : value;\\\\n}\\\\n\\\\n// Calculate Damage\\\\nlet value = 0;\\\\nif (stat < ((2 + armor) / 2)) {\\\\n    // Plink Damage\\\\n    let baseline = Math.max(stat - ((12 * (armor - stat + 1)) / stat), 5);\\\\n    value = baseline / 3;\\\\n} else {\\\\n    // Normal Damage\\\\n    let baseline = Math.max(stat - (armor / 2), 1);\\\\n    value = baseline / 2;\\\\n}\\\\nvalue *= multiplier;\\\\n\\\\n// Return Value\\\\nreturn isNaN(value) ? 0 : value;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Multiplier\",\"DamageType2:str\":\"%1 Damage Multiplier\",\"DamageType3:str\":\"%1 Recovery Multiplier\",\"DamageType4:str\":\"%1 Recovery Multiplier\",\"DamageType5:str\":\"%1 Drain Multiplier\",\"DamageType6:str\":\"%1 Drain Multiplier\",\"DamageDisplay:func\":\"\\\"// Define Constants\\\\nconst item = this._item;\\\\nconst formula = item.damage.formula;\\\\nconst a = this._tempActorA;\\\\nconst b = this._tempActorB;\\\\nconst user = a;\\\\nconst target = b;\\\\n\\\\n// Return Value\\\\ntry {\\\\n    const value = Math.max(eval(formula), 0);\\\\n    return '%1%'.format(Math.round(value * 100));\\\\n} catch (e) {\\\\n    if ($gameTemp.isPlaytest()) {\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\n    }\\\\n    return '?????';\\\\n}\\\"\"}","{\"Name:str\":\"FF7\",\"Formula:func\":\"\\\"// Define Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Create Power\\\\nconst power = Math.max(eval(item.damage.formula), 0);\\\\n\\\\n// Declare base Damage\\\\nlet baseDamage = 0;\\\\nlet level = Math.max(a.level || a.luk, 1);\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    baseDamage = a.atk + ((a.atk + level) / 32) * ((a.atk * level) / 32);\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    baseDamage = 6 * (a.mat + level);\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\n    baseDamage = 6 * (a.def + level);\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\n    baseDamage = 6 * (a.mdf + level);\\\\n}\\\\n\\\\n// Calculate Final Damage\\\\nlet value = baseDamage;\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\narmor = this.applyArmorModifiers(target, armor);\\\\nif (this.isRecover()) {\\\\n    value += 22 * power;\\\\n} else {\\\\n    value = (power * Math.max(512 - armor, 1) * baseDamage) / (16 * 512);\\\\n}\\\\n\\\\n// Return Value\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Power\",\"DamageType2:str\":\"%1 Damage Power\",\"DamageType3:str\":\"%1 Recovery Power\",\"DamageType4:str\":\"%1 Recovery Power\",\"DamageType5:str\":\"%1 Drain Power\",\"DamageType6:str\":\"%1 Drain Power\",\"DamageDisplay:func\":\"\\\"// Define Constants\\\\nconst item = this._item;\\\\nconst formula = item.damage.formula;\\\\nconst a = this._tempActorA;\\\\nconst b = this._tempActorB;\\\\nconst user = a;\\\\nconst target = b;\\\\n\\\\n// Return Value\\\\ntry {\\\\n    return formula;\\\\n} catch (e) {\\\\n    if ($gameTemp.isPlaytest()) {\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\n    }\\\\n    return '?????';\\\\n}\\\"\"}","{\"Name:str\":\"FF8\",\"Formula:func\":\"\\\"// Define Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Create Power\\\\nconst power = Math.max(eval(item.damage.formula), 0);\\\\n\\\\n// Declare Damage\\\\nlet Value = 0;\\\\nlet level = Math.max(a.level || a.luk, 1);\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\narmor = this.applyArmorModifiers(target, armor);\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    value = a.atk ** 2 / 16 + a.atk;\\\\n    value *= Math.max(265 - armor, 1) / 256;\\\\n    value *= power / 16;\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    value = a.mat + power;\\\\n    value *= Math.max(265 - armor, 1) / 4;\\\\n    value *= power / 256;\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\n    value = (power + a.def) * power / 2;\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\n    value = (power + a.mdf) * power / 2;\\\\n}\\\\n\\\\n// Return Value\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Power\",\"DamageType2:str\":\"%1 Damage Power\",\"DamageType3:str\":\"%1 Recovery Power\",\"DamageType4:str\":\"%1 Recovery Power\",\"DamageType5:str\":\"%1 Drain Power\",\"DamageType6:str\":\"%1 Drain Power\",\"DamageDisplay:func\":\"\\\"// Define Constants\\\\nconst item = this._item;\\\\nconst formula = item.damage.formula;\\\\nconst a = this._tempActorA;\\\\nconst b = this._tempActorB;\\\\nconst user = a;\\\\nconst target = b;\\\\n\\\\n// Return Value\\\\ntry {\\\\n    return formula;\\\\n} catch (e) {\\\\n    if ($gameTemp.isPlaytest()) {\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\n    }\\\\n    return '?????';\\\\n}\\\"\"}","{\"Name:str\":\"FF9\",\"Formula:func\":\"\\\"// Define Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Create Damage Constant\\\\nconst power = Math.max(eval(item.damage.formula), 0);\\\\nif (this.isCertainHit()) {\\\\n    return (isNaN(power) ? 0 : power) * sign;\\\\n}\\\\n\\\\n// Declare Main Stats\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\narmor = this.applyArmorModifiers(b, armor);\\\\nlet stat = 1;\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    stat = a.atk;\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    stat = a.mat;\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\n    stat = a.def;\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\n    stat = a.mdf;\\\\n}\\\\n\\\\n// Declare Base Damage\\\\nlet baseDamage = power;\\\\nif (this.isPhysical()) {\\\\n    baseDamage += stat;\\\\n}\\\\nif (this.isDamage() || this.isDrain()) {\\\\n    baseDamage -= armor;\\\\n    baseDamage = Math.max(1, baseDamage);\\\\n}\\\\n\\\\n// Declare Bonus Damage\\\\nlet bonusDamage = stat + (((a.level || a.luk) + stat) / 8);\\\\n\\\\n// Declare Final Damage\\\\nlet value = baseDamage * bonusDamage * sign;\\\\n\\\\n// Return Value\\\\nreturn isNaN(value) ? 0 : value;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Power\",\"DamageType2:str\":\"%1 Damage Power\",\"DamageType3:str\":\"%1 Recovery Power\",\"DamageType4:str\":\"%1 Recovery Power\",\"DamageType5:str\":\"%1 Drain Power\",\"DamageType6:str\":\"%1 Drain Power\",\"DamageDisplay:func\":\"\\\"// Define Constants\\\\nconst item = this._item;\\\\nconst formula = item.damage.formula;\\\\nconst a = this._tempActorA;\\\\nconst b = this._tempActorB;\\\\nconst user = a;\\\\nconst target = b;\\\\n\\\\n// Return Value\\\\ntry {\\\\n    return formula;\\\\n} catch (e) {\\\\n    if ($gameTemp.isPlaytest()) {\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\n    }\\\\n    return '?????';\\\\n}\\\"\"}","{\"Name:str\":\"FF10\",\"Formula:func\":\"\\\"// Define Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Create Damage Constant\\\\nconst power = Math.max(eval(item.damage.formula), 0);\\\\nif (this.isCertainHit()) {\\\\n    return (isNaN(power) ? 0 : power) * sign;\\\\n}\\\\n\\\\n// Create Damage Offense Value\\\\nlet value = power;\\\\n\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    value = (((a.atk ** 3) / 32) + 32) * power / 16;\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    value = power * ((a.mat ** 2 / 6) + power) / 4;\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\n    value = power * ((a.def + power) / 2);\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\n    value = power * ((a.mdf + power) / 2);\\\\n}\\\\n\\\\n// Apply Damage Defense Value\\\\nif (this.isDamage() || this.isDrain()) {\\\\n    let armor = this.isPhysical() ? b.def : b.mdf;\\\\n    armor = this.applyArmorModifiers(b, armor);\\\\n    armor = Math.max(armor, 1);\\\\n    value *= ((((armor - 280.4) ** 2) / 110) / 16) / 730;\\\\n    value *= (730 - (armor * 51 - (armor ** 2) / 11) / 10) / 730;\\\\n} else if (this.isRecover()) {\\\\n    value *= -1;\\\\n}\\\\n\\\\n// Return Value\\\\nreturn isNaN(value) ? 0 : value;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Power\",\"DamageType2:str\":\"%1 Damage Power\",\"DamageType3:str\":\"%1 Recovery Power\",\"DamageType4:str\":\"%1 Recovery Power\",\"DamageType5:str\":\"%1 Drain Power\",\"DamageType6:str\":\"%1 Drain Power\",\"DamageDisplay:func\":\"\\\"// Define Constants\\\\nconst item = this._item;\\\\nconst formula = item.damage.formula;\\\\nconst a = this._tempActorA;\\\\nconst b = this._tempActorB;\\\\nconst user = a;\\\\nconst target = b;\\\\n\\\\n// Return Value\\\\ntry {\\\\n    return formula;\\\\n} catch (e) {\\\\n    if ($gameTemp.isPlaytest()) {\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\n    }\\\\n    return '?????';\\\\n}\\\"\"}","{\"Name:str\":\"MK\",\"Formula:func\":\"\\\"// Define Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Create Multiplier\\\\nconst multiplier = Math.max(eval(item.damage.formula), 0);\\\\n\\\\n// Declare Values\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\narmor = this.applyArmorModifiers(target, armor);\\\\nconst denominator = Math.max(200 + armor, 1);\\\\n\\\\n// Calculate Damage \\\\nlet value = 0;\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    value = 200 * a.atk / denominator;\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    value = 200 * a.mat / denominator;\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\n    value = 200 * a.def / 200;\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\n    value = 200 * a.mdf / 200;\\\\n}\\\\nvalue *= multiplier;\\\\n\\\\n// Return Value\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Multiplier\",\"DamageType2:str\":\"%1 Damage Multiplier\",\"DamageType3:str\":\"%1 Recovery Multiplier\",\"DamageType4:str\":\"%1 Recovery Multiplier\",\"DamageType5:str\":\"%1 Drain Multiplier\",\"DamageType6:str\":\"%1 Drain Multiplier\",\"DamageDisplay:func\":\"\\\"// Define Constants\\\\nconst item = this._item;\\\\nconst formula = item.damage.formula;\\\\nconst a = this._tempActorA;\\\\nconst b = this._tempActorB;\\\\nconst user = a;\\\\nconst target = b;\\\\n\\\\n// Return Value\\\\ntry {\\\\n    const value = Math.max(eval(formula), 0);\\\\n    return '%1%'.format(Math.round(value * 100));\\\\n} catch (e) {\\\\n    if ($gameTemp.isPlaytest()) {\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\n    }\\\\n    return '?????';\\\\n}\\\"\"}","{\"Name:str\":\"MOBA\",\"Formula:func\":\"\\\"// Define Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Create Damage Value\\\\nlet value = Math.max(eval(item.damage.formula), 0) * sign;\\\\n\\\\n// Apply Attacker's Offense Parameter\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    value *= a.atk;\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    value *= a.mat;\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\n    value *= a.def;\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\n    value *= a.mdf;\\\\n}\\\\n\\\\n// Apply Defender's Defense Parameter\\\\nif (this.isDamage() && !this.isCertainHit()) {\\\\n\\\\n    // Calculate Base Armor\\\\n    let armor = this.isPhysical() ? b.def : b.mdf;\\\\n    armor = this.applyArmorModifiers(target, armor);\\\\n\\\\n    // Apply Armor to Damage\\\\n    if (armor >= 0) {\\\\n        value *= 100 / (100 + armor);\\\\n    } else {\\\\n        value *= 2 - (100 / (100 - armor));\\\\n    }\\\\n}\\\\n\\\\n// Return Value\\\\nreturn isNaN(value) ? 0 : value;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Multiplier\",\"DamageType2:str\":\"%1 Damage Multiplier\",\"DamageType3:str\":\"%1 Recovery Multiplier\",\"DamageType4:str\":\"%1 Recovery Multiplier\",\"DamageType5:str\":\"%1 Drain Multiplier\",\"DamageType6:str\":\"%1 Drain Multiplier\",\"DamageDisplay:func\":\"\\\"// Define Constants\\\\nconst item = this._item;\\\\nconst formula = item.damage.formula;\\\\nconst a = this._tempActorA;\\\\nconst b = this._tempActorB;\\\\nconst user = a;\\\\nconst target = b;\\\\n\\\\n// Return Value\\\\ntry {\\\\n    const value = Math.max(eval(formula), 0);\\\\n    return '%1%'.format(Math.round(value * 100));\\\\n} catch (e) {\\\\n    if ($gameTemp.isPlaytest()) {\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\n    }\\\\n    return '?????';\\\\n}\\\"\"}","{\"Name:str\":\"PKMN\",\"Formula:func\":\"\\\"// Define Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Create Power\\\\nconst power = Math.max(eval(item.damage.formula), 0);\\\\n\\\\n// Declare Values\\\\nlet value = 0;\\\\nlet level = Math.max(a.level || a.luk, 1);\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\narmor = Math.max(this.applyArmorModifiers(target, armor), 0);\\\\nlet attackStat = 0;\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    attackStat = a.atk;\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    attackStat =  a.mat;\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\n    attackStat =  a.def;\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\n    attackStat =  a.mdf;\\\\n}\\\\n\\\\n// Calculate Damage\\\\nvalue = (((((2 * level) / 5) + 2) * power * (attackStat / armor)) / 50) + 2;\\\\n\\\\n// Return Value\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Power\",\"DamageType2:str\":\"%1 Damage Power\",\"DamageType3:str\":\"%1 Recovery Power\",\"DamageType4:str\":\"%1 Recovery Power\",\"DamageType5:str\":\"%1 Drain Power\",\"DamageType6:str\":\"%1 Drain Power\",\"DamageDisplay:func\":\"\\\"// Define Constants\\\\nconst item = this._item;\\\\nconst formula = item.damage.formula;\\\\nconst a = this._tempActorA;\\\\nconst b = this._tempActorB;\\\\nconst user = a;\\\\nconst target = b;\\\\n\\\\n// Return Value\\\\ntry {\\\\n    return formula;\\\\n} catch (e) {\\\\n    if ($gameTemp.isPlaytest()) {\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\n    }\\\\n    return '?????';\\\\n}\\\"\"}"]
 *
 * @param Cap
 * @text Damage Cap
 *
 * @param EnableDamageCap:eval
 * @text Enable Damage Cap?
 * @parent Cap
 * @type boolean
 * @on Enable
 * @off Disable
 * @desc Put a maximum hard damage cap on how far damage can go?
 * This can be broken through the usage of notetags.
 * @default false
 *
 * @param DefaultHardCap:num
 * @text Default Hard Cap
 * @parent EnableDamageCap:eval
 * @type number
 * @min 1
 * @desc The default hard damage cap used before applying damage.
 * @default 9999
 *
 * @param EnableSoftCap:eval
 * @text Enable Soft Cap?
 * @parent Cap
 * @type boolean
 * @on Enable
 * @off Disable
 * @desc Soft caps ease in the damage values leading up to the 
 * hard damage cap. Requires hard Damage Cap enabled.
 * @default false
 *
 * @param DefaultSoftCap:num
 * @text Base Soft Cap Rate
 * @parent EnableSoftCap:eval
 * @desc The default soft damage cap used before applying damage.
 * @default 0.80
 *
 * @param DefaultSoftScaler:num
 * @text Soft Scale Constant
 * @parent EnableSoftCap:eval
 * @desc The default soft damage cap used before applying damage.
 * @default 0.1275
 *
 * @param Popups
 *
 * @param PopupDuration:num
 * @text Popup Duration
 * @parent Popups
 * @type number
 * @min 1
 * @desc Adjusts how many frames a popup stays visible.
 * @default 128
 *
 * @param NewPopupBottom:eval
 * @text Newest Popups Bottom
 * @parent Popups
 * @type boolean
 * @on Bottom
 * @off Top
 * @desc Puts the newest popups at the bottom.
 * @default true
 *
 * @param PopupPosition:str
 * @text Appear Position
 * @parent Popups
 * @type select
 * @option Head - At the top of the battler.
 * @value head
 * @option Center - At the center of the battler.
 * @value center
 * @option Base - At the foot of the battler.
 * @value base
 * @desc Selects where you want popups to appear relative to the battler.
 * @default base
 *
 * @param PopupOffsetX:num
 * @text Offset X
 * @parent Popups
 * @desc Sets how much to offset the sprites by horizontally.
 * Negative values go left. Positive values go right.
 * @default 0
 *
 * @param PopupOffsetY:num
 * @text Offset Y
 * @parent Popups
 * @desc Sets how much to offset the sprites by vertically.
 * Negative values go up. Positive values go down.
 * @default 0
 *
 * @param PopupShiftX:num
 * @text Shift X
 * @parent Popups
 * @desc Sets how much to shift the sprites by horizontally.
 * Negative values go left. Positive values go right.
 * @default 8
 *
 * @param PopupShiftY:num
 * @text Shift Y
 * @parent Popups
 * @desc Sets how much to shift the sprites by vertically.
 * Negative values go up. Positive values go down.
 * @default -28
 *
 * @param hpDamageFmt:str
 * @text HP Damage Format
 * @parent Popups
 * @desc Determines HP damage format for popup.
 * %1 - Value, %2 - HP Text
 * @default -%1
 *
 * @param hpHealingFmt:str
 * @text HP Healing Format
 * @parent Popups
 * @desc Determines HP healing format for popup.
 * %1 - Value, %2 - HP Text
 * @default +%1
 *
 * @param mpDamageFmt:str
 * @text MP Damage Format
 * @parent Popups
 * @desc Determines MP damage format for popup.
 * %1 - Value, %2 - MP Text
 * @default -%1 %2
 *
 * @param mpHealingFmt:str
 * @text MP Healing Format
 * @parent Popups
 * @desc Determines MP healing format for popup.
 * %1 - Value, %2 - MP Text
 * @default +%1 %2
 *
 * @param CriticalColor:eval
 * @text Critical Flash Color
 * @parent Popups
 * @desc Adjust the popup's flash color.
 * Format: [red, green, blue, alpha]
 * @default [255, 0, 0, 160]
 *
 * @param CriticalDuration:num
 * @text Critical Duration
 * @parent Popups
 * @type number
 * @min 1
 * @desc Adjusts how many frames a the flash lasts.
 * @default 128
 *
 * @param Formulas
 *
 * @param OverallFormulaJS:func
 * @text JS: Overall Formula
 * @parent Formulas
 * @type note
 * @desc The overall formula used when calculating damage.
 * @default "// Declare Constants\nconst target = arguments[0];\nconst critical = arguments[1];\nconst item = this.item();\n\n// Get Base Damage\nconst baseValue = this.evalDamageFormula(target);\n\n// Calculate Element Modifiers\nlet value = baseValue * this.calcElementRate(target);\n\n// Calculate Physical and Magical Modifiers\nif (this.isPhysical()) {\n    value *= target.pdr;\n}\nif (this.isMagical()) {\n    value *= target.mdr;\n}\n\n// Apply Healing Modifiers\nif (baseValue < 0) {\n    value *= target.rec;\n}\n\n// Apply Critical Modifiers\nif (critical) {\n    value = this.applyCritical(value);\n}\n\n// Apply Variance and Guard Modifiers\nvalue = this.applyVariance(value, item.damage.variance);\nvalue = this.applyGuard(value, target);\n\n// Finalize Damage\nvalue = Math.round(value);\nreturn value;"
 *
 * @param VarianceFormulaJS:func
 * @text JS: Variance Formula
 * @parent Formulas
 * @type note
 * @desc The formula used when damage variance.
 * @default "// Declare Constants\nconst damage = arguments[0];\nconst variance = arguments[1];\n\n// Calculate Variance\nconst amp = Math.floor(Math.max((Math.abs(damage) * variance) / 100, 0));\nconst v = Math.randomInt(amp + 1) + Math.randomInt(amp + 1) - amp;\n\n// Return Damage\nreturn damage >= 0 ? damage + v : damage - v;"
 *
 * @param GuardFormulaJS:func
 * @text JS: Guard Formula
 * @parent Formulas
 * @type note
 * @desc The formula used when damage is guarded.
 * @default "// Declare Constants\nconst damage = arguments[0];\nconst target = arguments[1];\n\n// Return Damage Early\nconst note = this.item().note;\nif (note.match(/<UNBLOCKABLE>/i)) return damage;\nif (!target.isGuard()) return damage;\nif (damage < 0) return damage;\n\n// Declare Guard Rate\nlet guardRate = 0.5;\nguardRate /= target.grd;\n\n// Return Damage\nreturn damage * guardRate;"
 *
 * @param Critical
 * @text Critical Hits
 *
 * @param CriticalHitRateJS:func
 * @text JS: Rate Formula
 * @parent Critical
 * @type note
 * @desc The formula used to calculate Critical Hit Rates.
 * @default "// Declare Constants\nconst user = this.subject();\nconst target = arguments[0];\n\n// Create Base Critical Rate\nlet rate = this.subject().cri * (1 - target.cev);\n\n// Apply Notetags\nconst note = this.item().note;\nif (note.match(/<ALWAYS CRITICAL>/i)) {\n    return 1;\n}\nif (note.match(/<SET CRITICAL RATE:[ ](\\d+)([%％])>/i)) {\n    return Number(RegExp.$1) / 100;\n}\nif (note.match(/<MODIFY CRITICAL RATE:[ ](\\d+)([%％])>/i)) {\n    rate *= Number(RegExp.$1) / 100;\n}\nif (note.match(/<MODIFY CRITICAL RATE:[ ]([\\+\\-]\\d+)([%％])>/i)) {\n    rate += Number(RegExp.$1) / 100;\n}\nif (note.match(/<JS CRITICAL RATE>\\s*([\\s\\S]*)\\s*<\\/JS CRITICAL RATE>/i)) {\n    const code = String(RegExp.$1);\n    try {\n        eval(code);\n    } catch (e) {\n        if ($gameTemp.isPlaytest()) console.log(e);\n    }\n}\n\n// Apply LUK Buffs/Debuffs\nconst lukStack = this.subject().buff(7);\nrate *= 2 ** lukStack;\n\n// Return Rate\nreturn rate;"
 *
 * @param CriticalHitMultiplier:func
 * @text JS: Damage Formula
 * @parent Critical
 * @type note
 * @desc The formula used to calculate Critical Hit Damage modification.
 * @default "// Declare Constants\nconst user = this.subject();\nlet damage = arguments[0];\nlet multiplier = 2.0;\nlet bonusDamage = this.subject().luk * this.subject().cri;\n\n// Apply Notetags\nconst note = this.item().note;\nif (note.match(/<MODIFY CRITICAL MULTIPLIER:[ ](\\d+)([%％])>/i)) {\n    multiplier = Number(RegExp.$1) / 100;\n}\nif (note.match(/<MODIFY CRITICAL MULTIPLIER:[ ]([\\+\\-]\\d+)([%％])>/i)) {\n    multiplier += Number(RegExp.$1) / 100;\n}\nif (note.match(/<MODIFY CRITICAL BONUS DAMAGE:[ ](\\d+)([%％])>/i)) {\n    bonusDamage *= Number(RegExp.$1) / 100;\n}\nif (note.match(/<MODIFY CRITICAL BONUS DAMAGE:[ ]([\\+\\-]\\d+)([%％])>/i)) {\n    bonusDamage += bonusDamage * (RegExp.$1) / 100;\n}\nif (note.match(/<JS CRITICAL DAMAGE>\\s*([\\s\\S]*)\\s*<\\/JS CRITICAL DAMAGE>/i)) {\n    const code = String(RegExp.$1);\n    try {\n        eval(code);\n    } catch (e) {\n        if ($gameTemp.isPlaytest()) console.log(e);\n    }\n}\n\n// Return Damage\nreturn damage * multiplier + bonusDamage;"
 *
 */
/* ----------------------------------------------------------------------------
 * Damage Formula Style
 * ----------------------------------------------------------------------------
 */
/*~struct~DamageStyle:
 *
 * @param Name:str
 * @text Name
 * @desc Name of this Damage Style.
 * Used for notetags and such.
 * @default Untitled
 *
 * @param Formula:func
 * @text JS: Formula
 * @parent Name:str
 * @type note
 * @desc The base formula for this Damage Style.
 * @default "// Define Constants\nconst item = this.item();\nconst a = this.subject();\nconst b = target;\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\n\n// Create Damage Value\nlet value = Math.max(eval(item.damage.formula), 0) * sign;\n\n// Return Value\nreturn isNaN(value) ? 0 : value;"
 *
 * @param ItemsEquipsCore
 * @text Items & Equips Core
 *
 * @param DamageType
 * @text Damage Label
 * @parent ItemsEquipsCore
 *
 * @param DamageType1:str
 * @text HP Damage
 * @parent DamageType
 * @desc Vocabulary used for this data entry.
 * @default %1 Damage Multiplier
 *
 * @param DamageType2:str
 * @text MP Damage
 * @parent DamageType
 * @desc Vocabulary used for this data entry.
 * @default %1 Damage Multiplier
 *
 * @param DamageType3:str
 * @text HP Recovery
 * @parent DamageType
 * @desc Vocabulary used for this data entry.
 * @default %1 Recovery Multiplier
 *
 * @param DamageType4:str
 * @text MP Recovery
 * @parent DamageType
 * @desc Vocabulary used for this data entry.
 * @default %1 Recovery Multiplier
 *
 * @param DamageType5:str
 * @text HP Drain
 * @parent DamageType
 * @desc Vocabulary used for this data entry.
 * @default %1 Drain Multiplier
 *
 * @param DamageType6:str
 * @text MP Drain
 * @parent DamageType
 * @desc Vocabulary used for this data entry.
 * @default %1 Drain Multiplier
 *
 * @param DamageDisplay:func
 * @text JS: Damage Display
 * @parent ItemsEquipsCore
 * @type note
 * @desc Code used the data displayed for this category.
 * @default "// Define Constants\nconst item = this._item;\nconst formula = item.damage.formula;\nconst a = this._tempActorA;\nconst b = this._tempActorB;\nconst user = a;\nconst target = b;\n\n// Return Value\ntry {\n    const value = Math.max(eval(formula), 0);\n    return '%1%'.format(Math.round(value * 100));\n} catch (e) {\n    if ($gameTemp.isPlaytest()) {\n        console.log('Damage Formula Error for %1'.format(this._item.name));\n    }\n    return '?????';\n}"
 *
 */
/* ----------------------------------------------------------------------------
 * Mechanics Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Mechanics:
 *
 * @param ActionSpeed
 * @text Action Speed
 *
 * @param AllowRandomSpeed:eval
 * @text Allow Random Speed?
 * @parent ActionSpeed
 * @type boolean
 * @on Allow
 * @off Disable
 * @desc Allow speed to be randomized base off the user's AGI?
 * @default false
 *
 * @param CalcActionSpeedJS:func
 * @text JS: Calculate
 * @parent ActionSpeed
 * @type note
 * @desc Code used to calculate action speed.
 * @default "// Declare Constants\nconst agi = this.subject().agi;\n\n// Create Speed\nlet speed = agi;\nif (this.allowRandomSpeed()) {\n    speed += Math.randomInt(Math.floor(5 + agi / 4));\n}\nif (this.item()) {\n    speed += this.item().speed;\n}\nif (this.isAttack()) {\n    speed += this.subject().attackSpeed();\n}\n\n// Return Speed\nreturn speed;"
 *
 * @param BaseTroop
 * @text Base Troop
 *
 * @param BaseTroopIDs:arraynum
 * @text Base Troop ID's
 * @parent BaseTroop
 * @type troop[]
 * @desc Select the Troop ID(s) to duplicate page events from for all other troops.
 * @default ["1"]
 *
 * @param CommonEvents
 * @text Common Events (on Map)
 *
 * @param BattleStartEvent:num
 * @text Pre-Battle Event
 * @parent CommonEvents
 * @type common_event
 * @desc Common Event to run before each battle on map.
 * Use to 0 to not run any Common Event at all.
 * @default 0
 *
 * @param BattleEndEvent:num
 * @text Post-Battle Event
 * @parent CommonEvents
 * @type common_event
 * @desc Queued Common Event to run after each battle on map.
 * Use to 0 to not run any Common Event at all.
 * @default 0
 *
 * @param VictoryEvent:num
 * @text Victory Event
 * @parent CommonEvents
 * @type common_event
 * @desc Queued Common Event to run upon victory on map.
 * Use to 0 to not run any Common Event at all.
 * @default 0
 *
 * @param DefeatEvent:num
 * @text Defeat Event
 * @parent CommonEvents
 * @type common_event
 * @desc Queued Common Event to run upon defeat on map.
 * Use to 0 to not run any Common Event at all.
 * @default 0
 *
 * @param EscapeSuccessEvent:num
 * @text Escape Success Event
 * @parent CommonEvents
 * @type common_event
 * @desc Queued Common Event to run upon escape success on map.
 * Use to 0 to not run any Common Event at all.
 * @default 0
 *
 * @param EscapeFailEvent:num
 * @text Escape Fail Event
 * @parent CommonEvents
 * @type common_event
 * @desc Queued Common Event to run upon escape failure on map.
 * Use to 0 to not run any Common Event at all.
 * @default 0
 *
 * @param Escape
 *
 * @param CalcEscapeRatioJS:func
 * @text JS: Calc Escape Ratio
 * @parent Escape
 * @type note
 * @desc Code used to calculate the escape success ratio.
 * @default "// Calculate Escape Ratio\nlet ratio = 0.5;\nratio *= $gameParty.agility();\nratio /= $gameTroop.agility();\n\n// Return Ratio\nreturn ratio;"
 *
 * @param CalcEscapeRaiseJS:func
 * @text JS: Calc Escape Raise
 * @parent Escape
 * @type note
 * @desc Code used to calculate how much the escape success ratio raises upon each failure.
 * @default "// Calculate Escape Ratio\nlet value = 0.1;\nvalue += $gameParty.aliveMembers().length;\n\n// Return Value\nreturn value;"
 *
 * @param Switches
 *
 * @param SwitchCritical:num
 * @text Switch: Critical
 * @parent Switches
 * @type switch
 * @desc Turns switch ON if the action performs a critical hit.
 * Switch reverts to OFF whenever an action starts.
 * @default 0
 *
 * @param SwitchMissEvade:num
 * @text Switch: Miss/Evade
 * @parent Switches
 * @type switch
 * @desc Turns switch ON if the action misses/is evaded.
 * Switch reverts to OFF whenever an action starts.
 * @default 0
 *
 * @param Variables
 *
 * @param VariableDmg:num
 * @text Variable: Damage
 * @parent Variables
 * @type variable
 * @desc Variable records target damage during action.
 * Variable reverts to 0 whenever an action starts.
 * @default 0
 *
 * @param VariableHeal:num
 * @text Variable: Healing
 * @parent Variables
 * @type variable
 * @desc Variable records target healing during action.
 * Variable reverts to 0 whenever an action starts.
 * @default 0
 *
 * @param BattleJS
 * @text JS: Battle-Related
 * 
 * @param PreStartBattleJS:func
 * @text JS: Pre-Start Battle
 * @parent BattleJS
 * @type note
 * @desc Target function: BattleManager.startBattle()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param PostStartBattleJS:func
 * @text JS: Post-Start Battle
 * @parent BattleJS
 * @type note
 * @desc Target function: BattleManager.startBattle()
 * JavaScript code occurs after function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 * 
 * @param BattleVictoryJS:func
 * @text JS: Battle Victory
 * @parent BattleJS
 * @type note
 * @desc Target function: BattleManager.processVictory()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param EscapeSuccessJS:func
 * @text JS: Escape Success
 * @parent BattleJS
 * @type note
 * @desc Target function: BattleManager.onEscapeSuccess()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param EscapeFailureJS:func
 * @text JS: Escape Failure
 * @parent BattleJS
 * @type note
 * @desc Target function: BattleManager.onEscapeFailure()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 * 
 * @param BattleDefeatJS:func
 * @text JS: Battle Defeat
 * @parent BattleJS
 * @type note
 * @desc Target function: BattleManager.processDefeat()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 * 
 * @param PreEndBattleJS:func
 * @text JS: Pre-End Battle
 * @parent BattleJS
 * @type note
 * @desc Target function: BattleManager.endBattle()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param PostEndBattleJS:func
 * @text JS: Post-End Battle
 * @parent BattleJS
 * @type note
 * @desc Target function: BattleManager.endBattle()
 * JavaScript code occurs after function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param TurnJS
 * @text JS: Turn-Related
 *
 * @param PreStartTurnJS:func
 * @text JS: Pre-Start Turn
 * @parent TurnJS
 * @type note
 * @desc Target function: BattleManager.startTurn()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param PostStartTurnJS:func
 * @text JS: Post-Start Turn
 * @parent TurnJS
 * @type note
 * @desc Target function: BattleManager.startTurn()
 * JavaScript code occurs after function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param PreEndTurnJS:func
 * @text JS: Pre-End Turn
 * @parent TurnJS
 * @type note
 * @desc Target function: Game_Battler.prototype.onTurnEnd()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param PostEndTurnJS:func
 * @text JS: Post-End Turn
 * @parent TurnJS
 * @type note
 * @desc Target function: Game_Battler.prototype.onTurnEnd()
 * JavaScript code occurs after function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param PreRegenerateJS:func
 * @text JS: Pre-Regenerate
 * @parent TurnJS
 * @type note
 * @desc Target function: Game_Battler.prototype.regenerateAll()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param PostRegenerateJS:func
 * @text JS: Post-Regenerate
 * @parent TurnJS
 * @type note
 * @desc Target function: Game_Battler.prototype.regenerateAll()
 * JavaScript code occurs after function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param ActionJS
 * @text JS: Action-Related
 *
 * @param PreStartActionJS:func
 * @text JS: Pre-Start Action
 * @parent ActionJS
 * @type note
 * @desc Target function: BattleManager.startAction()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst value = arguments[0];\nconst user = this.subject();\nconst target = user;\nconst a = user;\nconst b = user;\nconst action = this;\nconst item = this.item();\nconst skill = this.item();\n\n// Perform Actions\n"
 *
 * @param PostStartActionJS:func
 * @text JS: Post-Start Action
 * @parent ActionJS
 * @type note
 * @desc Target function: BattleManager.startAction()
 * JavaScript code occurs after function is run.
 * @default "// Declare Constants\nconst value = arguments[0];\nconst user = this.subject();\nconst target = user;\nconst a = user;\nconst b = user;\nconst action = this;\nconst item = this.item();\nconst skill = this.item();\n\n// Perform Actions\n"
 *
 * @param PreApplyJS:func
 * @text JS: Pre-Apply
 * @parent ActionJS
 * @type note
 * @desc Target function: Game_Action.prototype.apply()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst value = arguments[0];\nconst target = arguments[1];\nconst user = this.subject();\nconst a = user;\nconst b = target;\nconst action = this;\nconst item = this.item();\nconst skill = this.item();\n\n// Perform Actions\n\n// Return Value\nreturn value;"
 *
 * @param PreDamageJS:func
 * @text JS: Pre-Damage
 * @parent ActionJS
 * @type note
 * @desc Target function: Game_Action.prototype.executeDamage()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst value = arguments[0];\nconst target = arguments[1];\nconst user = this.subject();\nconst a = user;\nconst b = target;\nconst action = this;\nconst item = this.item();\nconst skill = this.item();\n\n// Perform Actions\n\n// Return Value\nreturn value;"
 *
 * @param PostDamageJS:func
 * @text JS: Post-Damage
 * @parent ActionJS
 * @type note
 * @desc Target function: Game_Action.prototype.executeDamage()
 * JavaScript code occurs after function is run.
 * @default "// Declare Constants\nconst value = arguments[0];\nconst target = arguments[1];\nconst user = this.subject();\nconst a = user;\nconst b = target;\nconst action = this;\nconst item = this.item();\nconst skill = this.item();\n\n// Perform Actions\n\n// Return Value\nreturn value;"
 *
 * @param PostApplyJS:func
 * @text JS: Post-Apply
 * @parent ActionJS
 * @type note
 * @desc Target function: Game_Action.prototype.apply()
 * JavaScript code occurs after function is run.
 * @default "// Declare Constants\nconst value = arguments[0];\nconst target = arguments[1];\nconst user = this.subject();\nconst a = user;\nconst b = target;\nconst action = this;\nconst item = this.item();\nconst skill = this.item();\n\n// Perform Actions\n\n// Return Value\nreturn value;"
 *
 * @param PreEndActionJS:func
 * @text JS: Pre-End Action
 * @parent ActionJS
 * @type note
 * @desc Target function: BattleManager.endAction()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst value = arguments[0];\nconst user = this.subject();\nconst target = user;\nconst a = user;\nconst b = user;\nconst action = this;\nconst item = this.item();\nconst skill = this.item();\n\n// Perform Actions\n"
 *
 * @param PostEndActionJS:func
 * @text JS: Post-End Action
 * @parent ActionJS
 * @type note
 * @desc Target function: BattleManager.endAction()
 * JavaScript code occurs after function is run.
 * @default "// Declare Constants\nconst value = arguments[0];\nconst user = this.subject();\nconst target = user;\nconst a = user;\nconst b = user;\nconst action = this;\nconst item = this.item();\nconst skill = this.item();\n\n// Perform Actions\n"
 *
 */
/* ----------------------------------------------------------------------------
 * Battle Layout Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~BattleLayout:
 *
 * @param Style:str
 * @text Battle Layout Style
 * @type select
 * @option Default - Shows actor faces in Battle Status.
 * @value default
 * @option List - Lists actors in Battle Status.
 * @value list
 * @option XP - Shows actor battlers in a stretched Battle Status.
 * @value xp
 * @option Portrait - Shows portraits in a stretched Battle Status.
 * @value portrait
 * @option Border - Displays windows around the screen border.
 * @value border
 * @option Sideview Battle UI - Requires VisuMZ_3_SideviewBattleUI
 * @value sideview_ui
 * @desc The style used for the battle layout.
 * @default default
 *
 * @param ListStyle
 * @text List Style
 * @parent Style:str
 *
 * @param ShowFacesListStyle:eval
 * @text Show Faces
 * @parent ListStyle
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Shows faces in List Style?
 * @default true
 *
 * @param CommandWidth:num
 * @text Command Window Width
 * @parent ListStyle
 * @type number
 * @min 1
 * @desc Determine the window width for the Party and Actor Command
 * Windows. Affects Default and List Battle Layout styles.
 * @default 192
 *
 * @param XPStyle
 * @text XP Style
 * @parent Style:str
 *
 * @param XPActorCommandLines:num
 * @text Command Lines
 * @parent XPStyle
 * @type number
 * @min 1
 * @desc Number of action lines in the Actor Command Window for the XP Style.
 * @default 4
 *
 * @param XPActorDefaultHeight:num
 * @text Sprite Height
 * @parent XPStyle
 * @type number
 * @min 1
 * @desc Default sprite height used when if the sprite's height has not been determined yet.
 * @default 64
 *
 * @param XPSpriteYLocation:str
 * @text Sprite Base Location
 * @parent XPStyle
 * @type select
 * @option Above Name - Sprite is located above the name.
 * @value name
 * @option Bottom - Sprite is located at the bottom of the window.
 * @value bottom
 * @option Centered - Sprite is centered in the window.
 * @value center
 * @option Top - Sprite is located at the top of the window.
 * @value top
 * @desc Determine where the sprite is located on the Battle Status Window.
 * @default name
 *
 * @param PotraitStyle
 * @text Portrait Style
 * @parent Style:str
 *
 * @param ShowPortraits:eval
 * @text Show Portraits?
 * @parent PotraitStyle
 * @type boolean
 * @on Portraits
 * @off Faces
 * @desc Requires VisuMZ_1_MainMenuCore.
 * Shows the actor's portrait instead of a face.
 * @default true
 *
 * @param PortraitScale:num
 * @text Portrait Scaling
 * @parent PotraitStyle
 * @desc If portraits are used, scale them by this much.
 * @default 0.5
 *
 * @param BorderStyle
 * @text Border Style
 * @parent Style:str
 *
 * @param SkillItemBorderCols:num
 * @text Columns
 * @parent BorderStyle
 * @type number
 * @min 1
 * @desc The total number of columns for Skill & Item Windows
 * in the battle scene.
 * @default 1
 *
 * @param ShowPortraitsBorderStyle:eval
 * @text Show Portraits?
 * @parent BorderStyle
 * @type boolean
 * @on Portraits
 * @off Faces
 * @desc Requires VisuMZ_1_MainMenuCore.
 * Shows the actor's portrait at the edge of the screen.
 * @default true
 *
 * @param PortraitScaleBorderStyle:num
 * @text Portrait Scaling
 * @parent BorderStyle
 * @desc If portraits are used, scale them by this much.
 * @default 1.0
 *
 * @param SkillItemWindows
 * @text Skill & Item Windows
 *
 * @param SkillItemMiddleLayout:eval
 * @text Middle Layout
 * @parent SkillItemWindows
 * @type boolean
 * @on Middle
 * @off Bottom
 * @desc Shows the Skill & Item Windows in mid-screen?
 * @default false
 *
 * @param SkillItemStandardCols:num
 * @text Columns
 * @parent SkillItemWindows
 * @type number
 * @min 1
 * @desc The total number of columns for Skill & Item Windows
 * in the battle scene.
 * @default 2
 *
 * @param StatusWindow
 * @text Status Window Elements
 *
 * @param StatusWindowName
 * @text Battler Name
 * @parent StatusWindow
 *
 * @param NameOffsetX:num
 * @text Offset: X
 * @parent StatusWindowName
 * @desc Offset this Battle Status Window element's X.
 * Negative goes left. Positive goes right.
 * @default +0
 *
 * @param NameOffsetY:num
 * @text Offset: Y
 * @parent StatusWindowName
 * @desc Offset this Battle Status Window element's Y.
 * Negative goes up. Positive goes down.
 * @default +0
 *
 * @param StatusWindowHpGauge
 * @text Gauge 1 (HP)
 * @parent StatusWindow
 *
 * @param HpGaugeOffsetX:num
 * @text Offset: X
 * @parent StatusWindowHpGauge
 * @desc Offset this Battle Status Window element's X.
 * Negative goes left. Positive goes right.
 * @default +0
 *
 * @param HpGaugeOffsetY:num
 * @text Offset: Y
 * @parent StatusWindowHpGauge
 * @desc Offset this Battle Status Window element's Y.
 * Negative goes up. Positive goes down.
 * @default +0
 *
 * @param StatusWindowMpGauge
 * @text Gauge 2 (MP)
 * @parent StatusWindow
 *
 * @param MpGaugeOffsetX:num
 * @text Offset: X
 * @parent StatusWindowMpGauge
 * @desc Offset this Battle Status Window element's X.
 * Negative goes left. Positive goes right.
 * @default +0
 *
 * @param MpGaugeOffsetY:num
 * @text Offset: Y
 * @parent StatusWindowMpGauge
 * @desc Offset this Battle Status Window element's Y.
 * Negative goes up. Positive goes down.
 * @default +0
 *
 * @param StatusWindowTpGauge
 * @text Gauge 3 (TP)
 * @parent StatusWindow
 *
 * @param TpGaugeOffsetX:num
 * @text Offset: X
 * @parent StatusWindowTpGauge
 * @desc Offset this Battle Status Window element's X.
 * Negative goes left. Positive goes right.
 * @default +0
 *
 * @param TpGaugeOffsetY:num
 * @text Offset: Y
 * @parent StatusWindowTpGauge
 * @desc Offset this Battle Status Window element's Y.
 * Negative goes up. Positive goes down.
 * @default +0
 *
 * @param StatusWindowStateIcon
 * @text State Icon
 * @parent StatusWindow
 *
 * @param StateIconOffsetX:num
 * @text Offset: X
 * @parent StatusWindowStateIcon
 * @desc Offset this Battle Status Window element's X.
 * Negative goes left. Positive goes right.
 * @default +0
 *
 * @param StateIconOffsetY:num
 * @text Offset: Y
 * @parent StatusWindowStateIcon
 * @desc Offset this Battle Status Window element's Y.
 * Negative goes up. Positive goes down.
 * @default +0
 *
 * @param StatusWindowTpbGauge
 * @text TPB/ATB Gauge
 * @parent StatusWindow
 *
 * @param TpbGaugeOffsetX:num
 * @text Offset: X
 * @parent StatusWindowTpbGauge
 * @desc Offset this Battle Status Window element's X.
 * Negative goes left. Positive goes right.
 * @default +0
 *
 * @param TpbGaugeOffsetY:num
 * @text Offset: Y
 * @parent StatusWindowTpbGauge
 * @desc Offset this Battle Status Window element's Y.
 * Negative goes up. Positive goes down.
 * @default +0
 *
 * @param StatusWindowSkin
 * @text Window Skin
 * @parent StatusWindow
 *
 * @param StatusWindowSkinFilename:str
 * @text Filename
 * @parent StatusWindowSkin
 * @type file
 * @dir img/system/
 * @desc Filename used for the Battle Status Window skin.
 * Leave this empty to use the default window skin.
 * @default 
 *
 * @param StatusWindowSkinHide:eval
 * @text Hide Window Skin?
 * @parent StatusWindowSkin
 * @type boolean
 * @on No Window Skin
 * @off Default Skin
 * @desc Show/Hide the window skin for the Battle Status Window?
 * @default false
 *
 * @param StatusWindowSelectBack
 * @text Selectable Background
 * @parent StatusWindow
 *
 * @param StatusWindowSelectableBackHide:eval
 * @text Hide Selectable BG?
 * @parent StatusWindowSelectBack
 * @type boolean
 * @on No Selectable BG
 * @off Default Selectable BG
 * @desc Show/Hide the selectable background box for the Battle Status Window?
 * @default false
 *
 * @param StatusWindowAttachments
 * @text Attachments
 * @parent StatusWindow
 *
 * @param StatusWindowBackAttachment
 * @text Back Attachment
 * @parent StatusWindowAttachments
 *
 * @param StatusWindowAttachmentBack:str
 * @text Filename
 * @parent StatusWindowBackAttachment
 * @type file
 * @dir img/system/
 * @desc Filename used for an image to attach to the back of the
 * Battle Status Window. Leave empty for none.
 * @default 
 *
 * @param StatusWindowAttachmentBackOffsetX:num
 * @text Offset: X
 * @parent StatusWindowBackAttachment
 * @desc Offset this Battle Status Window element's X.
 * Negative goes left. Positive goes right.
 * @default +0
 *
 * @param StatusWindowAttachmentBackOffsetY:num
 * @text Offset: Y
 * @parent StatusWindowBackAttachment
 * @desc Offset this Battle Status Window element's Y.
 * Negative goes up. Positive goes down.
 * @default +0
 *
 * @param StatusWindowFrontAttachment
 * @text Front Attachment
 * @parent StatusWindowAttachments
 *
 * @param StatusWindowAttachmentFront:str
 * @text Filename
 * @parent StatusWindowFrontAttachment
 * @type file
 * @dir img/system/
 * @desc Filename used for an image to attach to the front of the
 * Battle Status Window. Leave empty for none.
 * @default 
 *
 * @param StatusWindowAttachmentFrontOffsetX:num
 * @text Offset: X
 * @parent StatusWindowFrontAttachment
 * @desc Offset this Battle Status Window element's X.
 * Negative goes left. Positive goes right.
 * @default +0
 *
 * @param StatusWindowAttachmentFrontOffsetY:num
 * @text Offset: Y
 * @parent StatusWindowFrontAttachment
 * @desc Offset this Battle Status Window element's Y.
 * Negative goes up. Positive goes down.
 * @default +0
 *
 */
/* ----------------------------------------------------------------------------
 * Battle Log Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~BattleLog:
 *
 * @param General
 *
 * @param BackColor:str
 * @text Back Color
 * @parent General
 * @desc Use #rrggbb for a hex color.
 * @default #000000
 *
 * @param MaxLines:num
 * @text Max Lines
 * @parent General
 * @type number
 * @min 1
 * @desc Maximum number of lines to be displayed.
 * @default 10
 *
 * @param MessageWait:num
 * @text Message Wait
 * @parent General
 * @type number
 * @min 1
 * @desc Number of frames for a usual message wait.
 * @default 16
 *
 * @param TextAlign:str
 * @text Text Align
 * @parent General
 * @type combo
 * @option left
 * @option center
 * @option right
 * @desc Text alignment for the Window_BattleLog.
 * @default center
 *
 * @param BattleLogRectJS:func
 * @text JS: X, Y, W, H
 * @parent General
 * @type note
 * @desc Code used to determine the dimensions for the battle log.
 * @default "const wx = 0;\nconst wy = 0;\nconst ww = Graphics.boxWidth;\nconst wh = this.calcWindowHeight(10, false);\nreturn new Rectangle(wx, wy, ww, wh);"
 *
 * @param StartTurn
 * @text Start Turn
 *
 * @param StartTurnShow:eval
 * @text Show Start Turn?
 * @parent StartTurn
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display turn changes at the start of the turn?
 * @default false
 *
 * @param StartTurnMsg:str
 * @text Start Turn Message
 * @parent StartTurn
 * @desc Message displayed at turn start.
 * %1 - Turn Count
 * @default Turn %1
 *
 * @param StartTurnWait:num
 * @text Start Turn Wait
 * @parent StartTurn
 * @type number
 * @min 1
 * @desc Number of frames to wait after a turn started.
 * @default 40
 *
 * @param DisplayAction
 * @text Display Action
 *
 * @param ActionCenteredName:eval
 * @text Show Centered Action?
 * @parent DisplayAction
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display a centered text of the action name?
 * @default true
 *
 * @param ActionSkillMsg1:eval
 * @text Show Skill Message 1?
 * @parent DisplayAction
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display the 1st skill message?
 * @default false
 *
 * @param ActionSkillMsg2:eval
 * @text Show Skill Message 2?
 * @parent DisplayAction
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display the 2nd skill message?
 * @default true
 *
 * @param ActionItemMsg:eval
 * @text Show Item Message?
 * @parent DisplayAction
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display the item use message?
 * @default false
 *
 * @param ActionChanges
 * @text Action Changes
 *
 * @param ShowCounter:eval
 * @text Show Counter?
 * @parent ActionChanges
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display counter text?
 * @default true
 *
 * @param ShowReflect:eval
 * @text Show Reflect?
 * @parent ActionChanges
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display magic reflection text?
 * @default true
 *
 * @param ShowSubstitute:eval
 * @text Show Substitute?
 * @parent ActionChanges
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display substitute text?
 * @default true
 *
 * @param ActionResults
 * @text Action Results
 *
 * @param ShowFailure:eval
 * @text Show No Effect?
 * @parent ActionResults
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display no effect text?
 * @default false
 *
 * @param ShowCritical:eval
 * @text Show Critical?
 * @parent ActionResults
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display critical text?
 * @default false
 *
 * @param ShowMissEvasion:eval
 * @text Show Miss/Evasion?
 * @parent ActionResults
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display miss/evasion text?
 * @default false
 *
 * @param ShowHpDmg:eval
 * @text Show HP Damage?
 * @parent ActionResults
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display HP Damage text?
 * @default false
 *
 * @param ShowMpDmg:eval
 * @text Show MP Damage?
 * @parent ActionResults
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display MP Damage text?
 * @default false
 *
 * @param ShowTpDmg:eval
 * @text Show TP Damage?
 * @parent ActionResults
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display TP Damage text?
 * @default false
 *
 * @param DisplayStates
 * @text Display States
 *
 * @param ShowAddedState:eval
 * @text Show Added States?
 * @parent DisplayStates
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display added states text?
 * @default false
 *
 * @param ShowRemovedState:eval
 * @text Show Removed States?
 * @parent DisplayStates
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display removed states text?
 * @default false
 *
 * @param ShowCurrentState:eval
 * @text Show Current States?
 * @parent DisplayStates
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display the currently affected state text?
 * @default false
 *
 * @param ShowAddedBuff:eval
 * @text Show Added Buffs?
 * @parent DisplayStates
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display added buffs text?
 * @default false
 *
 * @param ShowAddedDebuff:eval
 * @text Show Added Debuffs?
 * @parent DisplayStates
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display added debuffs text?
 * @default false
 *
 * @param ShowRemovedBuff:eval
 * @text Show Removed Buffs?
 * @parent DisplayStates
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display removed de/buffs text?
 * @default false
 *
 */
/* ----------------------------------------------------------------------------
 * Battleback Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Battleback:
 *
 * @param DefaultStyle:str
 * @text Default Style
 * @type select
 * @option MZ (MZ's default style)
 * @value MZ
 * @option 1:1 (No Scaling)
 * @value 1:1
 * @option Scale To Fit (Scale to screen size)
 * @value ScaleToFit
 * @option Scale Down (Scale Downward if Larger than Screen)
 * @value ScaleDown
 * @option Scale Up (Scale Upward if Smaller than Screen)
 * @value ScaleUp
 * @desc The default scaling style used for battlebacks.
 * @default MZ
 *
 * @param jsOneForOne:func
 * @text JS: 1:1
 * @type note
 * @desc This code gives you control over the scaling for this style.
 * @default "// Adjust Size\nthis.width = Graphics.width;\nthis.height = Graphics.height;\n\n// Adjust Scale\nconst scale = 1.0;\nthis.scale.x = scale;\nthis.scale.y = scale;\n\n// Adjust Coordinates\nthis.x = 0;\nthis.y = 0;"
 *
 * @param jsScaleToFit:func
 * @text JS: Scale To Fit
 * @type note
 * @desc This code gives you control over the scaling for this style.
 * @default "// Adjust Size\nthis.width = Graphics.width;\nthis.height = Graphics.height;\n\n// Adjust Scale\nconst ratioX = this.width / this.bitmap.width;\nconst ratioY = this.height / this.bitmap.height;\nconst scale = Math.max(ratioX, ratioY);\nthis.scale.x = scale;\nthis.scale.y = scale;\n\n// Adjust Coordinates\nthis.x = (Graphics.width - this.width) / 2;\nthis.y = Graphics.height - this.height;"
 *
 * @param jsScaleDown:func
 * @text JS: Scale Down
 * @type note
 * @desc This code gives you control over the scaling for this style.
 * @default "// Adjust Size\nthis.width = Graphics.width;\nthis.height = Graphics.height;\n\n// Adjust Scale\nconst ratioX = Math.min(1, this.width / this.bitmap.width);\nconst ratioY = Math.min(1, this.height / this.bitmap.height);\nconst scale = Math.max(ratioX, ratioY);\nthis.scale.x = scale;\nthis.scale.y = scale;\n\n// Adjust Coordinates\nthis.x = (Graphics.width - this.width) / 2;\nthis.y = Graphics.height - this.height;"
 *
 * @param jsScale Up:func
 * @text JS: Scale Up
 * @type note
 * @desc This code gives you control over the scaling for this style.
 * @default "// Adjust Size\nthis.width = Graphics.width;\nthis.height = Graphics.height;\n\n// Adjust Scale\nconst ratioX = Math.max(1, this.width / this.bitmap.width);\nconst ratioY = Math.max(1, this.height / this.bitmap.height);\nconst scale = Math.max(ratioX, ratioY);\nthis.scale.x = scale;\nthis.scale.y = scale;\n\n// Adjust Coordinates\nthis.x = (Graphics.width - this.width) / 2;\nthis.y = Graphics.height - this.height;"
 *
 */
/* ----------------------------------------------------------------------------
 * Party Command Window Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~PartyCmd:
 *
 * @param Cmd
 * @text Command Window
 *
 * @param CmdStyle:str
 * @text Style
 * @parent Cmd
 * @type select
 * @option Text Only
 * @value text
 * @option Icon Only
 * @value icon
 * @option Icon + Text
 * @value iconText
 * @option Automatic
 * @value auto
 * @desc How do you wish to draw commands in the Party Command Window?
 * @default auto
 *
 * @param CmdTextAlign:str
 * @text Text Align
 * @parent Cmd
 * @type combo
 * @option left
 * @option center
 * @option right
 * @desc Text alignment for the Party Command Window.
 * @default left
 *
 * @param CmdIconFight:num
 * @text Fight Icon
 * @parent Cmd
 * @desc The icon used for the Fight command.
 * @default 76
 *
 * @param CommandAddAutoBattle:eval
 * @text Add Auto Battle?
 * @parent Cmd
 * @type boolean
 * @on Add
 * @off Don't
 * @desc Add the "Auto Battle" command to the Command Window?
 * @default true
 *
 * @param CmdIconAutoBattle:num
 * @text Auto Battle Icon
 * @parent CommandAddAutoBattle:eval
 * @desc The icon used for the Auto Battle command.
 * @default 78
 *
 * @param CmdTextAutoBattle:str
 * @text Auto Battle Text
 * @parent CommandAddAutoBattle:eval
 * @desc The text used for the Auto Battle command.
 * @default Auto
 *
 * @param CommandAddOptions:eval
 * @text Add Options?
 * @parent Cmd
 * @type boolean
 * @on Add
 * @off Don't
 * @desc Add the "Options" command to the Command Window?
 * @default true
 *
 * @param CmdIconOptions:num
 * @text Options Icon
 * @parent CommandAddOptions:eval
 * @desc The icon used for the Options command.
 * @default 83
 *
 * @param ActiveTpbOptionsMessage:str
 * @text Active TPB Message
 * @parent CommandAddOptions:eval
 * @desc Message that will be displayed when selecting options during the middle of an action.
 * @default Options Menu queued after action is complete.
 *
 * @param CmdIconEscape:num
 * @text Escape Icon
 * @parent Cmd
 * @desc The icon used for the Escape command.
 * @default 82
 *
 * @param Access
 *
 * @param SkipPartyCmd:eval
 * @text Skip Party Command
 * @parent Access
 * @type boolean
 * @on Skip
 * @off Don't
 * @desc DTB: Skip Party Command selection on turn start.
 * TPB: Skip Party Command selection at battle start.
 * @default true
 *
 * @param DisablePartyCmd:eval
 * @text Disable Party Command
 * @parent Access
 * @type boolean
 * @on Disable
 * @off Don't
 * @desc Disable the Party Command Window entirely?
 * @default false
 *
 * @param HelpWindow
 * @text Help Window
 *
 * @param HelpFight:str
 * @text Fight
 * @parent HelpWindow
 * @desc Text displayed when selecting a skill type.
 * %1 - Skill Type Name
 * @default Select actions to fight.
 *
 * @param HelpAutoBattle:str
 * @text Auto Battle
 * @parent HelpWindow
 * @desc Text displayed when selecting the Auto Battle command.
 * @default Sets party to Auto Battle mode.
 *
 * @param HelpOptions:str
 * @text Options
 * @parent HelpWindow
 * @desc Text displayed when selecting the Options command.
 * @default Opens up the Options Menu.
 *
 * @param HelpEscape:str
 * @text Escape
 * @parent HelpWindow
 * @desc Text displayed when selecting the escape command.
 * @default Attempt to escape the battle.
 *
 */
/* ----------------------------------------------------------------------------
 * Actor Command Window Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~ActorCmd:
 *
 * @param Cmd
 * @text Command Window
 *
 * @param CmdStyle:str
 * @text Style
 * @parent Cmd
 * @type select
 * @option Text Only
 * @value text
 * @option Icon Only
 * @value icon
 * @option Icon + Text
 * @value iconText
 * @option Automatic
 * @value auto
 * @desc How do you wish to draw commands in the Actor Command Window?
 * @default auto
 *
 * @param CmdTextAlign:str
 * @text Text Align
 * @parent Cmd
 * @type combo
 * @option left
 * @option center
 * @option right
 * @desc Text alignment for the Actor Command Window.
 * @default left
 *
 * @param CmdIconItem:num
 * @text Item Icon
 * @parent Cmd
 * @desc The icon used for the Item command.
 * @default 176
 *
 * @param IconStypeNorm:num
 * @text Normal SType Icon
 * @parent Cmd
 * @desc Icon used for normal skill types that aren't assigned any
 * icons. Ignore if VisuMZ_1_SkillsStatesCore is installed.
 * @default 78
 *
 * @param IconStypeMagic:num
 * @text Magic SType Icon
 * @parent Cmd
 * @desc Icon used for magic skill types that aren't assigned any
 * icons. Ignore if VisuMZ_1_SkillsStatesCore is installed.
 * @default 79
 *
 * @param BattleCmd
 * @text Battle Commands
 *
 * @param BattleCmdList:arraystr
 * @text Command List
 * @parent BattleCmd
 * @type combo[]
 * @option attack
 * @option skills
 * @option guard
 * @option item
 * @option party
 * @option escape
 * @option auto battle
 * @option stypes
 * @option stype: x
 * @option stype: name
 * @option all skills
 * @option skill: x
 * @option skill: name
 * @option combat log
 * @option talk
 * @option weapon swap
 * @desc List of battle commands that appear by default
 * if the <Battle Commands> notetag isn't present.
 * @default ["attack","skills","guard","party","item"]
 *
 * @param ShowCosts:eval
 * @text Show Command Costs
 * @parent BattleCmd
 * @type boolean
 * @on Show Costs
 * @off Hide Costs
 * @desc If a battle command has a resource cost, show it?
 * @default true
 *
 * @param HelpWindow
 * @text Help Window
 *
 * @param HelpSkillType:str
 * @text Skill Types
 * @parent HelpWindow
 * @desc Text displayed when selecting a skill type.
 * %1 - Skill Type Name
 * @default Opens up a list of skills under the \C[16]%1\C[0] category.
 *
 * @param HelpItem:str
 * @text Items
 * @parent HelpWindow
 * @desc Text displayed when selecting the item command.
 * @default Opens up a list of items that you can use.
 *
 * @param HelpEscape:str
 * @text Escape
 * @parent HelpWindow
 * @desc Text displayed when selecting the escape command.
 * @default Attempt to escape the battle.
 *
 * @param HelpAutoBattle:str
 * @text Auto Battle
 * @parent HelpWindow
 * @desc Text displayed when selecting the Auto Battle command.
 * @default Automatically choose an action suitable for combat.
 *
 * @param HelpParty:str
 * @text Party
 * @parent HelpWindow
 * @desc Text displayed when selecting the Party command.
 * Requires 
 * @default Automatically choose an action suitable for combat.
 *
 */
/* ----------------------------------------------------------------------------
 * Actor Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Actor:
 *
 * @param Flinch
 *
 * @param FlinchDistanceX:num
 * @text Flinch Distance X
 * @parent Flinch
 * @desc The normal X distance when flinching.
 * @default 12
 *
 * @param FlinchDistanceY:num
 * @text Flinch Distance Y
 * @parent Flinch
 * @desc The normal Y distance when flinching.
 * @default 0
 *
 * @param FlinchDuration:num
 * @text Flinch Duration
 * @parent Flinch
 * @desc The number of frames for a flinch to complete.
 * @default 6
 *
 * @param SvBattlers
 * @text Sideview Battlers
 *
 * @param AnchorX:num
 * @text Anchor: X
 * @parent SvBattlers
 * @desc Default X anchor for Sideview Battlers.
 * Use values between 0 and 1 to be safe.
 * @default 0.5
 *
 * @param AnchorY:num
 * @text Anchor: Y
 * @parent SvBattlers
 * @desc Default Y anchor for Sideview Battlers.
 * Use values between 0 and 1 to be safe.
 * @default 1.0
 *
 * @param ChantStyle:eval
 * @text Chant Style
 * @parent SvBattlers
 * @type boolean
 * @on Magical Hit Type
 * @off Magical Skill Type
 * @desc What determines the chant motion?
 * Hit type or skill type?
 * @default true
 *
 * @param OffsetX:num
 * @text Offset: X
 * @parent SvBattlers
 * @desc Offsets X position where actor is positioned.
 * Negative values go left. Positive values go right.
 * @default 0
 *
 * @param OffsetY:num
 * @text Offset: Y
 * @parent SvBattlers
 * @desc Offsets Y position where actor is positioned.
 * Negative values go up. Positive values go down.
 * @default 0
 *
 * @param MotionSpeed:num
 * @text Motion Speed
 * @parent SvBattlers
 * @type number
 * @min 1
 * @desc The number of frames in between each motion.
 * @default 12
 *
 * @param PrioritySortActive:eval
 * @text Priority: Active
 * @parent SvBattlers
 * @type boolean
 * @on Active Actor over All Else
 * @off Active Actor is Sorted Normally
 * @desc Place the active actor on top of actor and enemy sprites.
 * @default false
 *
 * @param PrioritySortActors:eval
 * @text Priority: Actors
 * @parent SvBattlers
 * @type boolean
 * @on Actors over Enemies
 * @off Sort by Y Position
 * @desc Prioritize actors over enemies when placing sprites on top
 * of each other.
 * @default true
 *
 * @param Shadow:eval
 * @text Shadow Visible
 * @parent SvBattlers
 * @type boolean
 * @on Visible
 * @off Hidden
 * @desc Show or hide the shadow for Sideview Battlers.
 * @default true
 *
 * @param SmoothImage:eval
 * @text Smooth Image
 * @parent SvBattlers
 * @type boolean
 * @on Smooth
 * @off Pixelated
 * @desc Smooth out the battler images or pixelate them?
 * @default false
 *
 * @param HomePosJS:func
 * @text JS: Home Position
 * @parent SvBattlers
 * @type note
 * @desc Code used to calculate the home position of actors.
 * @default "// Declare Constants\nconst sprite = this;\nconst actor = this._actor;\nconst index = arguments[0];\n\n// Make Calculations\nlet x = Math.round((Graphics.width / 2) + 192)\nx -= Math.floor((Graphics.width - Graphics.boxWidth) / 2);\nx += index * 32;\nlet y = (Graphics.height - 200) - ($gameParty.maxBattleMembers() * 48);\ny -= Math.floor((Graphics.height - Graphics.boxHeight) / 2);\ny += index * 48;\n\n// Home Position Offsets\nconst offsetNote = /<SIDEVIEW HOME OFFSET:[ ]([\\+\\-]\\d+),[ ]([\\+\\-]\\d+)>/i;\nconst xOffsets = actor.traitObjects().map((obj) => (obj && obj.note.match(offsetNote) ? Number(RegExp.$1) : 0));\nconst yOffsets = actor.traitObjects().map((obj) => (obj && obj.note.match(offsetNote) ? Number(RegExp.$2) : 0));\nx = xOffsets.reduce((r, offset) => r + offset, x);\ny = yOffsets.reduce((r, offset) => r + offset, y);\n\n// Set Home Position\nthis.setHome(x, y);"
 *
 */
/* ----------------------------------------------------------------------------
 * Enemy Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Enemy:
 *
 * @param Visual
 *
 * @param AttackAnimation:num
 * @text Attack Animation
 * @parent Visual
 * @type animation
 * @desc Default attack animation used for enemies.
 * Use <Attack Animation: x> for custom animations.
 * @default 1
 *
 * @param EmergeText:eval
 * @text Emerge Text
 * @parent Visual
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Show or hide the 'Enemy emerges!' text at the start of battle.
 * @default false
 *
 * @param OffsetX:num
 * @text Offset: X
 * @parent Visual
 * @desc Offsets X position where enemy is positioned.
 * Negative values go left. Positive values go right.
 * @default 0
 *
 * @param OffsetY:num
 * @text Offset: Y
 * @parent Visual
 * @desc Offsets Y position where enemy is positioned.
 * Negative values go up. Positive values go down.
 * @default 0
 *
 * @param SmoothImage:eval
 * @text Smooth Image
 * @parent Visual
 * @type boolean
 * @on Smooth
 * @off Pixelated
 * @desc Smooth out the battler images or pixelate them?
 * @default true
 *
 * @param SelectWindow
 * @text Select Window
 *
 * @param LastSelected:eval
 * @text Any: Last Selected
 * @parent SelectWindow
 * @type boolean
 * @on Last Selected
 * @off FV/SV Priority
 * @desc Prioritize last selected enemy over front view or sideview settings?
 * @default true
 *
 * @param FrontViewSelect:eval
 * @text FV: Right Priority
 * @parent SelectWindow
 * @type boolean
 * @on Right
 * @off Normal
 * @desc If using frontview, auto select the enemy furthest right.
 * @default false
 *
 * @param SideviewSelect:eval
 * @text SV: Right Priority
 * @parent SelectWindow
 * @type boolean
 * @on Right
 * @off Normal
 * @desc If using sideview, auto select the enemy furthest right.
 * @default true
 * 
 * @param Name
 *
 * @param NameLegacy:eval
 * @text Legacy Option
 * @parent Name
 * @type boolean
 * @on Legacy Version
 * @off New Version (Sprite)
 * @desc Use the legacy version (window) or new version (sprite).
 * WARNING: Legacy version is no longer supported for bugs.
 * @default false
 *
 * @param NameFontSize:num
 * @text Font Size
 * @parent Name
 * @desc Font size used for enemy names.
 * @default 22
 * 
 * @param NamePosition
 * @text Name Position
 * @parent Name
 *
 * @param NameOffsetX:num
 * @text Offset X
 * @parent NamePosition
 * @desc Offset the enemy name's X position by this much.
 * Negative goes left. Positive goes right.
 * @default 0
 *
 * @param NameOffsetY:num
 * @text Offset Y
 * @parent NamePosition
 * @desc Offset the enemy name's Y position by this much.
 * Negative goes up. Positive goes down.
 * @default 0
 *
 * @param NameAttachStateIcon:eval
 * @text Attach States
 * @parent Name
 * @type boolean
 * @on Attach
 * @off Normal Position
 * @desc Attach the enemy's state icon to the enemy name?
 * @default false
 *
 * @param AttachStateOffsetX:num
 * @text Attach: Offset X
 * @parent NameAttachStateIcon:eval
 * @desc How much to offset the attached icon's X position by?
 * Negative goes left. Positive goes right.
 * @default +0
 *
 * @param AttachStateOffsetY:num
 * @text Attach: Offset Y
 * @parent NameAttachStateIcon:eval
 * @desc How much to offset the attached icon's Y position by?
 * Negative goes up. Positive goes down.
 * @default +0
 * 
 * @param NameVisibility
 * @text Name Visibility
 * @parent Name
 *
 * @param NameAlwaysHidden:eval
 * @text Always Hidden
 * @parent NameVisibility
 * @type boolean
 * @on Always Hidden
 * @off No Priority
 * @desc Determines if the enemy name will always be visible.
 * Highest priority.
 * @default false
 *
 * @param NameAlwaysVisible:eval
 * @text Always Visible
 * @parent NameVisibility
 * @type boolean
 * @on Always Visible
 * @off Hide when Unselected
 * @desc Determines if the enemy name will always be visible.
 * Medium priority.
 * @default false
 *
 * @param NameAlwaysSelectOnly:eval
 * @text By Selection?
 * @parent NameVisibility
 * @type boolean
 * @on Visible when Selected
 * @off Visible when Targeting
 * @desc Determines the conditions for enemy name visibility.
 * Lowest priority.
 * @default false
 *
 * @param SvBattlers
 * @text Sideview Battlers
 *
 * @param AllowCollapse:eval
 * @text Allow Collapse
 * @parent SvBattlers
 * @type boolean
 * @on Allow
 * @off Don't
 * @desc Causes defeated enemies with SV Battler graphics
 * to "fade away" when defeated?
 * @default false
 *
 * @param AnchorX:num
 * @text Anchor: X
 * @parent SvBattlers
 * @desc Default X anchor for Sideview Battlers.
 * Use values between 0 and 1 to be safe.
 * @default 0.5
 *
 * @param AnchorY:num
 * @text Anchor: Y
 * @parent SvBattlers
 * @desc Default Y anchor for Sideview Battlers.
 * Use values between 0 and 1 to be safe.
 * @default 1.0
 *
 * @param MotionIdle:str
 * @text Motion: Idle
 * @parent SvBattlers
 * @type combo
 * @option walk
 * @option wait
 * @option chant
 * @option guard
 * @option damage
 * @option evade
 * @option thrust
 * @option swing
 * @option missile
 * @option skill
 * @option spell
 * @option item
 * @option escape
 * @option victory
 * @option dying
 * @option abnormal
 * @option sleep
 * @option dead
 * @desc Sets default idle animation used by Sideview Battlers.
 * @default walk
 *
 * @param Shadow:eval
 * @text Shadow Visible
 * @parent SvBattlers
 * @type boolean
 * @on Visible
 * @off Hidden
 * @desc Show or hide the shadow for Sideview Battlers.
 * @default true
 *
 * @param Width:num
 * @text Size: Width
 * @parent SvBattlers
 * @type number
 * @min 1
 * @desc Default width for enemies that use Sideview Battlers.
 * @default 64
 *
 * @param Height:num
 * @text Size: Height
 * @parent SvBattlers
 * @type number
 * @min 1
 * @desc Default height for enemies that use Sideview Battlers.
 * @default 64
 *
 * @param WtypeId:num
 * @text Weapon Type
 * @parent SvBattlers
 * @type number
 * @min 0
 * @desc Sets default weapon type used by Sideview Battlers.
 * Use 0 for Bare Hands.
 * @default 0
 *
 */
/* ----------------------------------------------------------------------------
 * HP Gauge Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~HpGauge:
 *
 * @param Display
 * @text Show Gauges For
 *
 * @param ShowActorGauge:eval
 * @text Actors
 * @parent Display
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Show HP Gauges over the actor sprites' heads?
 * Requires SV Actors to be visible.
 * @default true
 *
 * @param ShowEnemyGauge:eval
 * @text Enemies
 * @parent Display
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Show HP Gauges over the enemy sprites' heads?
 * Can be bypassed with <Hide HP Gauge> notetag.
 * @default true
 *
 * @param RequiresDefeat:eval
 * @text Requires Defeat?
 * @parent ShowEnemyGauge:eval
 * @type boolean
 * @on Require Defeat First
 * @off No Requirement
 * @desc Requires defeating the enemy once to show HP Gauge?
 * Can be bypassed with <Show HP Gauge> notetag.
 * @default true
 *
 * @param BTestBypass:eval
 * @text Battle Test Bypass?
 * @parent RequiresDefeat:eval
 * @type boolean
 * @on Bypass
 * @off Don't Bypass
 * @desc Bypass the defeat requirement in battle test?
 * @default true
 *
 * @param Settings
 *
 * @param AnchorX:num
 * @text Anchor X
 * @parent Settings
 * @desc Where do you want the HP Gauge sprite's anchor X to be?
 * Use values between 0 and 1 to be safe.
 * @default 0.5
 *
 * @param AnchorY:num
 * @text Anchor Y
 * @parent Settings
 * @desc Where do you want the HP Gauge sprite's anchor Y to be?
 * Use values between 0 and 1 to be safe.
 * @default 1.0
 *
 * @param Scale:num
 * @text Scale
 * @parent Settings
 * @desc How large/small do you want the HP Gauge to be scaled?
 * @default 0.5
 *
 * @param OffsetX:num
 * @text Offset X
 * @parent Settings
 * @desc How many pixels to offset the HP Gauge's X by?
 * @default 0
 *
 * @param OffsetY:num
 * @text Offset Y
 * @parent Settings
 * @desc How many pixels to offset the HP Gauge's Y by?
 * @default -3
 *
 * @param Options
 * @text Options
 *
 * @param AddHpGaugeOption:eval
 * @text Add Option?
 * @parent Options
 * @type boolean
 * @on Add
 * @off Don't Add
 * @desc Add the 'Show HP Gauge' option to the Options menu?
 * @default true
 *
 * @param AdjustRect:eval
 * @text Adjust Window Height
 * @parent Options
 * @type boolean
 * @on Adjust
 * @off Don't
 * @desc Automatically adjust the options window height?
 * @default true
 *
 * @param Name:str
 * @text Option Name
 * @parent Options
 * @desc Command name of the option.
 * @default Show HP Gauge
 *
 */
/* ----------------------------------------------------------------------------
 * Action Sequence Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~ActionSequence:
 *
 * @param AutoSequences
 * @text Automatic Sequences
 *
 * @param AutoMeleeSolo:eval
 * @text Melee Single Target
 * @parent AutoSequences
 * @type boolean
 * @on Allow
 * @off Ignore
 * @desc Allow this auto sequence for physical, single target actions?
 * @default true
 *
 * @param AutoMeleeAoE:eval
 * @text Melee Multi Target
 * @parent AutoSequences
 * @type boolean
 * @on Allow
 * @off Ignore
 * @desc Allow this auto sequence for physical, multi-target actions?
 * @default true
 *
 * @param QoL
 * @text Quality of Life
 *
 * @param AutoNotetag:eval
 * @text Auto Notetag
 * @parent QoL
 * @type boolean
 * @on Automatic
 * @off Manual
 * @desc Automatically apply the <Custom Action Sequence> notetag
 * effect to any item or skill that has a Common Event?
 * @default false
 *
 * @param CastAnimations
 * @text Cast Animations
 *
 * @param CastCertain:num
 * @text Certain Hit
 * @parent CastAnimations
 * @type animation
 * @desc Cast animation for Certain Hit skills.
 * @default 120
 *
 * @param CastPhysical:num
 * @text Physical
 * @parent CastAnimations
 * @type animation
 * @desc Cast animation for Physical skills.
 * @default 52
 *
 * @param CastMagical:num
 * @text Magical
 * @parent CastAnimations
 * @type animation
 * @desc Cast animation for Magical skills.
 * @default 51
 *
 * @param CounterReflection
 * @text Counter/Reflect
 *
 * @param CounterPlayback:eval
 * @text Counter Back
 * @parent CounterReflection
 * @type boolean
 * @on Play Back
 * @off Ignore
 * @desc Play back the attack animation used?
 * @default true
 *
 * @param ReflectAnimation:num
 * @text Reflect Animation
 * @parent CounterReflection
 * @type animation
 * @desc Animation played when an action is reflected.
 * @default 53
 *
 * @param ReflectPlayback:eval
 * @text Reflect Back
 * @parent CounterReflection
 * @type boolean
 * @on Play Back
 * @off Ignore
 * @desc Play back the attack animation used?
 * @default true
 *
 * @param Stepping
 *
 * @param MeleeDistance:num
 * @text Melee Distance
 * @parent Stepping
 * @desc Minimum distance in pixels for Movement Action Sequences.
 * @default 24
 *
 * @param StepDistanceX:num
 * @text Step Distance X
 * @parent Stepping
 * @desc The normal X distance when stepping forward.
 * @default 48
 *
 * @param StepDistanceY:num
 * @text Step Distance Y
 * @parent Stepping
 * @desc The normal Y distance when stepping forward.
 * @default 0
 *
 * @param StepDuration:num
 * @text Step Duration
 * @parent Stepping
 * @desc The number of frames for a stepping action to complete.
 * @default 12
 *
 */
/* ----------------------------------------------------------------------------
 * Projectile Start Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~ProjectileStart:
 * 
 * @param Type:str
 * @text Type
 * @type select
 * @option Target - Start from battler target(s)
 * @value target
 * @option Point - Start from a point on the screen
 * @value point
 * @desc Select where the projectile should start from.
 * @default target
 * 
 * @param Targets:arraystr
 * @text Target(s)
 * @parent Type:str
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to start the projectile from.
 * @default ["user"]
 * 
 * @param TargetCenter:eval
 * @text Centralize
 * @parent Targets:arraystr
 * @type boolean
 * @on Center Projectile
 * @off Create Each
 * @desc Create one projectile at the center of the targets?
 * Or create a projectile for each target?
 * @default false
 * 
 * @param TargetLocation:str
 * @text Target Location
 * @parent Targets:arraystr
 * @type combo
 * @option front head
 * @option front center
 * @option front base
 * @option middle head
 * @option middle center
 * @option middle base
 * @option back head
 * @option back center
 * @option back base
 * @desc Select which part of the target to send the projectile from.
 * @default middle center
 * 
 * @param PointX:eval
 * @text Point X
 * @parent Type:str
 * @desc Insert the X coordinate to start the projectile at.
 * You may use JavaScript code.
 * @default Graphics.width / 2
 * 
 * @param PointY:eval
 * @text Point Y
 * @parent Type:str
 * @desc Insert the Y coordinate to start the projectile at.
 * You may use JavaScript code.
 * @default Graphics.height / 2
 * 
 * @param OffsetX:eval
 * @text Offset X
 * @desc Insert how many pixels to offset the X coordinate by.
 * You may use JavaScript code.
 * @default +0
 * 
 * @param OffsetY:eval
 * @text Offset Y
 * @desc Insert how many pixels to offset the Y coordinate by.
 * You may use JavaScript code.
 * @default +0
 *
 */
/* ----------------------------------------------------------------------------
 * Projectile Goal Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~ProjectileGoal:
 * 
 * @param Type:str
 * @text Type
 * @type select
 * @option Target - Goal is battler target(s)
 * @value target
 * @option Point - Goal is a point on the screen
 * @value point
 * @desc Select where the projectile should go to.
 * @default target
 * 
 * @param Targets:arraystr
 * @text Target(s)
 * @parent Type:str
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) for projectile to go to.
 * @default ["all targets"]
 * 
 * @param TargetCenter:eval
 * @text Centralize
 * @parent Targets:arraystr
 * @type boolean
 * @on Center Projectile
 * @off Create Each
 * @desc Set goal in the center of targets?
 * Or create a projectile to go to each target?
 * @default false
 * 
 * @param TargetLocation:str
 * @text Target Location
 * @parent Targets:arraystr
 * @type combo
 * @option front head
 * @option front center
 * @option front base
 * @option middle head
 * @option middle center
 * @option middle base
 * @option back head
 * @option back center
 * @option back base
 * @desc Select which part of the target to send the projectile at.
 * @default middle center
 * 
 * @param PointX:eval
 * @text Point X
 * @parent Type:str
 * @desc Insert the X coordinate to send the projectile to.
 * You may use JavaScript code.
 * @default Graphics.width / 2
 * 
 * @param PointY:eval
 * @text Point Y
 * @parent Type:str
 * @desc Insert the Y coordinate to send the projectile to.
 * You may use JavaScript code.
 * @default Graphics.height / 2
 * 
 * @param OffsetX:eval
 * @text Offset X
 * @desc Insert how many pixels to offset the X coordinate by.
 * You may use JavaScript code.
 * @default +0
 * 
 * @param OffsetY:eval
 * @text Offset Y
 * @desc Insert how many pixels to offset the Y coordinate by.
 * You may use JavaScript code.
 * @default +0
 *
 */
/* ----------------------------------------------------------------------------
 * Projectile Extra Animation Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~ProjectileExAni:
 * 
 * @param AutoAngle:eval
 * @text Auto Angle?
 * @parent Settings
 * @type boolean
 * @on Automatically Angle
 * @off Normal
 * @desc Automatically angle the projectile to tilt the direction it's moving?
 * @default true
 * 
 * @param AngleOffset:eval
 * @text Angle Offset
 * @desc Alter the projectile's tilt by this many degrees.
 * @default +0
 * 
 * @param Arc:eval
 * @text Arc Peak
 * @parent Settings
 * @desc This is the height of the project's trajectory arc
 * in pixels.
 * @default 0
 *
 * @param EasingType:str
 * @text Easing
 * @parent Settings
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type to apply to the projectile's trajectory.
 * @default Linear
 * 
 * @param Spin:eval
 * @text Spin Speed
 * @parent Settings
 * @desc Determine how much angle the projectile spins per frame.
 * Does not work well with "Auto Angle".
 * @default +0.0
 *
 */
/* ----------------------------------------------------------------------------
 * Projectile Extra Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~ProjectileExtra:
 * 
 * @param AutoAngle:eval
 * @text Auto Angle?
 * @parent Settings
 * @type boolean
 * @on Automatically Angle
 * @off Normal
 * @desc Automatically angle the projectile to tilt the direction it's moving?
 * @default true
 * 
 * @param AngleOffset:eval
 * @text Angle Offset
 * @desc Alter the projectile's tilt by this many degrees.
 * @default +0
 * 
 * @param Arc:eval
 * @text Arc Peak
 * @parent Settings
 * @desc This is the height of the project's trajectory arc
 * in pixels.
 * @default 0
 *
 * @param BlendMode:num
 * @text Blend Mode
 * @type select
 * @option 0 - Normal
 * @value 0
 * @option 1 - Additive
 * @value 1
 * @option 2 - Multiply
 * @value 2
 * @option 3 - Screen
 * @value 3
 * @desc What kind of blend mode do you wish to apply to the projectile?
 * @default 0
 *
 * @param EasingType:str
 * @text Easing
 * @parent Settings
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type to apply to the projectile's trajectory.
 * @default Linear
 * 
 * @param Hue:eval
 * @text Hue
 * @parent Settings
 * @desc Adjust the hue of the projectile.
 * Insert a number between 0 and 360.
 * @default 0
 * 
 * @param Scale:eval
 * @text Scale
 * @parent Settings
 * @desc Adjust the size scaling of the projectile.
 * Use decimals for exact control.
 * @default 1.0
 * 
 * @param Spin:eval
 * @text Spin Speed
 * @parent Settings
 * @desc Determine how much angle the projectile spins per frame.
 * Does not work well with "Auto Angle".
 * @default +0.0
 *
 */
//=============================================================================

const _0xfd5ed1=_0x4950;(function(_0x13a3dc,_0x522ad6){const _0x5db368=_0x4950,_0x315127=_0x13a3dc();while(!![]){try{const _0x5c21df=parseInt(_0x5db368(0x948))/0x1+-parseInt(_0x5db368(0x429))/0x2*(-parseInt(_0x5db368(0x84f))/0x3)+parseInt(_0x5db368(0xafb))/0x4*(-parseInt(_0x5db368(0x569))/0x5)+-parseInt(_0x5db368(0x62b))/0x6+-parseInt(_0x5db368(0x4a2))/0x7+-parseInt(_0x5db368(0x3be))/0x8*(parseInt(_0x5db368(0x85f))/0x9)+parseInt(_0x5db368(0xbbe))/0xa*(parseInt(_0x5db368(0x5dc))/0xb);if(_0x5c21df===_0x522ad6)break;else _0x315127['push'](_0x315127['shift']());}catch(_0x858e1a){_0x315127['push'](_0x315127['shift']());}}}(_0x12e1,0x610fd));function _0x12e1(){const _0x2b96b4=['getColor','thrust','svBattlerShadowVisible','ActSeq_Element_ForceElements','_baseLineStack','_skewEasing','evaded','isOpponent','_actorCommandWindow','isSideView','isMoving','_text','Scene_Battle_selectNextCommand','isPartyTpbInputtable','Sprite_Actor_updateShadow','battleLayoutStyle','OJBBk','VisuMZ_1_ElementStatusCore','Window_BattleLog_update','ActSeq_Movement_WaitForFloat','isMagical','PerformAction','setActorHome','fwMRZ','Sprite_Animation_targetSpritePosition','lYaiy','randomInt','ActSeq_Impact_ZoomBlurTargetCenter','ActSeq_Motion_MotionType','ppvGN','CommandAddAutoBattle','Sprite_Battler_startMove','VWxbQ','AlphaFilter','jonrd','_spriteset','DefaultHardCap','commandName','ShowTpDmg','evade','battlerSmoothImage','cancel','XJVxb','_partyCommandWindow','width','pointY','Sprite_Actor_moveToStartPosition','stepFlinch','isDisplayEmergedEnemies','_preemptive','ActSeq_Camera_Reset','BqaZi','TpGaugeOffsetY','Scene_Battle_createAllWindows','hJZqn','ZFxKZ','isCharging','PreStartTurnJS','<%1>\x5cs*([\x5cs\x5cS]*)\x5cs*<\x5c/%1>','IAxBy','isDebuffAffected','kbDOU','Scene_Boot_onDatabaseLoaded','onEncounter','auto','odYMe','Wgyhu','Scene_Battle_startActorCommandSelection','_battleCoreBattleResumeAfter','battlelog','regenerateAllBattleCore','stbGainInstant','start','RevertAngle','COMBAT\x20LOG','battleCameraData','displayBuffs','Game_Interpreter_terminate','checkAutoCustomActionSequenceNotetagEffect','onActorOk','WaitCount2','anchorX','_wtypeIDs','GRDuf','pdBGO','_backAttachmentSprite','WgRYa','_inputting','ActSeq_Mechanics_PtbFullHalfAction','members','%1EndActionJS','addAnimationSpriteToContainer','TOSRQ','msxCB','Intensity','isForRandomBattleCore','createShadowSprite','addPartyCommand','_homeX','ActionStart','jLRjz','onGrowEnd','PreEndTurnJS','regionId','HaIsv','validTargets','XuaHr','adtwE','ActSeq_Zoom_Scale','eraseState','autoBattleUseSkills','attachSpritesToDistortionSprite','performFlinch','FyoCt','Window_ActorCommand_initialize','canUseItemCommand','command357','Scene_Battle_helpWindowRect','_enemyId','WaitForZoom','ESvgq','eMsKD','LlsEI','battleEffect','_subject','requestPointAnimation','setHue','hsBQE','victory','mainSprite','ParseEnemyNotetags','createMainSprite','setBattleCameraPoint','svBattlerAnchorX','message4','terminate','displayChangedBuffs','setup','lXQcV','Sprite_Enemy_initVisibility','QibuW','wholeActionSet','getDamageStyle','Defeat','AS\x20TARGET','registerCommand','rRSCu','DefaultSoftCap','EFFECT_COMMON_EVENT','makeData','xymxx','tSqLT','MDF','isSceneBattle','#ffffff','setupIconTextPopup','XgsIn','_battlePortrait','canAddSkillCommand','_cursorSprite','64970vCEpQH','Elements','SKILLS','IconStypeNorm','ActSeq_Impact_ShockwaveCenterTargets','setHelpWindowItem','PostEndBattleJS','MeleeDistance','ShowFacesListStyle','linkSprite','push','_uiContainer','customDamageFormula','allowCollapse','makeSpeed','qpVRk','createDigits','casting','ActSeq_Horror_TVRemove','_skewX','Scene_Map_initialize','onRegeneratePlayStateAnimation','open','user','repeats','SbRRe','AByeZ','jump','formula','ADpAc','_targetIndex','StatusWindowAttachmentBack','updateAttachmentSprites','Actor','checkShowHideSkillNotetags','refreshStatusWindow','AUTO\x20BATTLE','ActSeq_Movement_FaceDirection','_shadowSprite','initialize','BattleLog','_battleField','ShowPortraitsBorderStyle','createAttachmentSprites','isAnyoneGrowing','QxTWx','inHomePosition','_battler','Skill-%1-%2','Spriteset_Battle_createLowerLayer','isSTB','ArPenFlat','tIcTH','Slot','spriteId','PXyhw','isAnimationShownOnBattlePortrait','UNTITLED','mTSWH','hhkqh','LastSelected','placeActorName','updateShadowScale','States','constructor','DistanceX','StatusWindowSkinHide','_dragonbonesSpriteContainer','UmWzM','zVqke','autoMeleeMultiTargetActionSet','_speed','processRefresh','YfymC','selectPreviousCommand','front\x20base','XqiQe','updateMain','yKnKU','oeUPD','isOptionsCommandEnabled','getAttackMotionSlot','createMiss','isAnyProjectilePresent','MkmvG','process_VisuMZ_BattleCore_Action_Notetags','Window_BattleLog_performMiss','nReAf','ActSeq_Angle_WaitForAngle','selectNextCommandTpb','<CENTER>%1','options','clearElementChanges','performSTBExploiter','backColor','EscapeFail','esGKe','nruqF','Window_BattleLog_performCounter','Game_Troop_setup','createBattleField','Sprite_Actor_setActorHome','battleAngle','ShuffleArray','RyrVi','RTROv','Game_BattlerBase_die','unchanged','sliceMin','chIsY','addItemCommand','isAtbCastingState','battleCoreResumeLaunchBattle','PreEndActionJS','aqbhW','CmdIconItem','hpHealingFmt','ShowEnemyGauge','isBypassDamageCap','TumoZ','skillItemWindowRectBorderStyle','CommandVisible','_index','ConvertParams','checkShowHideBattleNotetags','isAnyoneJumping','applyGuard','_linkedSprite','damageOffsetX','isCustomActionSequence','OffsetX','oEcCm','_battleCoreForcedElements','CriticalHitRate','angle','changeBattlebacks','createAnimationContainer','actor%1-portrait','makeTargetsBattleCore','VCKhA','LZRhT','NkHIB','Window_BattleLog_performDamage','updateFrame','Immortal','hCnmi','battleAnimation','nUSwT','ClearBattleLog','alive\x20battlers','revertTpbCachedActor','xgLKw','updateBitmap','pow','addText','mainSpriteWidth','createAllWindows','Scene_Battle_onActorOk','ActSeq_Target_CurrentIndex','BattleCore','vzwhU','KGpYX','priority','Wave','DEdAB','clearFreezeMotionForWeapons','updateStateIconSprite','hBzva','faceRect','drawItemImage','_offsetX','Enemy','AddOption','_skewDuration','displaySubstitute','ATK','createAutoBattleWindow','message2','loadEnemy','coreEngineRepositionEnemies','portrait','_stateSprite','szrhp','needsSelectionBattleCore','nameY','EXcPt','applyForcedGameTroopSettingsBattleCore','targetSpritePosition','UniIa','ParseSkillNotetags','Window_BattleLog_performCollapse','_flashDuration','duration','isItem','SvWeaponSolo-%1-%2','drawItem','movement','commandNameWindowCenter','PiqVq','FlashColor','isClicked','hide','endAnimation','fnordAddedStates','ActSeq_Movement_MoveToPoint','resetFontSettings','initMembers','ActSeq_Zoom_Reset','_commonEventKey','WRPeX','wvQlX','stop','ENMmD','DistanceAdjust','BattleManager_onEscapeSuccess','JOGLK','format','eBHNH','setCustomDamageFormula','startSpin','PopupShiftX','DefaultDamageStyle','updateGrow','pattern','textSizeEx','PreDamageAsUserJS','WaitForProjectile','ActSeq_Target_PrevTarget','bgType','removeBuffsAuto','animationNextDelay','Formula','noise','WoZun','gainTp','_target','MAXHP','TJqCy','command339','loadBitmap','GTPSg','createBorderStylePortraitSprite','jHqDr','VisuMZ_2_BattleSystemPTB','autoBattleWindowRect','WnVlR','ResetFocus','Scene_Battle_startEnemySelection','isAppeared','parse','ActSeq_Movement_WaitForSpin','criticalDmgRate','battleCamera','kjSMf','createWeather','AdjustRect','TPaQd','_damagePopupArray','dataId','RTkUB','filterArea','_jumpMaxHeight','BaseTroopIDs','autoBattle','BattleManager_initMembers','_growX','_lines','XgNfa','ActSeq_Movement_WaitForMovement','EnableSoftCap','performJump','isEscapeCommandEnabled','Spriteset_Battle_createBattleField','toUseBoostPoints','Destination','callUpdateHelp','MyWoe','QFgso','GZnUp','DisablePartyCmd','FlinchDistanceY','prototype','fontSize','PostApplyAsTargetJS','anchor','drawIcon','clone','JQGjb','addBattleCoreAutoBattleStyleCommand','ParseClassNotetags','_isBattlerFlipped','qHpbl','Scene_Battle_createHelpWindow','cancelButtonText','BreakShields','round','HelpAutoBattle','alive\x20enemies','VisuMZ_2_DragonbonesUnion','refreshCursor','_battlerName','MJssV','Window_BattleLog_performMagicEvasion','actor','dAiIE','Ylnwn','isFastForward','NameLegacy','contains','gainFullActionsPTB','SLOMv','ShowMissEvasion','displayActionResults','_escapeRatio','waitForMovement','measureTextWidth','updateActors','performActionMotions','Height','splice','applyArmorModifiers','repeatTargets','power','PostDamageJS','createBattleFieldContainer','sortDamageSprites','ScaleDown','LfLMV','BHNFu','gMMGV','Sprite_Battler_updatePosition','CREVu','getItemDamageAmountTextOriginal','StepDuration','shadow','WaitForNewLine','turnOrderChangeOTB','displayAffectedStatus','EscapeFailureJS','addChildAt','isLearnedSkill','Scene_Battle_stop','isFriendly','setHorrorEffectSettings','isOkEnabled','sLYxO','_cacheTextWidth','process_VisuMZ_BattleCore_Notetags','_updateCursorFilterArea','_cursorArea','CriticalDmgRate','isCertainHit','Provp','_itemWindow','autoBattleStart','lsROS','performCounter','_targets','equipSlots','GuardFormulaJS','VisuMZ_2_HorrorEffects','DGeiz','Game_Map_battleback1Name','startInput','setFullActionsPTB','toString','updateCallMenu','hFsHj','origin','Zhtoy','HP_Rate','applyCritical','FullActions','WrcCc','ZktmT','makeActionList','getStypeIdWithName','keoLT','Post','AutoBattleMsg','_action','Game_Enemy_transform','compareBattlerSprites','showAnimation','NameAlwaysVisible','PostEndActionJS','regenerateAll','_lastAction','prepareCustomActionSequence','changeCtbCastTime','LlEqH','ActSeq_Mechanics_BtbGain','HpGauge','_colorType','PMEcb','ShowHide','createEffectActionSet','dCMVi','VEsmd','AutoBattle','parent','processBattleCoreJS','BattleManager_onEncounter','clearActiveWeaponSlot','IXDqM','clearResult','UHCHV','anfRp','_deathStateApplied','makeEscapeRatio','hrjGi','WzcrI','ZgMly','updateOpacity','FlinchDuration','startWeaponAnimation','%1Event','ActSeq_Camera_WaitForCamera','LcdLG','SgiPy','checkShowHideSwitchNotetags','itemLineRect','JS\x20%1REGENERATE','helpWindowRect','subject','nghie','updateWeather','updatePadding','JumpToLabel','_methods','iingo','removedBuffs','CastPhysical','Sprite_StateIcon_updateFrame','Scene_Battle_createPartyCommandWindow','startAttackWeaponAnimation','eJmjt','applyResultSwitches','trim','ShowReflect','createStateSprite','_cache','BnPZz','createCommandVisibleJS','beFZR','requestAnimation','BattleLogRectJS','LQgCX','WaitCount1','AaRzR','PreApplyAsUserJS','_additionalSprites','BattleManager_makeActionOrders','kAVlt','initVisibility','StateIconOffsetY','SkillItemBorderCols','PreDamageJS','Ayiyh','requestRefresh','effect','_targetGrowX','KrYsQ','FrontViewSelect','dragonbonesData','occasion','\x0a\x20\x20\x20\x20\x20\x20\x20\x20//\x20Declare\x20Arguments\x0a\x20\x20\x20\x20\x20\x20\x20\x20const\x20user\x20=\x20arguments[0];\x0a\x20\x20\x20\x20\x20\x20\x20\x20const\x20skill\x20=\x20arguments[1];\x0a\x20\x20\x20\x20\x20\x20\x20\x20const\x20a\x20=\x20user;\x0a\x20\x20\x20\x20\x20\x20\x20\x20const\x20b\x20=\x20user;\x0a\x20\x20\x20\x20\x20\x20\x20\x20let\x20visible\x20=\x20true;\x0a\x0a\x20\x20\x20\x20\x20\x20\x20\x20//\x20Process\x20Code\x0a\x20\x20\x20\x20\x20\x20\x20\x20try\x20{\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20%1\x0a\x20\x20\x20\x20\x20\x20\x20\x20}\x20catch\x20(e)\x20{\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20if\x20($gameTemp.isPlaytest())\x20console.log(e);\x0a\x20\x20\x20\x20\x20\x20\x20\x20}\x0a\x0a\x20\x20\x20\x20\x20\x20\x20\x20//\x20Return\x20Value\x0a\x20\x20\x20\x20\x20\x20\x20\x20return\x20visible;\x0a\x20\x20\x20\x20','ActSeq_Element_NullElements','return\x200','ActSeq_Impact_MotionTrailRemove','Window_Options_statusText','HGGWQ','cameraOffsetDuration','isAnyoneChangingOpacity','qKDMX','statusWindowRect','contentsOpacity','skew','HpGaugeOffsetY','isTpbCharged','adjustFlippedBattlefield','getNextSubjectFromPool','makeActions','BattleStartEvent','onFloatEnd','isBusy','tYjdU','SRdaR','createTroopNote','enemy','addSingleSkillCommand','VariableDmg','processEscape','AybZs','ActSeq_Horror_Clear','isSceneChanging','lsURn','Game_Action_makeTargets','scope','isHidden','ZFsCv','YAiWe','yBLzF','isQueueOptionsMenu','battleUIOffsetY','not\x20focus','ChOpW','Scene_Battle_terminate','changeWeather','QMvyp','\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20//\x20Declare\x20Arguments\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20user\x20=\x20arguments[0];\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20target\x20=\x20arguments[1];\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20obj\x20=\x20arguments[2];\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20let\x20value\x20=\x20arguments[3]\x20||\x200;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20let\x20originalValue\x20=\x20value;\x0a\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20//\x20Declare\x20Constants\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20action\x20=\x20(this.constructor\x20===\x20Game_Action)\x20?\x20this\x20:\x20user.currentAction();\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20a\x20=\x20user;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20b\x20=\x20target;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20attacker\x20=\x20user;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20defender\x20=\x20target;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20healer\x20=\x20user;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20receiver\x20=\x20target;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20actor\x20=\x20obj;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20currentClass\x20=\x20obj;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20skill\x20=\x20(this.constructor\x20===\x20Game_Action)\x20?\x20this.item()\x20:\x20obj;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20item\x20=\x20(this.constructor\x20===\x20Game_Action)\x20?\x20this.item()\x20:\x20obj;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20weapon\x20=\x20obj;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20armor\x20=\x20obj;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20enemy\x20=\x20obj;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20state\x20=\x20obj;\x0a\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20//\x20Create\x20Compatibility\x20Variables\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20let\x20origin\x20=\x20user;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20if\x20(Imported.VisuMZ_1_SkillsStatesCore\x20&&\x20$dataStates.includes(obj))\x20{\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20origin\x20=\x20target.getStateOrigin(obj.id);\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20}\x0a\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20//\x20Process\x20Code\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20try\x20{\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20%1\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20}\x20catch\x20(e)\x20{\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20if\x20($gameTemp.isPlaytest())\x20console.log(e);\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20}\x0a\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20//\x20NaN\x20Check\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20if\x20(isNaN(value)){\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20if\x20($gameTemp.isPlaytest())\x20{\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20console.log(\x27NaN\x20value\x20created\x20by\x20%2\x27.format(\x27\x27,obj.name));\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20console.log(\x27Restoring\x20value\x20to\x20%2\x27.format(\x27\x27,originalValue));\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20}\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20value\x20=\x20originalValue;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20}\x0a\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20//\x20Return\x20Value\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20return\x20value;\x0a\x20\x20\x20\x20\x20\x20\x20\x20','RegExp','uiInputPosition','JS\x20ESCAPE\x20SUCCESS','_weaponSprite','_targetOpacity','updateSpin','WaitForScale','_animationCount','addAttackCommand','_createCursorArea','selectNextActor','MotionType','bOpkf','front\x20center','ooeUe','displayCounter','_borderPortraitSprite','isDuringNonLoopingMotion','floatBattler','alive\x20opponents','isWaiting','LdlPZ','battleCommands','canBattlerMove','guardSkillId','ActSeq_Set_FinishAction','gainMp','NameAttachStateIcon','addCombatLogCommand','uCqVM','updateFloat','_floatDuration','visibilityState','ActSeq_Motion_FreezeMotionFrame','drGXZ','pointX','_customDamageFormula','AutoBattleOK','Filename','Scene_ItemBase_applyItem','getConfigValue','missile','_autoBattle','JS\x20%1END\x20TURN','_floatWholeDuration','getBattlePortraitOffsetX','_allTargets','_lastPluginCommandInterpreter','statusText','GgSNV','startActorCommandSelection','ActSeq_BattleLog_DisplayAction','EgJdM','popupDamage','isFTB','POST-','maxCommands','dsQZt','allowRandomSpeed','Scene_Battle_updateBattleProcess','_actions','PKtxW','_damageContainer','IInkm','_skewY','qAund','JHbEN','ActSeq_Animation_PlayAtCoordinate','_phase','updatePointAnimations','fbmEH','moveToStartPosition','NaULk','adjustPosition_ScaleUp','setImmortal','changeTurnOrderByCTB','HJuYK','_targetSkewX','startDamagePopup','Scene_Battle_onActorCancel','cKmkC','alterChange','smBbV','ActiveTpbOptionsMessage','status','removeBuff','isBattlerFlipped','shift','+%1\x20MP','Game_Action_applyGlobal','frontviewSpriteY','rFvKm','refreshBattlerMotions','isFightCommandEnabled','ActSeq_Motion_ClearFreezeFrame','STYPES','addEscapeCommand','setupCriticalEffect','DrnYA','process_VisuMZ_BattleCore_TraitObject_Notetags','qwREO','innerHeight','setActionState','actorId','showPortraits','updateBorderStyle','ActSeq_Mechanics_FtbAction','createBattleFieldBattleCore','GxOhW','maxBattleMembers','AnimationID','gaugeLineHeight','processPostBattleCommonEvents','cZjxU','Game_Action_itemEffectAddAttackState','nLHlW','XPSpriteYLocation','8DNHqXX','ElementStatusCore','updateCollapse','vYdna','alive\x20battlers\x20not\x20user','_scene','becomeSTBExploited','MaxLines','wlOgU','item','PrioritySortActive','FLslo','mugEa','Shadow2','stepBack','bsKaQ','useItem','displayRemovedStates','isBuffAffected','clear','createEnemyNames','autoSelectPriority','showEnemyAttackAnimation','statusWindowRectXPStyle','PreApplyJS','addBattleCoreAutoBattleStartupCommand','addChild','%1\x27s\x20version\x20does\x20not\x20match\x20plugin\x27s.\x20Please\x20update\x20it\x20in\x20the\x20Plugin\x20Manager.','JkPMA','tGYwG','BattleManager_cancelActorInput','makeDeepCopy','\x0a\x20\x20\x20\x20\x20\x20\x20\x20//\x20Declare\x20Arguments\x0a\x20\x20\x20\x20\x20\x20\x20\x20const\x20user\x20=\x20arguments[0];\x0a\x20\x20\x20\x20\x20\x20\x20\x20const\x20a\x20=\x20user;\x0a\x20\x20\x20\x20\x20\x20\x20\x20const\x20b\x20=\x20user;\x0a\x20\x20\x20\x20\x20\x20\x20\x20let\x20targets\x20=\x20arguments[1];\x0a\x0a\x20\x20\x20\x20\x20\x20\x20\x20//\x20Process\x20Code\x0a\x20\x20\x20\x20\x20\x20\x20\x20try\x20{\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20%1\x0a\x20\x20\x20\x20\x20\x20\x20\x20}\x20catch\x20(e)\x20{\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20if\x20($gameTemp.isPlaytest())\x20console.log(e);\x0a\x20\x20\x20\x20\x20\x20\x20\x20}\x0a\x0a\x20\x20\x20\x20\x20\x20\x20\x20//\x20Return\x20Value\x0a\x20\x20\x20\x20\x20\x20\x20\x20return\x20targets\x20||\x20[];\x0a\x20\x20\x20\x20','alive\x20actors\x20not\x20target','canInput','value1','razEz','applyItem','addSkillTypeCommand','createContents','wZqlV','createBattleUIOffsetX','CombatLogIcon','hpDamageFmt','checkTpbInputOpen','_targetFloatHeight','revealNewWeaknesses','addShowHpGaugeCommand','map','ToKgp','TargetLocation','Scene_Battle_onEnemyCancel','Sprite_Actor_update','forceMotion','BoostPoints','isAffectedByBreakShield','_flinched','wait','Scene_Battle_selectPreviousCommand','_callSceneOptions','ActSeq_Projectile_Icon','ActSeq_Movement_Opacity','VisuMZ_3_WeaknessDisplay','applyFreezeMotionFrames','ActionCount','RKTsK','setupActionSet','uzUkL','Targets2','isJumping','attackAnimationIdSlot','VariableHeal','ITEM','_tempBattler','isPartyCommandWindowDisabled','fwRFI','ZLMvo','repositionEnemiesByResolution','gainHalfActionsPTB','ParseWeaponNotetags','NxbdR','performReflection','updateStateSpriteBattleCore','iKfmp','StatusWindowAttachmentBackOffsetX','createEmptyBitmap','YoJoI','isActiveTpb','setBattlerFacePoint','_targetAngle','displayMpDamage','vOteR','getHardDamageCap','visible','BattleManager_startTurn','setMoveEasingType','setBattlerFlip','MCgpF','onMoveEnd','die','ParseStateNotetags','getItemDamageAmountLabelOriginal','PortraitScaleBorderStyle','OypoI','initMembersBattleCore','refreshRequest','fillRect','6OwHQJP','updateSkew','isCTB','reduce','damage','Opacity','JEsVE','isPTB','CmdIconFight','QJhHV','_defeatedEnemies','ucwrJ','displayAddedStates','SwitchCritical','_duration','isBattleFlipped','isUndecided','maxTp','updateShadow','base','nvsih','1:1','isForAll','DTWXt','isOpen','TmivP','physical','VHeDj','isFloating','isMagicSkill','isFlipped','popBaseLine','createEnemyNameContainer','Game_Map_setupBattleback','DefaultStyle','ParseArmorNotetags','getSkillTypes','code','WaitComplete','VisuMZ_3_ActSeqCamera','makeDamageValue','name','clearDamagePopup','clearMotion','pJGyI','battler','ActSeq_BattleLog_WaitForNewLine','actorCommandEscape','statusWindowRectBorderStyle','ActSeq_Horror_NoiseRemove','performAttack','Actor-%1-%2','mVzNx','addChildToBack','TPJOZ','UhnUH','autoSelect','ForceRandom','QNoHp','close','requestMotion','_skewWholeDuration','ActSeq_Mechanics_RemoveState','lineRect','WaitForJump','pop','damageRate','fQIib','nKuYL','iyQys','AsTarget','KHeKM','mainSpriteScaleX','ActionSequence','jOBTu','CDjcq','notFocusValid','Sprite_Actor_updateBitmap','windowAreaHeight','canAlterActionCostPTB','SyKpw','makeAutoBattleActions','isTpb','nBQDq','XiOvz','DigitGrouping','HelpFight','actorCommandSingleSkill','MZvKx','CurrentTurn','numTargets','changeAtbChargeTime','_interpreter','refresh','TP_Rate','PRsmh','updateBattlebackBitmap2','isCustomBattleScope','GWbIz','Wnhmk','TUkNS','invokeAction','isAutoBattleCommandAdded','isForOpponent','FlinchDistanceX','motionType','displayTpDamage','resetResultSwitches','battleSpriteSkew','Window_BattleLog_displayMpDamage','luXjC','Window_BattleLog_pushBaseLine','finalizeScale','ActSeq_Mechanics_BoostPointsStoreData','expRate','Window_BattleLog_displayActionResults','CreateActionSequenceTargets','animationShouldMirror','setupBattleCoreData','attackAnimationId1','VAhar','2455474nxsvnN','prev\x20target','addDamageSprite','_commandNameWindow','FjHhe','Sprite_Battler_setBattler','clearForcedGameTroopSettingsBattleCore','weapons','center','Window_BattleLog_displayFailure','FpDNS','mwwDo','ChargeRate','filter','ParseAllNotetags','_skillWindow','type','getCommonEventIdWithName','transform','AGI','includes','battleCoreTpbMainPhase','DRVYE','_actor','VisuMZ_4_BreakShields','IaigQ','_jumpWholeDuration','isTurnBased','_currentAngle','drawTextEx','VisuMZ_2_BattleSystemBTB','uizRn','uwMFy','iconWidth','GzUny','extraPositionY','Debuffs','isStatusAffected','VisuMZ_2_BattleSystemETB','_actionInputIndex','sMWWm','jMOcG','_angleDuration','mKuGf','EytUH','isBattleMember','SvBattlerMass-%1-%2','allBattleMembers','ActSeq_Zoom_WaitForZoom','max','PopupPosition','StatusWindowAttachmentFrontOffsetY','skills','Huvgc','SlotID','Sprite_Enemy_updateBossCollapse','windowskin','placeGauge','_growY','ActSeq_Camera_Offset','addGuardCommand','cyRJk','DoWOe','commandAutoBattle','_enemies','RCwpd','ZOKTX','noSimilarSTypes','useDigitGrouping','kKIPV','dying','AUwBs','opponentsUnit','OffsetAdjust','switchToWeaponType','itemTextAlign','ActSeq_Weapon_ClearActiveWeapon','missle','PYrdh','vFHSm','Class-%1-%2','isSelected','_visualHpGauge_JustDied','Game_BattlerBase_eraseState','recoverAll','createAttachedSprites','addOptionsCommand','_lineHeight','loadBattleback1','ActSeq_Impact_MotionBlurScreen','isGuardWaiting','playEnemyAttack','textWidth','applyGlobalCommonEventNotetags','battleSpin','xumvR','_motionSpeed','NyZlO','concat','Sprite_Enemy_createStateIconSprite','Item-%1-%2','ActSeq_Mechanics_VariablePopup','GroupDigits','CheckMapBattleEventValid','VisuMZ_2_BattleSystemCTB','Scene_Battle_createActorCommandWindow','process_VisuMZ_BattleCore_Failsafes','SUHvQ','performMoveToPoint','Jjqkc','rexQQ','onSkewEnd','isGrowing','split','PkiFp','DamageRate','targetActionSet','isAttack','PreStartBattleJS','growBattler','statusTextAutoBattleStyle','juCJe','adjustPosition','Buffs','_autoBattleWindow','collapse','createCancelButton','registerDefeatedEnemy','inputting','applyBattleCoreJS','isMeleeMultiTargetAction','AllowCollapse','scgZI','_borderPortraitDuration','DamageDisplay','partyCommandWindowRect','agNbD','Window_SkillList_maxCols','mpHealingFmt','waitCount','QAHHx','windowPadding','egxqj','TInXA','itemEffectAddAttackState','HomePosJS','_battleLayoutStyle','zoomDuration','processForcedAction','performActionStart','Angle','JS\x20ESCAPE\x20FAILURE','gexPs','activate','NtCJa','jbdqe','ActSeq_Mechanics_RemoveBuffDebuff','AtRZW','adjustPosition_1for1','command283','PostStartTurnJS','prepareBorderActor','VkNFi','vwEUp','glitch','gCmUR','VisuMZ_2_BattleSystemATB','alive\x20battlers\x20not\x20target','ActSeq_Mechanics_CtbOrder','findTargetSprite','YCOdJ','Window_PartyCommand_initialize','BcCLt','updateVisibility','isGuard','ForceExploiter','okButtonText','skillWindowRect','forceSelect','ActSeq_Skew_WaitForSkew','StyleName','ActSeq_BattleLog_Clear','Linear','DisplayAction','snapForBackground','kNGcX','chant','applyDamageCaps','yRgCn','onTurnEnd','stateMotionIndex','addLoadListener','ceil','isItemCommandEnabled','drawSingleSkillCost','ActSeq_Motion_RefreshMotion','_animation','setupRgbSplitImpactFilter','LPJGH','110lWunCA','NameAlwaysHidden','PartyCmd','process_VisuMZ_BattleCore_PreBattleCommonEvent','_tpbNeedsPartyCommand','isAlive','NBMPT','ARRAYJSON','Scene_Map_launchBattle','toLowerCase','nCcjp','_shadowScaleX','startTpbTurn','attackMotions','ShowCounter','HelpOptions','_baseY','hDiQF','tpbActorSwitchConditionsMet','YCyZM','VisuMZ_3_ActSeqImpact','BindCommonEventKeysForGroup','battleEnd','iIreI','iconHeight','updateAttachedSprites','drawSkillCost','extraPositionX','AsNBK','message1','LUK','collapseType','TMXUC','Window_BattleStatus_drawItemImage','XzHkr','AttachStateOffsetX','playReflection','getLastPluginCommandInterpreter','removeStatesAuto','battleUIOffsetX','createPartyCommandWindowBattleCore','setActiveWeaponSet','damageFlat','PostStartBattleJS','rowSpacing','%1Apply%2JS','dczqe','jugiv','loadSvActor','value','random','DamageType%1','STRUCT','svShadow','Sprite_Enemy_setBattler','_endBattle','dead\x20battlers','PostApplyAsUserJS','ShowWeapon','_attackAnimationId','Window_BattleLog_popupDamage','softDamageCapRate','_effectType','Mute','Game_Actor_setup','_shake','jBRHJ','createActorCommandWindow','isAutoBattleCommandEnabled','ArPenRate','drawItemStyleIcon','KMdQo','DEF','process_VisuMZ_BattleCore_CommonEventKeys','iTYax','nVydh','freezeMotion','maxItems','length','skewDuration','loadSvEnemy','setHelpWindow','AutoBattleCancel','hasBeenDefeatedBefore','loadPicture','softDamageCap','IqRtu','updateBattlerContainer','performSubstitute','performCastAnimation','performRecovery','HP_Flat','ConfigManager_makeData','randomTargets','mzuon','JS\x20%1START\x20TURN','Parse_Notetags_TraitObjects','createEnemies','checkCacheKey','PreRegenerateJS','TpXTN','Window_BattleEnemy_show','ChangeOrderBy','ActSeq_Motion_PerformAction','Rate','NameAlwaysSelectOnly','jtJpG','CoreEngine','expTotal','QhToZ','BojcW','ActSeq_Animation_AttackAnimation2','getItemDamageAmountTextBattleCore','DamageStyles','extraHeight','1969alcjbe','qxDYz','displayCritical','Ecemj','applySoftDamageCap','slice','OffsetY','_enemyIDs','ConvertActionSequenceTarget','mainSpriteHeight','gDPCg','setActiveWeaponSlot','makeTargetSprites','mainSpriteScaleY','Spriteset_Battle_update','WaitForFloat','traitObjects','removeAnimation','canUse','startActorSelection','Parse_Notetags_Targets','displayStartMessages','isInputting','_stateIconSprite','hardDamageCap','deathStateId','Mirror','statusWindowRectDefaultStyle','Weapon-%1-%2','Game_BattlerBase_refresh','version','svBattlerName','_active','CFoZF','_list','performWeaponAnimation','ActSeq_Movement_HomeReset','reserveCommonEvent','_tempEquipCheck','scale','contents','attackAnimationId2','fittingHeight','Settings','Damage','Game_Battler_onTurnEnd','Game_Interpreter_PluginCommand','motionIdle','gainBravePoints','isIncludedInEnemyWindow','SkillItemMiddleLayout','Qumxk','_opacityEasing','MessageWait','CmdIconOptions','_tempActor','PwWHU','yckQt','magicSkills','WaitForSkew','KGUMx','hitFlat','JXtYW','OTjQF','isAlwaysHidden','Window_ActorCommand_setup','onSelectAction','JJoiL','_executedValue','jInEO','waitForEffect','inputtingAction','PopupDuration','ueGOH','dead','YjGaI','_floatHeight','ActSeq_ChangeAngle','_windowLayer','2227092TtHpaw','tpbCommandFight','mpDamage','pages','process_VisuMZ_BattleCore_BaseTroops','updateShadowPosition','addedStateObjects','exit','COXZr','BattleDefeatJS','actionEffect','loop','blt','parameters','fXgDh','hpDamage','dXSNm','startJump','setSTBExploited','top','Game_Battler_clearMotion','JkSxi','list','Window_BattleLog_displayCurrentState','sideview_ui','CounterPlayback','_updateCursorArea','WaitForCamera','isSpinning','_opacityWholeDuration','changePaintOpacity','ShowHpDmg','ActSeq_Element_Clear','buffAdd','ActSeq_Projectile_Animation','onDisabledPartyCommandSelection','PreStartActionJS','displayMiss','addSingleSkillCommands','CalcEscapeRatioJS','actorCommandWindowRect','ActSeq_Animation_AttackAnimation','setSkill','VaQEF','Direction','QtlKE','pYqXr','Game_Battler_startTpbTurn','createTargetsJS','faceWidth','DaSrH','isForOpponentBattleCore','padding','Game_Action_executeDamage','ActSeq_Horror_TVCreate','_totalValue','updateScale','updateRefresh','isDeathStateAffected','bossCollapse','updateBattlebackBitmap1','StepDistanceX','isShownOnBattlePortrait','canAttackBattleCore','isRightInputMode','commandNameWindowDrawBackground','NewPopupBottom','processBorderActor','partyCommandWindowRectDefaultStyle','GCboO','Game_BattlerBase_canAttack','ssTSY','addNewState','SvMotionIdleSolo-%1-%2','makeTargets','show','cancelActorInput','children','%1Damage%2JS','commandEscape','sgeQi','StartName','weatherType','UpdbU','qXFNx','autoMeleeSingleTargetActionSet','destroy','_commonEventIDs','Window_BattleLog_performActionEnd','setupDamagePopup','addDebuff','_jumpDuration','gkVHM','_enemy','Game_Interpreter_command283','mjTco','ActSeq_Mechanics_PtbConvert','MTbyi','compareEnemySprite','setupHpGaugeSprite','StepDistanceY','gaugeX','ActSeq_Mechanics_Multipliers','updatePositionBattleCore','alive\x20enemies\x20not\x20target','eNZfP','canMove','AmNff','Scene_Battle_onEnemyOk','remove','_battleCoreBattleStartEvent','Enemy-%1-%2','startSkew','ShowMpDmg','HalfActions','jouDh','wtypeId','_actorSprites','attackSkillId','_animationSprites','RsvkP','Sprite_Weapon_loadBitmap','UHyOf','wYVrY','wIusJ','Window_BattleStatus_initialize','maxLines','battleGrow','kIGkw','SwitchMissEvade','lnBJc','ActionSkillMsg1','xlRRn','CmdIconEscape','Game_Actor_makeActionList','_jumpHeight','battleMove','ONZPt','LyrIr','isCancelled','fEUgI','whrWh','spell','KyRVM','xrvAZ','ConvertCount','SkewX','updateCommandNameWindow','performDamage','ActSeq_Impact_ShockwavePoint','Game_Battler_regenerateAll','compatibilityVisible','wGewp','StatusWindowAttachmentFront','moveBattlerToPoint','Game_BattlerBase_initMembers','critical','getChildIndex','createDamageContainer','setBattleAngle','current\x20target','aliveMembers','Sprite_Actor_setBattler','kAPxa','PreEndBattleJS','drawActorFace','isDTB','battleMembers','kmtAl','updateBattlebackBitmap','skillItemWindowRectMiddle','currentExt','Game_BattlerBase_canGuard','Mechanics','AutoBattleBgType','DvCeh','ActSeq_Movement_WaitForOpacity','SceneManager_isSceneChanging','command3011','Text','CriticalHitMultiplier','CriticalHitFlat','Window_BattleLog_performActionStart','command301_PreBattleEvent','placeStateIcon','Iirnj','QjGBi','VRwhk','isAtbChargingState','Scene_Map_initializeAfter','AttackAnimation','FaceDirection','Window_ItemList_maxCols','_lastEnemy','dimColor2','ActSeq_Mechanics_StbRemoveExcessActions','_indent','createJS','YdfPe','_statusWindow','RKgkL','callNextMethod','_requestRefresh','surprise','_baseX','FeaoI','clearBattlerMotionTrailData','swapEnemyIDs','LATtk','ActSeq_Mechanics_WaitForEffect','VisuMZ_3_SideviewBattleUI','XbeNq','riRFC','bCmTW','Spriteset_Battle_updateActors','default','battleback2Name','startTurn','SYnPp','BravePoints','isBattleSys','alterPriority','VpRIV','_helpWindow','LjdiS','animationBaseDelay','debuffAdd','anchorY','onBattleStartBattleCore','setupWeaponAnimation','isBattlerGrounded','MolDN','_handlers','applyImmortal','changeBattlerOpacity','Game_Action_needsSelection','launchBattle','eiIBP','shouldPopupDamage','onDatabaseLoaded','qFbOJ','move','isStateResist','ShowActorGauge','Sprite_Actor_initMembers','resizeWindowBorderStyle','XaHwS','Scene_Map_updateCallMenu','mpDamageFmt','setupMotionBlurImpactFilter','alive\x20actors\x20not\x20user','%1StartActionJS','Scene_Battle_commandFight','_battlerContainer','performTpbActiveCheckSwitch','yvtJp','ShowSubstitute','setHome','ShowRemovedState','isForFriendBattleCore','sEnyW','zcvEO','updateForceAction','setBattlerBattleCore','Sprite_Battler_damageOffsetX','ShowPortraits','redraw','Game_Battler_performEvasion','swing','adjustPosition_ScaleDown','partyCommandWindowRectXPStyle','_svBattlerData','_emptyBitmap','isEnemy','Scene_Battle_skillWindowRect','Window_BattleLog_performSubstitute','callOptions','call','iWACz','JSON','VNQOC','helpAreaBottom','TpbGaugeOffsetY','skill','isVisualHpGaugeDisplayed','battleProjectiles','onEnemyCancel','Sprite_Actor_createStateSprite','startMotion','ActSeq_Horror_GlitchRemove','jtCgv','gNBnv','EasingType','setBattleSkew','tReeI','buffRemove','SkillsStatesCore','updateEventMain','Game_Actor_equips','turn','addAutoBattleCommands','_waitMode','isSkillItemWindowsMiddle','Scene_Battle_startPartyCommandSelection','isActor','requestMotionRefresh','#%1','moveBattlerDistance','PopupOffsetX','Game_BattlerBase_addNewState','processDefeat','ZGHzl','setupChild','createDamageSprite','floor','HEaQW','VisuMZ_2_PartySystem','VisuMZ_0_CoreEngine','wwtSm','createActorCommandWindowBattleCore','head','setVisibleUI','ActSeq_Motion_WaitMotionFrame','NTiQx','ZKivo','getBattlePortraitOffsetY','_offsetY','qDjpk','ilVXP','setBackgroundType','ActSeq_Mechanics_DeathBreak','bxnza','battleJump','_createClientArea','clearActiveWeaponSet','worldTransform','ibVqg','svBattlerAnchorY','parseForcedGameTroopSettingsBattleCore','TimeScale','Radius','processRandomizedData','BhzEZ','XGeqD','_enemyNameContainer','pushBaseLine','battleOpacity','ReflectPlayback','ActSeq_Movement_MoveBy','Game_Action_apply','mLbUj','innerWidth','setupFont','lukEffectRate','tgIzn','ARRAYFUNC','_updateFilterArea','frameCount','BattleManager_processDefeat','BattleManager_updatePhase','updateJump','isOnCurrentMap','startFloat','itemHit','replace','_mainSprite','getMenuImage','EscapeSuccessJS','_homeY','isFrameVisible','ApplyImmortal','enemyId','Fvlcj','DMvQN','commandStyle','QdCIB','AsUser','_frontAttachmentSprite','displayReflectionPlayBack','setWaitMode','_effectDuration','ShowAddedState','BattleManager_endBattle','CmdTextAutoBattle','xKKLD','Sprite_Battler_update','isHiddenSkill','createUIContainer','LFfgq','isDead','Reveal','Actions','isAnyoneSpinning','logWindowRect','HelpSkillType','updateMotionCount','brOoH','_growWholeDuration','_pattern','skillTypes','MP_Flat','MpGaugeOffsetY','canAttack','updateBattleProcess','CgVgP','TpbActiveChangeEnabled','gainHp','alive\x20friends\x20not\x20user','aJJHH','-%1','HjtcO','NameOffsetY','BattleCmdList','_regionBattleback1','Game_Map_battleback2Name','_createDamageContainer','Window_BattleLog_displayTpDamage','ZNGbC','CommandAddOptions','Game_Battler_performActionStart','PreApplyAsTargetJS','changeCtbChargeTime','getDefeatedEnemies','mLerS','_back1Sprite','ActSeq_BattleLog_Refresh','clearBattleRefreshRequest','ActSeq_Movement_Spin','LdzRO','StatusWindowAttachmentFrontOffsetX','HelpEscape','magicReflection','CastAnimation','isSpriteVisible','string','displayType','_enemyWindow','XPActorCommandLines','bitmapHeight','updateStatusWindowPosition','Targets','isConfused','_growDuration','Izqci','text','_cancelButton','LvKHX','_battlerHue','isNonSubmenuCancel','retreat','forceAction','effects','_actionBattlers','Override','sort','canEscape','_item','custom','action','MRHUI','displayAction','freezeFrame','HLziL','setupShockwaveImpactFilter','FUNC','EnableDamageCap','ActSeq_Animation_ShowAnimation','applyGlobal','makeBattleCommand','Scene_Options_maxCommands','makeTargetSelectionMoreVisible','_appeared','kwfmY','cameraDuration','ActSeq_Target_NextTarget','SkewY','AddHpGaugeOption','gradientFillRect','result','cLOYr','drawBackgroundRect','MpGaugeOffsetX','createDistortionSprite','StyleOFF','note','loadSystem','_surprise','Sprite_Battler_isMoving','getAttackWeaponAnimationId','_animationContainer','drawText','updateEffectContainers','CommandWidth','CmdIconAutoBattle','left','hue','_motion','RYCvo','_borderPortraitTargetX','isChangingOpacity','ActSeq_Movement_FacePoint','createHelpWindow','DVFyE','TextColor','repositionCancelButtonBorderStyle','fhaxU','timeScale','SpDgq','ThewX','_flipScaleX','Game_Troop_expTotal','battleCommandName','animationId','YHzsX','optDisplayTp','_currentActor','+%1','Game_Enemy_setup','Frame','applyData','ParseActorNotetags','updateInterpreter','isATB','Nvjyf','wbHkQ','ActSeq_Set_TargetActionSet','_damages','QxzvU','isAnimationPlaying','TehFT','maxCols','applyEasing','isSkill','update','performMoveToTargets','exFKQ','goYhp','updatePhase','PostApplyJS','BattleManager_selectNextCommand','itemCri','Scene_Battle_start','HpGaugeOffsetX','getTraitSetKeys','actorCommandCancelTPB','iterateBattler','encounterList','turnCount','395817aCEDBP','slices','actions','charged','visualHpGauge','UMJDB','onBattleStart','getEnemyIdWithName','drawItemStyleIconText','_distortionSprite','addBuff','ActSeq_BattleLog_PopBaseLine','itemEffectAddNormalState','fnordRemovedStates','BattleManager_startInput','drawItemImagePortraitStyle','793404NtytUL','ZPfJA','_motionCount','ShowCritical','CriticalColor','deadMembers','_waitCount','AnchorX','WaitForMovement','drawGauge','cameraClamp','Duration','updateEffectsContainer','isBreakStunned','missed','bitmap','removeHorrorEffect','_eventId','performAction','bOLoA','COMBATLOG','%1\x20is\x20missing\x20a\x20required\x20plugin.\x0aPlease\x20install\x20%2\x20into\x20the\x20Plugin\x20Manager.','weaponImageId','startGrow','escape','UFLst','MOTIONS','vzadN','sJrXb','_branch','ShowRemovedBuff','ReflectAnimation','drawItemImageListStyle','ZHcsH','StatusWindowAttachmentBackOffsetY','uqxLA','applyHardDamageCap','addState','unshift','svAnchorX','CmdTextAlign','targetObjects','Window_BattleLog_refresh','displayReflection','Sprite_SvEnemy','PostStartActionJS','makeSuccess','LNmEF','RWsIX','onEncounterBattleCore','Sprite_Actor_updateFrame','_angleWholeDuration','xnNxi','clearBattleCoreData','onEnemyOk','WgNPy','WduzE','svAnchorY','Window_BattleLog_clear','PrioritySortActors','ILdSS','battleSkew','addAutoBattleCommand','battleSys','-%1\x20MP','hUtbA','_motionType','MIN_SAFE_INTEGER','updateStyleOpacity','stepForward','SideviewSelect','battleFloat','alive\x20friends','WaitForOpacity','Variable','friendsUnit','Window_Options_addGeneralOptions','Game_BattlerBase_isStateResist','ActSeq_Mechanics_TextPopup','resizeWindowXPStyle','CreateCommonEventKeys','_forcedBattlers','ActionItemMsg','PreApply%1JS','xqDuM','Window_BattleLog_displayMiss','_ptbActionCost','PreDamageAsTargetJS','_shadowScaleY','grssd','selectNextCommand','addImmortal','blWkr','_flashColor','ZKZcA','Sprite_Battler_setHome','Scene_Battle_windowAreaHeight','ActSeq_Mechanics_ArmorPenetration','attack','ParseItemNotetags','criticalDmgFlat','NJAID','_svBattlerSprite','height','battlerShadowScaleX','_tpbState','Window_BattleLog_displayCritical','helpWindowRectBorderStyle','targetDistortionSpritePosition','VisuMZ_1_MainMenuCore','Game_Action_isForFriend','dead\x20enemies','PRE-','IBolz','command236','damageStyle','updateHpGaugePosition','ShowAddedDebuff','fight','smooth','MwKQy','ActSeq_Mechanics_AddBuffDebuff','BattleManager_isTpbMainPhase','ARRAYNUM','ActSeq_Movement_MoveToTarget','isImmortal','performCollapse','JS\x20%1END\x20ACTION','isBTB','isSkipPartyCommandWindow','ActionEffect','_enemyID','getSkillIdWithName','AnchorY','setupBattleCore','clamp','hitRate','BattleManager_startAction','usePremadeActionSequence','waitForAnimation','battleCommandIcon','WhXup','initBattlePortrait','isAnyoneSkewing','Pre','helpAreaHeight','PyvCP','battleCorePreBattleCommonEvent','BindCommonEventKeysForObj','hasSkill','GngJE','battleback1Name','Scale','setValue','displayCurrentState','VisuMZ_3_BoostAction','weatherPower','ofARA','textColor','tLYIF','process_VisuMZ_BattleCore_CreateRegExp','Index','_logWindow','battleDisplayText','createString','command119','BattleEndEvent','Window_BattleLog_performAction','endAction','ycWOA','clearWeaponAnimation','removeAnimationFromContainer','isTickBased','currentClass','ActSeq_Mechanics_CustomDmgFormula','Parse_Notetags_Action','abnormal','makeActionListAutoAttack','StateIconOffsetX','WIhxD','nnLHx','setFrame','ActionSkillMsg2','isNextSceneBattleTransitionable','_weather','ChantStyle','isBorderStylePortraitShown','_commonEventQueue','_battleCoreAddedElements','DigitGroupingDamageSprites','substitute','EGznD','loadWindowskin','alterActionCostPTB','flashDuration','_createCursorSprite','Scene_Battle_startActorSelection','_dimmerSprite','filters','Sprite_Battler_initMembers','iconIndex','cPmlD','hpAffected','BattleManager_inputtingAction','ActSeq_Skew_Reset','finishActorInput','startAction','checkTpbInputClose','Game_Temp_requestAnimation','ActSeq_Mechanics_BreakShieldChange','battleZoom','_checkOn','autoBattleAtStart','autoSelectLastSelected','ActSeq_Element_AddElements','Skills','_effectsContainer','ARRAYEVAL','FocusY','CuxGW','addCommand','tPLeN','startEnemySelection','isForFriend','AllowRandomSpeed','mZwjr','TpbGaugeOffsetX','min','preparePartyRefresh','addedBuffs','animationWait','isPhysical','Armor-%1-%2','429971qdBtkq','_armorPenetration','Window_BattleLog_performRecovery','_skillIDs','hxeRF','commandSymbol','Game_Action_evalDamageFormula','startMove','alignBattleCoreDamageSprite','Scene_Battle_updateStatusWindowPosition','_forcedBattleLayout','pJlPj','OmESD','Gffkb','TPB','isPreviousSceneBattleTransitionable','ArRedRate','isNextScene','BzKYD','alive\x20enemies\x20not\x20user','onJumpEnd','updateBossCollapse','aBbLl','updatePosition','PostDamageAsTargetJS','ActSeq_Impact_MotionTrailCreate','actionBattleCoreJS','currentSymbol','QUvXz','refreshActorPortrait','create','forceWeaponAnimation','BattleManager_processVictory','Game_Party_removeActor','displayChangedStates','Interrupt','WtypeId','createActors','extraPositionScaledY','active','drawItemImageXPStyle','Sprite_Battler_damageOffsetY','Game_Battler_clearDamagePopup','_angleRevertOnFinish','yhLzJ','ResetOffset','createCommandNameWindow','Game_Battler_performDamage','BattleManager_onEscapeFailure','trueRandomTarget','NPUYH','itemWindowRect','cVIKU','nextActiveWeaponSlot','oEsDC','VQAeu','IconStypeMagic','indexOf','createActionSequenceProjectile','kEcdc','cancelTargetSelectionVisibility','StyleON','AttachStateOffsetY','clearHorrorEffects','calcWindowHeight','apply','damageContainer','ActSeq_Angle_Reset','PostEndTurnJS','ActSeq_BattleLog_PushBaseLine','VisuMZ_4_CombatLog','commandStyleCheck','isPreviousScene','EpyzK','canGuard','placeTimeGauge','performActionEnd','Scene_Battle_partyCommandWindowRect','clearRect','_updateClientArea','ActSeq_BattleLog_AddText','refreshMotion','startBattle','jumpBattler','VarianceFormulaJS','_angleEasing','hdluT','getBattlePortrait','VariableID','ScaleUp','yuNIM','actionSplicePoint','OtLYk','clearFreezeMotion','_weaponImageId','removeImmortal','ActSeq_Set_WholeActionSet','FollowTurn','adjustWeaponSpriteOffset','ZLJGn','opacity','ActSeq_DB_DragonbonesTimeScale','ForceDeath','_immortal','JS\x20%1END\x20BATTLE','_growEasing','description','stateRate','CastMagical','executeDamage','isDying','addCustomCommands','charging','waitForNewLine','getAttackMotion','Victory','hasSvBattler','setLastPluginCommandInterpreter','SKgSZ','BattleLayout','ForceExploited','lineHeight','Shadow','performAttackSlot','boxWidth','TpGaugeOffsetX','iconText','MotionFrameWait','partyCommandWindowRectBorderStyle','JtGSj','JdonS','GNrKE','isChanting','setBattleCameraOffset','ActSeq_Mechanics_CtbSpeed','border','_enemySprites','damageOffsetY','Sprite_Enemy_updateStateSprite','getFullActionsPTB','undecided','CXMJK','some','QUNfe','ActSeq_Movement_WaitForScale','mhp','criticalHitFlat','fCedO','PostRegenerateJS','equips','Sprite_Enemy_update','_freezeMotionData','iPPGA','sleep','ActSeq_Set_SetupAction','singleSkill','match','addSkillCommands','pxVLz','processActorCommandCancelTPB','_targetSkewY','ActSeq_Movement_Scale','AS\x20USER','ScaleX','icon','removeActor','setHandler','setBattleCameraTargets','NVFdC','requestFauxAnimation','WaitForAngle','setupZoomBlurImpactFilter','EmergeText','inBattle','rbaaN','Pbdzu','sILwv','isOptionsCommandAdded','addTextToCombatLog','YTwZB','jTQCT','displayEvasion','isActing','HfZQE','Name','EscapeSuccess','setBattleZoom','updateCancel','CriticalHitRateJS','ActSeq_Movement_WaitForSkew','commandNameWindowDrawText','ActSeq_Movement_Float','setText','isAnyoneFloating','updateStateSprite','actorCommandAutoBattle','isTpbMainPhase','EyQwb','updateBorderSprite','sTqZK','NameOffsetX','autoBattleStyle','bind','_back2Sprite','preemptive','process_VisuMZ_BattleCore_DamageStyles','displayItemMessage','FMojn','ActSeq_Weapon_SetActiveWeapon','isOTB','isActionSelectionValid','loadBattleback2','ohehZ','isBattleCoreTargetScope','setSvBattlerSprite','_floatEasing','evalDamageFormulaBattleCore','SvBattlerSolo-%1-%2','log','aYCdN','guard','eWUvH','setupBattlebackBattleCore','wJEPr','playCancel','okTargetSelectionVisibility','removeState','PopupShiftY','yXKbe','applyTargetFilters','addActor','VTOZL','DualWield','CmdStyle','setupTextPopup','svBattlerData','index','performActionEndMembers','isAutoBattle','ScaleY','SmoothImage','ActSeq_Mechanics_AnalyzeWeakness','showHelpWindow','BattleManager_endAction','makeCommandList','focus','XpChZ','Game_Action_itemHit','battlerShadowScaleY','initElementStatusCore','BxVaq','lNyls','Point','Sprite_Battleback_adjustPosition','isDamagePopupRequested','KlpQT','_opacityDuration','processVictory','moveToStartPositionBattleCore','ActSeq_Movement_WaitForJump','createStateIconSprite','drawItemStatusXPStyle','HitFlat','FlashDuration','toUpperCase','counterAttack','boxHeight','motionSpeed','emerge','DWEwf','traitSet','gqqeE','idEhe','WaitCount','createChildSprite','zQRXT','isMVAnimation','CriticalDmgFlat','performEvasion','JS\x20%1APPLY\x20%2','VisuMZ_3_ActSeqProjectiles','isAnyoneMoving','\x5cI[%1]%2','drawEnemyName','State-%1-%2','_forceAction','Ntsiy','_hpGaugeSprite','qGcoO','Game_Party_addActor','ZDzPl','QrRlL','finishActionSet','nXpXa','getInputButtonString','LVPah','TextAlign','makeActionOrders','dead\x20actors','Game_Interpreter_command301','FORJc','Game_Action_isForRandom','abs','createHelpWindowBattleCore','messageSpeed','gXtRZ','IQkqD','Game_Action_isForOpponent','updateHelp','VisuMZ_1_SkillsStatesCore','process_VisuMZ_BattleCore_PluginParams','VisuMZ_2_BattleSystemOTB','refreshDimmerBitmap','BattleManager_startBattle','NextTurn','uMfno','AutoNotetag','BattleVictoryJS','TOhmJ','StatusWindowSelectableBackHide','Game_Battler_onBattleStart','walk','bHyRh','battlerSprites','isPlaytest','displayFailure','NDfzW','spinBattler','_stypeIDs','updateShadowBattleCore','ALL\x20SKILLS','yqMGe','skewBattler','getNextSubject','bitmapWidth','isSkewing','VisuMZ_2_WeaponSwapSystem','xEYzg','XZLEY','right','Game_Battler_performMiss','tone','isSideButtonLayout','_preBattleCommonEvent','Amp','updateWaitMode','updateCustomActionSequence','dead\x20friends','PbORr','MotionAni','ActSeq_Mechanics_Immortal','_targetGrowY','Scene_Battle_logWindowRect','speed','WXWFE','setBattlePortrait','zblYA','onEscapeSuccess','VisuMZ_2_BattleSystemSTB','ActionCenteredName','MAT','FaceAway','createInnerPortrait','MANUAL','Game_System_initialize','CopyCombatLog','ZUEGm','ijpCP','currentAction','createLowerLayer','createBattleUIOffsetY','CheckSkillCommandShowSwitches','Strength','ATTACK','_tpbSceneChangeCacheActor','weaponTypes','WaitForAnimation','chantStyle','_iconIndex','Window_BattleLog_popBaseLine','setBattler','endBattle','Game_Action_itemEffectAddNormalState','initBattleCore','performMiss','removeDamageSprite','Evyml','HitRate','alterCost','delay','putActiveBattlerOnTop','ActSeq_Animation_ActionAnimation','WaitForEffect','ShowCurrentState','createSeparateDamagePopups','_padding','needsSelection','NameFontSize','onActorCancel','setAttack','onAngleEnd','commandFight','qKnmr','createKeyJS','ActionEnd','BtdYT','ActorCmd','PjFpW','XPActorDefaultHeight','cAjqY','battleStatusWindowAnimationContainer','getWtypeIdWithName','getBattlePortraitFilename','isBattleTest','ARRAYSTRUCT','DTB','BEHjP','ScaleToFit','process_VisuMZ_BattleCore_jsFunctions','createPartyCommandWindow','removeChild','animation','onEscapeFailure','sortEnemies','AutoBattleRect','processAnimationRequests','kboAd','isForRandom','itemRect','ActSeq_Mechanics_ActionEffect','isEffecting','centerFrontViewSprite','bICoK','PostDamageAsUserJS','createHpGaugeSprite','142012QNLxpU','updateShadowVisibility','_regionBattleback2','Window_BattleLog_performReflection','QseTj','performMagicEvasion','SkipPartyCmd','updateLink','PreDamage%1JS','WaitForSpin','resize','qmsox','startOpacity','Game_Battler_forceAction','_activeWeaponSlot','VzGzi','all\x20targets','BackColor','float','Sprite_Battler_updateMain','callOkHandler','updateFlip','Game_Action_clear','forceEscapeSprite','CNuTs','jOXpi','hjoOX','alive\x20friends\x20not\x20target','HelpItem','_multipliers','MqNkn','ZMKZN','flashColor','SkillItemStandardCols','getDualWieldTimes'];_0x12e1=function(){return _0x2b96b4;};return _0x12e1();}var label=_0xfd5ed1(0x1e9),tier=tier||0x0,dependencies=[],pluginData=$plugins[_0xfd5ed1(0x4af)](function(_0x36ffa8){const _0x409f55=_0xfd5ed1;return _0x36ffa8[_0x409f55(0x39d)]&&_0x36ffa8[_0x409f55(0x9b2)][_0x409f55(0x4b6)]('['+label+']');})[0x0];VisuMZ[label][_0xfd5ed1(0x607)]=VisuMZ[label][_0xfd5ed1(0x607)]||{},VisuMZ['ConvertParams']=function(_0x473900,_0x76dceb){const _0x4ee911=_0xfd5ed1;for(const _0xedcd0e in _0x76dceb){if(_0x4ee911(0x7b7)===_0x4ee911(0x7b7)){if(_0xedcd0e[_0x4ee911(0x9e4)](/(.*):(.*)/i)){if(_0x4ee911(0x2e6)!=='ZgMly')this[_0x4ee911(0x2db)](_0x4ee911(0xb57)),_0x56bb36[_0x4ee911(0x1e9)][_0x4ee911(0x65a)]['call'](this),this[_0x4ee911(0x2db)](_0x4ee911(0x542));else{const _0x1fe529=String(RegExp['$1']),_0x24b0b0=String(RegExp['$2'])[_0x4ee911(0xa50)]()[_0x4ee911(0x300)]();let _0x341926,_0x2c764e,_0x4ab896;switch(_0x24b0b0){case'NUM':_0x341926=_0x76dceb[_0xedcd0e]!==''?Number(_0x76dceb[_0xedcd0e]):0x0;break;case _0x4ee911(0x8da):_0x2c764e=_0x76dceb[_0xedcd0e]!==''?JSON[_0x4ee911(0x243)](_0x76dceb[_0xedcd0e]):[],_0x341926=_0x2c764e[_0x4ee911(0x3ee)](_0x371290=>Number(_0x371290));break;case'EVAL':_0x341926=_0x76dceb[_0xedcd0e]!==''?eval(_0x76dceb[_0xedcd0e]):null;break;case _0x4ee911(0x938):_0x2c764e=_0x76dceb[_0xedcd0e]!==''?JSON[_0x4ee911(0x243)](_0x76dceb[_0xedcd0e]):[],_0x341926=_0x2c764e[_0x4ee911(0x3ee)](_0x39ee57=>eval(_0x39ee57));break;case _0x4ee911(0x742):_0x341926=_0x76dceb[_0xedcd0e]!==''?JSON[_0x4ee911(0x243)](_0x76dceb[_0xedcd0e]):'';break;case _0x4ee911(0x570):_0x2c764e=_0x76dceb[_0xedcd0e]!==''?JSON[_0x4ee911(0x243)](_0x76dceb[_0xedcd0e]):[],_0x341926=_0x2c764e[_0x4ee911(0x3ee)](_0x3ae39f=>JSON[_0x4ee911(0x243)](_0x3ae39f));break;case _0x4ee911(0x7fb):_0x341926=_0x76dceb[_0xedcd0e]!==''?new Function(JSON['parse'](_0x76dceb[_0xedcd0e])):new Function(_0x4ee911(0x31e));break;case _0x4ee911(0x78e):_0x2c764e=_0x76dceb[_0xedcd0e]!==''?JSON[_0x4ee911(0x243)](_0x76dceb[_0xedcd0e]):[],_0x341926=_0x2c764e[_0x4ee911(0x3ee)](_0x19d363=>new Function(JSON[_0x4ee911(0x243)](_0x19d363)));break;case'STR':_0x341926=_0x76dceb[_0xedcd0e]!==''?String(_0x76dceb[_0xedcd0e]):'';break;case'ARRAYSTR':_0x2c764e=_0x76dceb[_0xedcd0e]!==''?JSON[_0x4ee911(0x243)](_0x76dceb[_0xedcd0e]):[],_0x341926=_0x2c764e[_0x4ee911(0x3ee)](_0x5c7ffe=>String(_0x5c7ffe));break;case _0x4ee911(0x59d):_0x4ab896=_0x76dceb[_0xedcd0e]!==''?JSON[_0x4ee911(0x243)](_0x76dceb[_0xedcd0e]):{},_0x473900[_0x1fe529]={},VisuMZ[_0x4ee911(0x1c5)](_0x473900[_0x1fe529],_0x4ab896);continue;case _0x4ee911(0xae6):_0x2c764e=_0x76dceb[_0xedcd0e]!==''?JSON[_0x4ee911(0x243)](_0x76dceb[_0xedcd0e]):[],_0x341926=_0x2c764e['map'](_0x47b9a2=>VisuMZ['ConvertParams']({},JSON[_0x4ee911(0x243)](_0x47b9a2)));break;default:continue;}_0x473900[_0x1fe529]=_0x341926;}}}else _0x49dd13['prototype'][_0x4ee911(0x2f5)][_0x4ee911(0x740)](this);}return _0x473900;},(_0x4a9fd5=>{const _0xd2ad30=_0xfd5ed1,_0x41ea33=_0x4a9fd5[_0xd2ad30(0x452)];for(const _0x18881d of dependencies){if(!Imported[_0x18881d]){alert(_0xd2ad30(0x874)['format'](_0x41ea33,_0x18881d)),SceneManager[_0xd2ad30(0x632)]();break;}}const _0x54f7eb=_0x4a9fd5['description'];if(_0x54f7eb['match'](/\[Version[ ](.*?)\]/i)){if(_0xd2ad30(0x76e)!=='NTiQx'){const _0x41b389=_0x471dce['note'];if(_0x41b389[_0xd2ad30(0x9e4)](/<COMMAND REQUIRE LEARN>/i)){if(!this['_actor'][_0xd2ad30(0x29e)](_0x1aea79['id']))return![];}if(_0x41b389[_0xd2ad30(0x9e4)](/<COMMAND REQUIRE ACCESS>/i)){if(!this['_actor']['hasSkill'](_0x4946a5['id']))return![];}const _0x5be632=_0x491d32[_0xd2ad30(0x1e9)][_0xd2ad30(0xadb)](_0xb1bdde,_0xd2ad30(0x1c3));if(_0x2dceff[_0xd2ad30(0x1e9)]['JS'][_0x5be632]){if(!_0x20ef19[_0xd2ad30(0x1e9)]['JS'][_0x5be632][_0xd2ad30(0x740)](this,this[_0xd2ad30(0x4b9)],_0x5b589c))return![];}return _0x4c1f97[_0xd2ad30(0x1e9)][_0xd2ad30(0xabb)](_0x1645a3);}else{const _0x185b39=Number(RegExp['$1']);_0x185b39!==VisuMZ[label][_0xd2ad30(0x5fa)]&&(alert(_0xd2ad30(0x3d9)[_0xd2ad30(0x222)](_0x41ea33,_0x185b39)),SceneManager[_0xd2ad30(0x632)]());}}if(_0x54f7eb[_0xd2ad30(0x9e4)](/\[Tier[ ](\d+)\]/i)){const _0x49ff99=Number(RegExp['$1']);_0x49ff99<tier?(alert('%1\x20is\x20incorrectly\x20placed\x20on\x20the\x20plugin\x20list.\x0aIt\x20is\x20a\x20Tier\x20%2\x20plugin\x20placed\x20over\x20other\x20Tier\x20%3\x20plugins.\x0aPlease\x20reorder\x20the\x20plugin\x20list\x20from\x20smallest\x20to\x20largest\x20tier\x20numbers.'['format'](_0x41ea33,_0x49ff99,tier)),SceneManager[_0xd2ad30(0x632)]()):'ehroc'===_0xd2ad30(0x304)?_0x59a78d['isNextSceneBattleTransitionable']()?_0x66f972[_0xd2ad30(0x263)][_0xd2ad30(0x21d)][_0xd2ad30(0x740)](this):_0x46cf11[_0xd2ad30(0x1e9)][_0xd2ad30(0x29f)][_0xd2ad30(0x740)](this):tier=Math[_0xd2ad30(0x4d3)](_0x49ff99,tier);}VisuMZ[_0xd2ad30(0x1c5)](VisuMZ[label][_0xd2ad30(0x607)],_0x4a9fd5[_0xd2ad30(0x638)]);})(pluginData),VisuMZ[_0xfd5ed1(0x49d)]=function(_0x45ed03){const _0x40fbf3=_0xfd5ed1;let _0x5b49bc=[];for(const _0x589f59 of _0x45ed03){_0x5b49bc=_0x5b49bc['concat'](VisuMZ[_0x40fbf3(0x5e4)](_0x589f59));}return _0x5b49bc[_0x40fbf3(0x4af)](_0x581b09=>_0x581b09);},VisuMZ[_0xfd5ed1(0x5e4)]=function(_0x190fa8){const _0x45e788=_0xfd5ed1,_0x4e554=BattleManager['allBattleMembers']()[_0x45e788(0x4af)](_0x56cdc0=>_0x56cdc0&&_0x56cdc0['isAppeared']()),_0x1e5dc5=BattleManager[_0x45e788(0xb9a)],_0x203e8d=BattleManager[_0x45e788(0x235)],_0x550ba1=BattleManager[_0x45e788(0x377)]?BattleManager[_0x45e788(0x377)][_0x45e788(0x5e1)](0x0):_0x4e554;_0x190fa8=_0x190fa8['toLowerCase']()['trim']();if(_0x190fa8===_0x45e788(0xbd5))return[_0x1e5dc5];else{if(_0x190fa8===_0x45e788(0x6cb))return[_0x203e8d];else{if(_0x190fa8===_0x45e788(0x4a3)){if('MKiKE'===_0x45e788(0xa83))_0x508ebe[_0x45e788(0xbc8)](_0x45e788(0x779),_0x581857);else{if(_0x203e8d){if(_0x45e788(0x5df)!==_0x45e788(0xb14)){const _0x525da3=_0x550ba1[_0x45e788(0x981)](_0x203e8d);return _0x525da3>=0x0?[_0x550ba1[_0x525da3-0x1]||_0x203e8d]:[_0x203e8d];}else _0x1b1a78[_0x45e788(0x601)](_0xd918a7[_0x45e788(0x905)]);}}}else{if(_0x190fa8==='text\x20target'){if(_0x45e788(0x762)===_0x45e788(0x762)){if(_0x203e8d){const _0x19d1fe=_0x550ba1[_0x45e788(0x981)](_0x203e8d);return _0x19d1fe>=0x0?[_0x550ba1[_0x19d1fe+0x1]||_0x203e8d]:[_0x203e8d];}}else{if(this['_actions'][_0x45e788(0x9d6)](_0x20eda9=>_0x20eda9[_0x45e788(0x3c7)]()&&_0x20eda9[_0x45e788(0x446)]()))return!![];}}else{if(_0x190fa8===_0x45e788(0xb0b))return _0x550ba1;else{if(_0x190fa8===_0x45e788(0xa3d))return _0x45e788(0x9c9)===_0x45e788(0x9c9)?[_0x1e5dc5][_0x45e788(0x504)](_0x550ba1):'iconText';else{if(_0x190fa8===_0x45e788(0x343)){if(_0x45e788(0x9ff)!==_0x45e788(0x9ff))this['addAutoBattleCommand']();else return _0x4e554[_0x45e788(0x4af)](_0x4cdaaa=>_0x4cdaaa!==_0x1e5dc5&&!_0x550ba1[_0x45e788(0x4b6)](_0x4cdaaa)&&_0x4cdaaa[_0x45e788(0x475)]());}}}}}}}if(_0x1e5dc5){if(_0x190fa8===_0x45e788(0x8a7))return _0x1e5dc5[_0x45e788(0x8aa)]()[_0x45e788(0x6cc)]();else{if(_0x190fa8===_0x45e788(0x7c2))return'kiYeJ'!==_0x45e788(0xadd)?_0x1e5dc5[_0x45e788(0x8aa)]()[_0x45e788(0x6cc)]()['filter'](_0x20c8be=>_0x20c8be!==_0x1e5dc5):_0x3c51a7[_0x45e788(0x1e9)][_0x45e788(0x607)][_0x45e788(0x608)]['VarianceFormulaJS']['call'](this,_0x49ad44,_0x2650f7);else{if(_0x190fa8===_0x45e788(0xb16)){if(_0x45e788(0xa58)!==_0x45e788(0xa58)){if(!this[_0x45e788(0x7e4)]()&&_0x2eb49a[_0x45e788(0x373)])return!![];return _0x384bf9[_0x45e788(0x263)][_0x45e788(0xa36)][_0x45e788(0x740)](this);}else return _0x1e5dc5[_0x45e788(0x8aa)]()[_0x45e788(0x6cc)]()[_0x45e788(0x4af)](_0x35e59f=>_0x35e59f!==_0x203e8d);}else{if(_0x190fa8===_0x45e788(0xaa3))return _0x1e5dc5[_0x45e788(0x8aa)]()[_0x45e788(0x864)]();else{if(_0x190fa8['match'](/FRIEND INDEX (\d+)/i)){const _0x21f5a0=Number(RegExp['$1']);return[_0x1e5dc5[_0x45e788(0x8aa)]()[_0x45e788(0xb77)]()[_0x21f5a0]];}}}}}if(_0x190fa8===_0x45e788(0x35c))return _0x1e5dc5[_0x45e788(0x4ea)]()[_0x45e788(0x6cc)]();else{if(_0x190fa8==='alive\x20opponents\x20not\x20target')return _0x1e5dc5[_0x45e788(0x4ea)]()['aliveMembers']()[_0x45e788(0x4af)](_0x59510b=>_0x59510b!==_0x203e8d);else{if(_0x190fa8==='dead\x20opponents')return _0x1e5dc5[_0x45e788(0x4ea)]()[_0x45e788(0x864)]();else{if(_0x190fa8[_0x45e788(0x9e4)](/OPPONENT INDEX (\d+)/i)){const _0x2a5f7f=Number(RegExp['$1']);return[_0x1e5dc5[_0x45e788(0x4ea)]()[_0x45e788(0xb77)]()[_0x2a5f7f]];}}}}}if(_0x190fa8==='alive\x20actors')return $gameParty[_0x45e788(0x6cc)]();else{if(_0x190fa8===_0x45e788(0x725)){if('OfXRs'!==_0x45e788(0x72f))return $gameParty[_0x45e788(0x6cc)]()['filter'](_0x2fd229=>_0x2fd229!==_0x1e5dc5);else _0x4e8922['reserveCommonEvent'](_0x2688b9[_0x1e8ca]);}else{if(_0x190fa8===_0x45e788(0x3df))return $gameParty['aliveMembers']()[_0x45e788(0x4af)](_0x101c6e=>_0x101c6e!==_0x203e8d);else{if(_0x190fa8===_0x45e788(0xa72))return $gameParty[_0x45e788(0x864)]();else{if(_0x190fa8[_0x45e788(0x9e4)](/ACTOR INDEX (\d+)/i)){const _0x6f21f=Number(RegExp['$1']);return[$gameParty[_0x45e788(0xb77)]()[_0x6f21f]];}else{if(_0x190fa8[_0x45e788(0x9e4)](/ACTOR ID (\d+)/i)){if(_0x45e788(0x41f)===_0x45e788(0x233)){if(!_0x5d3405[_0x45e788(0xbb7)]())return null;if(!_0x58e4ca[_0x45e788(0x3c3)][_0x45e788(0xb41)])return null;return _0x58dc2f['_scene'][_0x45e788(0xb41)][_0x45e788(0x54b)](this);}else{const _0x29b180=Number(RegExp['$1']);return[$gameActors[_0x45e788(0x279)](_0x29b180)];}}}}}}}if(_0x190fa8===_0x45e788(0x273))return $gameTroop[_0x45e788(0x6cc)]();else{if(_0x190fa8===_0x45e788(0x95b))return $gameTroop[_0x45e788(0x6cc)]()[_0x45e788(0x4af)](_0xa1f6a8=>_0xa1f6a8!==_0x1e5dc5);else{if(_0x190fa8===_0x45e788(0x693)){if(_0x45e788(0x200)!==_0x45e788(0x200)){if(!this[_0x45e788(0x695)]())return;if(!this['_distortionSprite'])return;if(this[_0x45e788(0x317)]===_0x24933e&&this[_0x45e788(0xaa7)]===_0x42dc14)return;this[_0x45e788(0x317)]=_0xa5b6e3,this['_targetGrowY']=_0x5731b6,this[_0x45e788(0x7e5)]=_0x74c64e,this[_0x45e788(0x7b8)]=_0x48cda8,this[_0x45e788(0x9b1)]=_0xd77de8||_0x45e788(0x558),_0x4136bb<=0x0&&(this[_0x45e788(0x253)]=this[_0x45e788(0x317)],this[_0x45e788(0x4dc)]=this[_0x45e788(0xaa7)]);}else return $gameTroop[_0x45e788(0x6cc)]()[_0x45e788(0x4af)](_0x3a73b6=>_0x3a73b6!==_0x203e8d);}else{if(_0x190fa8===_0x45e788(0x8ce))return $gameTroop[_0x45e788(0x864)]();else{if(_0x190fa8[_0x45e788(0x9e4)](/ENEMY INDEX (\d+)/i)){const _0x1caef2=Number(RegExp['$1']);return[$gameTroop['members']()[_0x1caef2]];}else{if(_0x190fa8[_0x45e788(0x9e4)](/ENEMY ID (\d+)/i)){if('pEewN'===_0x45e788(0x730)){const _0x26b0ff=_0x2648de(_0x5002c3['$1'])[_0x45e788(0x513)](/[\r\n]+/)[_0x45e788(0x698)](''),_0x35810f=_0x5ac9a3[_0x45e788(0x780)](_0x26b0ff);_0x5cf9b6[_0x45e788(0x69f)]=_0x49cf7c[_0x45e788(0xae3)](_0x35810f);}else{const _0x972428=Number(RegExp['$1']);return $gameTroop[_0x45e788(0x6cc)]()[_0x45e788(0x4af)](_0x24d01f=>_0x24d01f[_0x45e788(0x79e)]()===_0x972428);}}}}}}}if(_0x190fa8===_0x45e788(0x1df))return _0x4e554[_0x45e788(0x4af)](_0x1bc810=>_0x1bc810['isAlive']());else{if(_0x190fa8===_0x45e788(0x3c2))return _0x4e554[_0x45e788(0x4af)](_0x529465=>_0x529465['isAlive']()&&_0x529465!==_0x1e5dc5);else{if(_0x190fa8===_0x45e788(0x549))return _0x4e554[_0x45e788(0x4af)](_0x162377=>_0x162377['isAlive']()&&_0x162377!==_0x203e8d);else{if(_0x190fa8===_0x45e788(0x5a1))return _0x4e554['filter'](_0x1a9ac8=>_0x1a9ac8[_0x45e788(0x7b0)]());}}}return[];},PluginManager['registerCommand'](pluginData['name'],_0xfd5ed1(0x9e2),_0x184200=>{const _0x13f6a5=_0xfd5ed1;if(!SceneManager[_0x13f6a5(0xbb7)]())return;VisuMZ[_0x13f6a5(0x1c5)](_0x184200,_0x184200);const _0x1d04c1=$gameTemp[_0x13f6a5(0x58e)](),_0x41af0c=BattleManager['_action'],_0x1c8aab=BattleManager[_0x13f6a5(0xb9a)],_0x205203=BattleManager[_0x13f6a5(0x377)]?BattleManager[_0x13f6a5(0x377)][_0x13f6a5(0x5e1)](0x0):[],_0x2d0872=BattleManager[_0x13f6a5(0x901)];if(!_0x1d04c1||!_0x41af0c||!_0x1c8aab)return;if(!_0x41af0c[_0x13f6a5(0x3c7)]())return;if(_0x184200[_0x13f6a5(0x559)])_0x2d0872[_0x13f6a5(0x7f7)](_0x1c8aab,_0x41af0c['item']());_0x184200['ApplyImmortal']&&_0x2d0872[_0x13f6a5(0xbc8)](_0x13f6a5(0x714),_0x1c8aab,_0x205203,!![]);if(_0x184200[_0x13f6a5(0xb81)])_0x2d0872[_0x13f6a5(0xbc8)](_0x13f6a5(0x537),_0x1c8aab,_0x41af0c);if(_0x184200[_0x13f6a5(0x867)])_0x2d0872['push']('waitForMovement');if(_0x184200[_0x13f6a5(0x7db)])_0x2d0872['push'](_0x13f6a5(0x5c2),_0x1c8aab,_0x41af0c);if(_0x184200[_0x13f6a5(0xac0)])_0x2d0872[_0x13f6a5(0xbc8)](_0x13f6a5(0x8ea));_0x1d04c1['setWaitMode'](_0x13f6a5(0xb63));}),PluginManager['registerCommand'](pluginData[_0xfd5ed1(0x452)],_0xfd5ed1(0x9a8),_0x1cb693=>{const _0x2ba37b=_0xfd5ed1;if(!SceneManager[_0x2ba37b(0xbb7)]())return;VisuMZ[_0x2ba37b(0x1c5)](_0x1cb693,_0x1cb693);const _0x2cf100=$gameTemp[_0x2ba37b(0x58e)](),_0x185ddd=BattleManager['_action'],_0x3d418b=BattleManager[_0x2ba37b(0xb9a)],_0x3adbec=BattleManager[_0x2ba37b(0x377)]?BattleManager[_0x2ba37b(0x377)][_0x2ba37b(0x5e1)](0x0):[],_0x2ac418=BattleManager[_0x2ba37b(0x901)],_0xfa9334=_0x1cb693[_0x2ba37b(0xa30)]??![];if(!_0x2cf100||!_0x185ddd||!_0x3d418b)return;if(!_0x185ddd[_0x2ba37b(0x3c7)]())return;let _0x3a3b5d=_0xfa9334?_0x2ac418[_0x2ba37b(0xb1d)](_0x3d418b):0x1;for(let _0x1aec27=0x0;_0x1aec27<_0x3a3b5d;_0x1aec27++){if(_0xfa9334&&_0x3d418b[_0x2ba37b(0x75b)]()){if(_0x2ba37b(0x9db)!==_0x2ba37b(0x9db)){if(!_0x13f9df['isSceneBattle']())return;const _0x182490=this[_0x2ba37b(0x456)]();if(!_0x182490)return;let _0x5e8dcf=this[_0x2ba37b(0x75b)]()?_0x182490[_0x2ba37b(0x34c)]:_0x182490[_0x2ba37b(0x8c5)]['_weaponSprite'];_0x5e8dcf&&_0x5e8dcf[_0x2ba37b(0xba7)](0x0);}else _0x2ac418['push'](_0x2ba37b(0x592),_0x3d418b,_0x1aec27);}if(_0x1cb693['PerformAction'])_0x2ac418['push']('performAction',_0x3d418b,_0x185ddd);if(_0x1cb693[_0x2ba37b(0xa59)]>0x0)_0x2ac418[_0x2ba37b(0xbc8)]('waitCount',_0x1cb693['WaitCount']);if(_0x1cb693['ActionAnimation'])_0x2ac418[_0x2ba37b(0xbc8)](_0x2ba37b(0x2c9),_0x3d418b,_0x3adbec,_0x185ddd[_0x2ba37b(0x3c7)]()['animationId']);if(_0x1cb693[_0x2ba37b(0xac0)])_0x2ac418[_0x2ba37b(0xbc8)]('waitForAnimation');for(const _0x1ee432 of _0x3adbec){if(!_0x1ee432)continue;if(_0x1cb693[_0x2ba37b(0x8e1)])_0x2ac418[_0x2ba37b(0xbc8)](_0x2ba37b(0x635),_0x3d418b,_0x1ee432);}}_0xfa9334&&_0x3d418b[_0x2ba37b(0x75b)]()&&(_0x2ba37b(0x843)==='goYhp'?_0x2ac418[_0x2ba37b(0xbc8)](_0x2ba37b(0x779),_0x3d418b):_0x817030=_0x1bcfce[_0x2ba37b(0x508)](_0x44709b));if(_0x1cb693[_0x2ba37b(0x79d)])_0x2ac418[_0x2ba37b(0xbc8)](_0x2ba37b(0x714),_0x3d418b,_0x3adbec,![]);_0x2cf100['setWaitMode'](_0x2ba37b(0xb63));}),PluginManager[_0xfd5ed1(0xbaf)](pluginData[_0xfd5ed1(0x452)],_0xfd5ed1(0x838),_0x3fad00=>{const _0x406fe5=_0xfd5ed1;if(!SceneManager[_0x406fe5(0xbb7)]())return;VisuMZ[_0x406fe5(0x1c5)](_0x3fad00,_0x3fad00);const _0x4f9b06=$gameTemp['getLastPluginCommandInterpreter'](),_0x2c59fe=BattleManager[_0x406fe5(0x2c6)],_0xeae9fb=BattleManager[_0x406fe5(0xb9a)],_0x40b5e5=BattleManager['_allTargets']?BattleManager['_allTargets'][_0x406fe5(0x5e1)](0x0):[],_0x45af86=BattleManager[_0x406fe5(0x901)],_0x599acc=_0x3fad00[_0x406fe5(0xa30)]??![];if(!_0x4f9b06||!_0x2c59fe||!_0xeae9fb)return;if(!_0x2c59fe[_0x406fe5(0x3c7)]())return;let _0x21b4c6=_0x599acc?_0x45af86[_0x406fe5(0xb1d)](_0xeae9fb):0x1;for(let _0x1a2b80=0x0;_0x1a2b80<_0x21b4c6;_0x1a2b80++){for(const _0x21d56d of _0x40b5e5){if(!_0x21d56d)continue;if(_0x599acc&&_0xeae9fb[_0x406fe5(0x75b)]()){if('XFAPV'!==_0x406fe5(0x589))_0x45af86['push'](_0x406fe5(0x592),_0xeae9fb,_0x1a2b80);else{const _0x481c34=this[_0x406fe5(0x456)]();if(_0x481c34)_0x481c34[_0x406fe5(0x967)](_0xfb28e7);}}if(_0x3fad00[_0x406fe5(0xb33)])_0x45af86[_0x406fe5(0xbc8)](_0x406fe5(0x871),_0xeae9fb,_0x2c59fe);if(_0x3fad00[_0x406fe5(0x30a)]>0x0)_0x45af86[_0x406fe5(0xbc8)](_0x406fe5(0x52d),_0x3fad00['WaitCount1']);if(_0x3fad00['ActionAnimation'])_0x45af86[_0x406fe5(0xbc8)](_0x406fe5(0x2c9),_0xeae9fb,[_0x21d56d],_0x2c59fe[_0x406fe5(0x3c7)]()[_0x406fe5(0x82b)]);if(_0x3fad00[_0x406fe5(0xb6e)]>0x0)_0x45af86[_0x406fe5(0xbc8)](_0x406fe5(0x52d),_0x3fad00['WaitCount2']);if(_0x3fad00[_0x406fe5(0x8e1)])_0x45af86[_0x406fe5(0xbc8)](_0x406fe5(0x635),_0xeae9fb,_0x21d56d);}}if(_0x599acc&&_0xeae9fb[_0x406fe5(0x75b)]()){if(_0x406fe5(0x3ad)!=='GPsWv')_0x45af86['push'](_0x406fe5(0x779),_0xeae9fb);else return _0xd81bec[_0x406fe5(0x6cc)]()[_0x406fe5(0x4af)](_0x530ae2=>_0x530ae2!==_0x1d431c);}if(_0x3fad00[_0x406fe5(0x79d)])_0x45af86['push'](_0x406fe5(0x714),_0xeae9fb,_0x40b5e5,![]);_0x4f9b06[_0x406fe5(0x7a6)](_0x406fe5(0xb63));}),PluginManager[_0xfd5ed1(0xbaf)](pluginData[_0xfd5ed1(0x452)],_0xfd5ed1(0x362),_0xee374d=>{const _0x4106c6=_0xfd5ed1;if(!SceneManager[_0x4106c6(0xbb7)]())return;VisuMZ[_0x4106c6(0x1c5)](_0xee374d,_0xee374d);const _0x235b32=$gameTemp[_0x4106c6(0x58e)](),_0x272eb0=BattleManager[_0x4106c6(0x2c6)],_0x2ef749=BattleManager[_0x4106c6(0xb9a)],_0x36bfeb=BattleManager[_0x4106c6(0x377)]?BattleManager[_0x4106c6(0x377)][_0x4106c6(0x5e1)](0x0):[],_0x361c69=BattleManager[_0x4106c6(0x901)];if(!_0x235b32||!_0x272eb0||!_0x2ef749)return;if(!_0x272eb0[_0x4106c6(0x3c7)]())return;if(_0xee374d[_0x4106c6(0x79d)])_0x361c69[_0x4106c6(0xbc8)](_0x4106c6(0x714),_0x2ef749,_0x36bfeb,![]);if(_0xee374d[_0x4106c6(0x299)])_0x361c69[_0x4106c6(0xbc8)](_0x4106c6(0x9b9));if(_0xee374d[_0x4106c6(0xad0)])_0x361c69[_0x4106c6(0xbc8)](_0x4106c6(0x622));if(_0xee374d[_0x4106c6(0x1de)])_0x361c69[_0x4106c6(0xbc8)](_0x4106c6(0x3d1));if(_0xee374d[_0x4106c6(0xadc)])_0x361c69[_0x4106c6(0xbc8)]('performActionEnd',_0x2ef749);if(_0xee374d[_0x4106c6(0x867)])_0x361c69[_0x4106c6(0xbc8)](_0x4106c6(0x284));_0x235b32[_0x4106c6(0x7a6)](_0x4106c6(0xb63));}),PluginManager[_0xfd5ed1(0xbaf)](pluginData[_0xfd5ed1(0x452)],_0xfd5ed1(0x629),_0x1e1994=>{const _0x520d65=_0xfd5ed1;if(!SceneManager[_0x520d65(0xbb7)]())return;if(!Imported[_0x520d65(0x450)])return;VisuMZ[_0x520d65(0x1c5)](_0x1e1994,_0x1e1994);const _0x340bab=$gameTemp['getLastPluginCommandInterpreter'](),_0x5a8f6d=_0x1e1994[_0x520d65(0x9f2)];if(!_0x340bab)return;$gameScreen[_0x520d65(0x6ca)](_0x1e1994[_0x520d65(0x538)],_0x1e1994[_0x520d65(0x86a)],_0x1e1994[_0x520d65(0x74f)]);if(_0x5a8f6d)_0x340bab[_0x520d65(0x7a6)](_0x520d65(0x1b0));}),PluginManager[_0xfd5ed1(0xbaf)](pluginData[_0xfd5ed1(0x452)],_0xfd5ed1(0x98b),_0x144353=>{const _0xa76dfc=_0xfd5ed1;if(!SceneManager[_0xa76dfc(0xbb7)]())return;if(!Imported['VisuMZ_3_ActSeqCamera'])return;VisuMZ[_0xa76dfc(0x1c5)](_0x144353,_0x144353);const _0x205d20=$gameTemp['getLastPluginCommandInterpreter'](),_0x450d63=_0x144353[_0xa76dfc(0x9f2)];if(!_0x205d20)return;$gameScreen[_0xa76dfc(0x6ca)](0x0,_0x144353[_0xa76dfc(0x86a)],_0x144353[_0xa76dfc(0x74f)]);if(_0x450d63)_0x205d20[_0xa76dfc(0x7a6)](_0xa76dfc(0x1b0));}),PluginManager[_0xfd5ed1(0xbaf)](pluginData[_0xfd5ed1(0x452)],_0xfd5ed1(0x1a2),_0x5426ba=>{const _0x316652=_0xfd5ed1;if(!SceneManager[_0x316652(0xbb7)]())return;if(!Imported['VisuMZ_3_ActSeqCamera'])return;const _0x3d7e32=$gameTemp[_0x316652(0x58e)]();if(!_0x3d7e32)return;_0x3d7e32[_0x316652(0x7a6)](_0x316652(0x1b0));}),PluginManager[_0xfd5ed1(0xbaf)](pluginData[_0xfd5ed1(0x452)],_0xfd5ed1(0xacf),_0x1cecdf=>{const _0x490be4=_0xfd5ed1;if(!SceneManager[_0x490be4(0xbb7)]())return;VisuMZ['ConvertParams'](_0x1cecdf,_0x1cecdf);const _0x1d0895=$gameTemp[_0x490be4(0x58e)](),_0x1fabc3=BattleManager[_0x490be4(0x2c6)],_0x4d54b0=BattleManager['_subject'],_0xeed798=VisuMZ[_0x490be4(0x49d)](_0x1cecdf['Targets']),_0x5577e5=_0x1cecdf[_0x490be4(0x5f6)],_0x2665a3=BattleManager[_0x490be4(0x901)];if(!_0x1d0895||!_0x1fabc3||!_0x4d54b0)return;if(!_0x1fabc3[_0x490be4(0x3c7)]())return;let _0x59f1fa=_0x1fabc3[_0x490be4(0x3c7)]()[_0x490be4(0x82b)];if(_0x59f1fa<0x0)_0x59f1fa=_0x4d54b0[_0x490be4(0x4a0)]();$gameTemp['requestAnimation'](_0xeed798,_0x59f1fa,_0x5577e5),_0x1cecdf['WaitForAnimation']&&_0x1d0895[_0x490be4(0x7a6)](_0x490be4(0x1dc));}),PluginManager[_0xfd5ed1(0xbaf)](pluginData['name'],_0xfd5ed1(0x654),_0x47ddc9=>{const _0x873509=_0xfd5ed1;if(!SceneManager['isSceneBattle']())return;VisuMZ['ConvertParams'](_0x47ddc9,_0x47ddc9);const _0x61853=$gameTemp[_0x873509(0x58e)](),_0x59a8c9=BattleManager['_subject'],_0x18556f=VisuMZ['CreateActionSequenceTargets'](_0x47ddc9[_0x873509(0x7e3)]),_0x58c2fa=_0x47ddc9[_0x873509(0x5f6)],_0x41f849=BattleManager[_0x873509(0x901)];if(!_0x61853||!_0x59a8c9)return;const _0x5197e7=_0x59a8c9[_0x873509(0x4a0)]();$gameTemp['requestAnimation'](_0x18556f,_0x5197e7,_0x58c2fa),_0x47ddc9['WaitForAnimation']&&_0x61853[_0x873509(0x7a6)](_0x873509(0x1dc));}),PluginManager[_0xfd5ed1(0xbaf)](pluginData[_0xfd5ed1(0x452)],_0xfd5ed1(0x5d8),_0x3bcf10=>{const _0x2093b5=_0xfd5ed1;if(!SceneManager[_0x2093b5(0xbb7)]())return;VisuMZ[_0x2093b5(0x1c5)](_0x3bcf10,_0x3bcf10);const _0x3c05c2=_0x5a4ab9[_0x2093b5(0x404)](_0x3bcf10[_0x2093b5(0x17f)]);if(_0x3c05c2<=0x0)return;const _0x4dbb07=$gameTemp[_0x2093b5(0x58e)](),_0x5a4ab9=BattleManager[_0x2093b5(0xb9a)],_0x34ddb8=VisuMZ[_0x2093b5(0x49d)](_0x3bcf10[_0x2093b5(0x7e3)]),_0x567812=_0x3bcf10[_0x2093b5(0x5f6)],_0x5ade09=BattleManager[_0x2093b5(0x901)];if(!_0x4dbb07||!_0x5a4ab9)return;$gameTemp[_0x2093b5(0x307)](_0x34ddb8,_0x3c05c2,_0x567812);if(_0x3bcf10[_0x2093b5(0xac0)]){if(_0x2093b5(0x3ff)===_0x2093b5(0x1b7)){if(_0x5617e5[_0x2093b5(0x1e9)][_0x2093b5(0x21a)][_0x3cf5ec]){const _0x5c8a54=_0x497b40[_0x2093b5(0x1e9)][_0x2093b5(0x21a)][_0x3111c9],_0x461b55={'code':0x2c,'dataId':_0x5c8a54,'value1':0x1,'value2':0x0};_0x47a087['effects']['push'](_0x461b55);}}else _0x4dbb07[_0x2093b5(0x7a6)](_0x2093b5(0x1dc));}}),PluginManager[_0xfd5ed1(0xbaf)](pluginData[_0xfd5ed1(0x452)],'ActSeq_Animation_CastAnimation',_0x306d94=>{const _0xceadd3=_0xfd5ed1;if(!SceneManager[_0xceadd3(0xbb7)]())return;VisuMZ['ConvertParams'](_0x306d94,_0x306d94);const _0x182dac=$gameTemp['getLastPluginCommandInterpreter'](),_0x869132=BattleManager['_action'],_0x38cbcf=_0x306d94['Mirror'],_0x20ad8b=VisuMZ[_0xceadd3(0x49d)](_0x306d94[_0xceadd3(0x7e3)]);if(!_0x182dac||!_0x869132)return;if(!_0x869132[_0xceadd3(0x3c7)]())return;for(const _0x590ba6 of _0x20ad8b){if(!_0x590ba6)continue;_0x590ba6[_0xceadd3(0x5c2)](_0x869132,_0x38cbcf);}if(_0x306d94[_0xceadd3(0xac0)])_0x182dac['setWaitMode']('battleAnimation');}),PluginManager[_0xfd5ed1(0xbaf)](pluginData[_0xfd5ed1(0x452)],'ActSeq_Animation_ChangeBattlePortrait',_0x11ca25=>{const _0x2aaad9=_0xfd5ed1;VisuMZ[_0x2aaad9(0x1c5)](_0x11ca25,_0x11ca25);const _0x55ed64=$gameTemp['getLastPluginCommandInterpreter'](),_0x556192=VisuMZ[_0x2aaad9(0x49d)](_0x11ca25['Targets']),_0x33e8dd=_0x11ca25[_0x2aaad9(0x36f)];if(!_0x33e8dd)return;for(const _0x32a900 of _0x556192){if(!_0x32a900)continue;if(!_0x32a900['isActor']())continue;_0x32a900[_0x2aaad9(0xaab)](_0x33e8dd);}}),PluginManager[_0xfd5ed1(0xbaf)](pluginData[_0xfd5ed1(0x452)],_0xfd5ed1(0x38c),_0x19b839=>{const _0x4dff97=_0xfd5ed1;if(!SceneManager[_0x4dff97(0x3c3)])return;if(!SceneManager['_scene'][_0x4dff97(0xb41)])return;if(!Imported[_0x4dff97(0x768)])return;VisuMZ['ConvertParams'](_0x19b839,_0x19b839);const _0x217fe9=$gameTemp[_0x4dff97(0x58e)](),_0xd49a52=Math[_0x4dff97(0x271)](_0x19b839[_0x4dff97(0x36c)]),_0x4c8a08=Math[_0x4dff97(0x271)](_0x19b839[_0x4dff97(0xb4b)]);$gameTemp[_0x4dff97(0xb9b)](_0xd49a52,_0x4c8a08,_0x19b839[_0x4dff97(0x3b7)],_0x19b839[_0x4dff97(0x5f6)],_0x19b839[_0x4dff97(0x5a8)]),_0x19b839[_0x4dff97(0x44f)]&&_0x217fe9&&(SceneManager[_0x4dff97(0x3c3)][_0x4dff97(0xb41)][_0x4dff97(0x38e)](),_0x217fe9['setWaitMode']('battleAnimation'));}),PluginManager[_0xfd5ed1(0xbaf)](pluginData[_0xfd5ed1(0x452)],_0xfd5ed1(0x7fd),_0x287b32=>{const _0x40b369=_0xfd5ed1;if(!SceneManager[_0x40b369(0xbb7)]())return;VisuMZ[_0x40b369(0x1c5)](_0x287b32,_0x287b32);const _0x4c85d4=$gameTemp[_0x40b369(0x58e)](),_0x1e9dbf=VisuMZ[_0x40b369(0x49d)](_0x287b32[_0x40b369(0x7e3)]),_0x867df1=_0x287b32[_0x40b369(0x3b7)],_0x5aa2b3=_0x287b32[_0x40b369(0x5f6)];if(!_0x4c85d4)return;$gameTemp[_0x40b369(0x307)](_0x1e9dbf,_0x867df1,_0x5aa2b3);if(_0x287b32[_0x40b369(0xac0)])_0x4c85d4['setWaitMode'](_0x40b369(0x1dc));}),PluginManager[_0xfd5ed1(0xbaf)](pluginData[_0xfd5ed1(0x452)],'ActSeq_Animation_WaitForAnimation',_0x558114=>{const _0x1cfa77=_0xfd5ed1;if(!SceneManager['isSceneBattle']())return;const _0x306622=$gameTemp['getLastPluginCommandInterpreter']();if(!_0x306622)return;_0x306622[_0x1cfa77(0x7a6)](_0x1cfa77(0x1dc));}),PluginManager[_0xfd5ed1(0xbaf)](pluginData['name'],_0xfd5ed1(0x998),_0x5209de=>{const _0x12875d=_0xfd5ed1;if(!SceneManager[_0x12875d(0xbb7)]())return;VisuMZ[_0x12875d(0x1c5)](_0x5209de,_0x5209de);const _0x514554=BattleManager['_logWindow'],_0x254957=_0x5209de[_0x12875d(0xab5)]&&Imported[_0x12875d(0x98e)];_0x514554['addText'](_0x5209de['Text']),_0x254957&&Imported[_0x12875d(0x98e)]&&$gameSystem[_0x12875d(0x9fa)](_0x5209de[_0x12875d(0x6de)]||'',_0x5209de[_0x12875d(0x3e8)]||0x0);}),PluginManager[_0xfd5ed1(0xbaf)](pluginData[_0xfd5ed1(0x452)],_0xfd5ed1(0x557),_0x3d7465=>{const _0x5616bc=_0xfd5ed1;if(!SceneManager[_0x5616bc(0xbb7)]())return;const _0x39df74=BattleManager[_0x5616bc(0x901)];_0x39df74['clear']();}),PluginManager[_0xfd5ed1(0xbaf)](pluginData[_0xfd5ed1(0x452)],_0xfd5ed1(0x37c),_0x3a6632=>{const _0x24f2f3=_0xfd5ed1;if(!SceneManager['isSceneBattle']())return;const _0x354b96=$gameTemp[_0x24f2f3(0x58e)](),_0x2e58e4=BattleManager[_0x24f2f3(0x2c6)],_0x187d4b=BattleManager[_0x24f2f3(0xb9a)],_0x293c11=BattleManager[_0x24f2f3(0x901)];if(!_0x354b96||!_0x2e58e4||!_0x187d4b)return;if(!_0x2e58e4['item']())return;_0x293c11[_0x24f2f3(0x7f7)](_0x187d4b,_0x2e58e4[_0x24f2f3(0x3c7)]()),_0x354b96['setWaitMode'](_0x24f2f3(0xb63));}),PluginManager[_0xfd5ed1(0xbaf)](pluginData['name'],_0xfd5ed1(0x85a),_0x16d521=>{const _0x206f85=_0xfd5ed1;if(!SceneManager[_0x206f85(0xbb7)]())return;const _0x5a7e3a=BattleManager[_0x206f85(0x901)];_0x5a7e3a[_0x206f85(0x448)]();}),PluginManager['registerCommand'](pluginData[_0xfd5ed1(0x452)],_0xfd5ed1(0x98d),_0x1ed9f3=>{const _0x9d4f8b=_0xfd5ed1;if(!SceneManager[_0x9d4f8b(0xbb7)]())return;const _0x345d1c=BattleManager[_0x9d4f8b(0x901)];_0x345d1c[_0x9d4f8b(0x784)]();}),PluginManager['registerCommand'](pluginData[_0xfd5ed1(0x452)],_0xfd5ed1(0x7d4),_0x43338e=>{const _0x5805af=_0xfd5ed1;if(!SceneManager['isSceneBattle']())return;const _0x3b4a14=BattleManager[_0x5805af(0x901)];_0x3b4a14[_0x5805af(0x486)]();}),PluginManager[_0xfd5ed1(0xbaf)](pluginData[_0xfd5ed1(0x452)],'ActSeq_BattleLog_UI',_0x16ff0c=>{const _0x5e089e=_0xfd5ed1;if(!SceneManager[_0x5e089e(0xbb7)]())return;VisuMZ[_0x5e089e(0x1c5)](_0x16ff0c,_0x16ff0c),SceneManager[_0x5e089e(0x3c3)]['setVisibleUI'](_0x16ff0c[_0x5e089e(0x2d5)]);}),PluginManager['registerCommand'](pluginData['name'],'ActSeq_BattleLog_WaitForBattleLog',_0xb13b21=>{const _0x2630aa=_0xfd5ed1;if(!SceneManager[_0x2630aa(0xbb7)]())return;const _0x4933ba=$gameTemp[_0x2630aa(0x58e)]();_0x4933ba['setWaitMode'](_0x2630aa(0xb63));}),PluginManager['registerCommand'](pluginData[_0xfd5ed1(0x452)],_0xfd5ed1(0x457),_0x4116e7=>{const _0x56de38=_0xfd5ed1;if(!SceneManager[_0x56de38(0xbb7)]())return;const _0x5eaad3=$gameTemp['getLastPluginCommandInterpreter'](),_0x26f6f7=BattleManager['_logWindow'];_0x26f6f7[_0x56de38(0x9b9)](),_0x5eaad3[_0x56de38(0x7a6)]('battlelog');}),PluginManager[_0xfd5ed1(0xbaf)](pluginData['name'],'ActSeq_Camera_Clamp',_0x57209a=>{const _0x1e991=_0xfd5ed1;if(!SceneManager[_0x1e991(0xbb7)]())return;if(!Imported[_0x1e991(0x450)])return;VisuMZ['ConvertParams'](_0x57209a,_0x57209a);const _0x3d38f9=$gameScreen['battleCameraData']();_0x3d38f9[_0x1e991(0x869)]=_0x57209a['Setting'];}),PluginManager[_0xfd5ed1(0xbaf)](pluginData[_0xfd5ed1(0x452)],'ActSeq_Camera_FocusPoint',_0x100e03=>{const _0x434038=_0xfd5ed1;if(!SceneManager[_0x434038(0xbb7)]())return;if(!Imported[_0x434038(0x450)])return;VisuMZ['ConvertParams'](_0x100e03,_0x100e03);const _0x4a799e=$gameTemp[_0x434038(0x58e)](),_0x365bcd=_0x100e03['WaitForCamera'];$gameScreen[_0x434038(0xba2)](_0x100e03['FocusX'],_0x100e03[_0x434038(0x939)],_0x100e03[_0x434038(0x86a)],_0x100e03['EasingType']);if(_0x365bcd)_0x4a799e[_0x434038(0x7a6)](_0x434038(0x246));}),PluginManager[_0xfd5ed1(0xbaf)](pluginData[_0xfd5ed1(0x452)],'ActSeq_Camera_FocusTarget',_0x419a53=>{const _0x595f49=_0xfd5ed1;if(!SceneManager['isSceneBattle']())return;if(!Imported[_0x595f49(0x450)])return;VisuMZ[_0x595f49(0x1c5)](_0x419a53,_0x419a53);const _0x581a49=$gameTemp[_0x595f49(0x58e)](),_0x44ba4d=VisuMZ['CreateActionSequenceTargets'](_0x419a53[_0x595f49(0x7e3)]),_0x1d679f=_0x419a53[_0x595f49(0x646)];$gameScreen[_0x595f49(0x9ef)](_0x44ba4d,_0x419a53[_0x595f49(0x86a)],_0x419a53[_0x595f49(0x74f)]);if(_0x1d679f)_0x581a49[_0x595f49(0x7a6)](_0x595f49(0x246));}),PluginManager[_0xfd5ed1(0xbaf)](pluginData[_0xfd5ed1(0x452)],_0xfd5ed1(0x4dd),_0x28452b=>{const _0x1dc9b2=_0xfd5ed1;if(!SceneManager[_0x1dc9b2(0xbb7)]())return;if(!Imported[_0x1dc9b2(0x450)])return;VisuMZ[_0x1dc9b2(0x1c5)](_0x28452b,_0x28452b);const _0x42d986=$gameTemp[_0x1dc9b2(0x58e)](),_0x2f6996=_0x28452b[_0x1dc9b2(0x646)];$gameScreen['setBattleCameraOffset'](_0x28452b[_0x1dc9b2(0x1cc)],_0x28452b[_0x1dc9b2(0x5e2)],_0x28452b['Duration'],_0x28452b[_0x1dc9b2(0x74f)]);if(_0x2f6996)_0x42d986['setWaitMode'](_0x1dc9b2(0x246));}),PluginManager['registerCommand'](pluginData[_0xfd5ed1(0x452)],_0xfd5ed1(0xb50),_0x3ee4c5=>{const _0x4fe0fc=_0xfd5ed1;if(!SceneManager['isSceneBattle']())return;if(!Imported[_0x4fe0fc(0x450)])return;VisuMZ['ConvertParams'](_0x3ee4c5,_0x3ee4c5);const _0x447289=$gameTemp[_0x4fe0fc(0x58e)](),_0x2df311=_0x3ee4c5[_0x4fe0fc(0x240)],_0x187e80=_0x3ee4c5[_0x4fe0fc(0x975)],_0x467747=_0x3ee4c5[_0x4fe0fc(0x646)];if(_0x2df311){if(_0x4fe0fc(0x67e)==='UpdbU'){const _0x3f7d70=Math['round'](Graphics[_0x4fe0fc(0xb4a)]/0x2),_0x5d7330=Math[_0x4fe0fc(0x271)](Graphics[_0x4fe0fc(0x8c6)]/0x2);$gameScreen['setBattleCameraPoint'](_0x3f7d70,_0x5d7330,_0x3ee4c5[_0x4fe0fc(0x86a)],_0x3ee4c5['EasingType']);}else this[_0x4fe0fc(0x669)]()?_0x4f62ed[_0x4fe0fc(0x3c3)][_0x4fe0fc(0x6f2)][_0x4fe0fc(0xac9)](_0x1db6b3):(this[_0x4fe0fc(0x98a)]()[_0x4fe0fc(0xaec)](_0x21cca2),this[_0x4fe0fc(0x839)][_0x4fe0fc(0x698)](_0x1c30fb),_0xcbd32a['destroy']());}_0x187e80&&('nVydh'===_0x4fe0fc(0x5b4)?$gameScreen['setBattleCameraOffset'](0x0,0x0,_0x3ee4c5[_0x4fe0fc(0x86a)],_0x3ee4c5[_0x4fe0fc(0x74f)]):(this['_shadowSprite']=new _0x25f292(),this[_0x4fe0fc(0xbe4)][_0x4fe0fc(0x86e)]=_0x52b86e[_0x4fe0fc(0x810)](_0x4fe0fc(0x3cb)),this[_0x4fe0fc(0xbe4)]['bitmap'][_0x4fe0fc(0x8d6)]=_0x28fbd8['BattleCore'][_0x4fe0fc(0x607)][_0x4fe0fc(0xbdf)][_0x4fe0fc(0xa38)],this['_shadowSprite'][_0x4fe0fc(0x266)]['x']=0.5,this[_0x4fe0fc(0xbe4)][_0x4fe0fc(0x266)]['y']=0.5,this[_0x4fe0fc(0xbe4)]['y']=-0x2,this['_shadowSprite']['visible']=![],this[_0x4fe0fc(0x3d8)](this[_0x4fe0fc(0xbe4)])));if(_0x467747)_0x447289[_0x4fe0fc(0x7a6)](_0x4fe0fc(0x246));}),PluginManager[_0xfd5ed1(0xbaf)](pluginData[_0xfd5ed1(0x452)],_0xfd5ed1(0x2eb),_0x5d50e4=>{const _0x68700c=_0xfd5ed1;if(!SceneManager['isSceneBattle']())return;if(!Imported[_0x68700c(0x450)])return;const _0x1f2f67=$gameTemp[_0x68700c(0x58e)]();if(!_0x1f2f67)return;_0x1f2f67[_0x68700c(0x7a6)](_0x68700c(0x246));}),PluginManager[_0xfd5ed1(0xbaf)](pluginData['name'],'ActSeq_DB_DragonbonesMotionAni',_0x4b8357=>{const _0x5cf931=_0xfd5ed1;if(!SceneManager[_0x5cf931(0xbb7)]())return;if(!Imported[_0x5cf931(0x274)])return;VisuMZ[_0x5cf931(0x1c5)](_0x4b8357,_0x4b8357);const _0x850aff=VisuMZ[_0x5cf931(0x49d)](_0x4b8357[_0x5cf931(0x7e3)]),_0x1a4505=_0x4b8357[_0x5cf931(0xaa5)][_0x5cf931(0x572)]()['trim']();for(const _0x5c0b0c of _0x850aff){if(!_0x5c0b0c)continue;_0x5c0b0c['requestDragonbonesAnimation'](_0x1a4505);}}),PluginManager[_0xfd5ed1(0xbaf)](pluginData[_0xfd5ed1(0x452)],_0xfd5ed1(0x9ad),_0x1369bb=>{const _0x591d3c=_0xfd5ed1;if(!SceneManager[_0x591d3c(0xbb7)]())return;if(!Imported[_0x591d3c(0x274)])return;VisuMZ[_0x591d3c(0x1c5)](_0x1369bb,_0x1369bb);const _0x201d72=VisuMZ['CreateActionSequenceTargets'](_0x1369bb[_0x591d3c(0x7e3)]),_0x1c889b=_0x1369bb[_0x591d3c(0x77e)];for(const _0x50c6b6 of _0x201d72){if('irRvP'!=='aLaAt'){if(!_0x50c6b6)continue;_0x50c6b6[_0x591d3c(0x31a)]()[_0x591d3c(0x825)]=_0x1c889b;}else _0x32c8a9[_0x591d3c(0x1e9)][_0x591d3c(0x26b)][_0x591d3c(0x740)](this,_0x53739a);}}),PluginManager[_0xfd5ed1(0xbaf)](pluginData[_0xfd5ed1(0x452)],_0xfd5ed1(0x935),_0x23d3f6=>{const _0x4b4fef=_0xfd5ed1;if(!SceneManager[_0x4b4fef(0xbb7)]())return;if(!Imported['VisuMZ_1_ElementStatusCore'])return;VisuMZ[_0x4b4fef(0x1c5)](_0x23d3f6,_0x23d3f6);const _0x1c8362=BattleManager[_0x4b4fef(0x2c6)],_0x343a2b=_0x23d3f6[_0x4b4fef(0xbbf)];if(!_0x1c8362)return;_0x1c8362[_0x4b4fef(0x91b)]=_0x343a2b;}),PluginManager['registerCommand'](pluginData[_0xfd5ed1(0x452)],_0xfd5ed1(0x64b),_0x32248c=>{const _0xd588c6=_0xfd5ed1;if(!SceneManager[_0xd588c6(0xbb7)]())return;if(!Imported[_0xd588c6(0xb2f)])return;const _0x1dafdd=BattleManager[_0xd588c6(0x2c6)];if(!_0x1dafdd)return;_0x1dafdd['clearElementChanges']();}),PluginManager['registerCommand'](pluginData[_0xfd5ed1(0x452)],_0xfd5ed1(0xb21),_0x560f8f=>{const _0x3ac62e=_0xfd5ed1;if(!SceneManager[_0x3ac62e(0xbb7)]())return;if(!Imported[_0x3ac62e(0xb2f)])return;VisuMZ[_0x3ac62e(0x1c5)](_0x560f8f,_0x560f8f);const _0x39807f=BattleManager[_0x3ac62e(0x2c6)],_0x19cabe=_0x560f8f['Elements'];if(!_0x39807f)return;_0x39807f[_0x3ac62e(0x1ce)]=_0x19cabe;}),PluginManager[_0xfd5ed1(0xbaf)](pluginData['name'],_0xfd5ed1(0x31d),_0x467033=>{const _0xf003a8=_0xfd5ed1;if(!SceneManager[_0xf003a8(0xbb7)]())return;if(!Imported['VisuMZ_1_ElementStatusCore'])return;const _0xcec5f9=BattleManager[_0xf003a8(0x2c6)];if(!_0xcec5f9)return;_0xcec5f9['_battleCoreNoElement']=!![];}),PluginManager['registerCommand'](pluginData[_0xfd5ed1(0x452)],_0xfd5ed1(0x338),_0x92d181=>{const _0x4cec80=_0xfd5ed1;if(!Imported['VisuMZ_2_HorrorEffects'])return;if(!SceneManager[_0x4cec80(0xbb7)]())return;VisuMZ[_0x4cec80(0x1c5)](_0x92d181,_0x92d181);const _0x33e4cc=VisuMZ['CreateActionSequenceTargets'](_0x92d181['Targets']);for(const _0x1987b6 of _0x33e4cc){if(_0x4cec80(0x8b8)!==_0x4cec80(0x8b8)){if(this['_forcedBattlers'][_0x4cec80(0x5b7)]>0x0){const _0x416d4f=this['_forcedBattlers']['shift'](),_0x4c3251=_0x416d4f[0x0];return _0x4c3251['_actions']=_0x4c3251[_0x4cec80(0x385)]||[],_0x4c3251[_0x4cec80(0x385)][0x0]=_0x416d4f[0x1],_0x4c3251;}else return this['_actionBattlers'][_0x4cec80(0x3a0)]();}else{if(!_0x1987b6)continue;_0x1987b6[_0x4cec80(0x86f)](_0x4cec80(0x232)),_0x1987b6[_0x4cec80(0x86f)]('glitch'),_0x1987b6[_0x4cec80(0x86f)]('tv'),_0x1987b6[_0x4cec80(0x987)]();}}$gamePlayer[_0x4cec80(0x486)]();}),PluginManager[_0xfd5ed1(0xbaf)](pluginData['name'],'ActSeq_Horror_GlitchCreate',_0x178bc8=>{const _0x5c7f01=_0xfd5ed1;if(!Imported[_0x5c7f01(0x2b2)])return;if(!SceneManager[_0x5c7f01(0xbb7)]())return;VisuMZ[_0x5c7f01(0x1c5)](_0x178bc8,_0x178bc8);const _0x57b885=VisuMZ['CreateActionSequenceTargets'](_0x178bc8[_0x5c7f01(0x7e3)]),_0x2ba57e=_0x5c7f01(0x546);_0x178bc8[_0x5c7f01(0x1b6)]=Math[_0x5c7f01(0x562)](_0x178bc8[_0x5c7f01(0x850)]/0x2),_0x178bc8['sliceMax']=_0x178bc8[_0x5c7f01(0x850)],_0x178bc8[_0x5c7f01(0x427)]=!![];for(const _0x24bbdd of _0x57b885){if(!_0x24bbdd)continue;_0x24bbdd[_0x5c7f01(0x2a1)](_0x2ba57e,_0x178bc8);}$gamePlayer[_0x5c7f01(0x486)]();}),PluginManager['registerCommand'](pluginData[_0xfd5ed1(0x452)],_0xfd5ed1(0x74c),_0x464207=>{const _0x1270cf=_0xfd5ed1;if(!Imported[_0x1270cf(0x2b2)])return;if(!SceneManager['isSceneBattle']())return;VisuMZ[_0x1270cf(0x1c5)](_0x464207,_0x464207);const _0x4d9fe8=VisuMZ['CreateActionSequenceTargets'](_0x464207[_0x1270cf(0x7e3)]);for(const _0x31ee3a of _0x4d9fe8){if(!_0x31ee3a)continue;_0x31ee3a[_0x1270cf(0x86f)]('glitch');}$gamePlayer[_0x1270cf(0x486)]();}),PluginManager[_0xfd5ed1(0xbaf)](pluginData[_0xfd5ed1(0x452)],'ActSeq_Horror_NoiseCreate',_0x368810=>{const _0x126c5b=_0xfd5ed1;if(!Imported[_0x126c5b(0x2b2)])return;if(!SceneManager['isSceneBattle']())return;VisuMZ[_0x126c5b(0x1c5)](_0x368810,_0x368810);const _0x4f3429=VisuMZ[_0x126c5b(0x49d)](_0x368810[_0x126c5b(0x7e3)]),_0x518cae=_0x126c5b(0x232);for(const _0x5b7e05 of _0x4f3429){if(!_0x5b7e05)continue;_0x5b7e05[_0x126c5b(0x2a1)](_0x518cae,_0x368810);}$gamePlayer[_0x126c5b(0x486)]();}),PluginManager[_0xfd5ed1(0xbaf)](pluginData[_0xfd5ed1(0x452)],_0xfd5ed1(0x45a),_0x1320fc=>{const _0xf68f33=_0xfd5ed1;if(!Imported[_0xf68f33(0x2b2)])return;if(!SceneManager[_0xf68f33(0xbb7)]())return;VisuMZ[_0xf68f33(0x1c5)](_0x1320fc,_0x1320fc);const _0x3510ee=VisuMZ['CreateActionSequenceTargets'](_0x1320fc['Targets']);for(const _0x16bb0d of _0x3510ee){if(!_0x16bb0d)continue;_0x16bb0d[_0xf68f33(0x86f)](_0xf68f33(0x232));}$gamePlayer[_0xf68f33(0x486)]();}),PluginManager[_0xfd5ed1(0xbaf)](pluginData[_0xfd5ed1(0x452)],_0xfd5ed1(0x661),_0xe10341=>{const _0x58b162=_0xfd5ed1;if(!Imported[_0x58b162(0x2b2)])return;if(!SceneManager['isSceneBattle']())return;VisuMZ[_0x58b162(0x1c5)](_0xe10341,_0xe10341);const _0x15444a=VisuMZ[_0x58b162(0x49d)](_0xe10341[_0x58b162(0x7e3)]),_0x118707='tv';for(const _0x2703a9 of _0x15444a){if(_0x58b162(0x55b)!==_0x58b162(0x55b))return _0xdd0e66['BattleCore'][_0x58b162(0x607)][_0x58b162(0xade)][_0x58b162(0xa31)];else{if(!_0x2703a9)continue;_0x2703a9['setHorrorEffectSettings'](_0x118707,_0xe10341);}}$gamePlayer[_0x58b162(0x486)]();}),PluginManager[_0xfd5ed1(0xbaf)](pluginData['name'],_0xfd5ed1(0xbd0),_0xc17c9d=>{const _0x3a2fd6=_0xfd5ed1;if(!Imported[_0x3a2fd6(0x2b2)])return;if(!SceneManager[_0x3a2fd6(0xbb7)]())return;VisuMZ['ConvertParams'](_0xc17c9d,_0xc17c9d);const _0x18d3f8=VisuMZ[_0x3a2fd6(0x49d)](_0xc17c9d['Targets']);for(const _0x477475 of _0x18d3f8){if(!_0x477475)continue;_0x477475[_0x3a2fd6(0x86f)]('tv');}$gamePlayer['refresh']();}),PluginManager['registerCommand'](pluginData[_0xfd5ed1(0x452)],'ActSeq_Impact_ColorBreak',_0x3ed28d=>{const _0x4c213b=_0xfd5ed1;if(!SceneManager['isSceneBattle']())return;if(!Imported[_0x4c213b(0x57d)])return;const _0x4d7fd3=SceneManager[_0x4c213b(0x3c3)][_0x4c213b(0xb41)];if(!_0x4d7fd3)return;VisuMZ[_0x4c213b(0x1c5)](_0x3ed28d,_0x3ed28d);const _0x6062d1=_0x3ed28d[_0x4c213b(0xb7c)]||0x1,_0x3a46bd=_0x3ed28d[_0x4c213b(0x86a)]||0x1,_0x40269e=_0x3ed28d[_0x4c213b(0x74f)]||_0x4c213b(0x558);_0x4d7fd3[_0x4c213b(0x567)](_0x6062d1,_0x3a46bd,_0x40269e);}),PluginManager['registerCommand'](pluginData['name'],_0xfd5ed1(0x4fb),_0x589587=>{const _0x157d0d=_0xfd5ed1;if(!SceneManager[_0x157d0d(0xbb7)]())return;if(!Imported[_0x157d0d(0x57d)])return;const _0x1f087e=SceneManager[_0x157d0d(0x3c3)][_0x157d0d(0xb41)];if(!_0x1f087e)return;VisuMZ[_0x157d0d(0x1c5)](_0x589587,_0x589587);const _0x36d8e2=Number(_0x589587[_0x157d0d(0x538)])||0x0,_0x25fc11=Number(_0x589587['Rate']),_0x12df19=_0x589587[_0x157d0d(0x86a)]||0x1,_0x400801=_0x589587[_0x157d0d(0x74f)]||_0x157d0d(0x558);_0x1f087e[_0x157d0d(0x724)](_0x36d8e2,_0x25fc11,_0x12df19,_0x400801);}),PluginManager[_0xfd5ed1(0xbaf)](pluginData[_0xfd5ed1(0x452)],'ActSeq_Impact_MotionBlurTarget',_0x474127=>{const _0x30417a=_0xfd5ed1;if(!SceneManager[_0x30417a(0xbb7)]())return;if(!Imported[_0x30417a(0x57d)])return;const _0x1a327f=SceneManager[_0x30417a(0x3c3)][_0x30417a(0xb41)];if(!_0x1a327f)return;VisuMZ['ConvertParams'](_0x474127,_0x474127);const _0x1fc69f=Number(_0x474127['Angle'])||0x0,_0x24af9c=Number(_0x474127[_0x30417a(0x5d1)]),_0x5d4d72=_0x474127['Duration']||0x1,_0x318556=_0x474127[_0x30417a(0x74f)]||_0x30417a(0x558),_0x24d573=VisuMZ[_0x30417a(0x49d)](_0x474127['Targets']);for(const _0x4e88c3 of _0x24d573){if(_0x30417a(0x4cb)!=='RtnrT'){if(!_0x4e88c3)continue;if(!_0x4e88c3[_0x30417a(0x456)]())continue;_0x4e88c3['battler']()[_0x30417a(0x724)](_0x1fc69f,_0x24af9c,_0x5d4d72,_0x318556);}else return _0x35503a[_0x30417a(0x768)]?_0x39d2dc[_0x30417a(0xa6e)]('ok'):_0x8b5ed5[_0x30417a(0x1e9)]['Settings'][_0x30417a(0x2d9)]['AutoBattleOK'];}}),PluginManager['registerCommand'](pluginData[_0xfd5ed1(0x452)],_0xfd5ed1(0x961),_0x22a2d4=>{const _0x2d140c=_0xfd5ed1;if(!SceneManager[_0x2d140c(0xbb7)]())return;if(!Imported[_0x2d140c(0x57d)])return;VisuMZ[_0x2d140c(0x1c5)](_0x22a2d4,_0x22a2d4);const _0x4784cc={'delay':_0x22a2d4[_0x2d140c(0xacd)],'duration':_0x22a2d4[_0x2d140c(0x20a)],'hue':_0x22a2d4[_0x2d140c(0x81a)],'opacityStart':_0x22a2d4['opacityStart'],'tone':_0x22a2d4[_0x2d140c(0xa9d)],'visible':!![]},_0x19f5cd=VisuMZ[_0x2d140c(0x49d)](_0x22a2d4[_0x2d140c(0x7e3)]);for(const _0x410379 of _0x19f5cd){if(_0x2d140c(0xa99)===_0x2d140c(0x580))this[_0x2d140c(0x8b9)]();else{if(!_0x410379)continue;_0x410379['setBattlerMotionTrailData'](_0x4784cc);}}}),PluginManager['registerCommand'](pluginData[_0xfd5ed1(0x452)],_0xfd5ed1(0x31f),_0x541644=>{const _0x436dc0=_0xfd5ed1;if(!SceneManager['isSceneBattle']())return;if(!Imported['VisuMZ_3_ActSeqImpact'])return;VisuMZ['ConvertParams'](_0x541644,_0x541644);const _0x165acc=VisuMZ[_0x436dc0(0x49d)](_0x541644[_0x436dc0(0x7e3)]);for(const _0x301541 of _0x165acc){if(_0x436dc0(0x6fb)!==_0x436dc0(0x6fb)){if(_0x7af2e7[_0x436dc0(0xa8c)]())_0x2576e5[_0x436dc0(0xa22)](_0x4683b5);return _0x5e17f7['BattleCore'][_0x436dc0(0x94e)][_0x436dc0(0x740)](this);}else{if(!_0x301541)continue;_0x301541[_0x436dc0(0x6f9)]();}}}),PluginManager[_0xfd5ed1(0xbaf)](pluginData['name'],_0xfd5ed1(0x6c0),_0x5bb12b=>{const _0x3cc578=_0xfd5ed1;if(!Imported[_0x3cc578(0x57d)])return;const _0x5ca5df=SceneManager[_0x3cc578(0x3c3)][_0x3cc578(0xb41)];if(!_0x5ca5df)return;VisuMZ['ConvertParams'](_0x5bb12b,_0x5bb12b);const _0x44f158=_0x5bb12b['X']||0x0,_0x421980=_0x5bb12b['Y']||0x0,_0x3f70c7=_0x5bb12b[_0x3cc578(0xaa0)]||0x0,_0x32f29f=_0x5bb12b[_0x3cc578(0x1ed)]||0x0,_0x1c1146=_0x5bb12b[_0x3cc578(0x86a)]||0x1;_0x5ca5df['setupShockwaveImpactFilter'](_0x44f158,_0x421980,_0x3f70c7,_0x32f29f,_0x1c1146);}),PluginManager['registerCommand'](pluginData[_0xfd5ed1(0x452)],'ActSeq_Impact_ShockwaveEachTargets',_0xf91051=>{const _0x2b59a8=_0xfd5ed1;if(!SceneManager['isSceneBattle']())return;if(!Imported[_0x2b59a8(0x57d)])return;const _0x3baf0a=SceneManager[_0x2b59a8(0x3c3)]['_spriteset'];if(!_0x3baf0a)return;VisuMZ[_0x2b59a8(0x1c5)](_0xf91051,_0xf91051);const _0x5842f8=VisuMZ[_0x2b59a8(0x49d)](_0xf91051[_0x2b59a8(0x7e3)]),_0x1b6a4b=_0xf91051[_0x2b59a8(0x3f0)],_0x4d97b9=_0xf91051[_0x2b59a8(0x1cc)]||0x0,_0xcffe5b=_0xf91051[_0x2b59a8(0x5e2)]||0x0,_0x1e3aa5=_0xf91051[_0x2b59a8(0xaa0)]||0x0,_0x237d8=_0xf91051[_0x2b59a8(0x1ed)]||0x0,_0x261386=_0xf91051[_0x2b59a8(0x86a)]||0x1;for(const _0x40b20a of _0x5842f8){if(!_0x40b20a)continue;if(!_0x40b20a['battler']())continue;const _0x167eb0=_0x40b20a[_0x2b59a8(0x456)]();let _0x318fcf=_0x167eb0['_baseX'],_0xa29efe=_0x167eb0[_0x2b59a8(0x579)];_0x318fcf+=(Graphics['width']-Graphics[_0x2b59a8(0x9c4)])/0x2,_0xa29efe+=(Graphics['height']-Graphics[_0x2b59a8(0xa52)])/0x2;if(_0x1b6a4b[_0x2b59a8(0x9e4)](/front/i)){if('gqqeE'!==_0x2b59a8(0xa57)){this[_0x2b59a8(0x359)][_0x2b59a8(0x41b)]=_0x46867f[_0x2b59a8(0x5f2)]();const _0x67bfd2=_0x50d60b[_0x2b59a8(0x279)]();if(_0x67bfd2===this['_borderPortraitSprite'][_0x2b59a8(0x279)])return;this[_0x2b59a8(0x359)][_0x2b59a8(0x279)]=_0x67bfd2||this[_0x2b59a8(0x359)][_0x2b59a8(0x279)];if(!_0x67bfd2)return;else{if(_0x67bfd2[_0x2b59a8(0xae4)]()===''){this[_0x2b59a8(0x359)][_0x2b59a8(0x86e)]=_0x16dee5[_0x2b59a8(0x73b)];return;}else{const _0x458c0a=_0x15d342[_0x2b59a8(0x5bd)](_0x67bfd2[_0x2b59a8(0xae4)]());_0x458c0a[_0x2b59a8(0x561)](this[_0x2b59a8(0x66e)][_0x2b59a8(0xa12)](this,_0x458c0a));}}}else _0x318fcf+=(_0x40b20a[_0x2b59a8(0x73c)]()?0x1:-0x1)*_0x167eb0['mainSpriteWidth']()/0x2;}else _0x1b6a4b[_0x2b59a8(0x9e4)](/back/i)&&(_0x2b59a8(0xb54)!==_0x2b59a8(0xb54)?_0x3a78d7[_0x2b59a8(0x60b)]=_0x2c8084(_0x4bd7cf['$1'])[_0x2b59a8(0x572)]()[_0x2b59a8(0x300)]():_0x318fcf+=(_0x40b20a[_0x2b59a8(0x73c)]()?-0x1:0x1)*_0x167eb0['mainSpriteWidth']()/0x2);if(_0x1b6a4b['match'](/head/i))_0xa29efe-=_0x167eb0[_0x2b59a8(0x5e5)]();else _0x1b6a4b[_0x2b59a8(0x9e4)](/center/i)&&(_0x2b59a8(0x769)===_0x2b59a8(0x5d7)?_0x498d48=_0x1d221a(_0x49520b['$1']):_0xa29efe-=_0x167eb0[_0x2b59a8(0x5e5)]()/0x2);_0x318fcf+=_0x4d97b9,_0xa29efe+=_0xcffe5b,_0x3baf0a[_0x2b59a8(0x7fa)](_0x318fcf,_0xa29efe,_0x1e3aa5,_0x237d8,_0x261386);}}),PluginManager['registerCommand'](pluginData['name'],_0xfd5ed1(0xbc2),_0x57ad09=>{const _0x4c30ca=_0xfd5ed1;if(!SceneManager[_0x4c30ca(0xbb7)]())return;if(!Imported['VisuMZ_3_ActSeqImpact'])return;const _0x16e573=SceneManager['_scene']['_spriteset'];if(!_0x16e573)return;VisuMZ[_0x4c30ca(0x1c5)](_0x57ad09,_0x57ad09);const _0x1aa911=VisuMZ[_0x4c30ca(0x49d)](_0x57ad09[_0x4c30ca(0x7e3)]),_0x4f418d=_0x57ad09['TargetLocation'],_0x1f7d56=_0x57ad09['OffsetX']||0x0,_0x2db204=_0x57ad09['OffsetY']||0x0,_0x5b43eb=_0x57ad09[_0x4c30ca(0xaa0)]||0x0,_0xb79cff=_0x57ad09['Wave']||0x0,_0x59ed51=_0x57ad09[_0x4c30ca(0x86a)]||0x1,_0xe84ab5=Math['min'](..._0x1aa911['map'](_0x4fad98=>_0x4fad98['battler']()[_0x4c30ca(0x6f7)]-_0x4fad98['battler']()['mainSpriteWidth']()/0x2)),_0x2c988f=Math[_0x4c30ca(0x4d3)](..._0x1aa911[_0x4c30ca(0x3ee)](_0x27343b=>_0x27343b[_0x4c30ca(0x456)]()[_0x4c30ca(0x6f7)]+_0x27343b[_0x4c30ca(0x456)]()[_0x4c30ca(0x1e5)]()/0x2)),_0x22408d=Math[_0x4c30ca(0x942)](..._0x1aa911['map'](_0x153698=>_0x153698[_0x4c30ca(0x456)]()[_0x4c30ca(0x579)]-_0x153698[_0x4c30ca(0x456)]()[_0x4c30ca(0x5e5)]())),_0x5e91df=Math['max'](..._0x1aa911[_0x4c30ca(0x3ee)](_0xd24825=>_0xd24825[_0x4c30ca(0x456)]()['_baseY'])),_0x42ea1f=_0x1aa911['filter'](_0xd256c0=>_0xd256c0[_0x4c30ca(0x75b)]())[_0x4c30ca(0x5b7)],_0x30f70c=_0x1aa911[_0x4c30ca(0x4af)](_0x56e6bb=>_0x56e6bb[_0x4c30ca(0x73c)]())['length'];let _0x1575e0=0x0,_0x560e91=0x0;if(_0x4f418d['match'](/front/i))'nnLHx'===_0x4c30ca(0x913)?_0x1575e0=_0x42ea1f>=_0x30f70c?_0xe84ab5:_0x2c988f:this['_cancelButton']['x']=-this[_0x4c30ca(0x7e8)][_0x4c30ca(0xb4a)]-0x4;else{if(_0x4f418d['match'](/middle/i))_0x1575e0=(_0xe84ab5+_0x2c988f)/0x2,melee=-0x1;else _0x4f418d['match'](/back/i)&&(_0x1575e0=_0x42ea1f>=_0x30f70c?_0x2c988f:_0xe84ab5);}if(_0x4f418d[_0x4c30ca(0x9e4)](/head/i))'PnYAa'===_0x4c30ca(0x5d6)?_0x13a920['command119']([_0x2805b0]):_0x560e91=_0x22408d;else{if(_0x4f418d[_0x4c30ca(0x9e4)](/center/i))_0x4c30ca(0x621)==='cAskv'?this[_0x4c30ca(0x798)][_0x4c30ca(0x86e)]['smooth']!==this[_0x4c30ca(0xbed)][_0x4c30ca(0xb46)]()&&(this['_mainSprite'][_0x4c30ca(0x86e)][_0x4c30ca(0x8d6)]=this[_0x4c30ca(0xbed)][_0x4c30ca(0xb46)]()):_0x560e91=(_0x22408d+_0x5e91df)/0x2;else _0x4f418d[_0x4c30ca(0x9e4)](/base/i)&&(_0x560e91=_0x5e91df);}_0x1575e0+=(Graphics[_0x4c30ca(0xb4a)]-Graphics['boxWidth'])/0x2,_0x560e91+=(Graphics[_0x4c30ca(0x8c6)]-Graphics['boxHeight'])/0x2,_0x1575e0+=_0x1f7d56,_0x560e91+=_0x2db204,_0x16e573[_0x4c30ca(0x7fa)](_0x1575e0,_0x560e91,_0x5b43eb,_0xb79cff,_0x59ed51);}),PluginManager[_0xfd5ed1(0xbaf)](pluginData[_0xfd5ed1(0x452)],'ActSeq_Impact_ZoomBlurPoint',_0x5a8e06=>{const _0x1c793b=_0xfd5ed1;if(!Imported[_0x1c793b(0x57d)])return;const _0x353721=SceneManager['_scene']['_spriteset'];if(!_0x353721)return;VisuMZ['ConvertParams'](_0x5a8e06,_0x5a8e06);const _0x5eedc4=_0x5a8e06['X']||0x0,_0x565bd6=_0x5a8e06['Y']||0x0,_0x418934=_0x5a8e06[_0x1c793b(0xabc)]||0x0,_0x42c1e8=_0x5a8e06['Radius']||0x0,_0x2c9a65=_0x5a8e06[_0x1c793b(0x86a)]||0x1,_0x5668d1=_0x5a8e06['EasingType']||_0x1c793b(0x558);_0x353721[_0x1c793b(0x9f3)](_0x418934,_0x5eedc4,_0x565bd6,_0x42c1e8,_0x2c9a65,_0x5668d1);}),PluginManager[_0xfd5ed1(0xbaf)](pluginData[_0xfd5ed1(0x452)],_0xfd5ed1(0xb39),_0x5b2713=>{const _0x5e56e1=_0xfd5ed1;if(!Imported['VisuMZ_3_ActSeqImpact'])return;const _0x176902=SceneManager[_0x5e56e1(0x3c3)][_0x5e56e1(0xb41)];if(!_0x176902)return;VisuMZ['ConvertParams'](_0x5b2713,_0x5b2713);const _0x53ea99=VisuMZ[_0x5e56e1(0x49d)](_0x5b2713[_0x5e56e1(0x7e3)]),_0x4be0dd=_0x5b2713[_0x5e56e1(0x3f0)],_0x3fa27b=_0x5b2713[_0x5e56e1(0x1cc)]||0x0,_0x3e2010=_0x5b2713[_0x5e56e1(0x5e2)]||0x0,_0x51fe22=_0x5b2713['Strength']||0x0,_0x3d50c5=_0x5b2713[_0x5e56e1(0x77f)]||0x0,_0x1daed8=_0x5b2713['Duration']||0x1,_0x11ab9e=_0x5b2713[_0x5e56e1(0x74f)]||_0x5e56e1(0x558),_0x3b1520=Math['min'](..._0x53ea99[_0x5e56e1(0x3ee)](_0x4f6aa0=>_0x4f6aa0[_0x5e56e1(0x456)]()[_0x5e56e1(0x6f7)]-_0x4f6aa0[_0x5e56e1(0x456)]()[_0x5e56e1(0x1e5)]()/0x2)),_0x30303d=Math[_0x5e56e1(0x4d3)](..._0x53ea99['map'](_0x34818f=>_0x34818f[_0x5e56e1(0x456)]()['_baseX']+_0x34818f['battler']()[_0x5e56e1(0x1e5)]()/0x2)),_0x17b30c=Math[_0x5e56e1(0x942)](..._0x53ea99['map'](_0x103316=>_0x103316[_0x5e56e1(0x456)]()[_0x5e56e1(0x579)]-_0x103316[_0x5e56e1(0x456)]()[_0x5e56e1(0x5e5)]())),_0x528cb8=Math[_0x5e56e1(0x4d3)](..._0x53ea99[_0x5e56e1(0x3ee)](_0xd0b845=>_0xd0b845['battler']()[_0x5e56e1(0x579)])),_0x23be26=_0x53ea99['filter'](_0x2795f4=>_0x2795f4['isActor']())[_0x5e56e1(0x5b7)],_0x2414ca=_0x53ea99[_0x5e56e1(0x4af)](_0x538e15=>_0x538e15[_0x5e56e1(0x73c)]())[_0x5e56e1(0x5b7)];let _0xfd94f=0x0,_0x201c03=0x0;if(_0x4be0dd[_0x5e56e1(0x9e4)](/front/i))_0xfd94f=_0x23be26>=_0x2414ca?_0x3b1520:_0x30303d;else{if(_0x4be0dd[_0x5e56e1(0x9e4)](/middle/i)){if('kAPxa'===_0x5e56e1(0x6ce))_0xfd94f=(_0x3b1520+_0x30303d)/0x2,melee=-0x1;else{if(_0x3bb4f1[_0x5e56e1(0x80f)][_0x5e56e1(0x9e4)](/<SWAP ENEMIES>\s*([\s\S]*)\s*<\/SWAP ENEMIES>/i)){const _0x11f961=_0x266d4a(_0x3d627f['$1'])[_0x5e56e1(0x513)](/[\r\n]+/)[_0x5e56e1(0x698)](''),_0x2f0f16=this[_0x5e56e1(0x780)](_0x11f961);_0x22bd55=this[_0x5e56e1(0x856)](_0x2f0f16)||_0x268f8f,_0x450de8=_0x286235[_0x5e56e1(0x6fa)](_0x364547);}}}else _0x4be0dd[_0x5e56e1(0x9e4)](/back/i)&&(_0xfd94f=_0x23be26>=_0x2414ca?_0x30303d:_0x3b1520);}if(_0x4be0dd['match'](/head/i))_0x5e56e1(0x78d)==='FbLED'?this[_0x5e56e1(0x74b)](_0x5e56e1(0x4e8)):_0x201c03=_0x17b30c;else{if(_0x4be0dd[_0x5e56e1(0x9e4)](/center/i))_0x201c03=(_0x17b30c+_0x528cb8)/0x2;else _0x4be0dd[_0x5e56e1(0x9e4)](/base/i)&&(_0x201c03=_0x528cb8);}_0xfd94f+=(Graphics[_0x5e56e1(0xb4a)]-Graphics['boxWidth'])/0x2,_0x201c03+=(Graphics[_0x5e56e1(0x8c6)]-Graphics[_0x5e56e1(0xa52)])/0x2,_0xfd94f+=_0x3fa27b,_0x201c03+=_0x3e2010,_0x176902[_0x5e56e1(0x9f3)](_0x51fe22,_0xfd94f,_0x201c03,_0x3d50c5,_0x1daed8,_0x11ab9e);}),PluginManager[_0xfd5ed1(0xbaf)](pluginData[_0xfd5ed1(0x452)],_0xfd5ed1(0xaf5),_0x416ea1=>{const _0x33a208=_0xfd5ed1;if(!SceneManager[_0x33a208(0xbb7)]())return;VisuMZ[_0x33a208(0x1c5)](_0x416ea1,_0x416ea1);const _0x4d9a82=$gameTemp['getLastPluginCommandInterpreter'](),_0x3717fc=BattleManager[_0x33a208(0x2c6)],_0x15f00b=BattleManager['_subject'],_0x5baea9=BattleManager[_0x33a208(0x901)];if(!_0x4d9a82||!_0x3717fc||!_0x15f00b)return;if(!_0x3717fc[_0x33a208(0x3c7)]())return;const _0x809af7=VisuMZ[_0x33a208(0x49d)](_0x416ea1[_0x33a208(0x7e3)]);for(const _0x4cd9e0 of _0x809af7){if('Fvlcj'!==_0x33a208(0x79f))this[_0x33a208(0x6f4)]();else{if(!_0x4cd9e0)continue;_0x5baea9[_0x33a208(0xbc8)](_0x33a208(0x635),_0x15f00b,_0x4cd9e0);}}_0x4d9a82['setWaitMode'](_0x33a208(0xb63));}),PluginManager[_0xfd5ed1(0xbaf)](pluginData[_0xfd5ed1(0x452)],_0xfd5ed1(0x8d8),_0x2367bc=>{const _0x408873=_0xfd5ed1;if(!SceneManager['isSceneBattle']())return;VisuMZ[_0x408873(0x1c5)](_0x2367bc,_0x2367bc);const _0x452be6=[_0x408873(0x236),'MAXMP',_0x408873(0x1f9),'DEF',_0x408873(0xab0),'MDF',_0x408873(0x4b5),_0x408873(0x587)],_0x24afeb=_0x2367bc['Buffs'],_0x251657=_0x2367bc[_0x408873(0x4c6)],_0x3d07fd=_0x2367bc['Turns'],_0x55c879=VisuMZ[_0x408873(0x49d)](_0x2367bc[_0x408873(0x7e3)]);for(const _0x4eaaea of _0x55c879){if('xumvR'===_0x408873(0x501)){if(!_0x4eaaea)continue;for(const _0x5774ef of _0x24afeb){const _0x1908da=_0x452be6[_0x408873(0x981)](_0x5774ef[_0x408873(0xa50)]()['trim']());_0x1908da>=0x0&&_0x1908da<=0x7&&_0x4eaaea[_0x408873(0x859)](_0x1908da,_0x3d07fd);}for(const _0xde27e of _0x251657){const _0x279aa6=_0x452be6[_0x408873(0x981)](_0xde27e[_0x408873(0xa50)]()[_0x408873(0x300)]());_0x279aa6>=0x0&&_0x279aa6<=0x7&&_0x4eaaea[_0x408873(0x685)](_0x279aa6,_0x3d07fd);}}else return!![];}}),PluginManager['registerCommand'](pluginData[_0xfd5ed1(0x452)],'ActSeq_Mechanics_AddState',_0x971c41=>{const _0x3573f8=_0xfd5ed1;if(!SceneManager[_0x3573f8(0xbb7)]())return;VisuMZ[_0x3573f8(0x1c5)](_0x971c41,_0x971c41);const _0x2116ad=_0x971c41[_0x3573f8(0x189)],_0x4939f8=VisuMZ['CreateActionSequenceTargets'](_0x971c41[_0x3573f8(0x7e3)]);for(const _0x27f51f of _0x4939f8){if(!_0x27f51f)continue;for(const _0x11b4f7 of _0x2116ad){_0x27f51f[_0x3573f8(0x884)](_0x11b4f7);}}}),PluginManager['registerCommand'](pluginData[_0xfd5ed1(0x452)],_0xfd5ed1(0x8c0),_0x364bdb=>{const _0x56b8c5=_0xfd5ed1;if(!SceneManager[_0x56b8c5(0xbb7)]())return;VisuMZ[_0x56b8c5(0x1c5)](_0x364bdb,_0x364bdb);const _0x351882=BattleManager[_0x56b8c5(0x2c6)],_0x2cd04c={'arPenRate':_0x364bdb[_0x56b8c5(0x5ae)],'arPenFlat':_0x364bdb[_0x56b8c5(0xbf1)],'arRedRate':_0x364bdb[_0x56b8c5(0x958)],'arRedFlat':_0x364bdb['ArRedFlat']};_0x351882[_0x56b8c5(0x949)]=_0x2cd04c;}),PluginManager['registerCommand'](pluginData[_0xfd5ed1(0x452)],_0xfd5ed1(0xa39),_0x4742d5=>{const _0x18082a=_0xfd5ed1;if(!SceneManager[_0x18082a(0xbb7)]())return;if(!Imported[_0x18082a(0x3fc)])return;VisuMZ[_0x18082a(0x1c5)](_0x4742d5,_0x4742d5);const _0x58c739=VisuMZ['CreateActionSequenceTargets'](_0x4742d5[_0x18082a(0x7e3)]),_0x321f18=_0x4742d5[_0x18082a(0x7b1)]||0x1;for(const _0x516c58 of _0x58c739){if(!_0x516c58)continue;if(!_0x516c58[_0x18082a(0x73c)]())continue;_0x516c58[_0x18082a(0x3ec)](_0x321f18);}}),PluginManager['registerCommand'](pluginData['name'],'ActSeq_Mechanics_AtbGauge',_0x20ea2b=>{const _0x550dae=_0xfd5ed1;if(!SceneManager[_0x550dae(0xbb7)]())return;if(!Imported[_0x550dae(0x548)])return;if(!BattleManager[_0x550dae(0x835)]())return;VisuMZ[_0x550dae(0x1c5)](_0x20ea2b,_0x20ea2b);const _0x3124d=VisuMZ[_0x550dae(0x49d)](_0x20ea2b[_0x550dae(0x7e3)]),_0x5844bf=_0x20ea2b['ChargeRate'],_0x40ddb6=_0x20ea2b[_0x550dae(0x4ae)],_0x593929=_0x20ea2b[_0x550dae(0x96b)];for(const _0x5cdd3c of _0x3124d){if(!_0x5cdd3c)continue;if(_0x5cdd3c[_0x550dae(0x6e7)]()){if(_0x550dae(0x2ad)!==_0x550dae(0x53c))_0x5cdd3c[_0x550dae(0x484)](_0x5844bf);else return _0x2d41e7['BattleCore'][_0x550dae(0x320)]['call'](this,_0x2175e1);}else{if(_0x5cdd3c[_0x550dae(0x1b9)]()){if(_0x550dae(0xa66)!==_0x550dae(0x8c4)){_0x5cdd3c['changeAtbCastTime'](_0x40ddb6);if(_0x593929)_0x5cdd3c['atbInterrupt']();}else{if(_0x15eec4['type']===0x0)this[_0x550dae(0x465)](_0x550dae(0xb1f));else{if(_0x7d0e75[_0x550dae(0x4b2)]===0x1)this[_0x550dae(0x465)](_0x550dae(0x737));else _0x20a0e7[_0x550dae(0x4b2)]===0x2&&this[_0x550dae(0x465)]('missile');}}}}}}),PluginManager[_0xfd5ed1(0xbaf)](pluginData['name'],'ActSeq_Mechanics_BoostPointsChange',_0xe59acd=>{const _0x57410c=_0xfd5ed1;if(!SceneManager[_0x57410c(0xbb7)]())return;if(!Imported['VisuMZ_3_BoostAction'])return;VisuMZ[_0x57410c(0x1c5)](_0xe59acd,_0xe59acd);const _0x4235b4=VisuMZ[_0x57410c(0x49d)](_0xe59acd[_0x57410c(0x7e3)]),_0x27bcfd=_0xe59acd[_0x57410c(0x3f4)];for(const _0x455f66 of _0x4235b4){if(!_0x455f66)continue;_0x455f66['gainStoredBoostPoints'](_0x27bcfd);}}),PluginManager[_0xfd5ed1(0xbaf)](pluginData[_0xfd5ed1(0x452)],_0xfd5ed1(0x49a),_0x5d1063=>{const _0x119950=_0xfd5ed1;if(!SceneManager[_0x119950(0xbb7)]())return;if(!Imported[_0x119950(0x8fa)])return;if(!BattleManager['_subject'])return;VisuMZ[_0x119950(0x1c5)](_0x5d1063,_0x5d1063);const _0x95b7f5=_0x5d1063[_0x119950(0x9a0)];$gameVariables[_0x119950(0x8f8)](_0x95b7f5,BattleManager[_0x119950(0xb9a)][_0x119950(0x25b)]());}),PluginManager[_0xfd5ed1(0xbaf)](pluginData[_0xfd5ed1(0x452)],_0xfd5ed1(0x930),_0x47a612=>{const _0x3d5981=_0xfd5ed1;if(!SceneManager[_0x3d5981(0xbb7)]())return;if(!Imported[_0x3d5981(0x4ba)])return;VisuMZ['ConvertParams'](_0x47a612,_0x47a612);const _0x4afa31=VisuMZ[_0x3d5981(0x49d)](_0x47a612['Targets']),_0x5159ba=_0x47a612[_0x3d5981(0x270)];for(const _0x391374 of _0x4afa31){if(!_0x391374)continue;if(_0x391374[_0x3d5981(0x86c)]())continue;if(!_0x391374[_0x3d5981(0x3f5)]())continue;_0x391374['alterBreakShield'](_0x5159ba);}}),PluginManager['registerCommand'](pluginData[_0xfd5ed1(0x452)],'ActSeq_Mechanics_BreakShieldReset',_0x2ed35a=>{const _0x46b30d=_0xfd5ed1;if(!SceneManager[_0x46b30d(0xbb7)]())return;if(!Imported['VisuMZ_4_BreakShields'])return;VisuMZ[_0x46b30d(0x1c5)](_0x2ed35a,_0x2ed35a);const _0x4a5088=VisuMZ[_0x46b30d(0x49d)](_0x2ed35a['Targets']);for(const _0x176eaf of _0x4a5088){if(_0x46b30d(0xba8)!==_0x46b30d(0x4f0)){if(!_0x176eaf)continue;if(_0x176eaf[_0x46b30d(0x86c)]())continue;if(!_0x176eaf[_0x46b30d(0x3f5)]())continue;_0x176eaf['resetBreakShield']();}else{if(_0x52f5ab[_0x46b30d(0x47b)]())return _0x46b30d(0x956);return'DTB';}}}),PluginManager[_0xfd5ed1(0xbaf)](pluginData[_0xfd5ed1(0x452)],_0xfd5ed1(0x2d1),_0x64bda3=>{const _0x5c5a52=_0xfd5ed1;if(!SceneManager['isSceneBattle']())return;if(!Imported[_0x5c5a52(0x4c0)])return;if(!BattleManager[_0x5c5a52(0x8df)]())return;VisuMZ[_0x5c5a52(0x1c5)](_0x64bda3,_0x64bda3);const _0x2f0ff9=VisuMZ['CreateActionSequenceTargets'](_0x64bda3[_0x5c5a52(0x7e3)]),_0xc15eed=_0x64bda3[_0x5c5a52(0x706)];for(const _0x49628d of _0x2f0ff9){if(!_0x49628d)continue;_0x49628d[_0x5c5a52(0x60c)](_0xc15eed);}}),PluginManager[_0xfd5ed1(0xbaf)](pluginData['name'],'ActSeq_Mechanics_Collapse',_0x340bc5=>{const _0x129b2e=_0xfd5ed1;if(!SceneManager[_0x129b2e(0xbb7)]())return;VisuMZ[_0x129b2e(0x1c5)](_0x340bc5,_0x340bc5);const _0x3afeee=$gameTemp['getLastPluginCommandInterpreter'](),_0x4aea1b=BattleManager['_action'],_0x50c18f=BattleManager[_0x129b2e(0xb9a)];if(!_0x3afeee||!_0x4aea1b||!_0x50c18f)return;if(!_0x4aea1b['item']())return;const _0x4c5cbf=VisuMZ[_0x129b2e(0x49d)](_0x340bc5[_0x129b2e(0x7e3)]);for(const _0x5a4cbe of _0x4c5cbf){if(!_0x5a4cbe)continue;if(_0x340bc5[_0x129b2e(0x9ae)]){if('cLOYr'===_0x129b2e(0x80a))_0x5a4cbe[_0x129b2e(0x9a7)](),_0x5a4cbe[_0x129b2e(0x884)](_0x5a4cbe['deathStateId']());else{if(this['_cache'][_0x129b2e(0x59e)]!==_0x28ae7a)return this[_0x129b2e(0x303)][_0x129b2e(0x59e)];if(this['actor']()['note'][_0x129b2e(0x9e4)](/<SIDEVIEW SHOW SHADOW>/i))this[_0x129b2e(0x303)][_0x129b2e(0x59e)]=!![];else this[_0x129b2e(0x279)]()['note'][_0x129b2e(0x9e4)](/<SIDEVIEW HIDE SHADOW>/i)?this['_cache'][_0x129b2e(0x59e)]=![]:this['_cache']['svShadow']=_0x2c8711[_0x129b2e(0x263)][_0x129b2e(0xb20)][_0x129b2e(0x740)](this);return this[_0x129b2e(0x303)][_0x129b2e(0x59e)];}}_0x5a4cbe[_0x129b2e(0x665)]()&&_0x5a4cbe['performCollapse']();}_0x3afeee[_0x129b2e(0x7a6)](_0x129b2e(0xb99));}),PluginManager['registerCommand'](pluginData[_0xfd5ed1(0x452)],_0xfd5ed1(0x54a),_0x2bb5bd=>{const _0x29e104=_0xfd5ed1;if(!SceneManager[_0x29e104(0xbb7)]())return;if(!Imported['VisuMZ_2_BattleSystemCTB'])return;if(!BattleManager[_0x29e104(0x42b)]())return;VisuMZ[_0x29e104(0x1c5)](_0x2bb5bd,_0x2bb5bd);const _0x7c04e7=VisuMZ['CreateActionSequenceTargets'](_0x2bb5bd[_0x29e104(0x7e3)]),_0x170d84=_0x2bb5bd[_0x29e104(0x5cf)];for(const _0xaab4ea of _0x7c04e7){if(_0x29e104(0x474)!==_0x29e104(0x6a6)){if(!_0xaab4ea)continue;_0xaab4ea[_0x29e104(0x394)](_0x170d84);}else _0x4653aa+=_0x11fe80(_0x103157['$1']);}}),PluginManager[_0xfd5ed1(0xbaf)](pluginData['name'],_0xfd5ed1(0x9ce),_0x18014d=>{const _0x3bec91=_0xfd5ed1;if(!SceneManager[_0x3bec91(0xbb7)]())return;if(!Imported[_0x3bec91(0x50a)])return;if(!BattleManager[_0x3bec91(0x42b)]())return;VisuMZ[_0x3bec91(0x1c5)](_0x18014d,_0x18014d);const _0x5af4a9=VisuMZ[_0x3bec91(0x49d)](_0x18014d['Targets']),_0x5b8325=_0x18014d[_0x3bec91(0x4ae)],_0x388c90=_0x18014d['ChargeRate'];for(const _0x45e207 of _0x5af4a9){if('ChjHg'!==_0x3bec91(0x54e)){if(!_0x45e207)continue;if(_0x45e207[_0x3bec91(0x8c8)]===_0x3bec91(0x9b8))_0x3bec91(0x27a)===_0x3bec91(0x3c9)?this['_cache'][_0x3bec91(0x898)]=_0x1ac837[_0x3bec91(0x263)]['svBattlerAnchorY'][_0x3bec91(0x740)](this):_0x45e207[_0x3bec91(0x7d0)](_0x5b8325);else _0x45e207[_0x3bec91(0x8c8)]===_0x3bec91(0xbcf)&&_0x45e207[_0x3bec91(0x2cf)](_0x388c90);}else return![];}}),PluginManager[_0xfd5ed1(0xbaf)](pluginData['name'],_0xfd5ed1(0x90d),_0xa1f5d5=>{const _0x391069=_0xfd5ed1;if(!SceneManager[_0x391069(0xbb7)]())return;VisuMZ[_0x391069(0x1c5)](_0xa1f5d5,_0xa1f5d5);const _0x39fefe=BattleManager[_0x391069(0x2c6)];if(!_0x39fefe)return;let _0x56897d=_0xa1f5d5[_0x391069(0x231)];_0x39fefe[_0x391069(0x224)](_0x56897d);}),PluginManager[_0xfd5ed1(0xbaf)](pluginData[_0xfd5ed1(0x452)],'ActSeq_Mechanics_DamagePopup',_0x470663=>{const _0x58aae7=_0xfd5ed1;if(!SceneManager[_0x58aae7(0xbb7)]())return;VisuMZ[_0x58aae7(0x1c5)](_0x470663,_0x470663);const _0x347f65=VisuMZ['CreateActionSequenceTargets'](_0x470663[_0x58aae7(0x7e3)]);for(const _0x6f6e9d of _0x347f65){if('YDIQA'===_0x58aae7(0xa2f))this[_0x58aae7(0x45b)]();else{if(!_0x6f6e9d)continue;if(_0x6f6e9d[_0x58aae7(0x719)]())_0x6f6e9d[_0x58aae7(0x397)]();}}}),PluginManager[_0xfd5ed1(0xbaf)](pluginData[_0xfd5ed1(0x452)],_0xfd5ed1(0x775),_0xbf3360=>{const _0x2f0c00=_0xfd5ed1;if(!SceneManager[_0x2f0c00(0xbb7)]())return;VisuMZ[_0x2f0c00(0x1c5)](_0xbf3360,_0xbf3360);const _0x75cee9=$gameTemp[_0x2f0c00(0x58e)](),_0x938ba3=BattleManager[_0x2f0c00(0xb9a)],_0x18b275=_0xbf3360[_0x2f0c00(0x2f6)];if(!_0x75cee9)return;if(!_0x938ba3)return;_0x938ba3&&_0x938ba3['isDead']()&&_0x18b275[_0x2f0c00(0xa50)]()[_0x2f0c00(0x300)]()!==_0x2f0c00(0x183)&&_0x75cee9[_0x2f0c00(0x904)]([_0x18b275]);}),PluginManager[_0xfd5ed1(0xbaf)](pluginData[_0xfd5ed1(0x452)],'ActSeq_Mechanics_EnemyEscape',_0xa1ae07=>{const _0x2736db=_0xfd5ed1;if(!SceneManager['isSceneBattle']())return;VisuMZ[_0x2736db(0x1c5)](_0xa1ae07,_0xa1ae07);const _0x4b32af=VisuMZ[_0x2736db(0x49d)](_0xa1ae07[_0x2736db(0x7e3)]);for(const _0x20a47f of _0x4b32af){if(!_0x20a47f)continue;if(!_0x20a47f['isEnemy']())continue;_0x20a47f['escape']();}}),PluginManager[_0xfd5ed1(0xbaf)](pluginData['name'],'ActSeq_Mechanics_EtbAction',_0x19f9f6=>{const _0x3e5e00=_0xfd5ed1;if(!SceneManager[_0x3e5e00(0xbb7)]())return;if(!Imported[_0x3e5e00(0x4c8)])return;if(!BattleManager['isETB']())return;VisuMZ[_0x3e5e00(0x1c5)](_0x19f9f6,_0x19f9f6);const _0x5bce45=_0x19f9f6['ActionCount'];BattleManager['_subject']&&BattleManager['_subject'][_0x3e5e00(0x8aa)]()['gainCurrentActionsETB'](_0x5bce45);}),PluginManager[_0xfd5ed1(0xbaf)](pluginData[_0xfd5ed1(0x452)],_0xfd5ed1(0x3b3),_0x5e42ec=>{const _0x324c7c=_0xfd5ed1;if(!SceneManager['isSceneBattle']())return;if(!Imported['VisuMZ_2_BattleSystemFTB'])return;if(!BattleManager[_0x324c7c(0x37f)]())return;VisuMZ[_0x324c7c(0x1c5)](_0x5e42ec,_0x5e42ec);const _0x1e2217=_0x5e42ec[_0x324c7c(0x3fe)];BattleManager[_0x324c7c(0xb9a)]&&BattleManager['_subject'][_0x324c7c(0x8aa)]()['gainCurrentActionsFTB'](_0x1e2217);}),PluginManager[_0xfd5ed1(0xbaf)](pluginData['name'],'ActSeq_Mechanics_HpMpTp',_0x54b485=>{const _0xd99a9=_0xfd5ed1;if(!SceneManager['isSceneBattle']())return;VisuMZ[_0xd99a9(0x1c5)](_0x54b485,_0x54b485);const _0x1741d5=VisuMZ[_0xd99a9(0x49d)](_0x54b485[_0xd99a9(0x7e3)]),_0x3418e0=_0x54b485[_0xd99a9(0x2bc)],_0x4d3e8b=_0x54b485[_0xd99a9(0x5c4)],_0x17f229=_0x54b485['MP_Rate'],_0x57f9cc=_0x54b485[_0xd99a9(0x7bb)],_0x4c7c91=_0x54b485[_0xd99a9(0x487)],_0x2be279=_0x54b485['TP_Flat'],_0x2390e0=_0x54b485['ShowPopup'];for(const _0x20c712 of _0x1741d5){if(_0xd99a9(0x4ca)===_0xd99a9(0x83c))this[_0xd99a9(0x4db)](_0x110124,'tp',_0x3ed22f+0x88*0x2+(_0x201eba['TpGaugeOffsetX']||0x0),_0x10ec0b+(_0x3ea828['TpGaugeOffsetY']||0x0));else{if(!_0x20c712)continue;const _0xdbb9c=_0x20c712['isAlive'](),_0x3d23d4=Math[_0xd99a9(0x271)](_0x3418e0*_0x20c712[_0xd99a9(0x9d9)]+_0x4d3e8b),_0x3becde=Math[_0xd99a9(0x271)](_0x17f229*_0x20c712['mmp']+_0x57f9cc),_0x4c729c=Math[_0xd99a9(0x271)](_0x4c7c91*_0x20c712[_0xd99a9(0x43a)]()+_0x2be279);if(_0x3d23d4!==0x0)_0x20c712[_0xd99a9(0x7c1)](_0x3d23d4);if(_0x3becde!==0x0)_0x20c712[_0xd99a9(0x363)](_0x3becde);if(_0x4c729c!==0x0)_0x20c712[_0xd99a9(0x234)](_0x4c729c);if(_0x2390e0)_0x20c712[_0xd99a9(0x397)]();_0xdbb9c&&_0x20c712[_0xd99a9(0x7b0)]()&&_0x20c712[_0xd99a9(0x8dd)]();}}}),PluginManager[_0xfd5ed1(0xbaf)](pluginData[_0xfd5ed1(0x452)],_0xfd5ed1(0xaa6),_0x5e8be6=>{const _0x50ac6c=_0xfd5ed1;if(!SceneManager[_0x50ac6c(0xbb7)]())return;VisuMZ[_0x50ac6c(0x1c5)](_0x5e8be6,_0x5e8be6);const _0x16335c=VisuMZ['CreateActionSequenceTargets'](_0x5e8be6[_0x50ac6c(0x7e3)]);for(const _0x58a886 of _0x16335c){if(_0x50ac6c(0x93a)==='uOJIg')return 0xa;else{if(!_0x58a886)continue;_0x58a886[_0x50ac6c(0x393)](_0x5e8be6[_0x50ac6c(0x1da)]);}}}),PluginManager['registerCommand'](pluginData[_0xfd5ed1(0x452)],_0xfd5ed1(0x691),_0x480adc=>{const _0x3b0949=_0xfd5ed1;if(!SceneManager['isSceneBattle']())return;VisuMZ[_0x3b0949(0x1c5)](_0x480adc,_0x480adc);const _0x36731e=BattleManager[_0x3b0949(0x2c6)],_0x942098={'criticalHitRate':_0x480adc[_0x3b0949(0x1cf)],'criticalHitFlat':_0x480adc[_0x3b0949(0x6e0)],'criticalDmgRate':_0x480adc[_0x3b0949(0x2a8)],'criticalDmgFlat':_0x480adc[_0x3b0949(0xa5d)],'damageRate':_0x480adc[_0x3b0949(0x515)],'damageFlat':_0x480adc['DamageFlat'],'hitRate':_0x480adc[_0x3b0949(0xacb)],'hitFlat':_0x480adc[_0x3b0949(0xa4e)]};_0x36731e['_multipliers']=_0x942098;}),PluginManager[_0xfd5ed1(0xbaf)](pluginData[_0xfd5ed1(0x452)],'ActSeq_Mechanics_OtbOrder',_0x26f336=>{const _0x59db1e=_0xfd5ed1;if(!SceneManager[_0x59db1e(0xbb7)]())return;if(!Imported[_0x59db1e(0xa7f)])return;if(!BattleManager[_0x59db1e(0xa19)]())return;VisuMZ['ConvertParams'](_0x26f336,_0x26f336);const _0x44025c=VisuMZ[_0x59db1e(0x49d)](_0x26f336['Targets']);for(const _0x1dd44e of _0x44025c){if('VaQEF'!==_0x59db1e(0x656))return[_0x5ef308][_0x59db1e(0x504)](_0x13083d);else{if(!_0x1dd44e)continue;let _0x23d204=_0x26f336[_0x59db1e(0x482)],_0xca95ee=_0x26f336[_0x59db1e(0xa82)],_0x3dfbc9=_0x26f336[_0x59db1e(0x9a9)];BattleManager[_0x59db1e(0x7ef)][_0x59db1e(0x4b6)](_0x1dd44e)?_0x23d204+=_0x3dfbc9:_0xca95ee+=_0x3dfbc9,BattleManager[_0x59db1e(0x29a)](_0x1dd44e,-_0x23d204,![]),BattleManager['turnOrderChangeOTB'](_0x1dd44e,-_0xca95ee,!![]);}}}),PluginManager['registerCommand'](pluginData[_0xfd5ed1(0x452)],'ActSeq_Mechanics_PtbAlterCost',_0x3f71cc=>{const _0x3d1665=_0xfd5ed1;if(!SceneManager[_0x3d1665(0xbb7)]())return;if(!Imported[_0x3d1665(0x23d)])return;if(!BattleManager['isPTB']())return;VisuMZ[_0x3d1665(0x1c5)](_0x3f71cc,_0x3f71cc);const _0x454833=BattleManager[_0x3d1665(0xb9a)][_0x3d1665(0x8aa)](),_0x14d879=_0x3f71cc[_0x3d1665(0x7f0)],_0x464bf9=_0x3f71cc[_0x3d1665(0x39a)]||_0x3d1665(0x1b5),_0x55561b=_0x3f71cc['alterType']||_0x3d1665(0x1b5),_0x20bc56=_0x3f71cc[_0x3d1665(0xacc)]||0x0,_0x320c9c=_0x3f71cc[_0x3d1665(0x708)]||0x0;(_0x454833[_0x3d1665(0x478)]()||_0x14d879)&&(_0x3d1665(0x17e)!==_0x3d1665(0x17e)?this[_0x3d1665(0x9e7)]():(_0x14d879&&(_0x3d1665(0x9fb)!=='dNXty'?(_0x454833[_0x3d1665(0x8b5)]=_0x454833['_ptbActionCost']||{},_0x454833[_0x3d1665(0x8b5)]['priority']=0x0):_0xde4651[_0x3d1665(0x82e)][_0x3d1665(0x3af)](_0x3d1665(0x522))),_0x454833[_0x3d1665(0x920)](_0x464bf9,_0x55561b,_0x20bc56,_0x320c9c)));}),PluginManager[_0xfd5ed1(0xbaf)](pluginData[_0xfd5ed1(0x452)],_0xfd5ed1(0x68b),_0x24c1d7=>{const _0xa160fe=_0xfd5ed1;if(!SceneManager[_0xa160fe(0xbb7)]())return;if(!Imported['VisuMZ_2_BattleSystemPTB'])return;if(!BattleManager[_0xa160fe(0x430)]())return;VisuMZ[_0xa160fe(0x1c5)](_0x24c1d7,_0x24c1d7);const _0x3cdcf9=BattleManager[_0xa160fe(0xb9a)]['friendsUnit']();let _0x57c442=Math[_0xa160fe(0x4d3)](_0x24c1d7[_0xa160fe(0x6bc)],0x0),_0x4d8e46=_0x3cdcf9[_0xa160fe(0x9d3)](),_0x45634e=_0x3cdcf9['getHalfActionsPTB']();while(_0x57c442--){if(_0xa160fe(0xb74)!==_0xa160fe(0xb5f)){if(_0x4d8e46<=0x0&&_0x45634e<=0x0)break;else{if(_0x4d8e46>0x0){if(_0xa160fe(0x1cd)===_0xa160fe(0x1cd))_0x4d8e46--,_0x45634e++;else{if(!_0x5c28ac[_0xa160fe(0xb27)]())return;const _0x490001=this[_0xa160fe(0x456)]();if(!_0x490001)return;_0x490001[_0xa160fe(0x225)](_0x54b52a,_0x3059c7,_0xfcfe78,_0x4d1a98);}}else _0x45634e--;}}else _0x5ddfff[_0xa160fe(0x1e9)][_0xa160fe(0x476)]['call'](this),this[_0xa160fe(0x798)]&&this[_0xa160fe(0x798)]['bitmap']&&this[_0xa160fe(0xbed)]&&(this[_0xa160fe(0x798)]['bitmap'][_0xa160fe(0x8d6)]!==this[_0xa160fe(0xbed)]['battlerSmoothImage']()&&(this[_0xa160fe(0x798)][_0xa160fe(0x86e)][_0xa160fe(0x8d6)]=this['_battler'][_0xa160fe(0xb46)]()));}_0x3cdcf9[_0xa160fe(0x2b6)](_0x4d8e46),_0x3cdcf9['setHalfActionsPTB'](_0x45634e);}),PluginManager['registerCommand'](pluginData['name'],_0xfd5ed1(0xb76),_0x56ddbd=>{const _0x218d62=_0xfd5ed1;if(!SceneManager['isSceneBattle']())return;if(!Imported[_0x218d62(0x23d)])return;if(!BattleManager[_0x218d62(0x430)]())return;VisuMZ[_0x218d62(0x1c5)](_0x56ddbd,_0x56ddbd);const _0x3b0a84=BattleManager[_0x218d62(0xb9a)][_0x218d62(0x8aa)]();let _0x4cb587=_0x56ddbd['FullActions'],_0x37da23=_0x56ddbd[_0x218d62(0x69d)];_0x3b0a84['gainFullActionsPTB'](_0x4cb587),_0x3b0a84[_0x218d62(0x40c)](_0x37da23);}),PluginManager[_0xfd5ed1(0xbaf)](pluginData[_0xfd5ed1(0x452)],_0xfd5ed1(0x53e),_0x525551=>{const _0x455563=_0xfd5ed1;if(!SceneManager[_0x455563(0xbb7)]())return;VisuMZ['ConvertParams'](_0x525551,_0x525551);const _0x2412bf=[_0x455563(0x236),'MAXMP',_0x455563(0x1f9),_0x455563(0x5b1),'MAT',_0x455563(0xbb6),_0x455563(0x4b5),_0x455563(0x587)],_0x1b47b7=_0x525551[_0x455563(0x51d)],_0x32fe69=_0x525551[_0x455563(0x4c6)],_0x53c718=VisuMZ['CreateActionSequenceTargets'](_0x525551[_0x455563(0x7e3)]);for(const _0x2f51ae of _0x53c718){if(!_0x2f51ae)continue;for(const _0x622a76 of _0x1b47b7){const _0x63741e=_0x2412bf[_0x455563(0x981)](_0x622a76[_0x455563(0xa50)]()[_0x455563(0x300)]());_0x63741e>=0x0&&_0x63741e<=0x7&&_0x2f51ae[_0x455563(0x3d0)](_0x63741e)&&_0x2f51ae[_0x455563(0x39e)](_0x63741e);}for(const _0x30d6b7 of _0x32fe69){if(_0x455563(0x1aa)!=='LpHgM'){const _0x4e17af=_0x2412bf[_0x455563(0x981)](_0x30d6b7[_0x455563(0xa50)]()[_0x455563(0x300)]());_0x4e17af>=0x0&&_0x4e17af<=0x7&&_0x2f51ae[_0x455563(0xb5a)](_0x4e17af)&&_0x2f51ae[_0x455563(0x39e)](_0x4e17af);}else this['_weaponImageId']=_0x4175df,this[_0x455563(0x350)]=-_0x2e86a4,this[_0x455563(0x7b9)]=_0x1d08c5,this[_0x455563(0x239)](),this[_0x455563(0x1d9)]();}}}),PluginManager['registerCommand'](pluginData[_0xfd5ed1(0x452)],_0xfd5ed1(0x467),_0x1fa85d=>{const _0xaece1f=_0xfd5ed1;if(!SceneManager[_0xaece1f(0xbb7)]())return;VisuMZ[_0xaece1f(0x1c5)](_0x1fa85d,_0x1fa85d);const _0x58b742=_0x1fa85d['States'],_0xf77dfc=VisuMZ[_0xaece1f(0x49d)](_0x1fa85d[_0xaece1f(0x7e3)]);for(const _0x5ef74c of _0xf77dfc){if(!_0x5ef74c)continue;for(const _0x4eb2fd of _0x58b742){_0x5ef74c[_0xaece1f(0xa2a)](_0x4eb2fd);}}}),PluginManager[_0xfd5ed1(0xbaf)](pluginData['name'],'ActSeq_Mechanics_StbExploit',_0x58c143=>{const _0x299df8=_0xfd5ed1;if(!SceneManager[_0x299df8(0xbb7)]())return;if(!Imported[_0x299df8(0xaae)])return;if(!BattleManager[_0x299df8(0xbf0)]())return;VisuMZ[_0x299df8(0x1c5)](_0x58c143,_0x58c143);const _0x357d88=_0x58c143['Exploited'],_0x96cb98=VisuMZ[_0x299df8(0x49d)](_0x58c143[_0x299df8(0x7e3)]),_0x309849=_0x58c143[_0x299df8(0x9c0)],_0x3c6926=_0x58c143['Exploiter'],_0xd59c11=_0x58c143[_0x299df8(0x551)],_0x30d21b=BattleManager[_0x299df8(0x2c6)];if(_0x357d88)for(const _0x29bcf0 of _0x96cb98){if(_0x299df8(0x95a)!==_0x299df8(0x95a))this[_0x299df8(0x758)]='';else{if(!_0x29bcf0)continue;if(_0x29bcf0===user)continue;if(_0x309849)_0x29bcf0[_0x299df8(0x63d)](![]);_0x29bcf0[_0x299df8(0x3c4)](BattleManager[_0x299df8(0xb9a)],_0x30d21b);}}if(_0x3c6926&&BattleManager[_0x299df8(0xb9a)]){if('FeaoI'!==_0x299df8(0x6f8))this['damageContainer']()[_0x299df8(0xaec)](_0x2342ce),this[_0x299df8(0x839)][_0x299df8(0x698)](_0x161c92),_0x3d4739[_0x299df8(0x681)]();else{if(_0xd59c11)BattleManager[_0x299df8(0xb9a)][_0x299df8(0x63d)](![]);const _0x33e052=_0x96cb98[0x0];BattleManager[_0x299df8(0x1a7)](_0x33e052,_0x30d21b);}}}),PluginManager[_0xfd5ed1(0xbaf)](pluginData[_0xfd5ed1(0x452)],'ActSeq_Mechanics_StbExtraAction',_0x4785e4=>{const _0x3966a1=_0xfd5ed1;if(!SceneManager['isSceneBattle']())return;if(!Imported[_0x3966a1(0xaae)])return;if(!BattleManager[_0x3966a1(0xbf0)]())return;VisuMZ['ConvertParams'](_0x4785e4,_0x4785e4);const _0x455d2a=_0x4785e4[_0x3966a1(0x7b2)];BattleManager[_0x3966a1(0xb9a)]&&BattleManager[_0x3966a1(0xb9a)][_0x3966a1(0xb65)](_0x455d2a);}),PluginManager[_0xfd5ed1(0xbaf)](pluginData[_0xfd5ed1(0x452)],_0xfd5ed1(0x6ee),_0x4e406a=>{const _0x4dc4e6=_0xfd5ed1;if(!SceneManager[_0x4dc4e6(0xbb7)]())return;if(!Imported[_0x4dc4e6(0xaae)])return;if(!BattleManager[_0x4dc4e6(0xbf0)]())return;VisuMZ[_0x4dc4e6(0x1c5)](_0x4e406a,_0x4e406a);let _0x2673c8=_0x4e406a['Actions'];if(BattleManager[_0x4dc4e6(0xb9a)]){BattleManager['_subject'][_0x4dc4e6(0x385)]=BattleManager[_0x4dc4e6(0xb9a)][_0x4dc4e6(0x385)]||[];while(_0x2673c8--){if(BattleManager[_0x4dc4e6(0xb9a)]['_actions']['length']<=0x0)break;BattleManager['_subject'][_0x4dc4e6(0x385)]['shift']();}}}),PluginManager['registerCommand'](pluginData[_0xfd5ed1(0x452)],'ActSeq_Mechanics_SwapWeapon',_0x2e4ceb=>{const _0x4689c3=_0xfd5ed1;if(!SceneManager[_0x4689c3(0xbb7)]())return;if(!Imported[_0x4689c3(0xa98)])return;VisuMZ[_0x4689c3(0x1c5)](_0x2e4ceb,_0x2e4ceb);const _0x4c4ae6=VisuMZ[_0x4689c3(0x49d)](_0x2e4ceb[_0x4689c3(0x7e3)]),_0x448e85=_0x2e4ceb['WeaponTypeID'];for(const _0x4131cd of _0x4c4ae6){if(_0x4689c3(0x659)!==_0x4689c3(0x432)){if(!_0x4131cd)continue;if(!_0x4131cd[_0x4689c3(0x75b)]())continue;_0x4131cd[_0x4689c3(0x4ec)](_0x448e85);}else _0x256058[_0x4689c3(0x263)][_0x4689c3(0x78f)][_0x4689c3(0x740)](this),this[_0x4689c3(0x2a6)]();}}),PluginManager[_0xfd5ed1(0xbaf)](pluginData[_0xfd5ed1(0x452)],_0xfd5ed1(0x8ad),_0x553617=>{const _0x21cf57=_0xfd5ed1;if(!SceneManager[_0x21cf57(0xbb7)]())return;VisuMZ[_0x21cf57(0x1c5)](_0x553617,_0x553617);const _0x2c9ee6=VisuMZ[_0x21cf57(0x49d)](_0x553617[_0x21cf57(0x7e3)]),_0x36f4ad=_0x553617[_0x21cf57(0x6de)],_0x4ba4de={'textColor':ColorManager[_0x21cf57(0xb1e)](_0x553617[_0x21cf57(0x822)]),'flashColor':_0x553617[_0x21cf57(0x211)],'flashDuration':_0x553617[_0x21cf57(0xa4f)]};for(const _0x1451cd of _0x2c9ee6){if(!_0x1451cd)continue;_0x1451cd['setupTextPopup'](_0x36f4ad,_0x4ba4de);}}),PluginManager['registerCommand'](pluginData['name'],_0xfd5ed1(0x507),_0x292b68=>{const _0x141866=_0xfd5ed1;if(!SceneManager['isSceneBattle']())return;VisuMZ['ConvertParams'](_0x292b68,_0x292b68);const _0x43f3c3=VisuMZ[_0x141866(0x49d)](_0x292b68[_0x141866(0x7e3)]);let _0x485138=$gameVariables[_0x141866(0x59a)](_0x292b68[_0x141866(0x8a9)]);Imported['VisuMZ_0_CoreEngine']&&_0x292b68[_0x141866(0x47e)]&&(_0x485138=VisuMZ['GroupDigits'](_0x485138));const _0x4c5d31=String(_0x485138),_0x164fbf={'textColor':ColorManager[_0x141866(0xb1e)](_0x292b68[_0x141866(0x822)]),'flashColor':_0x292b68['FlashColor'],'flashDuration':_0x292b68[_0x141866(0xa4f)]};for(const _0x4f0e35 of _0x43f3c3){if(!_0x4f0e35)continue;_0x4f0e35['setupTextPopup'](_0x4c5d31,_0x164fbf);}}),PluginManager['registerCommand'](pluginData[_0xfd5ed1(0x452)],_0xfd5ed1(0x6fc),_0x115ed3=>{const _0x1871f0=_0xfd5ed1;if(!SceneManager['isSceneBattle']())return;const _0xa97451=$gameTemp[_0x1871f0(0x58e)]();if(!_0xa97451)return;_0xa97451[_0x1871f0(0x7a6)](_0x1871f0(0xb99));}),PluginManager[_0xfd5ed1(0xbaf)](pluginData[_0xfd5ed1(0x452)],_0xfd5ed1(0x3a7),_0x245585=>{const _0x3bc05b=_0xfd5ed1;if(!SceneManager[_0x3bc05b(0xbb7)]())return;VisuMZ[_0x3bc05b(0x1c5)](_0x245585,_0x245585);const _0xb8d597=VisuMZ['CreateActionSequenceTargets'](_0x245585[_0x3bc05b(0x7e3)]);for(const _0x814e69 of _0xb8d597){if(_0x3bc05b(0x2d8)===_0x3bc05b(0x2d8)){if(!_0x814e69)continue;_0x814e69['clearFreezeMotion']();}else this['selectNextCommand']();}}),PluginManager[_0xfd5ed1(0xbaf)](pluginData[_0xfd5ed1(0x452)],_0xfd5ed1(0x36a),_0x55d87f=>{const _0x353372=_0xfd5ed1;if(!SceneManager['isSceneBattle']())return;VisuMZ[_0x353372(0x1c5)](_0x55d87f,_0x55d87f);const _0x2ca731=VisuMZ[_0x353372(0x49d)](_0x55d87f[_0x353372(0x7e3)]),_0x47e47f=_0x55d87f[_0x353372(0x354)][_0x353372(0x572)]()['trim'](),_0x40210b=_0x55d87f['ShowWeapon'],_0x5c34a5=_0x55d87f[_0x353372(0x831)];for(const _0x4398ca of _0x2ca731){if('ChOpW'===_0x353372(0x344)){if(!_0x4398ca)continue;_0x4398ca[_0x353372(0x5b5)](_0x47e47f,_0x40210b,_0x5c34a5);}else return this[_0x353372(0x9af)];}}),PluginManager['registerCommand'](pluginData[_0xfd5ed1(0x452)],_0xfd5ed1(0xb3a),_0x534975=>{const _0x272596=_0xfd5ed1;if(!SceneManager[_0x272596(0xbb7)]())return;VisuMZ[_0x272596(0x1c5)](_0x534975,_0x534975);const _0x550f6b=VisuMZ['CreateActionSequenceTargets'](_0x534975[_0x272596(0x7e3)]),_0xbe01e9=_0x534975[_0x272596(0x354)]['toLowerCase']()[_0x272596(0x300)](),_0x12027b=_0x534975[_0x272596(0x5a3)];for(const _0xbf929b of _0x550f6b){if(!_0xbf929b)continue;if(_0xbe01e9[_0x272596(0x9e4)](/ATTACK[ ](\d+)/i))_0xbf929b[_0x272596(0x9c3)](Number(RegExp['$1']));else _0xbe01e9===_0x272596(0x8c1)?_0xbf929b[_0x272596(0x45b)]():_0xbf929b[_0x272596(0x465)](_0xbe01e9);if(!_0x12027b)_0xbf929b[_0x272596(0x2e9)](0x0);else{if(_0x12027b&&[_0x272596(0xb1f),_0x272596(0x737),_0x272596(0x4ef)][_0x272596(0x4b6)](_0xbe01e9)){}}}}),PluginManager[_0xfd5ed1(0xbaf)](pluginData[_0xfd5ed1(0x452)],_0xfd5ed1(0x5d0),_0x367635=>{const _0x25494c=_0xfd5ed1;if(!SceneManager[_0x25494c(0xbb7)]())return;VisuMZ[_0x25494c(0x1c5)](_0x367635,_0x367635);const _0x3d7819=BattleManager['_action'];if(!_0x3d7819)return;if(!_0x3d7819[_0x25494c(0x3c7)]())return;const _0x99c717=VisuMZ[_0x25494c(0x49d)](_0x367635[_0x25494c(0x7e3)]);for(const _0x50a1f9 of _0x99c717){if(!_0x50a1f9)continue;_0x50a1f9[_0x25494c(0x871)](_0x3d7819);}}),PluginManager['registerCommand'](pluginData[_0xfd5ed1(0x452)],_0xfd5ed1(0x565),_0x1ef919=>{const _0x28d850=_0xfd5ed1;if(!SceneManager['isSceneBattle']())return;VisuMZ[_0x28d850(0x1c5)](_0x1ef919,_0x1ef919);const _0xafd070=VisuMZ[_0x28d850(0x49d)](_0x1ef919['Targets']);for(const _0x458fcf of _0xafd070){if(_0x28d850(0xa93)===_0x28d850(0x954))return _0x30164d[_0x28d850(0x858)]?this['targetDistortionSpritePosition'](_0x394d8e):_0x3bed96[_0x28d850(0x1e9)]['Sprite_Animation_targetSpritePosition'][_0x28d850(0x740)](this,_0x2eb4d8);else{if(!_0x458fcf)continue;if(!_0x458fcf[_0x28d850(0x456)]())continue;_0x458fcf[_0x28d850(0x456)]()['refreshMotion']();}}}),PluginManager[_0xfd5ed1(0xbaf)](pluginData[_0xfd5ed1(0x452)],_0xfd5ed1(0x76d),_0x392bbf=>{const _0x2a7c20=_0xfd5ed1;if(!SceneManager[_0x2a7c20(0xbb7)]())return;VisuMZ['ConvertParams'](_0x392bbf,_0x392bbf);const _0x669299=$gameTemp[_0x2a7c20(0x58e)](),_0x55b85d=_0x392bbf[_0x2a7c20(0x9c7)]*Sprite_Battler[_0x2a7c20(0x502)];_0x669299[_0x2a7c20(0x3f7)](_0x55b85d);}),PluginManager[_0xfd5ed1(0xbaf)](pluginData[_0xfd5ed1(0x452)],'ActSeq_Movement_BattleStep',_0x22644c=>{const _0x2cabb8=_0xfd5ed1;if(!SceneManager[_0x2cabb8(0xbb7)]())return;VisuMZ[_0x2cabb8(0x1c5)](_0x22644c,_0x22644c);const _0x422482=$gameTemp['getLastPluginCommandInterpreter'](),_0x167201=BattleManager[_0x2cabb8(0x2c6)];if(!_0x422482||!_0x167201)return;if(!_0x167201[_0x2cabb8(0x3c7)]())return;const _0x3ba6d0=VisuMZ[_0x2cabb8(0x49d)](_0x22644c[_0x2cabb8(0x7e3)]);for(const _0x51aee1 of _0x3ba6d0){if(!_0x51aee1)continue;_0x51aee1['performActionStart'](_0x167201);}if(_0x22644c[_0x2cabb8(0x867)])_0x422482['setWaitMode']('battleMove');}),PluginManager[_0xfd5ed1(0xbaf)](pluginData[_0xfd5ed1(0x452)],_0xfd5ed1(0xbe3),_0x284530=>{const _0x1591bf=_0xfd5ed1;if(!SceneManager['isSceneBattle']())return;if(!$gameSystem['isSideView']())return;VisuMZ['ConvertParams'](_0x284530,_0x284530);const _0xd5a1b4=VisuMZ[_0x1591bf(0x49d)](_0x284530[_0x1591bf(0x7e3)]);let _0x7fde2b=_0x284530[_0x1591bf(0x657)][_0x1591bf(0x9e4)](/back/i);for(const _0x2fda47 of _0xd5a1b4){if(!_0x2fda47)continue;if(_0x284530[_0x1591bf(0x657)]['match'](/rand/i))_0x7fde2b=Math[_0x1591bf(0xb38)](0x2);_0x2fda47['setBattlerFlip'](!!_0x7fde2b);}}),PluginManager['registerCommand'](pluginData[_0xfd5ed1(0x452)],_0xfd5ed1(0x81f),_0x2e918a=>{const _0x20ae0e=_0xfd5ed1;if(!SceneManager[_0x20ae0e(0xbb7)]())return;if(!$gameSystem[_0x20ae0e(0xb27)]())return;VisuMZ[_0x20ae0e(0x1c5)](_0x2e918a,_0x2e918a);const _0x42b5d8=VisuMZ[_0x20ae0e(0x49d)](_0x2e918a[_0x20ae0e(0x7e3)]);let _0x1ccba7=_0x2e918a[_0x20ae0e(0xa44)];const _0x3359e0=_0x2e918a[_0x20ae0e(0xab1)];for(const _0x45663e of _0x42b5d8){if(!_0x45663e)continue;let _0xb78c28=_0x45663e[_0x20ae0e(0x456)]()['_baseX'],_0x2036de=_0x45663e[_0x20ae0e(0x456)]()[_0x20ae0e(0x579)];if(_0x1ccba7[_0x20ae0e(0x9e4)](/home/i)){if(_0x20ae0e(0x8bd)!==_0x20ae0e(0x2c0))_0xb78c28=_0x45663e[_0x20ae0e(0x456)]()['_homeX'],_0x2036de=_0x45663e[_0x20ae0e(0x456)]()['_homeY'];else{const _0x340796=_0xa1b11a[_0x20ae0e(0x3dd)](_0x1ffa54);_0x340796['missed']=![],_0x340796['evaded']=![],_0x340796[_0x20ae0e(0x62d)]=0x0,this[_0x20ae0e(0x24b)][_0x20ae0e(0xbc8)](_0x340796);}}else{if(_0x1ccba7[_0x20ae0e(0x9e4)](/center/i)){if('wPkvX'==='xXvxE'){const _0x6077d9=_0x1cb773['BattleCore'][_0x20ae0e(0x607)][_0x20ae0e(0x9bf)],_0x2ee956=_0x49cd62[_0x20ae0e(0x82d)]?0x4:0x3,_0x72f608=_0x2ee956*0x80+(_0x2ee956-0x1)*0x8+0x4,_0x3830d4=this[_0x20ae0e(0x279)](_0x158c5f),_0x3bfc38=this[_0x20ae0e(0xaf4)](_0x1c9f19);let _0x56ea76=_0x3bfc38['x']+this[_0x20ae0e(0x65f)];_0x6077d9[_0x20ae0e(0xbc6)]?_0x56ea76=_0x3bfc38['x']+_0x1eb5fb['faceWidth']+0x8:_0x56ea76+=_0x3fa8ac['iconWidth'];const _0xf9cff7=_0x4994bf['round'](_0x15753c[_0x20ae0e(0x942)](_0x3bfc38['x']+_0x3bfc38[_0x20ae0e(0xb4a)]-_0x72f608,_0x56ea76)),_0x1c6922=_0x333848[_0x20ae0e(0x271)](_0x3bfc38['y']+(_0x3bfc38['height']-_0x87793a[_0x20ae0e(0x263)]['bitmapHeight']())/0x2),_0x5690bb=_0x6dac6d[_0x20ae0e(0x271)](_0xf9cff7-_0xda5f1[_0x20ae0e(0x4c3)]/0x2-0x4),_0x1402a4=_0x54ccf6[_0x20ae0e(0x271)](_0x3bfc38['y']+(_0x3bfc38[_0x20ae0e(0x8c6)]-_0x36224a[_0x20ae0e(0x581)])/0x2+_0xc781dd['iconHeight']/0x2);let _0x548d22=_0xf9cff7+0x88;const _0x2f3bea=_0x1c6922;this['placeTimeGauge'](_0x3830d4,_0xf9cff7-0x4+(_0x6077d9[_0x20ae0e(0x941)]||0x0),_0x1c6922+(_0x6077d9[_0x20ae0e(0x745)]||0x0)),this['placeActorName'](_0x3830d4,_0xf9cff7+(_0x6077d9['NameOffsetX']||0x0),_0x1c6922+(_0x6077d9[_0x20ae0e(0x7c6)]||0x0)),this[_0x20ae0e(0x6e3)](_0x3830d4,_0x5690bb+(_0x6077d9[_0x20ae0e(0x911)]||0x0),_0x1402a4+(_0x6077d9[_0x20ae0e(0x311)]||0x0)),this[_0x20ae0e(0x4db)](_0x3830d4,'hp',_0x548d22+0x88*0x0+(_0x6077d9[_0x20ae0e(0x849)]||0x0),_0x2f3bea+(_0x6077d9[_0x20ae0e(0x328)]||0x0)),this[_0x20ae0e(0x4db)](_0x3830d4,'mp',_0x548d22+0x88*0x1+(_0x6077d9[_0x20ae0e(0x80c)]||0x0),_0x2f3bea+(_0x6077d9[_0x20ae0e(0x7bc)]||0x0)),_0x586476[_0x20ae0e(0x82d)]&&this[_0x20ae0e(0x4db)](_0x3830d4,'tp',_0x548d22+0x88*0x2+(_0x6077d9[_0x20ae0e(0x9c5)]||0x0),_0x2f3bea+(_0x6077d9[_0x20ae0e(0xb52)]||0x0));}else _0xb78c28=Graphics[_0x20ae0e(0x9c4)]/0x2,_0x2036de=Graphics[_0x20ae0e(0xa52)]/0x2;}else _0x1ccba7[_0x20ae0e(0x9e4)](/point (\d+), (\d+)/i)&&(_0xb78c28=Number(RegExp['$1']),_0x2036de=Number(RegExp['$2']));}_0x45663e[_0x20ae0e(0x416)](Math[_0x20ae0e(0x271)](_0xb78c28),Math['round'](_0x2036de),!!_0x3359e0);}}),PluginManager[_0xfd5ed1(0xbaf)](pluginData['name'],'ActSeq_Movement_FaceTarget',_0x1e9ebd=>{const _0x5e62c9=_0xfd5ed1;if(!SceneManager[_0x5e62c9(0xbb7)]())return;if(!$gameSystem[_0x5e62c9(0xb27)]())return;VisuMZ['ConvertParams'](_0x1e9ebd,_0x1e9ebd);const _0x4d7fbd=VisuMZ[_0x5e62c9(0x49d)](_0x1e9ebd['Targets1']),_0x54b803=VisuMZ[_0x5e62c9(0x49d)](_0x1e9ebd[_0x5e62c9(0x402)]),_0x105b00=_0x54b803[_0x5e62c9(0x3ee)](_0x566f80=>_0x566f80&&_0x566f80['battler']()?_0x566f80['battler']()[_0x5e62c9(0x6f7)]:0x0)/(_0x54b803[_0x5e62c9(0x5b7)]||0x1),_0x3e6c00=_0x54b803[_0x5e62c9(0x3ee)](_0x4b7b4b=>_0x4b7b4b&&_0x4b7b4b[_0x5e62c9(0x456)]()?_0x4b7b4b[_0x5e62c9(0x456)]()['_baseY']:0x0)/(_0x54b803[_0x5e62c9(0x5b7)]||0x1),_0x2763c9=_0x1e9ebd[_0x5e62c9(0xab1)];for(const _0xdbd4ea of _0x4d7fbd){if(!_0xdbd4ea)continue;_0xdbd4ea['setBattlerFacePoint'](Math[_0x5e62c9(0x271)](_0x105b00),Math[_0x5e62c9(0x271)](_0x3e6c00),!!_0x2763c9);}}),PluginManager['registerCommand'](pluginData['name'],_0xfd5ed1(0xa07),_0x452680=>{const _0x5db306=_0xfd5ed1;if(!SceneManager[_0x5db306(0xbb7)]())return;VisuMZ[_0x5db306(0x1c5)](_0x452680,_0x452680);const _0x12e286=$gameTemp['getLastPluginCommandInterpreter'](),_0xd03641=VisuMZ['CreateActionSequenceTargets'](_0x452680['Targets']),_0x2da13a=_0x452680['Height'],_0x13ae1e=_0x452680[_0x5db306(0x86a)],_0x13f803=_0x452680[_0x5db306(0x74f)],_0x5234c6=_0x452680[_0x5db306(0x5eb)];if(!_0x12e286)return;for(const _0x107e26 of _0xd03641){if(_0x5db306(0x321)!=='HGGWQ')return;else{if(!_0x107e26)continue;_0x107e26[_0x5db306(0x35b)](_0x2da13a,_0x13ae1e,_0x13f803);}}if(_0x5234c6)_0x12e286[_0x5db306(0x7a6)]('battleFloat');}),PluginManager[_0xfd5ed1(0xbaf)](pluginData[_0xfd5ed1(0x452)],_0xfd5ed1(0x600),_0x1671ee=>{const _0x49ec7c=_0xfd5ed1;if(!SceneManager[_0x49ec7c(0xbb7)]())return;VisuMZ[_0x49ec7c(0x1c5)](_0x1671ee,_0x1671ee);const _0x478138=$gameTemp[_0x49ec7c(0x58e)]();if(!_0x478138)return;const _0x15cb63=VisuMZ[_0x49ec7c(0x49d)](_0x1671ee[_0x49ec7c(0x7e3)]);for(const _0x2b605a of _0x15cb63){if(!_0x2b605a)continue;_0x2b605a[_0x49ec7c(0xa35)]();}BattleManager[_0x49ec7c(0xb9a)]&&BattleManager['_subject'][_0x49ec7c(0x994)]();if(_0x1671ee[_0x49ec7c(0x867)])_0x478138[_0x49ec7c(0x7a6)](_0x49ec7c(0x6b3));}),PluginManager[_0xfd5ed1(0xbaf)](pluginData['name'],'ActSeq_Movement_Jump',_0x19f279=>{const _0x6cdb51=_0xfd5ed1;if(!SceneManager[_0x6cdb51(0xbb7)]())return;VisuMZ[_0x6cdb51(0x1c5)](_0x19f279,_0x19f279);const _0x343efd=$gameTemp[_0x6cdb51(0x58e)](),_0x12d921=VisuMZ['CreateActionSequenceTargets'](_0x19f279[_0x6cdb51(0x7e3)]),_0x295d4d=_0x19f279[_0x6cdb51(0x288)],_0x556f35=_0x19f279[_0x6cdb51(0x86a)],_0x4f8eeb=_0x19f279[_0x6cdb51(0x469)];if(!_0x343efd)return;for(const _0x8fedd6 of _0x12d921){if(_0x6cdb51(0x824)!==_0x6cdb51(0x4bb)){if(!_0x8fedd6)continue;_0x8fedd6[_0x6cdb51(0x99b)](_0x295d4d,_0x556f35);}else{const _0x4e9f02=/<BYPASS DAMAGE CAP>/i;if(this[_0x6cdb51(0x3c7)]()[_0x6cdb51(0x80f)][_0x6cdb51(0x9e4)](_0x4e9f02))return!![];if(this[_0x6cdb51(0x2f2)]()[_0x6cdb51(0x5ec)]()[_0x6cdb51(0x9d6)](_0x25aca9=>_0x25aca9&&_0x25aca9[_0x6cdb51(0x80f)]['match'](_0x4e9f02)))return!![];return!_0x3615b3['BattleCore'][_0x6cdb51(0x607)][_0x6cdb51(0x608)]['EnableDamageCap'];}}if(_0x4f8eeb)_0x343efd[_0x6cdb51(0x7a6)](_0x6cdb51(0x777));}),PluginManager[_0xfd5ed1(0xbaf)](pluginData[_0xfd5ed1(0x452)],_0xfd5ed1(0x787),_0x405132=>{const _0x5b80ed=_0xfd5ed1;if(!SceneManager['isSceneBattle']())return;if(!$gameSystem['isSideView']())return;VisuMZ[_0x5b80ed(0x1c5)](_0x405132,_0x405132);const _0x22af3a=$gameTemp[_0x5b80ed(0x58e)](),_0x2c2162=VisuMZ[_0x5b80ed(0x49d)](_0x405132[_0x5b80ed(0x7e3)]),_0x287f2a=_0x405132[_0x5b80ed(0x21f)],_0x889fb9=_0x405132[_0x5b80ed(0x18b)],_0xa6e304=_0x405132['DistanceY'],_0x252c2f=_0x405132[_0x5b80ed(0x86a)],_0x5cf933=_0x405132[_0x5b80ed(0x6ea)],_0x3571e6=_0x405132['EasingType'],_0x544504=_0x405132[_0x5b80ed(0x354)],_0x1a1373=_0x405132[_0x5b80ed(0x867)];if(!_0x22af3a)return;for(const _0x5be593 of _0x2c2162){if(_0x5b80ed(0x7cc)!==_0x5b80ed(0x7cc))this['_itemWindow'][_0x5b80ed(0x676)]();else{if(!_0x5be593)continue;let _0x4f4441=_0x889fb9,_0x5bdca5=_0xa6e304;if(_0x287f2a[_0x5b80ed(0x9e4)](/horz/i))_0x4f4441*=_0x5be593[_0x5b80ed(0x75b)]()?-0x1:0x1;if(_0x287f2a[_0x5b80ed(0x9e4)](/vert/i))_0x5bdca5*=_0x5be593[_0x5b80ed(0x75b)]()?-0x1:0x1;_0x5be593[_0x5b80ed(0x75e)](_0x4f4441,_0x5bdca5,_0x252c2f,_0x5cf933,_0x3571e6),_0x5be593[_0x5b80ed(0x465)](_0x544504);}}if(_0x1a1373)_0x22af3a[_0x5b80ed(0x7a6)]('battleMove');}),PluginManager[_0xfd5ed1(0xbaf)](pluginData[_0xfd5ed1(0x452)],_0xfd5ed1(0x216),_0x5af061=>{const _0x496954=_0xfd5ed1;if(!SceneManager[_0x496954(0xbb7)]())return;if(!$gameSystem['isSideView']())return;VisuMZ['ConvertParams'](_0x5af061,_0x5af061);const _0x436d3a=$gameTemp[_0x496954(0x58e)](),_0x2f6e0e=VisuMZ[_0x496954(0x49d)](_0x5af061[_0x496954(0x7e3)]),_0x583d3a=_0x5af061[_0x496954(0x25c)],_0x4cb95d=_0x5af061[_0x496954(0x4eb)],_0x593bc4=_0x5af061[_0x496954(0x1cc)],_0x50cd38=_0x5af061[_0x496954(0x5e2)],_0x1b1871=_0x5af061['Duration'],_0x19d5c1=_0x5af061[_0x496954(0x6ea)],_0xccb5e4=_0x5af061[_0x496954(0x74f)],_0x1e89a6=_0x5af061[_0x496954(0x354)],_0x104d0a=_0x5af061[_0x496954(0x867)];if(!_0x436d3a)return;for(const _0x197a19 of _0x2f6e0e){if(!_0x197a19)continue;let _0xe81649=_0x197a19[_0x496954(0x456)]()[_0x496954(0x6f7)],_0x1df490=_0x197a19[_0x496954(0x456)]()[_0x496954(0x579)];if(_0x583d3a[_0x496954(0x9e4)](/home/i)){if(_0x496954(0xa74)==='FORJc')_0xe81649=_0x197a19[_0x496954(0x456)]()[_0x496954(0xb80)],_0x1df490=_0x197a19[_0x496954(0x456)]()[_0x496954(0x79b)];else{if(!_0x442fc8[_0x496954(0xbb7)]())return;const _0x40c650=_0x4ee77c[_0x496954(0x58e)]();_0x40c650[_0x496954(0x7a6)](_0x496954(0xb63));}}else{if(_0x583d3a[_0x496954(0x9e4)](/center/i)){if(_0x496954(0x318)!=='KrYsQ'){if(!_0x3c0e70[_0x496954(0x1e9)][_0x496954(0x607)][_0x496954(0xbe6)]['ShowFailure'])return;_0x368785['BattleCore'][_0x496954(0x4ab)][_0x496954(0x740)](this,_0x4ae50e);}else _0xe81649=Graphics['boxWidth']/0x2,_0x1df490=Graphics[_0x496954(0xa52)]/0x2;}else _0x583d3a[_0x496954(0x9e4)](/point (\d+), (\d+)/i)&&('mjcqr'===_0x496954(0x309)?(this[_0x496954(0x677)](),this['_currentActor']=null,this[_0x496954(0xb75)]=![]):(_0xe81649=Number(RegExp['$1']),_0x1df490=Number(RegExp['$2'])));}if(_0x4cb95d[_0x496954(0x9e4)](/none/i))_0xe81649+=_0x593bc4,_0x1df490+=_0x50cd38;else{if(_0x4cb95d['match'](/horz/i)&&_0x4cb95d[_0x496954(0x9e4)](/vert/i)){if(_0x496954(0x4ad)!==_0x496954(0x24a))_0xe81649+=_0x197a19['isActor']()?-_0x593bc4:_0x593bc4,_0x1df490+=_0x197a19[_0x496954(0x75b)]()?-_0x50cd38:_0x50cd38;else{const _0x906d19=!!this[_0x496954(0x9df)];this[_0x496954(0x9df)]=_0x5f0b28,_0x906d19&&(this[_0x496954(0x75c)](),this[_0x496954(0x1ef)]());}}else{if(_0x4cb95d['match'](/horz/i))_0xe81649+=_0x197a19['isActor']()?-_0x593bc4:_0x593bc4,_0x1df490+=_0x50cd38;else _0x4cb95d['match'](/vert/i)&&(_0xe81649+=_0x593bc4,_0x1df490+=_0x197a19[_0x496954(0x75b)]()?-_0x50cd38:_0x50cd38);}}_0x197a19[_0x496954(0x6c5)](_0xe81649,_0x1df490,_0x1b1871,_0x19d5c1,_0xccb5e4,-0x1),_0x197a19[_0x496954(0x465)](_0x1e89a6);}if(_0x104d0a)_0x436d3a[_0x496954(0x7a6)](_0x496954(0x6b3));}),PluginManager[_0xfd5ed1(0xbaf)](pluginData['name'],_0xfd5ed1(0x8db),_0x2a201c=>{const _0x2965c3=_0xfd5ed1;if(!SceneManager['isSceneBattle']())return;if(!$gameSystem[_0x2965c3(0xb27)]())return;VisuMZ[_0x2965c3(0x1c5)](_0x2a201c,_0x2a201c);const _0x2bcaa3=$gameTemp[_0x2965c3(0x58e)](),_0x16d010=VisuMZ[_0x2965c3(0x49d)](_0x2a201c['Targets1']),_0x5d5066=VisuMZ['CreateActionSequenceTargets'](_0x2a201c['Targets2']),_0x45e413=_0x2a201c[_0x2965c3(0x3f0)];let _0x84428d=_0x2a201c[_0x2965c3(0xbc5)];const _0x4b2607=_0x2a201c[_0x2965c3(0x4eb)],_0x3c5d54=_0x2a201c[_0x2965c3(0x1cc)],_0x583a7a=_0x2a201c['OffsetY'],_0x2f1c3b=_0x2a201c[_0x2965c3(0x86a)],_0x15634b=_0x2a201c[_0x2965c3(0x6ea)],_0x5b2faa=_0x2a201c['EasingType'],_0xf57484=_0x2a201c[_0x2965c3(0x354)],_0x453f3f=_0x2a201c[_0x2965c3(0x867)],_0x4b5b63=Math[_0x2965c3(0x942)](..._0x5d5066[_0x2965c3(0x3ee)](_0xdf237f=>_0xdf237f['battler']()[_0x2965c3(0x6f7)]-_0xdf237f['battler']()['mainSpriteWidth']()/0x2)),_0x90c3fe=Math[_0x2965c3(0x4d3)](..._0x5d5066[_0x2965c3(0x3ee)](_0x33d68d=>_0x33d68d['battler']()[_0x2965c3(0x6f7)]+_0x33d68d[_0x2965c3(0x456)]()[_0x2965c3(0x1e5)]()/0x2)),_0x427671=Math[_0x2965c3(0x942)](..._0x5d5066[_0x2965c3(0x3ee)](_0x2f1f23=>_0x2f1f23[_0x2965c3(0x456)]()[_0x2965c3(0x579)]-_0x2f1f23[_0x2965c3(0x456)]()[_0x2965c3(0x5e5)]())),_0x50bc5c=Math[_0x2965c3(0x4d3)](..._0x5d5066[_0x2965c3(0x3ee)](_0x118cf9=>_0x118cf9[_0x2965c3(0x456)]()[_0x2965c3(0x579)])),_0x568b38=_0x5d5066[_0x2965c3(0x4af)](_0x62f456=>_0x62f456[_0x2965c3(0x75b)]())['length'],_0x5a2ebf=_0x5d5066[_0x2965c3(0x4af)](_0x3403f8=>_0x3403f8[_0x2965c3(0x73c)]())[_0x2965c3(0x5b7)];let _0xedd7ba=0x0,_0x3e3002=0x0;if(_0x45e413[_0x2965c3(0x9e4)](/front/i)){if('bXpcq'===_0x2965c3(0x46e)){const _0x5d840f=this[_0x2965c3(0xa5a)](_0x48970b,_0x5e5ab5);_0x5d840f['bitmap'][_0x2965c3(0x815)](_0x2d919f[_0x47e258],0x0,0x0,_0x579ab5,_0x230ef1,_0x2965c3(0x4aa)),_0x5d840f['x']=(_0xf98a68-(_0x471903['length']-0x1)/0x2)*_0x2753f4,_0x5d840f['dy']=-_0x31351e;}else _0xedd7ba=_0x568b38>=_0x5a2ebf?_0x4b5b63:_0x90c3fe;}else{if(_0x45e413[_0x2965c3(0x9e4)](/middle/i))_0xedd7ba=(_0x4b5b63+_0x90c3fe)/0x2,_0x84428d=-0x1;else _0x45e413[_0x2965c3(0x9e4)](/back/i)&&(_0xedd7ba=_0x568b38>=_0x5a2ebf?_0x90c3fe:_0x4b5b63);}if(_0x45e413[_0x2965c3(0x9e4)](/head/i))_0x3e3002=_0x427671;else{if(_0x45e413['match'](/center/i))_0x3e3002=(_0x427671+_0x50bc5c)/0x2;else _0x45e413[_0x2965c3(0x9e4)](/base/i)&&(_0x2965c3(0x25f)!==_0x2965c3(0x25f)?this['targetActionSet'](_0x1a43d4,_0x173f08,_0x3d431a):_0x3e3002=_0x50bc5c);}if(!_0x2bcaa3)return;for(const _0x3b65de of _0x16d010){if(_0x2965c3(0x687)===_0x2965c3(0x460))return _0x50c4d1(_0x4bdce6['$1'])||0x0;else{if(!_0x3b65de)continue;let _0x12659f=_0xedd7ba,_0x487d14=_0x3e3002;if(_0x4b2607[_0x2965c3(0x9e4)](/none/i))_0x12659f+=_0x3c5d54,_0x487d14+=_0x583a7a;else{if(_0x4b2607[_0x2965c3(0x9e4)](/horz/i)&&_0x4b2607[_0x2965c3(0x9e4)](/vert/i))_0x12659f+=_0x3b65de[_0x2965c3(0x75b)]()?-_0x3c5d54:_0x3c5d54,_0x487d14+=_0x3b65de[_0x2965c3(0x75b)]()?-_0x583a7a:_0x583a7a;else{if(_0x4b2607['match'](/horz/i))_0x2965c3(0x2e0)===_0x2965c3(0x7f6)?this[_0x2965c3(0x36d)]=_0xdceb20:(_0x12659f+=_0x3b65de[_0x2965c3(0x75b)]()?-_0x3c5d54:_0x3c5d54,_0x487d14+=_0x583a7a);else _0x4b2607[_0x2965c3(0x9e4)](/vert/i)&&('mxrRg'!==_0x2965c3(0x7c5)?(_0x12659f+=_0x3c5d54,_0x487d14+=_0x3b65de['isActor']()?-_0x583a7a:_0x583a7a):this['parseForcedGameTroopSettingsBattleCore'](_0x4d6b61[_0x2965c3(0x80f)]));}}_0x3b65de[_0x2965c3(0x6c5)](_0x12659f,_0x487d14,_0x2f1c3b,_0x15634b,_0x5b2faa,_0x84428d),_0x3b65de[_0x2965c3(0x465)](_0xf57484);}}if(_0x453f3f)_0x2bcaa3[_0x2965c3(0x7a6)](_0x2965c3(0x6b3));}),PluginManager[_0xfd5ed1(0xbaf)](pluginData[_0xfd5ed1(0x452)],_0xfd5ed1(0x3fb),_0x761332=>{const _0x4c7df9=_0xfd5ed1;if(!SceneManager[_0x4c7df9(0xbb7)]())return;VisuMZ['ConvertParams'](_0x761332,_0x761332);const _0xb6793a=$gameTemp[_0x4c7df9(0x58e)](),_0x272f87=VisuMZ[_0x4c7df9(0x49d)](_0x761332[_0x4c7df9(0x7e3)]),_0x315f8b=_0x761332[_0x4c7df9(0x42e)],_0x1b4182=_0x761332[_0x4c7df9(0x86a)],_0x463e7c=_0x761332['EasingType'],_0x4d4454=_0x761332[_0x4c7df9(0x8a8)];if(!_0xb6793a)return;for(const _0x45e48a of _0x272f87){if('EqHjE'!==_0x4c7df9(0x6b5)){if(!_0x45e48a)continue;_0x45e48a[_0x4c7df9(0x715)](_0x315f8b,_0x1b4182,_0x463e7c);}else return this['currentAction']()&&this[_0x4c7df9(0xab8)]()[_0x4c7df9(0x3c7)]()&&this[_0x4c7df9(0xab8)]()[_0x4c7df9(0xb32)]();}if(_0x4d4454)_0xb6793a[_0x4c7df9(0x7a6)](_0x4c7df9(0x785));}),PluginManager[_0xfd5ed1(0xbaf)](pluginData[_0xfd5ed1(0x452)],_0xfd5ed1(0x9e9),_0x2dc98c=>{const _0x2f102b=_0xfd5ed1;if(!SceneManager['isSceneBattle']())return;VisuMZ[_0x2f102b(0x1c5)](_0x2dc98c,_0x2dc98c);const _0x465a42=$gameTemp[_0x2f102b(0x58e)](),_0x20964e=VisuMZ[_0x2f102b(0x49d)](_0x2dc98c['Targets']),_0x3af4cb=_0x2dc98c[_0x2f102b(0x9eb)],_0x163c75=_0x2dc98c[_0x2f102b(0xa37)],_0x262182=_0x2dc98c[_0x2f102b(0x86a)],_0x55bd86=_0x2dc98c[_0x2f102b(0x74f)],_0x11f133=_0x2dc98c[_0x2f102b(0x34f)];if(!_0x465a42)return;for(const _0x50ce11 of _0x20964e){if(_0x2f102b(0x974)===_0x2f102b(0x52e)){if(!this[_0x2f102b(0x66a)]())return![];return _0x119cb6[_0x2f102b(0x1e9)][_0x2f102b(0x671)]['call'](this);}else{if(!_0x50ce11)continue;_0x50ce11[_0x2f102b(0x519)](_0x3af4cb,_0x163c75,_0x262182,_0x55bd86);}}if(_0x11f133)_0x465a42['setWaitMode']('battleGrow');}),PluginManager[_0xfd5ed1(0xbaf)](pluginData[_0xfd5ed1(0x452)],'ActSeq_Movement_Skew',_0x5c816e=>{const _0x3d2081=_0xfd5ed1;if(!SceneManager[_0x3d2081(0xbb7)]())return;VisuMZ[_0x3d2081(0x1c5)](_0x5c816e,_0x5c816e);const _0x12594f=$gameTemp[_0x3d2081(0x58e)](),_0x51d966=VisuMZ['CreateActionSequenceTargets'](_0x5c816e[_0x3d2081(0x7e3)]),_0x36d575=_0x5c816e[_0x3d2081(0x6bd)],_0xbd8a21=_0x5c816e[_0x3d2081(0x806)],_0x2f7e93=_0x5c816e[_0x3d2081(0x86a)],_0x122f9a=_0x5c816e['EasingType'],_0x2d8545=_0x5c816e['WaitForSkew'];if(!_0x12594f)return;for(const _0x37c70b of _0x51d966){if(!_0x37c70b)continue;_0x37c70b[_0x3d2081(0xa94)](_0x36d575,_0xbd8a21,_0x2f7e93,_0x122f9a);}if(_0x2d8545)_0x12594f[_0x3d2081(0x7a6)]('battleSpriteSkew');}),PluginManager[_0xfd5ed1(0xbaf)](pluginData[_0xfd5ed1(0x452)],_0xfd5ed1(0x7d6),_0x7ad233=>{const _0x4a8462=_0xfd5ed1;if(!SceneManager[_0x4a8462(0xbb7)]())return;VisuMZ[_0x4a8462(0x1c5)](_0x7ad233,_0x7ad233);const _0x30bd24=$gameTemp[_0x4a8462(0x58e)](),_0x494a16=VisuMZ[_0x4a8462(0x49d)](_0x7ad233[_0x4a8462(0x7e3)]),_0x1b2064=_0x7ad233[_0x4a8462(0x538)],_0x9d947a=_0x7ad233[_0x4a8462(0x86a)],_0xf4e443=_0x7ad233['EasingType'],_0x4d98ae=_0x7ad233[_0x4a8462(0xb67)],_0x44c738=_0x7ad233[_0x4a8462(0xb04)];if(!_0x30bd24)return;for(const _0x5f0e30 of _0x494a16){if(_0x4a8462(0x4e7)===_0x4a8462(0x544))this[_0x4a8462(0x67a)]();else{if(!_0x5f0e30)continue;_0x5f0e30[_0x4a8462(0xa8f)](_0x1b2064,_0x9d947a,_0xf4e443,_0x4d98ae);}}if(_0x44c738)_0x30bd24[_0x4a8462(0x7a6)](_0x4a8462(0x500));}),PluginManager[_0xfd5ed1(0xbaf)](pluginData['name'],_0xfd5ed1(0xb31),_0x497d62=>{const _0x4db5d6=_0xfd5ed1;if(!SceneManager[_0x4db5d6(0xbb7)]())return;const _0x48091a=$gameTemp['getLastPluginCommandInterpreter']();if(!_0x48091a)return;_0x48091a[_0x4db5d6(0x7a6)]('battleFloat');}),PluginManager[_0xfd5ed1(0xbaf)](pluginData['name'],_0xfd5ed1(0xa4b),_0x3978c6=>{const _0x2f28a3=_0xfd5ed1;if(!SceneManager['isSceneBattle']())return;const _0x14f99e=$gameTemp[_0x2f28a3(0x58e)]();if(!_0x14f99e)return;_0x14f99e[_0x2f28a3(0x7a6)](_0x2f28a3(0x777));}),PluginManager[_0xfd5ed1(0xbaf)](pluginData[_0xfd5ed1(0x452)],_0xfd5ed1(0x256),_0x4df974=>{const _0x46b320=_0xfd5ed1;if(!SceneManager['isSceneBattle']())return;const _0x2be871=$gameTemp['getLastPluginCommandInterpreter']();if(!_0x2be871)return;_0x2be871['setWaitMode'](_0x46b320(0x6b3));}),PluginManager[_0xfd5ed1(0xbaf)](pluginData[_0xfd5ed1(0x452)],_0xfd5ed1(0x6db),_0x23788e=>{const _0x20f472=_0xfd5ed1;if(!SceneManager[_0x20f472(0xbb7)]())return;const _0x45ef3d=$gameTemp[_0x20f472(0x58e)]();if(!_0x45ef3d)return;_0x45ef3d[_0x20f472(0x7a6)]('battleOpacity');}),PluginManager[_0xfd5ed1(0xbaf)](pluginData[_0xfd5ed1(0x452)],_0xfd5ed1(0x9d8),_0x4496d4=>{const _0x37bbe4=_0xfd5ed1;if(!SceneManager[_0x37bbe4(0xbb7)]())return;const _0x2bb60c=$gameTemp[_0x37bbe4(0x58e)]();if(!_0x2bb60c)return;_0x2bb60c[_0x37bbe4(0x7a6)]('battleGrow');}),PluginManager['registerCommand'](pluginData['name'],_0xfd5ed1(0xa05),_0x21e85f=>{const _0x1efa96=_0xfd5ed1;if(!SceneManager[_0x1efa96(0xbb7)]())return;const _0x46e108=$gameTemp[_0x1efa96(0x58e)]();if(!_0x46e108)return;_0x46e108[_0x1efa96(0x7a6)](_0x1efa96(0x495));}),PluginManager['registerCommand'](pluginData[_0xfd5ed1(0x452)],_0xfd5ed1(0x244),_0x29aa8a=>{const _0x1b16fd=_0xfd5ed1;if(!SceneManager[_0x1b16fd(0xbb7)]())return;const _0x1e2997=$gameTemp[_0x1b16fd(0x58e)]();if(!_0x1e2997)return;_0x1e2997[_0x1b16fd(0x7a6)]('battleSpin');}),PluginManager[_0xfd5ed1(0xbaf)](pluginData[_0xfd5ed1(0x452)],_0xfd5ed1(0x64d),_0x2a0666=>{const _0x215540=_0xfd5ed1;if(!SceneManager[_0x215540(0xbb7)]())return;if(!Imported['VisuMZ_3_ActSeqProjectiles'])return;VisuMZ['ConvertParams'](_0x2a0666,_0x2a0666);const _0x1c3e13=$gameTemp[_0x215540(0x58e)](),_0xb63834=_0x2a0666[_0x215540(0x22c)];if(!_0x1c3e13)return;const _0x3bb747=BattleManager[_0x215540(0xb41)];if(!_0x3bb747)return;_0x3bb747[_0x215540(0x982)](_0x2a0666);if(_0xb63834)_0x1c3e13[_0x215540(0x7a6)]('battleProjectiles');}),PluginManager[_0xfd5ed1(0xbaf)](pluginData[_0xfd5ed1(0x452)],_0xfd5ed1(0x3fa),_0x403586=>{const _0x680996=_0xfd5ed1;if(!SceneManager['isSceneBattle']())return;if(!Imported['VisuMZ_3_ActSeqProjectiles'])return;VisuMZ[_0x680996(0x1c5)](_0x403586,_0x403586);const _0x23d60a=$gameTemp[_0x680996(0x58e)](),_0x7e135f=_0x403586[_0x680996(0x22c)];if(!_0x23d60a)return;const _0x5e6c34=BattleManager[_0x680996(0xb41)];if(!_0x5e6c34)return;_0x5e6c34[_0x680996(0x982)](_0x403586);if(_0x7e135f)_0x23d60a[_0x680996(0x7a6)]('battleProjectiles');}),PluginManager['registerCommand'](pluginData['name'],'ActSeq_Projectile_Picture',_0x962d42=>{const _0x268884=_0xfd5ed1;if(!SceneManager[_0x268884(0xbb7)]())return;if(!Imported[_0x268884(0xa60)])return;VisuMZ[_0x268884(0x1c5)](_0x962d42,_0x962d42);const _0x1a7b08=$gameTemp[_0x268884(0x58e)](),_0x51683f=_0x962d42[_0x268884(0x22c)];if(!_0x1a7b08)return;const _0x16fabc=BattleManager[_0x268884(0xb41)];if(!_0x16fabc)return;_0x16fabc[_0x268884(0x982)](_0x962d42);if(_0x51683f)_0x1a7b08[_0x268884(0x7a6)](_0x268884(0x748));}),PluginManager[_0xfd5ed1(0xbaf)](pluginData['name'],'ActSeq_ChangeSkew',_0x92370=>{const _0x1d5298=_0xfd5ed1;if(!SceneManager[_0x1d5298(0xbb7)]())return;if(!Imported[_0x1d5298(0x450)])return;VisuMZ['ConvertParams'](_0x92370,_0x92370);const _0x4cf0b0=$gameTemp[_0x1d5298(0x58e)](),_0x16a964=_0x92370['WaitForSkew'];if(!_0x4cf0b0)return;$gameScreen[_0x1d5298(0x750)](_0x92370[_0x1d5298(0x6bd)],_0x92370[_0x1d5298(0x806)],_0x92370['Duration'],_0x92370['EasingType']);if(_0x16a964)_0x4cf0b0['setWaitMode'](_0x1d5298(0x89c));}),PluginManager[_0xfd5ed1(0xbaf)](pluginData[_0xfd5ed1(0x452)],_0xfd5ed1(0x92b),_0x4ca1c2=>{const _0x106be5=_0xfd5ed1;if(!SceneManager[_0x106be5(0xbb7)]())return;if(!Imported[_0x106be5(0x450)])return;VisuMZ['ConvertParams'](_0x4ca1c2,_0x4ca1c2);const _0x5353a8=$gameTemp[_0x106be5(0x58e)](),_0x5b926a=_0x4ca1c2[_0x106be5(0x617)];if(!_0x5353a8)return;$gameScreen[_0x106be5(0x750)](0x0,0x0,_0x4ca1c2[_0x106be5(0x86a)],_0x4ca1c2[_0x106be5(0x74f)]);if(_0x5b926a)_0x5353a8[_0x106be5(0x7a6)](_0x106be5(0x89c));}),PluginManager[_0xfd5ed1(0xbaf)](pluginData[_0xfd5ed1(0x452)],_0xfd5ed1(0x555),_0x4115e6=>{const _0x47bb18=_0xfd5ed1;if(!SceneManager[_0x47bb18(0xbb7)]())return;if(!Imported['VisuMZ_3_ActSeqCamera'])return;const _0x1fa680=$gameTemp[_0x47bb18(0x58e)]();if(!_0x1fa680)return;_0x1fa680['setWaitMode']('battleSkew');}),PluginManager[_0xfd5ed1(0xbaf)](pluginData[_0xfd5ed1(0x452)],_0xfd5ed1(0x1e8),_0x4bf7ef=>{const _0x219807=_0xfd5ed1;if(!SceneManager[_0x219807(0xbb7)]())return;VisuMZ[_0x219807(0x1c5)](_0x4bf7ef,_0x4bf7ef);const _0x2cc5d1=$gameTemp[_0x219807(0x58e)](),_0x582766=_0x4bf7ef[_0x219807(0x900)],_0xbb5d41=_0x4bf7ef[_0x219807(0x2f6)];if(!_0x2cc5d1)return;BattleManager['_targetIndex']=_0x582766,BattleManager[_0x219807(0x235)]=BattleManager[_0x219807(0x377)]?BattleManager[_0x219807(0x377)][BattleManager[_0x219807(0xbdc)]]||null:null,BattleManager[_0x219807(0x235)]&&_0xbb5d41[_0x219807(0xa50)]()[_0x219807(0x300)]()!=='UNTITLED'&&(_0x219807(0xb8f)!==_0x219807(0xbdb)?_0x2cc5d1['command119']([_0xbb5d41]):_0xa848af[_0x219807(0x39e)](_0x2e463b));}),PluginManager['registerCommand'](pluginData['name'],_0xfd5ed1(0x805),_0x1b0a63=>{const _0x50be4c=_0xfd5ed1;if(!SceneManager[_0x50be4c(0xbb7)]())return;VisuMZ[_0x50be4c(0x1c5)](_0x1b0a63,_0x1b0a63);const _0x4f88e0=$gameTemp[_0x50be4c(0x58e)](),_0x369589=_0x1b0a63[_0x50be4c(0x2f6)];if(!_0x4f88e0)return;BattleManager[_0x50be4c(0xbdc)]++,BattleManager[_0x50be4c(0x235)]=BattleManager[_0x50be4c(0x377)][BattleManager[_0x50be4c(0xbdc)]]||null;if(BattleManager[_0x50be4c(0x235)]&&_0x369589['toUpperCase']()[_0x50be4c(0x300)]()!==_0x50be4c(0x183)){if('oXbvg'===_0x50be4c(0x5e6))return this[_0x50be4c(0x707)](_0x50be4c(0xae7));else _0x4f88e0[_0x50be4c(0x904)]([_0x369589]);}}),PluginManager[_0xfd5ed1(0xbaf)](pluginData['name'],_0xfd5ed1(0x22d),_0x233ddb=>{const _0x40bea2=_0xfd5ed1;if(!SceneManager[_0x40bea2(0xbb7)]())return;VisuMZ['ConvertParams'](_0x233ddb,_0x233ddb);const _0x5159c6=$gameTemp[_0x40bea2(0x58e)](),_0x1f75ff=_0x233ddb[_0x40bea2(0x2f6)];if(!_0x5159c6)return;BattleManager[_0x40bea2(0xbdc)]--,BattleManager['_target']=BattleManager['_allTargets'][BattleManager[_0x40bea2(0xbdc)]]||null,BattleManager['_target']&&_0x1f75ff[_0x40bea2(0xa50)]()[_0x40bea2(0x300)]()!==_0x40bea2(0x183)&&_0x5159c6[_0x40bea2(0x904)]([_0x1f75ff]);}),PluginManager[_0xfd5ed1(0xbaf)](pluginData[_0xfd5ed1(0x452)],'ActSeq_Target_RandTarget',_0x21b88a=>{const _0x2bc5f4=_0xfd5ed1;if(!SceneManager[_0x2bc5f4(0xbb7)]())return;VisuMZ['ConvertParams'](_0x21b88a,_0x21b88a);const _0x4e4855=$gameTemp[_0x2bc5f4(0x58e)](),_0x29b619=_0x21b88a[_0x2bc5f4(0x462)],_0xca86a6=_0x21b88a[_0x2bc5f4(0x2f6)];if(!_0x4e4855)return;const _0xd09d40=BattleManager['_targetIndex'];for(;;){if(_0x2bc5f4(0x473)!==_0x2bc5f4(0x473))return _0x444fee['aliveMembers']()[_0x2bc5f4(0x4af)](_0x3f3ab1=>_0x3f3ab1!==_0x11d691);else{BattleManager[_0x2bc5f4(0xbdc)]=Math[_0x2bc5f4(0xb38)](BattleManager[_0x2bc5f4(0x377)][_0x2bc5f4(0x5b7)]);if(!_0x29b619)break;if(BattleManager[_0x2bc5f4(0xbdc)]!==_0xd09d40)break;if(BattleManager[_0x2bc5f4(0x377)][_0x2bc5f4(0x5b7)]<=0x1){BattleManager['_targetIndex']=0x0;break;}}}BattleManager[_0x2bc5f4(0x235)]=BattleManager['_allTargets'][BattleManager[_0x2bc5f4(0xbdc)]]||null,BattleManager['_target']&&_0xca86a6[_0x2bc5f4(0xa50)]()[_0x2bc5f4(0x300)]()!=='UNTITLED'&&(_0x2bc5f4(0x1eb)===_0x2bc5f4(0x1eb)?_0x4e4855['command119']([_0xca86a6]):this[_0x2bc5f4(0xb7f)]());}),PluginManager[_0xfd5ed1(0xbaf)](pluginData[_0xfd5ed1(0x452)],_0xfd5ed1(0x4ee),_0x3fc024=>{const _0x1eada7=_0xfd5ed1;if(!SceneManager[_0x1eada7(0xbb7)]())return;VisuMZ[_0x1eada7(0x1c5)](_0x3fc024,_0x3fc024);const _0x17ecd4=VisuMZ['CreateActionSequenceTargets'](_0x3fc024['Targets']);for(const _0x37f77d of _0x17ecd4){if(!_0x37f77d)continue;if(!_0x37f77d['isActor']())continue;_0x37f77d[_0x1eada7(0x2dd)]();}}),PluginManager[_0xfd5ed1(0xbaf)](pluginData[_0xfd5ed1(0x452)],'ActSeq_Weapon_NextActiveWeapon',_0xdcc1bb=>{const _0x102ea3=_0xfd5ed1;if(!SceneManager['isSceneBattle']())return;VisuMZ['ConvertParams'](_0xdcc1bb,_0xdcc1bb);const _0xdf1b0d=$gameTemp[_0x102ea3(0x58e)]();let _0x197ce3=![];const _0x3393c5=_0xdcc1bb[_0x102ea3(0x2f6)],_0xa79ed7=VisuMZ[_0x102ea3(0x49d)](_0xdcc1bb['Targets']);for(const _0x387c50 of _0xa79ed7){if(!_0x387c50)continue;if(!_0x387c50[_0x102ea3(0x75b)]())continue;_0x387c50[_0x102ea3(0x97d)](),_0x387c50[_0x102ea3(0x4a9)]()[_0x102ea3(0x5b7)]>0x0?_0x197ce3=!![]:'ePGyL'!=='USWUL'?_0x387c50[_0x102ea3(0x2dd)]():(_0x460b5f+=_0x309395[_0x102ea3(0x75b)]()?-_0x402bbc:_0x5db6aa,_0x5de587+=_0x27660d);}_0x197ce3&&_0x3393c5['toUpperCase']()['trim']()!=='UNTITLED'&&(_0x102ea3(0x33e)===_0x102ea3(0x33e)?_0xdf1b0d[_0x102ea3(0x904)]([_0x3393c5]):(this['_battlerContainer']['children']['sort'](this[_0x102ea3(0x2c8)][_0x102ea3(0xa12)](this)),this[_0x102ea3(0xace)]()));}),PluginManager[_0xfd5ed1(0xbaf)](pluginData[_0xfd5ed1(0x452)],_0xfd5ed1(0xa18),_0x4f1908=>{const _0x516523=_0xfd5ed1;if(!SceneManager[_0x516523(0xbb7)]())return;VisuMZ[_0x516523(0x1c5)](_0x4f1908,_0x4f1908);let _0x508805=_0x4f1908[_0x516523(0x4d8)];_0x508805--,_0x508805=Math[_0x516523(0x4d3)](_0x508805,0x0);const _0xb0cbf5=VisuMZ[_0x516523(0x49d)](_0x4f1908[_0x516523(0x7e3)]);for(const _0x53829d of _0xb0cbf5){if(!_0x53829d)continue;if(!_0x53829d[_0x516523(0x75b)]())continue;_0x53829d[_0x516523(0x5e7)](_0x508805);}}),PluginManager[_0xfd5ed1(0xbaf)](pluginData[_0xfd5ed1(0x452)],_0xfd5ed1(0xb8a),_0x3e9949=>{const _0x46135e=_0xfd5ed1;if(!SceneManager[_0x46135e(0xbb7)]())return;if(!Imported['VisuMZ_3_ActSeqCamera'])return;VisuMZ[_0x46135e(0x1c5)](_0x3e9949,_0x3e9949);const _0x43d4c4=$gameTemp['getLastPluginCommandInterpreter'](),_0x448025=_0x3e9949['WaitForZoom'];if(!_0x43d4c4)return;$gameScreen[_0x46135e(0xa02)](_0x3e9949['Scale'],_0x3e9949['Duration'],_0x3e9949[_0x46135e(0x74f)]);if(_0x448025)_0x43d4c4[_0x46135e(0x7a6)](_0x46135e(0x931));}),PluginManager['registerCommand'](pluginData[_0xfd5ed1(0x452)],_0xfd5ed1(0x219),_0x24aa65=>{const _0x18b23c=_0xfd5ed1;if(!SceneManager[_0x18b23c(0xbb7)]())return;if(!Imported[_0x18b23c(0x450)])return;VisuMZ['ConvertParams'](_0x24aa65,_0x24aa65);const _0x2e5f5e=$gameTemp[_0x18b23c(0x58e)](),_0x2e4493=_0x24aa65['WaitForZoom'];if(!_0x2e5f5e)return;$gameScreen['setBattleZoom'](0x1,_0x24aa65[_0x18b23c(0x86a)],_0x24aa65[_0x18b23c(0x74f)]);if(_0x2e4493)_0x2e5f5e['setWaitMode'](_0x18b23c(0x931));}),PluginManager[_0xfd5ed1(0xbaf)](pluginData[_0xfd5ed1(0x452)],_0xfd5ed1(0x4d2),_0xa477f3=>{const _0x11473e=_0xfd5ed1;if(!SceneManager[_0x11473e(0xbb7)]())return;if(!Imported[_0x11473e(0x450)])return;const _0xb27f9=$gameTemp[_0x11473e(0x58e)]();if(!_0xb27f9)return;_0xb27f9[_0x11473e(0x7a6)](_0x11473e(0x931));}),VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0xb5c)]=Scene_Boot[_0xfd5ed1(0x263)]['onDatabaseLoaded'],Scene_Boot[_0xfd5ed1(0x263)][_0xfd5ed1(0x71a)]=function(){const _0x2281b1=_0xfd5ed1;this['process_VisuMZ_BattleCore_Failsafes'](),this[_0x2281b1(0xa7e)](),this[_0x2281b1(0xa15)](),this[_0x2281b1(0x8ff)](),VisuMZ[_0x2281b1(0x1e9)][_0x2281b1(0xb5c)][_0x2281b1(0x740)](this),this['process_VisuMZ_BattleCore_Notetags'](),this[_0x2281b1(0x62f)](),this[_0x2281b1(0x56c)](),this[_0x2281b1(0x5b2)]();},Scene_Boot[_0xfd5ed1(0x263)][_0xfd5ed1(0x2a5)]=function(){const _0x226485=_0xfd5ed1;if(VisuMZ[_0x226485(0x4b0)])return;this[_0x226485(0x19f)](),this['process_VisuMZ_BattleCore_TraitObject_Notetags'](),this[_0x226485(0xaea)]();},Scene_Boot[_0xfd5ed1(0x263)][_0xfd5ed1(0x50c)]=function(){const _0x152e41=_0xfd5ed1,_0x2766b8=$dataSystem[_0x152e41(0xabf)][_0x152e41(0x5b7)];for(let _0x87cc46=0x0;_0x87cc46<_0x2766b8;_0x87cc46++){const _0x36efe2=$dataSystem[_0x152e41(0x576)][_0x87cc46];if(_0x36efe2)continue;$dataSystem[_0x152e41(0x576)][_0x87cc46]=JsonEx[_0x152e41(0x3dd)]($dataSystem[_0x152e41(0x576)][0x0]);}},Scene_Boot[_0xfd5ed1(0x263)][_0xfd5ed1(0xa7e)]=function(){const _0x19f83f=_0xfd5ed1,_0x4c440c=VisuMZ[_0x19f83f(0x1e9)][_0x19f83f(0x607)];_0x4c440c[_0x19f83f(0x608)][_0x19f83f(0x4d4)]===undefined&&(_0x4c440c[_0x19f83f(0x608)][_0x19f83f(0x4d4)]=_0x19f83f(0x43c));if(_0x4c440c[_0x19f83f(0xbdf)]['SmoothImage']===undefined){if(_0x19f83f(0x7bf)===_0x19f83f(0x766)){if(this['constructor']===_0x3b07ae)return;this[_0x19f83f(0x228)](),this[_0x19f83f(0x499)]();}else _0x4c440c[_0x19f83f(0xbdf)][_0x19f83f(0xa38)]=![];}_0x4c440c[_0x19f83f(0x1f5)][_0x19f83f(0xa38)]===undefined&&(_0x4c440c[_0x19f83f(0x1f5)][_0x19f83f(0xa38)]=!![]);if(_0x4c440c[_0x19f83f(0xbdf)]['PrioritySortActive']===undefined){if(_0x19f83f(0x4c2)!==_0x19f83f(0x4c2))return 0x0;else _0x4c440c[_0x19f83f(0xbdf)][_0x19f83f(0x3c8)]=![];}_0x4c440c[_0x19f83f(0xbdf)]['PrioritySortActors']===undefined&&(_0x4c440c[_0x19f83f(0xbdf)][_0x19f83f(0x89a)]=!![]);},VisuMZ['DamageStyles']={},Scene_Boot[_0xfd5ed1(0x263)]['process_VisuMZ_BattleCore_DamageStyles']=function(){const _0x5b7686=_0xfd5ed1;for(const _0x25d654 of VisuMZ['BattleCore'][_0x5b7686(0x607)][_0x5b7686(0x608)]['DamageStyleList']){if(_0x5b7686(0xb15)===_0x5b7686(0x401)){if(!_0x33e64e[_0x5b7686(0xbb7)]())return;if(!_0xb8ca29['VisuMZ_3_ActSeqCamera'])return;_0x45da29[_0x5b7686(0x1c5)](_0x440990,_0x20c9ee);const _0xeaaa13=_0x51d867[_0x5b7686(0x58e)](),_0xc786d9=_0x5c9dd5[_0x5b7686(0xb95)];if(!_0xeaaa13)return;_0x3c6328['setBattleZoom'](0x1,_0x23cc2f['Duration'],_0x2b6acb[_0x5b7686(0x74f)]);if(_0xc786d9)_0xeaaa13[_0x5b7686(0x7a6)](_0x5b7686(0x931));}else{if(!_0x25d654)continue;const _0x37d2ca=_0x25d654[_0x5b7686(0xa00)][_0x5b7686(0xa50)]()[_0x5b7686(0x300)]();VisuMZ['DamageStyles'][_0x37d2ca]=_0x25d654;}}},VisuMZ[_0xfd5ed1(0x1e9)]['RegExp']={},Scene_Boot[_0xfd5ed1(0x263)]['process_VisuMZ_BattleCore_CreateRegExp']=function(){const _0x15599d=_0xfd5ed1,_0x5753f8=VisuMZ[_0x15599d(0x1e9)][_0x15599d(0x349)],_0x52312e=_0x15599d(0xb58),_0x3ff171=[[_0x15599d(0x8ef),_0x15599d(0x8cf)],[_0x15599d(0x2c4),_0x15599d(0x380)]],_0x5a55f5=[[_0x15599d(0x596),_0x15599d(0xa5f)],[_0x15599d(0x679),'JS\x20%1DAMAGE\x20%2']],_0x338ce4=[['',''],[_0x15599d(0x7a3),_0x15599d(0x9ea)],[_0x15599d(0x46f),_0x15599d(0xbae)]];for(const _0x2a5c57 of _0x5a55f5){for(const _0x31e493 of _0x338ce4){for(const _0x422558 of _0x3ff171){if(_0x15599d(0x721)!==_0x15599d(0x51b)){const _0x5e2cb7=_0x2a5c57[0x0]['format'](_0x422558[0x0],_0x31e493[0x0]),_0x6ffedd=_0x2a5c57[0x1][_0x15599d(0x222)](_0x422558[0x1],_0x31e493[0x1])[_0x15599d(0x300)](),_0x25aace=new RegExp(_0x52312e[_0x15599d(0x222)](_0x6ffedd),'i');_0x5753f8[_0x5e2cb7]=_0x25aace;}else return[_0x2761ff];}}}const _0x2ac227=[[_0x15599d(0x726),'JS\x20%1START\x20ACTION'],[_0x15599d(0xb78),_0x15599d(0x8de)]];for(const _0x53706c of _0x2ac227){if('aYImN'===_0x15599d(0x3b5)){if(_0x51a1e7[_0x15599d(0x4b2)]===0x0)this[_0x15599d(0x465)](_0x15599d(0xb1f));else{if(_0x2fab0f['type']===0x1)this[_0x15599d(0x465)](_0x15599d(0x737));else _0x102156[_0x15599d(0x4b2)]===0x2&&this[_0x15599d(0x465)]('missile');}this[_0x15599d(0x2e9)](_0x335c5a[_0x15599d(0x875)]);}else for(const _0x582cee of _0x3ff171){const _0x4795d4=_0x53706c[0x0]['format'](_0x582cee[0x0]),_0xdbf166=_0x53706c[0x1][_0x15599d(0x222)](_0x582cee[0x1]),_0x1646b0=new RegExp(_0x52312e['format'](_0xdbf166),'i');_0x5753f8[_0x4795d4]=_0x1646b0;}}const _0x367304=[['%1StartBattleJS','JS\x20%1START\x20BATTLE'],['%1EndBattleJS',_0x15599d(0x9b0)],[_0x15599d(0xa85),'JS\x20BATTLE\x20VICTORY'],[_0x15599d(0x634),'JS\x20BATTLE\x20DEFEAT'],[_0x15599d(0x79a),_0x15599d(0x34b)],['EscapeFailureJS',_0x15599d(0x539)],['%1StartTurnJS',_0x15599d(0x5c8)],['%1EndTurnJS',_0x15599d(0x374)],['%1RegenerateJS',_0x15599d(0x2f0)]];for(const _0x3ac469 of _0x367304){if(_0x15599d(0x940)!==_0x15599d(0x94c))for(const _0x48651 of _0x3ff171){const _0x3fa80d=_0x3ac469[0x0][_0x15599d(0x222)](_0x48651[0x0]),_0x584e3a=_0x3ac469[0x1][_0x15599d(0x222)](_0x48651[0x1]),_0x4be32d=new RegExp(_0x52312e[_0x15599d(0x222)](_0x584e3a),'i');_0x5753f8[_0x3fa80d]=_0x4be32d;}else{const _0x187517=this[_0x15599d(0x1f2)](_0x29725a);this['drawActorFace'](_0x1c7dde,_0x187517['x'],_0x187517['y'],_0x187517[_0x15599d(0xb4a)],_0x187517['height']);}}},Scene_Boot['prototype'][_0xfd5ed1(0x19f)]=function(){const _0x1d8b4d=_0xfd5ed1,_0x1e46ed=$dataSkills[_0x1d8b4d(0x504)]($dataItems);for(const _0x136215 of _0x1e46ed){if(!_0x136215)continue;VisuMZ[_0x1d8b4d(0x1e9)]['Parse_Notetags_Action'](_0x136215);}},Scene_Boot[_0xfd5ed1(0x263)]['process_VisuMZ_BattleCore_TraitObject_Notetags']=function(){const _0x318e32=_0xfd5ed1,_0x535f7d=$dataActors[_0x318e32(0x504)]($dataClasses,$dataWeapons,$dataArmors,$dataEnemies,$dataStates);for(const _0x34fe32 of _0x535f7d){if(_0x318e32(0x7e6)===_0x318e32(0x2e5))this[_0x318e32(0x359)]['x']=this[_0x318e32(0xb4a)],this[_0x318e32(0x81d)]=this['width']*0x3/0x4;else{if(!_0x34fe32)continue;VisuMZ[_0x318e32(0x1e9)][_0x318e32(0x5c9)](_0x34fe32);}}},Scene_Boot[_0xfd5ed1(0x263)][_0xfd5ed1(0x62f)]=function(){const _0x152ded=_0xfd5ed1,_0x5cfa91=VisuMZ[_0x152ded(0x1e9)]['Settings'][_0x152ded(0x6d8)][_0x152ded(0x250)],_0xa781bc=[];for(const _0x503c7d of _0x5cfa91){if('xfTmb'!=='zMsHJ'){const _0xfbb94=$dataTroops[_0x503c7d];if(_0xfbb94)_0xa781bc[_0x152ded(0xbc8)](JsonEx[_0x152ded(0x3dd)](_0xfbb94));}else{_0x3ce931['prototype'][_0x152ded(0x840)][_0x152ded(0x740)](this),this[_0x152ded(0x664)](),this['updateEffectContainers']();if(this[_0x152ded(0xb2d)]()===_0x152ded(0x9cf))this[_0x152ded(0x3b2)]();}}for(const _0x32de09 of $dataTroops){if(_0x152ded(0xb13)===_0x152ded(0x196))return this[_0x152ded(0xa33)]()[_0x152ded(0x452)]!=='';else{if(!_0x32de09)continue;for(const _0x10cb7e of _0xa781bc){if(_0x152ded(0x4f1)==='XEvDR')_0x4ff4e8['BattleCore'][_0x152ded(0x50b)][_0x152ded(0x740)](this),this[_0x152ded(0x76a)]();else{if(_0x10cb7e['id']===_0x32de09['id'])continue;_0x32de09[_0x152ded(0x62e)]=_0x32de09[_0x152ded(0x62e)][_0x152ded(0x504)](_0x10cb7e['pages']);}}}}},Scene_Boot['prototype'][_0xfd5ed1(0x56c)]=function(){const _0x15d6e2=_0xfd5ed1,_0x5b8671=VisuMZ[_0x15d6e2(0x1e9)][_0x15d6e2(0x607)]['Mechanics'];if(_0x5b8671[_0x15d6e2(0x32d)]>0x0&&$dataCommonEvents[_0x5b8671[_0x15d6e2(0x32d)]]){const _0x36f5fe=$dataCommonEvents[_0x5b8671[_0x15d6e2(0x32d)]],_0x8c227c=_0x36f5fe['list'][_0x15d6e2(0x5b7)]-0x2,_0x284f71=_0x36f5fe['list'][_0x8c227c];if(_0x284f71&&_0x284f71[_0x15d6e2(0x44e)]!==0xe6){if(_0x15d6e2(0x40e)===_0x15d6e2(0x40e)){const _0x46077c={'code':0xe6,'indent':0x0,'parameters':[0x1]},_0x119ba8=_0x36f5fe[_0x15d6e2(0x641)][_0x15d6e2(0x46a)]();_0x36f5fe[_0x15d6e2(0x641)]['unshift'](_0x46077c),_0x36f5fe[_0x15d6e2(0x641)][_0x15d6e2(0x885)](_0x119ba8);}else{if(!_0x232539[_0x15d6e2(0xbb7)]())return;_0x3c3f1c[_0x15d6e2(0x1c5)](_0x423098,_0x2836b6);const _0xdf9110=_0x262538[_0x15d6e2(0x58e)](),_0x3b0f29=_0x288950[_0x15d6e2(0x2c6)],_0x5ca687=_0x2e8818[_0x15d6e2(0xb9a)],_0x5ee7f4=_0x3e198f[_0x15d6e2(0x377)]?_0x2a3c5f['_allTargets'][_0x15d6e2(0x5e1)](0x0):[],_0x17d438=_0x37430e[_0x15d6e2(0x901)];if(!_0xdf9110||!_0x3b0f29||!_0x5ca687)return;if(!_0x3b0f29[_0x15d6e2(0x3c7)]())return;if(_0x509bb0[_0x15d6e2(0x79d)])_0x17d438['push'](_0x15d6e2(0x714),_0x5ca687,_0x5ee7f4,![]);if(_0x444f70['WaitForNewLine'])_0x17d438[_0x15d6e2(0xbc8)]('waitForNewLine');if(_0x103683[_0x15d6e2(0xad0)])_0x17d438[_0x15d6e2(0xbc8)]('waitForEffect');if(_0x34b4f1[_0x15d6e2(0x1de)])_0x17d438[_0x15d6e2(0xbc8)](_0x15d6e2(0x3d1));if(_0x143429[_0x15d6e2(0xadc)])_0x17d438['push']('performActionEnd',_0x5ca687);if(_0xdcba50[_0x15d6e2(0x867)])_0x17d438[_0x15d6e2(0xbc8)]('waitForMovement');_0xdf9110[_0x15d6e2(0x7a6)](_0x15d6e2(0xb63));}}}},Scene_Boot[_0xfd5ed1(0x263)][_0xfd5ed1(0x5b2)]=function(){const _0x18b46c=_0xfd5ed1;VisuMZ['BattleCore'][_0x18b46c(0x8af)](),VisuMZ[_0x18b46c(0x1e9)][_0x18b46c(0x57e)]($dataSkills),VisuMZ['BattleCore'][_0x18b46c(0x57e)]($dataItems);},VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0x8af)]=function(){const _0xbca175=_0xfd5ed1;VisuMZ[_0xbca175(0x1e9)]['_commonEventKey']={};for(const _0x1efafb of $dataCommonEvents){if(!_0x1efafb)continue;if(_0x1efafb[_0xbca175(0x452)][_0xbca175(0x9e4)](/\[(.*)\]/i)){let _0x2ace2c=String(RegExp['$1'])[_0xbca175(0x797)](/,/g,'')[_0xbca175(0xa50)]()['trim']();VisuMZ['BattleCore'][_0xbca175(0x21a)][_0x2ace2c]=_0x1efafb['id'];}}},VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0x57e)]=function(_0x69dfc5){const _0x40f2a0=_0xfd5ed1;for(const _0xce3cfd of _0x69dfc5){if(!_0xce3cfd)continue;VisuMZ[_0x40f2a0(0x1e9)]['BindCommonEventKeysForObj'](_0xce3cfd);}},VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0x8f3)]=function(_0xa338b4){const _0x27c1da=_0xfd5ed1;if(!_0xa338b4)return;if(!_0xa338b4[_0x27c1da(0x7ee)])return;VisuMZ['BattleCore']['_commonEventKey']=VisuMZ[_0x27c1da(0x1e9)]['_commonEventKey']||{};const _0x1b418e=/<COMMON EVENT (?:KEY|KEYS):[ ](.*)>/gi,_0x434e66=/<COMMON EVENT (?:KEY|KEYS)>\s*([\s\S]*)\s*<\/COMMON EVENT (?:KEY|KEYS)>/i;let _0x4625ad=[];const _0x171bcc=_0xa338b4['note']['match'](_0x1b418e);if(_0x171bcc){for(const _0xdc6d7b of _0x171bcc){_0xdc6d7b[_0x27c1da(0x9e4)](_0x1b418e);const _0x1e9a57=String(RegExp['$1'])[_0x27c1da(0x513)](',')[_0x27c1da(0x3ee)](_0x450c68=>String(_0x450c68)[_0x27c1da(0xa50)]()['trim']());_0x4625ad=_0x4625ad['concat'](_0x1e9a57);}!_0xa338b4[_0x27c1da(0x80f)]['match'](/<CUSTOM ACTION SEQUENCE>/i)&&(_0xa338b4[_0x27c1da(0x80f)]+='<CUSTOM\x20ACTION\x20SEQUENCE>');;}if(_0xa338b4[_0x27c1da(0x80f)][_0x27c1da(0x9e4)](_0x434e66)){const _0x2bf4e7=String(RegExp['$1'])[_0x27c1da(0x513)](/[\r\n]+/)[_0x27c1da(0x3ee)](_0x38f963=>String(_0x38f963)[_0x27c1da(0xa50)]()['trim']());_0x4625ad=_0x4625ad[_0x27c1da(0x504)](_0x2bf4e7);!_0xa338b4[_0x27c1da(0x80f)][_0x27c1da(0x9e4)](/<CUSTOM ACTION SEQUENCE>/i)&&(_0x27c1da(0x5d3)===_0x27c1da(0x5d3)?_0xa338b4[_0x27c1da(0x80f)]+='<CUSTOM\x20ACTION\x20SEQUENCE>':(this[_0x27c1da(0x81d)]+=_0x424870[_0x27c1da(0x376)](),this[_0x27c1da(0x359)]['y']+=_0x52b2cb[_0x27c1da(0x770)]()));;}for(const _0x105d35 of _0x4625ad){if(VisuMZ['BattleCore'][_0x27c1da(0x21a)][_0x105d35]){const _0x493413=VisuMZ[_0x27c1da(0x1e9)][_0x27c1da(0x21a)][_0x105d35],_0x28147b={'code':0x2c,'dataId':_0x493413,'value1':0x1,'value2':0x0};_0xa338b4[_0x27c1da(0x7ee)][_0x27c1da(0xbc8)](_0x28147b);}}},Scene_Boot[_0xfd5ed1(0x263)][_0xfd5ed1(0xaea)]=function(){const _0x3b864f=_0xfd5ed1,_0xf2109e=$dataSkills[_0x3b864f(0x504)]($dataItems);for(const _0x3f1568 of _0xf2109e){if(!_0x3f1568)continue;VisuMZ[_0x3b864f(0x1e9)][_0x3b864f(0x5f0)](_0x3f1568);}},VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0x833)]=VisuMZ['ParseActorNotetags'],VisuMZ['ParseActorNotetags']=function(_0x40be2a){const _0x1132df=_0xfd5ed1;if(VisuMZ[_0x1132df(0x1e9)]['ParseActorNotetags']){if(_0x1132df(0x425)!==_0x1132df(0x425))return this[_0x1132df(0xa33)]()[_0x1132df(0x298)];else VisuMZ['BattleCore'][_0x1132df(0x833)][_0x1132df(0x740)](this,_0x40be2a);}VisuMZ[_0x1132df(0x1e9)][_0x1132df(0x5c9)](_0x40be2a);},VisuMZ['BattleCore']['ParseClassNotetags']=VisuMZ[_0xfd5ed1(0x26b)],VisuMZ[_0xfd5ed1(0x26b)]=function(_0x4506ec){const _0x139548=_0xfd5ed1;VisuMZ[_0x139548(0x1e9)]['ParseClassNotetags']&&VisuMZ['BattleCore'][_0x139548(0x26b)][_0x139548(0x740)](this,_0x4506ec),VisuMZ[_0x139548(0x1e9)][_0x139548(0x5c9)](_0x4506ec);},VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0x207)]=VisuMZ[_0xfd5ed1(0x207)],VisuMZ[_0xfd5ed1(0x207)]=function(_0x5c69e2){const _0x2843ab=_0xfd5ed1;if(VisuMZ['BattleCore'][_0x2843ab(0x207)]){if(_0x2843ab(0xa25)!==_0x2843ab(0xa25)){if(!this[_0x2843ab(0x4b9)][_0x2843ab(0x29e)](_0x32889['id']))return![];}else VisuMZ[_0x2843ab(0x1e9)]['ParseSkillNotetags'][_0x2843ab(0x740)](this,_0x5c69e2);}VisuMZ['BattleCore'][_0x2843ab(0x90e)](_0x5c69e2),VisuMZ[_0x2843ab(0x1e9)][_0x2843ab(0x5f0)](_0x5c69e2);},VisuMZ[_0xfd5ed1(0x1e9)]['ParseItemNotetags']=VisuMZ[_0xfd5ed1(0x8c2)],VisuMZ[_0xfd5ed1(0x8c2)]=function(_0x58a91e){const _0x522949=_0xfd5ed1;VisuMZ[_0x522949(0x1e9)]['ParseItemNotetags']&&VisuMZ['BattleCore'][_0x522949(0x8c2)][_0x522949(0x740)](this,_0x58a91e),VisuMZ[_0x522949(0x1e9)]['Parse_Notetags_Action'](_0x58a91e),VisuMZ[_0x522949(0x1e9)]['Parse_Notetags_Targets'](_0x58a91e);},VisuMZ[_0xfd5ed1(0x1e9)]['ParseWeaponNotetags']=VisuMZ[_0xfd5ed1(0x40d)],VisuMZ[_0xfd5ed1(0x40d)]=function(_0x176f38){const _0x5e7dc2=_0xfd5ed1;VisuMZ[_0x5e7dc2(0x1e9)]['ParseWeaponNotetags']&&VisuMZ[_0x5e7dc2(0x1e9)][_0x5e7dc2(0x40d)][_0x5e7dc2(0x740)](this,_0x176f38),VisuMZ['BattleCore'][_0x5e7dc2(0x5c9)](_0x176f38);},VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0x44c)]=VisuMZ[_0xfd5ed1(0x44c)],VisuMZ['ParseArmorNotetags']=function(_0x160afa){const _0xec61d9=_0xfd5ed1;if(VisuMZ[_0xec61d9(0x1e9)][_0xec61d9(0x44c)]){if(_0xec61d9(0x4a1)==='KzHSz')return _0xec61d9(0x9ec);else VisuMZ[_0xec61d9(0x1e9)][_0xec61d9(0x44c)][_0xec61d9(0x740)](this,_0x160afa);}VisuMZ[_0xec61d9(0x1e9)][_0xec61d9(0x5c9)](_0x160afa);},VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0xba0)]=VisuMZ[_0xfd5ed1(0xba0)],VisuMZ[_0xfd5ed1(0xba0)]=function(_0x3328f5){const _0x352d26=_0xfd5ed1;VisuMZ['BattleCore'][_0x352d26(0xba0)]&&VisuMZ[_0x352d26(0x1e9)]['ParseEnemyNotetags'][_0x352d26(0x740)](this,_0x3328f5),VisuMZ[_0x352d26(0x1e9)][_0x352d26(0x5c9)](_0x3328f5);},VisuMZ[_0xfd5ed1(0x1e9)]['ParseStateNotetags']=VisuMZ[_0xfd5ed1(0x422)],VisuMZ[_0xfd5ed1(0x422)]=function(_0x4eda55){const _0x309f56=_0xfd5ed1;VisuMZ[_0x309f56(0x1e9)][_0x309f56(0x422)]&&VisuMZ[_0x309f56(0x1e9)][_0x309f56(0x422)][_0x309f56(0x740)](this,_0x4eda55),VisuMZ[_0x309f56(0x1e9)][_0x309f56(0x5c9)](_0x4eda55);},VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0x90e)]=function(_0x35d025){const _0x19c2a9=_0xfd5ed1,_0x3bfae2=[_0x19c2a9(0x3d6),_0x19c2a9(0x845),_0x19c2a9(0x313),_0x19c2a9(0x28d),_0x19c2a9(0x64f),_0x19c2a9(0x88c),_0x19c2a9(0x1bb),_0x19c2a9(0x2cb)];for(const _0x2a4ba2 of _0x3bfae2){VisuMZ['BattleCore']['createJS'](_0x35d025,_0x2a4ba2);}const _0xa2ff9a=_0x35d025[_0x19c2a9(0x80f)];_0xa2ff9a[_0x19c2a9(0x9e4)](/<ALWAYS CRITICAL/i)&&(_0x19c2a9(0x366)!=='uCqVM'?_0x45704d[_0x19c2a9(0x1e9)]['ParseStateNotetags'][_0x19c2a9(0x740)](this,_0x186ccd):_0x35d025[_0x19c2a9(0x42d)][_0x19c2a9(0x6c7)]=!![]);_0xa2ff9a['match'](/<(?:REPEAT|REPEATS|REPEAT HITS):[ ](\d+)/i)&&(_0x35d025[_0x19c2a9(0xbd6)]=Math[_0x19c2a9(0x4d3)](0x1,Number(RegExp['$1'])));if(_0xa2ff9a['match'](/<TARGET:[ ](.*)>/i)){if('eNdSw'!=='eNdSw'){this[_0x19c2a9(0xbc8)](_0x19c2a9(0x5c1),_0x58433c,_0x845171);if(!_0x3834c8['BattleCore'][_0x19c2a9(0x607)][_0x19c2a9(0xbe6)][_0x19c2a9(0x72b)])return;const _0x46fa9e=_0xd94f35[_0x19c2a9(0x452)](),_0x170627=_0x3a1c08[_0x19c2a9(0x91d)][_0x19c2a9(0x222)](_0x46fa9e,_0x5763b1['name']());this[_0x19c2a9(0xbc8)](_0x19c2a9(0x1e4),_0x170627);}else _0x35d025[_0x19c2a9(0x33c)]=String(RegExp['$1'])[_0x19c2a9(0xa50)]()[_0x19c2a9(0x300)]();}},VisuMZ['BattleCore'][_0xfd5ed1(0x5c9)]=function(_0x34df8e){const _0x9bb2f5=_0xfd5ed1,_0x58722d=[_0x9bb2f5(0x30c),_0x9bb2f5(0x5a2),_0x9bb2f5(0x22b),_0x9bb2f5(0xaf9),_0x9bb2f5(0x7cf),_0x9bb2f5(0x265),_0x9bb2f5(0x8b6),_0x9bb2f5(0x960),'PreStartActionJS','PostStartActionJS',_0x9bb2f5(0x1bb),'PostEndActionJS',_0x9bb2f5(0x518),_0x9bb2f5(0x594),_0x9bb2f5(0x6cf),_0x9bb2f5(0xbc4),'BattleVictoryJS',_0x9bb2f5(0x634),_0x9bb2f5(0x79a),'EscapeFailureJS',_0x9bb2f5(0xb57),_0x9bb2f5(0x542),_0x9bb2f5(0xb84),_0x9bb2f5(0x98c),_0x9bb2f5(0x5cc),'PostRegenerateJS'];for(const _0x44d681 of _0x58722d){if(_0x9bb2f5(0x455)!=='qeWpq')VisuMZ[_0x9bb2f5(0x1e9)][_0x9bb2f5(0x6f0)](_0x34df8e,_0x44d681);else return this[_0x9bb2f5(0x99f)]();}},VisuMZ[_0xfd5ed1(0x1e9)]['Parse_Notetags_Targets']=function(_0x1a9386){const _0x52ea3e=_0xfd5ed1,_0x49b781=_0x1a9386[_0x52ea3e(0x80f)];if(_0x49b781[_0x52ea3e(0x9e4)](/<JS TARGETS>\s*([\s\S]*)\s*<\/JS TARGETS>/i)){const _0xcc5e56=String(RegExp['$1']),_0xb77f6f=VisuMZ[_0x52ea3e(0x1e9)][_0x52ea3e(0xadb)](_0x1a9386,_0x52ea3e(0x7e3));VisuMZ[_0x52ea3e(0x1e9)][_0x52ea3e(0x65b)](_0xcc5e56,_0xb77f6f);}if(_0x49b781['match'](/<JS COMMAND (?:VISIBLE|SHOW|HIDE)>\s*([\s\S]*)\s*<\/JS COMMAND (?:VISIBLE|SHOW|HIDE)>/i)){if(_0x52ea3e(0x694)==='eNZfP'){const _0x5d1b05=String(RegExp['$1']),_0x1e648b=VisuMZ['BattleCore'][_0x52ea3e(0xadb)](_0x1a9386,'CommandVisible');VisuMZ['BattleCore'][_0x52ea3e(0x305)](_0x5d1b05,_0x1e648b);}else this[_0x52ea3e(0x4de)]();}},VisuMZ[_0xfd5ed1(0x1e9)]['JS']={},VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0x6f0)]=function(_0x58e0df,_0x495b2f){const _0xfc9400=_0xfd5ed1,_0x492140=_0x58e0df[_0xfc9400(0x80f)];if(_0x492140[_0xfc9400(0x9e4)](VisuMZ[_0xfc9400(0x1e9)][_0xfc9400(0x349)][_0x495b2f])){if('JQYhe'==='JQYhe'){const _0xe49d1f=RegExp['$1'],_0x1f62ea=_0xfc9400(0x348)[_0xfc9400(0x222)](_0xe49d1f),_0xbd66e7=VisuMZ[_0xfc9400(0x1e9)][_0xfc9400(0xadb)](_0x58e0df,_0x495b2f);VisuMZ[_0xfc9400(0x1e9)]['JS'][_0xbd66e7]=new Function(_0x1f62ea);}else return _0x48c92b[_0xfc9400(0x80f)][_0xfc9400(0x9e4)](/<COMMAND ICON: (\d+)>/i)?_0x316a0e(_0xdcf472['$1']):_0x353bbc[_0xfc9400(0x927)];}},VisuMZ['BattleCore'][_0xfd5ed1(0xadb)]=function(_0x25fc1d,_0x2971ef){const _0x5797ba=_0xfd5ed1;let _0x2b9206='';if($dataActors[_0x5797ba(0x4b6)](_0x25fc1d))_0x2b9206=_0x5797ba(0x45c)[_0x5797ba(0x222)](_0x25fc1d['id'],_0x2971ef);if($dataClasses[_0x5797ba(0x4b6)](_0x25fc1d))_0x2b9206=_0x5797ba(0x4f2)[_0x5797ba(0x222)](_0x25fc1d['id'],_0x2971ef);if($dataSkills[_0x5797ba(0x4b6)](_0x25fc1d))_0x2b9206='Skill-%1-%2'[_0x5797ba(0x222)](_0x25fc1d['id'],_0x2971ef);if($dataItems[_0x5797ba(0x4b6)](_0x25fc1d))_0x2b9206='Item-%1-%2'[_0x5797ba(0x222)](_0x25fc1d['id'],_0x2971ef);if($dataWeapons[_0x5797ba(0x4b6)](_0x25fc1d))_0x2b9206=_0x5797ba(0x5f8)[_0x5797ba(0x222)](_0x25fc1d['id'],_0x2971ef);if($dataArmors[_0x5797ba(0x4b6)](_0x25fc1d))_0x2b9206=_0x5797ba(0x947)['format'](_0x25fc1d['id'],_0x2971ef);if($dataEnemies[_0x5797ba(0x4b6)](_0x25fc1d))_0x2b9206=_0x5797ba(0x69a)[_0x5797ba(0x222)](_0x25fc1d['id'],_0x2971ef);if($dataStates['includes'](_0x25fc1d))_0x2b9206=_0x5797ba(0xa64)[_0x5797ba(0x222)](_0x25fc1d['id'],_0x2971ef);return _0x2b9206;},VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0x65b)]=function(_0x32995c,_0x261f8c){const _0x662b5a=_0xfd5ed1,_0x5074e8='\x0a\x20\x20\x20\x20\x20\x20\x20\x20//\x20Declare\x20Arguments\x0a\x20\x20\x20\x20\x20\x20\x20\x20const\x20user\x20=\x20arguments[0];\x0a\x20\x20\x20\x20\x20\x20\x20\x20const\x20a\x20=\x20user;\x0a\x20\x20\x20\x20\x20\x20\x20\x20const\x20b\x20=\x20user;\x0a\x20\x20\x20\x20\x20\x20\x20\x20let\x20targets\x20=\x20arguments[1];\x0a\x0a\x20\x20\x20\x20\x20\x20\x20\x20//\x20Process\x20Code\x0a\x20\x20\x20\x20\x20\x20\x20\x20try\x20{\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20%1\x0a\x20\x20\x20\x20\x20\x20\x20\x20}\x20catch\x20(e)\x20{\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20if\x20($gameTemp.isPlaytest())\x20console.log(e);\x0a\x20\x20\x20\x20\x20\x20\x20\x20}\x0a\x0a\x20\x20\x20\x20\x20\x20\x20\x20//\x20Return\x20Value\x0a\x20\x20\x20\x20\x20\x20\x20\x20return\x20targets\x20||\x20[];\x0a\x20\x20\x20\x20'[_0x662b5a(0x222)](_0x32995c);VisuMZ['BattleCore']['JS'][_0x261f8c]=new Function(_0x5074e8);},VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0x305)]=function(_0x6f994d,_0x459b93){const _0x2a1faf=_0xfd5ed1,_0x1e95ba=_0x2a1faf(0x31c)[_0x2a1faf(0x222)](_0x6f994d);VisuMZ[_0x2a1faf(0x1e9)]['JS'][_0x459b93]=new Function(_0x1e95ba);},TextManager['autoBattle']=VisuMZ['BattleCore'][_0xfd5ed1(0x607)][_0xfd5ed1(0x56b)][_0xfd5ed1(0x7aa)],TextManager[_0xfd5ed1(0x2ac)]=VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0x607)][_0xfd5ed1(0x2d9)][_0xfd5ed1(0x67c)],TextManager[_0xfd5ed1(0xa11)]=VisuMZ[_0xfd5ed1(0x1e9)]['Settings']['AutoBattle'][_0xfd5ed1(0x556)],TextManager[_0xfd5ed1(0x853)]=VisuMZ['BattleCore'][_0xfd5ed1(0x607)][_0xfd5ed1(0x2d2)][_0xfd5ed1(0xa00)],ColorManager[_0xfd5ed1(0xb1e)]=function(_0x3585c7){const _0x1b96b4=_0xfd5ed1;_0x3585c7=String(_0x3585c7);if(_0x3585c7[_0x1b96b4(0x9e4)](/#(.*)/i)){if('DrnYA'===_0x1b96b4(0x3ab))return _0x1b96b4(0x75d)[_0x1b96b4(0x222)](String(RegExp['$1']));else _0x54a783['_inputting']=![];}else return this[_0x1b96b4(0x8fd)](Number(_0x3585c7));},DataManager[_0xfd5ed1(0xbac)]=function(_0x4213d7){const _0x530515=_0xfd5ed1;if(_0x4213d7[_0x530515(0x80f)][_0x530515(0x9e4)](/<DAMAGE STYLE:[ ](.*)>/i)){const _0x44c2db=String(RegExp['$1'])['toUpperCase']()[_0x530515(0x300)]();if(_0x44c2db===_0x530515(0xab3))return _0x530515(0xab3);if(VisuMZ[_0x530515(0x5da)][_0x44c2db])return _0x44c2db;}const _0x58d398=VisuMZ['BattleCore'][_0x530515(0x607)][_0x530515(0x608)][_0x530515(0x227)]['toUpperCase']()[_0x530515(0x300)]();if(VisuMZ['DamageStyles'][_0x58d398])return _0x58d398;return _0x530515(0xab3);},DataManager[_0xfd5ed1(0x2c2)]=function(_0x3e16c2){const _0xe40409=_0xfd5ed1;_0x3e16c2=_0x3e16c2['toUpperCase']()['trim'](),this[_0xe40409(0xa90)]=this[_0xe40409(0xa90)]||{};if(this[_0xe40409(0xa90)][_0x3e16c2])return this[_0xe40409(0xa90)][_0x3e16c2];for(let _0x369df0=0x1;_0x369df0<0x64;_0x369df0++){if(_0xe40409(0x210)!==_0xe40409(0x210))_0x5e1e6d['prototype'][_0xe40409(0x583)]['call'](this,_0xd002ec,_0x29ae41,_0x40e564,_0x2ae234);else{if(!$dataSystem[_0xe40409(0x7ba)][_0x369df0])continue;let _0x2aee23=$dataSystem[_0xe40409(0x7ba)][_0x369df0]['toUpperCase']()['trim']();_0x2aee23=_0x2aee23[_0xe40409(0x797)](/\x1I\[(\d+)\]/gi,''),_0x2aee23=_0x2aee23[_0xe40409(0x797)](/\\I\[(\d+)\]/gi,''),this['_stypeIDs'][_0x2aee23]=_0x369df0;}}return this[_0xe40409(0xa90)][_0x3e16c2]||0x0;},DataManager[_0xfd5ed1(0x8e3)]=function(_0x2b8f20){const _0x59d75d=_0xfd5ed1;_0x2b8f20=_0x2b8f20[_0x59d75d(0xa50)]()[_0x59d75d(0x300)](),this[_0x59d75d(0x94b)]=this['_skillIDs']||{};if(this[_0x59d75d(0x94b)][_0x2b8f20])return this[_0x59d75d(0x94b)][_0x2b8f20];for(const _0x220533 of $dataSkills){if(!_0x220533)continue;this[_0x59d75d(0x94b)][_0x220533['name']['toUpperCase']()[_0x59d75d(0x300)]()]=_0x220533['id'];}return this[_0x59d75d(0x94b)][_0x2b8f20]||0x0;},DataManager[_0xfd5ed1(0x856)]=function(_0x334c44){const _0xa37df4=_0xfd5ed1;_0x334c44=_0x334c44['toUpperCase']()[_0xa37df4(0x300)](),this[_0xa37df4(0x5e3)]=this[_0xa37df4(0x5e3)]||{};if(this[_0xa37df4(0x5e3)][_0x334c44])return this[_0xa37df4(0x5e3)][_0x334c44];for(const _0x2f2672 of $dataEnemies){if(!_0x2f2672)continue;this['_enemyIDs'][_0x2f2672[_0xa37df4(0x452)][_0xa37df4(0xa50)]()[_0xa37df4(0x300)]()]=_0x2f2672['id'];}return this[_0xa37df4(0x5e3)][_0x334c44]||0x0;},DataManager[_0xfd5ed1(0xae3)]=function(_0x414dae){const _0x28b13c=_0xfd5ed1;_0x414dae=_0x414dae[_0x28b13c(0xa50)]()[_0x28b13c(0x300)](),this[_0x28b13c(0xb70)]=this['_wtypeIDs']||{};if(this[_0x28b13c(0xb70)][_0x414dae])return this[_0x28b13c(0xb70)][_0x414dae];for(let _0x1b6b83=0x1;_0x1b6b83<0x64;_0x1b6b83++){if(!$dataSystem['weaponTypes'][_0x1b6b83])continue;let _0x1c135b=$dataSystem[_0x28b13c(0xabf)][_0x1b6b83][_0x28b13c(0xa50)]()[_0x28b13c(0x300)]();_0x1c135b=_0x1c135b[_0x28b13c(0x797)](/\x1I\[(\d+)\]/gi,''),_0x1c135b=_0x1c135b[_0x28b13c(0x797)](/\\I\[(\d+)\]/gi,''),this[_0x28b13c(0xb70)][_0x1c135b]=_0x1b6b83;}return this[_0x28b13c(0xb70)]['BARE\x20HANDS']=0x0,this[_0x28b13c(0xb70)][_0x414dae]||0x0;},DataManager[_0xfd5ed1(0x902)]=function(_0x5bf069){const _0x57dad1=_0xfd5ed1,_0x12f5e8=_0x57dad1(0xa62);let _0x1819f4=_0x5bf069['iconIndex'],_0x137157=_0x5bf069[_0x57dad1(0x452)];const _0x290fdc=_0x5bf069[_0x57dad1(0x80f)];return _0x290fdc[_0x57dad1(0x9e4)](/<DISPLAY ICON: (\d+)>/i)&&('WIhxD'!==_0x57dad1(0x912)?this['_mainSprite'][_0x57dad1(0x914)](0x0,0x0,this[_0x57dad1(0x798)][_0x57dad1(0xb4a)],this[_0x57dad1(0x7a7)]):_0x1819f4=Number(RegExp['$1'])),_0x290fdc['match'](/<DISPLAY TEXT: (.*)>/i)&&(_0x137157=String(RegExp['$1'])),_0x12f5e8['format'](_0x1819f4,_0x137157);},DataManager[_0xfd5ed1(0x82a)]=function(_0x385188){const _0x368c23=_0xfd5ed1;if(_0x385188[_0x368c23(0x80f)][_0x368c23(0x9e4)](/<COMMAND TEXT: (.*)>/i))return String(RegExp['$1']);else{if('egxqj'!==_0x368c23(0x530))_0x597646[_0x368c23(0x1e9)]['Sprite_Actor_setActorHome'][_0x368c23(0x740)](this,_0x1c7fad);else return _0x385188[_0x368c23(0x452)];}},DataManager[_0xfd5ed1(0x8eb)]=function(_0x5f4447){const _0x364835=_0xfd5ed1;if(_0x5f4447[_0x364835(0x80f)][_0x364835(0x9e4)](/<COMMAND ICON: (\d+)>/i))return _0x364835(0x185)!==_0x364835(0x185)?_0x4c9ee9[_0x364835(0x1e9)][_0x364835(0x607)][_0x364835(0x1f5)][_0x364835(0xa38)]:Number(RegExp['$1']);else{if(_0x364835(0x1ea)==='reWMY'){if(_0xbb2cad[_0x364835(0x59a)](_0x36cc8a))return!![];}else return _0x5f4447[_0x364835(0x927)];}},DataManager[_0xfd5ed1(0x6fa)]=function(_0x161a04){const _0x506001=_0xfd5ed1,_0x55b864=$dataEnemies[_0x161a04];if(_0x55b864){if(_0x506001(0x908)===_0x506001(0x908)){if(_0x55b864[_0x506001(0x80f)]['match'](/<SWAP ENEMIES>\s*([\s\S]*)\s*<\/SWAP ENEMIES>/i)){if('UfkpG'!=='sliSX'){const _0x569666=String(RegExp['$1'])[_0x506001(0x513)](/[\r\n]+/)[_0x506001(0x698)](''),_0x58423f=this[_0x506001(0x780)](_0x569666);_0x161a04=this[_0x506001(0x856)](_0x58423f)||_0x161a04,_0x161a04=DataManager[_0x506001(0x6fa)](_0x161a04);}else this[_0x506001(0x731)]();}}else this[_0x506001(0x74b)](_0x506001(0xa89));}return _0x161a04;},DataManager[_0xfd5ed1(0x780)]=function(_0x52b4d6){const _0x363a30=_0xfd5ed1;let _0x5a677a=0x0;const _0x3372f4={};for(const _0xf523fe of _0x52b4d6){if('cYBBG'===_0x363a30(0xb55))this[_0x363a30(0xbbb)]='',this['actor']()&&this[_0x363a30(0x279)]()[_0x363a30(0x80f)][_0x363a30(0x9e4)](/<BATTLE (?:IMAGE|PORTRAIT):[ ](.*)>/i)&&(this[_0x363a30(0xbbb)]=_0xa4836e(_0x46014c['$1']));else{if(_0xf523fe['match'](/(.*):[ ](\d+)/i)){const _0x34a4ce=String(RegExp['$1'])[_0x363a30(0x300)](),_0x2c0142=Number(RegExp['$2']);_0x3372f4[_0x34a4ce]=_0x2c0142,_0x5a677a+=_0x2c0142;}else{if(_0xf523fe[_0x363a30(0x9e4)](/(.*):[ ](\d+\.?\d+)/i)){const _0x303278=String(RegExp['$1'])[_0x363a30(0x300)](),_0xe65352=Number(RegExp['$2']);_0x3372f4[_0x303278]=_0xe65352,_0x5a677a+=_0xe65352;}else _0xf523fe!==''&&(_0x363a30(0xb59)===_0x363a30(0xb72)?(_0xfbccde[_0x363a30(0x1e9)][_0x363a30(0x422)]&&_0xb31ab3[_0x363a30(0x1e9)]['ParseStateNotetags'][_0x363a30(0x740)](this,_0x4ae8b9),_0x107a02[_0x363a30(0x1e9)]['Parse_Notetags_TraitObjects'](_0x361d2e)):(_0x3372f4[_0xf523fe]=0x1,_0x5a677a++));}}}if(_0x5a677a<=0x0)return'';let _0x4cdcb9=Math[_0x363a30(0x59b)]()*_0x5a677a;for(const _0xfc0927 in _0x3372f4){_0x4cdcb9-=_0x3372f4[_0xfc0927];if(_0x4cdcb9<=0x0)return _0xfc0927;}return'';},DataManager[_0xfd5ed1(0xb6c)]=function(_0x56da3d){const _0x53eb13=_0xfd5ed1;if(!_0x56da3d)return![];if(!VisuMZ['BattleCore'][_0x53eb13(0x607)]['ActionSequence'][_0x53eb13(0xa84)])return![];if(_0x56da3d[_0x53eb13(0x80f)]['match'](/<AUTO ACTION SEQUENCE>/i))return![];if(_0x56da3d[_0x53eb13(0x80f)][_0x53eb13(0x9e4)](/<COMMON (?:EVENT|EVENTS):[ ](.*)>/gi))return!![];for(const _0x16eac3 of _0x56da3d[_0x53eb13(0x7ee)]){if(_0x53eb13(0x30f)!==_0x53eb13(0x30f))this['_colorType']=_0x392a63['hpDamage']>=0x0?0x0:0x1,this[_0x53eb13(0xbce)](_0x460d0f['hpDamage']);else{if(!_0x16eac3)continue;if(_0x16eac3[_0x53eb13(0x44e)]===Game_Action[_0x53eb13(0xbb2)])return!![];}}return![];},DataManager['createTroopNote']=function(_0x480c45){const _0x18c619=_0xfd5ed1,_0x41568e=$dataTroops[_0x480c45];if(!_0x41568e)return'';let _0x482a9c='';_0x482a9c+=_0x41568e[_0x18c619(0x452)];for(const _0x4bbbba of _0x41568e[_0x18c619(0x62e)]){for(const _0x157de6 of _0x4bbbba[_0x18c619(0x641)]){[0x6c,0x198][_0x18c619(0x4b6)](_0x157de6[_0x18c619(0x44e)])&&(_0x482a9c+='\x0a',_0x482a9c+=_0x157de6[_0x18c619(0x638)][0x0]);}}return _0x482a9c;},ConfigManager[_0xfd5ed1(0x933)]=ConfigManager[_0xfd5ed1(0x933)]??![],ConfigManager[_0xfd5ed1(0xb8c)]=ConfigManager[_0xfd5ed1(0xb8c)]??![],ConfigManager[_0xfd5ed1(0x853)]=ConfigManager[_0xfd5ed1(0x853)]??!![],VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0x5c5)]=ConfigManager['makeData'],ConfigManager[_0xfd5ed1(0xbb3)]=function(){const _0x3fb546=_0xfd5ed1,_0xec61e5=VisuMZ[_0x3fb546(0x1e9)]['ConfigManager_makeData'][_0x3fb546(0x740)](this);return _0xec61e5[_0x3fb546(0x933)]=this[_0x3fb546(0x933)],_0xec61e5[_0x3fb546(0xb8c)]=this[_0x3fb546(0xb8c)],_0xec61e5[_0x3fb546(0x853)]=this[_0x3fb546(0x853)],_0xec61e5;},VisuMZ[_0xfd5ed1(0x1e9)]['ConfigManager_applyData']=ConfigManager[_0xfd5ed1(0x832)],ConfigManager['applyData']=function(_0x1f85e0){const _0x4e5f15=_0xfd5ed1;VisuMZ[_0x4e5f15(0x1e9)]['ConfigManager_applyData']['call'](this,_0x1f85e0);if(_0x4e5f15(0x933)in _0x1f85e0){if(_0x4e5f15(0x5b3)==='iTYax')this[_0x4e5f15(0x933)]=_0x1f85e0['autoBattleAtStart'];else{if(!this['_shadowSprite'])return;this[_0x4e5f15(0xbe4)]['y']=this[_0x4e5f15(0x579)]-this['y']-0x2;}}else this[_0x4e5f15(0x933)]=![];_0x4e5f15(0xb8c)in _0x1f85e0?this['autoBattleUseSkills']=_0x1f85e0[_0x4e5f15(0xb8c)]:this['autoBattleUseSkills']=![],_0x4e5f15(0x853)in _0x1f85e0?this['visualHpGauge']=_0x1f85e0[_0x4e5f15(0x853)]:this[_0x4e5f15(0x853)]=!![];},VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0x252)]=BattleManager[_0xfd5ed1(0x218)],BattleManager[_0xfd5ed1(0x218)]=function(){const _0x43da50=_0xfd5ed1;VisuMZ[_0x43da50(0x1e9)][_0x43da50(0x252)][_0x43da50(0x740)](this),this[_0x43da50(0x8b0)]=[];},BattleManager[_0xfd5ed1(0xbe1)]=function(){const _0x2e1ff2=_0xfd5ed1;if(!SceneManager['isSceneBattle']())return;const _0x37d077=SceneManager[_0x2e1ff2(0x3c3)]['_statusWindow'];if(_0x37d077)_0x37d077[_0x2e1ff2(0x315)]();},BattleManager[_0xfd5ed1(0x89e)]=function(){const _0x1e90d9=_0xfd5ed1;if(BattleManager[_0x1e90d9(0x47b)]())return _0x1e90d9(0x956);return _0x1e90d9(0xae7);},BattleManager[_0xfd5ed1(0x707)]=function(_0x50cc7c){const _0x5c071b=_0xfd5ed1;return _0x50cc7c=_0x50cc7c[_0x5c071b(0xa50)]()[_0x5c071b(0x300)](),this[_0x5c071b(0x89e)]()===_0x50cc7c;},BattleManager[_0xfd5ed1(0x6d1)]=function(){const _0x46846d=_0xfd5ed1;return this['isBattleSys'](_0x46846d(0xae7));},BattleManager[_0xfd5ed1(0x4bd)]=function(){const _0x5627a7=_0xfd5ed1;return this[_0x5627a7(0x6d1)]();},BattleManager[_0xfd5ed1(0x90b)]=function(){const _0x1a1a04=_0xfd5ed1;return!this[_0x1a1a04(0x4bd)]();},BattleManager['isTeamBased']=function(){const _0x3c543c=_0xfd5ed1;return!this['isTurnBased']()&&!this[_0x3c543c(0x90b)]();},BattleManager[_0xfd5ed1(0x2db)]=function(_0x3a8fcc){const _0x112f36=_0xfd5ed1;$gameParty[_0x112f36(0x2db)](_0x3a8fcc),$gameTroop['processBattleCoreJS'](_0x3a8fcc);},VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0xa81)]=BattleManager[_0xfd5ed1(0x99a)],BattleManager[_0xfd5ed1(0x99a)]=function(){const _0x10b29d=_0xfd5ed1;this[_0x10b29d(0x5a0)]=![],this[_0x10b29d(0x373)]=ConfigManager[_0x10b29d(0x933)],this[_0x10b29d(0x2db)]('PreStartBattleJS'),VisuMZ['BattleCore'][_0x10b29d(0xa81)][_0x10b29d(0x740)](this),this['processBattleCoreJS'](_0x10b29d(0x594));},BattleManager[_0xfd5ed1(0x3b9)]=function(_0x487033){const _0xc2c2de=_0xfd5ed1,_0x2e82a2=VisuMZ[_0xc2c2de(0x1e9)][_0xc2c2de(0x607)]['Mechanics'];if(_0x2e82a2[_0xc2c2de(0x905)]&&VisuMZ[_0xc2c2de(0x1e9)][_0xc2c2de(0x509)](_0x2e82a2[_0xc2c2de(0x905)])){if('EcNpb'==='NOsaA'){let _0xf2486f='';if(_0x21d5f3['includes'](_0xc7985))_0xf2486f=_0xc2c2de(0x45c)['format'](_0x2ddec4['id'],_0x1cb8f7);if(_0x4097b4[_0xc2c2de(0x4b6)](_0x119d2f))_0xf2486f=_0xc2c2de(0x4f2)['format'](_0x49aaa0['id'],_0x13cb4f);if(_0x11bf39[_0xc2c2de(0x4b6)](_0xd272b8))_0xf2486f=_0xc2c2de(0xbee)[_0xc2c2de(0x222)](_0x470372['id'],_0x527e4d);if(_0x202244[_0xc2c2de(0x4b6)](_0x16bb0e))_0xf2486f=_0xc2c2de(0x506)[_0xc2c2de(0x222)](_0x60855f['id'],_0x1895af);if(_0x2f1165[_0xc2c2de(0x4b6)](_0x20c597))_0xf2486f=_0xc2c2de(0x5f8)[_0xc2c2de(0x222)](_0x59fcc9['id'],_0x1bec67);if(_0x50e2cc[_0xc2c2de(0x4b6)](_0x1ce084))_0xf2486f=_0xc2c2de(0x947)[_0xc2c2de(0x222)](_0x5b8687['id'],_0x612bd0);if(_0x19e8b7[_0xc2c2de(0x4b6)](_0x1f4ef6))_0xf2486f=_0xc2c2de(0x69a)[_0xc2c2de(0x222)](_0xd7a3fa['id'],_0x387105);if(_0x4bd4a9[_0xc2c2de(0x4b6)](_0x2bfd76))_0xf2486f=_0xc2c2de(0xa64)[_0xc2c2de(0x222)](_0x560948['id'],_0x576b25);return _0xf2486f;}else $gameTemp[_0xc2c2de(0x601)](_0x2e82a2['BattleEndEvent']);}const _0x581240='%1Event'[_0xc2c2de(0x222)](_0x487033);if(_0x2e82a2[_0x581240]&&VisuMZ['BattleCore'][_0xc2c2de(0x509)](_0x2e82a2[_0x581240])){if('hwcgO'===_0xc2c2de(0x670)){const _0x5f3944=_0x9197e6(_0x2d6469['$1'])[_0xc2c2de(0xa50)]()[_0xc2c2de(0x300)]();return _0x5f3944;}else $gameTemp[_0xc2c2de(0x601)](_0x2e82a2[_0x581240]);}},VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0x968)]=BattleManager[_0xfd5ed1(0xa49)],BattleManager[_0xfd5ed1(0xa49)]=function(){const _0x16d829=_0xfd5ed1;this[_0x16d829(0x2db)](_0x16d829(0xa85)),VisuMZ[_0x16d829(0x1e9)][_0x16d829(0x968)]['call'](this),this[_0x16d829(0x3b9)](_0x16d829(0x9bb));},VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0x791)]=BattleManager[_0xfd5ed1(0x761)],BattleManager['processDefeat']=function(){const _0x1661ee=_0xfd5ed1;this[_0x1661ee(0x2db)]('BattleDefeatJS'),VisuMZ[_0x1661ee(0x1e9)]['BattleManager_processDefeat']['call'](this),this[_0x1661ee(0x3b9)](_0x1661ee(0xbad));},VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0x7a9)]=BattleManager[_0xfd5ed1(0xac5)],BattleManager[_0xfd5ed1(0xac5)]=function(_0x3ee0ab){const _0x297985=_0xfd5ed1;this[_0x297985(0x5a0)]=!![],this[_0x297985(0x373)]=![],this['processBattleCoreJS'](_0x297985(0x6cf)),VisuMZ['BattleCore']['BattleManager_endBattle'][_0x297985(0x740)](this,_0x3ee0ab),this['processBattleCoreJS']('PostEndBattleJS');},VisuMZ['BattleCore'][_0xfd5ed1(0x41c)]=BattleManager[_0xfd5ed1(0x704)],BattleManager['startTurn']=function(){const _0x1d711e=_0xfd5ed1;if(this[_0x1d711e(0x4bd)]())this[_0x1d711e(0x2db)](_0x1d711e(0xb57));VisuMZ['BattleCore'][_0x1d711e(0x41c)][_0x1d711e(0x740)](this);if(this[_0x1d711e(0x4bd)]())this['processBattleCoreJS'](_0x1d711e(0x542));},VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0x8e8)]=BattleManager['startAction'],BattleManager[_0xfd5ed1(0x92d)]=function(){const _0x192735=_0xfd5ed1,_0x45d2ea=this[_0x192735(0xb9a)][_0x192735(0xab8)](),_0x4e40d7=this[_0x192735(0xb9a)];if(_0x45d2ea&&_0x45d2ea[_0x192735(0x2f2)]()===_0x4e40d7){if(_0x192735(0x5cd)!==_0x192735(0xa6d))_0x45d2ea[_0x192735(0x962)]('PreStartActionJS');else{this[_0x192735(0xbc8)](_0x192735(0x2ae),_0xb84934);_0x24b1ea[_0x192735(0x1e9)][_0x192735(0x607)][_0x192735(0x472)][_0x192735(0x644)]&&this[_0x192735(0xbc8)](_0x192735(0x2c9),_0xedeb25,[_0x436674['_subject']],-0x1);if(!_0x1a83ac[_0x192735(0x1e9)][_0x192735(0x607)][_0x192735(0xbe6)][_0x192735(0x577)])return;this[_0x192735(0xbc8)](_0x192735(0x1e4),_0x3eb787[_0x192735(0xa51)][_0x192735(0x222)](_0x3b75c0[_0x192735(0x452)]()));}}VisuMZ[_0x192735(0x1e9)][_0x192735(0x8e8)][_0x192735(0x740)](this),_0x45d2ea&&_0x45d2ea[_0x192735(0x2f2)]()===_0x4e40d7&&_0x45d2ea[_0x192735(0x962)](_0x192735(0x88c));},VisuMZ['BattleCore'][_0xfd5ed1(0xa3b)]=BattleManager[_0xfd5ed1(0x907)],BattleManager[_0xfd5ed1(0x907)]=function(){const _0x3ad99c=_0xfd5ed1,_0x29a0b4=this[_0x3ad99c(0x2c6)],_0x2a36bf=this[_0x3ad99c(0xb9a)];if(_0x29a0b4&&_0x29a0b4!==this[_0x3ad99c(0x2cd)]&&_0x29a0b4['subject']()===_0x2a36bf){if(_0x3ad99c(0xb3e)!==_0x3ad99c(0x4c4))_0x29a0b4['actionBattleCoreJS']('PreEndActionJS');else{const _0x4b2395=_0x3244a8[_0x3ad99c(0x765)](_0x2893a1[_0x3ad99c(0xb4a)]/0x3),_0x57f5d6=this[_0x3ad99c(0x66b)]()?(_0x33e1bd[_0x3ad99c(0xb4a)]+_0x436139[_0x3ad99c(0x9c4)])/0x2-_0x4b2395:(_0xf95de9[_0x3ad99c(0xb4a)]-_0x233a60[_0x3ad99c(0x9c4)])/-0x2,_0x1ad580=this[_0x3ad99c(0x8ca)](),_0x2cf8f0=_0x1ad580['y']+_0x1ad580[_0x3ad99c(0x8c6)],_0x3c00e1=this['statusWindowRectBorderStyle'](),_0x56e964=_0x3c00e1['y']-_0x2cf8f0;return new _0x182d56(_0x57f5d6,_0x2cf8f0,_0x4b2395,_0x56e964);}}VisuMZ[_0x3ad99c(0x1e9)][_0x3ad99c(0xa3b)][_0x3ad99c(0x740)](this),_0x29a0b4&&_0x29a0b4!==this[_0x3ad99c(0x2cd)]&&_0x29a0b4['subject']()===_0x2a36bf&&_0x29a0b4[_0x3ad99c(0x962)](_0x3ad99c(0x2cb)),this[_0x3ad99c(0x3a5)](this[_0x3ad99c(0x4d1)]()),this[_0x3ad99c(0x2cd)]=this[_0x3ad99c(0x2c6)];},BattleManager[_0xfd5ed1(0x3a5)]=function(_0x4ad268){const _0x5bf28e=_0xfd5ed1;for(const _0x2cee47 of _0x4ad268){if(_0x5bf28e(0x709)!=='Mzetb'){if(!_0x2cee47)continue;if(!_0x2cee47['battler']())continue;_0x2cee47[_0x5bf28e(0x456)]()[_0x5bf28e(0x999)]();}else this[_0x5bf28e(0x3d3)]();}},BattleManager['updateAction']=function(){const _0x52c776=_0xfd5ed1;!this[_0x52c776(0x901)][_0x52c776(0x32f)]()&&this['endAction']();},Game_Battler[_0xfd5ed1(0x263)]['onAllActionsEnd']=function(){const _0x1ab1f9=_0xfd5ed1;this[_0x1ab1f9(0x2df)]();if(Imported[_0x1ab1f9(0xa7d)]){if(_0x1ab1f9(0x4a6)===_0x1ab1f9(0x4a6)){const _0x52b830=VisuMZ[_0x1ab1f9(0x753)][_0x1ab1f9(0x607)][_0x1ab1f9(0x189)];_0x52b830&&_0x52b830['ActionEndUpdate']===![]&&this[_0x1ab1f9(0x58f)](0x1);}else return this[_0x1ab1f9(0x368)]>0x0;}else this[_0x1ab1f9(0x58f)](0x1);this[_0x1ab1f9(0x22f)]();},BattleManager[_0xfd5ed1(0x2e3)]=function(){const _0x1fd6e2=_0xfd5ed1;this['_escapeRatio']=VisuMZ[_0x1fd6e2(0x1e9)][_0x1fd6e2(0x607)]['Mechanics'][_0x1fd6e2(0x652)]['call'](this);},VisuMZ['BattleCore'][_0xfd5ed1(0x220)]=BattleManager[_0xfd5ed1(0xaad)],BattleManager['onEscapeSuccess']=function(){const _0x172950=_0xfd5ed1;this[_0x172950(0x2db)](_0x172950(0x79a)),BattleManager[_0x172950(0xb41)][_0x172950(0x336)](),VisuMZ[_0x172950(0x1e9)][_0x172950(0x220)][_0x172950(0x740)](this),this['processPostBattleCommonEvents'](_0x172950(0xa01));},VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0x978)]=BattleManager[_0xfd5ed1(0xaee)],BattleManager[_0xfd5ed1(0xaee)]=function(){const _0x20de98=_0xfd5ed1;this[_0x20de98(0x2db)](_0x20de98(0x29c));const _0x4cc1bf=this[_0x20de98(0x283)];VisuMZ[_0x20de98(0x1e9)]['BattleManager_onEscapeFailure'][_0x20de98(0x740)](this),this[_0x20de98(0x283)]=_0x4cc1bf+VisuMZ['BattleCore'][_0x20de98(0x607)][_0x20de98(0x6d8)]['CalcEscapeRaiseJS'][_0x20de98(0x740)](this),this[_0x20de98(0x3b9)](_0x20de98(0x1a9));},BattleManager[_0xfd5ed1(0x5f1)]=function(){const _0x1edad1=_0xfd5ed1;let _0xb45e97=![];if(this[_0x1edad1(0xb4e)]()){if(_0x1edad1(0x40a)!==_0x1edad1(0x896))for(const _0x136e24 of $gameTroop['enemyNames']()){if(_0x1edad1(0x700)!=='bCmTW'){if(_0x25d0e3)_0x18261d[_0x1edad1(0xb9a)][_0x1edad1(0x63d)](![]);const _0xf14523=_0x14d945[0x0];_0x1efb7d[_0x1edad1(0x1a7)](_0xf14523,_0x1b52f2);}else this[_0x1edad1(0x901)]['push'](_0x1edad1(0x1e4),TextManager[_0x1edad1(0xa54)]['format'](_0x136e24)),this['_logWindow'][_0x1edad1(0xbc8)](_0x1edad1(0x3f7)),_0xb45e97=!![];}else{const _0x4bb49d=this[_0x1edad1(0x7a1)](),_0x242272=_0xf33a5['BattleCore']['Settings']['PartyCmd'][_0x1edad1(0x6b0)],_0x455ce3=_0x4bb49d===_0x1edad1(0x7e7)?_0x44858c['escape']:'\x5cI[%1]%2'[_0x1edad1(0x222)](_0x242272,_0x26255b[_0x1edad1(0x877)]),_0x2bd5f9=this[_0x1edad1(0x259)]();this[_0x1edad1(0x93b)](_0x455ce3,_0x1edad1(0x877),_0x2bd5f9);}}if(this[_0x1edad1(0xb4f)])this['_logWindow'][_0x1edad1(0xbc8)](_0x1edad1(0x1e4),TextManager[_0x1edad1(0xa14)][_0x1edad1(0x222)]($gameParty['name']())),this[_0x1edad1(0x901)][_0x1edad1(0xbc8)](_0x1edad1(0x3f7));else this['_surprise']&&(this[_0x1edad1(0x901)][_0x1edad1(0xbc8)](_0x1edad1(0x1e4),TextManager['surprise']['format']($gameParty[_0x1edad1(0x452)]())),this[_0x1edad1(0x901)][_0x1edad1(0xbc8)](_0x1edad1(0x3f7)));_0xb45e97&&(_0x1edad1(0x69e)===_0x1edad1(0x6e5)?_0x51863c[_0x1edad1(0x698)](this['subject']()):(this[_0x1edad1(0x901)][_0x1edad1(0xbc8)](_0x1edad1(0x3f7)),this[_0x1edad1(0x901)]['push'](_0x1edad1(0x3d1))));if(this['isTpb']()&&this['isSkipPartyCommandWindow']()){if('kmtAl'!==_0x1edad1(0x6d3)){if(_0xecaaed[_0x1edad1(0x699)])return;_0x4e0996[_0x1edad1(0x1e9)][_0x1edad1(0x722)]['call'](this);}else this[_0x1edad1(0x56d)]=![];}},BattleManager[_0xfd5ed1(0xb4e)]=function(){const _0x5be84b=_0xfd5ed1;if(BattleManager[_0x5be84b(0x373)])return![];return VisuMZ[_0x5be84b(0x1e9)][_0x5be84b(0x607)][_0x5be84b(0x1f5)][_0x5be84b(0x9f4)];},VisuMZ[_0xfd5ed1(0x1e9)]['BattleManager_startInput']=BattleManager['startInput'],BattleManager[_0xfd5ed1(0x2b5)]=function(){const _0xb85378=_0xfd5ed1;VisuMZ[_0xb85378(0x1e9)][_0xb85378(0x85d)][_0xb85378(0x740)](this),this[_0xb85378(0x6d1)]()&&this['isSkipPartyCommandWindow']()&&!this[_0xb85378(0x811)]&&$gameParty['canInput']()&&this['selectNextCommand']();},BattleManager[_0xfd5ed1(0x8e0)]=function(){const _0x2f74f6=_0xfd5ed1;return VisuMZ[_0x2f74f6(0x1e9)][_0x2f74f6(0x607)]['PartyCmd'][_0x2f74f6(0xb01)];},BattleManager[_0xfd5ed1(0x3ea)]=function(){const _0x4b7e90=_0xfd5ed1;this[_0x4b7e90(0xb2b)]()&&this[_0x4b7e90(0x8b9)]();},VisuMZ['BattleCore'][_0xfd5ed1(0xb61)]=Scene_Battle[_0xfd5ed1(0x263)]['startActorCommandSelection'],Scene_Battle['prototype']['startActorCommandSelection']=function(){const _0x4f233b=_0xfd5ed1;VisuMZ[_0x4f233b(0x1e9)][_0x4f233b(0xb61)][_0x4f233b(0x740)](this),BattleManager[_0x4f233b(0x47b)]()&&BattleManager[_0x4f233b(0x56d)]&&(BattleManager[_0x4f233b(0x56d)]=![],this[_0x4f233b(0x84b)]());},BattleManager['invokeMagicReflection']=function(_0x1dc36b,_0x3052e9){const _0x5a364b=_0xfd5ed1;this['_action']['_reflectionTarget']=_0x3052e9,this[_0x5a364b(0x901)][_0x5a364b(0x88a)](_0x3052e9),this['_logWindow'][_0x5a364b(0x7a5)](_0x1dc36b,this[_0x5a364b(0x2c6)]),this['_action'][_0x5a364b(0x989)](_0x1dc36b),this[_0x5a364b(0x901)]['displayActionResults'](_0x1dc36b,_0x1dc36b);},VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0x30e)]=BattleManager[_0xfd5ed1(0xa71)],BattleManager[_0xfd5ed1(0xa71)]=function(){const _0x566def=_0xfd5ed1;VisuMZ[_0x566def(0x1e9)][_0x566def(0x30e)][_0x566def(0x740)](this),this[_0x566def(0x7ef)]=this['_actionBattlers'][_0x566def(0x4af)](_0x7f9330=>_0x7f9330&&_0x7f9330['isAppeared']());},VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0x792)]=BattleManager[_0xfd5ed1(0x844)],BattleManager[_0xfd5ed1(0x844)]=function(_0x467e98){const _0x182f5c=_0xfd5ed1;if(this[_0x182f5c(0x38d)]===_0x182f5c(0x7f4))this[_0x182f5c(0xaa2)]();else{if(this[_0x182f5c(0x38d)]===_0x182f5c(0x7ed)){if(_0x182f5c(0x3ba)!=='PHEQS')this[_0x182f5c(0x731)]();else{return _0x3be502['BattleCore']['Game_Actor_makeActionList'][_0x182f5c(0x740)](this);;}}else VisuMZ[_0x182f5c(0x1e9)]['BattleManager_updatePhase'][_0x182f5c(0x740)](this,_0x467e98);}},BattleManager['prepareCustomActionSequence']=function(){const _0x44a7d0=_0xfd5ed1;this[_0x44a7d0(0x377)]=this[_0x44a7d0(0x2af)][_0x44a7d0(0x5e1)](0x0),this[_0x44a7d0(0xbdc)]=0x0,this[_0x44a7d0(0x235)]=this[_0x44a7d0(0x377)][0x0]||null,this['_phase']='custom';},BattleManager[_0xfd5ed1(0xaa2)]=function(){const _0x3b96c4=_0xfd5ed1;!this[_0x3b96c4(0x754)]()&&!this[_0x3b96c4(0x901)][_0x3b96c4(0x32f)]()&&(this[_0x3b96c4(0x38d)]=_0x3b96c4(0x7f5));},BattleManager['forceAction']=function(_0x1b8079){const _0x193eb7=_0xfd5ed1;this[_0x193eb7(0x7ef)][_0x193eb7(0x698)](_0x1b8079);if(_0x1b8079===this['_subject'])return;const _0x4d84e1=JsonEx[_0x193eb7(0x3dd)](_0x1b8079['currentAction']());this['_forcedBattlers'][_0x193eb7(0xbc8)]([_0x1b8079,_0x4d84e1]);},BattleManager[_0xfd5ed1(0x536)]=function(){},BattleManager['updateStart']=function(){const _0x5dd512=_0xfd5ed1;if(this['isTpb']())_0x5dd512(0x35e)!==_0x5dd512(0x35e)?this[_0x5dd512(0x4db)](_0x158b10,'tp',_0x2838ab+(_0x2a9b9a[_0x5dd512(0x9c5)]||0x0),_0x2d72a1+this[_0x5dd512(0x3b8)]()*0x2+(_0x1044ae[_0x5dd512(0xb52)]||0x0)):this[_0x5dd512(0x38d)]='turn';else this[_0x5dd512(0x8b0)][_0x5dd512(0x5b7)]>0x0?this[_0x5dd512(0x38d)]=_0x5dd512(0x756):this[_0x5dd512(0x2b5)]();},BattleManager[_0xfd5ed1(0xa95)]=function(){const _0x1b3f48=_0xfd5ed1,_0x1c30dd=this[_0x1b3f48(0xb9a)];_0x1c30dd&&this[_0x1b3f48(0x47b)]()&&_0x1c30dd[_0x1b3f48(0x3af)]('undecided');for(;;){if(_0x1b3f48(0x30b)===_0x1b3f48(0x48b))return this[_0x1b3f48(0x6d5)]();else{const _0x382aa3=this[_0x1b3f48(0x32b)]();if(!_0x382aa3){if(_0x1b3f48(0xada)!==_0x1b3f48(0xada))this[_0x1b3f48(0xbc8)](_0x1b3f48(0xa5e),_0x22c7b1);else return null;}if(_0x382aa3[_0x1b3f48(0x4cf)]()&&_0x382aa3[_0x1b3f48(0x56e)]()){if(_0x1b3f48(0x854)!==_0x1b3f48(0x854)){if(!_0x481e8f[_0x1b3f48(0xb27)]())return;_0x12ae3b[_0x1b3f48(0x1e9)][_0x1b3f48(0x58a)][_0x1b3f48(0x740)](this,_0x39ff92);}else return _0x382aa3;}}}},BattleManager[_0xfd5ed1(0x32b)]=function(){const _0x228e07=_0xfd5ed1;if(this[_0x228e07(0x8b0)]['length']>0x0){const _0x4c1772=this[_0x228e07(0x8b0)][_0x228e07(0x3a0)](),_0x5e0e5f=_0x4c1772[0x0];return _0x5e0e5f[_0x228e07(0x385)]=_0x5e0e5f['_actions']||[],_0x5e0e5f[_0x228e07(0x385)][0x0]=_0x4c1772[0x1],_0x5e0e5f;}else{if(_0x228e07(0xbaa)!==_0x228e07(0x444))return this[_0x228e07(0x7ef)][_0x228e07(0x3a0)]();else this[_0x228e07(0x74b)](_0x228e07(0x877));}},VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0xb08)]=Game_Battler[_0xfd5ed1(0x263)]['forceAction'],Game_Battler[_0xfd5ed1(0x263)][_0xfd5ed1(0x7ed)]=function(_0x53c215,_0x4bcde3){const _0x5d7a64=_0xfd5ed1;VisuMZ[_0x5d7a64(0x1e9)][_0x5d7a64(0xb08)][_0x5d7a64(0x740)](this,_0x53c215,_0x4bcde3),this['_actions'][this[_0x5d7a64(0x385)]['length']-0x1][_0x5d7a64(0xa65)]=!![];},Game_Interpreter['prototype'][_0xfd5ed1(0x238)]=function(_0x5c7920){const _0x11f118=_0xfd5ed1;return this[_0x11f118(0x84c)](_0x5c7920[0x0],_0x5c7920[0x1],_0x5c99ea=>{const _0x1b8ebb=_0x11f118;!_0x5c99ea[_0x1b8ebb(0x665)]()&&(_0x5c99ea[_0x1b8ebb(0x7ed)](_0x5c7920[0x2],_0x5c7920[0x3]),BattleManager[_0x1b8ebb(0x7ed)](_0x5c99ea));}),!![];},VisuMZ['BattleCore']['Game_Battler_makeSpeed']=Game_Battler[_0xfd5ed1(0x263)][_0xfd5ed1(0xbcc)],Game_Battler[_0xfd5ed1(0x263)][_0xfd5ed1(0xbcc)]=function(){const _0x5d023f=_0xfd5ed1;VisuMZ['BattleCore']['Game_Battler_makeSpeed'][_0x5d023f(0x740)](this),this['_actions'][_0x5d023f(0x5b7)]<=0x0&&(this[_0x5d023f(0x191)]=Number[_0x5d023f(0x8a2)]);},VisuMZ['BattleCore'][_0xfd5ed1(0x846)]=BattleManager[_0xfd5ed1(0x8b9)],BattleManager[_0xfd5ed1(0x8b9)]=function(){const _0x13c835=_0xfd5ed1;this['isTpb']()?this['selectNextCommandTpb']():VisuMZ[_0x13c835(0x1e9)][_0x13c835(0x846)][_0x13c835(0x740)](this);},BattleManager[_0xfd5ed1(0x1a3)]=function(){const _0x5aede8=_0xfd5ed1;if(this[_0x5aede8(0x82e)]){if('UPcCz'===_0x5aede8(0x928))this['_linkedSprite']=_0x57903a;else{if(this[_0x5aede8(0x82e)][_0x5aede8(0x8b9)]())return;this[_0x5aede8(0x92c)](),this[_0x5aede8(0x92e)]();if(!this[_0x5aede8(0xb9a)]&&!this['_currentActor']){if(_0x5aede8(0x36b)==='drGXZ')SceneManager['_scene'][_0x5aede8(0x7be)]();else{if(!_0x2c7542['isSideView']())return![];return![];}}}}else{if(!this[_0x5aede8(0xb9a)]){if(_0x5aede8(0xadf)===_0x5aede8(0x199)){const _0x32a122=_0x205f93(_0x4c1029['$1'])[_0x5aede8(0x300)](),_0x3255e9=_0x5ef468(_0x1b214b['$2']);_0x3cbe9c[_0x32a122]=_0x3255e9,_0x28c0c4+=_0x3255e9;}else this['selectNextActor']();}}},BattleManager[_0xfd5ed1(0x92e)]=function(){const _0x2362a5=_0xfd5ed1;if(!this[_0x2362a5(0xb2b)]()||this['needsActorInputCancel']()){if(this[_0x2362a5(0xabe)]){if(!$gameParty[_0x2362a5(0x6d2)]()['includes'](this['_tpbSceneChangeCacheActor'])){if(_0x2362a5(0xb40)!==_0x2362a5(0xb40)){if(this[_0x2362a5(0x527)]>0x0){const _0x5ecef4=this[_0x2362a5(0x527)],_0x4efce2=this[_0x2362a5(0x359)];_0x4efce2['x']=(_0x4efce2['x']*(_0x5ecef4-0x1)+this[_0x2362a5(0x81d)])/_0x5ecef4,_0x4efce2[_0x2362a5(0x9ac)]=(_0x4efce2[_0x2362a5(0x9ac)]*(_0x5ecef4-0x1)+0xff)/_0x5ecef4,this[_0x2362a5(0x527)]--;}}else this[_0x2362a5(0xabe)]=null;}}!this[_0x2362a5(0xabe)]?(this[_0x2362a5(0x677)](),this[_0x2362a5(0x82e)]=null,this[_0x2362a5(0xb75)]=![]):this[_0x2362a5(0x1e0)]();}},BattleManager[_0xfd5ed1(0x1e0)]=function(){const _0x4113e6=_0xfd5ed1;!$gameParty[_0x4113e6(0x6d2)]()[_0x4113e6(0x4b6)](this['_tpbSceneChangeCacheActor'])&&(this[_0x4113e6(0xabe)]=null);if(this['_tpbSceneChangeCacheActor'])this[_0x4113e6(0x82e)]=this['_tpbSceneChangeCacheActor'],this[_0x4113e6(0x82e)][_0x4113e6(0x8c8)]=_0x4113e6(0x852),this[_0x4113e6(0xb75)]=!![],this['_tpbSceneChangeCacheActor']=null;else{if(_0x4113e6(0x2e4)===_0x4113e6(0x2f8))return this['isFrameVisible']()?0x0:0xa;else this[_0x4113e6(0x677)](),this['_currentActor']=null,this[_0x4113e6(0xb75)]=![];}},VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0x8d9)]=BattleManager[_0xfd5ed1(0xa0c)],BattleManager[_0xfd5ed1(0xa0c)]=function(){const _0x3fa7eb=_0xfd5ed1;if(this[_0x3fa7eb(0x38d)]==='custom')return this[_0x3fa7eb(0x4b7)]();else{if(_0x3fa7eb(0xaf8)!==_0x3fa7eb(0x9f6))return VisuMZ['BattleCore'][_0x3fa7eb(0x8d9)][_0x3fa7eb(0x740)](this);else _0x32a2d1[_0x3fa7eb(0x1e9)][_0x3fa7eb(0x6c6)][_0x3fa7eb(0x740)](this),this['initMembersBattleCore']();}},BattleManager['battleCoreTpbMainPhase']=function(){const _0x565adb=_0xfd5ed1;return this[_0x565adb(0x415)]();},VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0x3dc)]=BattleManager['cancelActorInput'],BattleManager[_0xfd5ed1(0x677)]=function(){const _0x2143b2=_0xfd5ed1;this['isTpb']()&&this[_0x2143b2(0x38d)]===_0x2143b2(0x57f)&&(this[_0x2143b2(0x82e)]=null),VisuMZ['BattleCore'][_0x2143b2(0x3dc)][_0x2143b2(0x740)](this);},VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0x92a)]=BattleManager[_0xfd5ed1(0x623)],BattleManager[_0xfd5ed1(0x623)]=function(){const _0x566139=_0xfd5ed1,_0x4927be=this[_0x566139(0x82e)];if(_0x4927be&&!_0x4927be[_0x566139(0x623)]()){if('tYHhO'!==_0x566139(0xae8)){const _0x4dec9b=_0x4927be[_0x566139(0x4c9)];_0x4927be[_0x566139(0x385)][_0x4dec9b]=new Game_Action(_0x4927be);}else this[_0x566139(0xbc8)]('performRecovery',_0x1174af);}return VisuMZ[_0x566139(0x1e9)][_0x566139(0x92a)][_0x566139(0x740)](this);},SceneManager[_0xfd5ed1(0xbb7)]=function(){const _0xccd71f=_0xfd5ed1;return this[_0xccd71f(0x3c3)]&&this[_0xccd71f(0x3c3)][_0xccd71f(0x18a)]===Scene_Battle;},SceneManager[_0xfd5ed1(0x438)]=function(){const _0x2ba891=_0xfd5ed1;return Spriteset_Battle[_0x2ba891(0x263)][_0x2ba891(0x447)]();},SceneManager[_0xfd5ed1(0x957)]=function(){const _0x333315=_0xfd5ed1;if(SceneManager[_0x333315(0x990)](Scene_Options))return!![];return![];},SceneManager[_0xfd5ed1(0x916)]=function(){if(SceneManager['isNextScene'](Scene_Options))return!![];return![];},VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0x92f)]=Game_Temp['prototype']['requestAnimation'],Game_Temp['prototype'][_0xfd5ed1(0x307)]=function(_0x3e01c7,_0x28ed86,_0x182fd6){const _0x7b2538=_0xfd5ed1;_0x3e01c7=_0x3e01c7[_0x7b2538(0x4af)]((_0x8bbe79,_0x5d9135,_0x1af6e7)=>_0x1af6e7[_0x7b2538(0x981)](_0x8bbe79)===_0x5d9135);SceneManager['isSceneBattle']()&&SceneManager[_0x7b2538(0x438)]()&&(_0x7b2538(0xa86)!==_0x7b2538(0xa86)?(_0x5c7c24=_0x1b974b['width']/_0x26d540[_0x7b2538(0x6d2)]()[_0x7b2538(0x5b7)],_0x4d5bf2*=_0x50f1ff,_0x44e5e4+=_0x4b7f44[_0x7b2538(0xb4a)]/_0xd8efa5[_0x7b2538(0x6d2)]()[_0x7b2538(0x5b7)]/0x2):_0x182fd6=!_0x182fd6);VisuMZ[_0x7b2538(0x1e9)][_0x7b2538(0x92f)]['call'](this,_0x3e01c7,_0x28ed86,_0x182fd6);if(SceneManager['isSceneBattle']()){if(_0x7b2538(0x280)===_0x7b2538(0xa8e))return _0x49209d(_0x430a2f['$1'])*0.01;else BattleManager[_0x7b2538(0xb41)]['processAnimationRequests']();}},Game_Temp[_0xfd5ed1(0x263)]['setLastPluginCommandInterpreter']=function(_0x13523a){this['_lastPluginCommandInterpreter']=_0x13523a;},Game_Temp[_0xfd5ed1(0x263)]['getLastPluginCommandInterpreter']=function(){const _0x3a04bc=_0xfd5ed1;return this[_0x3a04bc(0x378)];},Game_Temp['prototype'][_0xfd5ed1(0x4a8)]=function(){const _0x59185f=_0xfd5ed1;this[_0x59185f(0x952)]=undefined;},Game_Temp['prototype'][_0xfd5ed1(0x204)]=function(_0x394b06){const _0x2a281d=_0xfd5ed1;if($gameMap&&$dataMap&&$dataMap[_0x2a281d(0x80f)]){if('DWEwf'!==_0x2a281d(0xa55)){if(!_0x40a766[_0x2a281d(0xbb7)]())return;_0x36b912[_0x2a281d(0x1c5)](_0x7b31d2,_0x1a40aa);const _0x31be6c=_0x25d6e6['_action'];if(!_0x31be6c)return;let _0x4d1a4d=_0x2b2014['Formula'];_0x31be6c[_0x2a281d(0x224)](_0x4d1a4d);}else this[_0x2a281d(0x77d)]($dataMap[_0x2a281d(0x80f)]);}const _0x4a6b7d=$dataTroops[_0x394b06];if(_0x4a6b7d){let _0x281309=DataManager[_0x2a281d(0x332)](_0x4a6b7d['id']);this[_0x2a281d(0x77d)](_0x281309);}},Game_Temp[_0xfd5ed1(0x263)][_0xfd5ed1(0x77d)]=function(_0x16c3b5){const _0x11effb=_0xfd5ed1;if(!_0x16c3b5)return;if(_0x16c3b5[_0x11effb(0x9e4)](/<(?:BATTLELAYOUT|BATTLE LAYOUT|LAYOUT):[ ](.*)>/i)){const _0x1b9404=String(RegExp['$1']);if(_0x1b9404[_0x11effb(0x9e4)](/DEFAULT/i))this[_0x11effb(0x952)]='default';else{if(_0x1b9404['match'](/LIST/i))this[_0x11effb(0x952)]='list';else{if(_0x1b9404[_0x11effb(0x9e4)](/XP/i)){if(_0x11effb(0x893)===_0x11effb(0xa27))return this[_0x11effb(0x5b6)]();else this[_0x11effb(0x952)]='xp';}else{if(_0x1b9404[_0x11effb(0x9e4)](/PORTRAIT/i)){if(_0x11effb(0x1d6)!==_0x11effb(0xb51))this['_forcedBattleLayout']=_0x11effb(0x1fe);else{if(this[_0x11effb(0x385)]['some'](_0x31ae74=>_0x31ae74[_0x11effb(0x3c7)]()&&_0x31ae74['isMagical']()))return!![];}}else{if(_0x1b9404[_0x11effb(0x9e4)](/BORDER/i))this[_0x11effb(0x952)]=_0x11effb(0x9cf);else _0x1b9404[_0x11effb(0x9e4)](/(?:SIDEVIEW UI|SIDEVIEW)/i)&&(Imported[_0x11effb(0x6fd)]?this['_forcedBattleLayout']=_0x11effb(0x643):this[_0x11effb(0x952)]='default');}}}}}},VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0xab4)]=Game_System[_0xfd5ed1(0x263)]['initialize'],Game_System['prototype'][_0xfd5ed1(0xbe5)]=function(){const _0x4ae4c8=_0xfd5ed1;VisuMZ[_0x4ae4c8(0x1e9)]['Game_System_initialize'][_0x4ae4c8(0x740)](this),this['initBattleCore']();},Game_System['prototype'][_0xfd5ed1(0xac7)]=function(){const _0x398eff=_0xfd5ed1;this[_0x398eff(0x433)]=this['_defeatedEnemies']||[];},Game_System['prototype'][_0xfd5ed1(0x7d1)]=function(){const _0x107267=_0xfd5ed1;if(this['_defeatedEnemies']===undefined)this[_0x107267(0xac7)]();return this[_0x107267(0x433)];},Game_System['prototype'][_0xfd5ed1(0x521)]=function(_0x54cb1b){const _0x10c047=_0xfd5ed1;if(this[_0x10c047(0x433)]===undefined)this[_0x10c047(0xac7)]();if(!_0x54cb1b)return;if(this[_0x10c047(0x433)][_0x10c047(0x4b6)](_0x54cb1b))return;this['_defeatedEnemies'][_0x10c047(0xbc8)](_0x54cb1b),this[_0x10c047(0x433)][_0x10c047(0x7f1)]((_0x29f24e,_0xcc0164)=>_0x29f24e-_0xcc0164);},VisuMZ[_0xfd5ed1(0x1e9)]['Game_BattlerBase_addNewState']=Game_BattlerBase[_0xfd5ed1(0x263)][_0xfd5ed1(0x673)],Game_BattlerBase[_0xfd5ed1(0x263)][_0xfd5ed1(0x673)]=function(_0x56ea45){const _0x11ba27=_0xfd5ed1,_0x3682de=this[_0x11ba27(0x56e)](),_0xea9db8=this[_0x11ba27(0x560)]();VisuMZ[_0x11ba27(0x1e9)][_0x11ba27(0x760)][_0x11ba27(0x740)](this,_0x56ea45),this[_0x11ba27(0x73c)]()&&_0x3682de&&this[_0x11ba27(0x7b0)]()&&(this['_visualHpGauge_JustDied']=!this[_0x11ba27(0x5bc)](),$gameSystem['registerDefeatedEnemy'](this[_0x11ba27(0x79e)]())),SceneManager[_0x11ba27(0xbb7)]()&&_0xea9db8!==this['stateMotionIndex']()&&(_0x11ba27(0xa7a)===_0x11ba27(0xa7a)?this[_0x11ba27(0x456)]()&&this[_0x11ba27(0x456)]()[_0x11ba27(0x999)]():_0x1a539b[_0x11ba27(0x1e9)][_0x11ba27(0x29f)][_0x11ba27(0x740)](this));},Game_Enemy['prototype']['hasBeenDefeatedBefore']=function(){const _0x299681=_0xfd5ed1;return $gameSystem['getDefeatedEnemies']()[_0x299681(0x4b6)](this[_0x299681(0xb94)]);},VisuMZ[_0xfd5ed1(0x1e9)]['Game_BattlerBase_eraseState']=Game_BattlerBase[_0xfd5ed1(0x263)][_0xfd5ed1(0xb8b)],Game_BattlerBase[_0xfd5ed1(0x263)][_0xfd5ed1(0xb8b)]=function(_0x2336d3){const _0x2600e3=_0xfd5ed1;VisuMZ[_0x2600e3(0x1e9)]['Game_BattlerBase_eraseState']['call'](this,_0x2336d3);this['isEnemy']()&&_0x2336d3===this[_0x2600e3(0x5f5)]()&&this['isAlive']()&&(_0x2600e3(0x97f)!==_0x2600e3(0x97f)?this[_0x2600e3(0x5fc)]=!![]:this[_0x2600e3(0x4f4)]=![]);if(!this[_0x2600e3(0x613)]&&!this['_tempBattler']&&SceneManager[_0x2600e3(0xbb7)]()){if(_0x2600e3(0x3cd)!==_0x2600e3(0x3cd)){const _0x248f87=_0x3de0d5[_0x2600e3(0x1e9)][_0x2600e3(0x607)]['AutoBattle'],_0x28214f=this[_0x2600e3(0x371)](_0x2600e3(0xb8c));return _0x28214f?_0x248f87[_0x2600e3(0x985)]:_0x248f87[_0x2600e3(0x80e)];}else this[_0x2600e3(0x75c)]();}},VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0xb11)]=Game_Action[_0xfd5ed1(0x263)]['clear'],Game_Action[_0xfd5ed1(0x263)]['clear']=function(){const _0x136bf8=_0xfd5ed1;VisuMZ[_0x136bf8(0x1e9)][_0x136bf8(0xb11)]['call'](this),this['_armorPenetration']={'arPenRate':0x0,'arPenFlat':0x0,'arRedRate':0x0,'arRedFlat':0x0},this[_0x136bf8(0xb18)]={'criticalHitRate':0x1,'criticalHitFlat':0x0,'criticalDmgRate':0x1,'criticalDmgFlat':0x0,'damageRate':0x1,'damageFlat':0x0,'hitRate':0x1,'hitFlat':0x0},this['_customDamageFormula']=_0x136bf8(0x702);},Game_Action[_0xfd5ed1(0x263)][_0xfd5ed1(0x451)]=function(_0x12a8f6,_0x1e18bf){const _0x380f22=_0xfd5ed1;return VisuMZ[_0x380f22(0x1e9)]['Settings'][_0x380f22(0x608)]['OverallFormulaJS']['call'](this,_0x12a8f6,_0x1e18bf);},Game_Action[_0xfd5ed1(0x263)]['applyVariance']=function(_0x3ef1e3,_0x40c043){const _0xf77d12=_0xfd5ed1;return VisuMZ[_0xf77d12(0x1e9)]['Settings'][_0xf77d12(0x608)][_0xf77d12(0x99c)][_0xf77d12(0x740)](this,_0x3ef1e3,_0x40c043);},Game_Action[_0xfd5ed1(0x263)][_0xfd5ed1(0x1c8)]=function(_0x22484e,_0x4bdb93){const _0x5ec29e=_0xfd5ed1;return VisuMZ[_0x5ec29e(0x1e9)][_0x5ec29e(0x607)][_0x5ec29e(0x608)][_0x5ec29e(0x2b1)][_0x5ec29e(0x740)](this,_0x22484e,_0x4bdb93);},VisuMZ['BattleCore']['Game_Action_itemHit']=Game_Action[_0xfd5ed1(0x263)][_0xfd5ed1(0x796)],Game_Action[_0xfd5ed1(0x263)][_0xfd5ed1(0x796)]=function(_0x417bc9){const _0x52796b=_0xfd5ed1,_0x12e547=this[_0x52796b(0x3c7)]()['note'];if(_0x12e547[_0x52796b(0x9e4)](/<ALWAYS HIT>/i))return 0x1;else{if(_0x12e547[_0x52796b(0x9e4)](/<ALWAYS HIT RATE: (\d+)([%％])>/i))return Number(RegExp['$1'])/0x64;else{if(_0x52796b(0x6b4)===_0x52796b(0x6b4)){let _0x227740=VisuMZ[_0x52796b(0x1e9)][_0x52796b(0xa3f)][_0x52796b(0x740)](this,_0x417bc9);return _0x227740=this['_multipliers'][_0x52796b(0x8e7)]*_0x227740+this[_0x52796b(0xb18)][_0x52796b(0x619)],_0x227740;}else this[_0x52796b(0x952)]=_0x9109f6;}}},Game_Action[_0xfd5ed1(0x263)][_0xfd5ed1(0x847)]=function(_0x408910){const _0x31c28c=_0xfd5ed1;if(!this['item']()['damage'][_0x31c28c(0x6c7)])return 0x0;let _0x14102b=VisuMZ[_0x31c28c(0x1e9)][_0x31c28c(0x607)][_0x31c28c(0x608)][_0x31c28c(0xa04)][_0x31c28c(0x740)](this,_0x408910);return _0x14102b=this[_0x31c28c(0xb18)]['criticalHitRate']*_0x14102b+this[_0x31c28c(0xb18)][_0x31c28c(0x9da)],_0x14102b;},Game_Action[_0xfd5ed1(0x263)][_0xfd5ed1(0x2bd)]=function(_0x144c23){const _0x45cb47=_0xfd5ed1;return _0x144c23=VisuMZ[_0x45cb47(0x1e9)][_0x45cb47(0x607)]['Damage'][_0x45cb47(0x6df)][_0x45cb47(0x740)](this,_0x144c23),_0x144c23=this[_0x45cb47(0xb18)][_0x45cb47(0x245)]*_0x144c23+this[_0x45cb47(0xb18)][_0x45cb47(0x8c3)],_0x144c23;},VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0x94e)]=Game_Action['prototype']['evalDamageFormula'],Game_Action[_0xfd5ed1(0x263)]['evalDamageFormula']=function(_0x1861ce){const _0x5d6d9a=_0xfd5ed1;if(this['_customDamageFormula']!==_0x5d6d9a(0x702))return this[_0x5d6d9a(0xbca)](_0x1861ce);else{if(DataManager[_0x5d6d9a(0xbac)](this[_0x5d6d9a(0x3c7)]())===_0x5d6d9a(0xab3)){if(_0x5d6d9a(0x5ab)==='jBRHJ')return VisuMZ[_0x5d6d9a(0x1e9)]['Game_Action_evalDamageFormula'][_0x5d6d9a(0x740)](this,_0x1861ce);else this[_0x5d6d9a(0x57b)]()?this[_0x5d6d9a(0x729)]():this[_0x5d6d9a(0x9e7)]();}else return this['evalDamageFormulaBattleCore'](_0x1861ce);}},Game_Action['prototype'][_0xfd5ed1(0x224)]=function(_0x11fb34){const _0x1d188a=_0xfd5ed1;this[_0x1d188a(0x36d)]=_0x11fb34;},Game_Action[_0xfd5ed1(0x263)][_0xfd5ed1(0xbca)]=function(_0x14bb25){const _0x3c3f2b=_0xfd5ed1,_0x4a42d1=this[_0x3c3f2b(0x3c7)](),_0x356e93=_0x4a42d1['damage']['formula'];_0x4a42d1[_0x3c3f2b(0x42d)][_0x3c3f2b(0xbda)]=this[_0x3c3f2b(0x36d)];let _0x4967a3=VisuMZ[_0x3c3f2b(0x1e9)][_0x3c3f2b(0x94e)][_0x3c3f2b(0x740)](this,_0x14bb25);return _0x4a42d1[_0x3c3f2b(0x42d)]['formula']=_0x356e93,_0x4967a3;},Game_Action[_0xfd5ed1(0x263)][_0xfd5ed1(0x8d2)]=function(){const _0x2f4bc1=_0xfd5ed1;if(this[_0x2f4bc1(0x3c7)]()[_0x2f4bc1(0x80f)][_0x2f4bc1(0x9e4)](/<DAMAGE STYLE:[ ](.*)>/i)){const _0x36f952=String(RegExp['$1'])[_0x2f4bc1(0xa50)]()[_0x2f4bc1(0x300)]();return _0x36f952;}return _0x2f4bc1(0xab3);},Game_Action[_0xfd5ed1(0x263)][_0xfd5ed1(0xa20)]=function(_0x56fbda){const _0x5874db=_0xfd5ed1,_0x48fd8e=DataManager[_0x5874db(0xbac)](this[_0x5874db(0x3c7)]()),_0x3aee0c=VisuMZ[_0x5874db(0x5da)][_0x48fd8e];try{return _0x3aee0c[_0x5874db(0x231)][_0x5874db(0x740)](this,_0x56fbda);}catch(_0x1024af){if(_0x5874db(0x5b0)===_0x5874db(0x5b0)){if($gameTemp[_0x5874db(0xa8c)]())console[_0x5874db(0xa22)](_0x1024af);return VisuMZ['BattleCore'][_0x5874db(0x94e)]['call'](this);}else this[_0x5874db(0x8ba)]();}},Game_Action[_0xfd5ed1(0x263)][_0xfd5ed1(0x28a)]=function(_0x2ce0c3,_0xae31c7){const _0x2025a4=_0xfd5ed1;if(this[_0x2025a4(0x2a9)]())return _0xae31c7;const _0x4b7861=this['subject'](),_0xca94df=_0x2ce0c3;let _0x1ee080=[],_0x5a5932=[];_0x1ee080[_0x2025a4(0xbc8)](this[_0x2025a4(0x949)]['arPenFlat'],this['_armorPenetration']['arRedFlat']),_0x5a5932[_0x2025a4(0xbc8)](this[_0x2025a4(0x949)]['arPenRate'],this[_0x2025a4(0x949)]['arRedRate']);const _0x4d6320=this[_0x2025a4(0x946)]()?/<ARMOR REDUCTION:[ ](\d+\.?\d*)>/i:/<MAGIC REDUCTION:[ ](\d+\.?\d*)>/i,_0x2e6aa1=this[_0x2025a4(0x946)]()?/<ARMOR REDUCTION:[ ](\d+\.?\d*)([%％])>/i:/<MAGIC REDUCTION:[ ](\d+\.?\d*)([%％])>/i,_0xe6cc4d=this['isPhysical']()?/<ARMOR PENETRATION:[ ](\d+\.?\d*)>/i:/<MAGIC PENETRATION:[ ](\d+\.?\d*)>/i,_0x3feb9f=this[_0x2025a4(0x946)]()?/<ARMOR PENETRATION:[ ](\d+\.?\d*)([%％])>/i:/<MAGIC PENETRATION:[ ](\d+\.?\d*)([%％])>/i;return _0x1ee080=_0x1ee080['concat'](_0xca94df['traitObjects']()[_0x2025a4(0x3ee)](_0x2fb2a5=>_0x2fb2a5&&_0x2fb2a5[_0x2025a4(0x80f)]['match'](_0x4d6320)?Number(RegExp['$1']):0x0)),_0x5a5932=_0x5a5932[_0x2025a4(0x504)](_0xca94df['traitObjects']()['map'](_0x426d38=>_0x426d38&&_0x426d38[_0x2025a4(0x80f)][_0x2025a4(0x9e4)](_0x2e6aa1)?Number(RegExp['$1'])/0x64:0x0)),_0x1ee080=_0x1ee080[_0x2025a4(0x504)](_0x4b7861[_0x2025a4(0x5ec)]()['map'](_0x5b5272=>_0x5b5272&&_0x5b5272[_0x2025a4(0x80f)][_0x2025a4(0x9e4)](_0xe6cc4d)?Number(RegExp['$1']):0x0)),_0x5a5932=_0x5a5932[_0x2025a4(0x504)](_0x4b7861[_0x2025a4(0x5ec)]()[_0x2025a4(0x3ee)](_0x998de7=>_0x998de7&&_0x998de7[_0x2025a4(0x80f)][_0x2025a4(0x9e4)](_0x3feb9f)?Number(RegExp['$1'])/0x64:0x0)),this[_0x2025a4(0x3c7)]()['note'][_0x2025a4(0x9e4)](_0xe6cc4d)&&_0x1ee080['push'](Number(RegExp['$1'])),this[_0x2025a4(0x3c7)]()[_0x2025a4(0x80f)][_0x2025a4(0x9e4)](_0x3feb9f)&&_0x5a5932['push'](Number(RegExp['$1'])),_0xae31c7=_0x1ee080[_0x2025a4(0x42c)]((_0x4fb14f,_0x1972e5)=>_0x4fb14f-_0x1972e5,_0xae31c7),_0xae31c7>0x0&&(_0xae31c7=_0x5a5932[_0x2025a4(0x42c)]((_0x115b9a,_0x2fde97)=>_0x115b9a*(0x1-_0x2fde97),_0xae31c7)),_0xae31c7;},VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0x660)]=Game_Action['prototype'][_0xfd5ed1(0x9b5)],Game_Action['prototype'][_0xfd5ed1(0x9b5)]=function(_0x1cf426,_0x3d2cf6){const _0xefc85d=_0xfd5ed1;_0x3d2cf6=_0x3d2cf6*this[_0xefc85d(0xb18)][_0xefc85d(0x46b)],_0x3d2cf6+=this[_0xefc85d(0xb18)][_0xefc85d(0x593)]*(_0x3d2cf6>=0x0?0x1:-0x1),_0x3d2cf6=this[_0xefc85d(0x523)](_0xefc85d(0xb03),_0x1cf426,_0x3d2cf6,![]),_0x3d2cf6=this[_0xefc85d(0x55d)](_0x3d2cf6),_0x3d2cf6=Math[_0xefc85d(0x271)](_0x3d2cf6),this[_0xefc85d(0x620)]=_0x3d2cf6,this[_0xefc85d(0x662)]=this[_0xefc85d(0x662)]||0x0,this['_totalValue']+=_0x3d2cf6,VisuMZ[_0xefc85d(0x1e9)][_0xefc85d(0x660)]['call'](this,_0x1cf426,_0x3d2cf6),this[_0xefc85d(0x523)]('PostDamage%1JS',_0x1cf426,_0x3d2cf6,!![]);},Game_Action[_0xfd5ed1(0x263)][_0xfd5ed1(0x55d)]=function(_0x550776){const _0x4d8f25=_0xfd5ed1;if(this[_0x4d8f25(0x1c0)]())return _0x550776;return _0x550776=this[_0x4d8f25(0x5e0)](_0x550776),_0x550776=this[_0x4d8f25(0x883)](_0x550776),_0x550776;},Game_Action[_0xfd5ed1(0x263)][_0xfd5ed1(0x1c0)]=function(){const _0x209269=_0xfd5ed1,_0xed52b=/<BYPASS DAMAGE CAP>/i;if(this[_0x209269(0x3c7)]()[_0x209269(0x80f)][_0x209269(0x9e4)](_0xed52b))return!![];if(this[_0x209269(0x2f2)]()[_0x209269(0x5ec)]()[_0x209269(0x9d6)](_0xf3f724=>_0xf3f724&&_0xf3f724['note'][_0x209269(0x9e4)](_0xed52b)))return!![];return!VisuMZ[_0x209269(0x1e9)][_0x209269(0x607)]['Damage'][_0x209269(0x7fc)];},Game_Action[_0xfd5ed1(0x263)]['applySoftDamageCap']=function(_0x150e2e){const _0x58cd32=_0xfd5ed1;if(!VisuMZ['BattleCore'][_0x58cd32(0x607)]['Damage'][_0x58cd32(0x257)])return _0x150e2e;const _0x53b08a=/<BYPASS SOFT DAMAGE CAP>/i;if(this[_0x58cd32(0x3c7)]()[_0x58cd32(0x80f)][_0x58cd32(0x9e4)](_0x53b08a))return!![];if(this['subject']()['traitObjects']()['some'](_0x44862b=>_0x44862b&&_0x44862b['note'][_0x58cd32(0x9e4)](_0x53b08a)))return!![];const _0x27055c=_0x150e2e<0x0?-0x1:0x1;_0x150e2e=Math['abs'](_0x150e2e);let _0x36ba54=this['subject']()[_0x58cd32(0x5a6)]();this[_0x58cd32(0x3c7)]()['note'][_0x58cd32(0x9e4)](/<SOFT DAMAGE CAP:[ ]([\+\-]\d+)([%％])>/i)&&(_0x36ba54+=Number(RegExp['$1'])/0x64);_0x36ba54=_0x36ba54[_0x58cd32(0x8e6)](0.01,0x1);const _0x295457=this[_0x58cd32(0x41a)](),_0x39ecb1=_0x36ba54*_0x295457;if(_0x150e2e>_0x39ecb1&&_0x295457>_0x39ecb1){if('KOGAN'!=='mmnlj'){_0x150e2e-=_0x39ecb1;const _0x1e59b3=VisuMZ[_0x58cd32(0x1e9)][_0x58cd32(0x607)][_0x58cd32(0x608)]['DefaultSoftScaler'],_0x95d60e=Math[_0x58cd32(0x4d3)](0x1-_0x150e2e/((_0x295457-_0x39ecb1)*_0x1e59b3+_0x150e2e),0.01);_0x150e2e*=_0x95d60e,_0x150e2e+=_0x39ecb1;}else _0x2f6cc0[_0x58cd32(0xa2a)](_0x23c337);}return _0x150e2e*_0x27055c;},Game_Action[_0xfd5ed1(0x263)]['getHardDamageCap']=function(){const _0x5f2f32=_0xfd5ed1;return this[_0x5f2f32(0x3c7)]()[_0x5f2f32(0x80f)]['match'](/<DAMAGE CAP:[ ](\d+)>/i)?Number(RegExp['$1']):this['subject']()[_0x5f2f32(0x5f4)]();},Game_Action[_0xfd5ed1(0x263)]['applyHardDamageCap']=function(_0x77bd19){const _0x1904cc=_0xfd5ed1;let _0x6022a3=this[_0x1904cc(0x41a)]();return _0x77bd19[_0x1904cc(0x8e6)](-_0x6022a3,_0x6022a3);},VisuMZ['BattleCore'][_0xfd5ed1(0x788)]=Game_Action[_0xfd5ed1(0x263)][_0xfd5ed1(0x989)],Game_Action[_0xfd5ed1(0x263)][_0xfd5ed1(0x989)]=function(_0x2af59a){const _0x35e4d2=_0xfd5ed1;this['applyBattleCoreJS'](_0x35e4d2(0x8b2),_0x2af59a,0x0,!![]),VisuMZ['BattleCore'][_0x35e4d2(0x788)][_0x35e4d2(0x740)](this,_0x2af59a),this[_0x35e4d2(0x523)]('PostApply%1JS',_0x2af59a,this[_0x35e4d2(0x620)]||0x0,!![]),this['applyResultSwitches'](_0x2af59a);},Game_Action['prototype'][_0xfd5ed1(0x523)]=function(_0x2e5942,_0x50f3fd,_0x2821a3,_0xd5fb71){const _0x53a2d5=_0xfd5ed1;if(this['_tempBattler']||this['_tempActor'])return;_0x2821a3=_0x2821a3||0x0;const _0x2dfe10=_0x2821a3,_0xd46dd6=VisuMZ['BattleCore'][_0x53a2d5(0x607)][_0x53a2d5(0x6d8)],_0x11e1d1=_0x2e5942[_0x53a2d5(0x222)]('');if(_0xd46dd6[_0x11e1d1]){_0x2821a3=_0xd46dd6[_0x11e1d1][_0x53a2d5(0x740)](this,_0x2821a3,_0x50f3fd);if(_0xd5fb71)_0x2821a3=_0x2dfe10;}let _0xd6e8f9=VisuMZ[_0x53a2d5(0x1e9)]['createKeyJS'](this[_0x53a2d5(0x3c7)](),_0x2e5942['format'](''));if(VisuMZ[_0x53a2d5(0x1e9)]['JS'][_0xd6e8f9]){_0x2821a3=VisuMZ['BattleCore']['JS'][_0xd6e8f9]['call'](this,this[_0x53a2d5(0x2f2)](),_0x50f3fd,this[_0x53a2d5(0x3c7)](),_0x2821a3);if(_0xd5fb71)_0x2821a3=_0x2dfe10;}for(const _0x35d7d0 of this[_0x53a2d5(0x2f2)]()[_0x53a2d5(0x5ec)]()){if(!_0x35d7d0)continue;_0xd6e8f9=VisuMZ[_0x53a2d5(0x1e9)][_0x53a2d5(0xadb)](_0x35d7d0,_0x2e5942[_0x53a2d5(0x222)](_0x53a2d5(0x7a3)));if(VisuMZ[_0x53a2d5(0x1e9)]['JS'][_0xd6e8f9]){_0x2821a3=VisuMZ['BattleCore']['JS'][_0xd6e8f9]['call'](this,this[_0x53a2d5(0x2f2)](),_0x50f3fd,_0x35d7d0,_0x2821a3);if(_0xd5fb71)_0x2821a3=_0x2dfe10;}}for(const _0x1a3643 of _0x50f3fd[_0x53a2d5(0x5ec)]()){if('CCpqb'===_0x53a2d5(0x269))_0x1c984d-=_0x19e0ac[_0x53a2d5(0x5e5)]()/0x2;else{if(!_0x1a3643)continue;_0xd6e8f9=VisuMZ[_0x53a2d5(0x1e9)]['createKeyJS'](_0x1a3643,_0x2e5942[_0x53a2d5(0x222)](_0x53a2d5(0x46f)));if(VisuMZ['BattleCore']['JS'][_0xd6e8f9]){_0x2821a3=VisuMZ[_0x53a2d5(0x1e9)]['JS'][_0xd6e8f9][_0x53a2d5(0x740)](this,this['subject'](),_0x50f3fd,_0x1a3643,_0x2821a3);if(_0xd5fb71)_0x2821a3=_0x2dfe10;}}}return _0x2821a3;},Game_Action['prototype'][_0xfd5ed1(0x962)]=function(_0x291822){const _0x5a8d2a=_0xfd5ed1,_0x4bc2a4=this['_totalValue']||0x0,_0x477e5a=VisuMZ[_0x5a8d2a(0x1e9)][_0x5a8d2a(0x607)][_0x5a8d2a(0x6d8)],_0x2f5c73=_0x291822['format']('');_0x477e5a[_0x2f5c73]&&_0x477e5a[_0x2f5c73][_0x5a8d2a(0x740)](this,_0x4bc2a4);let _0x5bc2dd=VisuMZ[_0x5a8d2a(0x1e9)]['createKeyJS'](this[_0x5a8d2a(0x3c7)](),_0x291822);VisuMZ[_0x5a8d2a(0x1e9)]['JS'][_0x5bc2dd]&&VisuMZ[_0x5a8d2a(0x1e9)]['JS'][_0x5bc2dd][_0x5a8d2a(0x740)](this,this[_0x5a8d2a(0x2f2)](),this[_0x5a8d2a(0x2f2)](),this[_0x5a8d2a(0x3c7)](),_0x4bc2a4);for(const _0x5a2e84 of this[_0x5a8d2a(0x2f2)]()[_0x5a8d2a(0x5ec)]()){if(!_0x5a2e84)continue;_0x5bc2dd=VisuMZ[_0x5a8d2a(0x1e9)][_0x5a8d2a(0xadb)](_0x5a2e84,_0x291822),VisuMZ[_0x5a8d2a(0x1e9)]['JS'][_0x5bc2dd]&&('RjzGE'!=='RjzGE'?this[_0x5a8d2a(0x695)]()&&_0x1eecab[_0x5a8d2a(0x1e9)][_0x5a8d2a(0xb3d)]['call'](this,_0x2b36d5,_0x343b59,_0x1161d4):VisuMZ[_0x5a8d2a(0x1e9)]['JS'][_0x5bc2dd]['call'](this,this['subject'](),this[_0x5a8d2a(0x2f2)](),_0x5a2e84,_0x4bc2a4));}},Game_Action[_0xfd5ed1(0x263)][_0xfd5ed1(0xaa9)]=function(){const _0x1978b2=_0xfd5ed1;return VisuMZ['BattleCore'][_0x1978b2(0x607)][_0x1978b2(0x6d8)]['CalcActionSpeedJS'][_0x1978b2(0x740)](this);},Game_Action[_0xfd5ed1(0x263)][_0xfd5ed1(0x383)]=function(){const _0x40b9d1=_0xfd5ed1;return VisuMZ[_0x40b9d1(0x1e9)]['Settings']['Mechanics']['AllowRandomSpeed'];},Game_Action[_0xfd5ed1(0x263)][_0xfd5ed1(0x48a)]=function(){const _0x36c8d5=_0xfd5ed1;return this['item']()[_0x36c8d5(0x80f)][_0x36c8d5(0x9e4)](/<JS TARGETS>/i);},Game_Action[_0xfd5ed1(0x263)][_0xfd5ed1(0xa1d)]=function(){const _0x402df1=_0xfd5ed1;if(!this['_forcing']&&this[_0x402df1(0x2f2)]()[_0x402df1(0x7e4)]())return![];if(this[_0x402df1(0x48a)]())return!![];return typeof this[_0x402df1(0x3c7)]()[_0x402df1(0x33c)]===_0x402df1(0x7dd);},VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0xa7b)]=Game_Action['prototype']['isForOpponent'],Game_Action[_0xfd5ed1(0x263)][_0xfd5ed1(0x490)]=function(){const _0x1d6bbb=_0xfd5ed1;if(this[_0x1d6bbb(0xa1d)]()&&!this['isCustomBattleScope']()){if(_0x1d6bbb(0x837)===_0x1d6bbb(0x57c))this['_battleLayoutStyle']=_0x1d6bbb(0x702);else return this[_0x1d6bbb(0x65e)]();}else{if('qWOcs'!=='dFcUk')return VisuMZ['BattleCore'][_0x1d6bbb(0xa7b)]['call'](this);else _0x293953=_0x4f9a2a;}},Game_Action[_0xfd5ed1(0x263)]['isForOpponentBattleCore']=function(){const _0x1b3888=_0xfd5ed1,_0x72f66=this[_0x1b3888(0x3c7)]()['scope'];return _0x72f66[_0x1b3888(0x9e4)](/(?:ENEMY|ENEMIES|FOE|FOES)/i);},VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0x8cd)]=Game_Action[_0xfd5ed1(0x263)][_0xfd5ed1(0x93e)],Game_Action[_0xfd5ed1(0x263)][_0xfd5ed1(0x93e)]=function(){const _0x4443bb=_0xfd5ed1;return this[_0x4443bb(0xa1d)]()&&!this[_0x4443bb(0x48a)]()?this[_0x4443bb(0x72e)]():VisuMZ[_0x4443bb(0x1e9)][_0x4443bb(0x8cd)][_0x4443bb(0x740)](this);},Game_Action[_0xfd5ed1(0x263)][_0xfd5ed1(0x72e)]=function(){const _0x4cfbce=_0xfd5ed1,_0x5aab4e=this['item']()[_0x4cfbce(0x33c)];return _0x5aab4e['match'](/(?:ALLY|ALLIES|FRIEND|FRIENDS)/i);},VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0xa75)]=Game_Action[_0xfd5ed1(0x263)][_0xfd5ed1(0xaf3)],Game_Action['prototype'][_0xfd5ed1(0xaf3)]=function(){const _0x400e55=_0xfd5ed1;return this[_0x400e55(0xa1d)]()&&!this[_0x400e55(0x48a)]()?this[_0x400e55(0xb7d)]():VisuMZ[_0x400e55(0x1e9)][_0x400e55(0xa75)][_0x400e55(0x740)](this);},Game_Action['prototype'][_0xfd5ed1(0xb7d)]=function(){const _0x9e5020=_0xfd5ed1,_0x186b9e=this['item']()[_0x9e5020(0x33c)];return _0x186b9e[_0x9e5020(0x9e4)](/(?:RAND|RANDOM)/i);},VisuMZ['BattleCore']['Game_Action_needsSelection']=Game_Action[_0xfd5ed1(0x263)]['needsSelection'],Game_Action[_0xfd5ed1(0x263)][_0xfd5ed1(0xad4)]=function(){const _0x101246=_0xfd5ed1;if(this[_0x101246(0xa1d)]()&&!this[_0x101246(0x48a)]()){if('oHsUJ'!==_0x101246(0x47c))return this[_0x101246(0x201)]();else this[_0x101246(0x3aa)]();}else return VisuMZ[_0x101246(0x1e9)]['Game_Action_needsSelection'][_0x101246(0x740)](this);},Game_Action['prototype'][_0xfd5ed1(0x201)]=function(){const _0x10ebb9=_0xfd5ed1,_0x530caf=this['item']()[_0x10ebb9(0x33c)];if(_0x530caf[_0x10ebb9(0x9e4)](/RANDOM/i))return![];if(_0x530caf[_0x10ebb9(0x9e4)](/ALL (?:ALLY|ALLIES|FRIEND|FRIENDS)/i))return![];if(_0x530caf['match'](/ALL (?:ENEMY|ENEMIES|FOE|FOES)/i))return![];return VisuMZ[_0x10ebb9(0x1e9)]['Game_Action_needsSelection'][_0x10ebb9(0x740)](this);},VisuMZ[_0xfd5ed1(0x1e9)]['Game_Action_makeTargets']=Game_Action[_0xfd5ed1(0x263)][_0xfd5ed1(0x675)],Game_Action[_0xfd5ed1(0x263)][_0xfd5ed1(0x675)]=function(){const _0x5b46a0=_0xfd5ed1;let _0x228952=[];return this[_0x5b46a0(0xa1d)]()?_0x228952=this['makeTargetsBattleCore']():_0x228952=VisuMZ[_0x5b46a0(0x1e9)][_0x5b46a0(0x33b)][_0x5b46a0(0x740)](this),_0x228952=this[_0x5b46a0(0xa2d)](_0x228952),_0x228952;},Game_Action[_0xfd5ed1(0x263)][_0xfd5ed1(0x1d4)]=function(){const _0x54c304=_0xfd5ed1;let _0x4d1f84=[];const _0x31a1f3=String(this[_0x54c304(0x3c7)]()[_0x54c304(0x33c)]),_0xf95317=VisuMZ['BattleCore'][_0x54c304(0xadb)](this[_0x54c304(0x3c7)](),'Targets');if(VisuMZ[_0x54c304(0x1e9)]['JS'][_0xf95317]){_0x4d1f84=VisuMZ['BattleCore'][_0x54c304(0x33b)][_0x54c304(0x740)](this);const _0x3aa952=VisuMZ['BattleCore'][_0x54c304(0xadb)](this[_0x54c304(0x3c7)](),_0x54c304(0x7e3));return _0x4d1f84=VisuMZ[_0x54c304(0x1e9)]['JS'][_0x3aa952][_0x54c304(0x740)](this,this['subject'](),_0x4d1f84),this[_0x54c304(0x28b)](_0x4d1f84);}if(_0x31a1f3[_0x54c304(0x9e4)](/(\d+) RANDOM ANY/i)){let _0xce555e=Number(RegExp['$1']);while(_0xce555e--){if(_0x54c304(0xa6a)===_0x54c304(0xa6a)){const _0x3a9266=Math['randomInt'](0x2)===0x0?this[_0x54c304(0x4ea)]():this[_0x54c304(0x8aa)]();_0x4d1f84[_0x54c304(0xbc8)](_0x3a9266[_0x54c304(0x979)]());}else return this[_0x54c304(0x7e5)]>0x0;}return this[_0x54c304(0x28b)](_0x4d1f84);}if(_0x31a1f3[_0x54c304(0x9e4)](/(\d+) RANDOM (?:ENEMY|ENEMIES|FOE|FOES)/i)){if(_0x54c304(0x639)===_0x54c304(0x382)){this[_0x54c304(0x6a0)]=[];for(let _0x7f1fc3=0x0;_0x7f1fc3<_0x1d354b[_0x54c304(0x3b6)]();_0x7f1fc3++){const _0x2fbfc0=_0x1e6ee5[_0x54c304(0x6d2)]()[_0x7f1fc3],_0x5b4105=new _0x22637b();_0x5b4105[_0x54c304(0xa4a)](_0x2fbfc0),_0x5b4105['setBattler'](_0x2fbfc0),_0x5b4105['update'](),this['_actorSprites']['push'](_0x5b4105),this[_0x54c304(0x728)][_0x54c304(0x3d8)](_0x5b4105);}}else{let _0x4a38a7=Number(RegExp['$1']);while(_0x4a38a7--){_0x4d1f84[_0x54c304(0xbc8)](this[_0x54c304(0x4ea)]()[_0x54c304(0x979)]());}return this[_0x54c304(0x28b)](_0x4d1f84);}}if(_0x31a1f3[_0x54c304(0x9e4)](/(\d+) RANDOM (?:ALLY|ALLIES|FRIEND|FRIENDS)/i)){let _0x335a65=Number(RegExp['$1']);while(_0x335a65--){_0x54c304(0xaac)!==_0x54c304(0xaac)?_0x12f68d[_0x54c304(0x1e9)]['JS'][_0x27c869][_0x54c304(0x740)](this,this[_0x54c304(0x2f2)](),this[_0x54c304(0x2f2)](),this[_0x54c304(0x3c7)](),_0x35358b):_0x4d1f84[_0x54c304(0xbc8)](this[_0x54c304(0x8aa)]()['trueRandomTarget']());}return this[_0x54c304(0x28b)](_0x4d1f84);}if(_0x31a1f3['match'](/ALL (?:ALLY|ALLIES|FRIEND|FRIENDS) (?:BUT|EXCEPT) (?:USER|SELF)/i)){if(_0x54c304(0x6f1)!==_0x54c304(0x6f1))_0x2b0bc0[_0x54c304(0x1e9)][_0x54c304(0x1a0)][_0x54c304(0x740)](this,_0x4222f4),this[_0x54c304(0x6f4)]();else return _0x4d1f84[_0x54c304(0xbc8)](...this[_0x54c304(0x8aa)]()[_0x54c304(0x6cc)]()[_0x54c304(0x4af)](_0x317d2a=>_0x317d2a!==this[_0x54c304(0x2f2)]())),this[_0x54c304(0x28b)](_0x4d1f84);}return VisuMZ[_0x54c304(0x1e9)][_0x54c304(0x33b)][_0x54c304(0x740)](this);},Game_Action['prototype'][_0xfd5ed1(0x5c6)]=function(_0x5d0851){const _0x32af47=_0xfd5ed1,_0x2a09d=[];for(let _0x74b7f2=0x0;_0x74b7f2<this[_0x32af47(0x483)]();_0x74b7f2++){_0x32af47(0x2fe)!=='eJmjt'?_0x1da058[_0x32af47(0x7d0)](_0x4dc523):_0x2a09d[_0x32af47(0xbc8)](_0x5d0851['trueRandomTarget']());}return _0x2a09d;},Game_Action[_0xfd5ed1(0x263)][_0xfd5ed1(0xa2d)]=function(_0x452caf){const _0x52f3b9=_0xfd5ed1;if(!this[_0x52f3b9(0x3c7)]())return _0x452caf;const _0x2a949d=this[_0x52f3b9(0x3c7)]()[_0x52f3b9(0x80f)];return _0x2a949d['match'](/(?:BUT|EXCEPT) (?:USER|SELF)/i)&&_0x452caf['remove'](this[_0x52f3b9(0x2f2)]()),_0x452caf;},VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0x3bb)]=Game_Action[_0xfd5ed1(0x263)]['itemEffectAddAttackState'],Game_Action[_0xfd5ed1(0x263)][_0xfd5ed1(0x532)]=function(_0x42f950,_0xf8fd29){const _0x2f2957=_0xfd5ed1;VisuMZ[_0x2f2957(0x1e9)][_0x2f2957(0x3bb)][_0x2f2957(0x740)](this,_0x42f950,_0xf8fd29);if(!_0x42f950[_0x2f2957(0x8dc)]())return;for(const _0x221053 of this[_0x2f2957(0x2f2)]()['attackStates']()){if(_0x221053===_0x42f950[_0x2f2957(0x5f5)]()){if(_0x2f2957(0x9f0)!==_0x2f2957(0x9f0))this[_0x2f2957(0x933)]=![];else{let _0x107951=_0xf8fd29[_0x2f2957(0x3e1)];_0x107951*=_0x42f950[_0x2f2957(0x9b3)](_0x221053),_0x107951*=this['subject']()['attackStatesRate'](_0x221053),_0x107951*=this['lukEffectRate'](_0x42f950),Math[_0x2f2957(0x59b)]()<_0x107951&&(_0x42f950[_0x2f2957(0x2e2)]=!![],this[_0x2f2957(0x88d)](_0x42f950));}}}},VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0xac6)]=Game_Action[_0xfd5ed1(0x263)][_0xfd5ed1(0x85b)],Game_Action[_0xfd5ed1(0x263)]['itemEffectAddNormalState']=function(_0x4a63a6,_0x382ff7){const _0x1eb28c=_0xfd5ed1;VisuMZ['BattleCore']['Game_Action_itemEffectAddNormalState'][_0x1eb28c(0x740)](this,_0x4a63a6,_0x382ff7);if(!_0x4a63a6[_0x1eb28c(0x8dc)]())return;if(_0x382ff7[_0x1eb28c(0x24c)]!==_0x4a63a6[_0x1eb28c(0x5f5)]())return;let _0x3146a3=_0x382ff7[_0x1eb28c(0x3e1)];!this['isCertainHit']()&&(_0x3146a3*=_0x4a63a6[_0x1eb28c(0x9b3)](_0x382ff7[_0x1eb28c(0x24c)]),_0x3146a3*=this[_0x1eb28c(0x78c)](_0x4a63a6)),Math[_0x1eb28c(0x59b)]()<_0x3146a3&&(_0x1eb28c(0x58b)!==_0x1eb28c(0x58b)?_0x20bfdd['_subject'][_0x1eb28c(0xb65)](_0x27fcac):(_0x4a63a6[_0x1eb28c(0x2e2)]=!![],this[_0x1eb28c(0x88d)](_0x4a63a6)));},VisuMZ[_0xfd5ed1(0x1e9)]['Game_Action_applyGlobal']=Game_Action[_0xfd5ed1(0x263)]['applyGlobal'],Game_Action[_0xfd5ed1(0x263)][_0xfd5ed1(0x7fe)]=function(){const _0x549c7e=_0xfd5ed1;VisuMZ[_0x549c7e(0x1e9)]['Game_Action_applyGlobal'][_0x549c7e(0x740)](this),this[_0x549c7e(0x4ff)](),this[_0x549c7e(0x494)]();},Game_Action[_0xfd5ed1(0x263)]['applyGlobalCommonEventNotetags']=function(){const _0x5e729b=_0xfd5ed1;if(!SceneManager[_0x5e729b(0xbb7)]())return;const _0xbab359=/<COMMON (?:EVENT|EVENTS):[ ](.*)>/gi,_0x4da44c=this[_0x5e729b(0x3c7)]()[_0x5e729b(0x80f)][_0x5e729b(0x9e4)](_0xbab359);if(_0x4da44c)for(const _0x5714a6 of _0x4da44c){if(!_0x5714a6)continue;_0x5714a6['match'](_0xbab359);const _0x367f50=String(RegExp['$1'])[_0x5e729b(0x513)](',')[_0x5e729b(0x3ee)](_0x23ca92=>String(_0x23ca92)[_0x5e729b(0x300)]()),_0x4a42bd=_0x367f50['map'](_0x2f047d=>DataManager[_0x5e729b(0x4b3)](_0x2f047d));for(const _0x5b38ce of _0x4a42bd){if(_0x5e729b(0x4c1)!==_0x5e729b(0x4c1))this['_currentAngle']=this[_0x5e729b(0x417)],this[_0x5e729b(0x973)]&&(this[_0x5e729b(0x417)]=0x0,this['_currentAngle']=0x0);else{const _0x2e1ad6=$dataCommonEvents[_0x5b38ce];if(_0x2e1ad6){if(_0x5e729b(0x340)!=='yBLzF'){if(this[_0x5e729b(0x333)]()['note'][_0x5e729b(0x9e4)](/<BATTLER SPRITE GROUNDED>/i))return!![];return![];}else $gameTemp['reserveCommonEvent'](_0x5b38ce);}}}}},DataManager[_0xfd5ed1(0x4b3)]=function(_0x958a81){const _0x53a918=_0xfd5ed1;_0x958a81=_0x958a81['toUpperCase']()[_0x53a918(0x300)](),this[_0x53a918(0x682)]=this[_0x53a918(0x682)]||{};if(this[_0x53a918(0x682)][_0x958a81])return this[_0x53a918(0x682)][_0x958a81];for(const _0x5cb0d9 of $dataCommonEvents){if(_0x53a918(0x781)!==_0x53a918(0x781))return![];else{if(!_0x5cb0d9)continue;let _0x2ae0af=_0x5cb0d9[_0x53a918(0x452)];_0x2ae0af=_0x2ae0af['replace'](/\x1I\[(\d+)\]/gi,''),_0x2ae0af=_0x2ae0af[_0x53a918(0x797)](/\\I\[(\d+)\]/gi,''),this['_commonEventIDs'][_0x2ae0af[_0x53a918(0xa50)]()['trim']()]=_0x5cb0d9['id'];}}return this[_0x53a918(0x682)][_0x958a81]||0x0;},Game_Action[_0xfd5ed1(0x263)][_0xfd5ed1(0x494)]=function(){const _0x14ed2d=_0xfd5ed1;if(!SceneManager['isSceneBattle']())return;const _0x285568=VisuMZ[_0x14ed2d(0x1e9)][_0x14ed2d(0x607)][_0x14ed2d(0x6d8)];if(_0x285568['SwitchCritical']){if(_0x14ed2d(0x88e)===_0x14ed2d(0x1b3)){const _0x39ba70=this[_0x14ed2d(0x4a5)],_0x332dff=_0x4d0617[_0x14ed2d(0x52f)](),_0x524867=_0x3dc812['x']+_0x152bdd[_0x14ed2d(0x765)](_0x4b5f56[_0x14ed2d(0xb4a)]/0x2)+_0x332dff;_0x39ba70['x']=_0x39ba70[_0x14ed2d(0xb4a)]/-0x2+_0x524867,_0x39ba70['y']=_0x1a38b9[_0x14ed2d(0x765)](_0x2d55c1[_0x14ed2d(0x8c6)]/0x2);}else $gameSwitches[_0x14ed2d(0x8f8)](_0x285568[_0x14ed2d(0x436)],![]);}_0x285568[_0x14ed2d(0x6ac)]&&$gameSwitches[_0x14ed2d(0x8f8)](_0x285568['SwitchMissEvade'],![]),_0x285568[_0x14ed2d(0x335)]&&(_0x14ed2d(0x4e0)!==_0x14ed2d(0x4e0)?(_0x138a8d[_0x14ed2d(0x4a8)](),_0x53fe4a[_0x14ed2d(0x204)](_0x1009a0),_0x3eadc3[_0x14ed2d(0x1e9)]['Game_Troop_setup'][_0x14ed2d(0x740)](this,_0x2bd244)):$gameVariables['setValue'](_0x285568[_0x14ed2d(0x335)],0x0)),_0x285568[_0x14ed2d(0x405)]&&('emOpS'!=='emOpS'?_0x307bf0[_0x14ed2d(0x3c3)][_0x14ed2d(0x7be)]():$gameVariables[_0x14ed2d(0x8f8)](_0x285568['VariableHeal'],0x0));},Game_Action['prototype'][_0xfd5ed1(0x2ff)]=function(_0xb5d216){const _0x12b787=_0xfd5ed1;if(!SceneManager[_0x12b787(0xbb7)]())return;if(!_0xb5d216)return;const _0x5727d5=_0xb5d216[_0x12b787(0x809)](),_0x4bdfeb=VisuMZ[_0x12b787(0x1e9)][_0x12b787(0x607)][_0x12b787(0x6d8)];_0x4bdfeb[_0x12b787(0x436)]&&_0x5727d5['critical']&&$gameSwitches['setValue'](_0x4bdfeb['SwitchCritical'],!![]);_0x4bdfeb['SwitchMissEvade']&&(_0x5727d5[_0x12b787(0x86d)]||_0x5727d5[_0x12b787(0xb24)])&&$gameSwitches[_0x12b787(0x8f8)](_0x4bdfeb[_0x12b787(0x6ac)],!![]);if(_0x4bdfeb[_0x12b787(0x335)]){let _0x350973=$gameVariables[_0x12b787(0x59a)](_0x4bdfeb[_0x12b787(0x335)]);_0x5727d5[_0x12b787(0x63a)]>0x0&&(_0x12b787(0xa6b)===_0x12b787(0xa6b)?_0x350973+=Math[_0x12b787(0xa76)](_0x5727d5[_0x12b787(0x63a)]):_0x30dd1a[_0x12b787(0x2ce)]()),$gameVariables[_0x12b787(0x8f8)](_0x4bdfeb[_0x12b787(0x335)],_0x350973);}if(_0x4bdfeb[_0x12b787(0x405)]){let _0x59ef23=$gameVariables[_0x12b787(0x59a)](_0x4bdfeb[_0x12b787(0x405)]);_0x5727d5[_0x12b787(0x63a)]<0x0&&(_0x59ef23+=Math[_0x12b787(0xa76)](_0x5727d5['hpDamage'])),$gameVariables[_0x12b787(0x8f8)](_0x4bdfeb[_0x12b787(0x405)],_0x59ef23);}},VisuMZ['BattleCore'][_0xfd5ed1(0x6c6)]=Game_BattlerBase[_0xfd5ed1(0x263)][_0xfd5ed1(0x218)],Game_BattlerBase[_0xfd5ed1(0x263)][_0xfd5ed1(0x218)]=function(){const _0x3f6c6e=_0xfd5ed1;VisuMZ[_0x3f6c6e(0x1e9)]['Game_BattlerBase_initMembers']['call'](this),this[_0x3f6c6e(0x426)]();},Game_BattlerBase[_0xfd5ed1(0x263)][_0xfd5ed1(0x426)]=function(){const _0x3b82ff=_0xfd5ed1;this[_0x3b82ff(0x9af)]=![];},VisuMZ[_0xfd5ed1(0x1e9)]['Game_BattlerBase_refresh']=Game_BattlerBase['prototype']['refresh'],Game_BattlerBase[_0xfd5ed1(0x263)][_0xfd5ed1(0x486)]=function(){const _0x3322b9=_0xfd5ed1;this['_cache']={},VisuMZ[_0x3322b9(0x1e9)][_0x3322b9(0x5f9)][_0x3322b9(0x740)](this);},Game_BattlerBase[_0xfd5ed1(0x263)][_0xfd5ed1(0x5cb)]=function(_0xe51f6f){const _0x1c4b44=_0xfd5ed1;return this[_0x1c4b44(0x303)]=this['_cache']||{},this[_0x1c4b44(0x303)][_0xe51f6f]!==undefined;},Game_BattlerBase[_0xfd5ed1(0x263)][_0xfd5ed1(0x5f4)]=function(){const _0x28c7fc=_0xfd5ed1;if(this['_cache'][_0x28c7fc(0x5f4)]!==undefined)return this[_0x28c7fc(0x303)][_0x28c7fc(0x5f4)];const _0x246b5b=/<DAMAGE CAP:[ ](\d+)>/i,_0xd3a483=this['traitObjects']()[_0x28c7fc(0x3ee)](_0x448c0d=>_0x448c0d&&_0x448c0d['note'][_0x28c7fc(0x9e4)](_0x246b5b)?Number(RegExp['$1']):0x0);let _0x2cca29=_0xd3a483[_0x28c7fc(0x5b7)]>0x0?Math[_0x28c7fc(0x4d3)](..._0xd3a483):0x0;if(_0x2cca29<=0x0)_0x2cca29=VisuMZ[_0x28c7fc(0x1e9)][_0x28c7fc(0x607)]['Damage'][_0x28c7fc(0xb42)];return this[_0x28c7fc(0x303)]['hardDamageCap']=_0x2cca29,this[_0x28c7fc(0x303)][_0x28c7fc(0x5f4)];},Game_BattlerBase[_0xfd5ed1(0x263)][_0xfd5ed1(0x5a6)]=function(){const _0x54ca4e=_0xfd5ed1;if(this[_0x54ca4e(0x303)]['softDamageCap']!==undefined)return this[_0x54ca4e(0x303)]['softDamageCap'];let _0x15f502=VisuMZ[_0x54ca4e(0x1e9)][_0x54ca4e(0x607)][_0x54ca4e(0x608)][_0x54ca4e(0xbb1)];const _0x588b1b=/<SOFT DAMAGE CAP:[ ]([\+\-]\d+)([%％])>/i,_0xe5b19=this[_0x54ca4e(0x5ec)]()[_0x54ca4e(0x3ee)](_0x414db0=>_0x414db0&&_0x414db0[_0x54ca4e(0x80f)][_0x54ca4e(0x9e4)](_0x588b1b)?Number(RegExp['$1'])/0x64:0x0);return _0x15f502=_0xe5b19[_0x54ca4e(0x42c)]((_0x115811,_0x4b85e2)=>_0x115811+_0x4b85e2,_0x15f502),this[_0x54ca4e(0x303)]['softDamageCap']=_0x15f502,this[_0x54ca4e(0x303)][_0x54ca4e(0x5be)][_0x54ca4e(0x8e6)](0.01,0x1);},VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0x1b4)]=Game_BattlerBase['prototype'][_0xfd5ed1(0x421)],Game_BattlerBase[_0xfd5ed1(0x263)][_0xfd5ed1(0x421)]=function(){const _0x4255ac=_0xfd5ed1;VisuMZ[_0x4255ac(0x1e9)][_0x4255ac(0x1b4)]['call'](this),SceneManager[_0x4255ac(0xbb7)]()&&this[_0x4255ac(0x465)](_0x4255ac(0x626));},Game_BattlerBase[_0xfd5ed1(0x263)]['battler']=function(){const _0x5a17dd=_0xfd5ed1;if(!SceneManager['isSceneBattle']())return null;if(!SceneManager[_0x5a17dd(0x3c3)][_0x5a17dd(0xb41)])return null;return SceneManager['_scene'][_0x5a17dd(0xb41)][_0x5a17dd(0x54b)](this);},Game_BattlerBase[_0xfd5ed1(0x263)][_0xfd5ed1(0xba3)]=function(){const _0x48254d=_0xfd5ed1;return VisuMZ[_0x48254d(0x1e9)][_0x48254d(0x607)][_0x48254d(0xbdf)][_0x48254d(0x866)];},Game_BattlerBase[_0xfd5ed1(0x263)][_0xfd5ed1(0x77c)]=function(){const _0x2d8c09=_0xfd5ed1;return VisuMZ[_0x2d8c09(0x1e9)][_0x2d8c09(0x607)][_0x2d8c09(0xbdf)][_0x2d8c09(0x8e4)];},Game_BattlerBase[_0xfd5ed1(0x263)][_0xfd5ed1(0xb20)]=function(){const _0x465c58=_0xfd5ed1;if(this[_0x465c58(0x75b)]&&this['isActor']()){if(_0x465c58(0xa17)!==_0x465c58(0x598))return VisuMZ[_0x465c58(0x1e9)][_0x465c58(0x607)][_0x465c58(0xbdf)][_0x465c58(0x9c2)];else _0xdd8b9[_0x465c58(0x904)]([_0x5f5288]);}else{if(_0x465c58(0x65d)!=='aZAff')return VisuMZ[_0x465c58(0x1e9)]['Settings'][_0x465c58(0x1f5)]['Shadow'];else _0x2b5b55[_0x465c58(0x1e9)][_0x465c58(0x26e)][_0x465c58(0x740)](this),this[_0x465c58(0xa77)]();}},Game_BattlerBase[_0xfd5ed1(0x263)][_0xfd5ed1(0xb46)]=function(){return!![];},Game_BattlerBase[_0xfd5ed1(0x263)]['battleUIOffsetX']=function(){return 0x0;},Game_BattlerBase[_0xfd5ed1(0x263)][_0xfd5ed1(0x342)]=function(){return 0x0;},Game_BattlerBase['prototype'][_0xfd5ed1(0x3e7)]=function(_0x10e341){const _0x41af69=_0xfd5ed1;if(!_0x10e341)return 0x0;let _0x5dee2a=0x0;const _0x43f90c=_0x10e341[_0x41af69(0x80f)];return _0x43f90c[_0x41af69(0x9e4)](/<BATTLE UI OFFSET X:[ ]([\+\-]\d+)>/i)&&(_0x5dee2a+=Number(RegExp['$1'])),_0x43f90c[_0x41af69(0x9e4)](/<BATTLE UI OFFSET:[ ]([\+\-]\d+),[ ]([\+\-]\d+)>/i)&&(_0x5dee2a+=Number(RegExp['$1'])),_0x5dee2a;},Game_BattlerBase[_0xfd5ed1(0x263)][_0xfd5ed1(0xaba)]=function(_0xe73cc5){const _0x80a4b9=_0xfd5ed1;if(!_0xe73cc5)return 0x0;let _0x2cb5bf=0x0;const _0x47302f=_0xe73cc5[_0x80a4b9(0x80f)];if(_0x47302f[_0x80a4b9(0x9e4)](/<BATTLE UI OFFSET Y:[ ]([\+\-]\d+)>/i)){if(_0x80a4b9(0xa42)!=='BxVaq')return this[_0x80a4b9(0x2da)];else _0x2cb5bf+=Number(RegExp['$1']);}if(_0x47302f['match'](/<BATTLE UI OFFSET:[ ]([\+\-]\d+),[ ]([\+\-]\d+)>/i)){if('EyQwb'===_0x80a4b9(0xa0d))_0x2cb5bf+=Number(RegExp['$2']);else{const _0x12cb35=_0x323324[_0x80a4b9(0xb4a)],_0x2e26b2=_0x4c90ad['round']((_0x2cea03[_0x80a4b9(0x9c4)]-_0x12cb35)/0x2),_0x2d31e7=this[_0x80a4b9(0x8f0)](),_0x1d8b1a=(_0x41dcaa['height']-_0x3036ca['boxHeight'])/-0x2;return new _0x514597(_0x2e26b2,_0x1d8b1a,_0x12cb35,_0x2d31e7);}}return _0x2cb5bf;},VisuMZ['BattleCore'][_0xfd5ed1(0x8ac)]=Game_BattlerBase[_0xfd5ed1(0x263)][_0xfd5ed1(0x71d)],Game_BattlerBase['prototype'][_0xfd5ed1(0x71d)]=function(_0xb92a59){const _0xba1ae3=_0xfd5ed1;if(_0xb92a59===this[_0xba1ae3(0x5f5)]()&&this[_0xba1ae3(0x8dc)]()){if(_0xba1ae3(0x184)===_0xba1ae3(0x503)){if(_0x4b55a2['VisuMZ_2_BattleSystemCTB']&&_0xf5de9a[_0xba1ae3(0x42b)]())return![];else{if(!_0xafcdd0[_0xba1ae3(0x1e9)][_0xba1ae3(0x7c0)])return![];const _0x234f77=_0x24ddcf['aliveMembers']()['filter'](_0x144b6e=>_0x144b6e[_0xba1ae3(0x329)]()&&_0x144b6e[_0xba1ae3(0x3e0)]());return _0x234f77[_0xba1ae3(0x5b7)]>0x0&&_0x5b2c1d['actor']()!==_0x234f77[_0x234f77[_0xba1ae3(0x5b7)]-0x1];}}else return!![];}return VisuMZ[_0xba1ae3(0x1e9)][_0xba1ae3(0x8ac)][_0xba1ae3(0x740)](this,_0xb92a59);},Game_BattlerBase[_0xfd5ed1(0x263)]['isImmortal']=function(){const _0x34dbd0=_0xfd5ed1;return this[_0x34dbd0(0x9af)];},Game_BattlerBase[_0xfd5ed1(0x263)][_0xfd5ed1(0x393)]=function(_0x298a6a){const _0x4d4944=_0xfd5ed1;_0x298a6a?'cgCzm'!==_0x4d4944(0x6a5)?this[_0x4d4944(0x8ba)]():_0x30d753=_0x3bc203>=_0x4647d4?_0x5b1940:_0xf489b2:this['removeImmortal']();},Game_BattlerBase[_0xfd5ed1(0x263)][_0xfd5ed1(0x8ba)]=function(){const _0x3ee2a6=_0xfd5ed1;if(this[_0x3ee2a6(0x7b0)]())return;this[_0x3ee2a6(0x9af)]=!![],this[_0x3ee2a6(0x2e2)]=![];},Game_BattlerBase['prototype']['removeImmortal']=function(){const _0x80c939=_0xfd5ed1,_0x2d1d20=this[_0x80c939(0x56e)]();this[_0x80c939(0x9af)]=![];if(_0x2d1d20&&this[_0x80c939(0x2e2)]){if(_0x80c939(0x19e)===_0x80c939(0x7f9)){const _0x1c0bdc=this[_0x80c939(0xb9a)]['currentAction'](),_0xb3100d=this[_0x80c939(0xb9a)];_0x1c0bdc&&_0x1c0bdc[_0x80c939(0x2f2)]()===_0xb3100d&&_0x1c0bdc['actionBattleCoreJS'](_0x80c939(0x64f)),_0x3c5d17[_0x80c939(0x1e9)]['BattleManager_startAction'][_0x80c939(0x740)](this),_0x1c0bdc&&_0x1c0bdc[_0x80c939(0x2f2)]()===_0xb3100d&&_0x1c0bdc['actionBattleCoreJS'](_0x80c939(0x88c));}else this[_0x80c939(0x421)]();}this[_0x80c939(0x2e2)]=![],this[_0x80c939(0x486)](),this[_0x80c939(0x7b0)]()&&_0x2d1d20&&(this['performCollapse'](),this[_0x80c939(0x75c)]());},VisuMZ['BattleCore'][_0xfd5ed1(0x671)]=Game_BattlerBase[_0xfd5ed1(0x263)]['canAttack'],Game_BattlerBase[_0xfd5ed1(0x263)][_0xfd5ed1(0x7bd)]=function(){const _0x32eb74=_0xfd5ed1;if(!this[_0x32eb74(0x66a)]())return![];return VisuMZ[_0x32eb74(0x1e9)]['Game_BattlerBase_canAttack']['call'](this);},Game_BattlerBase['prototype']['canAttackBattleCore']=function(){const _0x4a6d07=_0xfd5ed1;for(const _0x805f4a of this[_0x4a6d07(0x5ec)]()){if(_0x4a6d07(0x479)!==_0x4a6d07(0x2e1)){if(!_0x805f4a)continue;if(_0x805f4a[_0x4a6d07(0x80f)][_0x4a6d07(0x9e4)](/<(?:ATTACK SEAL|SEAL ATTACK)>/i))return![];}else return this['iterateBattler'](_0x6791d0[0x0],_0x3bb94e[0x1],_0x27bd00=>{const _0x188814=_0x4a6d07;!_0x27bd00[_0x188814(0x665)]()&&(_0x27bd00[_0x188814(0x7ed)](_0x1fc2ec[0x2],_0x4a3d1a[0x3]),_0x48c699[_0x188814(0x7ed)](_0x27bd00));}),!![];}return!![];},VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0x6d7)]=Game_BattlerBase[_0xfd5ed1(0x263)][_0xfd5ed1(0x992)],Game_BattlerBase[_0xfd5ed1(0x263)][_0xfd5ed1(0x992)]=function(){const _0x135508=_0xfd5ed1;if(!this['canGuardBattleCore']())return![];return VisuMZ[_0x135508(0x1e9)]['Game_BattlerBase_canGuard']['call'](this);},Game_BattlerBase[_0xfd5ed1(0x263)]['canGuardBattleCore']=function(){const _0x410cbb=_0xfd5ed1;for(const _0x72dd3f of this[_0x410cbb(0x5ec)]()){if(!_0x72dd3f)continue;if(_0x72dd3f['note'][_0x410cbb(0x9e4)](/<(?:GUARD SEAL|SEAL GUARD)>/i))return![];}return!![];},Game_BattlerBase['prototype'][_0xfd5ed1(0xb91)]=function(){const _0x6fa1f4=_0xfd5ed1;for(const _0x5c9888 of this['traitObjects']()){if(!_0x5c9888)continue;if(_0x5c9888[_0x6fa1f4(0x80f)][_0x6fa1f4(0x9e4)](/<(?:ITEM SEAL|SEAL ITEM|SEAL ITEMS)>/i))return![];}return!![];},Game_Battler[_0xfd5ed1(0x263)][_0xfd5ed1(0x383)]=function(){const _0x448d22=_0xfd5ed1;return VisuMZ[_0x448d22(0x1e9)]['Settings'][_0x448d22(0x6d8)][_0x448d22(0x93f)];},VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0x6c1)]=Game_Battler[_0xfd5ed1(0x263)][_0xfd5ed1(0x2cc)],Game_Battler['prototype'][_0xfd5ed1(0x2cc)]=function(){const _0x1324e7=_0xfd5ed1;if(SceneManager[_0x1324e7(0xbb7)]()&&$gameTroop['turnCount']()<=0x0)return;if(SceneManager[_0x1324e7(0xbb7)]()&&BattleManager[_0x1324e7(0x47b)]()&&this['_lastRegenFrameCount']===Graphics[_0x1324e7(0x790)])return;this['_lastRegenFrameCount']=Graphics[_0x1324e7(0x790)],this[_0x1324e7(0x2db)]('PreRegenerateJS'),VisuMZ[_0x1324e7(0x1e9)][_0x1324e7(0x6c1)][_0x1324e7(0x740)](this),this[_0x1324e7(0xb64)](),this[_0x1324e7(0x2db)](_0x1324e7(0x9dc));},Game_Battler[_0xfd5ed1(0x263)][_0xfd5ed1(0xb64)]=function(){const _0x40284c=_0xfd5ed1;if(SceneManager[_0x40284c(0xbb7)]()){if(_0x40284c(0x54c)===_0x40284c(0x991)){let _0x3ca717=_0x22e92a[_0x40284c(0x59a)](_0x352568['VariableHeal']);_0x392b4a['hpDamage']<0x0&&(_0x3ca717+=_0x1c57af[_0x40284c(0xa76)](_0x51ac33[_0x40284c(0x63a)])),_0x158baa['setValue'](_0x46f8b4[_0x40284c(0x405)],_0x3ca717);}else for(const _0x2c084e of this[_0x40284c(0x5ec)]()){if(!_0x2c084e)continue;this['onRegeneratePlayStateAnimation'](_0x2c084e);}}},Game_Battler[_0xfd5ed1(0x263)][_0xfd5ed1(0xbd3)]=function(_0x1265ba){const _0x432f8a=_0xfd5ed1;if(!Imported[_0x432f8a(0x768)])return;if(!SceneManager['isSceneBattle']())return;if(this['isDead']())return;if(this[_0x432f8a(0x33d)]())return;if(_0x1265ba['note']['match'](/<(?:REGENERATE|REGEN|DEGEN|DOT|SLIP)[ ]ANIMATION:[ ](\d+)>/i)){if(_0x432f8a(0x7ab)===_0x432f8a(0x882)){if(!_0x545d14['BattleCore'][_0x432f8a(0x607)][_0x432f8a(0x2d2)][_0x432f8a(0x807)])return;const _0x3dc42a=_0x129403[_0x432f8a(0x853)],_0x5f476d=_0x432f8a(0x853);this[_0x432f8a(0x93b)](_0x3dc42a,_0x5f476d);}else{const _0x120b71=Number(RegExp['$1']);$gameTemp['requestFauxAnimation']([this],_0x120b71,![],![]);}}},VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0x65a)]=Game_Battler['prototype'][_0xfd5ed1(0x575)],Game_Battler['prototype'][_0xfd5ed1(0x575)]=function(){const _0x41ab41=_0xfd5ed1;this['processBattleCoreJS']('PreStartTurnJS'),VisuMZ[_0x41ab41(0x1e9)]['Game_Battler_startTpbTurn']['call'](this),this[_0x41ab41(0x2db)](_0x41ab41(0x542));},VisuMZ['BattleCore'][_0xfd5ed1(0x609)]=Game_Battler[_0xfd5ed1(0x263)]['onTurnEnd'],Game_Battler[_0xfd5ed1(0x263)][_0xfd5ed1(0x55f)]=function(){const _0x1d9b0c=_0xfd5ed1;this[_0x1d9b0c(0x2db)](_0x1d9b0c(0xb84)),VisuMZ['BattleCore'][_0x1d9b0c(0x609)]['call'](this),this[_0x1d9b0c(0x2db)](_0x1d9b0c(0x98c));},Game_Battler['prototype'][_0xfd5ed1(0x2db)]=function(_0x4c168f){const _0x1ed837=_0xfd5ed1;if(this[_0x1ed837(0x407)]||this[_0x1ed837(0x613)])return;const _0x1ecb7e=VisuMZ[_0x1ed837(0x1e9)]['Settings'][_0x1ed837(0x6d8)];if(_0x1ecb7e[_0x4c168f])_0x1ecb7e[_0x4c168f][_0x1ed837(0x740)](this);for(const _0x4ecc34 of this['traitObjects']()){if(!_0x4ecc34)continue;key=VisuMZ['BattleCore'][_0x1ed837(0xadb)](_0x4ecc34,_0x4c168f);if(VisuMZ[_0x1ed837(0x1e9)]['JS'][key]){if(_0x1ed837(0x470)===_0x1ed837(0x3db)){if(!this[_0x1ed837(0xbed)])return;this[_0x1ed837(0x574)]=this[_0x1ed837(0xbed)][_0x1ed837(0x8c7)](),this['_shadowScaleY']=this[_0x1ed837(0xbed)]['battlerShadowScaleY']();}else VisuMZ[_0x1ed837(0x1e9)]['JS'][key]['call'](this,this,this,_0x4ecc34,0x0);}}},Game_Battler[_0xfd5ed1(0x263)][_0xfd5ed1(0xac1)]=function(){const _0x5b2bda=_0xfd5ed1;return VisuMZ['BattleCore']['Settings'][_0x5b2bda(0xbdf)][_0x5b2bda(0x918)]||![];},Game_Battler[_0xfd5ed1(0x263)][_0xfd5ed1(0x9cc)]=function(){const _0x32b77e=_0xfd5ed1;if(this[_0x32b77e(0x35d)]()){if(this[_0x32b77e(0xac1)]()){if(_0x32b77e(0x618)===_0x32b77e(0x4b8))_0x5c1e13--;else{if(this[_0x32b77e(0x385)]['some'](_0x4901ee=>_0x4901ee[_0x32b77e(0x3c7)]()&&_0x4901ee[_0x32b77e(0xb32)]())){if(_0x32b77e(0x291)!==_0x32b77e(0x291))_0x58d219=_0x1789ca['CastPhysical'];else return!![];}}}else{if(this['_actions'][_0x32b77e(0x9d6)](_0x5614c4=>_0x5614c4[_0x32b77e(0x3c7)]()&&_0x5614c4['isMagicSkill']())){if('rTiJl'!==_0x32b77e(0x295))return!![];else _0x42a99a[_0x32b77e(0x1e9)][_0x32b77e(0x3f1)]['call'](this);}}}if(BattleManager['isTpb']()&&this[_0x32b77e(0x8c8)]===_0x32b77e(0xbcf)){if(this['chantStyle']()){if(_0x32b77e(0xbcd)===_0x32b77e(0xbcd))return this['currentAction']()&&this[_0x32b77e(0xab8)]()['item']()&&this[_0x32b77e(0xab8)]()['isMagical']();else{const _0x1ca987=this[_0x32b77e(0x813)]();this[_0x32b77e(0x2e9)](_0x1ca987);}}else{if(_0x32b77e(0xab6)===_0x32b77e(0x5fd))_0x3ca38d+=_0x122d5[_0x32b77e(0x4c3)];else return this[_0x32b77e(0xab8)]()&&this[_0x32b77e(0xab8)]()[_0x32b77e(0x3c7)]()&&this[_0x32b77e(0xab8)]()['isMagicSkill']();}}return![];},Game_Battler['prototype']['isCharging']=function(){const _0xdee5ab=_0xfd5ed1;if(BattleManager['isTpb']()&&this[_0xdee5ab(0x8c8)]===_0xdee5ab(0xbcf))return this[_0xdee5ab(0xac1)]()?this[_0xdee5ab(0xab8)]()&&this[_0xdee5ab(0xab8)]()[_0xdee5ab(0x3c7)]()&&!this['currentAction']()[_0xdee5ab(0xb32)]():this[_0xdee5ab(0xab8)]()&&this[_0xdee5ab(0xab8)]()[_0xdee5ab(0x3c7)]()&&!this[_0xdee5ab(0xab8)]()[_0xdee5ab(0x446)]();return![];},VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0x972)]=Game_Battler[_0xfd5ed1(0x263)][_0xfd5ed1(0x453)],Game_Battler[_0xfd5ed1(0x263)][_0xfd5ed1(0x453)]=function(){const _0x38cd05=_0xfd5ed1;VisuMZ[_0x38cd05(0x1e9)][_0x38cd05(0x972)][_0x38cd05(0x740)](this),this['_damagePopupArray']=[];},Game_Battler[_0xfd5ed1(0x263)]['isDamagePopupRequested']=function(){const _0x4f0821=_0xfd5ed1;if(!this[_0x4f0821(0x24b)])this[_0x4f0821(0x453)]();return this[_0x4f0821(0x24b)]['length']>0x0;},Game_Battler['prototype'][_0xfd5ed1(0x397)]=function(){const _0x4dbed2=_0xfd5ed1;if(!SceneManager['isSceneBattle']())return;if(!this[_0x4dbed2(0x24b)])this[_0x4dbed2(0x453)]();this[_0x4dbed2(0xad2)]();const _0x310c85=this[_0x4dbed2(0x456)]();if(_0x310c85)_0x310c85[_0x4dbed2(0x684)]();},Game_Battler['prototype'][_0xfd5ed1(0xad2)]=function(){const _0x1a0a13=_0xfd5ed1,_0x2e1b11=this[_0x1a0a13(0x809)]();if(_0x2e1b11[_0x1a0a13(0x86d)]||_0x2e1b11[_0x1a0a13(0xb24)]){const _0x1b79e4=JsonEx[_0x1a0a13(0x3dd)](_0x2e1b11);_0x1b79e4['hpAffected']=![],_0x1b79e4['mpDamage']=0x0,this[_0x1a0a13(0x24b)][_0x1a0a13(0xbc8)](_0x1b79e4);}if(_0x2e1b11['hpAffected']){if(_0x1a0a13(0x743)===_0x1a0a13(0x743)){const _0x172098=JsonEx[_0x1a0a13(0x3dd)](_0x2e1b11);_0x172098[_0x1a0a13(0x86d)]=![],_0x172098[_0x1a0a13(0xb24)]=![],_0x172098[_0x1a0a13(0x62d)]=0x0,this[_0x1a0a13(0x24b)][_0x1a0a13(0xbc8)](_0x172098);}else return _0x373a8b['opponentsUnit']()['deadMembers']();}if(_0x2e1b11[_0x1a0a13(0x62d)]!==0x0){if(_0x1a0a13(0x314)!==_0x1a0a13(0x314))this['opacity']=this[_0x1a0a13(0x34d)];else{const _0x19467f=JsonEx[_0x1a0a13(0x3dd)](_0x2e1b11);_0x19467f[_0x1a0a13(0x86d)]=![],_0x19467f[_0x1a0a13(0xb24)]=![],_0x19467f[_0x1a0a13(0x929)]=![],this['_damagePopupArray'][_0x1a0a13(0xbc8)](_0x19467f);}}},Game_Battler[_0xfd5ed1(0x263)]['getNextDamagePopup']=function(){const _0x467caa=_0xfd5ed1;if(!this[_0x467caa(0x24b)])this[_0x467caa(0x453)]();if(VisuMZ[_0x467caa(0x1e9)]['Settings'][_0x467caa(0x608)][_0x467caa(0x66d)]){if(_0x467caa(0x8d7)==='Pnynt')this[_0x467caa(0x943)](),this[_0x467caa(0x6f5)]=![],_0x458492[_0x467caa(0x7d5)]();else return this[_0x467caa(0x24b)]['shift']();}else{if('jqOqe'!=='jqOqe')_0x13dd80[_0x467caa(0x1e9)]['Settings']['Enemy'][_0x467caa(0x364)]&&(this[_0x467caa(0x5f3)]=new _0xe07c50(),this[_0x467caa(0x3d8)](this[_0x467caa(0x5f3)]));else return this[_0x467caa(0x24b)][_0x467caa(0x46a)]();}},Game_Battler[_0xfd5ed1(0x263)][_0xfd5ed1(0xa32)]=function(_0x45f0e8,_0x7a4408){const _0x26a3f1=_0xfd5ed1;if(!SceneManager[_0x26a3f1(0xbb7)]())return;if(!this['battler']())return;if(_0x45f0e8[_0x26a3f1(0x5b7)]<=0x0)return;_0x7a4408=_0x7a4408||{},_0x7a4408[_0x26a3f1(0x8fd)]=_0x7a4408[_0x26a3f1(0x8fd)]||_0x26a3f1(0xbb8),_0x7a4408[_0x26a3f1(0xb1b)]=_0x7a4408[_0x26a3f1(0xb1b)]||[0x0,0x0,0x0,0x0],_0x7a4408['flashDuration']=_0x7a4408[_0x26a3f1(0x921)]||0x0,this[_0x26a3f1(0x456)]()[_0x26a3f1(0xa32)](_0x45f0e8,_0x7a4408);},Game_Battler[_0xfd5ed1(0x263)][_0xfd5ed1(0xbb9)]=function(_0x53d3e2,_0xd0ceae,_0x54170d){const _0x5070be=_0xfd5ed1;if(!SceneManager[_0x5070be(0xbb7)]())return;if(!this[_0x5070be(0x456)]())return;if(_0xd0ceae['length']<=0x0)return;_0x54170d=_0x54170d||{},_0x54170d['textColor']=_0x54170d['textColor']||_0x5070be(0xbb8),_0x54170d[_0x5070be(0xb1b)]=_0x54170d[_0x5070be(0xb1b)]||[0x0,0x0,0x0,0x0],_0x54170d[_0x5070be(0x921)]=_0x54170d['flashDuration']||0x0,this[_0x5070be(0x456)]()['setupIconTextPopup'](_0x53d3e2,_0xd0ceae,_0x54170d);},Game_Battler[_0xfd5ed1(0x263)][_0xfd5ed1(0x475)]=function(){const _0x5e129f=_0xfd5ed1;if(this[_0x5e129f(0x33d)]())return![];if(this[_0x5e129f(0x56e)]()&&this[_0x5e129f(0x242)]())return!![];if(this['isEnemy']()&&this[_0x5e129f(0x9bc)]()){if(this[_0x5e129f(0x7b0)]()&&this[_0x5e129f(0xbcb)]())return![];}else{if(this[_0x5e129f(0x7b0)]())return![];}return!![];},VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0x63f)]=Game_Battler['prototype'][_0xfd5ed1(0x454)],Game_Battler[_0xfd5ed1(0x263)][_0xfd5ed1(0x454)]=function(){const _0x334073=_0xfd5ed1;VisuMZ[_0x334073(0x1e9)]['Game_Battler_clearMotion']['call'](this),this['clearFreezeMotion']();},Game_Battler[_0xfd5ed1(0x263)]['canBattlerMove']=function(){return!![];},Game_Battler[_0xfd5ed1(0x263)][_0xfd5ed1(0x711)]=function(){return![];},VisuMZ['BattleCore'][_0xfd5ed1(0xa88)]=Game_Battler[_0xfd5ed1(0x263)][_0xfd5ed1(0x855)],Game_Battler['prototype']['onBattleStart']=function(_0x598339){const _0x54bd83=_0xfd5ed1;VisuMZ[_0x54bd83(0x1e9)][_0x54bd83(0xa88)][_0x54bd83(0x740)](this,_0x598339),this[_0x54bd83(0x70f)](_0x598339);},Game_Battler[_0xfd5ed1(0x263)][_0xfd5ed1(0x70f)]=function(_0x4dcf9a){this['setBattlerFlip'](![]);},VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0x7ce)]=Game_Battler[_0xfd5ed1(0x263)][_0xfd5ed1(0x537)],Game_Battler['prototype']['performActionStart']=function(_0x1d171f){const _0x52ce77=_0xfd5ed1;VisuMZ['BattleCore']['Game_Battler_performActionStart'][_0x52ce77(0x740)](this,_0x1d171f);if(!_0x1d171f['isGuard']()){const _0x50bc37=this[_0x52ce77(0x456)]();_0x50bc37&&('wrXxv'!==_0x52ce77(0x99e)?_0x50bc37[_0x52ce77(0x8a4)]():(this[_0x52ce77(0x2a7)]=new _0x1a9438(),this[_0x52ce77(0x2a7)][_0x52ce77(0x925)]=[new _0x30ae06['filters'][(_0x52ce77(0xb3f))]()],this[_0x52ce77(0x2a7)][_0x52ce77(0x24e)]=new _0x39408f(),this[_0x52ce77(0x2a7)]['move'](this['_padding'],this['_padding']),this[_0x52ce77(0x3d8)](this[_0x52ce77(0x2a7)])));}this[_0x52ce77(0x41e)](![]);},Game_Battler[_0xfd5ed1(0x263)][_0xfd5ed1(0xa35)]=function(){const _0x95233=_0xfd5ed1,_0x211b14=this[_0x95233(0x3f6)];this[_0x95233(0x3f6)]=![];if(BattleManager[_0x95233(0x415)]()&&this[_0x95233(0x5f2)]()){const _0x2ec9a6=this[_0x95233(0x456)]();if(_0x2ec9a6&&_0x211b14)_0x2ec9a6['stepForward']();return;}const _0x3f4f6f=this[_0x95233(0x456)]();if(_0x3f4f6f)_0x3f4f6f[_0x95233(0x3cc)]();this['setBattlerFlip'](![]),this['requestMotionRefresh']();},Game_Battler[_0xfd5ed1(0x263)][_0xfd5ed1(0x287)]=function(_0x163d8e){const _0x270b2e=_0xfd5ed1;if(_0x163d8e[_0x270b2e(0x517)]())this['performAttack']();else{if(_0x163d8e['isGuard']())this[_0x270b2e(0x465)](_0x270b2e(0xa24));else{if(_0x163d8e[_0x270b2e(0xb32)]())this[_0x270b2e(0x465)](_0x270b2e(0x6b9));else{if(_0x163d8e[_0x270b2e(0x83f)]())_0x163d8e[_0x270b2e(0x3c7)]()['damage']['type']>0x0?this[_0x270b2e(0x45b)]():this[_0x270b2e(0x465)](_0x270b2e(0x746));else _0x163d8e[_0x270b2e(0x20b)]()&&('IXDqM'!==_0x270b2e(0x2de)?this[_0x270b2e(0x934)]():this[_0x270b2e(0x465)]('item'));}}}},Game_Battler[_0xfd5ed1(0x263)][_0xfd5ed1(0x9ba)]=function(){const _0xe4cce8=_0xfd5ed1;return $dataSystem[_0xe4cce8(0x576)][0x0];},Game_Battler['prototype']['getAttackWeaponAnimationId']=function(){const _0x5a263b=_0xfd5ed1,_0x4cfce3=this[_0x5a263b(0x9ba)]();return _0x4cfce3?_0x4cfce3[_0x5a263b(0x875)]:0x0;},Game_Battler[_0xfd5ed1(0x263)]['performSubstitute']=function(_0x5726f1){const _0x41e4c7=_0xfd5ed1;if(!$gameSystem[_0x41e4c7(0xb27)]())return;const _0x552ae3=this[_0x41e4c7(0x456)](),_0x4ab386=_0x5726f1['battler']();if(!_0x552ae3||!_0x4ab386)return;const _0x52d7c1=_0x4ab386[_0x41e4c7(0x6f7)],_0xe72164=_0x4ab386[_0x41e4c7(0x579)];this[_0x41e4c7(0x6c5)](_0x52d7c1,_0xe72164,0x0,![],'Linear',-0x1),_0x552ae3['updatePosition']();const _0x1a8e8b=VisuMZ[_0x41e4c7(0x1e9)][_0x41e4c7(0x607)][_0x41e4c7(0x472)];let _0x2937e8=(_0x4ab386[_0x41e4c7(0xb4a)]+_0x552ae3[_0x41e4c7(0xb4a)])/0x2;_0x2937e8*=this[_0x41e4c7(0x75b)]()?0x1:-0x1;let _0x3f2086=_0x1a8e8b['StepDistanceY']*(this[_0x41e4c7(0x75b)]()?0x1:-0x1);_0x5726f1[_0x41e4c7(0x75e)](_0x2937e8,_0x3f2086,0x0,![],_0x41e4c7(0x558)),_0x4ab386[_0x41e4c7(0x95f)]();},Game_Battler[_0xfd5ed1(0x263)]['requestMotion']=function(_0x4630bf){const _0x5ef286=_0xfd5ed1;if(SceneManager['isSceneBattle']()){const _0x474315=this[_0x5ef286(0x456)]();_0x474315&&(_0x474315[_0x5ef286(0x3f3)](_0x4630bf),[_0x5ef286(0x737),_0x5ef286(0xb1f),_0x5ef286(0x372)][_0x5ef286(0x4b6)](_0x4630bf)&&this[_0x5ef286(0x5ff)]());}this[_0x5ef286(0x9a5)]();},Game_Battler['prototype']['performWeaponAnimation']=function(){},Game_Battler[_0xfd5ed1(0x263)][_0xfd5ed1(0x2e9)]=function(_0x1c4fb4){const _0x56a371=_0xfd5ed1;if(SceneManager[_0x56a371(0xbb7)]()){const _0x4600b6=this[_0x56a371(0x456)]();if(_0x4600b6)_0x4600b6['forceWeaponAnimation'](_0x1c4fb4);}},Game_Battler[_0xfd5ed1(0x263)][_0xfd5ed1(0x2fd)]=function(){const _0x403baf=_0xfd5ed1;if(SceneManager[_0x403baf(0xbb7)]()){if('FpDNS'===_0x403baf(0x4ac)){const _0x9486d1=this[_0x403baf(0x813)]();this[_0x403baf(0x2e9)](_0x9486d1);}else{if(!_0x2b3f1c)return![];return _0xb098a3[_0x403baf(0x8aa)]()===this[_0x403baf(0x8aa)]();}}},Game_Battler[_0xfd5ed1(0x263)][_0xfd5ed1(0x5c2)]=function(_0x29042b,_0x46374a){const _0x32c28a=_0xfd5ed1;if(!_0x29042b)return;if(!_0x29042b[_0x32c28a(0x3c7)]())return;if(_0x29042b[_0x32c28a(0x517)]())return;if(_0x29042b[_0x32c28a(0x550)]())return;if(_0x29042b[_0x32c28a(0x20b)]())return;let _0x4215d=0x0;const _0x5c1f2f=VisuMZ[_0x32c28a(0x1e9)][_0x32c28a(0x607)][_0x32c28a(0x472)],_0x2bf4ba=_0x29042b[_0x32c28a(0x3c7)]()[_0x32c28a(0x80f)];if(_0x2bf4ba[_0x32c28a(0x9e4)](/<CAST ANIMATION: (\d+)>/i))_0x32c28a(0x9cb)===_0x32c28a(0x9cb)?_0x4215d=Number(RegExp['$1']):this[_0x32c28a(0x465)](_0x32c28a(0x372));else{if(_0x2bf4ba[_0x32c28a(0x9e4)](/<NO CAST ANIMATION>/i))return;else{if(_0x29042b[_0x32c28a(0x2a9)]())_0x4215d=_0x5c1f2f['CastCertain'];else{if(_0x29042b['isPhysical']())_0x4215d=_0x5c1f2f[_0x32c28a(0x2fa)];else _0x29042b[_0x32c28a(0xb32)]()&&(_0x32c28a(0x1f1)===_0x32c28a(0x3e6)?(_0x5a790c+=_0x21a494[_0x32c28a(0x75b)]()?-_0x2b08d7:_0x4af03f,_0x3977c6+=_0x306e82[_0x32c28a(0x75b)]()?-_0x1bdab9:_0x53fd61):_0x4215d=_0x5c1f2f[_0x32c28a(0x9b4)]);}}}_0x4215d>0x0&&$gameTemp[_0x32c28a(0x307)]([this],_0x4215d,!!_0x46374a);},Game_Battler[_0xfd5ed1(0x263)][_0xfd5ed1(0x40f)]=function(){const _0x4c0e52=_0xfd5ed1;SoundManager[_0x4c0e52(0x58d)]();let _0x7538f=VisuMZ['BattleCore'][_0x4c0e52(0x607)][_0x4c0e52(0x472)][_0x4c0e52(0x87e)];if(_0x7538f>0x0){if(_0x4c0e52(0x3bc)===_0x4c0e52(0x3bc))Imported[_0x4c0e52(0x768)]?$gameTemp[_0x4c0e52(0x9f1)]([this],_0x7538f):_0x4c0e52(0x497)==='luXjC'?$gameTemp[_0x4c0e52(0x307)]([this],_0x7538f):(_0x4e3e6f[_0x4c0e52(0x1e9)]['Spriteset_Battle_createBattleField'][_0x4c0e52(0x740)](this),this['createBattleFieldBattleCore']());else{if(_0x5d9016[_0x4c0e52(0x373)]&&!_0x3d33be[_0x4c0e52(0xb8c)])return this[_0x4c0e52(0x910)]();else{return _0x1b0e0f['BattleCore'][_0x4c0e52(0x6b1)][_0x4c0e52(0x740)](this);;}}}},VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0x977)]=Game_Battler[_0xfd5ed1(0x263)][_0xfd5ed1(0x6bf)],Game_Battler[_0xfd5ed1(0x263)][_0xfd5ed1(0x6bf)]=function(){const _0x4fb4fe=_0xfd5ed1;VisuMZ[_0x4fb4fe(0x1e9)][_0x4fb4fe(0x977)][_0x4fb4fe(0x740)](this),this[_0x4fb4fe(0xb8e)]();},VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0xa9c)]=Game_Battler[_0xfd5ed1(0x263)][_0xfd5ed1(0xac8)],Game_Battler['prototype'][_0xfd5ed1(0xac8)]=function(){const _0x55ff88=_0xfd5ed1;VisuMZ['BattleCore'][_0x55ff88(0xa9c)][_0x55ff88(0x740)](this),this[_0x55ff88(0xb8e)]();},VisuMZ['BattleCore'][_0xfd5ed1(0x736)]=Game_Battler[_0xfd5ed1(0x263)][_0xfd5ed1(0xa5e)],Game_Battler[_0xfd5ed1(0x263)][_0xfd5ed1(0xa5e)]=function(){const _0x3a0f70=_0xfd5ed1;VisuMZ[_0x3a0f70(0x1e9)][_0x3a0f70(0x736)][_0x3a0f70(0x740)](this),this['performFlinch']();},Game_Battler[_0xfd5ed1(0x263)][_0xfd5ed1(0xb8e)]=function(){const _0x347cf5=_0xfd5ed1;if(!$gameSystem[_0x347cf5(0xb27)]())return;if(this['_flinched'])return;this[_0x347cf5(0x3f6)]=!![];const _0x58ddf8=this['battler']();if(_0x58ddf8)_0x58ddf8[_0x347cf5(0xb4d)]();},Game_Battler[_0xfd5ed1(0x263)]['requestMotionRefresh']=function(){const _0x54121e=_0xfd5ed1;if(this[_0x54121e(0x7b0)]()&&this[_0x54121e(0x8a1)]!==_0x54121e(0x626)){this[_0x54121e(0x465)](_0x54121e(0x626));return;}if(this['isDead']()&&this[_0x54121e(0x8a1)]===_0x54121e(0x626))return;if(!!this['_freezeMotionData'])return;if(this[_0x54121e(0x73c)]()){if(!this[_0x54121e(0x35a)]()&&this!==BattleManager[_0x54121e(0xb9a)]){if(this[_0x54121e(0x456)]())this['battler']()[_0x54121e(0x999)]();}this[_0x54121e(0x9a5)]();return;}if(this[_0x54121e(0x8a1)]===_0x54121e(0xb9e))return;if(this[_0x54121e(0x8a1)]==='escape'&&!BattleManager[_0x54121e(0x5f2)]())return;if(this[_0x54121e(0x8a1)]===_0x54121e(0xa24)&&!BattleManager['isInputting']())return;this[_0x54121e(0x454)]();if(this[_0x54121e(0x456)]()&&BattleManager[_0x54121e(0x5f2)]()){if(_0x54121e(0x391)===_0x54121e(0x391)){this[_0x54121e(0x456)]()[_0x54121e(0x999)](),this[_0x54121e(0x9a5)]();return;}else this[_0x54121e(0x798)][_0x54121e(0x86e)][_0x54121e(0x8d6)]!==this[_0x54121e(0xbed)][_0x54121e(0xb46)]()&&(this['_mainSprite'][_0x54121e(0x86e)][_0x54121e(0x8d6)]=this[_0x54121e(0xbed)][_0x54121e(0xb46)]());}},Game_Enemy[_0xfd5ed1(0x263)][_0xfd5ed1(0x35a)]=function(){const _0x4e4afe=_0xfd5ed1;if(!this['hasSvBattler']())return![];const _0x197a8a=this['battler']();if(!_0x197a8a)return![];const _0xeba79d=_0x197a8a[_0x4e4afe(0x8c5)];if(!_0xeba79d)return![];const _0x4c5cc6=_0xeba79d['_motion'];return _0x4c5cc6&&!_0x4c5cc6['loop'];},Game_Battler[_0xfd5ed1(0x263)]['isBattlerFlipped']=function(){const _0x27254a=_0xfd5ed1;return this[_0x27254a(0x26c)];},Game_Battler[_0xfd5ed1(0x263)][_0xfd5ed1(0x41e)]=function(_0x83f33a){const _0x179c52=_0xfd5ed1;if(!$gameSystem[_0x179c52(0xb27)]())return;this[_0x179c52(0x26c)]=_0x83f33a;const _0x43d0e1=this[_0x179c52(0x456)]();if(_0x43d0e1)_0x43d0e1[_0x179c52(0xb10)]();},Game_Battler[_0xfd5ed1(0x263)][_0xfd5ed1(0x416)]=function(_0x5a002f,_0x130341,_0x14df58){const _0x2f5b09=_0xfd5ed1;if(!$gameSystem[_0x2f5b09(0xb27)]())return;const _0x9b0759=this[_0x2f5b09(0x456)]();if(!_0x9b0759)return;if(_0x5a002f===_0x9b0759[_0x2f5b09(0x6f7)])return;let _0x460b20=![];if(this[_0x2f5b09(0x75b)]()){if('ItpQj'===_0x2f5b09(0x71b))_0x52b58d[_0x2f5b09(0x809)]()[_0x2f5b09(0x443)]?this['push'](_0x2f5b09(0xa5e),_0x5e7846):this[_0x2f5b09(0xbc8)](_0x2f5b09(0xb00),_0xec1f9f);else{if(_0x5a002f>_0x9b0759[_0x2f5b09(0x6f7)])_0x460b20=!![];if(_0x5a002f<_0x9b0759[_0x2f5b09(0x6f7)])_0x460b20=![];}}else{if(this['isEnemy']()){if(_0x2f5b09(0x1b2)!=='RyrVi')return _0x2e01ed[_0x2f5b09(0x263)]['damageOffsetY'][_0x2f5b09(0x740)](this);else{if(_0x5a002f>_0x9b0759['_baseX'])_0x460b20=![];if(_0x5a002f<_0x9b0759['_baseX'])_0x460b20=!![];}}};this[_0x2f5b09(0x41e)](_0x14df58?!_0x460b20:_0x460b20),_0x9b0759[_0x2f5b09(0xb10)]();},Game_Battler['prototype']['moveBattlerDistance']=function(_0x59588b,_0x3bc7e0,_0x40e941,_0x4b8976,_0x14572a){const _0x275837=_0xfd5ed1;if(!$gameSystem[_0x275837(0xb27)]())return;const _0x3cde45=this[_0x275837(0x456)]();if(!_0x3cde45)return;if(_0x4b8976)this[_0x275837(0x416)](_0x59588b+_0x3cde45[_0x275837(0x6f7)],_0x3bc7e0+_0x3cde45['_baseY'],![]);_0x59588b+=_0x3cde45[_0x275837(0x6f7)]-_0x3cde45[_0x275837(0xb80)],_0x3bc7e0+=_0x3cde45[_0x275837(0x579)]-_0x3cde45['_homeY'],_0x3cde45[_0x275837(0x94f)](_0x59588b,_0x3bc7e0,_0x40e941);if(Imported[_0x275837(0x768)])_0x3cde45[_0x275837(0x41d)](_0x14572a||_0x275837(0x558));},Game_Battler[_0xfd5ed1(0x263)]['moveBattlerToPoint']=function(_0x2e0186,_0x2d1c57,_0x1a0c18,_0xd6389b,_0x403534,_0x59e97f){const _0x3b0296=_0xfd5ed1;if(!$gameSystem['isSideView']())return;const _0x29d451=this[_0x3b0296(0x456)]();if(!_0x29d451)return;_0x59e97f=_0x59e97f||0x0;if(_0x59e97f>0x0){if(_0x3b0296(0x18f)!==_0x3b0296(0x18f)){const _0x2139b9=_0xadd514[_0x3b0296(0x243)]('['+_0x1f0b67['$1'][_0x3b0296(0x9e4)](/\d+/g)+']');for(const _0x2b9172 of _0x2139b9){if(!_0x164fae[_0x3b0296(0x59a)](_0x2b9172))return!![];}return![];}else{if(_0x29d451['_baseX']>_0x2e0186)_0x2e0186+=_0x29d451[_0x3b0296(0xb4a)]/0x2+_0x59e97f;if(_0x29d451[_0x3b0296(0x6f7)]<_0x2e0186)_0x2e0186-=_0x29d451[_0x3b0296(0xb4a)]/0x2+_0x59e97f;}}if(_0xd6389b)this[_0x3b0296(0x416)](_0x2e0186,_0x2d1c57,![]);_0x2e0186-=_0x29d451['_homeX'],_0x2d1c57-=_0x29d451['_homeY'],_0x29d451['startMove'](_0x2e0186,_0x2d1c57,_0x1a0c18);if(Imported[_0x3b0296(0x768)])_0x29d451[_0x3b0296(0x41d)](_0x403534||_0x3b0296(0x558));},Game_Battler[_0xfd5ed1(0x263)]['floatBattler']=function(_0x499a52,_0x33445d,_0x4f7130){const _0x3d3cc5=_0xfd5ed1;if(!$gameSystem[_0x3d3cc5(0xb27)]())return;const _0x167f5f=this[_0x3d3cc5(0x456)]();if(!_0x167f5f)return;_0x167f5f['startFloat'](_0x499a52,_0x33445d,_0x4f7130);},Game_Battler['prototype'][_0xfd5ed1(0x99b)]=function(_0x37150f,_0xf23172){const _0x2d1216=_0xfd5ed1;if(!$gameSystem[_0x2d1216(0xb27)]())return;const _0x54869a=this[_0x2d1216(0x456)]();if(!_0x54869a)return;_0x54869a['startJump'](_0x37150f,_0xf23172);},Game_Battler[_0xfd5ed1(0x263)][_0xfd5ed1(0xa8f)]=function(_0x2eb2df,_0x42d3ce,_0x3020b7,_0x38bd1b){const _0x16e192=_0xfd5ed1;if(!$gameSystem[_0x16e192(0xb27)]())return;const _0x427f09=this[_0x16e192(0x456)]();if(!_0x427f09)return;_0x427f09['startSpin'](_0x2eb2df,_0x42d3ce,_0x3020b7,_0x38bd1b);},Game_Battler['prototype']['skewBattler']=function(_0xcdfa7c,_0xc84b74,_0x5105b1,_0x2cae10){const _0x45758f=_0xfd5ed1;if(!$gameSystem[_0x45758f(0xb27)]())return;const _0x4008a8=this[_0x45758f(0x456)]();if(!_0x4008a8)return;this[_0x45758f(0x75b)]()&&(_0xcdfa7c*=-0x1,_0xc84b74*=-0x1),_0x4008a8[_0x45758f(0x69b)](_0xcdfa7c,_0xc84b74,_0x5105b1,_0x2cae10);},Game_Battler[_0xfd5ed1(0x263)][_0xfd5ed1(0x519)]=function(_0x5ff6fd,_0x3de263,_0x2d2b5a,_0x54ea54){const _0x447b3e=_0xfd5ed1;if(!$gameSystem[_0x447b3e(0xb27)]())return;const _0x45a1e0=this[_0x447b3e(0x456)]();if(!_0x45a1e0)return;_0x45a1e0[_0x447b3e(0x876)](_0x5ff6fd,_0x3de263,_0x2d2b5a,_0x54ea54);},Game_Battler['prototype'][_0xfd5ed1(0x715)]=function(_0x4c276e,_0x49c343,_0x3959d7){const _0x5e9b24=_0xfd5ed1;if(!$gameSystem['isSideView']())return;const _0x54eaf4=this[_0x5e9b24(0x456)]();if(!_0x54eaf4)return;_0x54eaf4[_0x5e9b24(0xb07)](_0x4c276e,_0x49c343,_0x3959d7);},Game_Battler[_0xfd5ed1(0x263)]['clearFreezeMotion']=function(){const _0x3d297b=_0xfd5ed1,_0x286d46=!!this[_0x3d297b(0x9df)];this[_0x3d297b(0x9df)]=undefined,_0x286d46&&(_0x3d297b(0x45d)===_0x3d297b(0x8ec)?(_0x360cdd[_0x3d297b(0x1e9)]['Game_Actor_setup'][_0x3d297b(0x740)](this,_0x5e7aea),this[_0x3d297b(0x8ed)]()):(this[_0x3d297b(0x75c)](),this[_0x3d297b(0x1ef)]()));},Game_Battler[_0xfd5ed1(0x263)][_0xfd5ed1(0x1ef)]=function(){const _0x41f6c7=_0xfd5ed1;if(!SceneManager[_0x41f6c7(0xbb7)]())return;const _0x3a3886=this['battler']();if(!_0x3a3886)return;let _0x4b3397=this[_0x41f6c7(0x75b)]()?_0x3a3886[_0x41f6c7(0x34c)]:_0x3a3886[_0x41f6c7(0x8c5)]['_weaponSprite'];_0x4b3397&&_0x4b3397[_0x41f6c7(0xba7)](0x0);},Game_Battler[_0xfd5ed1(0x263)]['freezeMotion']=function(_0x4f26e1,_0x9db98d,_0x442dde){const _0x234bd7=_0xfd5ed1;if(this[_0x234bd7(0x73c)]()&&!this[_0x234bd7(0x9bc)]())return;let _0x4c397d=0x0,_0x31d2e2=0x0;_0x4f26e1[_0x234bd7(0x9e4)](/ATTACK[ ](\d+)/i)&&(_0x31d2e2=Number(RegExp['$1']),_0x31d2e2--);if(this[_0x234bd7(0x75b)]()){if('nruqF'===_0x234bd7(0x1ab)){const _0xcc4d25=this[_0x234bd7(0x4a9)]();_0x4c397d=_0xcc4d25[_0x31d2e2]?_0xcc4d25[_0x31d2e2]['wtypeId']:0x0;}else{const _0x3de4c6=this[_0x234bd7(0x7a1)](),_0x27b284=_0x1adfe2['BattleCore'][_0x234bd7(0x607)]['PartyCmd']['CmdIconFight'],_0x33b2e2=_0x3de4c6===_0x234bd7(0x7e7)?_0x5d6638[_0x234bd7(0x8d5)]:'\x5cI[%1]%2'[_0x234bd7(0x222)](_0x27b284,_0x3cbf07['fight']),_0x8b2664=this[_0x234bd7(0x3a6)]();this[_0x234bd7(0x93b)](_0x33b2e2,_0x234bd7(0x8d5),_0x8b2664);}}else this[_0x234bd7(0x73c)]()&&(_0x4c397d=this[_0x234bd7(0xa33)]()[_0x234bd7(0x69f)]||0x0);const _0x9ab0a0=$dataSystem[_0x234bd7(0x576)][_0x4c397d];_0x4f26e1['match'](/attack/i)&&(_0x4f26e1=[_0x234bd7(0xb1f),'swing','missile'][_0x9ab0a0[_0x234bd7(0x4b2)]]||_0x234bd7(0x737)),this['_freezeMotionData']={'motionType':_0x4f26e1,'weaponImageId':_0x9db98d?_0x9ab0a0['weaponImageId']:0x0,'pattern':_0x442dde};},Game_Battler['prototype'][_0xfd5ed1(0x2a0)]=function(_0x3bcd83){const _0xd01865=_0xfd5ed1;if(!_0x3bcd83)return![];return _0x3bcd83[_0xd01865(0x8aa)]()===this[_0xd01865(0x8aa)]();},Game_Battler[_0xfd5ed1(0x263)][_0xfd5ed1(0xb25)]=function(_0x11d6ef){const _0x5f36c9=_0xfd5ed1;if(!_0x11d6ef)return![];return _0x11d6ef[_0x5f36c9(0x4ea)]()===this[_0x5f36c9(0x8aa)]();},VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0x5a9)]=Game_Actor['prototype'][_0xfd5ed1(0xba7)],Game_Actor[_0xfd5ed1(0x263)][_0xfd5ed1(0xba7)]=function(_0x10b707){const _0x1edd66=_0xfd5ed1;VisuMZ['BattleCore'][_0x1edd66(0x5a9)]['call'](this,_0x10b707),this['initBattlePortrait']();},Game_Actor['prototype'][_0xfd5ed1(0x8ed)]=function(){const _0x293045=_0xfd5ed1;this[_0x293045(0xbbb)]='',this[_0x293045(0x279)]()&&this['actor']()[_0x293045(0x80f)]['match'](/<BATTLE (?:IMAGE|PORTRAIT):[ ](.*)>/i)&&(this[_0x293045(0xbbb)]=String(RegExp['$1']));},Game_Actor[_0xfd5ed1(0x263)][_0xfd5ed1(0xae4)]=function(){const _0x5b3a95=_0xfd5ed1;if(this['getBattlePortrait']()!=='')return this[_0x5b3a95(0x99f)]();else{if(Imported['VisuMZ_1_MainMenuCore']&&this[_0x5b3a95(0x799)]()!=='')return this[_0x5b3a95(0x799)]();}return'';},Game_Actor[_0xfd5ed1(0x263)]['getBattlePortrait']=function(){const _0x446e7e=_0xfd5ed1;if(this[_0x446e7e(0xbbb)]===undefined)this[_0x446e7e(0x8ed)]();return this[_0x446e7e(0xbbb)];},Game_Actor[_0xfd5ed1(0x263)][_0xfd5ed1(0xaab)]=function(_0x20cca4){const _0x370e24=_0xfd5ed1;if(this[_0x370e24(0xbbb)]===undefined)this[_0x370e24(0x8ed)]();this['_battlePortrait']=_0x20cca4;if(SceneManager[_0x370e24(0xbb7)]()&&$gameParty[_0x370e24(0x6d2)]()[_0x370e24(0x4b6)](this)){if('yhipU'!==_0x370e24(0x803)){const _0x5b32af=SceneManager[_0x370e24(0x3c3)][_0x370e24(0x6f2)];if(_0x5b32af)_0x5b32af[_0x370e24(0x965)](this);}else{if(!this['canMove']())return;if(!this[_0x370e24(0x858)])return;if(this[_0x370e24(0x417)]===_0x2f5728)return;this[_0x370e24(0x417)]=_0x2aaf88,this['_angleDuration']=_0x40533a,this[_0x370e24(0x892)]=_0x40bab5,this[_0x370e24(0x99d)]=_0x15eb4b||_0x370e24(0x558),this[_0x370e24(0x973)]=_0x4c168d,this['_angleRevertOnFinish']===_0x56fea0&&(this[_0x370e24(0x973)]=!![]),_0x45a0b0<=0x0&&(this[_0x370e24(0x4be)]=_0x8dd39b,this[_0x370e24(0x973)]&&(this[_0x370e24(0x417)]=0x0,this[_0x370e24(0x4be)]=0x0));}}},Game_Actor[_0xfd5ed1(0x263)]['isSpriteVisible']=function(){return!![];},Game_Actor[_0xfd5ed1(0x263)]['isAutoBattle']=function(){const _0x2fcdce=_0xfd5ed1;if(!this[_0x2fcdce(0x7e4)]()&&BattleManager[_0x2fcdce(0x373)])return!![];return Game_Battler['prototype']['isAutoBattle'][_0x2fcdce(0x740)](this);},VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0x6b1)]=Game_Actor[_0xfd5ed1(0x263)][_0xfd5ed1(0x2c1)],Game_Actor[_0xfd5ed1(0x263)][_0xfd5ed1(0x2c1)]=function(){const _0x3c42b7=_0xfd5ed1;if(BattleManager[_0x3c42b7(0x373)]&&!ConfigManager[_0x3c42b7(0xb8c)]){if(_0x3c42b7(0x388)!=='IInkm')_0x52f6a6[_0x3c42b7(0x263)][_0x3c42b7(0x217)][_0x3c42b7(0x740)](this),this[_0x3c42b7(0x604)][_0x3c42b7(0x264)]=_0x33dbb1[_0x3c42b7(0x1e9)][_0x3c42b7(0x607)][_0x3c42b7(0x1f5)][_0x3c42b7(0xad5)];else return this['makeActionListAutoAttack']();}else{return VisuMZ['BattleCore'][_0x3c42b7(0x6b1)][_0x3c42b7(0x740)](this);;}},Game_Actor[_0xfd5ed1(0x263)][_0xfd5ed1(0x910)]=function(){const _0x1f5b4c=_0xfd5ed1,_0x5f082c=[],_0x511f8=new Game_Action(this);return _0x511f8[_0x1f5b4c(0xad7)](),_0x5f082c[_0x1f5b4c(0xbc8)](_0x511f8),_0x5f082c;},Game_Actor['prototype']['battleCommands']=function(){const _0x1a8d4a=_0xfd5ed1;return this[_0x1a8d4a(0x90c)]()[_0x1a8d4a(0x80f)][_0x1a8d4a(0x9e4)](/<BATTLE COMMANDS>\s*([\s\S]*)\s*<\/BATTLE COMMANDS>/i)?String(RegExp['$1'])[_0x1a8d4a(0x513)](/[\r\n]+/):VisuMZ[_0x1a8d4a(0x1e9)][_0x1a8d4a(0x607)]['ActorCmd'][_0x1a8d4a(0x7c7)];},Game_Actor[_0xfd5ed1(0x263)][_0xfd5ed1(0xba3)]=function(){const _0xc85682=_0xfd5ed1;if(this[_0xc85682(0x303)][_0xc85682(0x886)]!==undefined)return this['_cache'][_0xc85682(0x886)];if(this['actor']()[_0xc85682(0x80f)][_0xc85682(0x9e4)](/<SIDEVIEW ANCHOR: (.*), (.*)>/i)){if(_0xc85682(0xb82)==='jLRjz')this['_cache']['svAnchorX']=eval(RegExp['$1']),this['_cache'][_0xc85682(0x898)]=eval(RegExp['$2']);else return _0x59f947['friendsUnit']()[_0xc85682(0x6cc)]()[_0xc85682(0x4af)](_0x129ebb=>_0x129ebb!==_0x37796b);}else this[_0xc85682(0x303)][_0xc85682(0x886)]=Game_Battler['prototype'][_0xc85682(0xba3)]['call'](this);return this[_0xc85682(0x303)][_0xc85682(0x886)];},Game_Actor['prototype'][_0xfd5ed1(0x77c)]=function(){const _0x26b2ab=_0xfd5ed1;if(this[_0x26b2ab(0x303)][_0x26b2ab(0x898)]!==undefined)return this[_0x26b2ab(0x303)]['svAnchorY'];return this[_0x26b2ab(0x279)]()['note']['match'](/<SIDEVIEW ANCHOR: (.*), (.*)>/i)?(this[_0x26b2ab(0x303)][_0x26b2ab(0x886)]=eval(RegExp['$1']),this[_0x26b2ab(0x303)][_0x26b2ab(0x898)]=eval(RegExp['$2'])):this[_0x26b2ab(0x303)][_0x26b2ab(0x898)]=Game_Battler['prototype'][_0x26b2ab(0x77c)]['call'](this),this[_0x26b2ab(0x303)][_0x26b2ab(0x898)];},Game_Actor[_0xfd5ed1(0x263)][_0xfd5ed1(0xb20)]=function(){const _0x7dd62b=_0xfd5ed1;if(this[_0x7dd62b(0x303)][_0x7dd62b(0x59e)]!==undefined)return this[_0x7dd62b(0x303)][_0x7dd62b(0x59e)];if(this[_0x7dd62b(0x279)]()[_0x7dd62b(0x80f)][_0x7dd62b(0x9e4)](/<SIDEVIEW SHOW SHADOW>/i))this['_cache'][_0x7dd62b(0x59e)]=!![];else{if(this[_0x7dd62b(0x279)]()[_0x7dd62b(0x80f)][_0x7dd62b(0x9e4)](/<SIDEVIEW HIDE SHADOW>/i))this[_0x7dd62b(0x303)][_0x7dd62b(0x59e)]=![];else{if(_0x7dd62b(0x45f)!==_0x7dd62b(0x860))this['_cache']['svShadow']=Game_Battler[_0x7dd62b(0x263)][_0x7dd62b(0xb20)]['call'](this);else{this['push']('performReflection',_0x5ad759);if(!_0x54ceab[_0x7dd62b(0x1e9)][_0x7dd62b(0x607)]['BattleLog']['ShowReflect'])return;this['push'](_0x7dd62b(0x1e4),_0xc79e8f[_0x7dd62b(0x7da)][_0x7dd62b(0x222)](_0x531841[_0x7dd62b(0x452)]()));}}}return this['_cache'][_0x7dd62b(0x59e)];},Game_Actor[_0xfd5ed1(0x263)][_0xfd5ed1(0xb46)]=function(){const _0x54ee8c=_0xfd5ed1;return VisuMZ[_0x54ee8c(0x1e9)][_0x54ee8c(0x607)][_0x54ee8c(0xbdf)]['SmoothImage'];},Game_Actor[_0xfd5ed1(0x263)][_0xfd5ed1(0x5ff)]=function(){const _0x5707e7=_0xfd5ed1,_0x456603=this[_0x5707e7(0x4a9)](),_0xf88a27=_0x456603[0x0]?_0x456603[0x0][_0x5707e7(0x69f)]:0x0,_0x579114=$dataSystem[_0x5707e7(0x576)][_0xf88a27];if(_0x579114){if(_0x5707e7(0x8fe)!==_0x5707e7(0x8fe))return!![];else this['startWeaponAnimation'](_0x579114[_0x5707e7(0x875)]);}},Game_Actor[_0xfd5ed1(0x263)][_0xfd5ed1(0x871)]=function(_0x510fe9){const _0x487636=_0xfd5ed1;Game_Battler[_0x487636(0x263)][_0x487636(0x871)][_0x487636(0x740)](this,_0x510fe9),this['performActionMotions'](_0x510fe9);},Game_Actor[_0xfd5ed1(0x263)][_0xfd5ed1(0x9ba)]=function(){const _0x932502=_0xfd5ed1,_0x533d80=this[_0x932502(0x4a9)](),_0x5b92d6=_0x533d80[0x0]?_0x533d80[0x0][_0x932502(0x69f)]:0x0;return $dataSystem['attackMotions'][_0x5b92d6];},Game_Actor[_0xfd5ed1(0x263)]['attackAnimationIdSlot']=function(_0x159b91){const _0x486632=_0xfd5ed1;_0x159b91=_0x159b91||0x1,_0x159b91--;const _0x48eb17=this[_0x486632(0x4a9)]();return _0x48eb17[_0x159b91]?_0x48eb17[_0x159b91][_0x486632(0x82b)]:0x0;},Game_Actor[_0xfd5ed1(0x263)][_0xfd5ed1(0x19b)]=function(_0x4b0ab0){const _0x37b230=_0xfd5ed1;_0x4b0ab0=_0x4b0ab0||0x1,_0x4b0ab0--;const _0x48ebef=this[_0x37b230(0x4a9)](),_0x27cc13=_0x48ebef[_0x4b0ab0]?_0x48ebef[_0x4b0ab0][_0x37b230(0x69f)]:0x0;return $dataSystem[_0x37b230(0x576)][_0x27cc13];},Game_Actor[_0xfd5ed1(0x263)]['performAttackSlot']=function(_0x234e62){const _0x1a19b4=_0xfd5ed1;_0x234e62=_0x234e62||0x1,_0x234e62--;const _0x275e98=this[_0x1a19b4(0x4a9)](),_0x3fcb30=_0x275e98[_0x234e62]?_0x275e98[_0x234e62][_0x1a19b4(0x69f)]:0x0,_0xa865e7=$dataSystem['attackMotions'][_0x3fcb30];if(_0xa865e7){if(_0xa865e7[_0x1a19b4(0x4b2)]===0x0)this[_0x1a19b4(0x465)]('thrust');else{if(_0xa865e7[_0x1a19b4(0x4b2)]===0x1)this['requestMotion'](_0x1a19b4(0x737));else _0xa865e7[_0x1a19b4(0x4b2)]===0x2&&this[_0x1a19b4(0x465)](_0x1a19b4(0x372));}this[_0x1a19b4(0x2e9)](_0xa865e7[_0x1a19b4(0x875)]);}},Game_Battler[_0xfd5ed1(0x263)][_0xfd5ed1(0x5e7)]=function(_0x304f71){const _0x591fdd=_0xfd5ed1;this[_0x591fdd(0xb09)]=_0x304f71||0x0;},Game_Battler[_0xfd5ed1(0x263)][_0xfd5ed1(0x97d)]=function(){this['_activeWeaponSlot']=this['_activeWeaponSlot']||0x0,this['_activeWeaponSlot']++;},Game_Battler[_0xfd5ed1(0x263)]['clearActiveWeaponSlot']=function(){const _0x5b2e68=_0xfd5ed1;this[_0x5b2e68(0xb09)]=undefined;},VisuMZ[_0xfd5ed1(0x1e9)]['Game_Actor_equips']=Game_Actor['prototype'][_0xfd5ed1(0x9dd)],Game_Actor[_0xfd5ed1(0x263)][_0xfd5ed1(0x9dd)]=function(){const _0x8b9395=_0xfd5ed1;let _0x4c72c5=VisuMZ[_0x8b9395(0x1e9)][_0x8b9395(0x755)]['call'](this);if(this[_0x8b9395(0x602)])return _0x4c72c5;if(this[_0x8b9395(0xb09)]!==undefined){if('LwGRF'===_0x8b9395(0x70b)){const _0x32d7b1=this['commandStyleCheck'](_0x55fbf4);if(_0x32d7b1===_0x8b9395(0x9c6))this[_0x8b9395(0x857)](_0x18929a);else _0x32d7b1===_0x8b9395(0x9ec)?this[_0x8b9395(0x5af)](_0x4cd05a):_0x446bc3[_0x8b9395(0x263)]['drawItem'][_0x8b9395(0x740)](this,_0x1240bf);}else{this[_0x8b9395(0x602)]=!![];const _0x950309=this[_0x8b9395(0x2b0)]();for(let _0x331e65=0x0;_0x331e65<_0x950309[_0x8b9395(0x5b7)];_0x331e65++){_0x950309[_0x331e65]===0x1&&this[_0x8b9395(0xb09)]!==_0x331e65&&(_0x4c72c5[_0x331e65]=null);}this[_0x8b9395(0x602)]=undefined;}}return _0x4c72c5;},Window_BattleLog['prototype'][_0xfd5ed1(0xb1d)]=function(_0x24d999){const _0x1a0668=_0xfd5ed1;return _0x24d999[_0x1a0668(0x75b)]()?_0x24d999[_0x1a0668(0x4a9)]()[_0x1a0668(0x5b7)]||0x1:0x1;},Window_BattleLog[_0xfd5ed1(0x263)][_0xfd5ed1(0x592)]=function(_0x5b39d1,_0x278e7d){const _0x3fa2b1=_0xfd5ed1;_0x5b39d1&&_0x5b39d1['isActor']()&&(_0x3fa2b1(0xaaa)!=='WXWFE'?_0x20c5d4['prototype'][_0x3fa2b1(0xbe5)]['call'](this):_0x5b39d1[_0x3fa2b1(0x5e7)](_0x278e7d)),this[_0x3fa2b1(0x6f4)]();},Window_BattleLog[_0xfd5ed1(0x263)][_0xfd5ed1(0x779)]=function(_0x577c1b){const _0x584332=_0xfd5ed1;if(_0x577c1b&&_0x577c1b[_0x584332(0x75b)]()){if('gZhaT'===_0x584332(0x696)){const _0x35ebe6=_0x591b76[_0x584332(0x1e9)][_0x584332(0x607)][_0x584332(0x1f5)];this['_attackAnimationId']=_0x35ebe6[_0x584332(0x6e9)],this['_svBattlerData']={};}else _0x577c1b[_0x584332(0x2dd)]();}this[_0x584332(0x6f4)]();},Game_Actor['prototype'][_0xfd5ed1(0x590)]=function(){const _0x563fca=_0xfd5ed1;let _0x3a4ba2=_0x563fca(0x590);if(this[_0x563fca(0x5cb)](_0x3a4ba2))return this[_0x563fca(0x303)][_0x3a4ba2];return this['_cache'][_0x3a4ba2]=this['createBattleUIOffsetX'](this[_0x563fca(0x279)]()),this[_0x563fca(0x303)][_0x3a4ba2];},Game_Actor['prototype'][_0xfd5ed1(0x342)]=function(){const _0x3b0d80=_0xfd5ed1;let _0x4c0c66=_0x3b0d80(0x342);if(this[_0x3b0d80(0x5cb)](_0x4c0c66))return this[_0x3b0d80(0x303)][_0x4c0c66];return this[_0x3b0d80(0x303)][_0x4c0c66]=this['createBattleUIOffsetY'](this['actor']()),this['_cache'][_0x4c0c66];},VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0x830)]=Game_Enemy[_0xfd5ed1(0x263)]['setup'],Game_Enemy[_0xfd5ed1(0x263)][_0xfd5ed1(0xba7)]=function(_0x1effcc,_0x1634a7,_0x551d8d){const _0x490ea2=_0xfd5ed1;_0x1effcc=DataManager[_0x490ea2(0x6fa)](_0x1effcc),VisuMZ['BattleCore'][_0x490ea2(0x830)][_0x490ea2(0x740)](this,_0x1effcc,_0x1634a7,_0x551d8d);if(Imported[_0x490ea2(0xb2f)]){if(_0x490ea2(0x8bb)!==_0x490ea2(0x2bb))this[_0x490ea2(0xa41)]();else{if(!_0xf7cf4['isSceneBattle']())return;_0x53a088[_0x490ea2(0x1c5)](_0x39d609,_0x26b4d1);const _0x4a0079=_0x576029[_0x490ea2(0x58e)](),_0x4ec773=_0x445687[_0x490ea2(0x9c7)]*_0x354741[_0x490ea2(0x502)];_0x4a0079[_0x490ea2(0x3f7)](_0x4ec773);}}this[_0x490ea2(0x894)](),this[_0x490ea2(0x49f)](),Imported[_0x490ea2(0xb2f)]&&this['recoverAll']();},Game_Enemy[_0xfd5ed1(0x263)][_0xfd5ed1(0x894)]=function(){const _0x5d6ae4=_0xfd5ed1,_0x550450=VisuMZ[_0x5d6ae4(0x1e9)][_0x5d6ae4(0x607)][_0x5d6ae4(0x1f5)];this[_0x5d6ae4(0x5a4)]=_0x550450[_0x5d6ae4(0x6e9)],this[_0x5d6ae4(0x73a)]={};},Game_Enemy[_0xfd5ed1(0x263)][_0xfd5ed1(0x49f)]=function(){const _0x239d37=_0xfd5ed1,_0x47f270=VisuMZ['BattleCore'][_0x239d37(0x607)][_0x239d37(0x1f5)],_0xb49824=this[_0x239d37(0x333)]()[_0x239d37(0x80f)];this['_svBattlerData']={'name':'','wtypeId':_0x47f270[_0x239d37(0x96c)],'collapse':_0x47f270[_0x239d37(0x525)],'motionIdle':_0x47f270['MotionIdle'],'width':_0x47f270['Width']||0x40,'height':_0x47f270[_0x239d37(0x288)]||0x40,'anchorX':_0x47f270[_0x239d37(0x866)]||0x0,'anchorY':_0x47f270[_0x239d37(0x8e4)]||0x0,'shadow':_0x47f270[_0x239d37(0x9c2)]};_0xb49824['match'](/<ATTACK ANIMATION:[ ](\d+)>/i)&&(_0x239d37(0x237)!==_0x239d37(0x237)?(_0x3068ac[_0x239d37(0x1e9)][_0x239d37(0xb6b)]['call'](this),this[_0x239d37(0xa9f)]&&(this[_0x239d37(0xa9f)]=_0x2ca647,_0x57b174[_0x239d37(0x3c3)][_0x239d37(0x1ba)]())):this[_0x239d37(0x5a4)]=Number(RegExp['$1']));const _0x36de04=this[_0x239d37(0x73a)];if(_0xb49824[_0x239d37(0x9e4)](/<SIDEVIEW BATTLER: (.*)>/i))_0x36de04[_0x239d37(0x452)]=String(RegExp['$1']);else{if(_0xb49824['match'](/<SIDEVIEW BATTLERS>\s*([\s\S]*)\s*<\/SIDEVIEW BATTLERS>/i)){const _0x403935=String(RegExp['$1'])[_0x239d37(0x513)](/[\r\n]+/)[_0x239d37(0x698)]('');_0x36de04['name']=DataManager[_0x239d37(0x780)](_0x403935);}}_0xb49824[_0x239d37(0x9e4)](/<SIDEVIEW ANCHOR: (.*), (.*)>/i)&&(_0x239d37(0x46d)!==_0x239d37(0x46d)?(this[_0x239d37(0x901)][_0x239d37(0xbc8)](_0x239d37(0x1e4),_0x3e7528[_0x239d37(0x6f6)][_0x239d37(0x222)](_0x167e76['name']())),this[_0x239d37(0x901)][_0x239d37(0xbc8)](_0x239d37(0x3f7))):(_0x36de04[_0x239d37(0xb6f)]=eval(RegExp['$1']),_0x36de04[_0x239d37(0x70e)]=eval(RegExp['$2'])));if(_0xb49824['match'](/<SIDEVIEW COLLAPSE>/i))_0x36de04[_0x239d37(0x51f)]=!![];else _0xb49824[_0x239d37(0x9e4)](/<SIDEVIEW NO COLLAPSE>/i)&&(_0x239d37(0x4e9)===_0x239d37(0x4e9)?_0x36de04[_0x239d37(0x51f)]=![]:(_0xcfb4b4=(_0x389e25+_0x5bfbcd)/0x2,_0x395475=-0x1));if(_0xb49824['match'](/<SIDEVIEW SHOW SHADOW>/i)){if(_0x239d37(0x9a2)!==_0x239d37(0x409))_0x36de04[_0x239d37(0x298)]=!![];else return _0x111052['BattleCore'][_0x239d37(0x607)][_0x239d37(0x56b)][_0x239d37(0x887)];}else _0xb49824['match'](/<SIDEVIEW HIDE SHADOW>/i)&&(_0x36de04[_0x239d37(0x298)]=![]);if(_0xb49824[_0x239d37(0x9e4)](/<SIDEVIEW IDLE MOTION: (.*)>/i))_0x36de04['motionIdle']=String(RegExp['$1'])[_0x239d37(0x572)]()[_0x239d37(0x300)]();else{if(_0xb49824[_0x239d37(0x9e4)](/<SIDEVIEW IDLE MOTIONS>\s*([\s\S]*)\s*<\/SIDEVIEW IDLE MOTIONS>/i)){const _0x45dfcd=String(RegExp['$1'])[_0x239d37(0x513)](/[\r\n]+/)[_0x239d37(0x698)]('');_0x36de04[_0x239d37(0x60b)]=DataManager['processRandomizedData'](_0x45dfcd);}}if(_0xb49824[_0x239d37(0x9e4)](/<SIDEVIEW SIZE: (\d+), (\d+)>/i)){if(_0x239d37(0x2d4)!==_0x239d37(0x5bf))_0x36de04[_0x239d37(0xb4a)]=Number(RegExp['$1']),_0x36de04[_0x239d37(0x8c6)]=Number(RegExp['$2']);else{if(this['_cache'][_0x239d37(0x886)]!==_0x16fe6b)return this[_0x239d37(0x303)][_0x239d37(0x886)];return this[_0x239d37(0x279)]()['note'][_0x239d37(0x9e4)](/<SIDEVIEW ANCHOR: (.*), (.*)>/i)?(this[_0x239d37(0x303)][_0x239d37(0x886)]=_0x209a3c(_0x49e81b['$1']),this[_0x239d37(0x303)][_0x239d37(0x898)]=_0x16e660(_0x321a3d['$2'])):this[_0x239d37(0x303)][_0x239d37(0x886)]=_0x37e707['prototype'][_0x239d37(0xba3)][_0x239d37(0x740)](this),this['_cache'][_0x239d37(0x886)];}}if(_0xb49824[_0x239d37(0x9e4)](/<SIDEVIEW WEAPON: (.*)>/i))_0x36de04[_0x239d37(0x69f)]=DataManager[_0x239d37(0xae3)](RegExp['$1']);else{if(_0xb49824['match'](/<SIDEVIEW WEAPONS>\s*([\s\S]*)\s*<\/SIDEVIEW WEAPONS>/i)){if(_0x239d37(0x25e)!==_0x239d37(0x25e)){const _0x2c4aff=_0x123055[_0x239d37(0x1e9)][_0x239d37(0x607)][_0x239d37(0x6d8)];_0x2c4aff['BattleEndEvent']&&_0x15d9b5[_0x239d37(0x1e9)]['CheckMapBattleEventValid'](_0x2c4aff[_0x239d37(0x905)])&&_0x475d52[_0x239d37(0x601)](_0x2c4aff[_0x239d37(0x905)]);const _0x382ed6=_0x239d37(0x2ea)['format'](_0x3c0946);_0x2c4aff[_0x382ed6]&&_0x531c90[_0x239d37(0x1e9)]['CheckMapBattleEventValid'](_0x2c4aff[_0x382ed6])&&_0x5aac03[_0x239d37(0x601)](_0x2c4aff[_0x382ed6]);}else{const _0x320e1a=String(RegExp['$1'])['split'](/[\r\n]+/)[_0x239d37(0x698)](''),_0x3f8e34=DataManager[_0x239d37(0x780)](_0x320e1a);_0x36de04[_0x239d37(0x69f)]=DataManager[_0x239d37(0xae3)](_0x3f8e34);}}}if(Imported[_0x239d37(0xb2f)]){const _0x4d4ed5=this[_0x239d37(0x84a)]();for(const _0x3d7187 of _0x4d4ed5){const _0x2bd837=this[_0x239d37(0xa56)](_0x3d7187)[_0x239d37(0xa00)][_0x239d37(0xa50)]()[_0x239d37(0x300)](),_0x672b06=_0x3d7187[_0x239d37(0xa50)]()['trim']();if(_0xb49824[_0x239d37(0x9e4)](VisuMZ[_0x239d37(0x3bf)][_0x239d37(0x349)][_0x239d37(0xa21)[_0x239d37(0x222)](_0x672b06,_0x2bd837)]))_0x36de04[_0x239d37(0x452)]=String(RegExp['$1']);else{if(_0xb49824['match'](VisuMZ[_0x239d37(0x3bf)][_0x239d37(0x349)][_0x239d37(0x4d0)[_0x239d37(0x222)](_0x672b06,_0x2bd837)])){if('xrvAZ'===_0x239d37(0x6bb)){const _0xb5cbc0=String(RegExp['$1'])[_0x239d37(0x513)](/[\r\n]+/)['remove']('');_0x36de04[_0x239d37(0x452)]=DataManager[_0x239d37(0x780)](_0xb5cbc0);}else return this[_0x239d37(0x201)]();}}if(_0xb49824[_0x239d37(0x9e4)](VisuMZ[_0x239d37(0x3bf)][_0x239d37(0x349)][_0x239d37(0x20c)[_0x239d37(0x222)](_0x672b06,_0x2bd837)]))_0x36de04[_0x239d37(0x69f)]=DataManager['getWtypeIdWithName'](RegExp['$1']);else{if(_0xb49824[_0x239d37(0x9e4)](VisuMZ[_0x239d37(0x3bf)]['RegExp']['SvWeaponMass-%1-%2'[_0x239d37(0x222)](_0x672b06,_0x2bd837)])){const _0x510672=String(RegExp['$1'])[_0x239d37(0x513)](/[\r\n]+/)[_0x239d37(0x698)](''),_0x554ecd=DataManager[_0x239d37(0x780)](_0x510672);_0x36de04[_0x239d37(0x69f)]=DataManager[_0x239d37(0xae3)](_0x554ecd);}}if(_0xb49824[_0x239d37(0x9e4)](VisuMZ['ElementStatusCore'][_0x239d37(0x349)][_0x239d37(0x674)[_0x239d37(0x222)](_0x672b06,_0x2bd837)])){if(_0x239d37(0x4e3)===_0x239d37(0x57a)){_0x31a6cf[_0x239d37(0x1e9)]['Game_Battler_performActionStart'][_0x239d37(0x740)](this,_0xcf4c8);if(!_0x1c6aa2[_0x239d37(0x550)]()){const _0x573e5d=this[_0x239d37(0x456)]();_0x573e5d&&_0x573e5d[_0x239d37(0x8a4)]();}this['setBattlerFlip'](![]);}else _0x36de04[_0x239d37(0x60b)]=String(RegExp['$1'])[_0x239d37(0x572)]()[_0x239d37(0x300)]();}else{if(_0xb49824[_0x239d37(0x9e4)](VisuMZ[_0x239d37(0x3bf)][_0x239d37(0x349)]['SvMotionIdleMass-%1-%2'[_0x239d37(0x222)](_0x672b06,_0x2bd837)])){if(_0x239d37(0x6b8)===_0x239d37(0x6b8)){const _0x4b75a6=String(RegExp['$1'])['split'](/[\r\n]+/)[_0x239d37(0x698)]('');_0x36de04['motionIdle']=DataManager['processRandomizedData'](_0x4b75a6);}else{const _0x3b5713=_0x2971db['randomInt'](0x2)===0x0?this[_0x239d37(0x4ea)]():this[_0x239d37(0x8aa)]();_0xe3ae13['push'](_0x3b5713[_0x239d37(0x979)]());}}}}}},Game_Enemy[_0xfd5ed1(0x263)][_0xfd5ed1(0x4a0)]=function(){return this['_attackAnimationId']||0x0;},Game_Enemy[_0xfd5ed1(0x263)][_0xfd5ed1(0x605)]=function(){const _0x5dd059=_0xfd5ed1;return this[_0x5dd059(0x4a0)]();},Game_Enemy[_0xfd5ed1(0x263)][_0xfd5ed1(0x404)]=function(_0x198cf2){const _0x4000b4=_0xfd5ed1;return this[_0x4000b4(0x4a0)]();},Game_Enemy['prototype']['canBattlerMove']=function(){const _0x567025=_0xfd5ed1;if(this[_0x567025(0x333)]()[_0x567025(0x80f)][_0x567025(0x9e4)](/<BATTLER SPRITE CANNOT MOVE>/i))return![];return Game_Battler['prototype']['canBattlerMove']['call'](this);},Game_Enemy[_0xfd5ed1(0x263)][_0xfd5ed1(0x711)]=function(){const _0x35b9cd=_0xfd5ed1;if(this[_0x35b9cd(0x333)]()[_0x35b9cd(0x80f)][_0x35b9cd(0x9e4)](/<BATTLER SPRITE GROUNDED>/i))return!![];return![];},Game_Enemy['prototype'][_0xfd5ed1(0x4d6)]=function(){const _0x6d1bcd=_0xfd5ed1,_0x2386b7=[];for(const _0x4feb8a of this[_0x6d1bcd(0x333)]()[_0x6d1bcd(0x851)]){if(_0x6d1bcd(0x88f)===_0x6d1bcd(0x48c)){if(!this[_0x6d1bcd(0xbed)])return![];return _0x597488[_0x6d1bcd(0x1e9)][_0x6d1bcd(0x812)]['call'](this);}else{const _0x159346=$dataSkills[_0x4feb8a['skillId']];if(_0x159346&&!_0x2386b7['includes'](_0x159346))_0x2386b7[_0x6d1bcd(0xbc8)](_0x159346);}}return _0x2386b7;},Game_Enemy[_0xfd5ed1(0x263)]['battleUIOffsetX']=function(){const _0x43f88b=_0xfd5ed1;let _0x301e37=_0x43f88b(0x590);if(this[_0x43f88b(0x5cb)](_0x301e37))return this[_0x43f88b(0x303)][_0x301e37];return this['_cache'][_0x301e37]=this['createBattleUIOffsetX'](this[_0x43f88b(0x333)]()),this[_0x43f88b(0x303)][_0x301e37];},Game_Enemy[_0xfd5ed1(0x263)][_0xfd5ed1(0x342)]=function(){const _0x280e4b=_0xfd5ed1;let _0x1cd1d1=_0x280e4b(0x342);if(this[_0x280e4b(0x5cb)](_0x1cd1d1))return this[_0x280e4b(0x303)][_0x1cd1d1];return this[_0x280e4b(0x303)][_0x1cd1d1]=this[_0x280e4b(0xaba)](this[_0x280e4b(0x333)]()),this[_0x280e4b(0x303)][_0x1cd1d1];},Game_Enemy[_0xfd5ed1(0x263)][_0xfd5ed1(0xa33)]=function(){const _0x4c07b7=_0xfd5ed1;if(this[_0x4c07b7(0x73a)]!==undefined)return this[_0x4c07b7(0x73a)];return this[_0x4c07b7(0x49f)](),this[_0x4c07b7(0x73a)];},Game_Enemy['prototype'][_0xfd5ed1(0x9bc)]=function(){const _0x4fdc6a=_0xfd5ed1;return this[_0x4fdc6a(0xa33)]()[_0x4fdc6a(0x452)]!=='';},Game_Enemy['prototype'][_0xfd5ed1(0x5fb)]=function(){const _0xf97ddd=_0xfd5ed1;return this[_0xf97ddd(0xa33)]()[_0xf97ddd(0x452)];},Game_Enemy[_0xfd5ed1(0x263)][_0xfd5ed1(0xb46)]=function(){const _0x2deefd=_0xfd5ed1;if(this[_0x2deefd(0x9bc)]())return VisuMZ[_0x2deefd(0x1e9)][_0x2deefd(0x607)]['Actor'][_0x2deefd(0xa38)];else{if('bSLWY'==='bSLWY')return VisuMZ['BattleCore'][_0x2deefd(0x607)][_0x2deefd(0x1f5)]['SmoothImage'];else this[_0x2deefd(0x937)]['x']=this['x'],this[_0x2deefd(0x937)]['y']=this['y'];}},Game_Enemy[_0xfd5ed1(0x263)][_0xfd5ed1(0x871)]=function(_0x39578c){const _0xb3c365=_0xfd5ed1;Game_Battler[_0xb3c365(0x263)][_0xb3c365(0x871)]['call'](this,_0x39578c);if(this[_0xb3c365(0x9bc)]())this['performActionMotions'](_0x39578c);},Game_Enemy['prototype'][_0xfd5ed1(0x45b)]=function(){const _0x833a7b=_0xfd5ed1,_0x3dcf45=this[_0x833a7b(0xa33)]()['wtypeId']||0x0,_0xc33f92=$dataSystem[_0x833a7b(0x576)][_0x3dcf45];if(_0xc33f92){if(_0xc33f92[_0x833a7b(0x4b2)]===0x0)this[_0x833a7b(0x465)]('thrust');else{if(_0xc33f92[_0x833a7b(0x4b2)]===0x1)this[_0x833a7b(0x465)](_0x833a7b(0x737));else _0xc33f92[_0x833a7b(0x4b2)]===0x2&&this['requestMotion'](_0x833a7b(0x372));}}},Game_Enemy[_0xfd5ed1(0x263)]['performWeaponAnimation']=function(){const _0x28be65=_0xfd5ed1,_0x41c7dc=this[_0x28be65(0xa33)]()[_0x28be65(0x69f)]||0x0,_0x1df3cf=$dataSystem[_0x28be65(0x576)][_0x41c7dc];_0x1df3cf&&this[_0x28be65(0x2e9)](_0x1df3cf[_0x28be65(0x875)]);},Game_Enemy[_0xfd5ed1(0x263)][_0xfd5ed1(0x9ba)]=function(){const _0x13a1ff=_0xfd5ed1,_0x399111=this[_0x13a1ff(0xa33)]()[_0x13a1ff(0x69f)]||0x0;return $dataSystem['attackMotions'][_0x399111];},Game_Enemy[_0xfd5ed1(0x263)][_0xfd5ed1(0x19b)]=function(_0x49f934){const _0x18c2ba=_0xfd5ed1;return this[_0x18c2ba(0x9ba)]();},Game_Enemy[_0xfd5ed1(0x263)][_0xfd5ed1(0x6bf)]=function(){const _0x3467ba=_0xfd5ed1;Game_Battler[_0x3467ba(0x263)][_0x3467ba(0x6bf)][_0x3467ba(0x740)](this),this['isSpriteVisible']()&&this['hasSvBattler']()&&this['requestMotion'](_0x3467ba(0x42d)),SoundManager['playEnemyDamage']();},Game_Enemy[_0xfd5ed1(0x263)]['performEvasion']=function(){const _0x271b71=_0xfd5ed1;Game_Battler[_0x271b71(0x263)]['performEvasion'][_0x271b71(0x740)](this),this['requestMotion'](_0x271b71(0xb45));},Game_Enemy[_0xfd5ed1(0x263)][_0xfd5ed1(0xb00)]=function(){const _0x28148b=_0xfd5ed1;Game_Battler[_0x28148b(0x263)][_0x28148b(0xb00)][_0x28148b(0x740)](this),this[_0x28148b(0x465)](_0x28148b(0xb45));},Game_Enemy[_0xfd5ed1(0x263)][_0xfd5ed1(0x2ae)]=function(){const _0x31c811=_0xfd5ed1;Game_Battler[_0x31c811(0x263)][_0x31c811(0x2ae)][_0x31c811(0x740)](this),this[_0x31c811(0x45b)]();},Game_Enemy[_0xfd5ed1(0x263)][_0xfd5ed1(0xbcb)]=function(){const _0x185cb7=_0xfd5ed1;if(this[_0x185cb7(0x9bc)]()){if(this[_0x185cb7(0x588)]()>=0x1)return!![];return this[_0x185cb7(0xa33)]()['collapse'];}else return!![];},Game_Enemy['prototype']['svBattlerAnchorX']=function(){const _0x54bb31=_0xfd5ed1;return this[_0x54bb31(0xa33)]()['anchorX'];},Game_Enemy[_0xfd5ed1(0x263)][_0xfd5ed1(0x77c)]=function(){const _0x20157c=_0xfd5ed1;return this[_0x20157c(0xa33)]()[_0x20157c(0x70e)];},Game_Enemy[_0xfd5ed1(0x263)]['svBattlerShadowVisible']=function(){const _0x3e0de3=_0xfd5ed1;return this[_0x3e0de3(0xa33)]()[_0x3e0de3(0x298)];},VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0x2c7)]=Game_Enemy[_0xfd5ed1(0x263)][_0xfd5ed1(0x4b4)],Game_Enemy[_0xfd5ed1(0x263)][_0xfd5ed1(0x4b4)]=function(_0x17c1a3){const _0x2447a9=_0xfd5ed1;VisuMZ[_0x2447a9(0x1e9)][_0x2447a9(0x2c7)][_0x2447a9(0x740)](this,_0x17c1a3),this['clearBattleCoreData'](),this[_0x2447a9(0x49f)]();const _0x4166e1=this[_0x2447a9(0x456)]();if(_0x4166e1)_0x4166e1[_0x2447a9(0xac4)](this);},Game_Unit['prototype'][_0xfd5ed1(0x2db)]=function(_0x385f05){const _0x5e40a4=_0xfd5ed1;for(const _0x12da1d of this[_0x5e40a4(0xb77)]()){if(_0x5e40a4(0x223)===_0x5e40a4(0x193))return _0x3150d1[_0x5e40a4(0x1e9)]['Settings'][_0x5e40a4(0x56b)][_0x5e40a4(0xb3c)];else{if(_0x12da1d)_0x12da1d[_0x5e40a4(0x2db)](_0x385f05);}}},Game_Unit[_0xfd5ed1(0x263)][_0xfd5ed1(0x979)]=function(){const _0x48683d=_0xfd5ed1,_0x1eec63=this['aliveMembers']();return _0x1eec63[Math[_0x48683d(0xb38)](_0x1eec63['length'])];},VisuMZ['BattleCore']['Game_Party_addActor']=Game_Party[_0xfd5ed1(0x263)][_0xfd5ed1(0xa2e)],Game_Party[_0xfd5ed1(0x263)]['addActor']=function(_0x4f8947){const _0x51485a=_0xfd5ed1;VisuMZ[_0x51485a(0x1e9)][_0x51485a(0xa69)][_0x51485a(0x740)](this,_0x4f8947),BattleManager['refreshStatusWindow']();},VisuMZ['BattleCore'][_0xfd5ed1(0x969)]=Game_Party[_0xfd5ed1(0x263)]['removeActor'],Game_Party[_0xfd5ed1(0x263)][_0xfd5ed1(0x9ed)]=function(_0x382181){const _0x453d17=_0xfd5ed1;VisuMZ['BattleCore']['Game_Party_removeActor'][_0x453d17(0x740)](this,_0x382181),BattleManager['refreshStatusWindow']();},VisuMZ['BattleCore']['Game_Troop_setup']=Game_Troop[_0xfd5ed1(0x263)][_0xfd5ed1(0xba7)],Game_Troop['prototype'][_0xfd5ed1(0xba7)]=function(_0x2c239e){const _0x5eec11=_0xfd5ed1;$gameTemp[_0x5eec11(0x4a8)](),$gameTemp[_0x5eec11(0x204)](_0x2c239e),VisuMZ[_0x5eec11(0x1e9)][_0x5eec11(0x1ad)][_0x5eec11(0x740)](this,_0x2c239e);},VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0x829)]=Game_Troop['prototype'][_0xfd5ed1(0x5d5)],Game_Troop[_0xfd5ed1(0x263)]['expTotal']=function(){const _0x320070=_0xfd5ed1;let _0x58da60=VisuMZ[_0x320070(0x1e9)][_0x320070(0x829)]['call'](this);return this['expRate']&&(_0x58da60*=this[_0x320070(0x49b)]()),Math[_0x320070(0x562)](_0x58da60);},Game_Troop[_0xfd5ed1(0x263)][_0xfd5ed1(0x49b)]=function(){return 0x1;},VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0x44a)]=Game_Map[_0xfd5ed1(0x263)]['setupBattleback'],Game_Map[_0xfd5ed1(0x263)]['setupBattleback']=function(){const _0x55cbe8=_0xfd5ed1;VisuMZ[_0x55cbe8(0x1e9)][_0x55cbe8(0x44a)]['call'](this),this[_0x55cbe8(0xa26)]();},Game_Map[_0xfd5ed1(0x263)][_0xfd5ed1(0xa26)]=function(){const _0x7f83d6=_0xfd5ed1;this[_0x7f83d6(0x7c8)]={},this[_0x7f83d6(0xafd)]={};if(!$dataMap)return;const _0x37797e=$dataMap['note'];if(!_0x37797e)return;const _0xac694d=_0x37797e[_0x7f83d6(0x9e4)](/<REGION (\d+) BATTLEBACK(\d+): (.*)>/gi);if(_0xac694d)for(const _0x5d1b79 of _0xac694d){_0x5d1b79[_0x7f83d6(0x9e4)](/<REGION (\d+) BATTLEBACK(\d+): (.*)>/i);const _0x24dccf=Number(RegExp['$1']),_0x323c0c=Number(RegExp['$2']),_0x51000c=_0x323c0c===0x1?this[_0x7f83d6(0x7c8)]:this[_0x7f83d6(0xafd)],_0xa70f61=String(RegExp['$3']);_0x51000c[_0x24dccf]=_0xa70f61;}},VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0x2b4)]=Game_Map[_0xfd5ed1(0x263)]['battleback1Name'],Game_Map['prototype'][_0xfd5ed1(0x8f6)]=function(){const _0x32a3fa=_0xfd5ed1;if(!BattleManager[_0x32a3fa(0xae5)]()){const _0x3bf768=$gamePlayer[_0x32a3fa(0xb85)]($gamePlayer['x'],$gamePlayer['y']);if(this['_regionBattleback1']&&this[_0x32a3fa(0x7c8)][_0x3bf768]){if(_0x32a3fa(0x872)===_0x32a3fa(0x872))return this[_0x32a3fa(0x7c8)][_0x3bf768];else{if(!_0x1d0966[_0x32a3fa(0xb27)]())return;const _0x2c4d10=this[_0x32a3fa(0x456)]();if(!_0x2c4d10)return;if(_0x49b0ee===_0x2c4d10['_baseX'])return;let _0x24da74=![];if(this['isActor']()){if(_0x3e6c49>_0x2c4d10[_0x32a3fa(0x6f7)])_0x24da74=!![];if(_0x1cdacf<_0x2c4d10['_baseX'])_0x24da74=![];}else{if(this[_0x32a3fa(0x73c)]()){if(_0x867658>_0x2c4d10[_0x32a3fa(0x6f7)])_0x24da74=![];if(_0x3925f9<_0x2c4d10[_0x32a3fa(0x6f7)])_0x24da74=!![];}};this[_0x32a3fa(0x41e)](_0x55b939?!_0x24da74:_0x24da74),_0x2c4d10['updateFlip']();}}}return VisuMZ[_0x32a3fa(0x1e9)][_0x32a3fa(0x2b4)]['call'](this);},VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0x7c9)]=Game_Map[_0xfd5ed1(0x263)][_0xfd5ed1(0x703)],Game_Map[_0xfd5ed1(0x263)]['battleback2Name']=function(){const _0x149026=_0xfd5ed1;if(!BattleManager['isBattleTest']()){const _0x244cfb=$gamePlayer['regionId']($gamePlayer['x'],$gamePlayer['y']);if(this[_0x149026(0x7c8)]&&this[_0x149026(0xafd)][_0x244cfb])return this['_regionBattleback2'][_0x244cfb];}return VisuMZ[_0x149026(0x1e9)][_0x149026(0x7c9)][_0x149026(0x740)](this);},VisuMZ[_0xfd5ed1(0x1e9)]['Game_Map_encounterList']=Game_Map[_0xfd5ed1(0x263)][_0xfd5ed1(0x84d)],Game_Map['prototype'][_0xfd5ed1(0x84d)]=function(){const _0x32eae3=_0xfd5ed1;let _0x4111b7=JsonEx[_0x32eae3(0x3dd)](VisuMZ[_0x32eae3(0x1e9)]['Game_Map_encounterList'][_0x32eae3(0x740)](this));return VisuMZ[_0x32eae3(0x1e9)][_0x32eae3(0x1b1)](_0x4111b7);},VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0x1b1)]=function(_0xfaba5f){const _0x3f37c8=_0xfd5ed1;var _0x1f8b09,_0x341e85,_0x236d8e;for(_0x236d8e=_0xfaba5f['length']-0x1;_0x236d8e>0x0;_0x236d8e--){_0x1f8b09=Math[_0x3f37c8(0x765)](Math[_0x3f37c8(0x59b)]()*(_0x236d8e+0x1)),_0x341e85=_0xfaba5f[_0x236d8e],_0xfaba5f[_0x236d8e]=_0xfaba5f[_0x1f8b09],_0xfaba5f[_0x1f8b09]=_0x341e85;}return _0xfaba5f;},VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0x60a)]=Game_Interpreter[_0xfd5ed1(0x263)][_0xfd5ed1(0xb92)],Game_Interpreter[_0xfd5ed1(0x263)][_0xfd5ed1(0xb92)]=function(_0x1594dd){const _0x6169e7=_0xfd5ed1;return $gameTemp[_0x6169e7(0x9bd)](this),VisuMZ[_0x6169e7(0x1e9)][_0x6169e7(0x60a)][_0x6169e7(0x740)](this,_0x1594dd);},VisuMZ[_0xfd5ed1(0x1e9)]['Game_Interpreter_updateWaitMode']=Game_Interpreter[_0xfd5ed1(0x263)][_0xfd5ed1(0xaa1)],Game_Interpreter['prototype'][_0xfd5ed1(0xaa1)]=function(){const _0xb3bbf2=_0xfd5ed1;if(SceneManager[_0xb3bbf2(0xbb7)]()){if(_0xb3bbf2(0x63b)!=='Syhla')switch(this['_waitMode']){case _0xb3bbf2(0x1b0):if(Imported[_0xb3bbf2(0x450)]){if($gameScreen[_0xb3bbf2(0xb69)]()['angleDuration']>0x0)return!![];this['_waitMode']='';}break;case _0xb3bbf2(0x1dc):if(BattleManager[_0xb3bbf2(0xb41)][_0xb3bbf2(0x83b)]())return!![];this[_0xb3bbf2(0x758)]='';break;case _0xb3bbf2(0x246):if(Imported[_0xb3bbf2(0x450)]){if(_0xb3bbf2(0xb5b)!=='jwtpK'){if($gameScreen[_0xb3bbf2(0xb69)]()[_0xb3bbf2(0x804)]>0x0)return!![];if($gameScreen[_0xb3bbf2(0xb69)]()[_0xb3bbf2(0x322)]>0x0)return!![];this[_0xb3bbf2(0x758)]='';}else this['refreshMotion']();}break;case _0xb3bbf2(0xb99):if(BattleManager[_0xb3bbf2(0xb41)][_0xb3bbf2(0xaf6)]())return!![];this[_0xb3bbf2(0x758)]='';break;case _0xb3bbf2(0x8a6):if(BattleManager[_0xb3bbf2(0xb41)][_0xb3bbf2(0xa09)]())return!![];this[_0xb3bbf2(0x758)]='';break;case _0xb3bbf2(0x777):if(BattleManager['_spriteset'][_0xb3bbf2(0x1c7)]())return!![];this['_waitMode']='';break;case _0xb3bbf2(0xb63):if(BattleManager[_0xb3bbf2(0x901)]['isBusy']())return!![];this[_0xb3bbf2(0x758)]='';break;case'battleMove':if(BattleManager['_spriteset'][_0xb3bbf2(0xa61)]())return!![];this[_0xb3bbf2(0x758)]='';break;case _0xb3bbf2(0x785):if(BattleManager[_0xb3bbf2(0xb41)][_0xb3bbf2(0x323)]())return!![];this['_waitMode']='';break;case _0xb3bbf2(0x6aa):if(BattleManager[_0xb3bbf2(0xb41)][_0xb3bbf2(0xbea)]())return!![];this[_0xb3bbf2(0x758)]='';break;case'battleSpriteSkew':if(BattleManager[_0xb3bbf2(0xb41)][_0xb3bbf2(0x8ee)]())return!![];this['_waitMode']='';break;case _0xb3bbf2(0x748):if(Imported['VisuMZ_3_ActSeqProjectiles']){if(_0xb3bbf2(0xaff)==='cUcHL')this['_currentAngle']=this[_0xb3bbf2(0x83e)](this[_0xb3bbf2(0x4be)],this[_0xb3bbf2(0x417)],_0x19740b,_0x5b6045,_0x265688);else{if(BattleManager[_0xb3bbf2(0xb41)][_0xb3bbf2(0x19d)]())return!![];this[_0xb3bbf2(0x758)]='';}}break;case'battleSkew':if(Imported[_0xb3bbf2(0x450)]){if(_0xb3bbf2(0x2aa)===_0xb3bbf2(0x411))_0xde5aa[_0xb3bbf2(0x561)](this[_0xb3bbf2(0x489)]['bind'](this,_0x16572e,_0x4aeee5,_0x405e7d,_0x6ab981));else{if($gameScreen[_0xb3bbf2(0xb69)]()[_0xb3bbf2(0x5b8)]>0x0)return!![];this[_0xb3bbf2(0x758)]='';}}break;case'battleSpin':if(BattleManager[_0xb3bbf2(0xb41)]['isAnyoneSpinning']())return!![];this['_waitMode']='';break;case _0xb3bbf2(0x931):if(Imported[_0xb3bbf2(0x450)]){if(_0xb3bbf2(0x1e1)===_0xb3bbf2(0x6ab))this[_0xb3bbf2(0x449)](),_0x263833[_0xb3bbf2(0x1e9)][_0xb3bbf2(0xb53)][_0xb3bbf2(0x740)](this),this[_0xb3bbf2(0x1fa)]();else{if($gameScreen[_0xb3bbf2(0xb69)]()[_0xb3bbf2(0x535)]>0x0)return!![];this[_0xb3bbf2(0x758)]='';}}break;}else this[_0xb3bbf2(0x41e)](![]);}return VisuMZ['BattleCore']['Game_Interpreter_updateWaitMode']['call'](this);},VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0xa73)]=Game_Interpreter['prototype']['command301'],Game_Interpreter[_0xfd5ed1(0x263)]['command301']=function(_0x297012){const _0x579342=_0xfd5ed1;if(!$gameParty[_0x579342(0x9f5)]())return _0x579342(0x6fe)===_0x579342(0x6fe)?this[_0x579342(0x6e2)](_0x297012):this[_0x579342(0xa8b)]()[_0x579342(0x9d6)](_0x29d4c8=>_0x29d4c8[_0x579342(0x445)]());else{if('XOLCf'!==_0x579342(0x6e4))return VisuMZ['BattleCore'][_0x579342(0xa73)][_0x579342(0x740)](this,_0x297012);else _0x6d90[_0x579342(0x1e9)][_0x579342(0x4f5)][_0x579342(0x740)](this,_0x241bc6),this['isEnemy']()&&_0x23c580===this[_0x579342(0x5f5)]()&&this[_0x579342(0x56e)]()&&(this['_visualHpGauge_JustDied']=![]),!this[_0x579342(0x613)]&&!this[_0x579342(0x407)]&&_0x39fcf9['isSceneBattle']()&&this['requestMotionRefresh']();}},Game_Interpreter['prototype'][_0xfd5ed1(0x6dd)]=function(_0x4d1a03){const _0xd1ea99=_0xfd5ed1;return VisuMZ[_0xd1ea99(0x1e9)]['Game_Interpreter_command301'][_0xd1ea99(0x740)](this,_0x4d1a03),BattleManager['setEventCallback'](_0x4108ae=>{const _0x45e3af=_0xd1ea99;if(_0x45e3af(0x1bc)!=='UtGJu')this[_0x45e3af(0x87c)][this[_0x45e3af(0x6ef)]]=_0x4108ae;else{if(_0x4610cc===_0x38e066[_0x45e3af(0x279)]())return![];}}),!![];},VisuMZ[_0xfd5ed1(0x1e9)]['CheckMapBattleEventValid']=function(_0x26d89a){const _0x89ae9=_0xfd5ed1,_0x7fc202=$dataCommonEvents[_0x26d89a];if(!_0x7fc202)return![];if(_0x7fc202[_0x89ae9(0x641)][_0x89ae9(0x5b7)]<=0x1)return![];return!![];},Game_Interpreter[_0xfd5ed1(0x263)][_0xfd5ed1(0x6e2)]=function(_0x35ecbd){const _0x3ad10c=_0xfd5ed1,_0x3ae406=VisuMZ[_0x3ad10c(0x1e9)]['Settings']['Mechanics'],_0x2272d6=_0x3ae406[_0x3ad10c(0x32d)],_0x4a823d=$dataCommonEvents[_0x2272d6];if(_0x4a823d&&VisuMZ[_0x3ad10c(0x1e9)][_0x3ad10c(0x509)](_0x2272d6)){const _0x43c98e=this[_0x3ad10c(0x794)]()?this[_0x3ad10c(0x870)]:0x0,_0x3eedd8=_0x4a823d[_0x3ad10c(0x641)];this[_0x3ad10c(0x763)](_0x3eedd8,_0x43c98e),this[_0x3ad10c(0x5fe)]=JsonEx[_0x3ad10c(0x3dd)](this['_list']);const _0x365742={'code':0xbc3,'indent':this[_0x3ad10c(0x6ef)],'parameters':JsonEx[_0x3ad10c(0x3dd)](_0x35ecbd)};return this['_list'][_0x3ad10c(0x289)](this[_0x3ad10c(0x1c4)]+0x1,0x0,_0x365742),!![];}else{if(_0x3ad10c(0x9be)==='fsewg')this['_effectsContainer']&&this[_0x3ad10c(0x3d8)](this['_effectsContainer']);else return VisuMZ['BattleCore'][_0x3ad10c(0xa73)][_0x3ad10c(0x740)](this,_0x35ecbd);}},VisuMZ['BattleCore']['BattleManager_onEncounter']=BattleManager[_0xfd5ed1(0xb5d)],BattleManager[_0xfd5ed1(0xb5d)]=function(){const _0x3afd9c=_0xfd5ed1;VisuMZ['BattleCore'][_0x3afd9c(0x2dc)][_0x3afd9c(0x740)](this),this[_0x3afd9c(0x890)]();},BattleManager[_0xfd5ed1(0x890)]=function(){const _0x7a4c6f=_0xfd5ed1,_0x23f2bf=VisuMZ[_0x7a4c6f(0x1e9)][_0x7a4c6f(0x607)][_0x7a4c6f(0x6d8)],_0x5347d9=_0x23f2bf['BattleStartEvent'];_0x5347d9&&VisuMZ[_0x7a4c6f(0x1e9)][_0x7a4c6f(0x509)](_0x5347d9)&&(this['_battleCoreBattleStartEvent']=!![],$gameTemp[_0x7a4c6f(0x601)](_0x23f2bf[_0x7a4c6f(0x32d)]),$gameMap[_0x7a4c6f(0x834)](),$gameMap[_0x7a4c6f(0x485)][_0x7a4c6f(0xa9f)]=!![]);if(_0x23f2bf['DefeatEvent']>0x0){if(_0x7a4c6f(0x247)===_0x7a4c6f(0x247))this['_canLose']=!![];else{const _0x56150e=_0x7a4c6f(0x3de)['format'](_0x4d1beb);_0x253ec7[_0x7a4c6f(0x1e9)]['JS'][_0x1b28da]=new _0x3fa395(_0x56150e);}}},VisuMZ['BattleCore']['Scene_Map_updateCallMenu']=Scene_Map[_0xfd5ed1(0x263)][_0xfd5ed1(0x2b8)],Scene_Map[_0xfd5ed1(0x263)][_0xfd5ed1(0x2b8)]=function(){const _0x393502=_0xfd5ed1;if(BattleManager[_0x393502(0x699)])return;VisuMZ[_0x393502(0x1e9)][_0x393502(0x722)][_0x393502(0x740)](this);},VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0x571)]=Scene_Map[_0xfd5ed1(0x263)][_0xfd5ed1(0x717)],Scene_Map[_0xfd5ed1(0x263)][_0xfd5ed1(0x717)]=function(){const _0x3594d6=_0xfd5ed1;if(BattleManager['_battleCoreBattleStartEvent']){if('ABWYC'!==_0x3594d6(0x50d))this[_0x3594d6(0x8f2)]();else{_0x5c11c[_0x3594d6(0x263)][_0x3594d6(0x25d)][_0x3594d6(0x740)](this);if(this['_commandNameWindow'])this[_0x3594d6(0x6be)]();}}else VisuMZ['BattleCore'][_0x3594d6(0x571)][_0x3594d6(0x740)](this);},Scene_Map['prototype']['battleCorePreBattleCommonEvent']=function(){const _0x24a20c=_0xfd5ed1;this[_0x24a20c(0x5fc)]=!![];},VisuMZ['BattleCore'][_0xfd5ed1(0x6dc)]=SceneManager[_0xfd5ed1(0x339)],SceneManager[_0xfd5ed1(0x339)]=function(){const _0x49d010=_0xfd5ed1;if(BattleManager[_0x49d010(0x699)])return![];return VisuMZ['BattleCore']['SceneManager_isSceneChanging'][_0x49d010(0x740)](this);},VisuMZ[_0xfd5ed1(0x1e9)]['Game_Interpreter_terminate']=Game_Interpreter[_0xfd5ed1(0x263)][_0xfd5ed1(0xba5)],Game_Interpreter[_0xfd5ed1(0x263)]['terminate']=function(){const _0x10c815=_0xfd5ed1;VisuMZ['BattleCore'][_0x10c815(0xb6b)][_0x10c815(0x740)](this),this[_0x10c815(0xa9f)]&&(this[_0x10c815(0xa9f)]=undefined,SceneManager['_scene']['battleCoreResumeLaunchBattle']());},Scene_Map[_0xfd5ed1(0x263)][_0xfd5ed1(0x1ba)]=function(){const _0x84378=_0xfd5ed1;BattleManager[_0x84378(0x699)]=undefined,BattleManager[_0x84378(0xb62)]=!![],this[_0x84378(0x21d)]();},VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0x6e8)]=Scene_Map[_0xfd5ed1(0x263)][_0xfd5ed1(0xbe5)],Scene_Map[_0xfd5ed1(0x263)][_0xfd5ed1(0xbe5)]=function(){const _0x3428b4=_0xfd5ed1;VisuMZ[_0x3428b4(0x1e9)][_0x3428b4(0x6e8)]['call'](this);if(BattleManager[_0x3428b4(0xb62)]){if(_0x3428b4(0x2b3)===_0x3428b4(0x2b3))this[_0x3428b4(0x5fc)]=!![],BattleManager['_battleCoreBattleResumeAfter']=undefined;else{if(!_0x13ad5d[_0x3428b4(0xbb7)]())return;if(!_0x25abd0[_0x3428b4(0x450)])return;_0x22106d[_0x3428b4(0x1c5)](_0x2f1d45,_0x4de84c);const _0x584a90=_0x683542[_0x3428b4(0x58e)](),_0x1de67f=_0x2c8857[_0x3428b4(0x9f2)];if(!_0x584a90)return;_0xb647e6[_0x3428b4(0x6ca)](_0x556b3d[_0x3428b4(0x538)],_0x467ef8[_0x3428b4(0x86a)],_0x57c732['EasingType']);if(_0x1de67f)_0x584a90[_0x3428b4(0x7a6)](_0x3428b4(0x1b0));}}},VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0xbd2)]=Scene_Map['prototype'][_0xfd5ed1(0xbe5)],Scene_Map[_0xfd5ed1(0x263)][_0xfd5ed1(0xbe5)]=function(){const _0x85d5b1=_0xfd5ed1;VisuMZ[_0x85d5b1(0x1e9)][_0x85d5b1(0xbd2)][_0x85d5b1(0x740)](this),$gameTemp[_0x85d5b1(0x4a8)]();},VisuMZ['BattleCore'][_0xfd5ed1(0x370)]=Scene_ItemBase[_0xfd5ed1(0x263)][_0xfd5ed1(0x3e3)],Scene_ItemBase[_0xfd5ed1(0x263)]['applyItem']=function(){const _0x518122=_0xfd5ed1;VisuMZ[_0x518122(0x1e9)]['Scene_ItemBase_applyItem'][_0x518122(0x740)](this),this[_0x518122(0x3c7)]()[_0x518122(0x80f)][_0x518122(0x9e4)](/<CUSTOM ACTION SEQUENCE>/i)&&(_0x518122(0x67f)!==_0x518122(0x67f)?_0x1543fd[_0x518122(0x1e9)]['Scene_Battle_startPartyCommandSelection'][_0x518122(0x740)](this):$gameTemp[_0x518122(0x91a)]=[]),DataManager[_0x518122(0xb6c)](this['item']())&&(_0x518122(0xb96)!==_0x518122(0x5dd)?$gameTemp[_0x518122(0x91a)]=[]:_0x50f890[_0x518122(0x1e9)][_0x518122(0x607)][_0x518122(0xbdf)][_0x518122(0x533)]?_0x19fe3e['BattleCore']['Settings'][_0x518122(0xbdf)][_0x518122(0x533)][_0x518122(0x740)](this,_0x5f2dba):_0x548673[_0x518122(0x1e9)]['Sprite_Actor_setActorHome']['call'](this,_0x4c1601));},VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0x800)]=Scene_Options[_0xfd5ed1(0x263)][_0xfd5ed1(0x381)],Scene_Options[_0xfd5ed1(0x263)][_0xfd5ed1(0x381)]=function(){const _0x3c388a=_0xfd5ed1;let _0xa3a12d=VisuMZ[_0x3c388a(0x1e9)][_0x3c388a(0x800)][_0x3c388a(0x740)](this);const _0x4cdc8b=VisuMZ[_0x3c388a(0x1e9)][_0x3c388a(0x607)];if(_0x4cdc8b[_0x3c388a(0x2d9)][_0x3c388a(0x1f6)]&&_0x4cdc8b[_0x3c388a(0x2d9)]['AdjustRect'])_0xa3a12d+=0x2;if(_0x4cdc8b[_0x3c388a(0x2d2)][_0x3c388a(0x1f6)]&&_0x4cdc8b['HpGauge'][_0x3c388a(0x249)])_0xa3a12d+=0x1;return _0xa3a12d;},VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0x848)]=Scene_Battle[_0xfd5ed1(0x263)]['start'],Scene_Battle[_0xfd5ed1(0x263)][_0xfd5ed1(0xb66)]=function(){const _0x15bfdb=_0xfd5ed1;if(SceneManager[_0x15bfdb(0x957)]())Scene_Message[_0x15bfdb(0x263)][_0x15bfdb(0xb66)][_0x15bfdb(0x740)](this),this['_spriteset']&&(_0x15bfdb(0x9e6)==='pxVLz'?this[_0x15bfdb(0xb41)]['update']():(_0x19891d[_0x15bfdb(0x1e9)][_0x15bfdb(0x241)]['call'](this),this['_enemyWindow'][_0x15bfdb(0x461)](),this[_0x15bfdb(0x801)]())),BattleManager[_0x15bfdb(0xabe)]&&BattleManager[_0x15bfdb(0x1e0)]();else{if(_0x15bfdb(0xaca)!==_0x15bfdb(0x514))VisuMZ['BattleCore'][_0x15bfdb(0x848)]['call'](this);else{this[_0x15bfdb(0x456)]()[_0x15bfdb(0x999)](),this['clearFreezeMotion']();return;}}},VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0x29f)]=Scene_Battle['prototype'][_0xfd5ed1(0x21d)],Scene_Battle['prototype'][_0xfd5ed1(0x21d)]=function(){const _0x3335c1=_0xfd5ed1;if(SceneManager[_0x3335c1(0x916)]()){if('yKnKU'!==_0x3335c1(0x198)){const _0x19b1c2=this[_0x3335c1(0x3c7)]()['scope'];return _0x19b1c2[_0x3335c1(0x9e4)](/(?:RAND|RANDOM)/i);}else Scene_Message[_0x3335c1(0x263)][_0x3335c1(0x21d)][_0x3335c1(0x740)](this);}else VisuMZ[_0x3335c1(0x1e9)][_0x3335c1(0x29f)]['call'](this);},VisuMZ['BattleCore'][_0xfd5ed1(0x345)]=Scene_Battle[_0xfd5ed1(0x263)][_0xfd5ed1(0xba5)],Scene_Battle[_0xfd5ed1(0x263)][_0xfd5ed1(0xba5)]=function(){const _0x654153=_0xfd5ed1;SceneManager[_0x654153(0x916)]()?Scene_Message[_0x654153(0x263)][_0x654153(0xba5)]['call'](this):VisuMZ[_0x654153(0x1e9)][_0x654153(0x345)]['call'](this);},Scene_Battle[_0xfd5ed1(0x263)][_0xfd5ed1(0x66b)]=function(){const _0x31db81=_0xfd5ed1;if(ConfigManager['uiMenuStyle']&&ConfigManager['uiInputPosition']!==undefined)return ConfigManager[_0x31db81(0x34a)];else{if(this['battleLayoutStyle']()===_0x31db81(0x9cf))return![];else{if('WdhwZ'!=='WdhwZ')this[_0x31db81(0xbc9)]=new _0x3b429d(),this[_0x31db81(0xbe7)][_0x31db81(0x3d8)](this[_0x31db81(0xbc9)]);else{return Scene_Message[_0x31db81(0x263)][_0x31db81(0x66b)][_0x31db81(0x740)](this);;}}}},VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0xb53)]=Scene_Battle[_0xfd5ed1(0x263)][_0xfd5ed1(0x1e6)],Scene_Battle['prototype']['createAllWindows']=function(){const _0x4ea1c5=_0xfd5ed1;this[_0x4ea1c5(0x449)](),VisuMZ[_0x4ea1c5(0x1e9)]['Scene_Battle_createAllWindows'][_0x4ea1c5(0x740)](this),this[_0x4ea1c5(0x1fa)]();},VisuMZ['BattleCore']['Scene_Battle_createCancelButton']=Scene_Battle[_0xfd5ed1(0x263)][_0xfd5ed1(0x520)],Scene_Battle[_0xfd5ed1(0x263)][_0xfd5ed1(0x520)]=function(){const _0x3871b6=_0xfd5ed1;VisuMZ[_0x3871b6(0x1e9)]['Scene_Battle_createCancelButton'][_0x3871b6(0x740)](this),this[_0x3871b6(0xb2d)]()===_0x3871b6(0x9cf)&&this[_0x3871b6(0x823)]();},Scene_Battle['prototype'][_0xfd5ed1(0x76c)]=function(_0x26c65d){const _0x57ee5a=_0xfd5ed1;if(_0x26c65d)this['_windowLayer']['x']=(Graphics[_0x57ee5a(0xb4a)]-Graphics[_0x57ee5a(0x9c4)])/0x2,this[_0x57ee5a(0x62a)]['y']=(Graphics['height']-Graphics[_0x57ee5a(0xa52)])/0x2;else{if('agNbD'!==_0x57ee5a(0x52a))return _0x1f0397[_0x57ee5a(0x3c3)][_0x57ee5a(0x7df)]&&_0x2c0f2b[_0x57ee5a(0x3c3)][_0x57ee5a(0x7df)][_0x57ee5a(0x96f)]&&_0xb089a2['_scene'][_0x57ee5a(0x7df)][_0x57ee5a(0x4e2)][_0x57ee5a(0x4b6)](this[_0x57ee5a(0xbed)]);else this[_0x57ee5a(0x62a)]['x']=Graphics['width']*0xa,this[_0x57ee5a(0x62a)]['y']=Graphics[_0x57ee5a(0x8c6)]*0xa;}},VisuMZ['BattleCore'][_0xfd5ed1(0xb2a)]=Scene_Battle['prototype'][_0xfd5ed1(0x8b9)],Scene_Battle[_0xfd5ed1(0x263)][_0xfd5ed1(0x8b9)]=function(){const _0xc94d00=_0xfd5ed1,_0x337674=BattleManager[_0xc94d00(0x279)]();VisuMZ[_0xc94d00(0x1e9)][_0xc94d00(0xb2a)][_0xc94d00(0x740)](this);if(_0x337674){if(_0x337674===BattleManager[_0xc94d00(0x279)]())return;if(_0x337674===BattleManager['_subject'])return;if(_0x337674[_0xc94d00(0x456)]())_0x337674[_0xc94d00(0x456)]()['stepBack']();}},VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0x3f8)]=Scene_Battle[_0xfd5ed1(0x263)][_0xfd5ed1(0x194)],Scene_Battle[_0xfd5ed1(0x263)][_0xfd5ed1(0x194)]=function(){const _0x326c31=_0xfd5ed1,_0xc59125=BattleManager[_0x326c31(0x279)]();if(_0xc59125&&_0xc59125['battler'])_0xc59125[_0x326c31(0x456)]()[_0x326c31(0x3cc)]();VisuMZ['BattleCore'][_0x326c31(0x3f8)][_0x326c31(0x740)](this);},VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0xaa8)]=Scene_Battle[_0xfd5ed1(0x263)][_0xfd5ed1(0x7b4)],Scene_Battle[_0xfd5ed1(0x263)]['logWindowRect']=function(){const _0x3c7e56=_0xfd5ed1;if(VisuMZ[_0x3c7e56(0x1e9)][_0x3c7e56(0x607)]['BattleLog']['BattleLogRectJS']){if('UklyS'!==_0x3c7e56(0x324))return VisuMZ[_0x3c7e56(0x1e9)]['Settings'][_0x3c7e56(0xbe6)][_0x3c7e56(0x308)][_0x3c7e56(0x740)](this);else{_0x124c33=_0x82c4d6||0x1,_0x35b1b4--;const _0x4b1f5b=this[_0x3c7e56(0x4a9)](),_0x3e04bd=_0x4b1f5b[_0x246473]?_0x4b1f5b[_0x34bcab][_0x3c7e56(0x69f)]:0x0;return _0x1a1c80['attackMotions'][_0x3e04bd];}}return VisuMZ[_0x3c7e56(0x1e9)][_0x3c7e56(0xaa8)][_0x3c7e56(0x740)](this);},VisuMZ[_0xfd5ed1(0x1e9)]['Scene_Battle_createPartyCommandWindow']=Scene_Battle[_0xfd5ed1(0x263)]['createPartyCommandWindow'],Scene_Battle[_0xfd5ed1(0x263)][_0xfd5ed1(0xaeb)]=function(){const _0x19d250=_0xfd5ed1;VisuMZ['BattleCore'][_0x19d250(0x2fc)][_0x19d250(0x740)](this),this[_0x19d250(0x591)]();},Scene_Battle[_0xfd5ed1(0x263)][_0xfd5ed1(0x591)]=function(){const _0x1116c5=_0xfd5ed1,_0x162f17=this[_0x1116c5(0xb49)];_0x162f17[_0x1116c5(0x9ee)](_0x1116c5(0x251),this[_0x1116c5(0x4e1)]['bind'](this)),_0x162f17[_0x1116c5(0x9ee)](_0x1116c5(0x1a5),this['commandOptions'][_0x1116c5(0xa12)](this));const _0x5025b8=this['battleLayoutStyle']();switch(_0x5025b8){case'xp':case _0x1116c5(0x1fe):return this['_partyCommandWindow'][_0x1116c5(0x774)](0x1);break;}},Scene_Battle['prototype'][_0xfd5ed1(0x4e1)]=function(){const _0x751b74=_0xfd5ed1;BattleManager[_0x751b74(0x373)]=!![],$gameParty[_0x751b74(0x32c)](),this[_0x751b74(0x8b9)](),BattleManager['isTpb']()&&(BattleManager[_0x751b74(0xb75)]=![]);},Scene_Battle[_0xfd5ed1(0x263)]['commandOptions']=function(){const _0x8067bd=_0xfd5ed1;this[_0x8067bd(0x341)]()?_0x8067bd(0x573)!==_0x8067bd(0x573)?(_0x4241a6+=_0x58c736[_0x8067bd(0x75b)]()?-_0x4909a9:_0x3ea798,_0x4e38da+=_0x51646f['isActor']()?-_0x404965:_0x5220c0):(this[_0x8067bd(0x3f9)]=!![],this[_0x8067bd(0x901)]['push'](_0x8067bd(0x1e4),VisuMZ[_0x8067bd(0x1e9)][_0x8067bd(0x607)]['PartyCmd'][_0x8067bd(0x39c)])):this[_0x8067bd(0x73f)]();},Scene_Battle[_0xfd5ed1(0x263)][_0xfd5ed1(0x341)]=function(){const _0xfaeb3c=_0xfd5ed1;return BattleManager[_0xfaeb3c(0x415)]();},Scene_Battle[_0xfd5ed1(0x263)][_0xfd5ed1(0x73f)]=function(){const _0x40fcf2=_0xfd5ed1;this[_0x40fcf2(0x3f9)]=![],this['_spriteset']['update'](),this[_0x40fcf2(0x62a)][_0x40fcf2(0x41b)]=![];if(BattleManager['isBattleTest']())_0x40fcf2(0x826)===_0x40fcf2(0x826)?($dataSystem[_0x40fcf2(0x8f6)]||$dataSystem['battleback2Name'])&&SceneManager[_0x40fcf2(0x55a)]():(this[_0x40fcf2(0x917)][_0x40fcf2(0x4b2)]=_0x2b59f1[_0x40fcf2(0x67d)](),this[_0x40fcf2(0x917)]['power']=_0x2bbd1c[_0x40fcf2(0x8fb)]());else{if($gameMap[_0x40fcf2(0x8f6)]()||$gameMap['battleback2Name']()){if(_0x40fcf2(0x2a3)===_0x40fcf2(0x260)){if(_0x48b419[_0x40fcf2(0x959)](_0x5fd668))return!![];return![];}else SceneManager[_0x40fcf2(0x55a)]();}}SceneManager[_0x40fcf2(0xbc8)](Scene_Options),BattleManager[_0x40fcf2(0x47b)]()&&(BattleManager['_tpbSceneChangeCacheActor']=BattleManager[_0x40fcf2(0x279)]());},VisuMZ['BattleCore'][_0xfd5ed1(0x384)]=Scene_Battle[_0xfd5ed1(0x263)][_0xfd5ed1(0x7be)],Scene_Battle[_0xfd5ed1(0x263)][_0xfd5ed1(0x7be)]=function(){const _0x50e220=_0xfd5ed1;VisuMZ[_0x50e220(0x1e9)]['Scene_Battle_updateBattleProcess'][_0x50e220(0x740)](this);if(this['_callSceneOptions']&&!BattleManager[_0x50e220(0xb9a)])this[_0x50e220(0x73f)]();},Scene_Battle[_0xfd5ed1(0x263)]['createAutoBattleWindow']=function(){const _0x2adea1=_0xfd5ed1,_0x1a9e5f=this[_0x2adea1(0x23e)]();this[_0x2adea1(0x51e)]=new Window_AutoBattleCancel(_0x1a9e5f),this['_autoBattleWindow'][_0x2adea1(0x213)](),this['addChild'](this[_0x2adea1(0x51e)]);},Scene_Battle[_0xfd5ed1(0x263)][_0xfd5ed1(0x23e)]=function(){const _0x29ed77=_0xfd5ed1;return VisuMZ[_0x29ed77(0x1e9)][_0x29ed77(0x607)][_0x29ed77(0x2d9)][_0x29ed77(0xaf0)][_0x29ed77(0x740)](this);},Scene_Battle[_0xfd5ed1(0x263)]['isPartyCommandWindowDisabled']=function(){const _0x483173=_0xfd5ed1;return VisuMZ[_0x483173(0x1e9)][_0x483173(0x607)][_0x483173(0x56b)][_0x483173(0x261)];},VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0x75a)]=Scene_Battle['prototype']['startPartyCommandSelection'],Scene_Battle['prototype']['startPartyCommandSelection']=function(){const _0x31aeff=_0xfd5ed1;this['isPartyCommandWindowDisabled']()?this['onDisabledPartyCommandSelection']():VisuMZ[_0x31aeff(0x1e9)][_0x31aeff(0x75a)]['call'](this);},Scene_Battle[_0xfd5ed1(0x263)][_0xfd5ed1(0x64e)]=function(){const _0x2eda4d=_0xfd5ed1;if(BattleManager[_0x2eda4d(0x6d1)]()){if(_0x2eda4d(0x597)===_0x2eda4d(0x2d7))return _0x2402f9[_0x2eda4d(0x1e9)]['Settings']['Enemy']['NameAlwaysVisible'];else this[_0x2eda4d(0x8b9)]();}else BattleManager['isTpb']()&&VisuMZ[_0x2eda4d(0x1e9)][_0x2eda4d(0x75a)][_0x2eda4d(0x740)](this);},VisuMZ['BattleCore']['Scene_Battle_commandFight']=Scene_Battle[_0xfd5ed1(0x263)]['commandFight'],Scene_Battle[_0xfd5ed1(0x263)][_0xfd5ed1(0xad9)]=function(){const _0x4bc734=_0xfd5ed1;BattleManager[_0x4bc734(0x47b)]()?(this[_0x4bc734(0x62c)](),this['startActorCommandSelection']()):_0x4bc734(0xb35)===_0x4bc734(0x68c)?_0x4243ff=_0x520a32[_0x4bc734(0x504)](_0x43e1b8['ConvertActionSequenceTarget'](_0x26fde9)):VisuMZ[_0x4bc734(0x1e9)]['Scene_Battle_commandFight']['call'](this);},Scene_Battle[_0xfd5ed1(0x263)][_0xfd5ed1(0x62c)]=function(){const _0x4decba=_0xfd5ed1;if(!VisuMZ[_0x4decba(0x1e9)][_0x4decba(0x7c0)])return;if(Imported[_0x4decba(0x50a)]&&BattleManager[_0x4decba(0x42b)]())return;const _0x235097=$gameParty[_0x4decba(0x6cc)]()[_0x4decba(0x4af)](_0x250d8f=>_0x250d8f['isTpbCharged']()&&_0x250d8f[_0x4decba(0x3e0)]());BattleManager['_currentActor']=_0x235097[0x0]||null,BattleManager[_0x4decba(0x82e)]&&BattleManager[_0x4decba(0x82e)][_0x4decba(0x3af)](_0x4decba(0x522));},VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0x50b)]=Scene_Battle[_0xfd5ed1(0x263)][_0xfd5ed1(0x5ac)],Scene_Battle[_0xfd5ed1(0x263)][_0xfd5ed1(0x5ac)]=function(){const _0x37aa79=_0xfd5ed1;VisuMZ[_0x37aa79(0x1e9)][_0x37aa79(0x50b)]['call'](this),this[_0x37aa79(0x76a)]();},Scene_Battle['prototype'][_0xfd5ed1(0x76a)]=function(){const _0x2b0a4f=_0xfd5ed1,_0x521bd9=this[_0x2b0a4f(0xb26)];_0x521bd9[_0x2b0a4f(0x9ee)](_0x2b0a4f(0x877),this[_0x2b0a4f(0x458)]['bind'](this)),_0x521bd9[_0x2b0a4f(0x9ee)](_0x2b0a4f(0x251),this[_0x2b0a4f(0xa0b)][_0x2b0a4f(0xa12)](this)),_0x521bd9['setHandler'](_0x2b0a4f(0x9e3),this['actorCommandSingleSkill'][_0x2b0a4f(0xa12)](this)),BattleManager[_0x2b0a4f(0x47b)]()&&(this[_0x2b0a4f(0x408)]()?'VHrPD'==='VHrPD'?delete _0x521bd9[_0x2b0a4f(0x713)][_0x2b0a4f(0xb47)]:_0x4c9572['setHandler'](_0x2b0a4f(0xb47),this[_0x2b0a4f(0x84b)][_0x2b0a4f(0xa12)](this)):_0x521bd9[_0x2b0a4f(0x9ee)]('cancel',this[_0x2b0a4f(0x84b)][_0x2b0a4f(0xa12)](this)));},Scene_Battle['prototype']['actorCommandEscape']=function(){const _0x36e2c6=_0xfd5ed1;this[_0x36e2c6(0x67a)]();},Scene_Battle['prototype'][_0xfd5ed1(0xa0b)]=function(){const _0x22797e=_0xfd5ed1;BattleManager[_0x22797e(0x279)]()[_0x22797e(0x47a)](),BattleManager[_0x22797e(0x92c)](),BattleManager[_0x22797e(0x353)](),this['changeInputWindow']();},Scene_Battle['prototype'][_0xfd5ed1(0x480)]=function(){const _0x610c9d=_0xfd5ed1,_0x4ea5ae=BattleManager[_0x610c9d(0x623)]();_0x4ea5ae[_0x610c9d(0x655)](this[_0x610c9d(0xb26)][_0x610c9d(0x6d6)]()),this[_0x610c9d(0x61e)]();},Scene_Battle[_0xfd5ed1(0x263)][_0xfd5ed1(0x84b)]=function(){const _0x3529ad=_0xfd5ed1;if(this[_0x3529ad(0x57b)]())_0x3529ad(0x56f)!=='KuvNB'?this[_0x3529ad(0x729)]():(this[_0x3529ad(0xbc8)](_0x3529ad(0x215)),this['push'](_0x3529ad(0x448)),this[_0x3529ad(0xbc8)]('pushBaseLine'),this[_0x3529ad(0xbc8)](_0x3529ad(0x1e4),_0x255bf6[_0x3529ad(0x222)](_0x3d6f14[_0x3529ad(0x452)]())),this[_0x3529ad(0xbc8)](_0x3529ad(0x3f7)));else{if(_0x3529ad(0x76f)!==_0x3529ad(0xab7))this[_0x3529ad(0x9e7)]();else{if(!_0x2caee9[_0x3529ad(0xb27)]())return;if(this['_flinched'])return;this['_flinched']=!![];const _0xb1df2f=this[_0x3529ad(0x456)]();if(_0xb1df2f)_0xb1df2f[_0x3529ad(0xb4d)]();}}},VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0x7c0)]=![],Scene_Battle[_0xfd5ed1(0x263)][_0xfd5ed1(0x57b)]=function(){const _0x42b9e5=_0xfd5ed1;if(Imported['VisuMZ_2_BattleSystemCTB']&&BattleManager[_0x42b9e5(0x42b)]()){if('TAWqe'!==_0x42b9e5(0x6e6))return![];else _0x2df2fe[_0x42b9e5(0x9a7)](),_0x4acee2[_0x42b9e5(0x884)](_0x4a11f0['deathStateId']());}else{if(_0x42b9e5(0xb86)===_0x42b9e5(0xb86)){if(!VisuMZ[_0x42b9e5(0x1e9)][_0x42b9e5(0x7c0)])return![];const _0x36ef9c=$gameParty['aliveMembers']()['filter'](_0x50f13b=>_0x50f13b[_0x42b9e5(0x329)]()&&_0x50f13b[_0x42b9e5(0x3e0)]());return _0x36ef9c[_0x42b9e5(0x5b7)]>0x0&&BattleManager['actor']()!==_0x36ef9c[_0x36ef9c[_0x42b9e5(0x5b7)]-0x1];}else this[_0x42b9e5(0xbe5)](...arguments);}},Scene_Battle['prototype'][_0xfd5ed1(0x729)]=function(){const _0x5bbeca=_0xfd5ed1,_0x1ce808=BattleManager[_0x5bbeca(0x279)](),_0x223789=_0x1ce808['battler']();if(_0x223789)_0x223789[_0x5bbeca(0x3cc)]();const _0x4778a4=$gameParty['aliveMembers']()['filter'](_0x4a89a3=>_0x4a89a3[_0x5bbeca(0x329)]()&&_0x4a89a3[_0x5bbeca(0x3e0)]()),_0xba69fa=_0x4778a4[_0x5bbeca(0x981)](_0x1ce808),_0x1aeed4=_0x4778a4[_0xba69fa+0x1];BattleManager[_0x5bbeca(0x82e)]=_0x1aeed4||null;if(_0x1aeed4)_0x1aeed4[_0x5bbeca(0x3af)](_0x5bbeca(0x522));_0x1ce808['setActionState'](_0x5bbeca(0x9d4)),this['changeInputWindow']();},Scene_Battle[_0xfd5ed1(0x263)][_0xfd5ed1(0x9e7)]=function(){const _0x3243f0=_0xfd5ed1;this[_0x3243f0(0xb49)][_0x3243f0(0xba7)](),this[_0x3243f0(0xb26)][_0x3243f0(0x464)]();if(!VisuMZ[_0x3243f0(0x1e9)]['TpbActiveChangeEnabled'])return;if(Imported[_0x3243f0(0x50a)]&&BattleManager[_0x3243f0(0x42b)]())return;if(BattleManager[_0x3243f0(0x82e)]){BattleManager['_currentActor'][_0x3243f0(0x3af)](_0x3243f0(0x9d4));const _0x3e4669=BattleManager[_0x3243f0(0x82e)][_0x3243f0(0x456)]();if(_0x3e4669)_0x3e4669[_0x3243f0(0x3cc)]();}BattleManager[_0x3243f0(0x82e)]=null;},VisuMZ['BattleCore'][_0xfd5ed1(0x26e)]=Scene_Battle[_0xfd5ed1(0x263)][_0xfd5ed1(0x820)],Scene_Battle[_0xfd5ed1(0x263)][_0xfd5ed1(0x820)]=function(){const _0x418087=_0xfd5ed1;VisuMZ[_0x418087(0x1e9)][_0x418087(0x26e)][_0x418087(0x740)](this),this[_0x418087(0xa77)]();},Scene_Battle['prototype'][_0xfd5ed1(0xa77)]=function(){const _0x4ae780=_0xfd5ed1;this[_0x4ae780(0xb26)][_0x4ae780(0x5ba)](this[_0x4ae780(0x70a)]),this['_partyCommandWindow'][_0x4ae780(0x5ba)](this[_0x4ae780(0x70a)]);},Scene_Battle[_0xfd5ed1(0x263)][_0xfd5ed1(0xb2d)]=function(){const _0x236cfa=_0xfd5ed1;if($gameTemp[_0x236cfa(0x952)]!==undefined){if(_0x236cfa(0x640)!==_0x236cfa(0x6ad))return $gameTemp[_0x236cfa(0x952)];else{if(_0x514a79['BattleCore'][_0x236cfa(0x607)]['ActionSequence']['ReflectPlayback']){const _0x5f46a1=_0x5d1a8b[_0x236cfa(0x3c7)]();this[_0x236cfa(0xbc8)]('showAnimation',_0x498dd9,[_0x3e4103],_0x5f46a1[_0x236cfa(0x82b)]);}}}if(this[_0x236cfa(0x534)])return this[_0x236cfa(0x534)];this[_0x236cfa(0x534)]=VisuMZ[_0x236cfa(0x1e9)][_0x236cfa(0x607)][_0x236cfa(0x9bf)]['Style'][_0x236cfa(0x572)]()['trim']();if(this[_0x236cfa(0x534)]===_0x236cfa(0x643)&&!Imported[_0x236cfa(0x6fd)]){if(_0x236cfa(0xbb0)===_0x236cfa(0xbb0))this[_0x236cfa(0x534)]=_0x236cfa(0x702);else{_0x3a6c80=_0x1722a1[_0x236cfa(0x1e9)][_0x236cfa(0x33b)]['call'](this);const _0x274d74=_0x247e13['BattleCore'][_0x236cfa(0xadb)](this[_0x236cfa(0x3c7)](),_0x236cfa(0x7e3));return _0x25cdd4=_0x432efd[_0x236cfa(0x1e9)]['JS'][_0x274d74][_0x236cfa(0x740)](this,this[_0x236cfa(0x2f2)](),_0x241db4),this['repeatTargets'](_0x1854f8);}}return this[_0x236cfa(0x534)];},VisuMZ[_0xfd5ed1(0x1e9)]['Scene_Battle_windowAreaHeight']=Scene_Battle[_0xfd5ed1(0x263)][_0xfd5ed1(0x477)],Scene_Battle[_0xfd5ed1(0x263)][_0xfd5ed1(0x477)]=function(){const _0x2c5b7c=_0xfd5ed1,_0x2e89da=this['battleLayoutStyle']();switch(_0x2e89da){case _0x2c5b7c(0x641):return this['calcWindowHeight'](Math[_0x2c5b7c(0x4d3)](0x1,$gameParty[_0x2c5b7c(0x3b6)]()),!![]);break;default:return VisuMZ[_0x2c5b7c(0x1e9)][_0x2c5b7c(0x8bf)][_0x2c5b7c(0x740)](this);break;}},VisuMZ['BattleCore'][_0xfd5ed1(0xb93)]=Scene_Battle[_0xfd5ed1(0x263)][_0xfd5ed1(0x2f1)],Scene_Battle[_0xfd5ed1(0x263)][_0xfd5ed1(0x2f1)]=function(){const _0x462bf4=_0xfd5ed1,_0x3f3347=this[_0x462bf4(0xb2d)]();switch(_0x3f3347){case _0x462bf4(0x9cf):return this[_0x462bf4(0x8ca)]();break;case _0x462bf4(0x702):case _0x462bf4(0x641):case'xp':case'portrait':default:return VisuMZ['BattleCore'][_0x462bf4(0xb93)]['call'](this);break;}},Scene_Battle['prototype'][_0xfd5ed1(0x325)]=function(){const _0x3d2f3e=_0xfd5ed1,_0x5ea5b3=this[_0x3d2f3e(0xb2d)]();switch(_0x5ea5b3){case'xp':case _0x3d2f3e(0x1fe):return this[_0x3d2f3e(0x3d5)]();break;case _0x3d2f3e(0x9cf):return this[_0x3d2f3e(0x459)]();break;case _0x3d2f3e(0x702):case _0x3d2f3e(0x641):default:return this[_0x3d2f3e(0x5f7)]();break;}},VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0x995)]=Scene_Battle[_0xfd5ed1(0x263)][_0xfd5ed1(0x529)],Scene_Battle[_0xfd5ed1(0x263)][_0xfd5ed1(0x529)]=function(){const _0x2e9a0a=_0xfd5ed1,_0x3d182a=this[_0x2e9a0a(0xb2d)]();switch(_0x3d182a){case'xp':case _0x2e9a0a(0x1fe):return this[_0x2e9a0a(0x739)]();break;case _0x2e9a0a(0x9cf):return this[_0x2e9a0a(0x9c8)]();case'default':case _0x2e9a0a(0x641):default:return this[_0x2e9a0a(0x66f)]();break;}},Scene_Battle[_0xfd5ed1(0x263)]['partyCommandWindowRectDefaultStyle']=function(){const _0xd8b38b=_0xfd5ed1,_0x5bc588=VisuMZ[_0xd8b38b(0x1e9)][_0xd8b38b(0x607)][_0xd8b38b(0x9bf)],_0xc1e82a=_0x5bc588[_0xd8b38b(0x817)]||0xc0,_0x4b5943=this[_0xd8b38b(0x477)](),_0x335b28=this[_0xd8b38b(0x66b)]()?Graphics[_0xd8b38b(0x9c4)]-_0xc1e82a:0x0,_0x487d0a=Graphics[_0xd8b38b(0xa52)]-_0x4b5943;return new Rectangle(_0x335b28,_0x487d0a,_0xc1e82a,_0x4b5943);},Scene_Battle[_0xfd5ed1(0x263)][_0xfd5ed1(0x653)]=function(){const _0x142aff=_0xfd5ed1;return this[_0x142aff(0x529)]();},VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0x951)]=Scene_Battle[_0xfd5ed1(0x263)][_0xfd5ed1(0x7e2)],Scene_Battle[_0xfd5ed1(0x263)][_0xfd5ed1(0x7e2)]=function(){const _0x48cf53=_0xfd5ed1,_0x3f7e47=this['battleLayoutStyle']();switch(_0x3f7e47){case'xp':case _0x48cf53(0x1fe):case _0x48cf53(0x9cf):break;case _0x48cf53(0x702):case'list':default:VisuMZ[_0x48cf53(0x1e9)]['Scene_Battle_updateStatusWindowPosition'][_0x48cf53(0x740)](this);break;}},VisuMZ['BattleCore'][_0xfd5ed1(0x923)]=Scene_Battle[_0xfd5ed1(0x263)][_0xfd5ed1(0x5ef)],Scene_Battle['prototype']['startActorSelection']=function(){const _0x32e7f0=_0xfd5ed1;VisuMZ[_0x32e7f0(0x1e9)][_0x32e7f0(0x923)][_0x32e7f0(0x740)](this),this[_0x32e7f0(0x801)]();},VisuMZ[_0xfd5ed1(0x1e9)]['Scene_Battle_startEnemySelection']=Scene_Battle['prototype'][_0xfd5ed1(0x93d)],Scene_Battle[_0xfd5ed1(0x263)][_0xfd5ed1(0x93d)]=function(){const _0x265c2b=_0xfd5ed1;VisuMZ[_0x265c2b(0x1e9)][_0x265c2b(0x241)][_0x265c2b(0x740)](this),this[_0x265c2b(0x7df)]['autoSelect'](),this['makeTargetSelectionMoreVisible']();},Scene_Battle[_0xfd5ed1(0x263)][_0xfd5ed1(0x801)]=function(){const _0xbcba02=_0xfd5ed1,_0x41299b=this[_0xbcba02(0xb2d)]();['xp',_0xbcba02(0x1fe),'border']['includes'](_0x41299b)&&this[_0xbcba02(0xb26)][_0xbcba02(0x464)](),(_0x41299b==='border'||this['isSkillItemWindowsMiddle']())&&(this[_0xbcba02(0x4b1)]['close'](),this['_itemWindow'][_0xbcba02(0x464)]());},VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0x1e7)]=Scene_Battle[_0xfd5ed1(0x263)][_0xfd5ed1(0xb6d)],Scene_Battle['prototype'][_0xfd5ed1(0xb6d)]=function(){const _0x2c29e7=_0xfd5ed1;VisuMZ['BattleCore'][_0x2c29e7(0x1e7)]['call'](this),this[_0x2c29e7(0xa29)]();},Scene_Battle['prototype'][_0xfd5ed1(0x7eb)]=function(){const _0x172657=_0xfd5ed1;return[_0x172657(0x8c1),_0x172657(0xa24),'singleSkill'][_0x172657(0x4b6)](this[_0x172657(0xb26)][_0x172657(0x963)]());},VisuMZ[_0xfd5ed1(0x1e9)]['Scene_Battle_onActorCancel']=Scene_Battle[_0xfd5ed1(0x263)][_0xfd5ed1(0xad6)],Scene_Battle[_0xfd5ed1(0x263)]['onActorCancel']=function(){const _0x20c2c5=_0xfd5ed1;this['isNonSubmenuCancel']()?(this[_0x20c2c5(0x6f2)][_0x20c2c5(0x676)](),this['_actorWindow'][_0x20c2c5(0x213)](),this[_0x20c2c5(0xb26)][_0x20c2c5(0x53b)]()):VisuMZ[_0x20c2c5(0x1e9)][_0x20c2c5(0x398)][_0x20c2c5(0x740)](this),this[_0x20c2c5(0x984)]();},VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0x697)]=Scene_Battle[_0xfd5ed1(0x263)][_0xfd5ed1(0x895)],Scene_Battle[_0xfd5ed1(0x263)][_0xfd5ed1(0x895)]=function(){const _0x28b4f=_0xfd5ed1;VisuMZ[_0x28b4f(0x1e9)][_0x28b4f(0x697)][_0x28b4f(0x740)](this),this[_0x28b4f(0xa29)]();},VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0x3f1)]=Scene_Battle[_0xfd5ed1(0x263)]['onEnemyCancel'],Scene_Battle[_0xfd5ed1(0x263)][_0xfd5ed1(0x749)]=function(){const _0x5c06bc=_0xfd5ed1;this[_0x5c06bc(0x7eb)]()?(this[_0x5c06bc(0x6f2)][_0x5c06bc(0x676)](),this[_0x5c06bc(0x7df)][_0x5c06bc(0x213)](),this['_actorCommandWindow'][_0x5c06bc(0x53b)]()):VisuMZ[_0x5c06bc(0x1e9)]['Scene_Battle_onEnemyCancel'][_0x5c06bc(0x740)](this),this[_0x5c06bc(0x984)]();},Scene_Battle['prototype'][_0xfd5ed1(0xa29)]=function(){const _0x1324bc=_0xfd5ed1,_0x50dc12=this[_0x1324bc(0xb2d)]();(_0x50dc12===_0x1324bc(0x9cf)||this['isSkillItemWindowsMiddle']())&&(this[_0x1324bc(0x4b1)][_0x1324bc(0xbd4)](),this[_0x1324bc(0x4b1)][_0x1324bc(0x96f)]&&this[_0x1324bc(0x4b1)][_0x1324bc(0x676)](),this[_0x1324bc(0x2ab)][_0x1324bc(0xbd4)](),this[_0x1324bc(0x2ab)]['active']&&this[_0x1324bc(0x2ab)]['show']());},Scene_Battle[_0xfd5ed1(0x263)][_0xfd5ed1(0x984)]=function(){const _0x2d953d=_0xfd5ed1,_0x470032=this[_0x2d953d(0xb2d)]();['xp',_0x2d953d(0x1fe),_0x2d953d(0x9cf)]['includes'](_0x470032)&&this[_0x2d953d(0xb26)][_0x2d953d(0xbd4)](),this[_0x2d953d(0xa29)]();},Scene_Battle[_0xfd5ed1(0x263)][_0xfd5ed1(0x5f7)]=function(){const _0x212f59=_0xfd5ed1,_0x893d91=VisuMZ['BattleCore'][_0x212f59(0x607)][_0x212f59(0x9bf)],_0x1ac561=Window_BattleStatus[_0x212f59(0x263)][_0x212f59(0x5db)](),_0xa9ec95=Graphics[_0x212f59(0x9c4)]-(_0x893d91['CommandWidth']||0xc0),_0x53e516=this[_0x212f59(0x477)]()+_0x1ac561,_0x553fb8=this[_0x212f59(0x66b)]()?0x0:Graphics[_0x212f59(0x9c4)]-_0xa9ec95,_0x376c5d=Graphics['boxHeight']-_0x53e516+_0x1ac561;return new Rectangle(_0x553fb8,_0x376c5d,_0xa9ec95,_0x53e516);},Scene_Battle[_0xfd5ed1(0x263)][_0xfd5ed1(0x3d5)]=function(){const _0x230cb7=_0xfd5ed1,_0x3089fe=Window_BattleStatus[_0x230cb7(0x263)]['extraHeight'](),_0x7847ad=Graphics[_0x230cb7(0x9c4)],_0x465cf1=this[_0x230cb7(0x477)]()+_0x3089fe,_0x4df4fb=0x0,_0x36ff50=Graphics[_0x230cb7(0xa52)]-_0x465cf1+_0x3089fe;return new Rectangle(_0x4df4fb,_0x36ff50,_0x7847ad,_0x465cf1);},Scene_Battle[_0xfd5ed1(0x263)][_0xfd5ed1(0x739)]=function(){const _0x4d478b=_0xfd5ed1,_0x59a0ef=Graphics[_0x4d478b(0x9c4)]/0x2,_0x14eb9a=this[_0x4d478b(0x988)](VisuMZ[_0x4d478b(0x1e9)][_0x4d478b(0x607)][_0x4d478b(0x9bf)][_0x4d478b(0x7e0)],!![]),_0x26e2f1=Math[_0x4d478b(0x271)]((Graphics[_0x4d478b(0x9c4)]-_0x59a0ef)/0x2),_0x34267c=Graphics[_0x4d478b(0xa52)]-_0x14eb9a-this[_0x4d478b(0x3d5)]()[_0x4d478b(0x8c6)];return new Rectangle(_0x26e2f1,_0x34267c,_0x59a0ef,_0x14eb9a);},Scene_Battle[_0xfd5ed1(0x263)][_0xfd5ed1(0x8ca)]=function(){const _0x233488=_0xfd5ed1,_0x449e85=Graphics[_0x233488(0xb4a)],_0x3f0644=Math[_0x233488(0x271)]((Graphics[_0x233488(0x9c4)]-_0x449e85)/0x2),_0x3edea8=this[_0x233488(0x8f0)](),_0x4b640d=(Graphics[_0x233488(0x8c6)]-Graphics[_0x233488(0xa52)])/-0x2;return new Rectangle(_0x3f0644,_0x4b640d,_0x449e85,_0x3edea8);},Scene_Battle['prototype']['statusWindowRectBorderStyle']=function(){const _0x5c08b2=_0xfd5ed1,_0x3f2278=Graphics[_0x5c08b2(0xb4a)],_0x4940ec=Math['round']((Graphics[_0x5c08b2(0x9c4)]-_0x3f2278)/0x2),_0x7c3887=this['calcWindowHeight'](0x4,!![]),_0x5bee24=Graphics['boxHeight']-_0x7c3887+(Graphics['height']-Graphics['boxHeight'])/0x2;return new Rectangle(_0x4940ec,_0x5bee24,_0x3f2278,_0x7c3887);},Scene_Battle[_0xfd5ed1(0x263)]['partyCommandWindowRectBorderStyle']=function(){const _0x2fcd8=_0xfd5ed1,_0xc2886c=Math[_0x2fcd8(0x765)](Graphics[_0x2fcd8(0xb4a)]/0x3),_0x2b6a42=this[_0x2fcd8(0x66b)]()?(Graphics['width']+Graphics[_0x2fcd8(0x9c4)])/0x2-_0xc2886c:(Graphics[_0x2fcd8(0xb4a)]-Graphics['boxWidth'])/-0x2,_0x47f055=this[_0x2fcd8(0x8ca)](),_0x2f0fd4=_0x47f055['y']+_0x47f055[_0x2fcd8(0x8c6)],_0x30836c=this[_0x2fcd8(0x459)](),_0x2be636=_0x30836c['y']-_0x2f0fd4;return new Rectangle(_0x2b6a42,_0x2f0fd4,_0xc2886c,_0x2be636);},Scene_Battle[_0xfd5ed1(0x263)]['skillItemWindowRectBorderStyle']=function(){const _0x3ecd31=_0xfd5ed1,_0x5bcc13=Math[_0x3ecd31(0x562)](Graphics[_0x3ecd31(0xb4a)]/0x3),_0x40e833=Math[_0x3ecd31(0x271)]((Graphics['boxWidth']-_0x5bcc13)/0x2),_0x4fa84d=this[_0x3ecd31(0x9c8)](),_0x2b8fb6=_0x4fa84d['y'],_0x5bd6d3=_0x4fa84d['height'];return new Rectangle(_0x40e833,_0x2b8fb6,_0x5bcc13,_0x5bd6d3);},Scene_Battle['prototype'][_0xfd5ed1(0x823)]=function(){const _0x17bc1a=_0xfd5ed1;this[_0x17bc1a(0x7e8)]['y']=this[_0x17bc1a(0x70a)]['y']+this[_0x17bc1a(0x70a)]['height'],this[_0x17bc1a(0x66b)]()?this[_0x17bc1a(0xb2d)]()==='border'?_0x17bc1a(0x82c)==='wNXlI'?_0x240c42[_0x17bc1a(0x1e9)]['Window_BattleLog_displayMiss'][_0x17bc1a(0x740)](this,_0x387077):this['_cancelButton']['x']=0x8:this[_0x17bc1a(0x7e8)]['x']=-this[_0x17bc1a(0x7e8)][_0x17bc1a(0xb4a)]-0x4:this[_0x17bc1a(0x7e8)]['x']=Graphics['width']-(Graphics[_0x17bc1a(0xb4a)]-Graphics[_0x17bc1a(0x9c4)])/0x2-this['_cancelButton'][_0x17bc1a(0xb4a)]-0x4;},VisuMZ['BattleCore']['Scene_Battle_skillWindowRect']=Scene_Battle[_0xfd5ed1(0x263)]['skillWindowRect'],Scene_Battle[_0xfd5ed1(0x263)][_0xfd5ed1(0x553)]=function(){const _0x432ae2=_0xfd5ed1;if(this['battleLayoutStyle']()==='border'){if('sILwv'===_0x432ae2(0x9f8))return this[_0x432ae2(0x1c2)]();else{if(this['constructor']===_0x1bb34a)return;_0x54b600[_0x432ae2(0x263)][_0x432ae2(0x213)]['call'](this);}}else return this[_0x432ae2(0x759)]()?this[_0x432ae2(0x6d5)]():VisuMZ[_0x432ae2(0x1e9)][_0x432ae2(0x73d)][_0x432ae2(0x740)](this);},VisuMZ[_0xfd5ed1(0x1e9)]['Scene_Battle_itemWindowRect']=Scene_Battle[_0xfd5ed1(0x263)]['itemWindowRect'],Scene_Battle[_0xfd5ed1(0x263)][_0xfd5ed1(0x97b)]=function(){const _0x2990fd=_0xfd5ed1;if(this[_0x2990fd(0xb2d)]()===_0x2990fd(0x9cf))return this[_0x2990fd(0x1c2)]();else return this['isSkillItemWindowsMiddle']()?this[_0x2990fd(0x6d5)]():VisuMZ[_0x2990fd(0x1e9)]['Scene_Battle_itemWindowRect'][_0x2990fd(0x740)](this);},Scene_Battle[_0xfd5ed1(0x263)]['isSkillItemWindowsMiddle']=function(){const _0x54d6bc=_0xfd5ed1;return VisuMZ['BattleCore'][_0x54d6bc(0x607)][_0x54d6bc(0x9bf)]['SkillItemMiddleLayout'];},Scene_Battle[_0xfd5ed1(0x263)]['skillItemWindowRectMiddle']=function(){const _0x122cf4=_0xfd5ed1,_0x219971=Sprite_Button[_0x122cf4(0x263)]['blockWidth']()*0x2+0x4;let _0x15ffea=Graphics['boxWidth']-_0x219971;Imported['VisuMZ_0_CoreEngine']&&SceneManager[_0x122cf4(0xa9e)]()&&(_0x122cf4(0xa6f)!==_0x122cf4(0xa6f)?_0x34ae52[_0x122cf4(0xb9a)][_0x122cf4(0x8aa)]()['gainCurrentActionsETB'](_0x3d9fca):_0x15ffea+=_0x219971);const _0x533e5e=this[_0x122cf4(0x744)](),_0x1af73b=Graphics['boxHeight']-_0x533e5e-this[_0x122cf4(0x325)]()[_0x122cf4(0x8c6)]+Window_BattleStatus['prototype']['extraHeight'](),_0x5eca6c=0x0;return new Rectangle(_0x5eca6c,_0x533e5e,_0x15ffea,_0x1af73b);},Scene_Battle[_0xfd5ed1(0x263)][_0xfd5ed1(0x449)]=function(){const _0x4e9655=_0xfd5ed1;if(!VisuMZ[_0x4e9655(0x1e9)][_0x4e9655(0x607)][_0x4e9655(0x1f5)]['NameLegacy'])return;this[_0x4e9655(0x783)]=new Sprite(),this[_0x4e9655(0x783)]['x']=this[_0x4e9655(0x62a)]['x'],this[_0x4e9655(0x783)]['y']=this[_0x4e9655(0x62a)]['y'];const _0x223b36=this[_0x4e9655(0x678)][_0x4e9655(0x981)](this[_0x4e9655(0x62a)]);this[_0x4e9655(0x29d)](this[_0x4e9655(0x783)],_0x223b36);for(let _0x1fad1e=0x0;_0x1fad1e<0x8;_0x1fad1e++){const _0x2384c3=new Window_EnemyName(_0x1fad1e);this['_enemyNameContainer']['addChild'](_0x2384c3);}},Sprite_Battler[_0xfd5ed1(0x502)]=VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0x607)][_0xfd5ed1(0xbdf)]['MotionSpeed'],VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0x926)]=Sprite_Battler[_0xfd5ed1(0x263)][_0xfd5ed1(0x218)],Sprite_Battler[_0xfd5ed1(0x263)][_0xfd5ed1(0x218)]=function(){const _0x270cf9=_0xfd5ed1;VisuMZ['BattleCore']['Sprite_Battler_initMembers'][_0x270cf9(0x740)](this),this[_0x270cf9(0x426)]();if(this[_0x270cf9(0x18a)]===Sprite_Enemy)this[_0x270cf9(0xb7e)]();this[_0x270cf9(0x80d)]();},Sprite_Battler[_0xfd5ed1(0x263)][_0xfd5ed1(0x426)]=function(){const _0x23a249=_0xfd5ed1;this[_0x23a249(0x6f7)]=0x0,this['_baseY']=0x0,this[_0x23a249(0x628)]=0x0,this['_targetFloatHeight']=0x0,this['_floatDuration']=0x0,this[_0x23a249(0x375)]=0x0,this[_0x23a249(0xa1f)]=_0x23a249(0x558),this[_0x23a249(0x6b2)]=0x0,this['_jumpMaxHeight']=0x0,this['_jumpDuration']=0x0,this['_jumpWholeDuration']=0x0,this[_0x23a249(0x34d)]=0xff,this[_0x23a249(0xa48)]=0x0,this['_opacityWholeDuration']=0x0,this['_opacityEasing']='Linear',this[_0x23a249(0x4be)]=0x0,this[_0x23a249(0x417)]=0x0,this[_0x23a249(0x4cc)]=0x0,this[_0x23a249(0x892)]=0x0,this[_0x23a249(0x99d)]='Linear',this['_angleRevertOnFinish']=!![],this[_0x23a249(0xbd1)]=0x0,this[_0x23a249(0x389)]=0x0,this[_0x23a249(0x396)]=0x0,this[_0x23a249(0x9e8)]=0x0,this[_0x23a249(0x1f7)]=0x0,this['_skewWholeDuration']=0x0,this['_skewEasing']='Linear',this[_0x23a249(0x253)]=0x1,this[_0x23a249(0x4dc)]=0x1,this[_0x23a249(0x317)]=0x1,this[_0x23a249(0xaa7)]=0x1,this['_growDuration']=0x0,this[_0x23a249(0x7b8)]=0x0,this[_0x23a249(0x9b1)]=_0x23a249(0x558),this[_0x23a249(0x828)]=0x1;},Sprite_Battler[_0xfd5ed1(0x263)][_0xfd5ed1(0xb7e)]=function(){const _0x2c9f19=_0xfd5ed1;this['_shadowSprite']=new Sprite(),this[_0x2c9f19(0xbe4)][_0x2c9f19(0x86e)]=ImageManager[_0x2c9f19(0x810)](_0x2c9f19(0x3cb)),this[_0x2c9f19(0xbe4)]['bitmap']['smooth']=VisuMZ[_0x2c9f19(0x1e9)]['Settings']['Actor'][_0x2c9f19(0xa38)],this[_0x2c9f19(0xbe4)]['anchor']['x']=0.5,this['_shadowSprite'][_0x2c9f19(0x266)]['y']=0.5,this[_0x2c9f19(0xbe4)]['y']=-0x2,this[_0x2c9f19(0xbe4)][_0x2c9f19(0x41b)]=![],this[_0x2c9f19(0x3d8)](this[_0x2c9f19(0xbe4)]);},Sprite_Battler['prototype'][_0xfd5ed1(0x80d)]=function(){const _0x406ba5=_0xfd5ed1;this[_0x406ba5(0x858)]=new Sprite(),this[_0x406ba5(0x858)][_0x406ba5(0x266)]['x']=0.5,this['_distortionSprite'][_0x406ba5(0x266)]['y']=0.5,this[_0x406ba5(0x3d8)](this[_0x406ba5(0x858)]);},Sprite_Battler[_0xfd5ed1(0x263)]['attachSpritesToDistortionSprite']=function(){const _0x2b8078=_0xfd5ed1;if(!this['_distortionSprite'])return;if(this[_0x2b8078(0xbe4)]){const _0x30203f=this[_0x2b8078(0x6c8)](this['_distortionSprite']);this[_0x2b8078(0x29d)](this[_0x2b8078(0xbe4)],_0x30203f),this['updateShadowVisibility']();}if(this[_0x2b8078(0x8c5)]){if('TqVtq'==='TqVtq')this[_0x2b8078(0x858)][_0x2b8078(0x3d8)](this['_svBattlerSprite']);else return!![];}this[_0x2b8078(0x34c)]&&this[_0x2b8078(0x858)][_0x2b8078(0x3d8)](this[_0x2b8078(0x34c)]);if(this[_0x2b8078(0x798)]){if('qDjpk'!==_0x2b8078(0x772)){const _0x47133d=_0x24987e(_0x886741['$1'])[_0x2b8078(0x300)](),_0x587920=_0xd55dc4(_0x5a1eff['$2']);_0x339e84[_0x47133d]=_0x587920,_0x4180b1+=_0x587920;}else this['_distortionSprite'][_0x2b8078(0x3d8)](this[_0x2b8078(0x798)]);}this[_0x2b8078(0x18d)]&&this[_0x2b8078(0x858)][_0x2b8078(0x3d8)](this[_0x2b8078(0x18d)]);},Sprite_Battler['prototype']['updateShadowVisibility']=function(){const _0x341236=_0xfd5ed1;if(!this[_0x341236(0xbe4)])return;if(this[_0x341236(0xbed)]&&this['_battler'][_0x341236(0xb20)]()){const _0x2e60b8=this[_0x341236(0xbe4)][_0x341236(0x86e)];this[_0x341236(0xbe4)][_0x341236(0x914)](0x0,0x0,_0x2e60b8['width'],_0x2e60b8['height']);}else{if('BQkIi'==='BQkIi')this[_0x341236(0xbe4)]['setFrame'](0x0,0x0,0x0,0x0);else{if(!_0x2fdecb[_0x341236(0xbb7)]())return;const _0x37a412=_0x31404c['_scene'][_0x341236(0x6f2)];if(_0x37a412)_0x37a412[_0x341236(0x315)]();}}},Sprite_Battler[_0xfd5ed1(0x263)][_0xfd5ed1(0x98a)]=function(){const _0x4d8298=_0xfd5ed1;if(SceneManager[_0x4d8298(0xbb7)]())return SceneManager[_0x4d8298(0x3c3)][_0x4d8298(0xb41)][_0x4d8298(0x387)];else{if('ZBrDc'===_0x4d8298(0xa23)){if(this['battler']())this[_0x4d8298(0x456)]()[_0x4d8298(0x999)]();}else return this[_0x4d8298(0x2da)];}},Sprite_Battler[_0xfd5ed1(0x263)][_0xfd5ed1(0xa32)]=function(_0x34d664,_0x2acfe4){const _0x5c4044=_0xfd5ed1;if(!this[_0x5c4044(0xbed)]['isSpriteVisible']())return;const _0x2c06dd=VisuMZ['BattleCore']['Settings'][_0x5c4044(0x608)],_0x1a0eaa=new Sprite_Damage();_0x1a0eaa[_0x5c4044(0x437)]=_0x2c06dd[_0x5c4044(0x624)],this[_0x5c4044(0x28f)](_0x1a0eaa),_0x1a0eaa[_0x5c4044(0xa32)](_0x34d664,_0x2acfe4),this[_0x5c4044(0x4a4)](_0x1a0eaa);},Sprite_Battler['prototype'][_0xfd5ed1(0xbb9)]=function(_0x445023,_0x26b38c,_0x478ef3){const _0x2bb851=_0xfd5ed1;if(!this[_0x2bb851(0xbed)][_0x2bb851(0x7dc)]())return;const _0xb0ab5c=VisuMZ[_0x2bb851(0x1e9)][_0x2bb851(0x607)][_0x2bb851(0x608)],_0x87a736=new Sprite_Damage();_0x87a736[_0x2bb851(0x437)]=_0xb0ab5c[_0x2bb851(0x624)],this[_0x2bb851(0x28f)](_0x87a736),_0x87a736[_0x2bb851(0xbb9)](_0x445023,_0x26b38c,_0x478ef3),this[_0x2bb851(0x4a4)](_0x87a736);},Sprite_Battler['prototype'][_0xfd5ed1(0x684)]=function(){const _0x46851c=_0xfd5ed1;if(!this[_0x46851c(0xbed)]['isDamagePopupRequested']())return;while(this[_0x46851c(0xbed)][_0x46851c(0xa46)]()){if(this[_0x46851c(0xbed)][_0x46851c(0x7dc)]()){if(_0x46851c(0x74e)===_0x46851c(0x74e))this[_0x46851c(0x764)]();else{const _0x39fbdd=_0x364c2f[_0x46851c(0x3c3)][_0x46851c(0x9c8)]();this['move'](_0x39fbdd['x'],_0x39fbdd['y'],_0x39fbdd[_0x46851c(0xb4a)],_0x39fbdd[_0x46851c(0x8c6)]),this[_0x46851c(0x3e5)](),this['setBackgroundType'](0x0);}}}this[_0x46851c(0xbed)][_0x46851c(0x453)](),this['_battler'][_0x46851c(0x2df)]();},Sprite_Battler[_0xfd5ed1(0x263)][_0xfd5ed1(0x764)]=function(){const _0x5d424c=_0xfd5ed1,_0x198098=VisuMZ[_0x5d424c(0x1e9)][_0x5d424c(0x607)][_0x5d424c(0x608)],_0x3387f9=new Sprite_Damage();_0x3387f9[_0x5d424c(0x437)]=_0x198098[_0x5d424c(0x624)],this['sortDamageSprites'](_0x3387f9),_0x3387f9['setup'](this['_battler']),_0x3387f9['setupBattleCore'](this[_0x5d424c(0xbed)]),this[_0x5d424c(0x4a4)](_0x3387f9);},Sprite_Battler['prototype'][_0xfd5ed1(0x4a4)]=function(_0x1dbd5d){const _0x28967d=_0xfd5ed1;this[_0x28967d(0x839)]['push'](_0x1dbd5d);if(this['isShownOnBattlePortrait']())SceneManager[_0x28967d(0x3c3)]['_statusWindow']['addDamageSprite'](_0x1dbd5d,this[_0x28967d(0xbed)]);else{this[_0x28967d(0x98a)]()[_0x28967d(0x3d8)](_0x1dbd5d);if(SceneManager['isBattleFlipped']())_0x1dbd5d['scale']['x']=-0x1;}},Sprite_Battler[_0xfd5ed1(0x263)][_0xfd5ed1(0x669)]=function(){const _0x5d078a=_0xfd5ed1;return!$gameSystem[_0x5d078a(0xb27)]()&&this[_0x5d078a(0xbed)]&&this['_battler']['isActor']();},Sprite_Battler['prototype'][_0xfd5ed1(0x28f)]=function(_0xf3eb7e){const _0x36612c=_0xfd5ed1;this[_0x36612c(0x950)](_0xf3eb7e,!![]);const _0x5e5c85=VisuMZ['BattleCore'][_0x36612c(0x607)][_0x36612c(0x608)],_0x2838a7=SceneManager[_0x36612c(0x438)]()?-0x1:0x1;if(_0x5e5c85[_0x36612c(0x66d)])for(const _0x28fcb0 of this['_damages']){_0x28fcb0['x']+=_0x5e5c85[_0x36612c(0x226)]*_0x2838a7,_0x28fcb0['y']+=_0x5e5c85[_0x36612c(0xa2b)];}else{if(_0x36612c(0x4d7)===_0x36612c(0x4d7)){const _0x5b6acc=this[_0x36612c(0x839)][this[_0x36612c(0x839)][_0x36612c(0x5b7)]-0x1];_0x5b6acc&&(_0xf3eb7e['x']=_0x5b6acc['x']+_0x5e5c85[_0x36612c(0x226)]*_0x2838a7,_0xf3eb7e['y']=_0x5b6acc['y']+_0x5e5c85[_0x36612c(0xa2b)]);}else _0x288b07=_0x4811eb>=_0x4ff588?_0x235e83:_0x5e5faa;}},Sprite_Battler[_0xfd5ed1(0x263)][_0xfd5ed1(0x950)]=function(_0x117d5b,_0x88b21c){const _0x2d5d1e=_0xfd5ed1,_0x25bd66=SceneManager['isBattleFlipped']()?-0x1:0x1;let _0x3869cb=this[_0x2d5d1e(0x6f7)];_0x3869cb+=this[_0x2d5d1e(0x584)]();let _0x25d336=this[_0x2d5d1e(0x579)];const _0x5f05fa=this[_0x2d5d1e(0x858)][_0x2d5d1e(0x603)]['y'];_0x25d336+=this[_0x2d5d1e(0x4c5)]();const _0x5822a0=SceneManager[_0x2d5d1e(0x3c3)][_0x2d5d1e(0x6f2)];if(_0x5822a0&&this['parent']===_0x5822a0){_0x3869cb+=_0x5822a0['x']-this[_0x2d5d1e(0x1ca)]();const _0x5a7380=_0x5822a0[_0x2d5d1e(0x9c1)]()*0x3/0x4;_0x25d336=_0x5822a0['y']+_0x5a7380,_0x25d336=Math['min'](_0x25d336,_0x5822a0['y']+this['y']-this[_0x2d5d1e(0x8c6)]+_0x5a7380);}_0x117d5b['x']=Math[_0x2d5d1e(0x271)](_0x3869cb+this[_0x2d5d1e(0x1ca)]()*_0x25bd66),_0x117d5b['y']=Math['round'](_0x25d336+this['damageOffsetY']());},VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0x733)]=Sprite_Battler['prototype'][_0xfd5ed1(0x1ca)],Sprite_Battler['prototype'][_0xfd5ed1(0x1ca)]=function(){const _0x3a351c=_0xfd5ed1;let _0x58a764=VisuMZ[_0x3a351c(0x1e9)][_0x3a351c(0x733)][_0x3a351c(0x740)](this),_0x26627b=VisuMZ[_0x3a351c(0x1e9)][_0x3a351c(0x607)]['Damage'][_0x3a351c(0x75f)]||0x0;return Math[_0x3a351c(0x271)](_0x58a764+_0x26627b);},VisuMZ['BattleCore'][_0xfd5ed1(0x971)]=Sprite_Battler[_0xfd5ed1(0x263)]['damageOffsetY'],Sprite_Battler[_0xfd5ed1(0x263)]['damageOffsetY']=function(){const _0x543cea=_0xfd5ed1;let _0x3ef2de=VisuMZ[_0x543cea(0x1e9)]['Sprite_Battler_damageOffsetY'][_0x543cea(0x740)](this);switch(VisuMZ[_0x543cea(0x1e9)][_0x543cea(0x607)][_0x543cea(0x608)]['PopupPosition']){case _0x543cea(0x76b):_0x3ef2de-=this[_0x543cea(0x8c6)]*this[_0x543cea(0x603)]['y'];break;case _0x543cea(0x4aa):_0x3ef2de-=this[_0x543cea(0x8c6)]*this[_0x543cea(0x603)]['y']*0.5;break;}let _0x221035=VisuMZ[_0x543cea(0x1e9)][_0x543cea(0x607)][_0x543cea(0x608)]['PopupOffsetY']||0x0;return Math[_0x543cea(0x271)](_0x3ef2de+_0x221035);},Sprite_Actor[_0xfd5ed1(0x263)][_0xfd5ed1(0x1ca)]=function(){const _0x451007=_0xfd5ed1;return Sprite_Battler[_0x451007(0x263)][_0x451007(0x1ca)][_0x451007(0x740)](this);},Sprite_Actor[_0xfd5ed1(0x263)][_0xfd5ed1(0x9d1)]=function(){const _0x1e0f61=_0xfd5ed1;return Sprite_Battler[_0x1e0f61(0x263)][_0x1e0f61(0x9d1)][_0x1e0f61(0x740)](this);},Sprite_Battler[_0xfd5ed1(0x263)]['destroyDamageSprite']=function(_0x4c6234){const _0x1e228b=_0xfd5ed1;this[_0x1e228b(0x669)]()?SceneManager[_0x1e228b(0x3c3)][_0x1e228b(0x6f2)][_0x1e228b(0xac9)](_0x4c6234):(this[_0x1e228b(0x98a)]()[_0x1e228b(0xaec)](_0x4c6234),this[_0x1e228b(0x839)][_0x1e228b(0x698)](_0x4c6234),_0x4c6234[_0x1e228b(0x681)]());},VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0x8be)]=Sprite_Battler[_0xfd5ed1(0x263)][_0xfd5ed1(0x72c)],Sprite_Battler[_0xfd5ed1(0x263)]['setHome']=function(_0x4632da,_0x3032ae){const _0x43e71e=_0xfd5ed1,_0x1ead1c=VisuMZ[_0x43e71e(0x1e9)][_0x43e71e(0x607)];if(this[_0x43e71e(0x18a)]===Sprite_Actor)_0x43e71e(0x9d5)===_0x43e71e(0x9d5)?(_0x4632da+=_0x1ead1c[_0x43e71e(0xbdf)][_0x43e71e(0x1cc)]||0x0,_0x3032ae+=_0x1ead1c[_0x43e71e(0xbdf)][_0x43e71e(0x5e2)]||0x0):_0x13f6a1=(_0x2f651d+_0x2f6c78)/0x2;else this[_0x43e71e(0x18a)]===Sprite_Enemy&&(_0x4632da+=_0x1ead1c[_0x43e71e(0x1f5)][_0x43e71e(0x1cc)]||0x0,_0x3032ae+=_0x1ead1c[_0x43e71e(0x1f5)][_0x43e71e(0x5e2)]||0x0);VisuMZ['BattleCore']['Sprite_Battler_setHome'][_0x43e71e(0x740)](this,_0x4632da,_0x3032ae);},VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0x7ac)]=Sprite_Battler['prototype'][_0xfd5ed1(0x840)],Sprite_Battler[_0xfd5ed1(0x263)][_0xfd5ed1(0x840)]=function(){const _0x53d8d0=_0xfd5ed1;VisuMZ[_0x53d8d0(0x1e9)]['Sprite_Battler_update'][_0x53d8d0(0x740)](this),!this[_0x53d8d0(0xbed)]&&this[_0x53d8d0(0xa67)]&&(this[_0x53d8d0(0xa67)]['visible']=![]);},VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0xb0e)]=Sprite_Battler['prototype'][_0xfd5ed1(0x197)],Sprite_Battler[_0xfd5ed1(0x263)][_0xfd5ed1(0x197)]=function(){const _0x1aedb4=_0xfd5ed1;this[_0x1aedb4(0x663)](),this[_0x1aedb4(0x42a)](),this[_0x1aedb4(0x34e)](),this['updateFlip'](),this['updateHpGaugePosition'](),VisuMZ['BattleCore'][_0x1aedb4(0xb0e)][_0x1aedb4(0x740)](this);if(this['constructor']===Sprite_Enemy)this['updateShadow']();},VisuMZ[_0xfd5ed1(0x1e9)]['Sprite_Battler_updatePosition']=Sprite_Battler[_0xfd5ed1(0x263)][_0xfd5ed1(0x95f)],Sprite_Battler[_0xfd5ed1(0x263)][_0xfd5ed1(0x95f)]=function(){const _0x1bd9a2=_0xfd5ed1;VisuMZ[_0x1bd9a2(0x1e9)][_0x1bd9a2(0x294)][_0x1bd9a2(0x740)](this),this[_0x1bd9a2(0x692)](),this[_0x1bd9a2(0x2e7)]();},Sprite_Battler[_0xfd5ed1(0x263)]['updatePositionBattleCore']=function(){const _0x2a858b=_0xfd5ed1;this['_baseX']=this['x'],this[_0x2a858b(0x579)]=this['y'],this[_0x2a858b(0x367)](),this[_0x2a858b(0x793)](),this['x']+=this['extraPositionX'](),this['y']+=this[_0x2a858b(0x4c5)](),this['y']+=this[_0x2a858b(0x96e)](),this['x']=Math[_0x2a858b(0x765)](this['x']),this['y']=Math[_0x2a858b(0x765)](this['y']);},Sprite_Battler[_0xfd5ed1(0x263)][_0xfd5ed1(0x584)]=function(){let _0x29b675=0x0;return _0x29b675;},Sprite_Battler[_0xfd5ed1(0x263)][_0xfd5ed1(0x4c5)]=function(){const _0x11c211=_0xfd5ed1;let _0x3393ac=0x0;return this[_0x11c211(0xbed)]&&!this[_0x11c211(0xbed)][_0x11c211(0x711)]()&&(_0x3393ac-=this[_0x11c211(0x628)],_0x3393ac-=this[_0x11c211(0x6b2)]),_0x3393ac;},Sprite_Battler[_0xfd5ed1(0x263)][_0xfd5ed1(0x96e)]=function(){const _0x58e5c5=_0xfd5ed1;let _0x48cb11=0x0;if(this['_distortionSprite']&&this[_0x58e5c5(0x18a)]!==Sprite_SvEnemy){if(_0x58e5c5(0x95e)===_0x58e5c5(0x50f)){const _0xde9f9a=_0x481f14[_0x120e97[_0x58e5c5(0x32d)]],_0x174357=_0xde9f9a[_0x58e5c5(0x641)]['length']-0x2,_0x3537c7=_0xde9f9a[_0x58e5c5(0x641)][_0x174357];if(_0x3537c7&&_0x3537c7['code']!==0xe6){const _0x371632={'code':0xe6,'indent':0x0,'parameters':[0x1]},_0x1cb8e0=_0xde9f9a['list'][_0x58e5c5(0x46a)]();_0xde9f9a['list'][_0x58e5c5(0x885)](_0x371632),_0xde9f9a[_0x58e5c5(0x641)][_0x58e5c5(0x885)](_0x1cb8e0);}}else{const _0x2ce0b2=this['_distortionSprite'][_0x58e5c5(0x603)]['y'];_0x48cb11-=(_0x2ce0b2-0x1)*this[_0x58e5c5(0x8c6)];}}return _0x48cb11;},Sprite_Battler[_0xfd5ed1(0x263)]['updateFlip']=function(){const _0x42acc5=_0xfd5ed1,_0xae2a8e=this[_0x42acc5(0xbed)]&&this[_0x42acc5(0xbed)][_0x42acc5(0x39f)]();this[_0x42acc5(0x828)]=(_0xae2a8e?-0x1:0x1)*Math['abs'](this[_0x42acc5(0x603)]['x']);},Sprite_Battler[_0xfd5ed1(0x263)][_0xfd5ed1(0x795)]=function(_0x17464c,_0x463858,_0x4a8d02){const _0x2d11c6=_0xfd5ed1;if(!this[_0x2d11c6(0x695)]())return;if(this[_0x2d11c6(0x3eb)]===_0x17464c)return;this[_0x2d11c6(0x3eb)]=_0x17464c,this['_floatDuration']=_0x463858,this[_0x2d11c6(0x375)]=_0x463858,this[_0x2d11c6(0xa1f)]=_0x4a8d02||_0x2d11c6(0x558);if(_0x463858<=0x0)this[_0x2d11c6(0x628)]=_0x17464c;},Sprite_Battler[_0xfd5ed1(0x263)][_0xfd5ed1(0x367)]=function(){const _0x33965a=_0xfd5ed1;if(this[_0x33965a(0x368)]<=0x0)return;const _0x1f1066=this[_0x33965a(0x368)],_0x1d99c3=this[_0x33965a(0x375)],_0x1a344e=this[_0x33965a(0xa1f)];Imported[_0x33965a(0x768)]?this[_0x33965a(0x628)]=this['applyEasing'](this[_0x33965a(0x628)],this[_0x33965a(0x3eb)],_0x1f1066,_0x1d99c3,_0x1a344e):'sZRDo'==='sZRDo'?this['_floatHeight']=(this[_0x33965a(0x628)]*(_0x1f1066-0x1)+this[_0x33965a(0x3eb)])/_0x1f1066:_0x28dede[_0x33965a(0x263)][_0x33965a(0x91f)]['call'](this);this[_0x33965a(0x368)]--;if(this['_floatDuration']<=0x0)this[_0x33965a(0x32e)]();},Sprite_Battler[_0xfd5ed1(0x263)]['onFloatEnd']=function(){const _0x4be088=_0xfd5ed1;this[_0x4be088(0x628)]=this[_0x4be088(0x3eb)];},Sprite_Battler[_0xfd5ed1(0x263)]['isFloating']=function(){const _0x3b3f65=_0xfd5ed1;return this[_0x3b3f65(0x368)]>0x0;},Sprite_Battler[_0xfd5ed1(0x263)][_0xfd5ed1(0x63c)]=function(_0x5b0b31,_0x179307){const _0x5b20e1=_0xfd5ed1;if(!this[_0x5b20e1(0x695)]())return;if(_0x179307<=0x0)return;this[_0x5b20e1(0x24f)]=_0x5b0b31,this[_0x5b20e1(0x686)]=_0x179307,this['_jumpWholeDuration']=_0x179307;},Sprite_Battler['prototype'][_0xfd5ed1(0x793)]=function(){const _0x1e382a=_0xfd5ed1;if(this[_0x1e382a(0x686)]<=0x0)return;const _0x3d52ae=this[_0x1e382a(0x4bc)]-this['_jumpDuration'],_0x32f54c=this[_0x1e382a(0x4bc)]/0x2,_0x27bb8e=this[_0x1e382a(0x24f)],_0x1e21c9=-_0x27bb8e/Math[_0x1e382a(0x1e3)](_0x32f54c,0x2);this[_0x1e382a(0x6b2)]=_0x1e21c9*Math[_0x1e382a(0x1e3)](_0x3d52ae-_0x32f54c,0x2)+_0x27bb8e,this['_jumpDuration']--;if(this[_0x1e382a(0x686)]<=0x0)return this[_0x1e382a(0x95c)]();},Sprite_Battler[_0xfd5ed1(0x263)][_0xfd5ed1(0x95c)]=function(){const _0x548a80=_0xfd5ed1;this[_0x548a80(0x6b2)]=0x0;},Sprite_Battler['prototype'][_0xfd5ed1(0x403)]=function(){return this['_jumpDuration']>0x0;},Sprite_Battler[_0xfd5ed1(0x263)][_0xfd5ed1(0xb07)]=function(_0x3ae55a,_0xc9dd1b,_0x46726f){const _0x332060=_0xfd5ed1;if(this[_0x332060(0x34d)]===_0x3ae55a)return;this['_targetOpacity']=_0x3ae55a,this[_0x332060(0xa48)]=_0xc9dd1b,this[_0x332060(0x648)]=_0xc9dd1b,this[_0x332060(0x610)]=_0x46726f||_0x332060(0x558);if(_0xc9dd1b<=0x0)this[_0x332060(0x9ac)]=_0x3ae55a;},Sprite_Battler[_0xfd5ed1(0x263)]['updateOpacity']=function(){const _0x83d65c=_0xfd5ed1;if(this[_0x83d65c(0x18a)]['name']===_0x83d65c(0x88b))return;if(this[_0x83d65c(0xa48)]<=0x0)return;const _0x567b5e=this['_opacityDuration'],_0x18008d=this['_opacityWholeDuration'],_0x19ea7f=this['_opacityEasing'];if(Imported[_0x83d65c(0x768)])this[_0x83d65c(0x9ac)]=this['applyEasing'](this[_0x83d65c(0x9ac)],this[_0x83d65c(0x34d)],_0x567b5e,_0x18008d,_0x19ea7f);else{if('Jgssj'!=='yqdfZ')this['opacity']=(this['opacity']*(_0x567b5e-0x1)+this['_targetOpacity'])/_0x567b5e;else{if(!_0x2535a5[_0x83d65c(0xbb7)]())return;_0x418f2a[_0x83d65c(0x1c5)](_0x4a1a01,_0x9e3b22);const _0x36e2f4=_0x863682[_0x83d65c(0x58e)](),_0x1cad7=_0x3b8e97[_0x83d65c(0x2c6)],_0x2205d6=_0x335765[_0x83d65c(0xb9a)],_0x396a37=_0xc9a754[_0x83d65c(0x49d)](_0x4461fc[_0x83d65c(0x7e3)]),_0x4cfdad=_0x4e7019[_0x83d65c(0x5f6)],_0x45919b=_0xa8a384[_0x83d65c(0x901)];if(!_0x36e2f4||!_0x1cad7||!_0x2205d6)return;if(!_0x1cad7[_0x83d65c(0x3c7)]())return;let _0x287063=_0x1cad7[_0x83d65c(0x3c7)]()['animationId'];if(_0x287063<0x0)_0x287063=_0x2205d6['attackAnimationId1']();_0x215099[_0x83d65c(0x307)](_0x396a37,_0x287063,_0x4cfdad),_0x362838['WaitForAnimation']&&_0x36e2f4[_0x83d65c(0x7a6)](_0x83d65c(0x1dc));}}this[_0x83d65c(0xa48)]--;if(this[_0x83d65c(0xa48)]<=0x0)this['onOpacityEnd']();},Sprite_Battler[_0xfd5ed1(0x263)]['onOpacityEnd']=function(){const _0x3ef67a=_0xfd5ed1;this[_0x3ef67a(0x9ac)]=this[_0x3ef67a(0x34d)];},Sprite_Battler['prototype'][_0xfd5ed1(0x81e)]=function(){return this['_opacityDuration']>0x0;},Sprite_Battler[_0xfd5ed1(0x263)][_0xfd5ed1(0x43b)]=function(){const _0x29184e=_0xfd5ed1;this['_shadowSprite'][_0x29184e(0x41b)]=this[_0x29184e(0xbed)][_0x29184e(0x9bc)](),this[_0x29184e(0x630)]();},Sprite_Battler['prototype'][_0xfd5ed1(0x630)]=function(){const _0x1056c1=_0xfd5ed1;if(!this['_shadowSprite'])return;this['_shadowSprite']['y']=this[_0x1056c1(0x579)]-this['y']-0x2;},Sprite_Battler['prototype'][_0xfd5ed1(0x188)]=function(){const _0x151d36=_0xfd5ed1;if(!this[_0x151d36(0xbed)])return;this[_0x151d36(0x574)]=this['_battler'][_0x151d36(0x8c7)](),this[_0x151d36(0x8b7)]=this[_0x151d36(0xbed)][_0x151d36(0xa40)]();},Game_BattlerBase['prototype'][_0xfd5ed1(0x8c7)]=function(){const _0x8312b0=_0xfd5ed1,_0x4d571b=this[_0x8312b0(0x75b)]()?this[_0x8312b0(0x279)]():this[_0x8312b0(0x333)]();if(_0x4d571b){const _0x4893b7=_0x4d571b[_0x8312b0(0x80f)];if(_0x4893b7[_0x8312b0(0x9e4)](/<SIDEVIEW SHADOW (?:SCALE|SCALE X):[ ](\d+)([%％])>/i)){if(_0x8312b0(0x23f)==='nDoZK')this['x']=_0x301a2f[_0x8312b0(0x9c4)]-this[_0x8312b0(0x333)]()[_0x8312b0(0x456)]()['_baseX'];else return Number(RegExp['$1'])*0.01;}else{if(_0x4893b7[_0x8312b0(0x9e4)](/<SIDEVIEW SHADOW (?:SCALE|SCALE X):[ ](.*)>/i))return Number(RegExp['$1'])||0x0;}}return 0x1;},Game_BattlerBase['prototype'][_0xfd5ed1(0xa40)]=function(){const _0x2d0d15=_0xfd5ed1,_0x1e7b10=this[_0x2d0d15(0x75b)]()?this[_0x2d0d15(0x279)]():this[_0x2d0d15(0x333)]();if(_0x1e7b10){if('XZLEY'!==_0x2d0d15(0xa9a)){if(_0x58f4f6[_0x2d0d15(0xbed)]&&_0x20a7d1[_0x2d0d15(0xbed)]){if(_0xf55b8b[_0x2d0d15(0xbed)][_0x2d0d15(0x75b)]()&&_0x21e96e[_0x2d0d15(0xbed)][_0x2d0d15(0x73c)]())return 0x1;else{if(_0x5ca28f['_battler']['isActor']()&&_0x167912[_0x2d0d15(0xbed)]['isEnemy']())return-0x1;}}}else{const _0x193294=_0x1e7b10['note'];if(_0x193294[_0x2d0d15(0x9e4)](/<SIDEVIEW SHADOW (?:SCALE|SCALE Y):[ ](\d+)([%％])>/i))return Number(RegExp['$1'])*0.01;else{if(_0x193294[_0x2d0d15(0x9e4)](/<SIDEVIEW SHADOW (?:SCALE|SCALE Y):[ ](.*)>/i))return Number(RegExp['$1'])||0x0;}}}return 0x1;},Sprite_Battler[_0xfd5ed1(0x263)]['updateScale']=function(){const _0x46c07f=_0xfd5ed1;if(this[_0x46c07f(0x18a)]===Sprite_SvEnemy)return;this['updateGrow'](),this[_0x46c07f(0x499)]();},Sprite_Battler[_0xfd5ed1(0x263)][_0xfd5ed1(0x499)]=function(){const _0x1c6f9e=_0xfd5ed1,_0xf92bd2=this[_0x1c6f9e(0x858)];_0xf92bd2&&(_0xf92bd2[_0x1c6f9e(0x603)]['x']=this['mainSpriteScaleX'](),_0xf92bd2[_0x1c6f9e(0x603)]['y']=this[_0x1c6f9e(0x5e9)]());},Sprite_Battler[_0xfd5ed1(0x263)][_0xfd5ed1(0x471)]=function(){const _0x53917c=_0xfd5ed1;let _0x4732f5=0x1;return _0x4732f5*=this[_0x53917c(0x828)],_0x4732f5*=this[_0x53917c(0x253)],_0x4732f5;},Sprite_Battler[_0xfd5ed1(0x263)][_0xfd5ed1(0x5e9)]=function(){const _0x3bb539=_0xfd5ed1;return 0x1*this[_0x3bb539(0x4dc)];},Sprite_Battler[_0xfd5ed1(0x263)]['mainSpriteWidth']=function(){const _0x3e8a76=_0xfd5ed1;return this[_0x3e8a76(0xb4a)]*this['mainSpriteScaleX']();},Sprite_Battler['prototype'][_0xfd5ed1(0x5e5)]=function(){const _0x38e6c7=_0xfd5ed1;return this[_0x38e6c7(0x8c6)]*this[_0x38e6c7(0x5e9)]();},Sprite_Battler[_0xfd5ed1(0x263)][_0xfd5ed1(0x876)]=function(_0x4571ba,_0x1dc4e4,_0x4479d3,_0x170e5c){const _0x2a7970=_0xfd5ed1;if(!this[_0x2a7970(0x695)]())return;if(!this[_0x2a7970(0x858)])return;if(this[_0x2a7970(0x317)]===_0x4571ba&&this[_0x2a7970(0xaa7)]===_0x1dc4e4)return;this[_0x2a7970(0x317)]=_0x4571ba,this[_0x2a7970(0xaa7)]=_0x1dc4e4,this[_0x2a7970(0x7e5)]=_0x4479d3,this[_0x2a7970(0x7b8)]=_0x4479d3,this['_growEasing']=_0x170e5c||_0x2a7970(0x558),_0x4479d3<=0x0&&(this[_0x2a7970(0x253)]=this[_0x2a7970(0x317)],this[_0x2a7970(0x4dc)]=this[_0x2a7970(0xaa7)]);},Sprite_Battler[_0xfd5ed1(0x263)][_0xfd5ed1(0x228)]=function(){const _0x2d552f=_0xfd5ed1;if(this[_0x2d552f(0x7e5)]<=0x0)return;if(!this['_distortionSprite'])return;const _0xc3ce0b=this['_growDuration'],_0x4cc3e9=this[_0x2d552f(0x7b8)],_0x1f74af=this[_0x2d552f(0x9b1)];Imported['VisuMZ_0_CoreEngine']?(this[_0x2d552f(0x253)]=this['applyEasing'](this[_0x2d552f(0x253)],this[_0x2d552f(0x317)],_0xc3ce0b,_0x4cc3e9,_0x1f74af),this[_0x2d552f(0x4dc)]=this[_0x2d552f(0x83e)](this['_growY'],this[_0x2d552f(0xaa7)],_0xc3ce0b,_0x4cc3e9,_0x1f74af)):_0x2d552f(0x37d)!=='hXKct'?(this['_growX']=(this[_0x2d552f(0x253)]*(_0xc3ce0b-0x1)+this['_targetGrowX'])/_0xc3ce0b,this['_growY']=(this['_growY']*(_0xc3ce0b-0x1)+this['_targetGrowY'])/_0xc3ce0b):(_0xba1b98[_0x2d552f(0x1e9)][_0x2d552f(0x5ea)][_0x2d552f(0x740)](this),this[_0x2d552f(0x2f4)]());this['_growDuration']--;if(this[_0x2d552f(0x7e5)]<=0x0)this[_0x2d552f(0xb83)]();},Sprite_Battler[_0xfd5ed1(0x263)][_0xfd5ed1(0xb83)]=function(){const _0x396b6e=_0xfd5ed1;this[_0x396b6e(0x253)]=this[_0x396b6e(0x317)],this[_0x396b6e(0x4dc)]=this[_0x396b6e(0xaa7)];},Sprite_Battler[_0xfd5ed1(0x263)][_0xfd5ed1(0x512)]=function(){const _0x335769=_0xfd5ed1;return this[_0x335769(0x7e5)]>0x0;},Sprite_Battler[_0xfd5ed1(0x263)][_0xfd5ed1(0x69b)]=function(_0x2dec59,_0x13279f,_0x5acc5f,_0x3601ea){const _0x5d3002=_0xfd5ed1;if(!this[_0x5d3002(0x695)]())return;if(!this[_0x5d3002(0x858)])return;if(this[_0x5d3002(0x396)]===_0x2dec59&&this[_0x5d3002(0x9e8)]===_0x13279f)return;this['_targetSkewX']=_0x2dec59,this[_0x5d3002(0x9e8)]=_0x13279f,this[_0x5d3002(0x1f7)]=_0x5acc5f,this['_skewWholeDuration']=_0x5acc5f,this[_0x5d3002(0xb23)]=_0x3601ea||_0x5d3002(0x558);if(_0x5acc5f<=0x0){if('HrIOP'!==_0x5d3002(0x23c))this[_0x5d3002(0x858)][_0x5d3002(0x327)]['x']=this[_0x5d3002(0x396)],this['_distortionSprite'][_0x5d3002(0x327)]['y']=this['_targetSkewY'];else{const _0x2a00ea=new _0x4d029b();this[_0x5d3002(0x783)][_0x5d3002(0x3d8)](_0x2a00ea),_0x2a00ea[_0x5d3002(0xbc7)](_0x42d714);}}},Sprite_Battler[_0xfd5ed1(0x263)][_0xfd5ed1(0x42a)]=function(){const _0x59b57f=_0xfd5ed1;if(this[_0x59b57f(0x1f7)]<=0x0)return;if(!this[_0x59b57f(0x858)])return;const _0x53b58a=this[_0x59b57f(0x1f7)],_0x1e79ad=this[_0x59b57f(0x466)],_0x2c8fc5=this[_0x59b57f(0xb23)],_0x3e78a6=this[_0x59b57f(0x858)];Imported['VisuMZ_0_CoreEngine']?(_0x3e78a6[_0x59b57f(0x327)]['x']=this['applyEasing'](_0x3e78a6['skew']['x'],this[_0x59b57f(0x396)],_0x53b58a,_0x1e79ad,_0x2c8fc5),_0x3e78a6[_0x59b57f(0x327)]['y']=this['applyEasing'](_0x3e78a6[_0x59b57f(0x327)]['y'],this[_0x59b57f(0x9e8)],_0x53b58a,_0x1e79ad,_0x2c8fc5)):_0x59b57f(0xa2c)===_0x59b57f(0xa2c)?(_0x3e78a6[_0x59b57f(0x327)]['x']=(_0x3e78a6[_0x59b57f(0x327)]['x']*(_0x53b58a-0x1)+this[_0x59b57f(0x396)])/_0x53b58a,_0x3e78a6['skew']['y']=(_0x3e78a6[_0x59b57f(0x327)]['y']*(_0x53b58a-0x1)+this[_0x59b57f(0x9e8)])/_0x53b58a):this[_0x59b57f(0xa67)][_0x59b57f(0x41b)]=![];this[_0x59b57f(0x1f7)]--;if(this[_0x59b57f(0x1f7)]<=0x0)this['onSkewEnd']();},Sprite_Battler[_0xfd5ed1(0x263)][_0xfd5ed1(0x511)]=function(){const _0x4640bf=_0xfd5ed1;this[_0x4640bf(0x858)]['skew']['x']=this[_0x4640bf(0x396)],this[_0x4640bf(0x858)][_0x4640bf(0x327)]['y']=this[_0x4640bf(0x9e8)];},Sprite_Battler[_0xfd5ed1(0x263)][_0xfd5ed1(0xa97)]=function(){const _0x18b017=_0xfd5ed1;return this[_0x18b017(0x1f7)]>0x0;},Sprite_Battler[_0xfd5ed1(0x263)][_0xfd5ed1(0x225)]=function(_0x39a04a,_0x5b4a83,_0x5c00fb,_0xea19c7){const _0x558538=_0xfd5ed1;if(!this[_0x558538(0x695)]())return;if(!this['_distortionSprite'])return;if(this[_0x558538(0x417)]===_0x39a04a)return;this[_0x558538(0x417)]=_0x39a04a,this[_0x558538(0x4cc)]=_0x5b4a83,this[_0x558538(0x892)]=_0x5b4a83,this[_0x558538(0x99d)]=_0x5c00fb||_0x558538(0x558),this[_0x558538(0x973)]=_0xea19c7;if(this[_0x558538(0x973)]===undefined){if(_0x558538(0x37a)===_0x558538(0x37a))this[_0x558538(0x973)]=!![];else{const _0x11f1c6=_0x46c0a6[this[_0x558538(0x4b9)][_0x558538(0x6a1)]()];if(!_0x11f1c6)return;if(!this[_0x558538(0xbbc)](_0x11f1c6))return;const _0x3937e4=this[_0x558538(0x7a1)](),_0x2b5796=_0x51670e[_0x558538(0x82a)](_0x11f1c6),_0x519f2c=_0x20a101['battleCommandIcon'](_0x11f1c6),_0x1c5bf4=_0x3937e4===_0x558538(0x7e7)?_0x2b5796:_0x558538(0xa62)[_0x558538(0x222)](_0x519f2c,_0x2b5796);this['addCommand'](_0x1c5bf4,_0x558538(0x8c1),this[_0x558538(0x4b9)][_0x558538(0x7bd)]());}}if(_0x5b4a83<=0x0){if('bxnza'===_0x558538(0x776)){this[_0x558538(0x4be)]=_0x39a04a;if(this[_0x558538(0x973)]){if(_0x558538(0xb98)!=='LlsEI'){if(!_0xf769f7[_0x558538(0x1e9)]['Settings'][_0x558538(0xbdf)][_0x558538(0x3c8)])return;const _0x5a6a74=_0x2e375f[_0x558538(0xb9a)];if(_0x5a6a74){if(_0x5a6a74['isActor']()&&!_0x480ea8['isSideView']())return;const _0x3527a5=_0x5a6a74[_0x558538(0x456)]();if(_0x3527a5&&_0x5a6a74[_0x558538(0x75b)]())this[_0x558538(0x728)][_0x558538(0x3d8)](_0x3527a5);}}else this[_0x558538(0x417)]=0x0,this['_currentAngle']=0x0;}}else _0x4586e8[_0x558538(0x1e9)][_0x558538(0x1e7)][_0x558538(0x740)](this),this[_0x558538(0xa29)]();}},Sprite_Battler[_0xfd5ed1(0x263)][_0xfd5ed1(0x34e)]=function(){this['updateAngleCalculations'](),this['applyAngleChange']();},Sprite_Battler['prototype']['updateAngleCalculations']=function(){const _0x573bf2=_0xfd5ed1;if(this[_0x573bf2(0x4cc)]<=0x0)return;const _0x32c9c5=this[_0x573bf2(0x4cc)],_0x5c99ef=this[_0x573bf2(0x892)],_0x4ed664=this[_0x573bf2(0x99d)];Imported[_0x573bf2(0x768)]?_0x573bf2(0x386)!==_0x573bf2(0x386)?(this['_svBattlerSprite']=new _0x564018(_0xd9896),this[_0x573bf2(0xb8d)]()):this[_0x573bf2(0x4be)]=this[_0x573bf2(0x83e)](this[_0x573bf2(0x4be)],this[_0x573bf2(0x417)],_0x32c9c5,_0x5c99ef,_0x4ed664):this[_0x573bf2(0x4be)]=(this[_0x573bf2(0x4be)]*(_0x32c9c5-0x1)+this[_0x573bf2(0x417)])/_0x32c9c5;this[_0x573bf2(0x4cc)]--;if(this['_angleDuration']<=0x0)this['onAngleEnd']();},Sprite_Battler['prototype'][_0xfd5ed1(0xad8)]=function(){const _0x37190e=_0xfd5ed1;this[_0x37190e(0x4be)]=this['_targetAngle'],this[_0x37190e(0x973)]&&(this[_0x37190e(0x417)]=0x0,this[_0x37190e(0x4be)]=0x0);},Sprite_Battler[_0xfd5ed1(0x263)][_0xfd5ed1(0x647)]=function(){const _0x1aa181=_0xfd5ed1;return this[_0x1aa181(0x4cc)]>0x0;},Sprite_Battler[_0xfd5ed1(0x263)]['applyAngleChange']=function(){const _0x247da2=_0xfd5ed1;if(!this[_0x247da2(0x858)])return;const _0x1bb90e=this[_0x247da2(0x4be)],_0x91e97d=this['scale']['x'],_0x283398=this[_0x247da2(0xbed)][_0x247da2(0x75b)]()?-0x1:0x1;this[_0x247da2(0x858)][_0x247da2(0x1d0)]=_0x1bb90e*_0x91e97d*_0x283398;const _0x47577b=this['_distortionSprite']['scale']['y'];this['_distortionSprite']['y']=this['height']*-0.5*(0x2-_0x47577b),this[_0x247da2(0x858)]['y']=Math[_0x247da2(0x562)](this['_distortionSprite']['y']);const _0x52b538=[this[_0x247da2(0x798)],this[_0x247da2(0x8c5)],this[_0x247da2(0x18d)]];for(const _0xf5eec5 of _0x52b538){if(!_0xf5eec5)continue;_0xf5eec5['y']=this[_0x247da2(0x8c6)]*0.5;}this['_shadowSprite']&&(this[_0x247da2(0x574)]=this[_0x247da2(0x574)]??0x1,this[_0x247da2(0x8b7)]=this[_0x247da2(0x8b7)]??0x1,this[_0x247da2(0xbe4)]['scale']['x']=this[_0x247da2(0x858)][_0x247da2(0x603)]['x']*this['_shadowScaleX'],this[_0x247da2(0xbe4)][_0x247da2(0x603)]['y']=this[_0x247da2(0x858)][_0x247da2(0x603)]['y']*this[_0x247da2(0x8b7)]);},VisuMZ['BattleCore'][_0xfd5ed1(0x74a)]=Sprite_Actor[_0xfd5ed1(0x263)][_0xfd5ed1(0x302)],Sprite_Actor[_0xfd5ed1(0x263)][_0xfd5ed1(0x302)]=function(){const _0x2cd7c1=_0xfd5ed1;VisuMZ[_0x2cd7c1(0x1e9)][_0x2cd7c1(0x74a)][_0x2cd7c1(0x740)](this),VisuMZ['BattleCore'][_0x2cd7c1(0x607)][_0x2cd7c1(0x2d2)][_0x2cd7c1(0x71e)]&&(_0x2cd7c1(0x93c)===_0x2cd7c1(0x7e9)?(this[_0x2cd7c1(0x253)]=this[_0x2cd7c1(0x317)],this[_0x2cd7c1(0x4dc)]=this['_targetGrowY']):this[_0x2cd7c1(0xafa)]());},VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0x505)]=Sprite_Enemy['prototype'][_0xfd5ed1(0xa4c)],Sprite_Enemy['prototype'][_0xfd5ed1(0xa4c)]=function(){const _0x54b4da=_0xfd5ed1;VisuMZ[_0x54b4da(0x1e9)][_0x54b4da(0x607)][_0x54b4da(0x2d2)][_0x54b4da(0x1bf)]&&this[_0x54b4da(0xafa)](),VisuMZ[_0x54b4da(0x1e9)]['Sprite_Enemy_createStateIconSprite'][_0x54b4da(0x740)](this);},Sprite_Battler[_0xfd5ed1(0x263)][_0xfd5ed1(0xafa)]=function(){const _0x1e5dd8=_0xfd5ed1;if(!ConfigManager['visualHpGauge'])return;if(this[_0x1e5dd8(0x18a)]===Sprite_SvEnemy)return;const _0x5246aa=VisuMZ[_0x1e5dd8(0x1e9)][_0x1e5dd8(0x607)][_0x1e5dd8(0x2d2)],_0x59b048=new Sprite_HpGauge();_0x59b048['anchor']['x']=_0x5246aa[_0x1e5dd8(0x866)],_0x59b048[_0x1e5dd8(0x266)]['y']=_0x5246aa[_0x1e5dd8(0x8e4)],_0x59b048['scale']['x']=_0x59b048[_0x1e5dd8(0x603)]['y']=_0x5246aa[_0x1e5dd8(0x8f7)],this[_0x1e5dd8(0xa67)]=_0x59b048,this[_0x1e5dd8(0x3d8)](this[_0x1e5dd8(0xa67)]);},VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0x4a7)]=Sprite_Battler['prototype']['setBattler'],Sprite_Battler[_0xfd5ed1(0x263)][_0xfd5ed1(0xac4)]=function(_0x1140ce){const _0x126ab6=_0xfd5ed1,_0x27e11b=this[_0x126ab6(0xbed)];VisuMZ[_0x126ab6(0x1e9)]['Sprite_Battler_setBattler']['call'](this,_0x1140ce),this[_0x126ab6(0x68e)](_0x1140ce);if(_0x27e11b!==_0x1140ce)this[_0x126ab6(0x188)]();},Sprite_Battler[_0xfd5ed1(0x263)]['setupHpGaugeSprite']=function(_0x5e4b45){const _0x4c86fa=_0xfd5ed1;if(!_0x5e4b45)return;if(!this[_0x4c86fa(0xa67)])return;if(_0x5e4b45['isActor']()){}else{if(_0x5e4b45[_0x4c86fa(0x73c)]()){if(this[_0x4c86fa(0x18a)]===Sprite_SvEnemy&&!_0x5e4b45[_0x4c86fa(0x9bc)]())return;}}this['_hpGaugeSprite'][_0x4c86fa(0xba7)](_0x5e4b45,'hp');},Sprite_Battler[_0xfd5ed1(0x263)][_0xfd5ed1(0x8d3)]=function(){const _0x5c1c89=_0xfd5ed1;if(!this['_battler'])return;if(!this[_0x5c1c89(0xa67)])return;const _0x2faa30=VisuMZ['BattleCore'][_0x5c1c89(0x607)][_0x5c1c89(0x2d2)],_0x5e990b=this[_0x5c1c89(0xa67)];_0x5e990b[_0x5c1c89(0x41b)]=this[_0x5c1c89(0x747)]();const _0x1b0307=_0x2faa30[_0x5c1c89(0x1cc)],_0xe8eeae=_0x2faa30[_0x5c1c89(0x5e2)];_0x5e990b['x']=_0x1b0307,_0x5e990b['x']+=this[_0x5c1c89(0xbed)][_0x5c1c89(0x590)](),_0x5e990b['y']=-this[_0x5c1c89(0x8c6)]+_0xe8eeae,_0x5e990b['y']+=this[_0x5c1c89(0xbed)][_0x5c1c89(0x342)]();},Sprite_Battler[_0xfd5ed1(0x263)][_0xfd5ed1(0x747)]=function(){const _0x3715f7=_0xfd5ed1;if(!this[_0x3715f7(0xbed)])return![];if(this['_battler']['isActor']())return!![];const _0x1d01dc=this[_0x3715f7(0xbed)][_0x3715f7(0x333)]()[_0x3715f7(0x80f)];if(_0x1d01dc['match'](/<SHOW HP GAUGE>/i))return!![];if(_0x1d01dc[_0x3715f7(0x9e4)](/<HIDE HP GAUGE>/i))return![];const _0x518fba=VisuMZ[_0x3715f7(0x1e9)][_0x3715f7(0x607)]['HpGauge'];if(_0x518fba['RequiresDefeat']){if(_0x3715f7(0x9e0)===_0x3715f7(0x81c)){if(this['_battleLayoutStyle'])return this['_battleLayoutStyle'];return this[_0x3715f7(0x534)]=_0x29bee3[_0x3715f7(0x3c3)]['battleLayoutStyle'](),this[_0x3715f7(0x534)];}else{if(_0x518fba['BTestBypass']&&BattleManager[_0x3715f7(0xae5)]())return!![];if(this['_battler'][_0x3715f7(0x4f4)])return![];return this[_0x3715f7(0xbed)][_0x3715f7(0x5bc)]();}}return!![];},VisuMZ['BattleCore'][_0xfd5ed1(0x812)]=Sprite_Battler[_0xfd5ed1(0x263)]['isMoving'],Sprite_Battler['prototype'][_0xfd5ed1(0xb28)]=function(){const _0x445172=_0xfd5ed1;if(!this[_0x445172(0xbed)])return![];return VisuMZ['BattleCore'][_0x445172(0x812)]['call'](this);},VisuMZ['BattleCore'][_0xfd5ed1(0xb3d)]=Sprite_Battler[_0xfd5ed1(0x263)]['startMove'],Sprite_Battler[_0xfd5ed1(0x263)][_0xfd5ed1(0x94f)]=function(_0x3465e4,_0x388744,_0xb7e021){const _0x38660b=_0xfd5ed1;this[_0x38660b(0x695)]()&&VisuMZ[_0x38660b(0x1e9)]['Sprite_Battler_startMove'][_0x38660b(0x740)](this,_0x3465e4,_0x388744,_0xb7e021);},Sprite_Battler[_0xfd5ed1(0x263)][_0xfd5ed1(0x695)]=function(){const _0x421943=_0xfd5ed1;if(this['_battler']&&this[_0x421943(0xbed)][_0x421943(0x7b0)]())return![];if(this[_0x421943(0xbed)]&&!this['_battler'][_0x421943(0x360)]())return![];return $gameSystem[_0x421943(0xb27)]();},Sprite_Battler[_0xfd5ed1(0x263)]['stepForward']=function(){},Sprite_Battler['prototype'][_0xfd5ed1(0x3cc)]=function(){const _0x3a4609=_0xfd5ed1;this[_0x3a4609(0x94f)](0x0,0x0,0xc);},Sprite_Battler[_0xfd5ed1(0x263)][_0xfd5ed1(0x7ec)]=function(){},Sprite_Battler[_0xfd5ed1(0x263)]['stepFlinch']=function(){const _0x3ef0d2=_0xfd5ed1,_0x4eb262=VisuMZ[_0x3ef0d2(0x1e9)][_0x3ef0d2(0x607)][_0x3ef0d2(0xbdf)],_0x29e5ab=this[_0x3ef0d2(0xbed)]&&this[_0x3ef0d2(0xbed)][_0x3ef0d2(0x75b)]()?0x1:-0x1,_0x4ee078=this['_baseX']-this[_0x3ef0d2(0xb80)]+_0x29e5ab*_0x4eb262[_0x3ef0d2(0x491)],_0x41a60a=this[_0x3ef0d2(0x579)]-this[_0x3ef0d2(0x79b)]+_0x29e5ab*_0x4eb262[_0x3ef0d2(0x262)],_0x31f296=_0x4eb262[_0x3ef0d2(0x2e8)];this[_0x3ef0d2(0x94f)](_0x4ee078,_0x41a60a,_0x31f296);},VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0x71f)]=Sprite_Actor[_0xfd5ed1(0x263)][_0xfd5ed1(0x218)],Sprite_Actor[_0xfd5ed1(0x263)][_0xfd5ed1(0x218)]=function(){const _0x15d2e8=_0xfd5ed1;VisuMZ[_0x15d2e8(0x1e9)][_0x15d2e8(0x71f)][_0x15d2e8(0x740)](this),this[_0x15d2e8(0xb8d)]();},Sprite_Actor['prototype'][_0xfd5ed1(0xb9f)]=function(){const _0xa00b6b=_0xfd5ed1;return this[_0xa00b6b(0x858)]||this[_0xa00b6b(0x798)]||this;},VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0xb4c)]=Sprite_Actor[_0xfd5ed1(0x263)][_0xfd5ed1(0x390)],Sprite_Actor[_0xfd5ed1(0x263)][_0xfd5ed1(0x390)]=function(){},Sprite_Actor['prototype'][_0xfd5ed1(0xa4a)]=function(_0x1d76b7){const _0x21efcf=_0xfd5ed1;if(SceneManager[_0x21efcf(0x957)]())return;if(!_0x1d76b7)return;if(!_0x1d76b7[_0x21efcf(0x695)]())return;VisuMZ['BattleCore'][_0x21efcf(0xb4c)]['call'](this);},VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0x1af)]=Sprite_Actor['prototype'][_0xfd5ed1(0xb34)],Sprite_Actor['prototype'][_0xfd5ed1(0xb34)]=function(_0x52c902){const _0x1c1158=_0xfd5ed1;if(VisuMZ[_0x1c1158(0x1e9)]['Settings']['Actor'][_0x1c1158(0x533)]){if(_0x1c1158(0x3c1)===_0x1c1158(0x8b3)){const _0x27f72a=_0xd6e2a7['makeDeepCopy'](_0x398ea7);_0x27f72a['missed']=![],_0x27f72a['evaded']=![],_0x27f72a[_0x1c1158(0x929)]=![],this[_0x1c1158(0x24b)]['push'](_0x27f72a);}else VisuMZ[_0x1c1158(0x1e9)][_0x1c1158(0x607)][_0x1c1158(0xbdf)]['HomePosJS'][_0x1c1158(0x740)](this,_0x52c902);}else VisuMZ[_0x1c1158(0x1e9)][_0x1c1158(0x1af)][_0x1c1158(0x740)](this,_0x52c902);},VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0x6cd)]=Sprite_Actor[_0xfd5ed1(0x263)][_0xfd5ed1(0xac4)],Sprite_Actor[_0xfd5ed1(0x263)]['setBattler']=function(_0x5ed77c){const _0x2a447e=_0xfd5ed1;VisuMZ['BattleCore'][_0x2a447e(0x6cd)][_0x2a447e(0x740)](this,_0x5ed77c),this[_0x2a447e(0x732)](_0x5ed77c);},Sprite_Actor[_0xfd5ed1(0x263)][_0xfd5ed1(0x732)]=function(_0x229bf9){const _0x29b628=_0xfd5ed1;if(!_0x229bf9)return;if(!this['_mainSprite'])return;this[_0x29b628(0x798)][_0x29b628(0x266)]['x']=this[_0x29b628(0x4b9)][_0x29b628(0xba3)](),this[_0x29b628(0x798)]['anchor']['y']=this[_0x29b628(0x4b9)]['svBattlerAnchorY'](),this['updateShadowVisibility']();},VisuMZ['BattleCore'][_0xfd5ed1(0x3f2)]=Sprite_Actor[_0xfd5ed1(0x263)][_0xfd5ed1(0x840)],Sprite_Actor['prototype']['update']=function(){const _0x153fd6=_0xfd5ed1;VisuMZ['BattleCore'][_0x153fd6(0x3f2)]['call'](this),this[_0x153fd6(0x4b9)]&&(_0x153fd6(0x821)==='vGsto'?this[_0x153fd6(0x58f)](0x1):(this[_0x153fd6(0xa0a)](),this['updateStyleOpacity']()));},VisuMZ['BattleCore']['Sprite_Actor_updateBitmap']=Sprite_Actor[_0xfd5ed1(0x263)][_0xfd5ed1(0x1e2)],Sprite_Actor['prototype'][_0xfd5ed1(0x1e2)]=function(){const _0x2d49bc=_0xfd5ed1;VisuMZ['BattleCore'][_0x2d49bc(0x476)][_0x2d49bc(0x740)](this);if(this['_mainSprite']&&this[_0x2d49bc(0x798)]['bitmap']&&this[_0x2d49bc(0xbed)]){if(_0x2d49bc(0xaf2)!==_0x2d49bc(0xaf2)){if(!this[_0x2d49bc(0x919)]())return;if(!this[_0x2d49bc(0x359)])this[_0x2d49bc(0x23b)]();this[_0x2d49bc(0x543)](),this[_0x2d49bc(0xa0e)]();}else{if(this['_mainSprite'][_0x2d49bc(0x86e)][_0x2d49bc(0x8d6)]!==this[_0x2d49bc(0xbed)][_0x2d49bc(0xb46)]()){if(_0x2d49bc(0x2c3)!==_0x2d49bc(0x955))this[_0x2d49bc(0x798)][_0x2d49bc(0x86e)]['smooth']=this[_0x2d49bc(0xbed)][_0x2d49bc(0xb46)]();else return _0x972ded[_0x2d49bc(0x263)]['isFlipped']();}}}},VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0xb2c)]=Sprite_Actor[_0xfd5ed1(0x263)][_0xfd5ed1(0x43b)],Sprite_Actor[_0xfd5ed1(0x263)][_0xfd5ed1(0x43b)]=function(){const _0x3407a8=_0xfd5ed1;VisuMZ[_0x3407a8(0x1e9)][_0x3407a8(0xb2c)][_0x3407a8(0x740)](this),this[_0x3407a8(0xa91)]();},Sprite_Actor[_0xfd5ed1(0x263)][_0xfd5ed1(0xa91)]=function(){const _0x27f594=_0xfd5ed1;if(!this[_0x27f594(0x798)])return;if(!this[_0x27f594(0xbe4)])return;this[_0x27f594(0xafc)](),this[_0x27f594(0x630)]();},Sprite_Actor[_0xfd5ed1(0x263)][_0xfd5ed1(0xa0a)]=function(){const _0x921db9=_0xfd5ed1;this['_stateSprite']['scale']['x']=0x1/(this['scale']['x']||0.001),this[_0x921db9(0x1ff)][_0x921db9(0x603)]['y']=0x1/(this[_0x921db9(0x603)]['y']||0.001);},Sprite_Actor[_0xfd5ed1(0x263)][_0xfd5ed1(0x8a3)]=function(){const _0x50c9e4=_0xfd5ed1;if(!$gameSystem['isSideView']()&&this['constructor']===Sprite_Actor){const _0x2deae5=Scene_Battle['prototype'][_0x50c9e4(0xb2d)]();[_0x50c9e4(0x702),'list',_0x50c9e4(0x1fe),_0x50c9e4(0x9cf)][_0x50c9e4(0x4b6)](_0x2deae5)&&(this[_0x50c9e4(0x9ac)]=0x0);}},Sprite_Actor[_0xfd5ed1(0x263)][_0xfd5ed1(0x999)]=function(){const _0x1d4868=_0xfd5ed1,_0x510ef2=this[_0x1d4868(0x4b9)];if(_0x510ef2){const _0x21aa26=_0x510ef2[_0x1d4868(0x560)]();if(_0x510ef2['isInputting']()||_0x510ef2[_0x1d4868(0x9fe)]())this[_0x1d4868(0x74b)]('walk');else{if(_0x21aa26===0x3)_0x1d4868(0x434)===_0x1d4868(0x434)?this[_0x1d4868(0x74b)](_0x1d4868(0x626)):(this[_0x1d4868(0x182)](_0x385135)?this[_0x1d4868(0xae2)]()['addChild'](_0x210c18):this['_animationContainer'][_0x1d4868(0x3d8)](_0x5c2de3),this['_animationSprites'][_0x1d4868(0xbc8)](_0x21d2be));else{if(_0x21aa26===0x2)this[_0x1d4868(0x74b)](_0x1d4868(0x9e1));else{if(this[_0x1d4868(0xb12)])'tReeI'===_0x1d4868(0x751)?this[_0x1d4868(0x74b)](_0x1d4868(0x877)):_0x494d92['isTpb']()?(this[_0x1d4868(0x62c)](),this[_0x1d4868(0x37b)]()):_0x25492a[_0x1d4868(0x1e9)][_0x1d4868(0x727)][_0x1d4868(0x740)](this);else{if(_0x510ef2[_0x1d4868(0xb56)]())this[_0x1d4868(0x74b)](_0x1d4868(0x3f7));else{if(_0x510ef2[_0x1d4868(0x9cc)]())this['startMotion'](_0x1d4868(0x55c));else{if(_0x510ef2[_0x1d4868(0x550)]()||_0x510ef2[_0x1d4868(0x4fc)]()){if('lfzrb'!=='lfzrb'){const _0x498574=_0x227391[_0x1d4868(0x753)]['Settings'][_0x1d4868(0x189)];_0x498574&&_0x498574['ActionEndUpdate']===![]&&this['removeStatesAuto'](0x1);}else this[_0x1d4868(0x74b)](_0x1d4868(0xa24));}else{if(_0x21aa26===0x1)_0x1d4868(0x9f7)!=='Pbdzu'?(_0x59b565=_0x210381[_0x1d4868(0x797)](/\x1I\[(\d+)\]/gi,''),_0x51d9d8=_0x5dd916[_0x1d4868(0x797)](/\\I\[(\d+)\]/gi,'')):this[_0x1d4868(0x74b)]('abnormal');else{if(_0x510ef2['isDying']())_0x1d4868(0xb88)!==_0x1d4868(0x6c3)?this['startMotion'](_0x1d4868(0x4e8)):this['opacity']=0x0;else{if(_0x510ef2[_0x1d4868(0x439)]())this[_0x1d4868(0x74b)]('walk');else _0x510ef2[_0x1d4868(0xab8)]()?this[_0x1d4868(0x74b)]('wait'):this[_0x1d4868(0x74b)](_0x1d4868(0xa89));}}}}}}}}}}},Sprite_Actor[_0xfd5ed1(0x263)][_0xfd5ed1(0x7ec)]=function(){const _0x572f59=_0xfd5ed1,_0x266fd5=0xa,_0x4b7316=0x12c*_0x266fd5,_0x2aad83=0x1e*_0x266fd5;this[_0x572f59(0x94f)](_0x4b7316,0x0,_0x2aad83);},Sprite_Actor[_0xfd5ed1(0x263)][_0xfd5ed1(0x420)]=function(){const _0x372879=_0xfd5ed1;Sprite_Battler['prototype'][_0x372879(0x420)][_0x372879(0x740)](this);},Sprite_Actor[_0xfd5ed1(0x263)][_0xfd5ed1(0xa53)]=function(){const _0x574f74=_0xfd5ed1;return Sprite_Battler[_0x574f74(0x502)];},Sprite_Weapon[_0xfd5ed1(0x263)][_0xfd5ed1(0x945)]=function(){const _0x3eab8b=_0xfd5ed1;return Sprite_Battler[_0x3eab8b(0x502)];},Sprite_Actor[_0xfd5ed1(0x263)]['setupMotion']=function(){},Sprite_Actor[_0xfd5ed1(0x263)][_0xfd5ed1(0x710)]=function(){},Sprite_Actor[_0xfd5ed1(0x263)][_0xfd5ed1(0x7b6)]=function(){const _0x3ecab2=_0xfd5ed1;if(this['_motion']&&++this[_0x3ecab2(0x861)]>=this['motionSpeed']()){if(_0x3ecab2(0x782)===_0x3ecab2(0x488)){const _0x56ea0e=_0x2394ef[_0x2622a9];_0x56ea0e&&_0x43312d[_0x3ecab2(0x601)](_0x8b5b0f);}else{if(this[_0x3ecab2(0x81b)][_0x3ecab2(0x636)]){if(_0x3ecab2(0x6b7)===_0x3ecab2(0x33f)){let _0x43d08e=_0x49a583[_0x3ecab2(0x1e9)][_0x3ecab2(0x829)][_0x3ecab2(0x740)](this);return this[_0x3ecab2(0x49b)]&&(_0x43d08e*=this['expRate']()),_0xbe4778[_0x3ecab2(0x562)](_0x43d08e);}else this[_0x3ecab2(0x7b9)]=(this[_0x3ecab2(0x7b9)]+0x1)%0x4;}else{if(this['_pattern']<0x2)this[_0x3ecab2(0x7b9)]++;else{if(_0x3ecab2(0x21c)!==_0x3ecab2(0x21c)){_0x205982=_0x235ae7||'',_0x1e97c6=_0x675f4f||'';_0x3e5935===''&&_0x207cfb===''&&(_0x483496=this[_0x3ecab2(0x7d3)][_0x3ecab2(0x8f6)](),_0x223271=this[_0x3ecab2(0xa13)][_0x3ecab2(0x703)]());const _0x46ffbb=_0x193b08[_0x3ecab2(0x4fa)](_0x54be37),_0x3f495e=_0x1dc344[_0x3ecab2(0xa1b)](_0xe7babd);_0x46ffbb[_0x3ecab2(0x561)](this[_0x3ecab2(0x667)][_0x3ecab2(0xa12)](this,this['_back1Sprite'],this['_back2Sprite'],_0x46ffbb,_0x3f495e));}else this[_0x3ecab2(0x999)]();}}this['_motionCount']=0x0;}}},Sprite_Actor[_0xfd5ed1(0x263)]['forceMotion']=function(_0x5c1412){const _0x561329=_0xfd5ed1;if(_0x5c1412===_0x561329(0xb9e))this[_0x561329(0x932)]=!![];if(this[_0x561329(0xbed)]&&this[_0x561329(0xbed)]['isDead']()){this[_0x561329(0x81b)]=Sprite_Actor['MOTIONS']['dead'];return;}const _0x4412da=Sprite_Actor[_0x561329(0x879)][_0x5c1412];this[_0x561329(0x81b)]=_0x4412da,this['_motionCount']=0x0,this[_0x561329(0x7b9)]=0x0;},Sprite_Actor[_0xfd5ed1(0x263)]['forceWeaponAnimation']=function(_0x23d6d5){const _0x2de016=_0xfd5ed1;this[_0x2de016(0x9aa)](),this[_0x2de016(0x34c)][_0x2de016(0xba7)](_0x23d6d5),this[_0x2de016(0x4b9)][_0x2de016(0x909)]();},Sprite_Actor[_0xfd5ed1(0x263)][_0xfd5ed1(0x9aa)]=function(){const _0x261457=_0xfd5ed1;let _0x5fa4b2=-0x10,_0x59e363=this[_0x261457(0x8c6)]*0.5;const _0x2a48ad=/<SIDEVIEW WEAPON OFFSET:[ ]([\+\-]\d+),[ ]([\+\-]\d+)>/i,_0x1bad0c=this[_0x261457(0xbed)][_0x261457(0x5ec)]()[_0x261457(0x3ee)](_0x3a6dae=>_0x3a6dae&&_0x3a6dae[_0x261457(0x80f)][_0x261457(0x9e4)](_0x2a48ad)?Number(RegExp['$1']):0x0),_0x243c1e=this[_0x261457(0xbed)][_0x261457(0x5ec)]()[_0x261457(0x3ee)](_0x33b7c4=>_0x33b7c4&&_0x33b7c4[_0x261457(0x80f)][_0x261457(0x9e4)](_0x2a48ad)?Number(RegExp['$2']):0x0);_0x5fa4b2=_0x1bad0c[_0x261457(0x42c)]((_0x280ebd,_0x1ec125)=>_0x280ebd+_0x1ec125,_0x5fa4b2),_0x59e363=_0x243c1e['reduce']((_0x2cac4a,_0x4bf892)=>_0x2cac4a+_0x4bf892,_0x59e363),this['_weaponSprite']['x']=_0x5fa4b2,this[_0x261457(0x34c)]['y']=_0x59e363,this['_weaponSprite']['update']();},Sprite_Weapon[_0xfd5ed1(0x263)][_0xfd5ed1(0xba7)]=function(_0x2d3972){const _0x215ee2=_0xfd5ed1;this[_0x215ee2(0x9a6)]=_0x2d3972,this[_0x215ee2(0x350)]=-0x1,this['_pattern']=0x0,this['loadBitmap'](),this[_0x215ee2(0x1d9)]();},Sprite_Actor[_0xfd5ed1(0x263)]['updateTargetPosition']=function(){},Sprite_Actor[_0xfd5ed1(0x263)]['stepForward']=function(){const _0x1da6cc=_0xfd5ed1,_0x66d62f=VisuMZ[_0x1da6cc(0x1e9)]['Settings'][_0x1da6cc(0x472)],_0x22eea2=_0x66d62f['StepDistanceX'],_0xf323e2=_0x66d62f['StepDistanceY'],_0x5c6f5e=_0x66d62f['StepDuration'];this['startMove'](-_0x22eea2,-_0xf323e2,_0x5c6f5e);},VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0x891)]=Sprite_Actor[_0xfd5ed1(0x263)][_0xfd5ed1(0x1d9)],Sprite_Actor[_0xfd5ed1(0x263)][_0xfd5ed1(0x1d9)]=function(){const _0x2a2cac=_0xfd5ed1;this[_0x2a2cac(0x3fd)](),VisuMZ[_0x2a2cac(0x1e9)][_0x2a2cac(0x891)][_0x2a2cac(0x740)](this);},Sprite_Actor['prototype']['applyFreezeMotionFrames']=function(){const _0x5c9ed3=_0xfd5ed1;if(this[_0x5c9ed3(0xbed)]&&this[_0x5c9ed3(0xbed)]['_freezeMotionData']){const _0xc27c58=this['_battler']['_freezeMotionData'];this[_0x5c9ed3(0x81b)]=Sprite_Actor['MOTIONS'][_0xc27c58[_0x5c9ed3(0x492)]],this[_0x5c9ed3(0x7b9)]=_0xc27c58[_0x5c9ed3(0x229)];const _0x4e71cd=this[_0x5c9ed3(0x34c)];_0x4e71cd[_0x5c9ed3(0x7f8)](_0xc27c58[_0x5c9ed3(0x875)],_0xc27c58[_0x5c9ed3(0x229)]),this[_0x5c9ed3(0x9aa)]();}},Sprite_Weapon[_0xfd5ed1(0x263)][_0xfd5ed1(0x7f8)]=function(_0x3fecea,_0x1ba757){const _0x475b6b=_0xfd5ed1;this[_0x475b6b(0x9a6)]=_0x3fecea,this[_0x475b6b(0x350)]=-Infinity,this[_0x475b6b(0x7b9)]=_0x1ba757,this[_0x475b6b(0x239)](),this[_0x475b6b(0x1d9)]();},Sprite_Enemy[_0xfd5ed1(0x263)][_0xfd5ed1(0x218)]=function(){const _0x1b250f=_0xfd5ed1;Sprite_Battler[_0x1b250f(0x263)][_0x1b250f(0x218)][_0x1b250f(0x740)](this),this[_0x1b250f(0x688)]=null,this['_appeared']=![],this['_battlerName']='',this[_0x1b250f(0x7ea)]=0x0,this[_0x1b250f(0x5a7)]=null,this['_effectDuration']=0x0,this[_0x1b250f(0x5aa)]=0x0,this['createMainSprite'](),this['createStateIconSprite']();},VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0x9de)]=Sprite_Enemy[_0xfd5ed1(0x263)][_0xfd5ed1(0x840)],Sprite_Enemy[_0xfd5ed1(0x263)][_0xfd5ed1(0x840)]=function(){const _0x18ea5b=_0xfd5ed1;VisuMZ['BattleCore']['Sprite_Enemy_update'][_0x18ea5b(0x740)](this),this[_0x18ea5b(0xafc)]();},Sprite_Enemy[_0xfd5ed1(0x263)][_0xfd5ed1(0xba1)]=function(){const _0x1ef4f4=_0xfd5ed1;this['_mainSprite']=new Sprite(),this[_0x1ef4f4(0x798)]['anchor']['x']=0.5,this['_mainSprite'][_0x1ef4f4(0x266)]['y']=0x1,this[_0x1ef4f4(0x3d8)](this['_mainSprite']),this[_0x1ef4f4(0xb8d)]();},Sprite_Enemy['prototype'][_0xfd5ed1(0xb9f)]=function(){const _0x7c9bc4=_0xfd5ed1;return this[_0x7c9bc4(0x858)]||this[_0x7c9bc4(0x798)]||this;},Sprite_Enemy[_0xfd5ed1(0x263)][_0xfd5ed1(0x239)]=function(_0x199b00){const _0x1910c0=_0xfd5ed1;this['bitmap']=new Bitmap(0x1,0x1);if(this[_0x1910c0(0x9bc)]()){const _0x506cc0=this['_enemy'][_0x1910c0(0xa33)]();this[_0x1910c0(0x86e)]=new Bitmap(_0x506cc0['width'],_0x506cc0[_0x1910c0(0x8c6)]),this['_mainSprite'][_0x1910c0(0x86e)]=new Bitmap(0x1,0x1);}else{if($gameSystem[_0x1910c0(0xb27)]())this['_mainSprite'][_0x1910c0(0x86e)]=ImageManager[_0x1910c0(0x5b9)](_0x199b00),this[_0x1910c0(0x798)][_0x1910c0(0x86e)][_0x1910c0(0x561)](this[_0x1910c0(0x413)][_0x1910c0(0xa12)](this));else{if('puahf'!==_0x1910c0(0xbd7))this[_0x1910c0(0x798)][_0x1910c0(0x86e)]=ImageManager[_0x1910c0(0x1fc)](_0x199b00),this[_0x1910c0(0x798)]['bitmap'][_0x1910c0(0x561)](this[_0x1910c0(0x413)][_0x1910c0(0xa12)](this));else return 0x1;}}},Sprite_Enemy[_0xfd5ed1(0x263)][_0xfd5ed1(0x413)]=function(){const _0x28b1b7=_0xfd5ed1,_0x52847d=this['_mainSprite'][_0x28b1b7(0x86e)];_0x52847d&&(_0x28b1b7(0xb97)!==_0x28b1b7(0x53d)?this['bitmap']=new Bitmap(_0x52847d[_0x28b1b7(0xb4a)],_0x52847d[_0x28b1b7(0x8c6)]):_0x322ffd[_0x28b1b7(0x1e9)][_0x28b1b7(0x40d)][_0x28b1b7(0x740)](this,_0x5a80de));},VisuMZ['BattleCore']['Sprite_Enemy_setHue']=Sprite_Enemy[_0xfd5ed1(0x263)]['setHue'],Sprite_Enemy[_0xfd5ed1(0x263)]['setHue']=function(_0x4f79d3){const _0x23c55b=_0xfd5ed1;this[_0x23c55b(0x798)]&&this[_0x23c55b(0x798)][_0x23c55b(0xb9c)](_0x4f79d3);},VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0xba9)]=Sprite_Enemy[_0xfd5ed1(0x263)]['initVisibility'],Sprite_Enemy[_0xfd5ed1(0x263)][_0xfd5ed1(0x310)]=function(){const _0x2eefad=_0xfd5ed1;if(this[_0x2eefad(0xbcb)]())VisuMZ[_0x2eefad(0x1e9)]['Sprite_Enemy_initVisibility']['call'](this);else{if(_0x2eefad(0x26d)===_0x2eefad(0x26d))this[_0x2eefad(0x802)]=!this['_enemy'][_0x2eefad(0x33d)](),!this[_0x2eefad(0x802)]&&(_0x2eefad(0x24d)===_0x2eefad(0x24d)?this[_0x2eefad(0x9ac)]=0x0:_0x34da12[_0x2eefad(0x2dd)]());else{this[_0x2eefad(0xbbd)]=new _0x45483c();for(let _0x157fca=0x0;_0x157fca<0x9;_0x157fca++){this['_cursorSprite'][_0x2eefad(0x3d8)](new _0x4fbc0d());}this[_0x2eefad(0x2a7)][_0x2eefad(0x3d8)](this['_cursorSprite']);}}},VisuMZ[_0xfd5ed1(0x1e9)]['Sprite_Enemy_updateCollapse']=Sprite_Enemy['prototype'][_0xfd5ed1(0x3c0)],Sprite_Enemy[_0xfd5ed1(0x263)][_0xfd5ed1(0x3c0)]=function(){const _0x59eb8e=_0xfd5ed1;if(this[_0x59eb8e(0xbcb)]())VisuMZ[_0x59eb8e(0x1e9)]['Sprite_Enemy_updateCollapse'][_0x59eb8e(0x740)](this);},Sprite_Enemy['prototype'][_0xfd5ed1(0x1d9)]=function(){const _0x9def85=_0xfd5ed1;Sprite_Battler[_0x9def85(0x263)]['updateFrame'][_0x9def85(0x740)](this);const _0xe461a2=this[_0x9def85(0xb9f)]()||this;if(!_0xe461a2)return;!_0xe461a2[_0x9def85(0x86e)]&&(_0x9def85(0x61a)==='JXtYW'?_0xe461a2[_0x9def85(0x86e)]=new Bitmap(this[_0x9def85(0xb4a)],this[_0x9def85(0x8c6)]):this[_0x9def85(0x74b)](_0x9def85(0x55c)));if(this['_effectType']===_0x9def85(0x666))this[_0x9def85(0x798)][_0x9def85(0x914)](0x0,0x0,this[_0x9def85(0x798)][_0x9def85(0xb4a)],this['_effectDuration']);else{if('ZMKZN'!==_0x9def85(0xb1a)){return _0xf701aa['prototype']['isRightInputMode'][_0x9def85(0x740)](this);;}else _0xe461a2[_0x9def85(0x914)](0x0,0x0,_0xe461a2[_0x9def85(0x86e)][_0x9def85(0xb4a)],this[_0x9def85(0x86e)][_0x9def85(0x8c6)]);}},VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0x4d9)]=Sprite_Enemy[_0xfd5ed1(0x263)][_0xfd5ed1(0x95d)],Sprite_Enemy[_0xfd5ed1(0x263)]['updateBossCollapse']=function(){const _0x12130d=_0xfd5ed1;if(this[_0x12130d(0xbcb)]())VisuMZ[_0x12130d(0x1e9)]['Sprite_Enemy_updateBossCollapse'][_0x12130d(0x740)](this);},Sprite_Enemy[_0xfd5ed1(0x263)][_0xfd5ed1(0xb28)]=function(){const _0x985457=_0xfd5ed1;return Sprite_Battler[_0x985457(0x263)]['isMoving'][_0x985457(0x740)](this);},VisuMZ['BattleCore'][_0xfd5ed1(0x9d2)]=Sprite_Enemy[_0xfd5ed1(0x263)][_0xfd5ed1(0xa0a)],Sprite_Enemy[_0xfd5ed1(0x263)]['updateStateSprite']=function(){const _0x5cb851=_0xfd5ed1;VisuMZ[_0x5cb851(0x1e9)]['Sprite_Enemy_updateStateSprite'][_0x5cb851(0x740)](this),this[_0x5cb851(0x410)]();},Sprite_Enemy[_0xfd5ed1(0x263)][_0xfd5ed1(0x410)]=function(){const _0x3b8582=_0xfd5ed1,_0xf76f=VisuMZ[_0x3b8582(0x1e9)][_0x3b8582(0x607)][_0x3b8582(0x1f5)];if(_0xf76f[_0x3b8582(0x364)]&&!_0xf76f[_0x3b8582(0x27d)]){this['_stateIconSprite']['opacity']=0x0;return;}this['_stateIconSprite']['x']=0x0,this[_0x3b8582(0x5f3)]['x']+=this[_0x3b8582(0xbed)][_0x3b8582(0x590)](),this[_0x3b8582(0x5f3)]['y']=-this[_0x3b8582(0x86e)][_0x3b8582(0x8c6)]-this[_0x3b8582(0x5f3)][_0x3b8582(0x8c6)],this['_stateIconSprite']['y']+=this[_0x3b8582(0xbed)][_0x3b8582(0x342)](),this[_0x3b8582(0x5f3)][_0x3b8582(0x603)]['x']=0x1/(this['scale']['x']||0.001),this[_0x3b8582(0x5f3)][_0x3b8582(0x603)]['y']=0x1/(this[_0x3b8582(0x603)]['y']||0.001),this['hasSvBattler']()&&(_0x3b8582(0x773)!==_0x3b8582(0x773)?(_0x5c4fa0[_0x3b8582(0x263)][_0x3b8582(0xbe5)][_0x3b8582(0x740)](this),this[_0x3b8582(0x4f7)]()):(this[_0x3b8582(0x8c5)]['_stateSprite'][_0x3b8582(0x603)]['x']=-0x1/(this[_0x3b8582(0x603)]['x']||0.001),this['_svBattlerSprite'][_0x3b8582(0x1ff)][_0x3b8582(0x603)]['y']=0x1/(this['scale']['y']||0.001)));},VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0x59f)]=Sprite_Enemy['prototype']['setBattler'],Sprite_Enemy[_0xfd5ed1(0x263)][_0xfd5ed1(0xac4)]=function(_0x341315){const _0x3f1dd7=_0xfd5ed1;VisuMZ['BattleCore']['Sprite_Enemy_setBattler']['call'](this,_0x341315),this[_0x3f1dd7(0xa1e)](_0x341315);},Sprite_Enemy[_0xfd5ed1(0x263)][_0xfd5ed1(0xa1e)]=function(_0x5ef126){const _0xff785=_0xfd5ed1;if(!this[_0xff785(0x8c5)]){if('Glkgr'===_0xff785(0x9ca)){const _0x51949f=_0x1309ae['getDamageStyle'](this['_item']),_0x2a7d76=_0x1307be[_0xff785(0x5da)][_0x51949f];if(!_0x2a7d76)return this[_0xff785(0x423)]();const _0xb03551='DamageType%1'[_0xff785(0x222)](this[_0xff785(0x7f3)][_0xff785(0x42d)]['type']),_0x41c98b=[null,_0x4c6c18['hp'],_0x457373['mp'],_0x42c4fb['hp'],_0x386712['mp'],_0x5ad3d3['hp'],_0x556cdf['mp']][this[_0xff785(0x7f3)][_0xff785(0x42d)][_0xff785(0x4b2)]];return _0x2a7d76[_0xb03551][_0xff785(0x222)](_0x41c98b);}else this[_0xff785(0x8c5)]=new Sprite_SvEnemy(_0x5ef126),this[_0xff785(0xb8d)]();}this[_0xff785(0x8c5)]['setBattler'](_0x5ef126);},Sprite_Enemy[_0xfd5ed1(0x263)][_0xfd5ed1(0x9bc)]=function(){return this['_enemy']&&this['_enemy']['hasSvBattler']();},Sprite_Enemy[_0xfd5ed1(0x263)]['allowCollapse']=function(){const _0x29a458=_0xfd5ed1;return this[_0x29a458(0x9bc)]()?_0x29a458(0x7a2)==='qPVPR'?_0x20c48d:this[_0x29a458(0x688)][_0x29a458(0xbcb)]():!![];},Sprite_Enemy[_0xfd5ed1(0x263)][_0xfd5ed1(0x999)]=function(){const _0x58b992=_0xfd5ed1;if(this['hasSvBattler']()){if('QtlKE'===_0x58b992(0x658))this[_0x58b992(0x8c5)]['refreshMotion']();else return _0x504038['BattleCore'][_0x58b992(0x607)][_0x58b992(0x608)][_0x58b992(0x2b1)][_0x58b992(0x740)](this,_0x2f961f,_0x51cbe0);}},Sprite_Enemy[_0xfd5ed1(0x263)]['forceMotion']=function(_0x5198ce){const _0x4539ea=_0xfd5ed1;if(this[_0x4539ea(0x9bc)]())this['_svBattlerSprite']['forceMotion'](_0x5198ce);},Sprite_Enemy[_0xfd5ed1(0x263)][_0xfd5ed1(0x967)]=function(_0x4a081d){const _0x2076a6=_0xfd5ed1;if(this[_0x2076a6(0x9bc)]())this[_0x2076a6(0x8c5)][_0x2076a6(0x967)](_0x4a081d);},Sprite_Enemy[_0xfd5ed1(0x263)][_0xfd5ed1(0x8a4)]=function(){const _0x2f7957=_0xfd5ed1,_0x5537ae=VisuMZ[_0x2f7957(0x1e9)][_0x2f7957(0x607)][_0x2f7957(0x472)],_0x31bef8=_0x5537ae[_0x2f7957(0x668)],_0x4760e9=_0x5537ae[_0x2f7957(0x68f)],_0x461f03=_0x5537ae[_0x2f7957(0x297)];this[_0x2f7957(0x94f)](_0x31bef8,_0x4760e9,_0x461f03);};function Sprite_SvEnemy(){const _0x1bdc19=_0xfd5ed1;this[_0x1bdc19(0xbe5)](...arguments);}Sprite_SvEnemy[_0xfd5ed1(0x263)]=Object[_0xfd5ed1(0x966)](Sprite_Actor[_0xfd5ed1(0x263)]),Sprite_SvEnemy[_0xfd5ed1(0x263)]['constructor']=Sprite_SvEnemy,Sprite_SvEnemy[_0xfd5ed1(0x263)][_0xfd5ed1(0xbe5)]=function(_0x25603c){const _0x2f65f6=_0xfd5ed1;Sprite_Actor['prototype'][_0x2f65f6(0xbe5)]['call'](this,_0x25603c),this[_0x2f65f6(0x603)]['x']=-0x1,this[_0x2f65f6(0x1ff)][_0x2f65f6(0x603)]['x']=-0x1;},Sprite_SvEnemy[_0xfd5ed1(0x263)][_0xfd5ed1(0xb7e)]=function(){},Sprite_SvEnemy[_0xfd5ed1(0x263)][_0xfd5ed1(0x390)]=function(){},Sprite_SvEnemy[_0xfd5ed1(0x263)][_0xfd5ed1(0xb34)]=function(_0x539c58){},Sprite_SvEnemy['prototype'][_0xfd5ed1(0x43b)]=function(){},Sprite_SvEnemy[_0xfd5ed1(0x263)][_0xfd5ed1(0x630)]=function(){},Sprite_SvEnemy[_0xfd5ed1(0x263)]['updateStateSprite']=function(){const _0x2429fc=_0xfd5ed1;this[_0x2429fc(0x1ff)][_0x2429fc(0x41b)]=![];},Sprite_SvEnemy[_0xfd5ed1(0x263)][_0xfd5ed1(0x1e2)]=function(){const _0x35047c=_0xfd5ed1;Sprite_Battler[_0x35047c(0x263)][_0x35047c(0x1e2)]['call'](this);const _0x1fdb9d=this[_0x35047c(0x4b9)][_0x35047c(0x5fb)]();if(this[_0x35047c(0x276)]!==_0x1fdb9d){if(_0x35047c(0x7c3)===_0x35047c(0x255)){if(!_0x415d9a)return![];return _0x5a9fad[_0x35047c(0x4ea)]()===this[_0x35047c(0x8aa)]();}else this[_0x35047c(0x276)]=_0x1fdb9d,this[_0x35047c(0x798)][_0x35047c(0x86e)]=ImageManager[_0x35047c(0x599)](_0x1fdb9d);}if(this['_mainSprite']&&this[_0x35047c(0x798)]['bitmap']&&this[_0x35047c(0xbed)]){if(_0x35047c(0x43d)!==_0x35047c(0xa68))this[_0x35047c(0x798)][_0x35047c(0x86e)][_0x35047c(0x8d6)]!==this[_0x35047c(0xbed)]['battlerSmoothImage']()&&(this[_0x35047c(0x798)][_0x35047c(0x86e)]['smooth']=this['_battler'][_0x35047c(0xb46)]());else return this[_0x35047c(0xa8b)]()[_0x35047c(0x9d6)](_0x11b47f=>_0x11b47f[_0x35047c(0x81e)]());}},Sprite_SvEnemy[_0xfd5ed1(0x263)][_0xfd5ed1(0x7ec)]=function(){},Sprite_SvEnemy[_0xfd5ed1(0x263)][_0xfd5ed1(0x94f)]=function(_0x176f49,_0x2a3128,_0x59ed93){const _0x282bc4=_0xfd5ed1;if(this[_0x282bc4(0x2da)])this[_0x282bc4(0x2da)][_0x282bc4(0x94f)](_0x176f49,_0x2a3128,_0x59ed93);},Sprite_SvEnemy[_0xfd5ed1(0x263)][_0xfd5ed1(0x999)]=function(){const _0xcf3d0d=_0xfd5ed1,_0x4e54ef=this[_0xcf3d0d(0x4b9)];if(_0x4e54ef){if(_0xcf3d0d(0x614)===_0xcf3d0d(0x614)){const _0x5df1f8=_0x4e54ef[_0xcf3d0d(0x560)]();if(_0x4e54ef[_0xcf3d0d(0x5f2)]()||_0x4e54ef['isActing']())_0xcf3d0d(0x47d)===_0xcf3d0d(0x47d)?this[_0xcf3d0d(0x74b)](_0xcf3d0d(0xa89)):(_0x4ea6a3[_0xcf3d0d(0x1e9)][_0xcf3d0d(0x3a2)][_0xcf3d0d(0x740)](this),this[_0xcf3d0d(0x4ff)](),this[_0xcf3d0d(0x494)]());else{if(_0x5df1f8===0x3){if(_0xcf3d0d(0x2ed)!=='UJbED')this[_0xcf3d0d(0x74b)]('dead');else return _0xf62c7e[_0xcf3d0d(0x1e9)][_0xcf3d0d(0x607)][_0xcf3d0d(0x9bf)][_0xcf3d0d(0x60e)];}else{if(_0x5df1f8===0x2){if('COXZr'===_0xcf3d0d(0x633))this['startMotion'](_0xcf3d0d(0x9e1));else return this[_0xcf3d0d(0xab8)]()&&this[_0xcf3d0d(0xab8)]()[_0xcf3d0d(0x3c7)]()&&!this['currentAction']()[_0xcf3d0d(0x446)]();}else{if(_0x4e54ef[_0xcf3d0d(0x9cc)]())this[_0xcf3d0d(0x74b)]('chant');else{if(_0x4e54ef[_0xcf3d0d(0x550)]()||_0x4e54ef[_0xcf3d0d(0x4fc)]())this[_0xcf3d0d(0x74b)]('guard');else{if(_0x5df1f8===0x1)this[_0xcf3d0d(0x74b)](_0xcf3d0d(0x90f));else{if(_0x4e54ef[_0xcf3d0d(0x9b6)]())this[_0xcf3d0d(0x74b)](_0xcf3d0d(0x4e8));else{if(_0x4e54ef[_0xcf3d0d(0x439)]()){if(_0xcf3d0d(0x6af)===_0xcf3d0d(0x61b)){if(!_0x540615[_0xcf3d0d(0xbb7)]())return;_0x342e9a[_0xcf3d0d(0x1c5)](_0x2902ad,_0x45cbf3);const _0x2306b6=_0x4b4035['getLastPluginCommandInterpreter'](),_0x4a02df=_0x4a44dc[_0xcf3d0d(0x2f6)];if(!_0x2306b6)return;_0x5ea29e['_targetIndex']++,_0x4525c8['_target']=_0x1f1315[_0xcf3d0d(0x377)][_0x2cf7eb[_0xcf3d0d(0xbdc)]]||null,_0x30b086[_0xcf3d0d(0x235)]&&_0x4a02df[_0xcf3d0d(0xa50)]()['trim']()!==_0xcf3d0d(0x183)&&_0x2306b6['command119']([_0x4a02df]);}else this[_0xcf3d0d(0x74b)]('walk');}else _0xcf3d0d(0xb48)===_0xcf3d0d(0x67b)?_0x533b9b=_0x1a53b6:this[_0xcf3d0d(0x74b)](_0x4e54ef[_0xcf3d0d(0xa33)]()['motionIdle']||_0xcf3d0d(0xa89));}}}}}}}}else{_0x7269ff[_0xcf3d0d(0x9e4)](_0x192fdd);const _0x32500c=_0x29be52(_0x3283bb['$1'])[_0xcf3d0d(0x513)](',')[_0xcf3d0d(0x3ee)](_0x43261f=>_0x5be465(_0x43261f)[_0xcf3d0d(0xa50)]()[_0xcf3d0d(0x300)]());_0x56832c=_0x1d72df[_0xcf3d0d(0x504)](_0x32500c);}}},Sprite_SvEnemy[_0xfd5ed1(0x263)][_0xfd5ed1(0xbec)]=function(){const _0x2e6100=_0xfd5ed1;if(this[_0x2e6100(0x2da)]){if('ZOKTX'!==_0x2e6100(0x4e4))_0x247f0e['command119']([_0x172959]);else return this[_0x2e6100(0x2da)][_0x2e6100(0x1f4)]===0x0&&this[_0x2e6100(0x2da)][_0x2e6100(0x771)]===0x0;}else{if('HJuYK'===_0x2e6100(0x395))return!![];else this[_0x2e6100(0x2a7)][_0x2e6100(0x41b)]=![];}},Sprite_SvEnemy[_0xfd5ed1(0x263)][_0xfd5ed1(0xb10)]=function(){},VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0xb36)]=Sprite_Animation[_0xfd5ed1(0x263)]['targetSpritePosition'],Sprite_Animation[_0xfd5ed1(0x263)][_0xfd5ed1(0x205)]=function(_0x26810b){const _0x3a4116=_0xfd5ed1;if(_0x26810b[_0x3a4116(0x858)])return _0x3a4116(0x7af)!=='LFfgq'?this[_0x3a4116(0x4cc)]>0x0:this['targetDistortionSpritePosition'](_0x26810b);else{if(_0x3a4116(0x1c1)==='GAufV')_0x1f0f5f=_0x58c611[_0x3a4116(0x8a5)];else return VisuMZ[_0x3a4116(0x1e9)][_0x3a4116(0xb36)][_0x3a4116(0x740)](this,_0x26810b);}},Sprite_Animation[_0xfd5ed1(0x263)][_0xfd5ed1(0x8cb)]=function(_0x540daa){const _0x2c4eaa=_0xfd5ed1;let _0x5e0e08=_0x540daa['x'],_0x87aa99=_0x540daa['y'],_0x1c919c=_0x540daa[_0x2c4eaa(0x8c6)],_0x101730=_0x540daa[_0x2c4eaa(0x858)][_0x2c4eaa(0x603)]['y'];_0x540daa['x']=_0x540daa['_baseX']+_0x540daa[_0x2c4eaa(0x584)](),_0x540daa['y']=_0x540daa['_baseY']+_0x540daa[_0x2c4eaa(0x4c5)](),_0x540daa['height']*=_0x101730;let _0x453cb7=VisuMZ[_0x2c4eaa(0x1e9)][_0x2c4eaa(0xb36)][_0x2c4eaa(0x740)](this,_0x540daa);return _0x540daa['x']=_0x5e0e08,_0x540daa['y']=_0x87aa99,_0x540daa[_0x2c4eaa(0x8c6)]=_0x1c919c,_0x453cb7;},Sprite_Damage[_0xfd5ed1(0x263)][_0xfd5ed1(0x8e5)]=function(_0x211688){const _0x518a7c=_0xfd5ed1,_0x5a54d8=_0x211688['getNextDamagePopup']()||_0x211688[_0x518a7c(0x809)]();if(_0x5a54d8[_0x518a7c(0x86d)]||_0x5a54d8[_0x518a7c(0xb24)])'EGLTJ'!==_0x518a7c(0x897)?(this[_0x518a7c(0x2d3)]=0x0,this[_0x518a7c(0x19c)]()):(this[_0x518a7c(0x798)][_0x518a7c(0x86e)]=_0x826864[_0x518a7c(0x5b9)](_0x2946b9),this[_0x518a7c(0x798)][_0x518a7c(0x86e)]['addLoadListener'](this[_0x518a7c(0x413)]['bind'](this)));else{if(_0x5a54d8[_0x518a7c(0x929)])_0x518a7c(0x8fc)===_0x518a7c(0x8fc)?(this[_0x518a7c(0x2d3)]=_0x5a54d8['hpDamage']>=0x0?0x0:0x1,this[_0x518a7c(0xbce)](_0x5a54d8[_0x518a7c(0x63a)])):this[_0x518a7c(0x1b8)]();else _0x211688['isAlive']()&&_0x5a54d8[_0x518a7c(0x62d)]!==0x0&&(this[_0x518a7c(0x2d3)]=_0x5a54d8[_0x518a7c(0x62d)]>=0x0?0x2:0x3,this[_0x518a7c(0xbce)](_0x5a54d8[_0x518a7c(0x62d)]));}_0x5a54d8['critical']&&(_0x518a7c(0x87a)===_0x518a7c(0x87a)?this[_0x518a7c(0x3aa)]():(_0x1e6425[_0x518a7c(0x1e9)][_0x518a7c(0x9de)][_0x518a7c(0x740)](this),this['updateShadowVisibility']()));},Sprite_Damage[_0xfd5ed1(0x263)][_0xfd5ed1(0xba7)]=function(_0x34a1f1){},Sprite_Damage['prototype'][_0xfd5ed1(0xbce)]=function(_0x4c9d49){const _0x39a519=_0xfd5ed1;let _0xac9b4b=this[_0x39a519(0x903)](_0x4c9d49);const _0xfc6676=this[_0x39a519(0x264)](),_0x12c89c=Math['floor'](_0xfc6676*0.75);for(let _0x58b01d=0x0;_0x58b01d<_0xac9b4b['length'];_0x58b01d++){if('sHfvL'!==_0x39a519(0x91e)){const _0x164dda=this[_0x39a519(0xa5a)](_0x12c89c,_0xfc6676);_0x164dda[_0x39a519(0x86e)][_0x39a519(0x815)](_0xac9b4b[_0x58b01d],0x0,0x0,_0x12c89c,_0xfc6676,_0x39a519(0x4aa)),_0x164dda['x']=(_0x58b01d-(_0xac9b4b[_0x39a519(0x5b7)]-0x1)/0x2)*_0x12c89c,_0x164dda['dy']=-_0x58b01d;}else this[_0x39a519(0x421)]();}},Sprite_Damage['prototype'][_0xfd5ed1(0x903)]=function(_0x37d36f){const _0x35e5a3=_0xfd5ed1;let _0x4ff421=Math[_0x35e5a3(0xa76)](_0x37d36f)[_0x35e5a3(0x2b7)]();this[_0x35e5a3(0x4e6)]()&&(_0x4ff421=VisuMZ[_0x35e5a3(0x508)](_0x4ff421));const _0x321716=VisuMZ[_0x35e5a3(0x1e9)][_0x35e5a3(0x607)][_0x35e5a3(0x608)];let _0x4b666c='',_0x3132d6='';switch(this[_0x35e5a3(0x2d3)]){case 0x0:_0x4b666c=_0x321716[_0x35e5a3(0x3e9)]||_0x35e5a3(0x7c4),_0x3132d6=TextManager['hp'];if(_0x37d36f===0x0)_0x4b666c='%1';break;case 0x1:_0x4b666c=_0x321716[_0x35e5a3(0x1be)]||_0x35e5a3(0x82f),_0x3132d6=TextManager['hp'];break;case 0x2:_0x4b666c=_0x321716[_0x35e5a3(0x723)]||_0x35e5a3(0x89f),_0x3132d6=TextManager['mp'];break;case 0x3:_0x4b666c=_0x321716[_0x35e5a3(0x52c)]||_0x35e5a3(0x3a1),_0x3132d6=TextManager['mp'];break;}return _0x4b666c[_0x35e5a3(0x222)](_0x4ff421,_0x3132d6)[_0x35e5a3(0x300)]();},Sprite_Damage[_0xfd5ed1(0x263)][_0xfd5ed1(0x4e6)]=function(){const _0x16c0fd=_0xfd5ed1;return Imported[_0x16c0fd(0x768)]?VisuMZ[_0x16c0fd(0x5d4)][_0x16c0fd(0x607)]['QoL'][_0x16c0fd(0x91c)]:![];},Sprite_Damage[_0xfd5ed1(0x263)][_0xfd5ed1(0x3aa)]=function(){const _0x42cff4=_0xfd5ed1,_0x2c746f=VisuMZ['BattleCore'][_0x42cff4(0x607)][_0x42cff4(0x608)];this[_0x42cff4(0x8bc)]=_0x2c746f[_0x42cff4(0x863)]['slice'](0x0),this[_0x42cff4(0x209)]=_0x2c746f['CriticalDuration'];},Sprite_Damage[_0xfd5ed1(0x263)][_0xfd5ed1(0xa32)]=function(_0x4557b8,_0x3507e7){const _0x4b56ad=_0xfd5ed1;this[_0x4b56ad(0x8bc)]=_0x3507e7['flashColor']||[0x0,0x0,0x0,0x0],this[_0x4b56ad(0x8bc)]=JsonEx[_0x4b56ad(0x3dd)](this[_0x4b56ad(0x8bc)]),this['_flashDuration']=_0x3507e7[_0x4b56ad(0x921)]||0x0;const _0x51da06=this[_0x4b56ad(0x264)](),_0x39b2ff=Math['floor'](_0x51da06*0x1e),_0x48a81c=this[_0x4b56ad(0xa5a)](_0x39b2ff,_0x51da06);_0x48a81c['bitmap']['textColor']=ColorManager[_0x4b56ad(0xb1e)](_0x3507e7['textColor']),_0x48a81c[_0x4b56ad(0x86e)][_0x4b56ad(0x815)](_0x4557b8,0x0,0x0,_0x39b2ff,_0x51da06,_0x4b56ad(0x4aa)),_0x48a81c['dy']=0x0;},Sprite_Damage[_0xfd5ed1(0x263)]['setupIconTextPopup']=function(_0x215707,_0x325af2,_0x1792d8){const _0x57949e=_0xfd5ed1,_0x5e4c2a=Math[_0x57949e(0x4d3)](this[_0x57949e(0x264)](),ImageManager[_0x57949e(0x581)]),_0x2cb04c=Math[_0x57949e(0x765)](_0x5e4c2a*0x1e),_0x35945c=this['createChildSprite'](_0x2cb04c,_0x5e4c2a),_0x358947=ImageManager[_0x57949e(0x4c3)]/0x2,_0x2688c0=_0x35945c[_0x57949e(0x86e)][_0x57949e(0x285)](_0x325af2+'\x20');_0x35945c[_0x57949e(0x86e)][_0x57949e(0x8fd)]=ColorManager[_0x57949e(0xb1e)](_0x1792d8['textColor']),_0x35945c[_0x57949e(0x86e)][_0x57949e(0x815)](_0x325af2,_0x358947,0x0,_0x2cb04c-_0x358947,_0x5e4c2a,'center');const _0xe5592b=Math[_0x57949e(0x271)]((_0x5e4c2a-ImageManager[_0x57949e(0x581)])/0x2),_0x37d19b=_0x2cb04c/0x2-ImageManager['iconWidth']-_0x2688c0/0x2+_0x358947/0x2,_0x45110e=ImageManager['loadSystem']('IconSet'),_0x1f4ee5=ImageManager['iconWidth'],_0x53050d=ImageManager[_0x57949e(0x581)],_0x1577bd=_0x215707%0x10*_0x1f4ee5,_0x16a04a=Math[_0x57949e(0x765)](_0x215707/0x10)*_0x53050d;_0x35945c[_0x57949e(0x86e)][_0x57949e(0x637)](_0x45110e,_0x1577bd,_0x16a04a,_0x1f4ee5,_0x53050d,_0x37d19b,_0xe5592b),this[_0x57949e(0x8bc)]=_0x1792d8[_0x57949e(0xb1b)]||[0x0,0x0,0x0,0x0],this['_flashColor']=JsonEx['makeDeepCopy'](this[_0x57949e(0x8bc)]),this['_flashDuration']=_0x1792d8[_0x57949e(0x921)]||0x0,_0x35945c['dy']=0x0;},VisuMZ[_0xfd5ed1(0x1e9)]['Sprite_StateIcon_updateFrame']=Sprite_StateIcon[_0xfd5ed1(0x263)]['updateFrame'],Sprite_StateIcon['prototype'][_0xfd5ed1(0x1d9)]=function(){const _0x3e620a=_0xfd5ed1;VisuMZ[_0x3e620a(0x1e9)][_0x3e620a(0x2fb)][_0x3e620a(0x740)](this),this[_0x3e620a(0x9ac)]=this[_0x3e620a(0xac2)]>0x0?0xff:0x0;},VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0x6a4)]=Sprite_Weapon[_0xfd5ed1(0x263)][_0xfd5ed1(0x239)],Sprite_Weapon['prototype'][_0xfd5ed1(0x239)]=function(){const _0x34857a=_0xfd5ed1;VisuMZ[_0x34857a(0x1e9)]['Sprite_Weapon_loadBitmap'][_0x34857a(0x740)](this);if(this[_0x34857a(0x86e)]){if(_0x34857a(0x842)!=='lbVaA')this[_0x34857a(0x86e)][_0x34857a(0x8d6)]=VisuMZ[_0x34857a(0x1e9)][_0x34857a(0x607)][_0x34857a(0xbdf)][_0x34857a(0xa38)];else return this[_0x34857a(0xac1)]()?this['currentAction']()&&this['currentAction']()[_0x34857a(0x3c7)]()&&!this[_0x34857a(0xab8)]()[_0x34857a(0xb32)]():this[_0x34857a(0xab8)]()&&this[_0x34857a(0xab8)]()['item']()&&!this[_0x34857a(0xab8)]()['isMagicSkill']();}};function Sprite_HpGauge(){this['initialize'](...arguments);}Sprite_HpGauge['prototype']=Object[_0xfd5ed1(0x966)](Sprite_Gauge[_0xfd5ed1(0x263)]),Sprite_HpGauge[_0xfd5ed1(0x263)]['constructor']=Sprite_HpGauge,Sprite_HpGauge['prototype'][_0xfd5ed1(0xbe5)]=function(){const _0x489c5f=_0xfd5ed1;Sprite_Gauge['prototype'][_0x489c5f(0xbe5)][_0x489c5f(0x740)](this);},Sprite_HpGauge[_0xfd5ed1(0x263)][_0xfd5ed1(0x690)]=function(){return 0x0;},Sprite_HpGauge[_0xfd5ed1(0x263)][_0xfd5ed1(0x735)]=function(){const _0x2c3d49=_0xfd5ed1;this['bitmap'][_0x2c3d49(0x3d1)]();const _0x420ade=this['currentValue']();!isNaN(_0x420ade)&&this[_0x2c3d49(0x868)]();};function Sprite_EnemyName(){this['initialize'](...arguments);}Sprite_EnemyName[_0xfd5ed1(0x263)]=Object['create'](Sprite_Name[_0xfd5ed1(0x263)]),Sprite_EnemyName[_0xfd5ed1(0x263)]['constructor']=Sprite_EnemyName,Sprite_EnemyName['prototype'][_0xfd5ed1(0xbe5)]=function(){const _0x5181fc=_0xfd5ed1;Sprite_Name[_0x5181fc(0x263)][_0x5181fc(0xbe5)][_0x5181fc(0x740)](this),this['createAttachedSprites']();},Sprite_EnemyName[_0xfd5ed1(0x263)][_0xfd5ed1(0x218)]=function(){const _0x22af7a=_0xfd5ed1;Sprite_Name[_0x22af7a(0x263)]['initMembers']['call'](this),this[_0x22af7a(0x9ac)]=0x0,this[_0x22af7a(0x1c9)]=null,this[_0x22af7a(0x266)]['x']=0.5,this[_0x22af7a(0x266)]['y']=0x0;},Sprite_EnemyName[_0xfd5ed1(0x263)][_0xfd5ed1(0x4f7)]=function(){const _0x5052ff=_0xfd5ed1;if(VisuMZ['BattleCore'][_0x5052ff(0x607)]['Enemy']['NameAttachStateIcon']){if('cyRJk'!==_0x5052ff(0x4df)){let _0x2f1f89=_0x5052ff(0x342);if(this[_0x5052ff(0x5cb)](_0x2f1f89))return this[_0x5052ff(0x303)][_0x2f1f89];return this[_0x5052ff(0x303)][_0x2f1f89]=this['createBattleUIOffsetY'](this[_0x5052ff(0x279)]()),this[_0x5052ff(0x303)][_0x2f1f89];}else this['_stateIconSprite']=new Sprite_StateIcon(),this[_0x5052ff(0x3d8)](this[_0x5052ff(0x5f3)]);}},Sprite_EnemyName[_0xfd5ed1(0x263)][_0xfd5ed1(0xa96)]=function(){const _0x3a98fc=_0xfd5ed1;return Graphics[_0x3a98fc(0x9c4)];},Sprite_EnemyName[_0xfd5ed1(0x263)][_0xfd5ed1(0x7e1)]=function(){const _0x553a1d=_0xfd5ed1;return this[_0x553a1d(0x4f9)]=this['_lineHeight']||Window_Base['prototype'][_0x553a1d(0x9c1)]()||0x24,this[_0x553a1d(0x4f9)]*0x4;},Sprite_EnemyName[_0xfd5ed1(0x263)][_0xfd5ed1(0x264)]=function(){const _0x3cee32=_0xfd5ed1;return VisuMZ[_0x3cee32(0x1e9)][_0x3cee32(0x607)][_0x3cee32(0x1f5)][_0x3cee32(0xad5)]||$gameSystem['mainFontSize']();},Sprite_EnemyName[_0xfd5ed1(0x263)][_0xfd5ed1(0xbc7)]=function(_0x31a0e9){const _0x7776cd=_0xfd5ed1;this[_0x7776cd(0x1c9)]=_0x31a0e9;},Sprite_EnemyName[_0xfd5ed1(0x263)]['update']=function(){const _0x379fce=_0xfd5ed1;Sprite_Name['prototype'][_0x379fce(0x840)][_0x379fce(0x740)](this),this[_0x379fce(0xb02)](),this[_0x379fce(0x95f)](),this[_0x379fce(0x582)](),this[_0x379fce(0x2e7)]();},Sprite_EnemyName['prototype']['redraw']=function(){const _0x168d34=_0xfd5ed1;this['_cacheTextWidth']=undefined;const _0x56d827=this[_0x168d34(0x452)](),_0x540e92=this[_0x168d34(0xa96)](),_0x1f2553=Window_Base['prototype'][_0x168d34(0x9c1)]();this['setupFont'](),this[_0x168d34(0x86e)][_0x168d34(0x3d1)](),this['bitmap'][_0x168d34(0x815)](_0x56d827,0x0,0x0,_0x540e92,_0x1f2553,_0x168d34(0x4aa));},Sprite_EnemyName['prototype']['updateLink']=function(){const _0x5bf68d=_0xfd5ed1;if(!this[_0x5bf68d(0x1c9)])return;if(this[_0x5bf68d(0xbed)]!==this[_0x5bf68d(0x1c9)][_0x5bf68d(0xbed)]){if('msxCB'!==_0x5bf68d(0xb7b)){const _0x4947a8=this['weapons'](),_0x21f012=_0x4947a8[0x0]?_0x4947a8[0x0]['wtypeId']:0x0;return _0xb3ab87[_0x5bf68d(0x576)][_0x21f012];}else this[_0x5bf68d(0xba7)](this[_0x5bf68d(0x1c9)][_0x5bf68d(0xbed)]);}},Sprite_EnemyName['prototype']['updatePosition']=function(){const _0x3a5e9f=_0xfd5ed1;if(!this[_0x3a5e9f(0x1c9)])return;this[_0x3a5e9f(0x4f9)]=this['_lineHeight']||Window_Base['prototype']['lineHeight'](),this['x']=this[_0x3a5e9f(0x1c9)][_0x3a5e9f(0x6f7)],this['y']=this[_0x3a5e9f(0x1c9)][_0x3a5e9f(0x579)]-this[_0x3a5e9f(0x4f9)]*0.5;const _0xa95013=VisuMZ[_0x3a5e9f(0x1e9)][_0x3a5e9f(0x607)][_0x3a5e9f(0x1f5)];this['x']+=_0xa95013[_0x3a5e9f(0xa10)]||0x0,this['y']+=_0xa95013['NameOffsetY']||0x0;},Sprite_EnemyName[_0xfd5ed1(0x263)]['updateAttachedSprites']=function(){const _0x27b437=_0xfd5ed1;this[_0x27b437(0x1f0)]();},Sprite_EnemyName[_0xfd5ed1(0x263)]['updateStateIconSprite']=function(){const _0x5cb2d6=_0xfd5ed1;if(!this[_0x5cb2d6(0x5f3)])return;this['_battler']!==this[_0x5cb2d6(0x5f3)]['_battler']&&this['_stateIconSprite'][_0x5cb2d6(0xba7)](this[_0x5cb2d6(0xbed)]);const _0xa50b3d=this[_0x5cb2d6(0x4fe)]();this[_0x5cb2d6(0x4f9)]=this[_0x5cb2d6(0x4f9)]||Window_Base[_0x5cb2d6(0x263)][_0x5cb2d6(0x9c1)](),this[_0x5cb2d6(0x5f3)]['x']=Math[_0x5cb2d6(0x271)]((_0xa50b3d+ImageManager[_0x5cb2d6(0x4c3)])/0x2)+0x8,this['_stateIconSprite']['y']=this[_0x5cb2d6(0x4f9)]/0x2;const _0x4dbf6f=VisuMZ[_0x5cb2d6(0x1e9)][_0x5cb2d6(0x607)]['Enemy'];this[_0x5cb2d6(0x5f3)]['x']+=_0x4dbf6f[_0x5cb2d6(0x58c)]||0x0,this[_0x5cb2d6(0x5f3)]['y']+=_0x4dbf6f[_0x5cb2d6(0x986)]||0x0;},Sprite_EnemyName[_0xfd5ed1(0x263)]['updateOpacity']=function(){const _0x39c721=_0xfd5ed1,_0x19323c=this[_0x39c721(0x369)]();if(_0x19323c&&this[_0x39c721(0x9ac)]<0xff){if('oEsDC'===_0x39c721(0x97e))this['opacity']+=0x10;else{const _0x96c2ee=_0x136c38['$1'],_0x577d1e=_0x39c721(0x348)[_0x39c721(0x222)](_0x96c2ee),_0x812885=_0x5e597d['BattleCore'][_0x39c721(0xadb)](_0x2591ed,_0xf09f70);_0x52c0c6[_0x39c721(0x1e9)]['JS'][_0x812885]=new _0x238063(_0x577d1e);}}else!_0x19323c&&this['opacity']>0x0&&(this[_0x39c721(0x9ac)]-=0x10);},Sprite_EnemyName[_0xfd5ed1(0x263)][_0xfd5ed1(0x369)]=function(){const _0x27bf71=_0xfd5ed1;if(this[_0x27bf71(0x61c)]())return![];else{if(!this[_0x27bf71(0xbed)]){if(_0x27bf71(0x293)!==_0x27bf71(0x293))this[_0x27bf71(0x764)]();else return![];}else{if(this['_battler'][_0x27bf71(0x7b0)]())return![];else{if(!this['_battler'][_0x27bf71(0x242)]())return![];else{if(this[_0x27bf71(0x6c2)]())return!![];else{if(this['isAlwaysVisible']())return!![];else{if(this[_0x27bf71(0x60d)]()){if(_0x27bf71(0x331)==='SRdaR')return!![];else this[_0x27bf71(0x6f5)]=!![];}else{if(this[_0x27bf71(0x9ac)]>0x0)return![];}}}}}}}},Sprite_EnemyName[_0xfd5ed1(0x263)][_0xfd5ed1(0x61c)]=function(){const _0x38ab14=_0xfd5ed1;return VisuMZ[_0x38ab14(0x1e9)]['Settings'][_0x38ab14(0x1f5)][_0x38ab14(0x56a)];},Sprite_EnemyName[_0xfd5ed1(0x263)][_0xfd5ed1(0x6c2)]=function(){return![];},Sprite_EnemyName[_0xfd5ed1(0x263)]['isAlwaysVisible']=function(){const _0x26c55d=_0xfd5ed1;return VisuMZ[_0x26c55d(0x1e9)]['Settings'][_0x26c55d(0x1f5)][_0x26c55d(0x2ca)];},Sprite_EnemyName['prototype'][_0xfd5ed1(0x60d)]=function(){const _0xd60711=_0xfd5ed1;if(VisuMZ['BattleCore'][_0xd60711(0x607)][_0xd60711(0x1f5)][_0xd60711(0x5d2)])return this[_0xd60711(0xbed)][_0xd60711(0x4f3)]();else{if(_0xd60711(0x53f)===_0xd60711(0x53f))return SceneManager[_0xd60711(0x3c3)]['_enemyWindow']&&SceneManager['_scene'][_0xd60711(0x7df)][_0xd60711(0x96f)]&&SceneManager[_0xd60711(0x3c3)][_0xd60711(0x7df)][_0xd60711(0x4e2)]['includes'](this[_0xd60711(0xbed)]);else{if(this[_0xd60711(0xbed)]&&this[_0xd60711(0xbed)][_0xd60711(0x7b0)]())return![];if(this['_battler']&&!this[_0xd60711(0xbed)][_0xd60711(0x360)]())return![];return _0x473e71['isSideView']();}}},Sprite_EnemyName[_0xfd5ed1(0x263)][_0xfd5ed1(0x4fe)]=function(){const _0xb9cac9=_0xfd5ed1;if(!this[_0xb9cac9(0xbed)])return 0x0;if(this['_cacheTextWidth'])return this[_0xb9cac9(0x2a4)];const _0x3c9702=this['name']();return this['setupFont'](),this[_0xb9cac9(0x2a4)]=this[_0xb9cac9(0x86e)][_0xb9cac9(0x285)](_0x3c9702)||0x1,this[_0xb9cac9(0x2a4)];},VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0xa45)]=Sprite_Battleback[_0xfd5ed1(0x263)][_0xfd5ed1(0x51c)],Sprite_Battleback['prototype'][_0xfd5ed1(0x51c)]=function(){const _0x47502c=_0xfd5ed1,_0x2b5b74=VisuMZ[_0x47502c(0x1e9)][_0x47502c(0x607)]['Battleback'];if(!_0x2b5b74)return VisuMZ[_0x47502c(0x1e9)][_0x47502c(0xa45)][_0x47502c(0x740)](this);const _0x17b7b0=String(_0x2b5b74[_0x47502c(0x44b)])||'MZ';switch(_0x17b7b0){case'MZ':VisuMZ[_0x47502c(0x1e9)][_0x47502c(0xa45)][_0x47502c(0x740)](this);break;case _0x47502c(0x43e):this['adjustPosition_1for1']();break;case _0x47502c(0xae9):this['adjustPosition_ScaleToFit']();break;case _0x47502c(0x290):this[_0x47502c(0x738)]();break;case _0x47502c(0x9a1):this[_0x47502c(0x392)]();break;}},Sprite_Battleback['prototype'][_0xfd5ed1(0x540)]=function(){const _0x49c99a=_0xfd5ed1;this[_0x49c99a(0xb4a)]=Graphics[_0x49c99a(0xb4a)],this[_0x49c99a(0x8c6)]=Graphics[_0x49c99a(0x8c6)];const _0x2c42c6=0x1;this['scale']['x']=_0x2c42c6,this[_0x49c99a(0x603)]['y']=_0x2c42c6,this['x']=0x0,this['y']=0x0;},Sprite_Battleback[_0xfd5ed1(0x263)]['adjustPosition_ScaleToFit']=function(){const _0x50c419=_0xfd5ed1;this['width']=Graphics['width'],this[_0x50c419(0x8c6)]=Graphics[_0x50c419(0x8c6)];const _0x1ac3c4=this[_0x50c419(0xb4a)]/this['bitmap'][_0x50c419(0xb4a)],_0x1a0081=this[_0x50c419(0x8c6)]/this[_0x50c419(0x86e)]['height'],_0x1c8bd1=Math[_0x50c419(0x4d3)](_0x1ac3c4,_0x1a0081);this['scale']['x']=_0x1c8bd1,this[_0x50c419(0x603)]['y']=_0x1c8bd1,this['x']=(Graphics[_0x50c419(0xb4a)]-this[_0x50c419(0xb4a)])/0x2,this['y']=Graphics[_0x50c419(0x8c6)]-this['height'];},Sprite_Battleback['prototype'][_0xfd5ed1(0x738)]=function(){const _0x359b11=_0xfd5ed1;this[_0x359b11(0xb4a)]=Graphics['width'],this[_0x359b11(0x8c6)]=Graphics['height'];const _0x3096a7=Math[_0x359b11(0x942)](0x1,this[_0x359b11(0xb4a)]/this['bitmap'][_0x359b11(0xb4a)]),_0x2d3bf0=Math['min'](0x1,this['height']/this[_0x359b11(0x86e)][_0x359b11(0x8c6)]),_0x28e6b6=Math['max'](_0x3096a7,_0x2d3bf0);this[_0x359b11(0x603)]['x']=_0x28e6b6,this[_0x359b11(0x603)]['y']=_0x28e6b6,this['x']=(Graphics[_0x359b11(0xb4a)]-this[_0x359b11(0xb4a)])/0x2,this['y']=Graphics[_0x359b11(0x8c6)]-this['height'];},Sprite_Battleback[_0xfd5ed1(0x263)][_0xfd5ed1(0x392)]=function(){const _0x4e7d19=_0xfd5ed1;this['width']=Graphics[_0x4e7d19(0xb4a)],this[_0x4e7d19(0x8c6)]=Graphics['height'];const _0x3a8f4a=Math[_0x4e7d19(0x4d3)](0x1,this['width']/this[_0x4e7d19(0x86e)][_0x4e7d19(0xb4a)]),_0x3dce6e=Math[_0x4e7d19(0x4d3)](0x1,this[_0x4e7d19(0x8c6)]/this[_0x4e7d19(0x86e)][_0x4e7d19(0x8c6)]),_0x11590f=Math['max'](_0x3a8f4a,_0x3dce6e);this[_0x4e7d19(0x603)]['x']=_0x11590f,this[_0x4e7d19(0x603)]['y']=_0x11590f,this['x']=(Graphics[_0x4e7d19(0xb4a)]-this[_0x4e7d19(0xb4a)])/0x2,this['y']=Graphics[_0x4e7d19(0x8c6)]-this[_0x4e7d19(0x8c6)];},Spriteset_Battle[_0xfd5ed1(0x263)][_0xfd5ed1(0x447)]=function(){const _0x41b4a8=_0xfd5ed1;if(!$gameSystem[_0x41b4a8(0xb27)]())return![];return![];},Spriteset_Battle[_0xfd5ed1(0x263)][_0xfd5ed1(0x70c)]=function(){return 0x0;},Spriteset_Battle[_0xfd5ed1(0x263)][_0xfd5ed1(0x230)]=function(){return 0x0;},VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0xbef)]=Spriteset_Battle['prototype'][_0xfd5ed1(0xab9)],Spriteset_Battle[_0xfd5ed1(0x263)][_0xfd5ed1(0xab9)]=function(){const _0x311fec=_0xfd5ed1;VisuMZ['BattleCore']['Spriteset_Battle_createLowerLayer'][_0x311fec(0x740)](this),this[_0x311fec(0x248)](),this[_0x311fec(0x7ae)](),this[_0x311fec(0x3d2)]();},VisuMZ['BattleCore']['Spriteset_Battle_update']=Spriteset_Battle[_0xfd5ed1(0x263)]['update'],Spriteset_Battle['prototype'][_0xfd5ed1(0x840)]=function(){const _0x1dfdeb=_0xfd5ed1;VisuMZ[_0x1dfdeb(0x1e9)][_0x1dfdeb(0x5ea)][_0x1dfdeb(0x740)](this),this[_0x1dfdeb(0x2f4)]();},Spriteset_Battle[_0xfd5ed1(0x263)][_0xfd5ed1(0x248)]=function(){const _0x383781=_0xfd5ed1;this['_weather']=new Weather(),this[_0x383781(0xbe7)][_0x383781(0x3d8)](this[_0x383781(0x917)]);},Spriteset_Battle[_0xfd5ed1(0x263)][_0xfd5ed1(0x2f4)]=function(){const _0x21d394=_0xfd5ed1;this[_0x21d394(0x917)][_0x21d394(0x4b2)]=$gameScreen['weatherType'](),this[_0x21d394(0x917)][_0x21d394(0x28c)]=$gameScreen[_0x21d394(0x8fb)]();},Game_Interpreter[_0xfd5ed1(0x263)][_0xfd5ed1(0x8d1)]=function(_0x52b24e){const _0xc7b57a=_0xfd5ed1;$gameScreen[_0xc7b57a(0x346)](_0x52b24e[0x0],_0x52b24e[0x1],_0x52b24e[0x2]);if(_0x52b24e[0x3])this[_0xc7b57a(0x3f7)](_0x52b24e[0x2]);return!![];},VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0x689)]=Game_Interpreter[_0xfd5ed1(0x263)][_0xfd5ed1(0x541)],Game_Interpreter[_0xfd5ed1(0x263)][_0xfd5ed1(0x541)]=function(_0x4116c4){const _0x96c047=_0xfd5ed1;if(SceneManager[_0x96c047(0xbb7)]()){if(_0x96c047(0x878)===_0x96c047(0x878))return SceneManager[_0x96c047(0x3c3)][_0x96c047(0xb41)][_0x96c047(0x1d1)](_0x4116c4[0x0],_0x4116c4[0x1]),!![];else{if(_0x5410a9[_0x96c047(0x4b0)])return;this[_0x96c047(0x19f)](),this[_0x96c047(0x3ac)](),this['process_VisuMZ_BattleCore_jsFunctions']();}}else return _0x96c047(0x87b)!=='sJrXb'?!this[_0x96c047(0x4bd)]():VisuMZ[_0x96c047(0x1e9)][_0x96c047(0x689)][_0x96c047(0x740)](this,_0x4116c4);},Spriteset_Battle['prototype'][_0xfd5ed1(0x6d4)]=function(_0x7e3bcc,_0x3d7c18){const _0x467fb0=_0xfd5ed1;_0x7e3bcc[_0x467fb0(0x86e)]=_0x3d7c18;},Spriteset_Battle[_0xfd5ed1(0x263)][_0xfd5ed1(0x1d1)]=function(_0x5dc84e,_0x45ca49){const _0xac4d7=_0xfd5ed1;_0x5dc84e=_0x5dc84e||'',_0x45ca49=_0x45ca49||'';_0x5dc84e===''&&_0x45ca49===''&&(_0xac4d7(0x741)===_0xac4d7(0x72a)?this['push'](_0xac4d7(0x592),_0x7caa41,_0x358cbe):(_0x5dc84e=this['_back1Sprite']['battleback1Name'](),_0x45ca49=this[_0xac4d7(0xa13)][_0xac4d7(0x703)]()));const _0x5f210e=ImageManager[_0xac4d7(0x4fa)](_0x5dc84e),_0x468b9e=ImageManager[_0xac4d7(0xa1b)](_0x45ca49);_0x5f210e['addLoadListener'](this[_0xac4d7(0x667)][_0xac4d7(0xa12)](this,this[_0xac4d7(0x7d3)],this['_back2Sprite'],_0x5f210e,_0x468b9e));},Spriteset_Battle['prototype']['updateBattlebackBitmap1']=function(_0x192670,_0x3db7ef,_0x535cea,_0x36d4ed){const _0x4541ff=_0xfd5ed1;_0x36d4ed[_0x4541ff(0x561)](this[_0x4541ff(0x489)][_0x4541ff(0xa12)](this,_0x192670,_0x3db7ef,_0x535cea,_0x36d4ed));},Spriteset_Battle[_0xfd5ed1(0x263)][_0xfd5ed1(0x489)]=function(_0x2d858f,_0x262bb5,_0x3f2d58,_0x40178e){const _0x85c75e=_0xfd5ed1;_0x2d858f[_0x85c75e(0x86e)]=_0x3f2d58,_0x262bb5['bitmap']=_0x40178e,_0x2d858f['adjustPosition'](),_0x262bb5[_0x85c75e(0x51c)]();},VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0x25a)]=Spriteset_Battle[_0xfd5ed1(0x263)][_0xfd5ed1(0x1ae)],Spriteset_Battle[_0xfd5ed1(0x263)][_0xfd5ed1(0x1ae)]=function(){const _0xb9baf0=_0xfd5ed1;VisuMZ[_0xb9baf0(0x1e9)][_0xb9baf0(0x25a)]['call'](this),this['createBattleFieldBattleCore']();},Spriteset_Battle[_0xfd5ed1(0x263)][_0xfd5ed1(0x3b4)]=function(){const _0x1542db=_0xfd5ed1;this[_0x1542db(0x28e)](),this['createAnimationContainer'](),this['createDamageContainer'](),this[_0x1542db(0x32a)]();},Spriteset_Battle['prototype'][_0xfd5ed1(0x28e)]=function(){const _0x45ac84=_0xfd5ed1;this[_0x45ac84(0x728)]=new Sprite(),this[_0x45ac84(0xbe7)][_0x45ac84(0x3d8)](this[_0x45ac84(0x728)]);},Spriteset_Battle[_0xfd5ed1(0x263)][_0xfd5ed1(0x1d2)]=function(){const _0x4ea737=_0xfd5ed1;this[_0x4ea737(0x814)]=new Sprite(),this[_0x4ea737(0xbe7)][_0x4ea737(0x3d8)](this['_animationContainer']);},Spriteset_Battle[_0xfd5ed1(0x263)][_0xfd5ed1(0x6c9)]=function(){const _0x2b0005=_0xfd5ed1;this['_damageContainer']=new Sprite(),this[_0x2b0005(0x387)]['x']=this[_0x2b0005(0xbe7)]['x'],this[_0x2b0005(0x387)]['y']=this[_0x2b0005(0xbe7)]['y'],this[_0x2b0005(0x3d8)](this[_0x2b0005(0x387)]);},Spriteset_Battle[_0xfd5ed1(0x263)][_0xfd5ed1(0x32a)]=function(){const _0x3edb0b=_0xfd5ed1;if(!this[_0x3edb0b(0x447)]())return;this[_0x3edb0b(0x728)][_0x3edb0b(0x603)]['x']=-0x1,this[_0x3edb0b(0x728)]['x']=this[_0x3edb0b(0xbe7)][_0x3edb0b(0xb4a)],this[_0x3edb0b(0x814)][_0x3edb0b(0x603)]['x']=-0x1,this[_0x3edb0b(0x814)]['x']=this[_0x3edb0b(0xbe7)][_0x3edb0b(0xb4a)],this['_damageContainer']['scale']['x']=-0x1,this[_0x3edb0b(0x387)]['x']=this[_0x3edb0b(0xbe7)]['x']+this[_0x3edb0b(0xbe7)][_0x3edb0b(0xb4a)];},Spriteset_Battle['prototype'][_0xfd5ed1(0x5ca)]=function(){const _0x5a2916=_0xfd5ed1;Imported['VisuMZ_0_CoreEngine']&&this[_0x5a2916(0x1fd)]()&&this[_0x5a2916(0x40b)]();const _0x3bdfd7=$gameTroop[_0x5a2916(0xb77)](),_0x3cc88a=[];for(const _0xefaf2b of _0x3bdfd7){if('fhvgP'===_0x5a2916(0x789)){if(_0x446a35[_0x5a2916(0x6d1)]())this['selectNextCommand']();else _0x346d8c[_0x5a2916(0x47b)]()&&_0x101961[_0x5a2916(0x1e9)][_0x5a2916(0x75a)][_0x5a2916(0x740)](this);}else _0x3cc88a[_0x5a2916(0xbc8)](new Sprite_Enemy(_0xefaf2b));}_0x3cc88a[_0x5a2916(0x7f1)](this[_0x5a2916(0x68d)]['bind'](this));for(const _0x55b4a0 of _0x3cc88a){this[_0x5a2916(0x728)][_0x5a2916(0x3d8)](_0x55b4a0);}this[_0x5a2916(0x9d0)]=_0x3cc88a;},Spriteset_Battle['prototype'][_0xfd5ed1(0x96d)]=function(){const _0x3b14ce=_0xfd5ed1;this[_0x3b14ce(0x6a0)]=[];for(let _0x341bd7=0x0;_0x341bd7<$gameParty[_0x3b14ce(0x3b6)]();_0x341bd7++){const _0x10f168=$gameParty['battleMembers']()[_0x341bd7],_0x53a092=new Sprite_Actor();_0x53a092[_0x3b14ce(0xa4a)](_0x10f168),_0x53a092[_0x3b14ce(0xac4)](_0x10f168),_0x53a092[_0x3b14ce(0x840)](),this[_0x3b14ce(0x6a0)][_0x3b14ce(0xbc8)](_0x53a092),this[_0x3b14ce(0x728)][_0x3b14ce(0x3d8)](_0x53a092);}},Spriteset_Battle['prototype']['createAnimationSprite']=function(_0x263d2b,_0x4e1d39,_0x5057b5,_0x3b3da1){const _0x1e7b46=_0xfd5ed1,_0x3deebc=this[_0x1e7b46(0xa5c)](_0x4e1d39),_0x293888=new(_0x3deebc?Sprite_AnimationMV:Sprite_Animation)(),_0x33b48a=this[_0x1e7b46(0x5e8)](_0x263d2b);this[_0x1e7b46(0x49e)](_0x263d2b[0x0])&&(_0x5057b5=!_0x5057b5),_0x293888['targetObjects']=_0x263d2b,_0x293888[_0x1e7b46(0xba7)](_0x33b48a,_0x4e1d39,_0x5057b5,_0x3b3da1),this[_0x1e7b46(0xb79)](_0x293888);},Spriteset_Battle['prototype']['addAnimationSpriteToContainer']=function(_0x51ed10){const _0x219373=_0xfd5ed1;this[_0x219373(0x182)](_0x51ed10)?this['battleStatusWindowAnimationContainer']()['addChild'](_0x51ed10):this[_0x219373(0x814)][_0x219373(0x3d8)](_0x51ed10),this[_0x219373(0x6a2)][_0x219373(0xbc8)](_0x51ed10);},Spriteset_Battle['prototype'][_0xfd5ed1(0x182)]=function(_0x1279a5){const _0x21ef5b=_0xfd5ed1;if(!_0x1279a5)return![];if(!_0x1279a5['_animation'])return![];if(_0x1279a5[_0x21ef5b(0x566)][_0x21ef5b(0x7de)]!==0x0)return![];if(!_0x1279a5[_0x21ef5b(0x888)][0x0])return![];if(_0x1279a5[_0x21ef5b(0x888)][0x0][_0x21ef5b(0x75b)]&&!_0x1279a5[_0x21ef5b(0x888)][0x0][_0x21ef5b(0x75b)]())return![];if($gameSystem[_0x21ef5b(0xb27)]())return![];if(!this[_0x21ef5b(0xae2)]())return![];const _0x267595=Window_BattleStatus[_0x21ef5b(0x263)][_0x21ef5b(0xb2d)]();return[_0x21ef5b(0x1fe),'xp'][_0x21ef5b(0x27e)](_0x267595);},Spriteset_Battle['prototype']['battleStatusWindowAnimationContainer']=function(){const _0x4e21cf=_0xfd5ed1;if(!SceneManager['_scene'])return null;if(!SceneManager[_0x4e21cf(0x3c3)][_0x4e21cf(0x6f2)])return null;if(!SceneManager['_scene'][_0x4e21cf(0x6f2)][_0x4e21cf(0x937)])return null;return SceneManager[_0x4e21cf(0x3c3)][_0x4e21cf(0x6f2)][_0x4e21cf(0x937)];},Spriteset_Battle[_0xfd5ed1(0x263)][_0xfd5ed1(0x5ed)]=function(_0x35fa98){const _0x10a290=_0xfd5ed1;this[_0x10a290(0x90a)](_0x35fa98);for(const _0x16941 of _0x35fa98[_0x10a290(0x888)]){_0x10a290(0x203)==='rMqFa'?this['requestMotion']('dead'):_0x16941['endAnimation']&&_0x16941[_0x10a290(0x214)]();}_0x35fa98[_0x10a290(0x681)]();},Spriteset_Battle[_0xfd5ed1(0x263)]['removeAnimationFromContainer']=function(_0x14a5a5){const _0x1929ea=_0xfd5ed1;this[_0x1929ea(0x6a2)]['remove'](_0x14a5a5);if(this['isAnimationShownOnBattlePortrait'](_0x14a5a5))_0x1929ea(0x953)===_0x1929ea(0x953)?this[_0x1929ea(0xae2)]()[_0x1929ea(0xaec)](_0x14a5a5):_0x49b3f5[_0x1929ea(0xba7)](0x0);else{if(_0x1929ea(0x2f3)!==_0x1929ea(0x2f3)){_0x2a3fb6[_0x1929ea(0x9e4)](/<REGION (\d+) BATTLEBACK(\d+): (.*)>/i);const _0x5bf84d=_0x5e9343(_0x247d05['$1']),_0x53cc48=_0x47dfcf(_0x557513['$2']),_0x2074eb=_0x53cc48===0x1?this[_0x1929ea(0x7c8)]:this[_0x1929ea(0xafd)],_0x50d74b=_0x18600f(_0xa3a0ff['$3']);_0x2074eb[_0x5bf84d]=_0x50d74b;}else this[_0x1929ea(0x814)]['removeChild'](_0x14a5a5);}},VisuMZ['BattleCore']['Spriteset_Battle_updateActors']=Spriteset_Battle[_0xfd5ed1(0x263)][_0xfd5ed1(0x286)],Spriteset_Battle[_0xfd5ed1(0x263)][_0xfd5ed1(0x286)]=function(){const _0x19640f=_0xfd5ed1;VisuMZ[_0x19640f(0x1e9)][_0x19640f(0x701)][_0x19640f(0x740)](this),this[_0x19640f(0x5c0)]();},Spriteset_Battle[_0xfd5ed1(0x263)][_0xfd5ed1(0x5c0)]=function(){const _0x1fd059=_0xfd5ed1;this[_0x1fd059(0x728)][_0x1fd059(0x678)]['sort'](this['compareBattlerSprites'][_0x1fd059(0xa12)](this)),this[_0x1fd059(0xace)]();},Spriteset_Battle[_0xfd5ed1(0x263)][_0xfd5ed1(0x2c8)]=function(_0x58f9a7,_0x12d2d6){const _0x326c59=_0xfd5ed1;if(VisuMZ[_0x326c59(0x1e9)][_0x326c59(0x607)][_0x326c59(0xbdf)]['PrioritySortActors']){if(_0x58f9a7['_battler']&&_0x12d2d6['_battler']){if(_0x58f9a7[_0x326c59(0xbed)][_0x326c59(0x75b)]()&&_0x12d2d6['_battler']['isEnemy']())return 0x1;else{if(_0x12d2d6[_0x326c59(0xbed)]['isActor']()&&_0x58f9a7[_0x326c59(0xbed)][_0x326c59(0x73c)]())return-0x1;}}}if(_0x58f9a7[_0x326c59(0x579)]!==_0x12d2d6[_0x326c59(0x579)]){if('NkHIB'===_0x326c59(0x1d7))return _0x58f9a7['_baseY']-_0x12d2d6[_0x326c59(0x579)];else _0x314a66[_0x326c59(0xbc8)](this[_0x326c59(0x4ea)]()[_0x326c59(0x979)]());}else return _0x12d2d6['spriteId']-_0x58f9a7['spriteId'];},Spriteset_Battle[_0xfd5ed1(0x263)][_0xfd5ed1(0xace)]=function(){const _0x1453a6=_0xfd5ed1;if(!VisuMZ[_0x1453a6(0x1e9)][_0x1453a6(0x607)][_0x1453a6(0xbdf)]['PrioritySortActive'])return;const _0x2317d4=BattleManager[_0x1453a6(0xb9a)];if(_0x2317d4){if(_0x1453a6(0x585)!=='AsNBK')this[_0x1453a6(0x408)]()?delete _0x509a2a[_0x1453a6(0x713)][_0x1453a6(0xb47)]:_0x16b11d[_0x1453a6(0x9ee)](_0x1453a6(0xb47),this['actorCommandCancelTPB'][_0x1453a6(0xa12)](this));else{if(_0x2317d4[_0x1453a6(0x75b)]()&&!$gameSystem['isSideView']())return;const _0x80a7bf=_0x2317d4[_0x1453a6(0x456)]();if(_0x80a7bf&&_0x2317d4['isActor']())this[_0x1453a6(0x728)][_0x1453a6(0x3d8)](_0x80a7bf);}}},Spriteset_Battle[_0xfd5ed1(0x263)][_0xfd5ed1(0x336)]=function(){const _0x14ffb3=_0xfd5ed1;for(const _0x6e3471 of $gameParty[_0x14ffb3(0x6cc)]()){if('razEz'!==_0x14ffb3(0x3e2)){if(!_0x4c07ba[_0x14ffb3(0xbb7)]())return;if(!_0x3232d2[_0x14ffb3(0xb2f)])return;_0x365200[_0x14ffb3(0x1c5)](_0x466c39,_0x37204e);const _0x463595=_0x15dc29[_0x14ffb3(0x2c6)],_0x3fd204=_0x508c53[_0x14ffb3(0xbbf)];if(!_0x463595)return;_0x463595['_battleCoreForcedElements']=_0x3fd204;}else{if(!_0x6e3471)continue;if(!_0x6e3471[_0x14ffb3(0x456)]())continue;_0x6e3471[_0x14ffb3(0x456)]()[_0x14ffb3(0xb12)]=!![],_0x6e3471[_0x14ffb3(0x456)]()[_0x14ffb3(0x7ec)]();}}},Spriteset_Battle[_0xfd5ed1(0x263)]['createUIContainer']=function(){const _0x5310d0=_0xfd5ed1;this['_uiContainer']=new Sprite(),this['_battleField'][_0x5310d0(0x3d8)](this[_0x5310d0(0xbc9)]);},Spriteset_Battle[_0xfd5ed1(0x263)][_0xfd5ed1(0x3d2)]=function(){const _0x307d36=_0xfd5ed1;if(VisuMZ['BattleCore'][_0x307d36(0x607)][_0x307d36(0x1f5)][_0x307d36(0x27d)])return;this[_0x307d36(0x783)]=new Sprite(),this[_0x307d36(0xbc9)][_0x307d36(0x3d8)](this['_enemyNameContainer']);for(const _0x537c17 of this['_enemySprites']){const _0x8e12f0=new Sprite_EnemyName();this['_enemyNameContainer'][_0x307d36(0x3d8)](_0x8e12f0),_0x8e12f0['linkSprite'](_0x537c17);}},Spriteset_Battle[_0xfd5ed1(0x263)][_0xfd5ed1(0x32f)]=function(){return![];},Spriteset_Battle['prototype'][_0xfd5ed1(0xa09)]=function(){const _0x5e1573=_0xfd5ed1;return this['battlerSprites']()[_0x5e1573(0x9d6)](_0x5f3d11=>_0x5f3d11[_0x5e1573(0x445)]());},Spriteset_Battle['prototype'][_0xfd5ed1(0x1c7)]=function(){const _0x283c7d=_0xfd5ed1;return this[_0x283c7d(0xa8b)]()[_0x283c7d(0x9d6)](_0x1dd756=>_0x1dd756[_0x283c7d(0x403)]());},Spriteset_Battle[_0xfd5ed1(0x263)][_0xfd5ed1(0xbea)]=function(){const _0x14948d=_0xfd5ed1;return this[_0x14948d(0xa8b)]()['some'](_0x33f403=>_0x33f403[_0x14948d(0x512)]());},Spriteset_Battle[_0xfd5ed1(0x263)][_0xfd5ed1(0x8ee)]=function(){const _0x49798f=_0xfd5ed1;return this[_0x49798f(0xa8b)]()['some'](_0x4ded96=>_0x4ded96[_0x49798f(0xa97)]());},Spriteset_Battle['prototype'][_0xfd5ed1(0x7b3)]=function(){const _0x29afd4=_0xfd5ed1;return this[_0x29afd4(0xa8b)]()[_0x29afd4(0x9d6)](_0x10f0ad=>_0x10f0ad['isSpinning']());},Spriteset_Battle[_0xfd5ed1(0x263)][_0xfd5ed1(0x323)]=function(){const _0x1fcc4a=_0xfd5ed1;return this[_0x1fcc4a(0xa8b)]()['some'](_0x4eb953=>_0x4eb953['isChangingOpacity']());},VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0x6eb)]=Window_ItemList[_0xfd5ed1(0x263)][_0xfd5ed1(0x83d)],Window_ItemList[_0xfd5ed1(0x263)][_0xfd5ed1(0x83d)]=function(){const _0x4544e4=_0xfd5ed1;if(SceneManager[_0x4544e4(0xbb7)]()){if(_0x4544e4(0x6ff)===_0x4544e4(0x38b))_0x164d83['_scene']['_statusWindow'][_0x4544e4(0xac9)](_0x4e3094);else{if(SceneManager[_0x4544e4(0x3c3)][_0x4544e4(0xb2d)]()===_0x4544e4(0x9cf)){if(_0x4544e4(0x181)!==_0x4544e4(0x3a4))return VisuMZ[_0x4544e4(0x1e9)][_0x4544e4(0x607)][_0x4544e4(0x9bf)][_0x4544e4(0x312)];else _0x21119['_deathStateApplied']=!![],this['makeSuccess'](_0x3176bb);}else{if('pyxZv'!==_0x4544e4(0xb9d))return VisuMZ[_0x4544e4(0x1e9)][_0x4544e4(0x607)][_0x4544e4(0x9bf)][_0x4544e4(0xb1c)];else{const _0x3373c8=_0x25ed30['parse']('['+_0xf3ef49['$1'][_0x4544e4(0x9e4)](/\d+/g)+']');for(const _0x3b9c65 of _0x3373c8){if(!_0x3e18de[_0x4544e4(0x59a)](_0x3b9c65))return![];}return!![];}}}}else return VisuMZ['BattleCore'][_0x4544e4(0x6eb)][_0x4544e4(0x740)](this);},VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0x52b)]=Window_SkillList[_0xfd5ed1(0x263)]['maxCols'],Window_SkillList[_0xfd5ed1(0x263)][_0xfd5ed1(0x83d)]=function(){const _0x248fb3=_0xfd5ed1;if(SceneManager['isSceneBattle']()){if(_0x248fb3(0xb3b)==='RVZMo'){const _0x42c7be=this[_0x248fb3(0x688)]['svBattlerData']();this['bitmap']=new _0x29e1e5(_0x42c7be[_0x248fb3(0xb4a)],_0x42c7be[_0x248fb3(0x8c6)]),this[_0x248fb3(0x798)][_0x248fb3(0x86e)]=new _0x7ee1d6(0x1,0x1);}else{if(SceneManager['_scene']['battleLayoutStyle']()===_0x248fb3(0x9cf))return VisuMZ[_0x248fb3(0x1e9)]['Settings'][_0x248fb3(0x9bf)][_0x248fb3(0x312)];else{if(_0x248fb3(0x531)!==_0x248fb3(0x531)){if(this['parent'])this[_0x248fb3(0x2da)]['startMove'](_0xc2fea1,_0x4b9e56,_0x2b9714);}else return VisuMZ[_0x248fb3(0x1e9)][_0x248fb3(0x607)][_0x248fb3(0x9bf)][_0x248fb3(0xb1c)];}}}else{if('RxqOP'!==_0x248fb3(0x2bf))return VisuMZ[_0x248fb3(0x1e9)]['Window_SkillList_maxCols'][_0x248fb3(0x740)](this);else this['drawGauge']();}},VisuMZ[_0xfd5ed1(0x1e9)]['Window_Options_addGeneralOptions']=Window_Options[_0xfd5ed1(0x263)]['addGeneralOptions'],Window_Options[_0xfd5ed1(0x263)]['addGeneralOptions']=function(){const _0x15a126=_0xfd5ed1;VisuMZ[_0x15a126(0x1e9)][_0x15a126(0x8ab)][_0x15a126(0x740)](this),this[_0x15a126(0x757)](),this['addShowHpGaugeCommand']();},Window_Options[_0xfd5ed1(0x263)][_0xfd5ed1(0x757)]=function(){const _0x352851=_0xfd5ed1;VisuMZ[_0x352851(0x1e9)]['Settings'][_0x352851(0x2d9)]['AddOption']&&(_0x352851(0x836)!==_0x352851(0x8f5)?(this[_0x352851(0x3d7)](),this[_0x352851(0x26a)]()):(_0xd028c0[_0x352851(0x1e9)]['ParseItemNotetags']&&_0x3867f4[_0x352851(0x1e9)][_0x352851(0x8c2)][_0x352851(0x740)](this,_0x5188dd),_0x1938bc[_0x352851(0x1e9)][_0x352851(0x90e)](_0x23050a),_0x172aa7[_0x352851(0x1e9)][_0x352851(0x5f0)](_0x1f75f4)));},Window_Options[_0xfd5ed1(0x263)][_0xfd5ed1(0x3ed)]=function(){const _0x2c2c70=_0xfd5ed1;if(!VisuMZ[_0x2c2c70(0x1e9)][_0x2c2c70(0x607)][_0x2c2c70(0x2d2)]['AddHpGaugeOption'])return;const _0x34fb5b=TextManager['visualHpGauge'],_0x305269=_0x2c2c70(0x853);this[_0x2c2c70(0x93b)](_0x34fb5b,_0x305269);},Window_Options[_0xfd5ed1(0x263)][_0xfd5ed1(0x3d7)]=function(){const _0x4e3464=_0xfd5ed1,_0x29e2a6=TextManager[_0x4e3464(0x2ac)],_0x1f9ef8=_0x4e3464(0x933);this[_0x4e3464(0x93b)](_0x29e2a6,_0x1f9ef8);},Window_Options[_0xfd5ed1(0x263)][_0xfd5ed1(0x26a)]=function(){const _0x1f1b85=_0xfd5ed1,_0xce04bc=TextManager['autoBattleStyle'],_0xfe32dd=_0x1f1b85(0xb8c);this['addCommand'](_0xce04bc,_0xfe32dd);},VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0x320)]=Window_Options['prototype']['statusText'],Window_Options[_0xfd5ed1(0x263)][_0xfd5ed1(0x379)]=function(_0x4a3873){const _0x4d49e8=_0xfd5ed1,_0x2130d6=this[_0x4d49e8(0x94d)](_0x4a3873);if(_0x2130d6===_0x4d49e8(0xb8c)){if(_0x4d49e8(0xa8a)===_0x4d49e8(0x292)){if(!_0x26aaaa)return![];return _0x3d1436[_0x4d49e8(0x31b)]===0x0||_0x2de838[_0x4d49e8(0x31b)]===0x1;}else return this[_0x4d49e8(0x51a)]();}else return VisuMZ[_0x4d49e8(0x1e9)]['Window_Options_statusText'][_0x4d49e8(0x740)](this,_0x4a3873);},Window_Options[_0xfd5ed1(0x263)][_0xfd5ed1(0x51a)]=function(){const _0x793eae=_0xfd5ed1,_0x4f7f98=VisuMZ['BattleCore']['Settings'][_0x793eae(0x2d9)],_0x35ae9a=this['getConfigValue'](_0x793eae(0xb8c));return _0x35ae9a?_0x4f7f98[_0x793eae(0x985)]:_0x4f7f98[_0x793eae(0x80e)];},Window_ShopStatus['prototype']['getItemDamageAmountLabelBattleCore']=function(){const _0xfb2398=_0xfd5ed1,_0x33c904=DataManager[_0xfb2398(0xbac)](this[_0xfb2398(0x7f3)]),_0x394965=VisuMZ[_0xfb2398(0x5da)][_0x33c904];if(!_0x394965)return this[_0xfb2398(0x423)]();const _0x24910f=_0xfb2398(0x59c)['format'](this['_item'][_0xfb2398(0x42d)][_0xfb2398(0x4b2)]),_0xacfc73=[null,TextManager['hp'],TextManager['mp'],TextManager['hp'],TextManager['mp'],TextManager['hp'],TextManager['mp']][this[_0xfb2398(0x7f3)][_0xfb2398(0x42d)][_0xfb2398(0x4b2)]];return _0x394965[_0x24910f][_0xfb2398(0x222)](_0xacfc73);},Window_ShopStatus[_0xfd5ed1(0x263)][_0xfd5ed1(0x5d9)]=function(){const _0x3eefc1=_0xfd5ed1,_0x558229=DataManager[_0x3eefc1(0xbac)](this[_0x3eefc1(0x7f3)]),_0x4b1511=VisuMZ[_0x3eefc1(0x5da)][_0x558229];if(!_0x4b1511)return this[_0x3eefc1(0x296)]();return _0x4b1511['DamageDisplay'][_0x3eefc1(0x740)](this);},VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0x54d)]=Window_PartyCommand[_0xfd5ed1(0x263)]['initialize'],Window_PartyCommand['prototype'][_0xfd5ed1(0xbe5)]=function(_0x2c3258){const _0xaf3251=_0xfd5ed1;VisuMZ[_0xaf3251(0x1e9)][_0xaf3251(0x54d)][_0xaf3251(0x740)](this,_0x2c3258),this[_0xaf3251(0x976)](_0x2c3258);},Window_PartyCommand[_0xfd5ed1(0x263)][_0xfd5ed1(0x976)]=function(_0x57e78a){const _0x55564d=_0xfd5ed1,_0x2d0d01=new Rectangle(0x0,0x0,_0x57e78a[_0x55564d(0xb4a)],_0x57e78a[_0x55564d(0x8c6)]);this[_0x55564d(0x4a5)]=new Window_Base(_0x2d0d01),this[_0x55564d(0x4a5)][_0x55564d(0x9ac)]=0x0,this[_0x55564d(0x3d8)](this[_0x55564d(0x4a5)]),this[_0x55564d(0x6be)]();},Window_PartyCommand[_0xfd5ed1(0x263)][_0xfd5ed1(0x25d)]=function(){const _0x9e3e1b=_0xfd5ed1;Window_Command[_0x9e3e1b(0x263)]['callUpdateHelp']['call'](this);if(this[_0x9e3e1b(0x4a5)])this[_0x9e3e1b(0x6be)]();},Window_PartyCommand['prototype'][_0xfd5ed1(0x6be)]=function(){const _0x1012af=_0xfd5ed1,_0x1257df=this[_0x1012af(0x4a5)];_0x1257df[_0x1012af(0x604)][_0x1012af(0x3d1)]();const _0x2230a2=this[_0x1012af(0x98f)](this[_0x1012af(0xa34)]());if(_0x2230a2===_0x1012af(0x9ec)&&this[_0x1012af(0x5b6)]()>0x0){const _0x239ed2=this[_0x1012af(0x2ef)](this[_0x1012af(0xa34)]());let _0x2d3050=this[_0x1012af(0xb43)](this[_0x1012af(0xa34)]());_0x2d3050=_0x2d3050[_0x1012af(0x797)](/\\I\[(\d+)\]/gi,''),_0x1257df[_0x1012af(0x217)](),this[_0x1012af(0x66c)](_0x2d3050,_0x239ed2),this['commandNameWindowDrawText'](_0x2d3050,_0x239ed2),this[_0x1012af(0x20f)](_0x2d3050,_0x239ed2);}},Window_PartyCommand[_0xfd5ed1(0x263)]['commandNameWindowDrawBackground']=function(_0x5d829c,_0x2f271f){},Window_PartyCommand[_0xfd5ed1(0x263)][_0xfd5ed1(0xa06)]=function(_0x36628e,_0x1e0c6b){const _0x24569f=_0xfd5ed1,_0x5d5ebd=this[_0x24569f(0x4a5)];_0x5d5ebd[_0x24569f(0x815)](_0x36628e,0x0,_0x1e0c6b['y'],_0x5d5ebd['innerWidth'],_0x24569f(0x4aa));},Window_PartyCommand['prototype'][_0xfd5ed1(0x20f)]=function(_0x5b223c,_0x37d4b7){const _0x263459=_0xfd5ed1,_0x4e7011=this[_0x263459(0x4a5)],_0x2a9189=$gameSystem[_0x263459(0x52f)](),_0x213f48=_0x37d4b7['x']+Math[_0x263459(0x765)](_0x37d4b7[_0x263459(0xb4a)]/0x2)+_0x2a9189;_0x4e7011['x']=_0x4e7011[_0x263459(0xb4a)]/-0x2+_0x213f48,_0x4e7011['y']=Math[_0x263459(0x765)](_0x37d4b7[_0x263459(0x8c6)]/0x2);},Window_PartyCommand[_0xfd5ed1(0x263)][_0xfd5ed1(0xa3c)]=function(){const _0x12a3f3=_0xfd5ed1;this['addFightCommand'](),this[_0x12a3f3(0x89d)](),this[_0x12a3f3(0x9b7)](),this[_0x12a3f3(0x4f8)](),this['addEscapeCommand']();},Window_PartyCommand[_0xfd5ed1(0x263)]['addFightCommand']=function(){const _0x2f2b12=_0xfd5ed1,_0x9ec406=this[_0x2f2b12(0x7a1)](),_0x403065=VisuMZ[_0x2f2b12(0x1e9)][_0x2f2b12(0x607)][_0x2f2b12(0x56b)][_0x2f2b12(0x431)],_0x5e5dab=_0x9ec406===_0x2f2b12(0x7e7)?TextManager[_0x2f2b12(0x8d5)]:_0x2f2b12(0xa62)['format'](_0x403065,TextManager[_0x2f2b12(0x8d5)]),_0x4d7c91=this[_0x2f2b12(0x3a6)]();this['addCommand'](_0x5e5dab,'fight',_0x4d7c91);},Window_PartyCommand[_0xfd5ed1(0x263)][_0xfd5ed1(0x3a6)]=function(){return!![];},Window_PartyCommand[_0xfd5ed1(0x263)][_0xfd5ed1(0x89d)]=function(){const _0x1e3747=_0xfd5ed1;if(!this[_0x1e3747(0x48f)]())return;const _0x1f0c56=this[_0x1e3747(0x7a1)](),_0xd424e0=VisuMZ[_0x1e3747(0x1e9)][_0x1e3747(0x607)][_0x1e3747(0x56b)][_0x1e3747(0x818)],_0x217084=_0x1f0c56===_0x1e3747(0x7e7)?TextManager[_0x1e3747(0x251)]:_0x1e3747(0xa62)[_0x1e3747(0x222)](_0xd424e0,TextManager[_0x1e3747(0x251)]),_0x2c315c=this[_0x1e3747(0x5ad)]();this[_0x1e3747(0x93b)](_0x217084,_0x1e3747(0x251),_0x2c315c);},Window_PartyCommand[_0xfd5ed1(0x263)][_0xfd5ed1(0x48f)]=function(){const _0x4d0cc6=_0xfd5ed1;return VisuMZ[_0x4d0cc6(0x1e9)][_0x4d0cc6(0x607)]['PartyCmd'][_0x4d0cc6(0xb3c)];},Window_PartyCommand['prototype'][_0xfd5ed1(0x5ad)]=function(){return!![];},Window_PartyCommand['prototype']['addCustomCommands']=function(){},Window_PartyCommand[_0xfd5ed1(0x263)]['addOptionsCommand']=function(){const _0x561585=_0xfd5ed1;if(!this['isOptionsCommandAdded']())return;const _0x1f80be=this[_0x561585(0x7a1)](),_0xc3f471=VisuMZ[_0x561585(0x1e9)][_0x561585(0x607)][_0x561585(0x56b)][_0x561585(0x612)],_0x1b199a=_0x1f80be==='text'?TextManager[_0x561585(0x1a5)]:_0x561585(0xa62)[_0x561585(0x222)](_0xc3f471,TextManager[_0x561585(0x1a5)]),_0x3b3d99=this[_0x561585(0x19a)]();this['addCommand'](_0x1b199a,_0x561585(0x1a5),_0x3b3d99);},Window_PartyCommand[_0xfd5ed1(0x263)][_0xfd5ed1(0x9f9)]=function(){const _0x1303df=_0xfd5ed1;return VisuMZ['BattleCore']['Settings'][_0x1303df(0x56b)][_0x1303df(0x7cd)];},Window_PartyCommand['prototype'][_0xfd5ed1(0x19a)]=function(){return!![];},Window_PartyCommand[_0xfd5ed1(0x263)][_0xfd5ed1(0x3a9)]=function(){const _0x4424d0=_0xfd5ed1,_0x3fd4da=this[_0x4424d0(0x7a1)](),_0xd8fc79=VisuMZ[_0x4424d0(0x1e9)][_0x4424d0(0x607)][_0x4424d0(0x56b)][_0x4424d0(0x6b0)],_0x406e6f=_0x3fd4da===_0x4424d0(0x7e7)?TextManager[_0x4424d0(0x877)]:'\x5cI[%1]%2'[_0x4424d0(0x222)](_0xd8fc79,TextManager['escape']),_0x366570=this[_0x4424d0(0x259)]();this[_0x4424d0(0x93b)](_0x406e6f,_0x4424d0(0x877),_0x366570);},Window_PartyCommand[_0xfd5ed1(0x263)][_0xfd5ed1(0x259)]=function(){const _0x5513ea=_0xfd5ed1;return BattleManager[_0x5513ea(0x7f2)]();},Window_PartyCommand[_0xfd5ed1(0x263)][_0xfd5ed1(0x4ed)]=function(){const _0x4af303=_0xfd5ed1;return VisuMZ[_0x4af303(0x1e9)][_0x4af303(0x607)][_0x4af303(0x56b)][_0x4af303(0x887)];},Window_PartyCommand['prototype'][_0xfd5ed1(0x20d)]=function(_0x24c442){const _0x5527d9=_0xfd5ed1,_0xb310f1=this[_0x5527d9(0x98f)](_0x24c442);if(_0xb310f1==='iconText')_0x5527d9(0x97a)==='uUjac'?(_0x5f5740[_0x5527d9(0x8f6)]||_0xac16e0[_0x5527d9(0x703)])&&_0x470397[_0x5527d9(0x55a)]():this[_0x5527d9(0x857)](_0x24c442);else{if(_0xb310f1===_0x5527d9(0x9ec)){if(_0x5527d9(0x3ef)!==_0x5527d9(0x615))this[_0x5527d9(0x5af)](_0x24c442);else return!![];}else{if(_0x5527d9(0x5c7)===_0x5527d9(0x5c7))Window_Command[_0x5527d9(0x263)][_0x5527d9(0x20d)][_0x5527d9(0x740)](this,_0x24c442);else{if(!this[_0x5527d9(0x4b9)][_0x5527d9(0x8f4)](_0x43fb77['id']))return![];}}}},Window_PartyCommand[_0xfd5ed1(0x263)][_0xfd5ed1(0x7a1)]=function(){const _0x398199=_0xfd5ed1;return VisuMZ['BattleCore'][_0x398199(0x607)][_0x398199(0x56b)][_0x398199(0xa31)];},Window_PartyCommand[_0xfd5ed1(0x263)][_0xfd5ed1(0x98f)]=function(_0x3f260c){const _0x4bd2d2=_0xfd5ed1;if(_0x3f260c<0x0)return _0x4bd2d2(0x7e7);const _0x1555b5=this[_0x4bd2d2(0x7a1)]();if(_0x1555b5!==_0x4bd2d2(0xb5e)){if(_0x4bd2d2(0x463)!==_0x4bd2d2(0x463)){this[_0x4bd2d2(0xb43)](_0x557eef)[_0x4bd2d2(0x9e4)](/\\I\[(\d+)\]/i);const _0x1ff1de=_0xa3ca50(_0x3331d0['$1'])||0x0,_0x356f9f=this[_0x4bd2d2(0x2ef)](_0x3a92fd),_0x10734d=_0x356f9f['x']+_0x57d44a['floor']((_0x356f9f[_0x4bd2d2(0xb4a)]-_0xbc9a3b['iconWidth'])/0x2),_0x4033d3=_0x356f9f['y']+(_0x356f9f[_0x4bd2d2(0x8c6)]-_0x425c60[_0x4bd2d2(0x581)])/0x2;this['drawIcon'](_0x1ff1de,_0x10734d,_0x4033d3);}else return _0x1555b5;}else{if(this[_0x4bd2d2(0x5b6)]()>0x0){if(_0x4bd2d2(0x330)===_0x4bd2d2(0x983))this[_0x4bd2d2(0xbc8)](_0x4bd2d2(0x6bf),_0x5c46a5);else{const _0x611b27=this[_0x4bd2d2(0xb43)](_0x3f260c);if(_0x611b27[_0x4bd2d2(0x9e4)](/\\I\[(\d+)\]/i)){if(_0x4bd2d2(0x6a3)!=='RsvkP')this['_defeatedEnemies']=this[_0x4bd2d2(0x433)]||[];else{const _0x459147=this[_0x4bd2d2(0x2ef)](_0x3f260c),_0x5906ca=this[_0x4bd2d2(0x22a)](_0x611b27)[_0x4bd2d2(0xb4a)];if(_0x5906ca<=_0x459147['width']){if(_0x4bd2d2(0x964)!=='QUvXz'){const _0x435a5c=_0x30a05d[_0x4bd2d2(0xbac)](this[_0x4bd2d2(0x7f3)]),_0x480eba=_0x431c69[_0x4bd2d2(0x5da)][_0x435a5c];if(!_0x480eba)return this[_0x4bd2d2(0x296)]();return _0x480eba[_0x4bd2d2(0x528)]['call'](this);}else return'iconText';}else{if(_0x4bd2d2(0x9a4)===_0x4bd2d2(0x1ee))this[_0x4bd2d2(0xbe5)](...arguments);else return _0x4bd2d2(0x9ec);}}}}}}return _0x4bd2d2(0x7e7);},Window_PartyCommand['prototype'][_0xfd5ed1(0x857)]=function(_0x5161c9){const _0x2e74fe=_0xfd5ed1,_0x193dca=this[_0x2e74fe(0x2ef)](_0x5161c9),_0x305a4d=this[_0x2e74fe(0xb43)](_0x5161c9),_0x38c551=this[_0x2e74fe(0x22a)](_0x305a4d)[_0x2e74fe(0xb4a)];this[_0x2e74fe(0x649)](this['isCommandEnabled'](_0x5161c9));const _0x17c531=this[_0x2e74fe(0x4ed)]();if(_0x17c531==='right')this[_0x2e74fe(0x4bf)](_0x305a4d,_0x193dca['x']+_0x193dca['width']-_0x38c551,_0x193dca['y'],_0x38c551);else{if(_0x17c531===_0x2e74fe(0x4aa)){const _0x3845e9=_0x193dca['x']+Math[_0x2e74fe(0x765)]((_0x193dca['width']-_0x38c551)/0x2);this[_0x2e74fe(0x4bf)](_0x305a4d,_0x3845e9,_0x193dca['y'],_0x38c551);}else this[_0x2e74fe(0x4bf)](_0x305a4d,_0x193dca['x'],_0x193dca['y'],_0x38c551);}},Window_PartyCommand[_0xfd5ed1(0x263)][_0xfd5ed1(0x5af)]=function(_0x4aa852){const _0xfeaf31=_0xfd5ed1;this[_0xfeaf31(0xb43)](_0x4aa852)[_0xfeaf31(0x9e4)](/\\I\[(\d+)\]/i);const _0x1629c4=Number(RegExp['$1'])||0x0,_0x488029=this[_0xfeaf31(0x2ef)](_0x4aa852),_0x50a8e4=_0x488029['x']+Math['floor']((_0x488029[_0xfeaf31(0xb4a)]-ImageManager[_0xfeaf31(0x4c3)])/0x2),_0x491e49=_0x488029['y']+(_0x488029['height']-ImageManager['iconHeight'])/0x2;this[_0xfeaf31(0x267)](_0x1629c4,_0x50a8e4,_0x491e49);},Window_PartyCommand[_0xfd5ed1(0x263)][_0xfd5ed1(0x213)]=function(){},Window_PartyCommand[_0xfd5ed1(0x263)][_0xfd5ed1(0x53b)]=function(){const _0x4b9f6b=_0xfd5ed1;Window_Command['prototype'][_0x4b9f6b(0x53b)]['call'](this);const _0x1af3fd=this[_0x4b9f6b(0xb2d)]();_0x1af3fd===_0x4b9f6b(0x9cf)&&this['showHelpWindow']();},Window_PartyCommand[_0xfd5ed1(0x263)][_0xfd5ed1(0xb2d)]=function(){const _0x21c736=_0xfd5ed1;if(this[_0x21c736(0x534)])return this['_battleLayoutStyle'];return this[_0x21c736(0x534)]=SceneManager[_0x21c736(0x3c3)][_0x21c736(0xb2d)](),this[_0x21c736(0x534)];},Window_PartyCommand[_0xfd5ed1(0x263)]['updateHelp']=function(){const _0x126677=_0xfd5ed1,_0x35fb83=VisuMZ[_0x126677(0x1e9)]['Settings'][_0x126677(0x56b)],_0x38abee=this['currentSymbol']();switch(_0x38abee){case'fight':this['_helpWindow'][_0x126677(0xa08)](_0x35fb83[_0x126677(0x47f)]);break;case _0x126677(0x251):this[_0x126677(0x70a)][_0x126677(0xa08)](_0x35fb83[_0x126677(0x272)]);break;case _0x126677(0x1a5):this[_0x126677(0x70a)]['setText'](_0x35fb83[_0x126677(0x578)]);break;case'escape':this[_0x126677(0x70a)]['setText'](_0x35fb83['HelpEscape']);break;default:this[_0x126677(0x70a)]['setText']('');break;}},VisuMZ[_0xfd5ed1(0x1e9)]['Window_ActorCommand_initialize']=Window_ActorCommand[_0xfd5ed1(0x263)]['initialize'],Window_ActorCommand[_0xfd5ed1(0x263)][_0xfd5ed1(0xbe5)]=function(_0x3a82be){const _0x142e63=_0xfd5ed1;VisuMZ[_0x142e63(0x1e9)][_0x142e63(0xb90)][_0x142e63(0x740)](this,_0x3a82be),this['createCommandNameWindow'](_0x3a82be);},Window_ActorCommand['prototype'][_0xfd5ed1(0x976)]=function(_0x5b4867){const _0x278278=_0xfd5ed1,_0x1d3a7c=new Rectangle(0x0,0x0,_0x5b4867[_0x278278(0xb4a)],_0x5b4867[_0x278278(0x8c6)]);this['_commandNameWindow']=new Window_Base(_0x1d3a7c),this[_0x278278(0x4a5)][_0x278278(0x9ac)]=0x0,this['addChild'](this[_0x278278(0x4a5)]),this[_0x278278(0x6be)]();},Window_ActorCommand[_0xfd5ed1(0x263)][_0xfd5ed1(0x25d)]=function(){const _0x12abf6=_0xfd5ed1;Window_Command[_0x12abf6(0x263)][_0x12abf6(0x25d)][_0x12abf6(0x740)](this);if(this[_0x12abf6(0x4a5)])this['updateCommandNameWindow']();},Window_ActorCommand[_0xfd5ed1(0x263)][_0xfd5ed1(0x6be)]=function(){const _0x249743=_0xfd5ed1,_0x39d0b6=this[_0x249743(0x4a5)];_0x39d0b6[_0x249743(0x604)]['clear']();const _0x5045a8=this[_0x249743(0x98f)](this['index']());if(_0x5045a8===_0x249743(0x9ec)&&this[_0x249743(0x5b6)]()>0x0){const _0x21b01f=this[_0x249743(0x2ef)](this[_0x249743(0xa34)]());let _0x188b18=this['commandName'](this[_0x249743(0xa34)]());_0x188b18=_0x188b18[_0x249743(0x797)](/\\I\[(\d+)\]/gi,''),_0x39d0b6[_0x249743(0x217)](),this[_0x249743(0x66c)](_0x188b18,_0x21b01f),this[_0x249743(0xa06)](_0x188b18,_0x21b01f),this['commandNameWindowCenter'](_0x188b18,_0x21b01f);}},Window_ActorCommand[_0xfd5ed1(0x263)][_0xfd5ed1(0x66c)]=function(_0x35def5,_0x41bb){},Window_ActorCommand[_0xfd5ed1(0x263)][_0xfd5ed1(0xa06)]=function(_0x3e025e,_0x1d4499){const _0x484893=_0xfd5ed1,_0x594b4b=this[_0x484893(0x4a5)];_0x594b4b[_0x484893(0x815)](_0x3e025e,0x0,_0x1d4499['y'],_0x594b4b[_0x484893(0x78a)],_0x484893(0x4aa));},Window_ActorCommand[_0xfd5ed1(0x263)]['commandNameWindowCenter']=function(_0x382284,_0x5c46d8){const _0x2d786f=_0xfd5ed1,_0x5568d2=this[_0x2d786f(0x4a5)],_0x270c81=$gameSystem[_0x2d786f(0x52f)](),_0x3fae50=_0x5c46d8['x']+Math['floor'](_0x5c46d8['width']/0x2)+_0x270c81;_0x5568d2['x']=_0x5568d2['width']/-0x2+_0x3fae50,_0x5568d2['y']=Math[_0x2d786f(0x765)](_0x5c46d8[_0x2d786f(0x8c6)]/0x2);},Window_ActorCommand[_0xfd5ed1(0x263)][_0xfd5ed1(0xa3c)]=function(){const _0x4a55c4=_0xfd5ed1;if(!this[_0x4a55c4(0x4b9)])return;const _0x5b6a49=this[_0x4a55c4(0x4b9)][_0x4a55c4(0x35f)]();for(const _0x35cd31 of _0x5b6a49){this[_0x4a55c4(0x7ff)](_0x35cd31[_0x4a55c4(0xa50)]()[_0x4a55c4(0x300)]());}},Window_ActorCommand[_0xfd5ed1(0x263)]['makeBattleCommand']=function(_0x3afef0){const _0x23c05f=_0xfd5ed1;_0x3afef0===_0x23c05f(0xabd)&&this[_0x23c05f(0x351)]();[_0x23c05f(0x3a8),_0x23c05f(0xbc0)][_0x23c05f(0x4b6)](_0x3afef0)&&(_0x23c05f(0x1dd)!==_0x23c05f(0x1dd)?(_0x495844[_0x23c05f(0x1e9)][_0x23c05f(0xb08)][_0x23c05f(0x740)](this,_0xeee1ea,_0x2053e8),this[_0x23c05f(0x385)][this['_actions'][_0x23c05f(0x5b7)]-0x1][_0x23c05f(0xa65)]=!![]):this[_0x23c05f(0x9e5)]());_0x3afef0==='GUARD'&&this['addGuardCommand']();if(_0x3afef0===_0x23c05f(0x406)){if(_0x23c05f(0x8a0)!==_0x23c05f(0x8a0))return!![];else this[_0x23c05f(0x1b8)]();}_0x3afef0==='ESCAPE'&&(_0x23c05f(0xb0a)!=='uFYnR'?this[_0x23c05f(0x3a9)]():this[_0x23c05f(0x798)]&&this[_0x23c05f(0x798)][_0x23c05f(0xb9c)](_0x5bdbad));_0x3afef0===_0x23c05f(0xbe2)&&(_0x23c05f(0x1db)===_0x23c05f(0x718)?(_0x369680+=_0x563e01['isActor']()?-_0x512b45:_0x1f8ed0,_0xfe1fd8+=_0x1ec2a3):this['addAutoBattleCommand']());if(_0x3afef0['match'](/STYPE: (\d+)/i)){const _0x526377=Number(RegExp['$1']);this['addSkillTypeCommand'](_0x526377);}else{if(_0x3afef0['match'](/STYPE: (.*)/i)){if(_0x23c05f(0xbba)!==_0x23c05f(0xbba))return![];else{const _0x3144e7=DataManager[_0x23c05f(0x2c2)](RegExp['$1']);this[_0x23c05f(0x3e4)](_0x3144e7);}}}_0x3afef0===_0x23c05f(0xa92)&&this[_0x23c05f(0x651)]();if(_0x3afef0[_0x23c05f(0x9e4)](/SKILL: (\d+)/i)){if('OxMjJ'==='OxMjJ'){const _0x36bacf=Number(RegExp['$1']);this[_0x23c05f(0x334)]($dataSkills[_0x36bacf]);}else this[_0x23c05f(0xa0a)](),this[_0x23c05f(0x8a3)]();}else{if(_0x3afef0['match'](/SKILL: (.*)/i)){if(_0x23c05f(0x6a7)!=='wIusJ')return this[_0x23c05f(0x3c3)]&&this[_0x23c05f(0x3c3)][_0x23c05f(0x18a)]===_0x3d700d;else{const _0x2e3535=DataManager[_0x23c05f(0x8e3)](RegExp['$1']);this['addSingleSkillCommand']($dataSkills[_0x2e3535]);}}}_0x3afef0==='PARTY'&&Imported[_0x23c05f(0x767)]&&this[_0x23c05f(0xb7f)]();[_0x23c05f(0x873),_0x23c05f(0xb68)][_0x23c05f(0x4b6)](_0x3afef0)&&Imported[_0x23c05f(0x98e)]&&('ENMmD'!==_0x23c05f(0x21e)?_0xf1a3f8+=_0x915898:this[_0x23c05f(0x365)]());if(_0x3afef0==='WEAPON\x20SWAP'&&Imported[_0x23c05f(0xa98)]){if(_0x23c05f(0x68a)!==_0x23c05f(0x68a)){const _0x175fc0=_0x5a826a['note'];if(_0x175fc0[_0x23c05f(0x9e4)](_0x5dd791['BattleCore'][_0x23c05f(0x349)][_0x1ad468])){const _0xa0d281=_0x38ad4f['$1'],_0x8be679=_0x23c05f(0x348)[_0x23c05f(0x222)](_0xa0d281),_0xc601cd=_0x429b36[_0x23c05f(0x1e9)][_0x23c05f(0xadb)](_0x5e1952,_0x14e5de);_0x2a3ff7['BattleCore']['JS'][_0xc601cd]=new _0x52f06b(_0x8be679);}}else this['addWeaponSwapCommand'](!![]);}},Window_ActorCommand[_0xfd5ed1(0x263)][_0xfd5ed1(0x351)]=function(){const _0x387c22=_0xfd5ed1,_0xf15e1=$dataSkills[this[_0x387c22(0x4b9)][_0x387c22(0x6a1)]()];if(!_0xf15e1)return;if(!this[_0x387c22(0xbbc)](_0xf15e1))return;const _0x370b52=this[_0x387c22(0x7a1)](),_0x4b4061=DataManager['battleCommandName'](_0xf15e1),_0x20e14d=DataManager[_0x387c22(0x8eb)](_0xf15e1),_0x608c68=_0x370b52==='text'?_0x4b4061:'\x5cI[%1]%2'[_0x387c22(0x222)](_0x20e14d,_0x4b4061);this[_0x387c22(0x93b)](_0x608c68,_0x387c22(0x8c1),this['_actor'][_0x387c22(0x7bd)]());},Window_ActorCommand[_0xfd5ed1(0x263)]['addGuardCommand']=function(){const _0x578e85=_0xfd5ed1,_0x14aeb6=$dataSkills[this[_0x578e85(0x4b9)][_0x578e85(0x361)]()];if(!_0x14aeb6)return;if(!this['canAddSkillCommand'](_0x14aeb6))return;const _0x54a9eb=this['commandStyle'](),_0x11e1ed=DataManager['battleCommandName'](_0x14aeb6),_0x424b84=DataManager['battleCommandIcon'](_0x14aeb6),_0x4a926b=_0x54a9eb==='text'?_0x11e1ed:_0x578e85(0xa62)[_0x578e85(0x222)](_0x424b84,_0x11e1ed);this[_0x578e85(0x93b)](_0x4a926b,'guard',this[_0x578e85(0x4b9)][_0x578e85(0x992)]());},Window_ActorCommand['prototype']['addItemCommand']=function(){const _0x206a59=_0xfd5ed1,_0x529960=this['commandStyle'](),_0x34a3f2=VisuMZ['BattleCore'][_0x206a59(0x607)][_0x206a59(0xade)][_0x206a59(0x1bd)],_0x5098c8=_0x529960===_0x206a59(0x7e7)?TextManager[_0x206a59(0x3c7)]:_0x206a59(0xa62)[_0x206a59(0x222)](_0x34a3f2,TextManager[_0x206a59(0x3c7)]),_0x3159e2=this['isItemCommandEnabled']();this[_0x206a59(0x93b)](_0x5098c8,_0x206a59(0x3c7),_0x3159e2);},Window_ActorCommand[_0xfd5ed1(0x263)][_0xfd5ed1(0x563)]=function(){const _0x179a8c=_0xfd5ed1;return this[_0x179a8c(0x4b9)]&&this[_0x179a8c(0x4b9)][_0x179a8c(0xb91)]();},Window_ActorCommand[_0xfd5ed1(0x263)][_0xfd5ed1(0x9e5)]=function(){const _0x5e132a=_0xfd5ed1,_0x2424e9=this['_actor'][_0x5e132a(0x7ba)]();for(const _0x217ab4 of _0x2424e9){this['addSkillTypeCommand'](_0x217ab4);}},Window_ActorCommand['prototype'][_0xfd5ed1(0x3e4)]=function(_0xd3afed){const _0x57a3e0=_0xfd5ed1;let _0x35ec29=$dataSystem[_0x57a3e0(0x7ba)][_0xd3afed];if(!_0x35ec29)return;let _0x32599=_0x35ec29;const _0x50208c=this[_0x57a3e0(0x7a1)]();if(_0x50208c==='text'){if('QxzvU'!==_0x57a3e0(0x83a)){this[_0x57a3e0(0x2a4)]=_0x164e95;const _0x3e8174=this[_0x57a3e0(0x452)](),_0x3ae22b=this['bitmapWidth'](),_0x4e9071=_0xaa0599[_0x57a3e0(0x263)][_0x57a3e0(0x9c1)]();this[_0x57a3e0(0x78b)](),this[_0x57a3e0(0x86e)][_0x57a3e0(0x3d1)](),this[_0x57a3e0(0x86e)]['drawText'](_0x3e8174,0x0,0x0,_0x3ae22b,_0x4e9071,'center');}else _0x32599=_0x32599[_0x57a3e0(0x797)](/\x1I\[(\d+)\]/gi,''),_0x32599=_0x32599[_0x57a3e0(0x797)](/\\I\[(\d+)\]/gi,'');}else{if(!_0x35ec29[_0x57a3e0(0x9e4)](/\\I\[(\d+)\]/i)){const _0x3e0b57=Imported['VisuMZ_1_SkillsStatesCore']?VisuMZ[_0x57a3e0(0x753)]['Settings'][_0x57a3e0(0x936)]:VisuMZ['BattleCore']['Settings'][_0x57a3e0(0xade)],_0x143bd5=$dataSystem[_0x57a3e0(0x616)][_0x57a3e0(0x4b6)](_0xd3afed),_0x1542f8=_0x143bd5?_0x3e0b57[_0x57a3e0(0x980)]:_0x3e0b57[_0x57a3e0(0xbc1)];_0x32599=_0x57a3e0(0xa62)['format'](_0x1542f8,_0x35ec29);}}this['addCommand'](_0x32599,_0x57a3e0(0x746),!![],_0xd3afed);},Window_ActorCommand[_0xfd5ed1(0x263)][_0xfd5ed1(0x651)]=function(){const _0x281867=_0xfd5ed1,_0xadada8=this[_0x281867(0x4b9)][_0x281867(0x7ba)](),_0x51c9c2=this[_0x281867(0x4b9)][_0x281867(0x4d6)]();for(const _0x1a96a0 of _0x51c9c2){if(!_0x1a96a0)continue;if(Imported[_0x281867(0xa7d)]){if(this[_0x281867(0x4e5)](_0x1a96a0))continue;if(this['isHiddenSkill'](_0x1a96a0))continue;}else{if(!_0xadada8[_0x281867(0x4b6)](_0x1a96a0['stypeId']))continue;}this['addSingleSkillCommand'](_0x1a96a0);}},Window_ActorCommand[_0xfd5ed1(0x263)][_0xfd5ed1(0x4e5)]=function(_0x4d6635){const _0x27bb91=_0xfd5ed1,_0x41a644=this[_0x27bb91(0x4b9)][_0x27bb91(0x7ba)](),_0x104873=_0x41a644[_0x27bb91(0x4af)](_0x8ccd39=>DataManager[_0x27bb91(0x44d)](_0x4d6635)[_0x27bb91(0x4b6)](_0x8ccd39));return _0x104873['length']<=0x0;},Window_ActorCommand['prototype'][_0xfd5ed1(0x7ad)]=function(_0x24272e){const _0xc233fa=_0xfd5ed1;if(!Window_SkillList[_0xc233fa(0x263)][_0xc233fa(0x1c6)]['call'](this,_0x24272e))return!![];if(!Window_SkillList[_0xc233fa(0x263)][_0xc233fa(0x2ee)]['call'](this,_0x24272e))return!![];if(!Window_SkillList['prototype'][_0xc233fa(0xbe0)][_0xc233fa(0x740)](this,_0x24272e))return!![];return![];},Window_ActorCommand['prototype'][_0xfd5ed1(0x334)]=function(_0x1f042a){const _0x4fb51d=_0xfd5ed1;if(!_0x1f042a)return;if(!this[_0x4fb51d(0xbbc)](_0x1f042a))return;const _0xb83687=this[_0x4fb51d(0x7a1)](),_0x1f9ac6=DataManager['battleCommandName'](_0x1f042a),_0x25d036=DataManager['battleCommandIcon'](_0x1f042a),_0x1aafd6=_0xb83687===_0x4fb51d(0x7e7)?_0x1f9ac6:_0x4fb51d(0xa62)['format'](_0x25d036,_0x1f9ac6),_0x49a791=this[_0x4fb51d(0x4b9)][_0x4fb51d(0x5ee)](_0x1f042a);this[_0x4fb51d(0x93b)](_0x1aafd6,_0x4fb51d(0x9e3),_0x49a791,_0x1f042a['id']);},Window_ActorCommand[_0xfd5ed1(0x263)]['canAddSkillCommand']=function(_0x2f7ce1){const _0x4e9875=_0xfd5ed1,_0x4a30d0=_0x2f7ce1[_0x4e9875(0x80f)];if(_0x4a30d0[_0x4e9875(0x9e4)](/<COMMAND REQUIRE LEARN>/i)){if(_0x4e9875(0x89b)!==_0x4e9875(0x89b)){const _0x2c2636=_0x15435e[_0x4e9875(0x3c7)]();this['displayAction'](_0x5e53b3,_0x2c2636),this[_0x4e9875(0xbc8)](_0x4e9875(0x714),_0x408d4c,_0x3cd427,!![]),this[_0x4e9875(0xbc8)](_0x4e9875(0x537),_0x5be949,_0x599027),this['push']('waitForMovement'),this[_0x4e9875(0xbc8)]('performCastAnimation',_0x3cc257,_0x21c0cd),this[_0x4e9875(0xbc8)](_0x4e9875(0x8ea));}else{if(!this[_0x4e9875(0x4b9)]['isLearnedSkill'](_0x2f7ce1['id']))return![];}}if(_0x4a30d0['match'](/<COMMAND REQUIRE ACCESS>/i)){if(!this['_actor'][_0x4e9875(0x8f4)](_0x2f7ce1['id']))return![];}const _0x49d6ae=VisuMZ[_0x4e9875(0x1e9)]['createKeyJS'](_0x2f7ce1,_0x4e9875(0x1c3));if(VisuMZ[_0x4e9875(0x1e9)]['JS'][_0x49d6ae]){if(_0x4e9875(0x4ce)==='EytUH'){if(!VisuMZ[_0x4e9875(0x1e9)]['JS'][_0x49d6ae][_0x4e9875(0x740)](this,this[_0x4e9875(0x4b9)],_0x2f7ce1))return![];}else _0x3e2cac[_0x4e9875(0x45b)]();}return VisuMZ[_0x4e9875(0x1e9)][_0x4e9875(0xabb)](_0x2f7ce1);},VisuMZ['BattleCore']['CheckSkillCommandShowSwitches']=function(_0x4726d1){const _0xce1e5b=_0xfd5ed1,_0x3ed41e=_0x4726d1[_0xce1e5b(0x80f)];if(_0x3ed41e[_0xce1e5b(0x9e4)](/<COMMAND SHOW[ ](?:SW|SWITCH|SWITCHES):[ ]*(\d+(?:\s*,\s*\d+)*)>/i)){if('KdVsy'!==_0xce1e5b(0x3c6)){const _0x1a47e4=JSON[_0xce1e5b(0x243)]('['+RegExp['$1'][_0xce1e5b(0x9e4)](/\d+/g)+']');for(const _0x10fa2d of _0x1a47e4){if(!$gameSwitches['value'](_0x10fa2d))return![];}return!![];}else!this['updateEventMain']()&&!this[_0xce1e5b(0x901)][_0xce1e5b(0x32f)]()&&(this[_0xce1e5b(0x38d)]=_0xce1e5b(0x7f5));}if(_0x3ed41e[_0xce1e5b(0x9e4)](/<COMMAND SHOW ALL[ ](?:SW|SWITCH|SWITCHES):[ ]*(\d+(?:\s*,\s*\d+)*)>/i)){if(_0xce1e5b(0x39b)===_0xce1e5b(0x39b)){const _0x286c65=JSON[_0xce1e5b(0x243)]('['+RegExp['$1'][_0xce1e5b(0x9e4)](/\d+/g)+']');for(const _0x4dcc73 of _0x286c65){if(!$gameSwitches['value'](_0x4dcc73))return![];}return!![];}else _0x48f35f+=_0x737702[_0xce1e5b(0xbdf)][_0xce1e5b(0x1cc)]||0x0,_0x13a2fb+=_0x322b33[_0xce1e5b(0xbdf)][_0xce1e5b(0x5e2)]||0x0;}if(_0x3ed41e[_0xce1e5b(0x9e4)](/<COMMAND SHOW ANY[ ](?:SW|SWITCH|SWITCHES):[ ]*(\d+(?:\s*,\s*\d+)*)>/i)){if(_0xce1e5b(0xa47)===_0xce1e5b(0x440))this['_shadowSprite'][_0xce1e5b(0x914)](0x0,0x0,0x0,0x0);else{const _0x4b080e=JSON[_0xce1e5b(0x243)]('['+RegExp['$1']['match'](/\d+/g)+']');for(const _0x454f42 of _0x4b080e){if($gameSwitches['value'](_0x454f42))return!![];}return![];}}if(_0x3ed41e[_0xce1e5b(0x9e4)](/<COMMAND HIDE[ ](?:SW|SWITCH|SWITCHES):[ ]*(\d+(?:\s*,\s*\d+)*)>/i)){if('dylxl'!==_0xce1e5b(0x61f)){const _0x230f5a=JSON['parse']('['+RegExp['$1'][_0xce1e5b(0x9e4)](/\d+/g)+']');for(const _0x2adc26 of _0x230f5a){if(!$gameSwitches[_0xce1e5b(0x59a)](_0x2adc26))return!![];}return![];}else{if(!_0x515108)return;if(!this[_0xce1e5b(0xa67)])return;if(_0x4f81e5[_0xce1e5b(0x75b)]()){}else{if(_0x40175f['isEnemy']()){if(this['constructor']===_0xd8dcec&&!_0x26f7b4['hasSvBattler']())return;}}this['_hpGaugeSprite'][_0xce1e5b(0xba7)](_0x3ffa60,'hp');}}if(_0x3ed41e[_0xce1e5b(0x9e4)](/<COMMAND HIDE ALL[ ](?:SW|SWITCH|SWITCHES):[ ]*(\d+(?:\s*,\s*\d+)*)>/i)){const _0xd28568=JSON[_0xce1e5b(0x243)]('['+RegExp['$1'][_0xce1e5b(0x9e4)](/\d+/g)+']');for(const _0xfef2e5 of _0xd28568){if(!$gameSwitches[_0xce1e5b(0x59a)](_0xfef2e5))return!![];}return![];}if(_0x3ed41e[_0xce1e5b(0x9e4)](/<COMMAND HIDE ANY[ ](?:SW|SWITCH|SWITCHES):[ ]*(\d+(?:\s*,\s*\d+)*)>/i)){const _0x2f60d0=JSON[_0xce1e5b(0x243)]('['+RegExp['$1'][_0xce1e5b(0x9e4)](/\d+/g)+']');for(const _0x549506 of _0x2f60d0){if($gameSwitches[_0xce1e5b(0x59a)](_0x549506))return![];}return!![];}return!![];},Window_ActorCommand[_0xfd5ed1(0x263)][_0xfd5ed1(0x3a9)]=function(){const _0x1578a0=_0xfd5ed1,_0x4a9cbd=this[_0x1578a0(0x7a1)](),_0x866726=VisuMZ[_0x1578a0(0x1e9)]['Settings']['PartyCmd']['CmdIconEscape'],_0xbdb626=_0x4a9cbd==='text'?TextManager[_0x1578a0(0x877)]:'\x5cI[%1]%2'['format'](_0x866726,TextManager['escape']),_0x54a5cc=this[_0x1578a0(0x259)]();this['addCommand'](_0xbdb626,_0x1578a0(0x877),_0x54a5cc);},Window_ActorCommand[_0xfd5ed1(0x263)][_0xfd5ed1(0x259)]=function(){const _0x5d44a2=_0xfd5ed1;return BattleManager[_0x5d44a2(0x7f2)]();},Window_ActorCommand[_0xfd5ed1(0x263)]['addAutoBattleCommand']=function(){const _0x5a8d1f=_0xfd5ed1,_0x56e9bc=this['commandStyle'](),_0x29d5be=VisuMZ[_0x5a8d1f(0x1e9)][_0x5a8d1f(0x607)][_0x5a8d1f(0x56b)]['CmdIconAutoBattle'],_0x2c7b7a=_0x56e9bc===_0x5a8d1f(0x7e7)?TextManager[_0x5a8d1f(0x251)]:_0x5a8d1f(0xa62)[_0x5a8d1f(0x222)](_0x29d5be,TextManager[_0x5a8d1f(0x251)]),_0x1a8867=this[_0x5a8d1f(0x5ad)]();this[_0x5a8d1f(0x93b)](_0x2c7b7a,'autoBattle',_0x1a8867);},Window_ActorCommand[_0xfd5ed1(0x263)]['isAutoBattleCommandEnabled']=function(){return!![];},Window_ActorCommand[_0xfd5ed1(0x263)][_0xfd5ed1(0x4ed)]=function(){const _0x34d3a5=_0xfd5ed1;return VisuMZ[_0x34d3a5(0x1e9)][_0x34d3a5(0x607)][_0x34d3a5(0xade)][_0x34d3a5(0x887)];},Window_ActorCommand[_0xfd5ed1(0x263)][_0xfd5ed1(0x20d)]=function(_0x148402){const _0x1464de=_0xfd5ed1,_0x2c4e93=this[_0x1464de(0x98f)](_0x148402);if(_0x2c4e93===_0x1464de(0x9c6))this[_0x1464de(0x857)](_0x148402);else{if(_0x2c4e93==='icon'){if(_0x1464de(0xbd8)!=='AByeZ'){let _0x14c076=_0x20c433(_0x259ec8['$1'])[_0x1464de(0x797)](/,/g,'')[_0x1464de(0xa50)]()[_0x1464de(0x300)]();_0x110373[_0x1464de(0x1e9)][_0x1464de(0x21a)][_0x14c076]=_0x2487c7['id'];}else this[_0x1464de(0x5af)](_0x148402);}else{if('sTqZK'!==_0x1464de(0xa0f))return _0x27b4fc[_0x1464de(0x4ea)]()[_0x1464de(0x6cc)]()['filter'](_0x2922c1=>_0x2922c1!==_0x20ab57);else Window_Command[_0x1464de(0x263)][_0x1464de(0x20d)][_0x1464de(0x740)](this,_0x148402);}}this['drawSingleSkillCost'](_0x148402);},Window_ActorCommand[_0xfd5ed1(0x263)]['commandStyle']=function(){const _0xc82c16=_0xfd5ed1;return VisuMZ['BattleCore'][_0xc82c16(0x607)][_0xc82c16(0xade)][_0xc82c16(0xa31)];},Window_ActorCommand[_0xfd5ed1(0x263)][_0xfd5ed1(0x98f)]=function(_0x942672){const _0x133eef=_0xfd5ed1;if(_0x942672<0x0)return _0x133eef(0x7e7);const _0x58eecb=this['commandStyle']();if(_0x58eecb!=='auto')return _0x58eecb;else{if(this[_0x133eef(0x5b6)]()>0x0){const _0x27acd2=this[_0x133eef(0xb43)](_0x942672);if(_0x27acd2[_0x133eef(0x9e4)](/\\I\[(\d+)\]/i)){if(_0x133eef(0x77b)===_0x133eef(0x77b)){const _0x2743cc=this[_0x133eef(0x2ef)](_0x942672),_0x2f99ec=this[_0x133eef(0x22a)](_0x27acd2)[_0x133eef(0xb4a)];if(_0x2f99ec<=_0x2743cc['width']){if('nQQbF'==='BHDBU')_0x4ea910[_0x133eef(0x1e9)][_0x133eef(0xb2c)][_0x133eef(0x740)](this),this[_0x133eef(0xa91)]();else return'iconText';}else return _0x133eef(0x9ec);}else this[_0x133eef(0x720)](_0x40bc82),this['showHelpWindow']();}}}return _0x133eef(0x7e7);},Window_ActorCommand[_0xfd5ed1(0x263)][_0xfd5ed1(0x857)]=function(_0x3e507d){const _0x277203=_0xfd5ed1,_0x2eb75f=this[_0x277203(0x2ef)](_0x3e507d),_0x1e86d0=this[_0x277203(0xb43)](_0x3e507d),_0x46c55=this[_0x277203(0x22a)](_0x1e86d0)[_0x277203(0xb4a)];this[_0x277203(0x649)](this['isCommandEnabled'](_0x3e507d));const _0x9911c0=this['itemTextAlign']();if(_0x9911c0===_0x277203(0xa9b))this[_0x277203(0x4bf)](_0x1e86d0,_0x2eb75f['x']+_0x2eb75f[_0x277203(0xb4a)]-_0x46c55,_0x2eb75f['y'],_0x46c55);else{if(_0x9911c0===_0x277203(0x4aa)){const _0x11fbbe=_0x2eb75f['x']+Math['floor']((_0x2eb75f[_0x277203(0xb4a)]-_0x46c55)/0x2);this[_0x277203(0x4bf)](_0x1e86d0,_0x11fbbe,_0x2eb75f['y'],_0x46c55);}else this[_0x277203(0x4bf)](_0x1e86d0,_0x2eb75f['x'],_0x2eb75f['y'],_0x46c55);}},Window_ActorCommand['prototype'][_0xfd5ed1(0x5af)]=function(_0x3362e7){const _0x4fddbb=_0xfd5ed1;this['commandName'](_0x3362e7)[_0x4fddbb(0x9e4)](/\\I\[(\d+)\]/i);const _0x3cdef1=Number(RegExp['$1'])||0x0,_0x51df8a=this[_0x4fddbb(0x2ef)](_0x3362e7),_0x3fe28a=_0x51df8a['x']+Math[_0x4fddbb(0x765)]((_0x51df8a['width']-ImageManager['iconWidth'])/0x2),_0x20d068=_0x51df8a['y']+(_0x51df8a['height']-ImageManager[_0x4fddbb(0x581)])/0x2;this[_0x4fddbb(0x267)](_0x3cdef1,_0x3fe28a,_0x20d068);},Window_ActorCommand[_0xfd5ed1(0x263)][_0xfd5ed1(0x564)]=function(_0x5b9b8d){const _0x5163cb=_0xfd5ed1;if(!(VisuMZ[_0x5163cb(0x1e9)]['Settings'][_0x5163cb(0xade)]['ShowCosts']??!![]))return;const _0x226ebd=this[_0x5163cb(0x94d)](_0x5b9b8d);if(![_0x5163cb(0x8c1),_0x5163cb(0xa24),_0x5163cb(0x9e3)][_0x5163cb(0x4b6)](_0x226ebd))return;const _0x530b88=this['itemLineRect'](_0x5b9b8d);let _0x706e4e=null;if(_0x226ebd===_0x5163cb(0x8c1)){if('Stprn'!=='PwEMy')_0x706e4e=$dataSkills[this['_actor'][_0x5163cb(0x6a1)]()];else{if(!_0x10952c)return![];if(!_0x1fd6e6[_0x5163cb(0x566)])return![];if(_0x1cd002['_animation'][_0x5163cb(0x7de)]!==0x0)return![];if(!_0x2998ac['targetObjects'][0x0])return![];if(_0x270d24[_0x5163cb(0x888)][0x0][_0x5163cb(0x75b)]&&!_0x1dff81[_0x5163cb(0x888)][0x0][_0x5163cb(0x75b)]())return![];if(_0x527b6a['isSideView']())return![];if(!this[_0x5163cb(0xae2)]())return![];const _0x3dfc0f=_0x404ed4['prototype'][_0x5163cb(0xb2d)]();return[_0x5163cb(0x1fe),'xp'][_0x5163cb(0x27e)](_0x3dfc0f);}}else _0x226ebd===_0x5163cb(0xa24)?_0x5163cb(0x74d)===_0x5163cb(0xa79)?this[_0x5163cb(0x4f6)]():_0x706e4e=$dataSkills[this[_0x5163cb(0x4b9)][_0x5163cb(0x361)]()]:'mugEa'!==_0x5163cb(0x3ca)?this[_0x5163cb(0xb41)][_0x5163cb(0x840)]():_0x706e4e=$dataSkills[this[_0x5163cb(0x5fe)][_0x5b9b8d]['ext']];this[_0x5163cb(0x583)](this[_0x5163cb(0x4b9)],_0x706e4e,_0x530b88['x'],_0x530b88['y'],_0x530b88[_0x5163cb(0xb4a)]);},Window_ActorCommand['prototype'][_0xfd5ed1(0x583)]=function(_0x242b02,_0x23c7f5,_0x21075f,_0x5d8a18,_0x3a0368){const _0x4f3386=_0xfd5ed1;if(!_0x23c7f5)return;if(Imported['VisuMZ_1_SkillsStatesCore'])Window_Command[_0x4f3386(0x263)][_0x4f3386(0x583)]['call'](this,_0x242b02,_0x23c7f5,_0x21075f,_0x5d8a18,_0x3a0368);else{if(_0x4f3386(0x33a)!==_0x4f3386(0x33a)){const _0x1679aa=_0x34ccbb[_0x4f3386(0x1e9)]['Settings'][_0x4f3386(0x9bf)],_0x3dd0da=_0x1679aa[_0x4f3386(0x817)]||0xc0,_0x2f5701=this[_0x4f3386(0x477)](),_0x2eea5e=this['isRightInputMode']()?_0x237bfb['boxWidth']-_0x3dd0da:0x0,_0x1666ea=_0x4d673b[_0x4f3386(0xa52)]-_0x2f5701;return new _0x4ada51(_0x2eea5e,_0x1666ea,_0x3dd0da,_0x2f5701);}else Window_SkillList[_0x4f3386(0x263)]['drawSkillCost'][_0x4f3386(0x740)](this,_0x23c7f5,_0x21075f,_0x5d8a18,_0x3a0368);}},Window_ActorCommand[_0xfd5ed1(0x263)][_0xfd5ed1(0x213)]=function(){},Window_ActorCommand[_0xfd5ed1(0x263)]['activate']=function(){const _0x598321=_0xfd5ed1;Window_Command[_0x598321(0x263)]['activate'][_0x598321(0x740)](this);const _0x2ff33c=this[_0x598321(0xb2d)]();_0x2ff33c===_0x598321(0x9cf)&&(_0x598321(0x880)===_0x598321(0x880)?this['showHelpWindow']():_0x63a03b[_0x598321(0xbdf)]['SmoothImage']=![]);},Window_ActorCommand[_0xfd5ed1(0x263)][_0xfd5ed1(0xb2d)]=function(){const _0x48ad33=_0xfd5ed1;if(this[_0x48ad33(0x534)])return this[_0x48ad33(0x534)];return this[_0x48ad33(0x534)]=SceneManager['_scene']['battleLayoutStyle'](),this[_0x48ad33(0x534)];},VisuMZ[_0xfd5ed1(0x1e9)][_0xfd5ed1(0x61d)]=Window_ActorCommand['prototype']['setup'],Window_ActorCommand[_0xfd5ed1(0x263)][_0xfd5ed1(0xba7)]=function(_0x3f026c){const _0x5a32cd=_0xfd5ed1,_0x3adaa8=this[_0x5a32cd(0xb2d)]();if(_0x3f026c&&['xp','portrait'][_0x5a32cd(0x4b6)](_0x3adaa8))_0x5a32cd(0x568)===_0x5a32cd(0x568)?this['resizeWindowXPStyle'](_0x3f026c):this[_0x5a32cd(0x5af)](_0x245e74);else _0x3f026c&&[_0x5a32cd(0x9cf)][_0x5a32cd(0x4b6)](_0x3adaa8)&&(this[_0x5a32cd(0x720)](_0x3f026c),this[_0x5a32cd(0xa3a)]());VisuMZ[_0x5a32cd(0x1e9)][_0x5a32cd(0x61d)][_0x5a32cd(0x740)](this,_0x3f026c),_0x3f026c&&$gameTroop[_0x5a32cd(0x6cc)]()[_0x5a32cd(0x5b7)]>0x0&&_0x3f026c[_0x5a32cd(0x456)]()&&('xymxx'!==_0x5a32cd(0xbb4)?this['selectNextCommand']():_0x3f026c[_0x5a32cd(0x456)]()[_0x5a32cd(0x8a4)]());},Window_ActorCommand[_0xfd5ed1(0x263)][_0xfd5ed1(0x8ae)]=function(_0x32e81f){const _0x9d2953=_0xfd5ed1,_0x70e20d=Math[_0x9d2953(0x271)](Graphics[_0x9d2953(0x9c4)]/0x3),_0x3c6afa=Math['round'](Graphics[_0x9d2953(0x9c4)]/$gameParty[_0x9d2953(0x6d2)]()[_0x9d2953(0x5b7)]),_0x4d7061=Math[_0x9d2953(0x942)](_0x70e20d,_0x3c6afa),_0x34416